/**
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * Copyright 2012-2015 the original author or authors.
 */
/**
 * 
 */
package org.assertj.core.extractor;

import org.assertj.core.api.iterable.Extractor;

/**
 * Extracts {@link Object#toString()} from any object
 * 
 * @author Mateusz Haligowski
 *
 */
public class ToStringExtractor implements Extractor<Object, String> {
  @Override
  public String extract(Object input) {
    return input.toString();
  }
  
  ToStringExtractor() {
    
  }

}
