#!/bin/bash

# Generates the documentation from the sources with Doxygen.
# These documents are not really useful per se, but the generation
# process helps detecting missing or invalid documentation.

PROJECT=acm

if [ ! -d src ]; then
	echo "$0: ERROR: this script must be started from the root directory of the project." >&2
	exit 1
fi

# Doxygen program:
DOXYGEN=doxygen

# Docs dest dir:
HTML_OUTPUT=doc/doxygen-html

# Create the Doxygen config file:
CONFIG=build-doxygen-docs-cfg.txt
{
	echo "# This file was generated by the $0 script"
	echo "PROJECT_NAME=$PROJECT"
	echo "JAVADOC_AUTOBRIEF=YES"
	echo "QUIET=YES"
	echo "WARN_NO_PARAMDOC=YES"
	echo "INPUT=src"
	echo "RECURSIVE=YES"
	echo "EXCLUDE_SYMBOLS=EXTERN"
	echo "EXCLUDE_SYMLINKS=YES"
	echo "STRIP_CODE_COMMENTS=NO"
	echo "REFERENCED_BY_RELATION=YES"
	echo "HTML_OUTPUT=$HTML_OUTPUT"
	echo "DOCSET_PUBLISHER_ID=it.icosaedro"
	echo "DOCSET_PUBLISHER_NAME=icosaedro.it di Umberto Salsi"
	echo "SEARCHENGINE=NO"
	echo "GENERATE_LATEX=NO"
} > $CONFIG

# Errors log file:
ERRORS=build-doxygen-docs-errors.txt

rm -f -r $HTML_OUTPUT

$DOXYGEN $CONFIG 2> $ERRORS

rm $CONFIG

if [ -d $HTML_OUTPUT ]; then
	echo "Generated documents available under: $HTML_OUTPUT/index.html"
fi

if [ -s "$ERRORS" ]; then
	echo "ERROR: see $ERRORS for details"
	sort $ERRORS > new-$ERRORS
	mv new-$ERRORS $ERRORS
else
	rm -f $ERRORS
	echo "Doxygen documents generated successfully."
fi

# THE END
