#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 Igor Telmenko
set -o errexit

###
# Syberia series:
# - Syberia 1
# - Syberia 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20250227.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID_SYBERIA1='syberia-1'
GAME_NAME_SYBERIA1='Syberia'

GAME_ID_SYBERIA2='syberia-2'
GAME_NAME_SYBERIA2='Syberia Ⅱ'

# Archives

## Syberia 1

ARCHIVE_BASE_SYBERIA1_RU_2_NAME='setup_syberia_1.0.0_hotfix4_(russian)_(53936).exe'
ARCHIVE_BASE_SYBERIA1_RU_2_MD5='98308bdd7980d5d2804fed458816296c'
ARCHIVE_BASE_SYBERIA1_RU_2_TYPE='innosetup'
ARCHIVE_BASE_SYBERIA1_RU_2_PART1_NAME='setup_syberia_1.0.0_hotfix4_(russian)_(53936)-1.bin'
ARCHIVE_BASE_SYBERIA1_RU_2_PART1_MD5='79a2c6f522d812a034f263dea9ae1fa3'
ARCHIVE_BASE_SYBERIA1_RU_2_SIZE='1600000'
ARCHIVE_BASE_SYBERIA1_RU_2_VERSION='1.0.0-gog53936'
ARCHIVE_BASE_SYBERIA1_RU_2_URL='https://www.gog.com/game/syberia'

ARCHIVE_BASE_SYBERIA1_EN_2_NAME='setup_syberia_1.0.0_hotfix4_(53936).exe'
ARCHIVE_BASE_SYBERIA1_EN_2_MD5='d2a928c368926e6b5acb0007e86292c0'
ARCHIVE_BASE_SYBERIA1_EN_2_TYPE='innosetup'
ARCHIVE_BASE_SYBERIA1_EN_2_PART1_NAME='setup_syberia_1.0.0_hotfix4_(53936)-1.bin'
ARCHIVE_BASE_SYBERIA1_EN_2_PART1_MD5='20a068f18d692deddf517bd5def14903'
ARCHIVE_BASE_SYBERIA1_EN_2_SIZE='1600000'
ARCHIVE_BASE_SYBERIA1_EN_2_VERSION='1.0.0-gog53936'
ARCHIVE_BASE_SYBERIA1_EN_2_URL='https://www.gog.com/game/syberia'

ARCHIVE_BASE_SYBERIA1_FR_2_NAME='setup_syberia_1.0.0_hotfix4_(french)_(53936).exe'
ARCHIVE_BASE_SYBERIA1_FR_2_MD5='d4f6fb1f650a6e82b4456c2c1e2e2b8d'
ARCHIVE_BASE_SYBERIA1_FR_2_TYPE='innosetup'
ARCHIVE_BASE_SYBERIA1_FR_2_PART1_NAME='setup_syberia_1.0.0_hotfix4_(french)_(53936)-1.bin'
ARCHIVE_BASE_SYBERIA1_FR_2_PART1_MD5='b8544dbc5ea5d125b224a8a1008913a7'
ARCHIVE_BASE_SYBERIA1_FR_2_SIZE='1600000'
ARCHIVE_BASE_SYBERIA1_FR_2_VERSION='1.0.0-gog53936'
ARCHIVE_BASE_SYBERIA1_FR_2_URL='https://www.gog.com/game/syberia'

ARCHIVE_BASE_SYBERIA1_RU_1_NAME='setup_syberia_russian_1.0.0_hotfix3_(18946).exe'
ARCHIVE_BASE_SYBERIA1_RU_1_MD5='cdf5ac1869d57d139495a20102d5ffb4'
ARCHIVE_BASE_SYBERIA1_RU_1_TYPE='innosetup'
ARCHIVE_BASE_SYBERIA1_RU_1_SIZE='1600000'
ARCHIVE_BASE_SYBERIA1_RU_1_VERSION='1.0.0-gog18946'

ARCHIVE_BASE_SYBERIA1_EN_1_NAME='setup_syberia_1.0.0_hotfix3_(18946).exe'
ARCHIVE_BASE_SYBERIA1_EN_1_MD5='53d91df35a154584812d31b9ee353cb8'
ARCHIVE_BASE_SYBERIA1_EN_1_TYPE='innosetup'
ARCHIVE_BASE_SYBERIA1_EN_1_SIZE='1600000'
ARCHIVE_BASE_SYBERIA1_EN_1_VERSION='1.0.0-gog18946'

ARCHIVE_BASE_SYBERIA1_FR_1_NAME='setup_syberia_french_1.0.0_hotfix3_(18946).exe'
ARCHIVE_BASE_SYBERIA1_FR_1_MD5='41881248eefd53929bbaa97c1905a7fe'
ARCHIVE_BASE_SYBERIA1_FR_1_TYPE='innosetup'
ARCHIVE_BASE_SYBERIA1_FR_1_SIZE='1600000'
ARCHIVE_BASE_SYBERIA1_FR_1_VERSION='1.0.0-gog18946'

ARCHIVE_BASE_SYBERIA1_EN_0_NAME='setup_syberia_1.0.0_hotfix2_(17897).exe'
ARCHIVE_BASE_SYBERIA1_EN_0_MD5='d52b7a776df7659d7fda9995715468a0'
ARCHIVE_BASE_SYBERIA1_EN_0_TYPE='innosetup'
ARCHIVE_BASE_SYBERIA1_EN_0_SIZE='1600000'
ARCHIVE_BASE_SYBERIA1_EN_0_VERSION='1.0.0-gog17897'

ARCHIVE_BASE_SYBERIA1_FR_0_NAME='setup_syberia_french_1.0.0_hotfix2_(17897).exe'
ARCHIVE_BASE_SYBERIA1_FR_0_MD5='d8a956a47c1b186a4364eff56c8cecb6'
ARCHIVE_BASE_SYBERIA1_FR_0_TYPE='innosetup'
ARCHIVE_BASE_SYBERIA1_FR_0_SIZE='1600000'
ARCHIVE_BASE_SYBERIA1_FR_0_VERSION='1.0.0-gog17897'

# Syberia 2

ARCHIVE_BASE_SYBERIA2_EN_0_NAME='setup_syberia_2_20171109_(16283).exe'
ARCHIVE_BASE_SYBERIA2_EN_0_MD5='f33e25fa29810e9ff8c6f009b7fdec3b'
ARCHIVE_BASE_SYBERIA2_EN_0_TYPE='innosetup'
ARCHIVE_BASE_SYBERIA2_EN_0_SIZE='1600000'
ARCHIVE_BASE_SYBERIA2_EN_0_VERSION='1.0-gog16283'
ARCHIVE_BASE_SYBERIA2_EN_0_URL='https://www.gog.com/game/syberia_2'

ARCHIVE_BASE_SYBERIA2_FR_0_NAME='setup_syberia_2_french_20171109_(16283).exe'
ARCHIVE_BASE_SYBERIA2_FR_0_MD5='e53a1ad01440837b933e935522389ab8'
ARCHIVE_BASE_SYBERIA2_FR_0_TYPE='innosetup'
ARCHIVE_BASE_SYBERIA2_FR_0_SIZE='1600000'
ARCHIVE_BASE_SYBERIA2_FR_0_VERSION='1.0-gog16283'
ARCHIVE_BASE_SYBERIA2_FR_0_URL='https://www.gog.com/game/syberia_2'

# Archives content

CONTENT_GAME_BIN_FILES='
dlls
binkw32.dll
ck2.dll
ckzlib.dll
dvd.dll
vxmath.dll
game.exe
syberia.exe
syberia2.exe
launch/settings.ini'
CONTENT_GAME_DATA_FILES='
cmo
data
textures
video'
CONTENT_DOC_L10N_FILES='
manual.pdf
walkthrough.pdf
readme.txt'

## Syberia 1

CONTENT_PATH_DEFAULT_SYBERIA1='.'
CONTENT_PATH_DEFAULT_SYBERIA1_EN_1='app'
CONTENT_PATH_DEFAULT_SYBERIA1_FR_1='app'
CONTENT_PATH_DEFAULT_SYBERIA1_RU_1='app'
CONTENT_PATH_DEFAULT_SYBERIA1_EN_0='app'
CONTENT_PATH_DEFAULT_SYBERIA1_FR_0='app'
CONTENT_GAME_L10N_FILES_SYBERIA1='
sounds
splash
cmo/citstation.cmo
cmo/valreceptioninn.cmo
data/font_syberia?.dat
data/string.dat
data/animations/momo/mo_tcheque.nmo
video/an
video/*_hansanna.syb
video/*_hansannab.syb
video/c1_intro.syb
textures/ingame
textures/valreceptioninn'

## Syberia 2

CONTENT_PATH_DEFAULT_SYBERIA2='app'
CONTENT_GAME_L10N_FILES_SYBERIA2='
data/minimalres.syb
data/string.dat'


USER_PERSISTENT_FILES='
*.ini'

WINE_PERSISTENT_DIRECTORIES_SYBERIA1='
users/${USER}/Documents/Syberia Saves'
WINE_PERSISTENT_DIRECTORIES_SYBERIA2='
users/${USER}/Documents/Syberia 2 Saves'
WINE_VIRTUAL_DESKTOP='auto'

APP_MAIN_EXE='game.exe'
APP_MAIN_ICON_SYBERIA1='syberia.exe'
APP_MAIN_ICON_SYBERIA2='syberia2.exe'

# Packages

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'

## Syberia 1

## Ensure easy upgrade from packages generated with pre-20210716.5 game script.
PKG_BIN_PROVIDES_SYBERIA1="${PKG_BIN_PROVIDES_SYBERIA1:-}
syberia"

PKG_L10N_BASE_ID_SYBERIA1="${GAME_ID_SYBERIA1}-l10n"
PKG_L10N_ID_SYBERIA1_RU="${PKG_L10N_BASE_ID_SYBERIA1}-ru"
PKG_L10N_ID_SYBERIA1_EN="${PKG_L10N_BASE_ID_SYBERIA1}-en"
PKG_L10N_ID_SYBERIA1_FR="${PKG_L10N_BASE_ID_SYBERIA1}-fr"
PKG_L10N_DESCRIPTION_SYBERIA1_RU='Russian localization'
PKG_L10N_DESCRIPTION_SYBERIA1_EN='English localization'
PKG_L10N_DESCRIPTION_SYBERIA1_FR='French localization'
PKG_L10N_PROVIDES_SYBERIA1="
$PKG_L10N_BASE_ID_SYBERIA1"
## Ensure easy upgrade from packages generated with pre-20210716.5 game script.
PKG_L10N_PROVIDES_SYBERIA1="${PKG_L10N_PROVIDES_SYBERIA1:-}
syberia-l10n"

PKG_DATA_ID_SYBERIA1="${GAME_ID_SYBERIA1}-data"
## Ensure easy upgrade from packages generated with pre-20210716.5 game script.
PKG_DATA_PROVIDES_SYBERIA1="${PKG_DATA_PROVIDES_SYBERIA1:-}
syberia-data"

## Syberia 2

PKG_L10N_BASE_ID_SYBERIA2="${GAME_ID_SYBERIA2}-l10n"
PKG_L10N_ID_SYBERIA2_EN="${PKG_L10N_BASE_ID_SYBERIA2}-en"
PKG_L10N_ID_SYBERIA2_FR="${PKG_L10N_BASE_ID_SYBERIA2}-fr"
PKG_L10N_DESCRIPTION_SYBERIA2_EN='English localization'
PKG_L10N_DESCRIPTION_SYBERIA2_FR='French localization'
PKG_L10N_PROVIDES_SYBERIA2="
$PKG_L10N_BASE_ID_SYBERIA2"

PKG_DATA_ID_SYBERIA2="${GAME_ID_SYBERIA2}-data"


# Work around a crash on nvidia drivers
# cf. https://bugs.winehq.org/show_bug.cgi?id=43199
#     https://bugs.winehq.org/show_bug.cgi?id=44009

registry_dump_noxvidmode_file='registry-dumps/no-xvidmode.reg'
registry_dump_noxvidmode_content='Windows Registry Editor Version 5.00

[HKEY_CURRENT_USER\Software\Wine\X11 Driver]
"UseXVidMode"="N"'
CONTENT_GAME0_BIN_FILES="${CONTENT_GAME0_BIN_FILES:-}
$registry_dump_noxvidmode_file"
APP_REGEDIT="${APP_REGEDIT:-} $registry_dump_noxvidmode_file"
REQUIREMENTS_LIST="${REQUIREMENTS_LIST:-}
iconv"

# Syberia 2 - Set game language

registry_dump_language_file='registry-dumps/language.reg'
registry_dump_language_content_common='Windows Registry Editor Version 5.00

[HKEY_LOCAL_MACHINE\SOFTWARE\Microids\Syberia DVD]'
registry_dump_language_content_SYBERIA2_EN="$registry_dump_language_content_common"'
"Language"="EN"'
registry_dump_language_content_SYBERIA2_FR="$registry_dump_language_content_common"'
"Language"="FR"'
CONTENT_GAME0_BIN_FILES="${CONTENT_GAME0_BIN_FILES:-}
$registry_dump_language_file"
APP_REGEDIT_SYBERIA2="${APP_REGEDIT:-} $registry_dump_language_file"
REQUIREMENTS_LIST="${REQUIREMENTS_LIST:-}
iconv"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Work around a crash on nvidia drivers
	mkdir --parents "$(dirname "$registry_dump_noxvidmode_file")"
	printf '%s' "$registry_dump_noxvidmode_content" |
		iconv --from-code=UTF-8 --to-code=UTF-16 --output="$registry_dump_noxvidmode_file"

	# Syberia 1 - Create player.ini to force windowed mode
	# cf. https://bugs.winehq.org/show_bug.cgi?id=21796
	case "$(current_archive)" in
		('ARCHIVE_BASE_SYBERIA1_'*)
			cat > 'player.ini' <<- EOF
			800 600 16 0 BaseCMO.cmo
			EOF
		;;
	esac

	# Syberia 2 - Set game language
	case "$(current_archive)" in
		('ARCHIVE_BASE_SYBERIA2_'*)
			registry_dump_language_content=$(context_value 'registry_dump_language_content')
			mkdir --parents "$(dirname "$registry_dump_language_content")"
			printf '%s' "$registry_dump_language_content" |
				iconv --from-code=UTF-8 --to-code=UTF-16 --output="$registry_dump_language_file"
		;;
	esac
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Syberia 2 - Set game language
APP_REGEDIT=$(context_value 'APP_REGEDIT')

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
