 --[[ Copyright (c) 2011 Sergei Larionov, Alexey Pinyagin, 2021 "Matvey1705"

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. --]]

Font("unicode")
Language("Русский", "Russian", "ru", "rus")
Inherit("English")
Encoding(utf8)

--[[  Оглавление
  1.  Главное меню
  2.  Игровое меню и панель инструментов
  3.  Отчеты
  4.  Окна интерфейса
  5.  Болезни
  6.  Факсы
  7.  Советчик
  8.  Письма из министерства (WIP)
--]]

-- 1.  Главное меню
main_menu = {
  new_game = "Новая игра",
  continue = "продолжить игру",
  custom_level = "Дополнительные уровни",
  custom_campaign = "Дополнительные кампании",
  load_game = "Загрузить игру",
  map_edit = "Редактор карт",
  options = "Настройки",
  exit = "Выход",
  savegame_version = "Версия файлов сохранений: ",
  version = "Версия: ",
}
new_game_window = {
  tutorial = "Обучение",
  easy = "Студент (Легкий)",
  medium = "Доктор (Средний)",
  hard = "Консультант (Трудный)",
  cancel = "Отмена",
  difficulty = "Сложность",
  option_on = "Вкл.",
  option_off = "Выкл.",
  caption = "Кампания",
  player_name = "Имя Игрока",
  start = "Старт",
}
menu_options_warmth_colors = {
  choice_2 = "  СИНИЙ ЗЕЛЕНЫЙ КРАСНЫЙ  ",
  choice_1 = "  КРАСНЫЙ  ",
  choice_3 = "  ЖЕЛТЫЙ ОРАНЖЕВЫЙ КРАСНЫЙ  ",
}
date_format = {
  daymonth = "%1% %2:months%",
}
custom_game_window = {
  free_build = "Свободное строительство",
  caption = "Дополнительные уровни",
  load_selected_level = "Старт",
}
load_game_window = {
  caption = "Загрузить игру",
}
save_game_window = {
  caption = "Сохранить игру",
  new_save_game = "Новое сохранение",
}
folders_window = {
  data_label = "Данные TH",
  music_location = "Выберите папку, которую хотите использовать под вашу Музыку",
  music_label = "MP3",
  new_th_location = "Здесь вы можете указать новую папку с установкой оригинальной Theme Hospital. Как только вы выберете новую папку, игра будет перезапущена.",
  caption = "Расположение папок",
  screenshots_label = "Скриншоты",
  font_label = "Шрифт",
  savegames_label = "Сохранения",
  back = "Назад",
  savegames_location = "Выберите папку для размещения сохраненных игр.",
  screenshots_location = "Выберите папку для размещения скриншотов.",
}
customise_window = {
  average_contents = "Среднее содержимое",
  option_on = "Вкл",
  paused = "Строить во время паузы",
  option_off = "Выкл",
  intro = "Проигрывать заставку",
  caption = "Пользовательские настройки",
  back = "Назад",
  movies = "Управление роликами",
  volume = "Горячая клавиша убавления громкости",
  aliens = "Инопланетные пациенты",
  fractured_bones = "Сломанные кости",
  remove_destroyed_rooms = "Удалять разрушенные комнаты",
}
options_window = {
  fullscreen = "Во весь экран",
  height = "Высота",
  width = "Ширина",
  change_resolution = "Сменить разрешение",
  back = "Назад",
  original_path = "Папка с установленной оригинальной игрой Theme Hospital",
  browse = "Выбрать папку",
  folder = "ПАПКИ",
  option_off = "Выкл.",
  apply = "Применить",
  option_on = "Вкл.",
  custom_resolution = "Выбрать...",
  caption = "Настройки",
  cancel = "Отмена",
  customise = "Настроить",
  audio = "Общие звуки",
  resolution = "Разрешение",
  language = "Язык в игре",
  zoom_speed = "Скорость размера",
  capture_mouse = "Привязка мышки",
  shift_scrollspeed = "Скорость прокрутки с Shift",
  hotkey = "Горячие клавиши",
  scrollspeed = "Скорость прокрутки",
}
menu_list_window = {
  back = "Назад",
  save_date = "Изменено",
  name = "Имя",
}
update_window = {
  caption = "Доступно обновление!",
  new_version = "Новая Версия:",
  current_version = "Текущая Версия: ",
  download = "Перейти на страницу загрузки",
  ignore = "Пропустить и перейти в Главное меню",
  caption = "Доступно новое обновление!",
}
save_map_window = {
  caption = "Сохранение карты (%1%)",
  new_map = "Новая карта",
}
hotkey_window = {
  ingame_rotateobject = "Повернуть объект",
  global_showLuaConsole = "Lua Консоль",
  global_confirm = "Подтвердить",
  panel_recallPosKeys = "Изменить клавиши положения",
  global_runDebugScript = "Сценарий отладки",
  ingame_zoom_in_more = "Быстрее увеличить размер",
  global_fullscreen_toggle = "Полный экран",
  panel_storePosKeys = "Клавиши покупки",
  ingame_storePosition_8 = "8",
  ingame_restartLevel = "Переиграть уровень",
  ingame_panel_map_alt = "План 2",
  caption_panels = "Панельные клавиши",
  global_resetApp = "Перезагрузить приложение",
  panel_debugKeys = "Клавиши отладки",
  ingame_saveMenu = "Сохранить игру",
  ingame_panel_casebook_alt = "Записная книжка 2",
  ingame_scroll_down = "Прокрутить вниз",
  ingame_panel_status = "Статус",
  button_defaults = "Восстановить все по умолчанию",
  global_stop_movie_alt = "Остановить видео",
  ingame_panel_editRoom = "Редактировать комнату",
  ingame_gamespeed_speedup = "Увеличить скорость",
  panel_gameSpeedKeys = "Клавиши игровой скорости",
  ingame_recallPosition_6 = "6",
  ingame_storePosition_6 = "6",
  ingame_storePosition_0 = "10",
  global_confirm_alt = "Подтвердить альт",
  ingame_showmenubar = "Показать меню",
  panel_scrollKeys = "Клавиши прокрутки",
  ingame_toggleAdvisor = "Помощник",
  ingame_showCheatWindow = "Чит-меню",
  ingame_recallPosition_7 = "7",
  global_cancel = "Отмена",
  panel_globalKeys = "Global Keys",
  global_window_close_alt = "Закрыть окно",
  ingame_recallPosition_8 = "8",
  panel_zoomKeys = "Изменение размера",
  button_accept = "Принять",
  ingame_panel_policy = "Политика больницы",
  ingame_storePosition_1 = "1",
  global_exitApp = "Выйти",
  ingame_quickLoad = "Быстрая загрузка",
  global_screenshot = "Снимок экрана",
  ingame_recallPosition_3 = "3",
  ingame_scroll_right = "Прокрутить вправо",
  ingame_storePosition_5 = "5",
  panel_altPanelKeys = "Альтернативные Клавиши Панели",
  button_recallPosKeys = "Вызов клавишей положения",
  ingame_openFirstMessage = "Сообщение уровня",
  global_cancel_alt = "Отменить альт",
  ingame_panel_research_alt = "Исследования 2",
  ingame_recallPosition_2 = "2",
  ingame_scroll_left = "Прокрутить влево",
  ingame_zoom_out = "Уменьшить размер",
  ingame_poopLog = "Дамп-лог",
  ingame_reset_zoom = "Размер по умолчанию",
  caption_main = "Hotkey Assignment",
  ingame_gamespeed_slower = " Медленная ",
  global_releaseMouse = "Отпустите мышку",
  ingame_gamespeed_slowest = " Черепашья ",
  panel_toggleKeys = "Клавиши переключения",
  ingame_gamespeed_normal = " Обычная ",
  ingame_gamespeed_max = " Быстрая ",
  ingame_panel_buildRoom = "Строить кабинеты",
  ingame_gamespeed_thensome = " Еще быстрее ",
  ingame_toggleInfo = "Информация",
  ingame_panel_bankManager = "Банк-Менеджер",
  ingame_jukebox = "Проигрыватель",
  ingame_storePosition_3 = "3",
  ingame_panel_bankStats = "Статус банка",
  ingame_panel_staffManage = "Управлять персоналом",
  ingame_zoom_in = "Увеличить размер",
  ingame_panel_casebook = "Записная книжка",
  ingame_quitLevel = "Выйти",
  ingame_storePosition_4 = "4",
  global_connectDebugger = "Отладчик",
  ingame_zoom_out_more = "Быстрее уменьшить размер",
  panel_generalInGameKeys = "Общие внутриигровые клавиши",
  button_cancel = "Отмена",
  ingame_quickSave = "Быстрое сохранение",
  ingame_panel_furnishCorridor = "Обставлять коридор",
  ingame_scroll_shift = "Shift-скорость",
  ingame_panel_casebook_alt02 = "Записная книжка 3",
  ingame_pause = " Пауза ",
  ingame_panel_hireStaff = "Нанять персонал",
  ingame_setTransparent = "Прозрачные стены",
  ingame_panel_research = "Исследования",
  ingame_toggleAnnouncements = "Объявления",
  ingame_toggleSounds = "Звуки",
  ingame_toggleMusic = "Музыка",
  ingame_scroll_up = "Прокрутить вверх",
  button_back = "Назад",
  ingame_poopStrings = "Строки дампа",
  ingame_patient_gohome = "Отправить домой",
  ingame_recallPosition_0 = "10",
  ingame_panel_charts = "Графики",
  ingame_recallPosition_9 = "9",
  ingame_storePosition_7 = "7",
  button_gameSpeedKeys = "Клавиши изменения скорости",
  ingame_recallPosition_5 = "5",
  ingame_recallPosition_4 = "4",
  ingame_panel_townMap = "Карта",
  ingame_storePosition_9 = "9",
  ingame_loadMenu = "Загрузить игру",
  ingame_recallPosition_1 = "1",
  button_toggleKeys = "Переключить клавиши",
  ingame_storePosition_2 = "2",
}
tooltip = {
  main_menu = {
    exit = "Стой! Пожалуйста, не уходи!",
    custom_level = "Играть отдельный уровень",
    options = "Изменить всякие параметры",
    new_game = "Начать совершенно новую игру с самого начала",
    continue = "продолжить последнюю сохраненную игру",
    load_game = "Загрузить сохраненную ранее игру",
  },
  new_game_window = {
    tutorial = "Поставьте галочку здесь, чтобы пройти режим обучения",
    easy = "Нажимайте сюда, если вы новичок в подобных играх",
    medium = "Самый обычный средний уровень сложности",
    hard = "Выберите этот вариант, если хотите усложнить себе игру",
    cancel = "Отмена",
  },
  totd_window = {
    previous = "Показать предыдущий совет",
    next = "Показать следующий совет",
  },
  options_window = {
    fullscreen_button = "Включить/отключить полноэкранный режим",
    change_resolution = "Сменить разрешение экрана на указанное слева",
    height = "Введите разрешение экрана по вертикали",
    width = "Введите разрешение экрана по горизонтали",
    language = "Выбрать %s язык",
    back = "Закрыть окно настроек",
    audio_button = "Включить/Выключить всё аудио в игре",
    audio_toggle = "Включить/Выключить",
    folder_button = "Свойства папки",
    customise_button = "Больше настроек для улучшения игрового опыта",
  },
  save_game_window = {
    new_save_game = "Введите имя для сохраненной игры",
    save_game = "Перезаписать игру «%s»",
  },
  load_game_window = {
    load_game = "Загрузить игру «%s»",
    load_autosave = "Загрузить автосохранение",
  },
  hotkey_window = {
    button_gameSpeedKeys = "Откройте окно, чтобы установить клавиши для управления скоростью игры",
    caption_panels = "Открыть окно для назначения клавиш панели",
    button_accept = "Принять и сохранить назначения горячих клавиш",
    button_back_02 = "Вернуться к главному окну горячих клавиш. Горячие клавиши, измененные в этом окне, могут быть приняты там",
    button_defaults = "Cбросить все горячие клавиши, и вернуть их на настройки по умолчанию",
    button_cancel = "Отменить изменения и вернуться в меню настроек",
    button_recallPosKeys = "Откройте окно для установки клавиш для сохранения и вызовов положений камеры",
  },
  custom_campaign_window = {
    choose_campaign = "Выберите кампанию, чтобы узнать про нее больше.",
    start_selected_campaign = "Начать играть в первый уровень этой кампании.",
  },
}

-- 2.  Игровое меню и панель инструментов
menu = {
  file =    "  Файл",
  player_count = "Кол-во игроков",
  options = "  Опции",
  charts =  "  Отчеты",
  display = "  ОТОБРАЖЕНИЕ  ",
  debug = "  ОТЛАДКА  ",
}
menu_file = {
  save =    "  (%1%) Сохранить",
  load =    "  (%1%) Загрузить",
  restart = "  (%1%) Начать заново",
  quit =    "  (%1%) Выйти в главное меню",
}
menu_options = {
  game_speed =        "    Скорость игры",
  sound_vol =         "    Громкость звука",
  music_vol =         "    Громкость музыки",
  edge_scrolling =    "    Прокрутка мышью",
  announcements =     "    (%1%) Сообщения",
  lock_windows =      "    Не двигать окна",
  settings =          "    Настройки",
  sound =             "    (%1%) Звуки",
  announcements_vol = "    Громкость сообщений",
  music =             "    (%1%) Музыка",
  autosave =          "    Автосохранение",
  jukebox =           "    (%1%) Музыкальный автомат",
  twentyfour_hour_clock = "    24-х часовой формат времени ",
  wage_increase = "    ЗАПРОСЫ О ЗАРПЛАТЕ ",
  warmth_colors = "    ЦВЕТА ОТОПЛЕНИЯ ",
  adviser_disabled = "    (%1%) ПОМОЩНИК  ",
  capture_mouse = "  Привязка мышки  ",
}
menu_options_game_speed = {
  pause =              "    (%1%) Пауза",
  slowest =            "    (%1%) Черепашья",
  slower =             "    (%1%) Медленная",
  normal =             "    (%1%) Обычная",
  max_speed =          "    (%1%) Быстрая",
  and_then_some_more = "    (%1%) Еще быстрее",
}
menu_options_wage_increase = {
  deny = "    ЗАПРЕТИТЬ ",
  grant = "    РАЗРЕШИТЬ ",
}
menu_charts = {
  statement =     "  (%1%) Баланс банка",
  casebook =      "  (%1%) Лабораторный журнал",
  policy =        "  (%1%) Политика",
  research =      "  (%1%) Исследования",
  graphs =        "  (%1%) Графики",
  staff_listing = "  (%1%) Список сотрудников",
  bank_manager =  "  (%1%) Управляющий банка",
  status =        "  (%1%) Состояние",
  briefing =      "  Инструктаж",
  town_map =      "  (%1%) карта города ",
}
menu_file_load = {
  [1] = "  ИГРА 1  ",
  [2] = "  ИГРА 2  ",
  [3] = "  ИГРА 3  ",
  [4] = "  ИГРА 4  ",
  [5] = "  ИГРА 5  ",
  [6] = "  ИГРА 6  ",
  [7] = "  ИГРА 7  ",
  [8] = "  ИГРА 8  ",
}
menu_debug_overlay = {
  heat = "  TEMPERATURE  ",
  byte_0_1 = "  BYTE 0 & 1  ",
  byte_6 = "  BYTE 6  ",
  flags = "  FLAGS  ",
  byte_7 = "  BYTE 7  ",
  byte_5 = "  BYTE 5  ",
  byte_floor = "  BYTE FLOOR  ",
  positions = "  POSITIONS  ",
  byte_w_wall = "  BYTE W WALL  ",
  parcel = "  PARCEL  ",
  byte_n_wall = "  BYTE N WALL  ",
  none = "  NONE  ",
}
menu_file_save = {
  [1] = "  ИГРА 1  ",
  [2] = "  ИГРА 2  ",
  [3] = "  ИГРА 3  ",
  [4] = "  ИГРА 4  ",
  [5] = "  ИГРА 5  ",
  [6] = "  ИГРА 6  ",
  [7] = "  ИГРА 7  ",
  [8] = "  ИГРА 8  ",
}
menu_display = {
  shadows = "  ТЕНИ  ",
  mcga_lo_res = "  MCGA НИЗ.РАЗРЕШЕНИЕ  ",
  high_res = "  ВЫСОКОЕ РАЗРЕШЕНИЕ  ",
}
menu_player_count = {
  players_1 = "  1 Игрок  ",
  players_4 = "  4 Игрока  ",
  players_2 = "  2 Игрока  ",
  players_3 = "  3 Игрока  ",
}

install = {
  title = "--------------------------------- Установка CorsixTH ---------------------------------",
  th_directory = "CorsixTH для нормальной работы требуется оригинальная установленная игра Theme Hospital. Нажмите кнопку и выберите папку, в которую установлена оригинальная игра.",
  exit = "Выход",
  ok = "OK",
  cancel = "Отмена",
}
dynamic_info = {
  patient = {
    emergency = "Чрезвычайная ситуация: %s",
    guessed_diagnosis = "Диагноз навскидку: %s ",
    diagnosis_progress = "Процесс диагностики",
    actions = {
      sent_to_other_hospital = "Отправлен в другую больницу",
      prices_too_high = "У вас слишком дорого, - я иду домой",
      no_gp_available = "Ждет постройки кабинета терапевта",
      waiting_for_treatment_rooms = "Ждет постройки кабинета для лечения",
      dying = "Умирает!",
      no_diagnoses_available = "Раз не знаете что со мной, - я иду домой",
      epidemic_sent_home = "Отправлен домой инспектором",
      cured = "Здоров!",
      waiting_for_diagnosis_rooms = "Ждет постройки диагностического кабинета",
      epidemic_contagious = "Заразный",
      awaiting_decision = "Ждет вашего решения",
      sent_home = "Отправлен домой",
      fed_up = "Сыт по горло и уходит",
      no_treatment_available = "Раз не можете вылечить, - я иду домой",
      on_my_way_to = "Идет в %s",
      queueing_for = "Стоит в очереди в %s",
      epidemic_vaccinated = "Я больше не заразен",
    },
    diagnosed = "Поставлен диагноз: %s ",
  },
  health_inspector = "Инспектор",
  vip = "Шишка",
  object = {
    times_used = "Использовано раз: %d",
    queue_size = "Длина очереди: %d",
    strength = "Прочность: %d",
    queue_expected = "Ожидается очередь: %d",
  },
  staff = {
    actions = {
      going_to_repair = "Идет чинить %s",
      fired = "Уволен",
      waiting_for_patient = "Ждет пациента",
      wandering = "Слоняется без дела",
      heading_for = "Идет в %s",
      vaccine = "Вакцинация пациента",
    },
    tiredness = "Усталость",
    psychiatrist_abbrev = "Псих.",
    ability = "Способность",
  },
}
handyman_window = {
  all_parcels = "Все корпуса",
  parcel = "Корпус",
}
font_location_window = {
  caption = "Выберите шрифт (%1%)",
}
staff_title = {
  junior = "Студент",
  psychiatrist = "Психиатр",
  consultant = "Консультант",
  surgeon = "Хирург",
  doctor = "Доктор",
  researcher = "Исследователь",
  nurse = "Медсестра",
  receptionist = "Регистратор",
  general = "Общий",
}
tooltip = {
  toolbar = {
    bank_button = "Левая кнопка - управляющий банка, правая - баланс банка",
    balance = "Ваш баланс",
    reputation = "Ваша репутация",
    date = "Дата",
    rooms = "Строить кабинеты",
    objects = "Обставлять коридор",
    edit = "Редактировать кабинеты/мебель",
    hire = "Нанять персонал",
    staff_list = "Управление персоналом",
    town_map = "Карта",
    casebook = "Лабораторный журнал",
    research = "Исследования",
    status = "Состояние",
    charts = "Графики",
    policy = "Политика",
  },
  options_window = {
    select_language = "Выбрать язык игры",
    select_resolution = "Выбрать новое разрешение",
    language_dropdown_item = "Выбрать %s язык",
    audio_button = "Включить или выключить весь игровой звук",
    resolution = "Разрешение в котором игра должна работать",
    audio_toggle = "Переключатель вкл. или выкл.",
    fullscreen = "Игра должна работать в полноэкранном или оконном режиме",
    apply = "Использовать введенное разрешение",
    cancel = "Вернуться без изменения разрешения",
    folder_button = "Свойства Папки",
    customise_button = "Выможете изменить больше настроек для индивидуализации игрового опыта",
    zoom_speed = "Измените скорость размера камеры от 10 (Самая медленная) до 1000 (Самая быстрая). По умолчанию это 80.",
    capture_mouse = "Включить привязку курсора в игровом окне.",
    cancel_shift_scrollspeed = "Продолжить без изменения скорости прокрутки с нажатой клавишей shift.",
    cancel_zoomspeed = "Продолжить без изменения скорости размера.",
    cancel_scrollspeed = "Продолжить без изменения скорости прокрутки.",
    apply_zoomspeed = "Применить введёную скорость изменения размера.",
    apply_shift_scrollspeed = "Применить введёную скорость прокрутки с нажатой клавишей shift.",
    scrollspeed = "Установите скорость прокрутки от 1 (Самая медленная) до 10 (Самая быстрая). По умолчанию это 2.",
    hotkey = "Измените горячие клавиши на клавиатуре.",
    shift_scrollspeed = "Установите скорость прокрутки при нажатой клавише shift. от 1 (самая медленная) до 10 (самая быстрая). Значение по умолчанию равно 4.",
    apply_scrollspeed = "Применить введенную скорость прокрутки.",
  },
  menu_list_window = {
    save_date = "Нажмите тут для сортировки списка по дате последнего изменения",
    name = "Нажмите тут для сортировки списка по имени",
  },
  custom_game_window = {
    free_build = "Отметьте тут если вы хотите играть без денег и условий для победы и поражения",
  },
  new_game_window = {
    difficulty = "Выберите уровень сложности игры",
    player_name = "Введите имя, которым вы хотите представляться в игре",
    start = "Начать игры с выбранными настройками",
  },
  casebook = {
    cure_type = {
      drug = "Это лечение будет использовать лекарство",
      unknown = "Вы все ещё не знаете как лечить это заболевание",
    },
    cure_requirement = {
      hire_surgeon = "Вы должны нанять второго Хирурка для проведения операции",
      not_possible = "Вы все ещё не можете справиться с этим лечением",
      hire_staff_old = "Вам нужно нанять %s для проведения этого лечения",
      hire_surgeons = "Для проведения операций вам нужно нанять двух Хирургов",
      build_ward = "Вам необходимо построить Палату для проведения этого лечения",
      ward_hire_nurse = "Вам нужна Медсестра для работы в Палате для проведения этого лечения",
    },
  },
  main_menu = {
    load_menu = {
      load_slot = "ЗАГРУЗИТЬ ИГРУ",
      empty_slot = "ПУСТО",
    },
    continue = "Продолжить предыдущую игру",
    network = "Начать сетевую игру",
    quit = "Вы собираетесь выйти из CorsixTH.  Вы уверены в том что хотите именно этого?",
    custom_campaign = "Играть в кампанию, сделанную сообществом",
    map_edit = "Создать собственную карту",
  },
  load_game_window = {
    load_game_number = "Загрузить игру %d",
  },
  update_window = {
    download = "Перейти на страницу загрузки самой последней версии CorsixTH",
    ignore = "Игнорировать это обновление. Вы будете снова оповещены когда снова запустите CorsixTH",
  },
  save_map_window = {
    map = "Перезаписать карту %s",
    new_map = "Введите название для сохранения карты",
  },
  folders_window = {
    browse_font = "Просмотреть другой файл шрифтаBrowse ( текущее местоположение: %1% )",
    screenshots_location = "По умолчанию Скриншоты сохраняются в папке вместе с конфигурационным файлом. Если это не подходит, то вы можете выбрать его самостоятельно, просто перейдите в каталог, который вы хотите для этого использовать.",
    reset_to_default = "Установить  папку по умолчанию",
    back = "Закрть это меню и вернуться в Меню Настроек",
    music_location = "Выберете папку, где хранятся файлы с mp3 музыкой. Если вы ее только что создали, тогда перейдите в нее.",
    font_location = "Местонахождение файла шрифта, способного отображать Unicode кодировку, необходимую для вашего языка. Если он не указан, то вы не можете выбрать языки, требующие для отображения больше символов, чем были в оригинальной игре. Например: Русский и Китайский ",
    savegames_location = "По умолчанию, папка для сохраненных игр находится вместе с конфигурационным файлом. Если это не удобно, тогда вы можете выбрать любую другую просто перейдя в нее. ",
    browse_data = "Указать другое место нахождения файлов Theme Hospital (текущее местоположение: %1%)",
    browse = "Просмотр папок",
    browse_screenshots = "Указать на другое местоположение папки со скиншотами  ( текущее местоположение: %1% ) ",
    browse_music = "Укажите друго расположение папки с Музыкой  ( текущее местоположение: %1% ) ",
    no_font_specified = "Расположение файла со шрифтом ещё не указано!",
    not_specified = "Местонахождение папки не определено!",
    browse_saves = "Укажите другое местонахождение папки с сохраненными играми  ( текущее местоположение: %1% ) ",
    default = "Местоположение по-умолчанию",
    data_location = "Папка, куда установлена оригинальная Theme Hospital, она необходима для запуска CorsixTH",
    browse_font = "Поиск другого файла со шрифтом ( текущее расположение: %1% )",
    screenshots_location = "По умолчанию скриншоты сохраняются в папке рядом с файлом конфигурации. По желанию Вы можете выбрать свою папку, просто укажите нужный путь к ней.",
    reset_to_default = "Вернуть папку в её изначальное расположение",
    back = "Закрыть это меню и вернуться к настройкам",
    music_location = "Выберите расположение ваших mp3 аудиофайлов. Вы должны были уже создать для них папку, теперь же укажите путь к ней.",
    font_location = "Расположение файла со шрифтом, который может отображать символы Юникода, необходимые вашему языку. Если это не будет указано, вы не сможете выбрать языки, которым нужно больше символов, чем игра может предложить. Например, китайский и русский.",
    savegames_location = "По умолчанию папка, куда помещаются сохранения, находится в папке рядом с файлом конфигурации. По желанию Вы можете выбрать свою папку, просто укажите нужный путь к ней.",
    browse_data = "Обзор расположения установленной версии Theme Hospital (текущее расположение: %1%)",
    browse = "Обзор расположения папки",
    browse_screenshots = "Обзор расположения папки скриншотов ( Текущее расположение: %1% ) ",
    browse_music = "Обзор расположения папки музыки ( Текущее расположение: %1% ) ",
    no_font_specified = "Расположение шрифта ещё не указано!",
    not_specified = "Расположение папки ещё не указано!",
    browse_saves = "Обзор расположения папки сохранений ( Текущее расположение: %1% ) ",
    default = "Расположение по умолчанию",
    data_location = "Папка с установленной версией Theme Hospital, которая нужна CorsixTH для запуска",
  },
  customise_window = {
    aliens = "К сожалению, пациенты с инопланетной ДНК плохо анимированы поэтому в больницу они приходят только по экстренным случаям. Если вы хотите, чтобы они приходили так же как и обычные пациенты, выключите эту опцию.",
    average_contents = "Если вы хотите, чтобы игра запоминала какие дополнительные объекты вы устанавливаете в том или ином кабинете, когда его строите, включите эту опцию.",
    back = "Закрыть это меню и вернуться в Главное меню",
    movies = "Общий контроль за видеороликами. Это позволит вам отключить все видеоролики.",
    fractured_bones = "Из-за плохой анимации, по-умолчанию мы отключили всех пациентов женщин со Сломанными костями. Для того чтобы женщины со сломанными костями приходили в вашу больницу, выключите эту опцию.",
    volume = "Если кнопка понижения громкости открывает журнал, включите эту опцию, чтобы изменить горячую клавишу журнала на Shift+C",
    intro = "Включить или выключить показ вступительного ролика. Общий контроль за видеороликами должен быть включен, если вы хотить видеть вступление каждый раз, когда запускаете CorsixTH",
    paused = "В оригинальном Theme Hospital использовать меню сверху экрана можно было только если поставить игру на паузу. Мы оставили это по-умолчанию и в CorsixTH. Если вы включите эту опцию, то на паузе можно будет делать все что угодно.",
    remove_destroyed_rooms = "Если вы хотите иметь возможность удалять разрушенные комнаты за отдельную плату, включите эту опцию.",
  },
  handyman_window = {
    happiness = "Счастье",
    salary = "Зарплата",
    parcel_select = "Корпус, в котором рабочий выполняет свои функции, нажмите, чтобы изменить",
    tiredness = "Усталость",
    sack = "Уволить",
    close = "Закрыть",
    face = "Изображение рабочего",
    pick_up = "Поднять",
    center_view = "Центрировать экран на рабочем",
    name = "Имя рабочего",
    ability = "Способности",
  },
  research_policy = {
    research_progress = "Прогресс, необходимый до следующего открытия в этой категории: %1%/%2%",
    no_research = "В настоящее время исследований в этой категории не производится",
  },
  objects = {
    lamp = "Лампа: излучает свет и позволяет персоналу видеть.",
    op_sink1 = "33 РАКОВИНА",
    litter_bomb = "Заминированное письмо: соботирует работу в больнице конкурента",
    x_ray = "27 РЕНТГЕН-АППАРАТ",
    projector = "37 ПРОЭКТОР",
    radiation_shield = "28 РАДИАЦИОННЫЙ ЩИТ",
    entrance_left = "58 ЛЕВАЯ ВХОДНАЯ ДВЕРЬ",
    table2 = "12 СТОЛ",
    bed2 = "неиспользовалась",
    console = "15 КОНСОЛЬ УПРАВЛЕНИЯ",
    operating_table = "30 СТОЛ ДЛЯ ОПЕРАЦИЙ",
    x_ray_viewer = "29 РЕНТГЕН ЭКРАН",
    crash_trolley = "20 КРЭШ-ТЕЛЕЖКИ",
    shower = "54 ОБЕЗЗАРАЖИВАЮЩИЙ ДУШ",
    electrolyser = "46 ЭЛЕКТРОЛИЗЕР",
    hair_restorer = "25 ВОССТАНОВИТЕЛЬ ВОЛОС",
    jelly_moulder = "47 РАЗЖЕЛЕИВАТЕЛЬ",
    couch = "18 КУШЕТКА",
    surgeon_screen = "35 ШИРМА ДЛЯ ОПЕРАЦИЙ",
    bed3 = "неиспользовалась",
    dna_fixer = "23 ВОССТАНОВИТЕЛЬ ДНК",
    chair = "Стул: пациенты сидят на нем и обсуждают свое заболевание.",
    cast_remover = "24 УДАЛИТЕРЬ ГИПСА",
    entrance_right = "59 ПРАВАЯ ВХОДНАЯ ДВЕРЬ",
    cardio = "13 КАРДИО АППАРАТ",
    slicer = "26 ЯЗЫКОРЕЗКА",
    table1 = "Стол (УДАЛЕН): содержит коллекцию журналов, чтобы занять ожидающих пациентов.",
    ultrascanner = "22 АППАРАТ УЗИ",
    scanner = "14 СКАНЕР",
    op_sink2 = "34 РАКОВИНА",
    door = "Дверь: люди могут открывать и закрывать ее много раз.",
    swing_door2 = "53 РАСПАШНАЯ ДВУСТВОРЧАТАЯ ДВЕРЬ",
    screen = "16 ШИРМА",
    gates_of_hell = "48 ВОРОТА В АД",
    blood_machine = "42 МАШИНА ДЛЯ ЗАБОРА КРОВИ",
    comfortable_chair = "61 КОМФОРТНЫЙ СТУЛ",
    swing_door1 = "52 РАСПАШНАЯ ДВУСТВОРЧАТАЯ ДВЕРЬ",
    rathole = "Семья крыс нашла вашу больницу грязной, и поэтому будут они будут жить здесь.",
  },
}
misc = {
  hospital_open = "Открыть больницу",
  save_success = "Игра успешно сохранена",
  save_failed = "Ошибка: не удалось сохранить игру",
  low_res = "Низкое разрешение",
  no_heliport = "Либо заболевания не обнаружены, либо на этой карте нет вертолетной площадки.",
  grade_adverb = {
    extremely = "экстремально",
    mildly = "средне",
    moderately = "умеренно",
  },
  not_yet_implemented = "(еще не реализовано)",
  send_message = "Отправить сообщение игроку %d",
  out_of_sync = "Рассинхронизация игры",
  balance = "Файл баланса:",
  load_failed = "Сохранение не загружено",
  mouse = "Мышь",
  done = "Готово",
  force = "Ускорение",
  pause = "Пауза",
  send_message_all = "Отправить сообщение всем игрокам",
  cant_treat_emergency = "Ваша больница не может лечить эту чрезвычайную ситуацию, потому что ее заболевание не было обнаружено.",
}
errors = {
  unavailable_screen_size = "Установленный размер экрана не поддерживается в полноэкранном режиме.",
  dialog_missing_graphics = "Сожалеем, но файлы демо версии не содержат этот диалог.",
  maximum_screen_size = "Максимальный размер экрана не должен превышать 3000x2000.",
  load_prefix = "Ошибка загрузки игры: ",
  no_games_to_contine = "Нет сохраненных игр",
  save_prefix = "Ошибка сохранения игры: ",
  map_file_missing = "Не найден файл карты %s для этого уровня!",
  minimum_screen_size = "Размер экрана не должен быть менее, чем 640x480.",
  alien_dna = "Пояснение: не существует анимации как инопланетные пациенты сидят, открывают или стучатся в дверь и т.п. В оригинальной Theme Hospital они при этом превращались в обычного пациента и потом обратно. пациенты с инопланетной ДНК будут доступны только если они разрешены в файле с уровнем.",
  fractured_bones = "Пояснение: анимация пациентов со сломанными костями женского пола плохая",
  load_quick_save = "Ошибка, не удалось загрузить быстрое сохранение, так как оно не существовало, но мы создали для Вас новое!",
  could_not_find_first_campaign_level = "Не удалось найти первый уровень в этой кампании: %s",
  save_to_tmp = "Файл в %s не может быть использован. Игра была сохранена в %s. Ошибка: %s",
  could_not_load_campaign = "Сбой при загрузке кампании: %s",
  compatibility_error = {
    new_in_old = "Извините, это сохранение было создано в более новой версией CorsixTH и несовместимо. Пожалуйста, обновите до более поздней версии.",
  },
}
hotkeys_file_err = {
  file_err_01 = " Не удается загрузить файл hotkeys.txt. Пожалуйста, убедитесь, что у CorsixTH есть разрешение на чтение/запись. ",
  file_err_02 = " , или используйте параметр командной строки --hotkeys-file=filename, чтобы указать файл, доступный для записи. Для справки, ошибка при загрузке файла горячих клавиш была: ",
}

-- 3.  Отчеты
staff_list = {
  morale = "Мораль",
  tiredness = "Бодрость",
  skill = "Компетентность",
  total_wages = "ВСЕГО ЗАРПЛАТЫ",
}
bank_manager = {
  current_loan = "Текущий заем",
  balance = "Баланс",
  interest_payment = "Выплачиваемый процент",
  hospital_value = "Стоимость госпиталя",
  interest_rate = "Процентная ставка",
  inflation_rate = "Уровень инфляции",
  insurance_owed = "Выплаты страховщиков",
  statistics_page = {
    balance = "Баланс",
    details = "Причина",
    date = "Дата",
    current_balance = "Текущий баланс",
    money_in = "Приход",
    money_out = "Расход",
  },
}
transactions = {
  severance = "Выходное пособие",
  research = "Финансирование исследований",
  eoy_trophy_bonus = "Приз по итогам года",
  buy_object = "Покупка",
  cure_colon = "Лечение:",
  wages = "Выплата зарплат",
  personal_bonus = "Выплата премии",
  drug_cost = "Покупка лекарств",
  heating = "Счет за отопление",
  treat_colon = "Обследование:",
  hire_staff = "Прием на работу",
  bank_loan = "Заем у банка",
  insurance_colon = "Страховка:",
  sell_object = "Продажа",
  loan_interest = "Выплата процента по займу",
  loan_repayment = "Возврат по займу",
  buy_land = "Покупка участка",
  machine_replacement = "Замена машины",
  build_room = "Постройка",
  drinks = "Продажа напитков",
  cure = "Вылечено",
  eoy_bonus_penalty = "Призы/Наказания в конце года",
  cheat = "Чит с деньгами",
  general_bonus = "Оплата Главной премии",
  emergency_bonus = "Оплата премии за Экстренные случаи",
  epidemy_coverup_fine = "Штраф за сокрытие эпидемий",
  research_bonus = "Премия исследований",
  final_treat_colon = "Окончательное лечение: ",
  jukebox = "Входящее: музыкальный автомат",
  vaccination = "Вакцинация",
  vip_award = "Денежная премия от ВИП",
  epidemy_fine = "Штраф за эпидемию",
  compensation = "Компенсация от Правительства",
  deposit = "Депозит на лечение",
  advance_colon = "Дополнительно: ",
  overdraft = "Проценты по кредиту",
  remove_room = "Удалите разрушенную комнату",
}
town_map = {
  number = "Номер участка",
  not_for_sale = "Не продается",
  price = "Цена участка",
  for_sale = "Продается",
  owner = "Владелец уч-ка",
  area = "Площадь уч-ка",
  chat = "Окно детализации города",
}
high_score = {
  categories = {
    deaths = "Пациентов угроблено",
    total_value = "Общая стоимость",
    money = "Самый богатый",
    cures = "Пациентов вылечено",
    visitors = "Количество посетителей",
    salary = "Размер зарплаты",
    clean = "Чистота",
    patient_happiness = "Удовлетворенность пациентов",
    cure_death_ratio = "Соотношение убитых и вылеченных",
    staff_happiness = "Удовлетворенность персонала",
    staff_number = "Самое большое количество персонала",
  },
  player = "ИГРОК",
  pos = "ПОЗ",
  best_scores = "ЗАЛ СЛАВЫ",
  killed = "Убито",
  worst_scores = "ЗАЛ ПОЗОРА",
  score = "ОЧКИ",
}
research = {
  allocated_amount = "Распределенное количество",
  funds_allocation = "Распределение финасирования",
  categories = {
    improvements = "Улучшения",
    drugs = "Исследование лекарств",
    diagnosis = "Диагностическое оборудование",
    cure = "Оборудование для лечения",
    specialisation = "Специализация",
  },
}
policy = {
  header = "Политика больницы",
  diag_termination = "Длительность обследования",
  sliders = {
    guess = "Диагноз наугад",
    send_home = "Отправить домой",
    stop = "Прекратить",
    staff_room = "Идти отдыхать",
  },
  diag_procedure = "Процедура обследования",
  staff_rest = "Отправлять персонал отдыхать",
  staff_leave_rooms = "Покидать кабинеты",
}
casebook = {
  sent_home = "Отправлено домой",
  deaths = "Жертвы",
  treatment_charge = "Взимаемая плата",
  reputation = "Репутация",
  research = "Сосредоточить исследования",
  cure = "Лекарство",
  cured = "Вылечено",
  earned_money = "Денег получено",
  cure_desc = {
    hire_surgeons = "Вам необходимо нанять хирургов.",
    improve_cure = "Улучшить лечение.",
    no_cure_known = "Нет известного лечения.",
    build_room = "Я рекомендую вам построить %s",
    hire_psychiatrists = "Вы должны нанять психиатра.",
    build_ward = "Вам по прежнему нужно построить Палату.",
    hire_nurses = "Вам нужно нанять медсестер.",
    cure_known = "Вылечен.",
    hire_doctors = "Вам нужно нанять докторов.",
  },
}
progress_report = {
  quite_unhappy = "Люди вами недовольны",
  header = "Отчет об успехах",
  very_unhappy = "Люди вас не любят. Уделяйте им больше внимания",
  more_drinks_machines = "Пациенты умирают от жажды. Поставьте автоматы с напитками",
  too_cold = "У вас слишком холодно, поставьте еще батарей",
  too_hot = "Настройте систему отопления, у вас слишком жарко",
  percentage_pop = "Доля клиентов",
  win_criteria = "Условия для победы",
  free_build = "Свободное строительство",
}
tooltip = {
  staff_list = {
    prev_person = "Предыдущая страница",
    next_person = "Следующая страница",
    detail = "Внимание к деталям",
    happiness = "Насколько ваши сотрудники довольны своей работой в целом",
    tiredness = "Показывает сколько ваши сотрудники еще смогут поработать без отдыха",
    ability = "Квалификация ваших сотрудников в среднем по больнице",
    happiness_2 = "Моральное состояние",
    ability_2 = "Профессиональные навыки",
    tiredness_2 = "Запас сил",
    researcher_train = "На %d%% готов к получению диплома исследователя",
    surgeon_train = "На %d%% готов к получению диплома хирурга",
    psychiatrist_train = "На %d%% готов к получению диплома психиатра",
    researcher = "Дипломированый исследователь",
    psychiatrist = "Дипломированый психиатр",
    surgeon = "Дипломированый хирург",
    handymen = "Показать список всех рабочих вашей больницы",
    nurses = "Показать список всех медсестер вашей больницы",
    doctors = "Показать список всех докторов вашей больницы",
    receptionists = "Показать список всех регистраторов вашей больницы",
    pay_rise = "Поднять оклад на 10%",
    bonus = "Выплатить премию в размере 10% от оклада",
    salary = "Текущая зарплата",
    close = "Назад к игре",
    sack = "Вышвырнуть на улицу",
    doctor_seniority = "Авторитет доктора",
    view_staff = "Наблюдать за работой",
    skills = "Дополнительные умения",
    total_wages = "Общая зарплата",
  },
  town_map = {
    close = "Закрыть",
    plants = "Показывать растения",
    fire_extinguishers = "Показывать огнетушители",
    people = "Показывать людей",
    balance = "Баланс",
    heat_dec = "Уменьшить температуру",
    heating_bill = "Счет за отопление",
    radiators = "Показывать батареи",
    objects = "Показывать мебель",
    heat_level = "Температура",
    heat_inc = "Увеличить температуру",
  },
  policy = {
    diag_termination = "Обследование пациента будет продолжаться, пока доктора не будут на столько процентов уверены в диагнозе или пока у них не закончатся средства диагностики",
    close = "Закрыть окно политики",
    staff_leave = "Нажмите здесь чтобы разрешить сотрудникам покидать кабинеты и идти туда где нужна их помощь",
    diag_procedure = "Если доктор уверен в своем диагнозе менее, чем значение «Отправить домой», пациент будет отправлен домой. Если же шансы выше чем «Диагноз наугад», он будет отправлен на лечение. В остальных случаях потребуется ваше решение",
    staff_rest = "Насколько усталым должен быть сотрудник, чтобы получить право на отдых",
    staff_stay = "Нажмите здесь чтобы сотрудники оставались в тех кабинетах, где вы их поставили",
  },
  bank_manager = {
    graph = "График ожидаемых выплат от %s",
    close = "Закрыть окно",
    hospital_value = "Текущая стоимость госпиталя вместе со всем оборудованием",
    graph_return = "Вернуться назад",
    current_loan = "Размер текущего займа",
    borrow_5000 = "Занять у банка 5000$",
    balance = "Ваш баланс",
    interest_payment = "Ежемесячные выплаты по займу",
    inflation_rate = "Размер инфляции за год",
    interest_rate = "Годовой процент по займу",
    repay_5000 = "Отдать банку 5000$",
    show_graph = "Показать график ожидаемых выплат от %s",
    insurance_owed = "Сколько денег вам должны %s",
  },
  casebook = {
    sent_home = "Количество пациентов, которым было отказано в лечении",
    increase = "Поднять стоимость",
    decrease = "Снизить стоимость",
    up = "Вверх",
    down = "Вниз",
    reputation = "Общая репутация этой практики",
    research = "Нажмите чтобы сосредоточить бюджет специальных исследований на этой проблеме",
    close = "Закрыть",
    earned_money = "Всего заработано на этом",
    deaths = "Количество летальных исходов",
    cured = "Количество вылеченных",
    treatment_charge = " Стоимость для пациентов",
    cure_type = {
      psychiatrist = "Это лечит психиатр",
      drug_percentage = "От этого есть лекарство. Ваше эффективно на %d%",
      machine = "Для лечения нужно специальное оборудование",
      surgery = "Лечение требует операции",
    },
    cure_requirement = {
      possible = "Вы можете это вылечить",
      build_room = "Вам нужно построить специальный кабинет для лечения",
      research_machine = "Для лечения нужно изобрести машину",
      hire_staff = "Вам нужно нанять специалиста для лечения",
    },
  },
  status = {
    population_chart = "Показывает соотношение числа посетителей в разных больницах",
    percentage_cured = "Вам нужно вылечить %d% всех посетителей. На данный момент вам удалось вылечить %d%",
    num_cured = "Вам нужно вылечить %d людей. Пока вам удалось исцелить %d",
    thirst = "Средний уровень жажды людей в больнице",
    close = "Закрыть окно",
    win_progress_own = "Показать успехи вашей больницы",
    reputation = "Ваша репутация должна достигать %d. Сейчас она составляет %d",
    population = "Добейтесь чтобы к вам приходили лечиться %d%% всех пациентов",
    warmth = "Средняя температура по больнице",
    percentage_killed = "Постарайтесь не убивать более чем %d%% посетителей. На данный момент вы угробили %d%%",
    balance = "На вашем счету должно быть не менее %d$. Сейчас у вас %d$",
    value = "Ваша больница должна стоить %d$. Сейчас она стоит %d$",
    win_progress_other = "Показать как идут дела у %s",
    happiness = "Общее состояние пациентов в вашей больнице",
  },
}

-- 4.  Другие окна
-- 4.1  Строительство и обстановка
build_room_window = {
  pick_room_type = "Выберите тип кабинета",
  pick_department = "Выберите кабинет",
  cost = "Стоимость: ",
}
room_classes = {
  diagnosis =  "Диагностика",
  treatment =  "Процедуры",
  clinics =    "Лечение",
  facilities = "Служебные комнаты",
}
rooms_short = {
  gps_office =        "Кабинет терапевта",
  general_diag =      "Общая диагностика",
  ultrascan =         "Ультрасканер",
  research_room =     "Исследовательский отдел",
  fracture_clinic =   "Лечение переломов",
  destroyed =         "Разрушено",
  staffroom =         "Комната отдыха",
  jelly_vat =         "Лечение ожеления",
  scanner =           "Сканер",
  decontamination =   "Обеззараживание",
  pharmacy =          "Аптека",
  cardiogram =        "Кардиография",
  reception =         "Регистратура",
  training_room =     "Лекционная",
  corridor_objects =  "Обстановка коридоров",
  operating_theatre = "Операционная",
  dna_fixer =         "Исправление ДНК",
  ward =              "Палата",
  psychiatric =       "Психиатрия",
  hair_restoration =  "Восстановление волос",
  inflation =         "Надувание",
  tongue_clinic =     "Языкорезка",
  toilets =           "Туалет",
  electrolysis =      "Электротерапия",
  x_ray =             "Рентген",
  blood_machine =     "Анализатор крови",
}
rooms_long = {
  ultrascan = "Кабинет ультрасканирования",
  research_room = "Исследовательский отдел",
  general = "Общий",
  gps_office = "Кабинет терапевта",
  inflation = "Кабинет надувания",
  staffroom = "Комната отдыха",
  jelly_vat = "Кабинет лечения ожеления",
  scanner = "Кабинет сканирования",
  emergency = "Реанимация",
  decontamination = "Кабинет обеззараживания",
  corridors = "Коридоры",
  cardiogram = "Кабинет кардиографии",
  ward = "Палата",
  training_room = "Лекционная комната",
  psychiatric = "Кабинет психиатра",
  operating_theatre = "Операционная",
  dna_fixer = "Кабинет исправления ДНК",
  tongue_clinic = "Кабинет обрезания языка",
  hair_restoration = "Кабинет восстановления волос",
  general_diag = "Общая диагностика",
  pharmacy = "Аптека",
  fracture_clinic = "Кабинет лечения переломов",
  toilets = "Туалет",
  electrolysis = "Кабинет электротерапии",
  x_ray = "Рентген-кабинет",
  blood_machine = "Кабинет анализа крови",
}
buy_objects_window = {
  price = "Стоимость: ",
  choose_items = "Выберите предметы",
  total = "Итого: ",
}
object = {
  chair = "Стул",
  litter = "Мусор",
  sofa = "Диван",
  operating_table = "Операционный стол",
  bench = "Скамья",
  scanner = "Сканер",
  couch = "Кушетка",
  blood_machine = "Анализатор крови",
  video_game = "Видеоигра",
  op_sink2 = "Раковина",
  door = "Дверь",
  auto_autopsy = "Автовскрывалка",
  reception_desk = "Регистратура",
  hair_restorer = "Оволоситель",
  projector = "Проектор",
  crash_trolley = "Скорая тележка",
  tv = "Ящик",
  ultrascanner = "Ультрасканер",
  surgeon_screen = "Хирургическая ширма",
  litter_bomb = "Мусорная бомба",
  inflator = "Надуватель",
  desk = "Письменный стол",
  pool_table = "Бильярд",
  x_ray_viewer = "Неготоскоп",
  radiation_shield = "Защита от излучения",
  bed = "Койка",
  swing_door2 = "Двустворчатая дверь",
  console = "Консоль",
  op_sink1 = "Раковина",
  bookcase = "Книжный шкаф",
  drinks_machine = "Автомат с газировкой",
  comfortable_chair = "Удобное кресло",
  skeleton = "Скелет",
  computer = "Компьютер",
  bin = "Козина для мусора",
  pharmacy_cabinet = "Аптечный шкаф",
  radiator = "Батарея",
  cast_remover = "Разгипсователь",
  atom_analyser = "Атомный анализатор",
  plant = "Растение",
  jelly_moulder = "Форма для желе",
  cardio = "Беговая дорожка",
  toilet = "Туалет",
  electrolyser = "Электролизатор",
  fire_extinguisher = "Огнетушитель",
  swing_door1 = "Двустворчатая дверь",
  lecture_chair = "Лекционный стул",
  screen = "Ширма",
  toilet_sink = "Раковина",
  shower = "Душ",
  gates_of_hell = "Врата в ад",
  slicer = "Языкорезка",
  dna_fixer = "Исправитель ДНК",
  x_ray = "Рентген",
  cabinet = "Картотека",
  lamp = "Лампа",
  entrance_left = "Левая входная дверь",
  table2 = "Стол",
  bed2 = "Кровать",
  bed3 = "Кровать",
  entrance_right = "Правая входная дверь",
  table1 = "Стол",
  rathole = "Норка крысы",
}
room_descriptions = {
  gp = {
    [1] = "Кабинет терапевта//",
    [2] = "Это основной диагностический кабинет в вашей больнице. Все новые пациенты приходят сюда чтобы узнать, что с ними не так. Отсюда они отправляются на дальнейшую диагностику или сразу на лечение. Вам может понадобиться несколько таких кабинетов, если пациентов будет слишком много. Чем просторнее помещение, и чем больше в нем предметов, тем выше престиж работающего здесь доктора. Впрочем, это относится ко всем кабинетам.//",
    [3] = "В кабинете терапевта может работать любой доктор.",
  },
  general_diag = {
    [1] = "Общая диагностика//",
    [2] = "Сюда направляются пациенты, которым требуется дополнительная диагностика. Здесь у врача значительно больше инструментов для обследования, чем у терапевта. Пациент вернется к терапевту с результатами обследования для постановки диагноза.//",
    [3] = "В кабинете общей диагностики может работать любой доктор.",
  },
  ultrascan = {
    [1] = "Ультрасканер//",
    [2] = "Ультрасканер - это практически вершина прогресса диагностического оборудования. Он очень дорогой, но он того стоит.//",
    [3] = "Ультрасканеру для полноценной работы требуется доктор. Также, ему требуется обслуживание.",
  },
  fracture_clinic = {
    [1] = "Лечение переломов.//",
    [2] = "Сюда приходят пациенты с поломанными костями. Используя мощный промышленный лазер, разгипсовочная машина срезает застывший гипс, что может вызывать незначительную агонию у пациента.//",
    [3] = "В этом кабинете работает медсестра. Машине также требуется частый ремонт.",
  },
  inflation = {
    [1] = "Кабинет надувания//",
    [2] = "В кабинет надувания направляют пациентов с выводящим из строя и очень болезненным недугом раздутой головы. Здесь их безразмерные черепа хлопнут и немедленно снова надуют до точно рассчитанного нормального давления.//",
    [3] = "В кабинете надувания может работать любой доктор. Аппарату требуется регулярный ремонт.",
  },
  jelly_vat = {
    [1] = "Лечение ожеления//",
    [2] = "Пациенты, страдающие забавной болезнью ожеления, должны дотрястись до этого кабинета, где их поместят в специальный бак. Медицинская наука не знает, что там происходит, но после процедуры им становится лучше.//",
    [3] = "В этом кабинете может работать любой доктор. Вам также понадобится рабочий для обслуживания машины.",
  },
  scanner = {
    [1] = "Сканер//",
    [2] = "При помощи этого сложного оборудования можно поставить очень точный диагноз.//",
    [3] = "Со сканером может работать любой доктор. Это устройство требует регулярного обслуживания.",
  },
  blood_machine = {
    [1] = "Анализатор крови//",
    [2] = "Эта машина разделяет кровь пациента на клетки и выясняет что с ними не в порядке.//",
    [3] = "С анализатором крови может работать любой доктор. Это устройство требует регулярного обслуживания.",
  },
  pharmacy = {
    [1] = "Аптека//",
    [2] = "Пациенты, которым поставлен диагноз и прописано лекарство, получают его в аптеке. Поскольку многие болезни излечиваются медикаментами, со временем тут может стать тесновато, и вам понадобится еще одна аптека.//",
    [3] = "В аптеке работает медсестра.",
  },
  cardiogram = {
    [1] = "Кардиография//",
    [2] = "Здесь пациентов проверяют на наличие болезней сердца и проводят стресс-тест на беговой дорожке. Затем с полученными результатами возвращают к терапевту.//",
    [3] = "В кардиографии может работать любой доктор. Беговой дорожке требуется регулярное обслуживание.",
  },
  ward = {
    [1] = "Палата//",
    [2] = "Во время обследования пациенты содержатся здесь под наблюдением медсестры. Также, тут они готовятся к операции.//",
    [3] = "В палате работает медсестра.",
  },
  psych = {
    [1] = "Психиатрия//",
    [2] = "Пациенты, страдающие от душевных недугов, должны посетить кабинет психиатра. Доктор обследует пациентов, и, если у них не все в порядке с головой, предложит прилечь на кушетку и побеседовать.//",
    [3] = "В этом кабинете может работать только специально обученный психиатр.",
  },
  staff_room = {
    [1] = "Комната персонала//",
    [2] = "После тяжелого рабочего дня, ваши сотрудники могут посетить эту комнату, чтобы отдохнуть и расслабиться. Усталые медики тормозят, хотят повышения зарплаты и могут даже уволиться. Также, они начинают чаще ошибаться. Убедитесь, что в вашей комнате достаточно места и развлечений для нескольких человек сразу.",
  },
  operating_theatre = {
    [1] = "Операционная//",
    [2] = "В этом важном помещении излечивают целый ряд заболеваний. Операционная должна быть просторной и хорошо оснащенной. Это очень важная часть любой больницы.//",
    [3] = "В операционной должны работать два квалифицированных хирурга.",
  },
  training = {
    [1] = "Лекционная//",
    [2] = "Ваши доктора могут повышать свою квалификацию в этой комнате. Лектор с дипломом хирурга, психиатра или исследователя может научить своих коллег всему, что знает. Те же, кто уже имеет диплом, здесь могут научиться лучше применять знания на практике.//",
    [3] = "Читать лекции здесь может только консультант.",
  },
  dna_fixer = {
    [1] = "Восстановление ДНК//",
    [2] = "Пациенты, имевшие несчастье войти в контакт с пришельцами из других миров, должны пройти процедуру починки ДНК. Поскольку восстановитель ДНК – машина сложная и высокотехнологичная, настоятельно рекомендуем разместить в кабинете огнетушитель, на всякий пожарный.//",
    [3] = "Восстановитель требует регулярного обслуживания. И работать с ним могут только доктора с дипломом исследователя.",
  },
  research = {
    [1] = "Исследовательский отдел//",
    [2] = "Здесь совершаются открытия и улучшаются существующие лекарства и методы лечения. Это очень полезный отдел, его работа творит чудеса в деле улучшения вашей статистики.//",
    [3] = "В исследовательском отделе могут работать только доктора с дипломом исследователя.",
  },
  hair_restoration = {
    [1] = "Восстановление волос//",
    [2] = "Машина восстановителя волос – последняя надежда для пациентов, страдающих плешивостью в терминальной стадии. При помощи этой машины доктор может быстро насадить совершенно новый волосяной покров.//",
    [3] = "В кабинете оволосителя может работать любой доктор. Время от времени машине требуется ремонт.",
  },
  electrolysis = {
    [1] = "Комната электролиза//",
    [2] = "Больные оволосением направляются в эту комнату, где специальная машина, называемая электролизатором, уничтожает излишние волосы и электрически запаивает поры при помощи состава, сильно напоминающего цемент.//",
    [3] = "В кабинете электролиза может работать любой доктор. Машина также требует обслуживания.",
  },
  slack_tongue = {
    [1] = "Лечение длинного языка//",
    [2] = "Пациенты с этим неутешительным диагнозом направляются в эту комнату для лечения. При помощи высокоточного оборудования, квалифицированный специалист возвращает языку нормальные размер и форму, а пациенту – хорошее самочувствие.//",
    [3] = "Здесь может работать любой доктор. Машину также надо иногда чинить.",
  },
  toilets = {
    [1] = "Туалет//",
    [2] = "Следуя зову природы, пациентам надо иногда облегчиться в комфортной обстановке ваших санитарных помещений. Вы можете установить дополнительные раковины и кабинки, если ожидаете наплыва посетителей. Иногда бывает полезно разместить дополнительные помещения в разных частях больницы.",
  },
  no_room = {
    [1] = "",
  },
  x_ray = {
    [1] = "Рентген//",
    [2] = "Сделанные при помощи специального излучения снимки внутренностей пациентов помогают врачам установить, что там не в порядке.//",
    [3] = "В кабинете рентгена может работать любой доктор. Также, машине требуется обслуживание.",
  },
  decontamination = {
    [1] = "Комната обеззараживания//",
    [2] = "Пациенты, подвергшиеся воздействию радиации, незамедлительно направляются в комнату обеззараживания. Приятный душ смоет с них всю ужасную радиацию и опасные отходы.//",
    [3] = "Оперировать душем может любой доктор. Также, машине требуется обслуживание.",
  },
  tv_room = {
    [1] = "Телевизионная комната не использовалась",
  },
}
place_objects_window = {
  place_objects_in_corridor = "Разместите эти предметы в коридорах.",
  place_windows = "Добавьте окон, если хотите, и нажмите «Подтвердить».",
  confirm_or_buy_objects = "Вы можете добавить, убрать или передвинуть объекты.",
  drag_blueprint = "Растяните комнату до желаемого размера.",
  place_door = "Разместите дверь",
  place_objects = "Выберите объект и переместите его на нужное место, потом подтвердите",
  pick_up_object = "Нажмите на объект, чтобы его поднять или выберете другую опцию из списка",
}
staff_class = {
  doctor = "Доктор",
  handyman = "Рабочий",
  receptionist = "Регистратор",
  nurse = "Медсестра",
  surgeon = "Хирург",
}
staff_descriptions = {
  good = {
    [1] = "Работает быстро и усердно. ",
    [2] = "Работает на совесть. ",
    [3] = "Мастер на все руки. ",
    [4] = "Легко заводит друзей и любит посмеяться. ",
    [5] = "Никогда не устает. Работает без остановки. ",
    [6] = "Имеет хорошее воспитание и утонченные манеры. ",
    [7] = "Проявляет талант и способности. ",
    [8] = "Очень основательно подходит к делу. ",
    [9] = "Никогда не сдается и всегда стремится к совершенству. ",
    [10] = "Помогает людям с улыбкой. ",
    [11] = "Всегда подбодрит и поможет. ",
    [12] = "Работает, как правило, хорошо и усердно. ",
    [13] = "Прилежно работает и ведет себя. ",
    [14] = "Никогда не подведет и не обидит. ",
    [15] = "Не оставит в беде. ",
  },
  misc = {
    [1] = "Играет в гольф. ",
    [2] = "Ныряет с аквалангом. ",
    [3] = "Делает скульптуры из льда. ",
    [4] = "Любит выпить. ",
    [5] = "Участвует в ралли. ",
    [6] = "Прыгает с тарзанкой. ",
    [7] = "Собирает подставки под пиво. ",
    [8] = "Любит прыгать в толпу со сцены. ",
    [9] = "Оглушительно пердит. ",
    [10] = "Любит расширять реки. ",
    [11] = "Варит самогон. ",
    [12] = "Собирает мебель своими руками. ",
    [13] = "Смотрит французское экспериментальное кино. ",
    [14] = "Играет на компьютере. ",
    [15] = "Водит грузовик. ",
    [16] = "Участвует в мотогонках. ",
    [17] = "Играет на скрипке и виолончели. ",
    [18] = "Обожает железнодорожные аварии. ",
    [19] = "Любит собак. ",
    [20] = "Слушает радио. ",
    [21] = "Часто принимает ванны. ",
    [22] = "Обучает резьбе по пальмам. ",
    [23] = "Делает мыльницы из овощей. ",
    [24] = "Особый констебль на полставки. ",
    [25] = "Бывший ведущий телевикторины. ",
    [26] = "Коллекционирует осколки времен ВМВ. ",
    [27] = "Переставляет мебель. ",
    [28] = "Слушает рейв и трип-хоп. ",
    [29] = "Любит злить насекомых при помощи дезодоранта. ",
    [30] = "Перебивает плохих комедиантов. ",
    [31] = "Шпионит на правительство. ",
    [32] = "Втайне садовник. ",
    [33] = "Провозит поддельные часы. ",
    [34] = "Поет рок'н'ролл. ",
    [35] = "Обожает дневные передачи. ",
    [36] = "Щекочет форель. ",
    [37] = "Завлекает туристов в музеи. ",
  },
  bad = {
    [1] = "Часто тормозит и дергается. ",
    [2] = "Невозможно заставить работать. ",
    [3] = "Ничего не умеет и не приносит пользы. ",
    [4] = "Хамит и ерничает. Не прощает и не забывает. ",
    [5] = "Быстро устает и на все жалуется. ",
    [6] = "Ничего не слышит. Пахнет капустой. ",
    [7] = "Плюет на работу. Предаст при первой возможности. ",
    [8] = "Ни о чем не думает и легко отвлекается. ",
    [9] = "Нервничает и часто ошибается. ",
    [10] = "Обижается и мстит за все. Ненавидит всех и вся. ",
    [11] = "Не соблюдает технику безопасности. ",
    [12] = "Видит работу в гробу. Настоящий лентяй. ",
    [13] = "Рискует зря и плюет на последствия. ",
    [14] = "Нагло врет и строит козни. ",
    [15] = "Дерзит и смотрит на всех свысока. ",
  },
}
tooltip = {
  build_room_window = {
    cost = "Цена выбранного кабинета",
    room_classes = {
      treatment = "Проказать процедурные кабинеты",
      diagnosis = "Показать комнаты для диагностики",
      facilities = "Показать служебные помещения",
      clinic = "Показать специализированные кабинеты для лечения",
    },
    close = "Ничего не строить и вернуться к игре",
  },
  hire_staff_window = {
    prev_person = "Предыдущий кандидат",
    cancel = "Отмена",
    psychiatrist = "Психиатр",
    surgeon = "Хирург",
    researcher = "Исследователь",
    salary = "Зарплата",
    next_person = "Следующий кандидат",
    nurses = "Посмотреть медсестер",
    handymen = "Посмотреть рабочих",
    doctors = "Посмотреть докторов",
    receptionists = "Посмотреть регистраторов",
    doctor_seniority = "Авторитет (Студент, Доктор, Консультант)",
    hire = "Нанять",
    qualifications = "Дополнительные дипломы доктора",
    staff_ability = "Компетентность",
  },
  place_objects_window = {
    confirm = "Подтвердить",
    cancel = "Отмена",
    pick_up = "Поднять объект",
    buy_sell = "Купить/продать",
  },
  rooms = {
    ultrascan = "Доктор обследует пациентов при помощи ультрасканера",
    research_room = "Исследователи придумывают новые лекарства и машины в исследовательском отделе",
    fracture_clinic = "Здесь медсестра снимает гипс с пациентов со сломанными костями",
    gps_office = "У терапевта пациенты начинают диагностику, и здесь же им сообщают неутешительные результаты",
    inflation = "При помощи надувателя доктор лечит пациентов с раздутой головой",
    staffroom = "В комнате персонала доктора и медсестры отдыхают и набираются сил",
    jelly_vat = "При помощи специальной машины доктор лечит ожеление",
    scanner = "Доктор использует сканер для диагностики пациентов",
    decontamination = "При помощи обеззараживающего душа доктор лечит облученных пациентов",
    pharmacy = "В аптеке медсестра раздает больным медикаменты",
    cardiogram = "Доктор снимает кардиограмму для диагностики пациентов",
    ward = "Палата используется как для диагностики, так и для лечения. Здесь пациенты готовятся к операции под наблюдением медсестры",
    training_room = "В лекционной консультант может обучать других докторов",
    operating_theatre = "В операционной работают сразу два хирурга",
    psychiatry = "Здесь квалифицированный психиатр обследует пациентов и вправляет мозги самым сумасшедшим",
    hair_restoration = "При помощи оволосителя доктор лечит плешивость",
    tongue_clinic = "При помощи языкорезки доктор подрезает длинные языки",
    dna_fixer = "Здесь доктор лечит пациентов с инопланетной ДНК",
    general_diag = "Здесь доктор проводит общий осмотр пациентов. Дешево и сердито",
    toilets = "Постройте туалеты, если не хотите чтобы пациенты загадили вам всю больницу",
    electrolysis = "При помощи электролизатора доктор лечит волосение",
    x_ray = "Доктор использует рентген для диагностики пациентов",
    blood_machine = "Доктор использует анализатор крови для диагностики пациентов",
  },
  objects = {
    litter = "Мусор: какому-то пациенту не удалось найти в вашей больнице мусорной корзины, и он бросил это прямо здесь",
    sofa = "Диван: если у вас в комнате отдыха нет ничего интереснее, то хотя бы можно посидеть на диване",
    bench = "Скамья: предоставляет одно сидячее место, скрашивая часы, проведенные в очередях",
    video_game = "Игральный автомат: предоставляет вашим сотрудникам возможность порубиться в Hi-Octane",
    auto_autopsy = "Автовскрывалка: очень помогает в исследовании заболеваний",
    reception_desk = "Регистратура: отсюда регистраторша направит пациента к врачу",
    tv = "Тель-а-визор: вы же не хотите, чтобы ваши сотрудники пропустили свои любимые передачи",
    inflator = "Надуватель: излечивает раздутие головы",
    desk = "Стол: надо ведь доктору куда-то поставить свой компьютер",
    pool_table = "Бильярдный стол: помогает вашим работникам расслабиться",
    bed = "Койка: на ней смогут прилечь те, кто уже не в силах стоять",
    bookcase = "Книжный шкаф: полон справочных материалов на медицинские темы",
    drinks_machine = "Торговый автомат: не дает пациентам умереть от жажды и приносит прибыль",
    skeleton = "Скелет: используется как учебное пособие и на Хэллоуин",
    computer = "Компьютер: незаменимый инструмент исследователя",
    bin = "Корзина: чтобы пациентам было куда деть свой мусор",
    pharmacy_cabinet = "Аптечный шкаф: тут хранятся все лекарства",
    radiator = "Батарея: поддерживает тепло в вашей больнице",
    atom_analyser = "Атомный анализатор: эта машина ускоряет все исследовательские процессы",
    plant = "Растение: нравится пациентам и очищает воздух",
    toilet = "Стульчак: пациенты... мм... пользуются им",
    fire_extinguisher = "Огнетушитель: несколько уменьшает опасность поломки машин",
    lecture_chair = "Лекционный стул: ваши доктора на нем сидят, записывают лекции, скучают и рисуют каракули. Чем больше стульев вы поставите, тем больше докторов сможет обучаться одновременно",
    toilet_sink = "Раковина: наиболее чистоплотные пациенты моют здесь свои грязные руки. Они будут очень недовольны, если не найдут свободной раковины",
    cabinet = "Картотека: содержит карточки пациентов, записи и научные документы",
  },
}
-- 4.2  Статус
queue_window = {
  num_in_queue = "Длина очереди",
  num_entered = "Всего посещений",
  max_queue_size = "Макс. длина",
  num_expected = "Ожидается",
}
tooltip = {
  handyman_window = {
    prio_machines = "Увеличить приоритет ремонта",
    prio_litter = "Увеличить приоритет уборки",
    prio_plants = "Увеличить приоритет поливки",
  },
  machine_window = {
    repair = "Вызвать рабочего для ремонта",
    name = "Название",
    close = "Закрыть",
    times_used = "Количество использований",
    status = "Состояние",
    replace = "Заменить машину",
  },
  patient_window = {
    graph = "Щелкните чтобы увидеть историю лечения или график график самочувствия",
    casebook = "Посмотреть статистику по болезни",
    close = "Закрыть",
    queue = "Посмотреть очередь",
    happiness = "Самочувствие пациента",
    warmth = "Согретость пациента",
    center_view = "Центрировать экран на пациенте",
    thirst = "Уровень жажды пациента",
    send_home = "Выставить из больницы",
    abort_diagnosis = "Отправить на лечение немедленно, не дожидаясь окончания диагностики",
  },
  staff_window = {
    doctor_seniority = "Авторитет (Студент, Доктор, Консультант)",
    psychiatrist = "Психиатр",
    close = "Закрыть окно",
    ability = "Компетентность",
    pick_up = "Взять",
    sack = "Уволить",
    surgeon = "Хирург",
    happiness = "Настроение",
    salary = "Ежемесячная зарплата",
    name = "Имя",
    tiredness = "Запас сил",
    center_view = "Левая кнопка - центрировать экран, правая - выбрать следующего сотрудника",
    skills = "Особые умения",
    researcher = "Исследователь",
    face = "Портрет - нажмите, чтобы перейти к экрану управления персоналом",
  },
}
-- 4.3  Запросы
confirmation = {
  abort_edit_room = "Вы сейчас строите или редактируете кабинет. Если все необходимое уже на месте, он будет построен, иначе же он будет удален. Продолжить?",
  return_to_blueprint = "Точно вернуться к режиму разметки?",
  delete_room = "Вы точно хотите удалить эту комнату?",
  quit = "Вы выбрали выход. А вы в этом уверены?",
  needs_restart = "Изменение этого параметра ребует перезапуска CorsixTH. Все несохраненные данные при этом будут потеряны. Продолжить?",
  overwrite_save = "В этом файле уже есть сохраненная игра. Перезаписать ее?",
  sack_staff = "Вы правда хотите уволить этого сотрудника?",
  replace_machine = "Вы правда хотите заменить %s за %d$?",
  restart_level = "Вы серьёзно хотите начать уровень заново?",
  maximum_screen_size = "Разрешение экрана, которое вы ввели, больше 3000 x 2000.  Большее разрешение возможно, но оно может потребовать более производительного оборудования, чтобы поддерживать играбельную частоту кадров.  Вы уверены, что хотите продолжить?",
  music_warning = "Перед тем, как выбрать mp3 в качестве игровой музыки, вам потребуется smpeg.dll или аналог для вашей операционной системы, иначе музыка не сможет быть проиграна. Вы уверены, что хотите продолжить?",
  remove_destroyed_room = "Вы хотите удалить комнату за $%d?",
  replace_machine_extra_info = "Новая машина будет иметь прочность %d (в настоящее время %d).",
}
pay_rise = {
  definite_quit = "Я увольняюсь, и точка. Я сыт по горло этим местом.",
  regular = {
    [1] = "Я крайне устаю. Мне нужен хороший отдых плюс повышение зарплаты на %d$, если хотите меня видеть на этой никчемной работе.",
    [2] = "Я очень устаю. Мне надо отдохнуть и не помешает получить надбавку в %d$ до %d$. Пошевеливайся, деспот.",
    [3] = "Ну все. Я тут тружусь как лошадь. Прибавьте мне %d$, а то уволюсь.",
    [4] = "Я в негодовании. Требую добавить к зарплате %d$, чтобы стало %d$, или я ухожу.",
    [5] = "Родители всегда говорили мне что в этом деле хорошо платят. Так что повысьте мне зарплату на %d$, или я пойду издавать компьютерные игры.",
    [6] = "С меня хватит. Платите мне как следует. Я хочу, чтобы мне повысили зарплату на %d$.",
  },
  poached = "Мне предлагают %d$ у %s. Платите мне не меньше, или я ухожу.",
}

-- 5.  Болезни
diseases = {
  general_practice = {
    name = "Обследование: терапевт",
  },
  diag_ward = {
    name = "Обследование: палата",
  },
  diag_ultrascan = {
    name = "Обследование: ультрасканер",
  },
  diag_blood_machine = {
    name = "Обследование: анализатор крови",
  },
  diag_x_ray = {
    name = "Обследование: рентген",
  },
  diag_psych = {
    name = "Обследование: психиатр",
  },
  diag_general_diag = {
    name = "Обследование: общая диагностика",
  },
  diag_cardiogram = {
    name = "Обследование: кардиограмма",
  },
  diag_scanner = {
    name = "Обследование: сканер",
  },
  autopsy = {
    name = "Вскрытие",
  },
  third_degree_sideburns = {
    cause = "Причина - непреодолимая тоска по семидесятым.",
    cure = "Лечение - психиатр должен, используя самые современные методы, убедить пациента, что чрезмерная волосатость уже не в моде.",
    name = "Бакенбарды третьей степени",
    symptoms = "Симптомы - длинные волосы, смешные штаны, обувь на платформе и сверкающий макияж.",
  },
  discrete_itching = {
    cause = "Причина - крошечные насекомые с очень острыми зубами.",
    cure = "Лечение - пациент выпивает липкий фармацевтический сироп, который защищает кожу.",
    name = "Спонтанное зудение",
    symptoms = "Симптомы - интенсивное чесание вплоть до воспламенения.",
  },
  the_squits = {
    cause = "Причина - поедание кусочков пиццы, упавших под плиту.",
    cure = "Лечение - клейкая смесь вязких фармацевтических реактивов сгущает все внутри у пациента.",
    name = "Метания",
    symptoms = "Симптомы - фу, какая гадость. Не будем об этом.",
  },
  spare_ribs = {
    cause = "Причина - сидение на холодном каменном полу.",
    cure = "Лечение - два хирурга должны удалить лишние ребра и завернуть их пациенту с собой.",
    name = "Лишние ребра",
    symptoms = "Симптомы - неприятные ощущения от массивной груди.",
  },
  king_complex = {
    cause = "Причина - дух Короля, который захватил контроль над разумом пациента.",
    cure = "Лечение - психиатр рассказывает пациенту как нелепо тот выглядит.",
    name = "Комплекс Короля",
    symptoms = "Симптомы - слабость к цветастой замшевой обуви и чизбургерам.",
  },
  fake_blood = {
    cause = "Причина - скорее всего, пациент стал жертвой розыгрыша.",
    cure = "Лечение - психиатр должен помочь пациенту успокоиться.",
    name = "Фальшивая кровь",
    symptoms = "Симптомы - красная жидкость в венах, которая испаряется при контакте с одеждой.",
  },
  invisibility = {
    cause = "Причина - укус радиоактивного (и, само собой, невидимого) муравья.",
    cure = "Лечение - напиток насыщенного цвета, приготовленный в аптеке, восстанавливает видимость пациента.",
    name = "Невидимость",
    symptoms = "Симптомы - пациент чувствует себя нормально и даже может использовать болезнь чтобы разыгрывать близких.",
  },
  golf_stones = {
    cause = "Причина - вдыхание ядовитого газа, содержащегося в мячиках для гольфа.",
    cure = "Лечение - образования удаляются хирургами в операционной.",
    name = "Мячики в почках",
    symptoms = "Симптомы - бред и чувство стыда.",
  },
  infectious_laughter = {
    cause = "Причина - просмотр классических комедий.",
    cure = "Лечение - квалифицированный психиатр должен напомнить пациенту, что не все в этой жизни смешно.",
    name = "Заразный смех",
    symptoms = "Симптомы - непроизвольное фырканье и повторение несмешных шуток.",
  },
  baldness = {
    cause = "Причина - вранье и придумавание небылиц с целью привлечения внимания.",
    cure = "Лечение - в ходе болезненной процедуры специальная машина плавно восстанавливает волосяной покров.",
    name = "Плешивость",
    symptoms = "Симптомы - блестящесть и смущение.",
  },
  heaped_piles = {
    cause = "Причина - привычка торчать возле питьевых фонтанчиков.",
    cure = "Лечение - приятная на вкус смесь сильных кислот растворяет кучи изнутри.",
    name = "Скученные кучи",
    symptoms = "Симптомы - у пациента такое чувство, будто он/она сидит на мешке с твердыми шариками.",
  },
  unexpected_swelling = {
    cause = "Причина - все внезапное.",
    cure = "Лечение - возбухание может быть уменьшено хирургами при помощи автогена.",
    name = "Внезапное возбухание",
    symptoms = "Симптом - возбухание.",
  },
  jellyitis = {
    cause = "Причина - пища, богатая желатином и избыток физической активности.",
    cure = "Лечение - пациента помещают в разжелетиватель в специальном кабинете.",
    name = "Ожеление",
    symptoms = "Симптомы - пациент чрезмерно трясется и часто падает.",
  },
  hairyitis = {
    cause = "Причина - длительные прогулки в свете луны.",
    cure = "Лечение - электролизатор удаляет волосы и запаивает поры.",
    name = "Оволосение",
    symptoms = "Симптомы - обостренное обоняние.",
  },
  alien_dna = {
    cause = "Причина - прыгающие личинки разумных видов пришельцев.",
    cure = "Лечение - в специальной машине ДНК извлекается, очищается от фрагментов пришельцев и быстро вставляется на место.",
    name = "ДНК пришельцев",
    symptoms = "Симптомы - постепенное превращение в пришельца и стремление уничтожить человечество.",
  },
  bloaty_head = {
    cause = "Причина - нюхание сыра и питье неочищенной дождевой воды.",
    cure = "Лечение - раздутая голова лопается и затем надувается до нормального давления при помощи хитроумной машины.",
    name = "Раздутие головы",
    symptoms = "Симптомы - очень неприятны для пациента.",
  },
  gastric_ejections = {
    cause = "Причина - острая мексиканская и индийская пища.",
    cure = "Лечение - выпивание специального связующего состава предотвращает какие бы то ни было извержения.",
    name = "Гастральные извержения",
    symptoms = "Симптомы - полупереваренная пища извергается из пациента в случайных местах.",
  },
  uncommon_cold = {
    cause = "Причина - крошечные капли соплей в воздухе.",
    cure = "Лечение - большой глоток необычной микстуры от кашля, сваренной из секретных ингредиентов в аптеке.",
    name = "Необычная простуда",
    symptoms = "Симптомы - сопли, чихание и обесцвечивание легких.",
  },
  corrugated_ankles = {
    cause = "Причина - езда через асфальтовые гребни на дорогах.",
    cure = "Лечение - слегка токсичная смесь трав и специй позволяет пациенту выпрямить лодыжки.",
    name = "Волнистые лодыжки",
    symptoms = "Симптомы - привычная обувь больше не подходит пациенту.",
  },
  sleeping_illness = {
    cause = "Причина - чрезмерная активность сонной железы в глотке пациента.",
    cure = "Лечение - медсестра должна дать пациенту большую дозу сильных стимуляторов.",
    name = "Сонная болезнь",
    symptoms = "Симптомы - непреодолимое желание поспать преследует пациента.",
  },
  sweaty_palms = {
    cause = "Причина - боязнь собеседований.",
    cure = "Лечение - психиатр должен уговорить пациента избавиться от этой выдуманной болезни.",
    name = "Потные ладони",
    symptoms = "Симптомы - рукопожатие пациента напоминает сжимание мокрой губки.",
  },
  serious_radiation = {
    cause = "Причина - жевание изотопов плутония.",
    cure = "Лечение - пациента нужно как следует промыть под обеззараживающим душем.",
    name = "Сильное облучение",
    symptoms = "Симптомы - пациент себя очень, очень плохо чувствует.",
  },
  gut_rot = {
    cause = "Причина - Старая добрая крепкая микстура от кашля тетушки О'Мэлли.",
    cure = "Лечение - медсестра приготовит специальную смесь химикатов для покрытия внутренностей пациента.",
    name = "Гнилые кишки",
    symptoms = "Симптомы - никакого кашля, но и никаких стенок желудка.",
  },
  iron_lungs = {
    cause = "Причина - городской смог и дым от шашлыков.",
    cure = "Лечение - два хирурга проводят операцию чтобы удалить затвердевшие легкие.",
    name = "Железные легкие",
    symptoms = "Симптомы - способность выдыхать огонь и громко кричать под водой.",
  },
  broken_wind = {
    cause = "Причина - упражнения на беговой дорожке после еды.",
    cure = "Лечение - насыщенная особыми водянистыми атомами микстура выпивается залпом.",
    name = "Бурные ветра",
    symptoms = "Симптомы - представляют опасность для находящих позади пациента.",
  },
  kidney_beans = {
    cause = "Причина - разгрызание ледяных кубиков в напитках.",
    cure = "Лечение - два хирурга должны удалить бобы, не прикасаясь к почкам.",
    name = "Бобы в почках",
    symptoms = "Симптомы - боль и частые визиты в туалет.",
  },
  transparency = {
    cause = "Причина - слизывание йогурта с крышечек упаковок.",
    cure = "Лечение - специально охлажденная и подкрашенная в аптеке вода вылечит эту болезнь.",
    name = "Прозрачность",
    symptoms = "Симптомы - плоть становится прозрачной и ужасно выглядит.",
  },
  broken_heart = {
    cause = "Причина - кто-нибудь более молодой, богатый и стройный чем пациент.",
    cure = "Лечение - два хирурга вскрывают грудную клетку и, затаив дыхание, аккуратно собирают сердце.",
    name = "Разбитое сердце",
    symptoms = "Симптомы - плач и боли в мышцах от разрывания праздничных фотографий.",
  },
  slack_tongue = {
    cause = "Причина - хроническое обсуждение мыльных опер.",
    cure = "Лечение - язык помещается в языкорезку и укорачивается быстро, точно, безжалостно.",
    name = "Длинный язык",
    symptoms = "Симптомы - язык примерно в пять раз увеличен в размерах.",
  },
  tv_personalities = {
    cause = "Причина - просмотр телепередач в дневное время.",
    cure = "Лечение - квалифицированный психиатр должен убедить пациента выкинуть телевизор и купить радио.",
    name = "Звезда экрана",
    symptoms = "Симптомы - пациент думает, что может вести собственное кулинарное шоу.",
  },
  ruptured_nodules = {
    cause = "Причина - прыжки с тарзанкой в холодную погоду.",
    cure = "Лечение - хирург удаляет грыжу твердой, уверенной рукой.",
    name = "Грыжа",
    symptoms = "Симптомы - невозможность сидеть с комфортом.",
  },
  fractured_bones = {
    cause = "Причина - падение с большой высоты на бетонные поверхности.",
    cure = "Лечение - сперва накладывается гипс, затем он удаляется при помощи устройства с лазером.",
    name = "Сломанные кости",
    symptoms = "Симптомы - громкий треск и неспособность использовать поврежденные конечности.",
  },
  chronic_nosehair = {
    cause = "Причина - высокомерное фыркание в присутствии менее успешных людей.",
    cure = "Лечение - отвратительное противоволосяное зелье приготавливается в аптеке.",
    name = "Хроническое носоволосение",
    symptoms = "Симптомы - нособорода, в которой можно свить гнездо.",
  },
  pregnancy = {
    cure = "Вылечено - ребенка достали в Операционной, отмыли и познакомили с пациентом.",
    cause = "Причина - отключение электричества в жилых районах.",
    name = "Беременность",
    symptoms = "Симптомы - странное питание с последующей непроходимостью кишечника.",
  },
}

-- 6.  Факсы
fax = {
  --  Эпидемия
  epidemic = {
    cover_up_explanation_1 = "Или вы можете попытаться вылечить всех зараженных, пока про это не узнали в министерстве здравоохранения.",
    cover_up_explanation_2 = "Если к приезду инспектора эпидемия все еще будет бушевать, приготовьтесь к неприятностям.",
    choices = {
      cover_up = "Попытаться вылечить всех зараженных пациентов пока есть время и пока он еще в больнице.",
      declare = "Объявить об эпидемии. Признать свою вину и заплатить штраф.",
    },
    disease_name = "Ваши доктора обнаружили особо заразный подвид %s.",
    declare_explanation_fine = "Вы можете объявить об эпидемии, заплатить штраф в %d$, тогда вам немедленно окажут помощь в вакцинации. Ваша репутация несколько пострадает.",
  },
  epidemic_result = {
    fine_amount = "Правительство объявило чрезвычайное положение, а вас оштрафовали на %d$.",
    close_text = "Ура!",
    hospital_evacuated = "У комиссии не осталось другого выбора, кроме как объявить эвакуацию.",
    succeeded = {
      part_1_name = "До департамента здоровья дошли слухи, что в вашей больнице бушует эпидемия %s.",
      part_2 = "Однако, инспектору не удалось найти им подтверждение.",
    },
    compensation_amount = "Правительство решило компенсировать ущерб, который эти враки нанесли репутации вашей больницы, в сумме %d$.",
    failed = {
      part_1_name = "В попытке скрыть наличие заразной инфекции %s,",
      part_2 = "ваши сотрудники вызвали распространение болезни по округе.",
    },
    rep_loss_fine_amount = "Журналисты уже заточили карандаши. Ваша репутация серьезно пострадает. К тому же, вас оштрафовали на %d$.",
  },
  --  Визит шишки
  vip_visit_query = {
    choices = {
      invite = "Отправить шишке официальное приглашение",
      refuse = "Наврать что-нибудь, чтобы не приходил",
    },
    vip_name = "%s выразил желание посетить вашу больницу",
  },
  vip_visit_result = {
    telegram = "Телеграмма!",
    remarks = {
      [1] = "Что за невероятная больница! Если я вдруг заболею, отвезите меня туда.",
      [2] = "Вот это я понимаю - больница!",
      [3] = "Это супербольница. Уж я-то в них разбираюсь.",
      [4] = "Какая хорошая больница! Спасибо за приглашение.",
      [5] = "Хмм... Определенно, неплохое медицинское учреждение.",
      [6] = "Мне очень понравилась ваша милая больничка. Ну, кто со мной в ресторан?",
      [7] = "Что ж, я видал и похуже. Им есть куда расти.",
      [8] = "Не знаю, стоит ли туда обращаться, если почувствуете себя неважно.",
      [9] = "Что я могу сказать, больница как больница. Я ожидал большего.",
      [10] = "Не надо было мне приходить. Лучше бы я просидел четырехчасовую оперу!",
      [11] = "Мне до сих пор не по себе. Они правда называют свое заведение больницей? Больше похоже на свинарник!",
      [12] = "Я сыт по горло визитами в подобные выгребные ямы и постоянным вниманием прессы! Я подаю в отставку.",
      [13] = "Ну и свалка! Я приложу все усилия чтобы ее закрыли.",
      [14] = "Никогда не видел больницы хуже. Какой позор!",
      [15] = "Я потрясен. Это нельзя назвать больницей! Мне надо выпить.",
      free_build = {
        [1] = "У вас очень милая больница. Не сложно будет заставить ее работать без ограничений по деньгам, правда?",
        [2] = "Я не экономист, но я думаю что я тоже смогу управлять этой больницей. Если понимаете о чем это я...",
        [3] = "Отлично работающая больница. Берегитесь кризисов! Хотя... вам тут не о чем беспокоиться.",
      },
    },
    rep_boost = "Ваша репутация улучшилась.",
    vip_remarked_name = "После посещения вашей больницы, %s заметил:",
    cash_grant = "Вам выдали грант в размере %d$.",
    rep_loss = "Ваша репутация пострадала.",
    close_text = "Спасибо за приглашение.",
  },
  --  Болезни
  disease_discovered = {
    discovered_name = "Ваша команда обнаружила новое заболевание. Это %s",
    can_cure = "Вы можете вылечить эту болезнь.",
    close_text = "Новое состояние было обнаружено.",
    need_to_build = "Вы должны построить %s чтобы вылечить это.",
    need_to_build_and_employ = "Если вы построите %s и наймете %s то сможете преуспеть.",
    need_to_employ = "Наймите %s для того чтобы справиться с этим кризисом.",
  },
  disease_discovered_patient_choice = {
    need_to_build = "Для лечения нам потребуется %s.",
    need_to_employ = "Наймите %s чтобы вылечить это.",
    what_to_do_question = "Что нам делать с этим пациентом?",
    guessed_percentage_name = "Мы не совсем уверены, что с этим пациентом. Существует вероятность в %d% что это %s",
    choices = {
      send_home = "Отправить пациента домой.",
      research = "Отправить пациента в исследовательский отдел.",
      wait = "Задержать пациента в больнице на какое-то время.",
    },
    disease_name = "Ваша команда обнаружила новое заболевание. Это %s",
    need_to_build_and_employ = "Можно будет попробовать, если вы построите %s и наймете %s .",
    can_not_cure = "Мы не можем это вылечить.",
  },
  diagnosis_failed = {
    choices = {
      send_home = "Отправить пациента домой.",
      take_chance = "Рискнуть и попытаться вылечить.",
      wait = "Задержать пациента, пока вы не построите еще кабинетов диагностики.",
    },
    situation = "Мы проверили этого пациента на всех наших машинах, но так и не поняли, что с ним случилось.",
    what_to_do_question = "Что нам с ним делать?",
    partial_diagnosis_percentage_name = "Есть шанс в %d%, что мы правильно угадаем какой вид %s у этого пациента.",
  },
  --  Чрезвычайная ситуация
  emergency = {
  locations = {
    [1] = "Новоуренгойский химзавод",
    [2] = "Фальшивый Университет",
    [3] = "Центр Принудительного Озеленения",
    [4] = "Институт Разработки Опасных Штук",
    [5] = "Клуб Хороших Танцоров",
    [6] = "Издательство «МакулатураПресс»",
    [7] = "Похоронное бюро «Безенчук и нимфы»",
    [8] = "Китайский ресторанчик дяди Вонга",
    [9] = "ГлавХимСбытСтыдЗагранПоставка",
  },
    num_disease = "У нас тут %d человек с диагнозом %s и им требуется немедленное лечение.",
    cure_possible_drug_name_efficiency = "У вас есть все необходимое оборудование и специалисты. У вас есть нужное лекарство. Это %s и оно эффективно на %d%",
    cure_not_possible_employ = "Вам потребуется нанять %s",
    cure_not_possible = "Сейчас вы не можете это вылечить.",
    cure_possible = "У вас есть все необходимое оборудование и специалисты, так что вы, наверное, справитесь.",
    choices = {
      accept = "Да. Я разберусь с этой ситуацией.",
      refuse = "Нет. Я отказываюсь в этом участвовать.",
    },
    location = "На предприятии %s чрезвычайная ситуация.",
    cure_not_possible_build = "Вам надо будет построить %s",
    cure_not_possible_build_and_employ = "Вам надо будет построить %s и нанять %s",
    bonus = "Вознаграждение за помощь составит %d. Если вы не справитесь, ваша репутация серьезно пострадает.",
    free_build = "Если вы преуспеете, то ваша репутация повысится, если облажаетесь, то она будет серьезно подпорчена.",
    num_disease_singular = "Тут 1 пациент с %s и они требуют немедленого внимания.",
  },
  emergency_result = {
    earned_money = "Из всей суммы %d$ вы заработали %d$.",
    close_text = "Нажмите чтобы закрыть.",
    saved_people = "Вы спасли %d из %d человек.",
  },
  choices = {
    return_to_main_menu = "Вернуться в главное меню",
    accept_new_level = "Перейти к следующему уровню",
    decline_new_level = "Продолжить играть ещё некоторое время",
  },
  debug_fax  = {
    text2 = "ВСЕГО ЛЮДЕЙ В БОЛЬНИЦЕ %d ПРОВЕРЕНО %d",
    text7 = "РЕПУТАЦИЯ: %d ОЖИДАЕТСЯ %d СНИЖЕНИЕ %d",
    text9 = "КАТАСТРОФЫ %d РАЗРЕШЕНЫ (MTHS) %d (%d)СНИЖЕНИЕ %d",
    text4 = "ФАКТОРЫ   : ДОКТОРА %d  МЕДСЕСТРЫ %d  ТЕРРИТОРИЯ %d  КАБИНЕТ %d  СТОИМОСТЬ %d",
    text1 = "ЛУЧШИЙ СЧЕТ %d",
    text6 = "СЛЕДУЮЩИЕ ФАКТОРЫ ТАК ЖЕ ПРИМЕНЕНЫ",
    close_text = "Да, Да, Да!",
    text3 = "КОЛИЧЕСТВА  : ДОКТОРА %d  МЕДСЕСТРЫ %d  ТЕРРИТОРИЯ %d  КАБИНЕТЫ %d  СТОИМОСТЬ %d",
    text5 = "CONTRIBN : ДОКТОРА %d  МЕДСЕСТРЫ %d  ТЕРРИТОРИЯ %d  КАБИНЕТЫ %d  СТОИМОСТЬ %d ПРОЦЕНТ(ОВ)",
    text8 = "AMENITIES %d PEEPS HANDLED %d REDUCTION %d",
    text10 = "УБИЙСТВА %d ДОПУЩЕНО (MTHS) %d (%d) СНИЖЕНИЕ %d",
    text11 = "пациентОВ В ЭТОМ МЕСЯЦЕ %d",
  },
}

-- 7.  Советчик
adviser = {
  tutorial = {
    build_reception = "Привет. Прежде всего, вашей новой больнице понадобится регистратура. Выберите ее в меню обстановки коридоров.",
    order_one_reception = "Щелкните один раз на мигающей строке, чтобы заказать стойку регистратуры.",
    accept_purchase = "Щелкните на мигающей кнопке, чтобы подтвердить заказ.",
    reception_invalid_position = "Стойка сейчас серого цвета, потому что ее нельзя разместить здесь. Попробуйте передвинуть или развернуть ее.",
    rotate_and_place_reception = "Пощелкайте правой кнопкой, чтобы развернуть стойку и установите ее левой кнопкой.",
    hire_receptionist = "А еще вам понадобится регистратор, чтобы принимать новых посетителей.",
    select_receptionists = "Нажмите мигающую кнопку, чтобы просмотреть регистраторов, которые ищут работу. Число на кнопке показывает, сколько кандидатур доступно.",
    next_receptionist = "Это резюме первой регистраторши в нашем списке. Нажмите мигающую кнопку, чтобы посмотреть следующее.",
    prev_receptionist = "Нажмите мигающую кнопку, чтобы вернуться к предыдущему резюме.",
    choose_receptionist = "Выберите регистратора, чьи профессиональные способности и зарплата вас устраивают и нажмите мигающую кнопку чтобы нанять ее.",
    receptionist_invalid_position = "Здесь ее поставить нельзя.",
    place_receptionist = "Поставьте вашу новую регистраторшу, где хотите. Она достаточно умна, чтобы добраться до своего стола.",
    build_gps_office = "Чтобы начать прием пациентов, первым делом постройте кабинет терапевта.",
    select_diagnosis_rooms = "Нажмите мигающую кнопку, чтобы увидеть список комнат диагностики.",
    click_gps_office = "Нажмите мигающую кнопку, чтобы выбрать кабинет терапевта.",
    click_and_drag_to_build = "Для начала решите, какого размера будет новый кабинет. Удерживайте левую кнопку мыши и растяните чертеж до нужного размера.",
    room_too_small = "Чертеж сейчас красного цвета потому, что он слишком мал. Растащите его побольше.",
    room_in_invalid_position = "Ой! Такой чертеж не пойдет, красная область перекрывает другие кабинеты или находится за стенами больницы.",
    room_big_enough = "Такого размера достаточно. Вы можете передвинуть кабинет или изменить размер еще раз, если хотите.",
    place_door = "Двигайте мышью вдоль стен кабинета, чтобы выбрать место для двери.",
    door_in_invalid_position = "Нет! Здесь нельзя сделать вход в кабинет. Щелкните где-нибудь на стене чертежа.",
    place_windows = "Проделайте несколько окон точно так же, как вы сделали дверь. Это совсем не обязательно, но так у ваших работников будет, куда глазеть в свободное время.",
    window_in_invalid_position = "Тут нельзя сделать окно. Будьте добры указать другое место на стене кабинета.",
    place_objects = "Правая кнопка вращает мебель, а левая устанавливает ее.",
    object_in_invalid_position = "Это предмет нельзя поставить здесь. Пожалуйста, переместите его или попробуйте повращать, возможно он станет сюда боком.",
    confirm_room = "Нажмите мигающую кнопку, чтобы завершить строительство, или нажмите на крестик, чтобы вернуться к предыдущему шагу.",
    information_window = "Справочное сообщение рассказывает вам о кабинете терапевта, который вы только что построили.",
    hire_doctor = "Чтобы обследовать и лечить пациентов, вам понадобится доктор.",
    select_doctors = "Нажмите мигающую кнопку, чтобы просмотреть докторов, которые ищут работу.",
    choose_doctor = "Как следует изучите резюме и рекомендации кандидатов прежде чем сделаете выбор.",
    place_doctor = "Поставьте доктора где-нибудь в пределах больницы. Он направится в кабинет терапевта, когда к вам придет первый пациент.",
    doctor_in_invalid_position = "Эй! Тут его поставить нельзя.",
    start_tutorial = "Прочитайте ваше задание а потом нажмите левую кнопку мыши, чтобы начать обучение.",
    room_too_small_and_invalid = "Кабинет слишком маленький, да еще размещен в недопустимом месте.",
    build_pharmacy = "Поздравляем! Теперь постройте Аптеку и наймите Медсестру, чтобы у вас получилась работающая больница.",
  },
  epidemic = {
    hurry_up = "Если что-то не сделать с этой эпидемией, мы окажемся в беде по самые ноздри. Шевелитесь!",
    serious_warning = "Эта заразная болезнь распространяется с невиданной скоростью. Сделайте же что-нибудь!",
    multiple_epidemies = "Похоже, у нас тут несколько эпидемий сразу. Какой кошмар.",
  },
  staff_advice = {
    need_handyman_machines = "Вам понадобится рабочий, чтобы ремонтировать машины в больнице.",
    need_doctors = "У вас не хватает врачей. Можно попробовать отправить самых лучших докторов в кабинеты с наибольшими очередями, вдруг поможет.",
    need_handyman_plants = "Вам понадобится рабочий, чтобы поливать растения.",
    need_handyman_litter = "Посетители совсем загадили нашу больницу. Наймите рабочего, чтобы подметать за ними.",
    need_nurses = "Вам нужно нанять медсестру. Аптека и палата не могут работать сами по себе.",
    too_many_doctors = "У вас слишком много докторов. Некоторые из них болтаются без дела.",
    too_many_nurses = "Я думаю что у вас слишком много медсестер... Они вам так нравятся?",
  },
  earthquake = {
    damage = "От землетрясения пострадали %d машин и %d человек.",
    alert = "Приближается землетрясение. Ваши машины могут пострадать от него, а если они в плохом состоянии, то и вовсе развалиться.",
    ended = "Фух. Это было довольно сильным, примерно %d по шкале Рихтера.",
  },
  surgery_requirements = {
    need_surgeons_ward_op = "Чтобы выполнять операции, вам надо нанять двух хирургов, а также построить палату и операционную.",
    need_surgeon_ward = "Чтобы начать оперировать, вам нужен еще один хирург и палата.",
  },
  vomit_wave = {
    started = "Похоже, в нашей больнице завелся рвотный вирус. Если бы вы поддерживали чистоту, этого бы не случилось. Наймите больше рабочих.",
    ended = "Уф! Похоже, волна тошноты отступила. На будущее, постарайтесь содержать больницу в чистоте.",
  },
  level_progress = {
    halfway_lost = "Вы на полпути к поражению.",
    dont_kill_more_patients = "Вы больше не можете себе позволить убивать пациентов.",
    another_patient_killed = "Ну вот! Еще один склеил ласты. И таких уже %d по больнице.",
    halfway_won = "Вы на полпути к победе.",
    close_to_win_increase_value = "Вы почти выиграли. Увеличьте стоимость больницы на %d.",
    financial_criteria_met = "Вы уже заработали достаточно денег. Не давайте балансу опуститься ниже %d и продолжайте эффективно управлять больницей.",
    nearly_won = "Вы уже почти выграли этот уровень.",
    hospital_value_enough = "Не давайте стоимости больницы упасть ниже %d и разберитесь с остальными проблемами, чтобы победить.",
    another_patient_cured = "Отлично, еще один пациент покинул больницу живым и здоровым. Мы вылечили уже %d.",
    three_quarters_lost = "Вы на три четверти проиграли этот уровень.",
    reputation_good_enough = "Хорошо, ваша репутация достаточно высока. Не опускайте ее ниже %d и разберитесь с имеющимися проблемами, чтобы победить.",
    cured_enough_patients = "Вы вылечили достаточно пациентов, но ваша больница еще недостаточно хороша.",
    nearly_lost = "Еще чуть-чуть - и вы проиграете.",
    improve_reputation = "Вам надо поднять репутацию еще на %d, чтобы выиграть этот уровень.",
    three_quarters_won = "Вы прошли три четверти пути к победе.",
    cured_enough_patients = "Вы вылечили достаточно пациентов, но вам нужно привести свою больницу в порядок, чтобы пройти уровень.",
    hospital_value_enough = "Держите стоимость вашей больницы выше %d и решайте другие проблемы, чтобы выиграть уровень.",
  },
  staff_place_advice = {
    receptionists_only_at_desk = "Регистраторы могут работать только в регистратуре.",
    only_psychiatrists = "В психиатрии могут работать только доктора с дипломом психиатра.",
    only_surgeons = "Только хирурги могут работать в операционной.",
    only_doctors_in_room = "Только Доктора могут работать в %s",
    only_nurses_in_room = "Только Медсестры могут работать в %s",
    nurses_cannot_work_in_room = "Медсестры не могут работать в %s",
    only_researchers = "Доктора могут работать в кабинете исследователей, только если у них есть квалификация исследователя.",
    doctors_cannot_work_in_room = "Доктора не могут работать в %s",
  },
  room_forbidden_non_reachable_parts = "Так вы заблокируете доступ к другим частям больницы.",
  research = {
    machine_improved = "%s улучшен вашим исследовательским отделом.",
    drug_fully_researched = "Вы исследовали %s на 100%.",
    new_machine_researched = "Изобретена новая %s.",
    drug_improved = "Исследовательский отдел улучшил ваше лекарство от %s.",
    drug_improved_1 = "Лекарство %s было улучшено Вашим департаментом исследований.",
    new_available = "Новый %s стал доступен.",
    new_drug_researched = "Было исследовано новое лекарство для лечения  %s ",
    autopsy_discovered_rep_loss = "О вашей машине Автоматического Вскрытия стало известно. Ждите негативную реакцию общественности.",
  },
  boiler_issue = {
    minimum_heat = "Я вас везде ищу! Паровой котел в подвале развалился. Скоро у нас в больнице станет весьма прохладно.",
    maximum_heat = "Паровой котел в подвале заклинило! Регулятор температуры вышел из строя и мы тут все скоро помрем от жары! Можно попробовать поставить еще автоматов с газировкой.",
    resolved = "Ну слава Богу! Система отопления снова работает как надо. Теперь температура в больнице станет нормальной.",
  },
  room_requirements = {
    research_room_need_researcher = "В исследовательском отделе должен работать доктор-исследователь.",
    op_need_another_surgeon = "Вам нужен еще один хирург, чтобы операционная наконец заработала.",
    op_need_ward = "Вам нужна палата, чтобы готовить пациентов к операции.",
    reception_need_receptionist = "Прием пацентов ведет регистратор.",
    psychiatry_need_psychiatrist = "Раз уж у вас есть кабинет психиатра, наймите и самого психиатра.",
    pharmacy_need_nurse = "Наймите медсестру, чтобы работать в аптеке.",
    ward_need_nurse = "Вам нужно нанять медсестру на работу в этой палате.",
    op_need_two_surgeons = "Наймите двух хирургов, чтобы начать выполнять операции.",
    training_room_need_consultant = "Вам нужен консультант, чтобы читать лекции.",
    gps_office_need_doctor = "Вам нужно нанять доктора, который будет вести прием в этом кабинете.",
  },
  goals = {
    win = {
      money = "Заработайте еще %d$, чтобы соответствовать финансовым требованиям этого уровня.",
      cure = "Вылечите еще %d пациентов, чтобы выиграть этот уровень.",
      reputation = "Поднимите свою репутацию до %d, чтобы удолетворить требования уровня.",
      value = "Вам нужно поднять стоимость больницы до %d$",
    },
    lose = {
      kill = "Убейте еще %d пациентов и вы проиграете!",
    },
  },
  warnings = {
    charges_too_low = "Вы мало просите за свои услуги. Хоть это и привлекает новых клиентов, вы с них много не получите.",
    charges_too_high = "У вас очень высокие цены. Это может временно поднять доходы, но так вы отпугиваете потенциальных клиентов.",
    staff_overworked = "Ваши люди сильно устают. От этого они работают кое-как и могут соверщать катастрофические ошибки.",
    doctors_tired = "Ваши доктора сильно устали. Скорее разрешите им отдохнуть.",
    people_did_it_on_the_floor = "У одного из пациентов иссякло терпение. Теперь кому-то придется все это отмывать.",
    queues_too_long = "У вас в больнице длинные очереди.",
    money_very_low_take_loan = "Ваш банковский баланс ниже плинтуса. Я слышала, у них там займы выдают.",
    patients_very_thirsty = "Ваши пациенты страдают от жажды. Если вы не поставите торговые автоматы, они пойдут пить домой, а лечиться - в другую больницу!",
    machinery_very_damaged = "Срочно найдите ремонтника, чтобы чинить ваши машины, а то кто-нибудь серьезно пострадает!",
    handymen_tired2 = "Ваши рабочие спят на ходу. Немедленно отправьте их в комнату отдыха.",
    desperate_need_for_watering = "Ваши растения умирают от жажды. Наймите рабочего, чтобы поливать их.",
    nurses_tired = "Ваши медсестры валятся с ног от усталости. Им очень нужен отдых.",
    too_much_litter = "У вас проблема с мусором. Ее можно решить, наняв еще рабочих.",
    reception_bottleneck = "Регистратура не справляется с наплывом посетителей. Вам нужно расширить ее и нанять еще регистратора.",
    place_plants4 = "Поставьте еще горшков с растениями, чтобы облегчить страдания пациентов.",
    change_priorities_to_plants = "Прикажите вашим рабочим чаще поливать растения.",
    staff_too_hot = "Вашим сотрудникам жарко. Уберите лишние батареи из кабинетов или уменьшите нагрев.",
    finanical_trouble2 = "Начинайте зарабатывать деньги или окажетесь за воротами. Потеряйте еще %d$ и вы проиграете.",
    plants_thirsty = "Присматривайте за растениями, их не помешает поливать почаще.",
    litter_everywhere = "У вас свалка, а не больница. Направьте еще рабочих на уборку.",
    nurses_tired2 = "Ваши медсестры засыпают на работе. Отправьте их отдыхать.",
    plants_dying = "Ваши растения засыхают на глазах, они в жизни не видели лейки. Мертвые растения нагоняют тоску на пациентов.",
    reduce_staff_rest_threshold = "Я тут подумала, может стоит уменьшить порог усталости для персонала в настройках политики больницы? Я не то, что бы настаиваю.",
    more_toilets = "Больнице нужны туалеты. Ваши клиенты с трудом сдерживают себя.",
    hospital_is_rubbish = "Везде говорят, что ваша больница ни к черту. Это ничем не помогает нам привлекать новых клиентов.",
    pay_back_loan = "У вас полно денег. Как насчет возврата долгов?",
    financial_trouble3 = "Состояние вашего банковского счета внушает опасения. Вам очень нужны деньги. Вы всего в %d$ от банкротства.",
    bankruptcy_imminent = "Эй! Еще немного и вы обанкротитесь. Тратьте осторожнее!",
    build_toilet_now = "Терпение ваших клиентов подходит к концу. Немедленно постройте туалет, или последствия не заставят себя ждать. И перестаньте ухмыляться, это серьезно!",
    patient_stuck = "Кто-то заблудился в ваших коридорах. У вас тут больница или парк развлечений?",
    no_patients_last_month = "В этом месяце у нас не было ни одного клиента. Вот так сюрприз.",
    more_benches = "Не помешает поставить скамеек. Не заставляйте больных стоять.",
    many_epidemics = "Похоже, у нас тут несколько эпидемий сразу. Это может обернуться серьезными проблемами.",
    place_plants_to_keep_people = "Люди злятся и уходят. Может горшков с цветами поставить?",
    patients_thirsty2 = "Пациенты хотят пить. Купите еще торговых автоматов или переставьте те, что есть, поудобнее.",
    money_low = "У вас заканчиваются деньги!",
    staff_unhappy = "Ваши сотрудники недовольны работой. Попробуйте подбодрить их премиями, а лучше постройте комнату персонала. Еще можно изменить политику больницы.",
    people_freezing = "Невероятно, в наш век центрального отопления ваши пациенты дрожат от холода. Поставьте батареи отопления и увеличьте нагрев.",
    need_toilets = "Пациентам нужны туалеты. И, желательно, поскорее.",
    nobody_cured_last_month = "В прошедшем месяце вы никого не вылечили.",
    patients_very_cold = "Пациенты замерзают. Увеличьте нагрев и поставьте побольше батарей в больнице.",
    build_toilets = "Немедленно постройте туалет или столкнетесь с антисанитарными последствиями. А запах...",
    many_killed = "Вы уже убили %d человек. Вы же их вроде лечить должны.",
    place_plants2 = "Люди уходят. Может, им не хватает зеленых растений?",
    staff_tired = "Ваши сотрудники невероятно устали. Если вы не дадите им отдохнуть в комнате персонала, они могут слететь с катушек.",
    machines_falling_apart = "Ваши машины разваливаются. Наймите ремонтника немедленно!",
    patients_unhappy = "Людям не нравится ваша больница. Предпримите что-нибудь по этому поводу.",
    place_plants3 = "Пациенты пребывают в печали. Поставьте горшков с цветами, чтобы подбодрить их.",
    staff_unhappy2 = "Ваши сотрудники недовольно ворчат. Скоро они захотят повышения зарплаты.",
    cash_low_consider_loan = "У вас на счету негусто. Как насчет кредита?",
    queue_too_long_at_reception = "У вас в регистратуре огромная очередь. Поставьте еще одну стойку и наймите регистратора.",
    queue_too_long_send_doctor = "В больнице огромная очередь в %s. Убедитесь, что там ведется прием.",
    financial_trouble = "Ваше финансовое положение удручает. Сделайте же что-нибудь! Потратьте еще %d$ и вы проиграете!",
    doctors_tired2 = "Ваши доктора невероятно устали. Им нужен отдых.",
    handymen_tired = "Ваши рабочие невероятно устали. Им нужен отдых.",
    patient_leaving = "Вот уходит пациент. Причина? У вас никчемная и бесполезная больница.",
    machinery_damaged2 = "Вашим машинам требуется ремонт, наймите рабочего.",
    patients_leaving = "Клиенты уходят. Сделайте вашу больницу более терпимой, поставив скамейки, растения, автоматы с газировкой и прочее.",
    epidemic_getting_serious = "Эта заразная болезнь быстро распространяется. Сделайте же что-нибудь!",
    machinery_damaged = "Быстрее почините свои машины. Скоро они начнут ломаться.",
    people_have_to_stand = "Несчастные больные вынуждены стоять. Поставьте еще скамеек.",
    build_staffroom = "Немедленно постройте комнату персонала. Ваши люди скоро начнут падать в обморок от усталости. Неужели для вас нет ничего святого!",
    machinery_slightly_damaged = "Оборудование вашего госпиталя понемногу изнашивается. Не забывайте чинить его время от времени.",
    need_staffroom = "Вашим сотрудникам нужна комната для отдыха.",
    patients_getting_hot = "В вашей больнице слишком жарко. Пожалуйста, снизьте нагрев или уберите часть батарей.",
    machinery_deteriorating = "Ваши машины начали изнашиваться от частого использования. Присматривайте за ними.",
    patients_too_hot = "Пациенты жалуются на жару. Уберите лишние батареи, снизьте температуру или поставьте еще автоматов с газировкой.",
    patients_thirsty = "Пациенты хотят пить. Может быть, стоит поставить торговые автоматы?",
    machine_severely_damaged = "%s скоро совсем развалится.",
    litter_catastrophy = "Мусор в вашей больнице выходит из под контроля. Скорее направьте еще рабочих на уборку!",
    staff_very_cold = "Сотрудники жалуются на холод. Увеличьте температуру или поставьте еще батарей.",
    deal_with_epidemic_now = "Если что-то не сделать с этой эпидемией, мы окажемся в беде по самые ноздри. Шевелитесь!",
    too_many_plants = "Я вижу, вы любите цветы. У вас тут настоящие джунгли.",
    patients_really_thirsty = "Пациенты очень хотят пить. Поставьте ваши торговые автоматы туда, где самые длинные очереди.",
    some_litter = "Дайте рабочим указание прибраться в больнице, пока проблема с мусором не разрослась.",
    patients_annoyed = "Люди терпеть не могут вашу больницу, и я не могу их винить за это. Разберитесь с вашими проблемами, или будет хуже!",
    doctor_crazy_overwork = "О Нет! Один из ваших докторов стал безумным из-за переработки! Он может вернуться в норму, если вы немедленно отправите его отдыхать.",
    no_desk_7 = "Вы построили регистратуру, как насчет нанять регистратора? Запомните, у вас не будет никаких пациентов, пока вы с этим не разберетесь!",
    researcher_needs_desk_1 = "Исследователю нужен стол, чтобы на нем работать.",
    no_desk_3 = "Это просто необыкновенно, прошел почти года, а вы так и не наняли регистратора! Как вы расчитываете получить пациентов? Теперь разберитесь с этим и прекратите заниматься ерундой.",
    no_desk_6 = "У вас нанят регистратор, теперь как насчет построить для нее Регистратуру?",
    no_desk_1 = "Если вы хотите, чтобы пациенты приходили в вашу больницу, вам следует построить Регистратуру и нанять регистратора, чтобы в ней работать.",
    falling_5 = "Это не место, чтобы выпинывать из него людей! Они больны, знаете ли!",
    no_desk = "Вам следует построить Регистратуру и нанять регистратора, наконец!",
    no_desk_2 = "Классно сработано! Это должно быть мировой рекорд: почти год и ни одного пациента! Если вы и дальше хотите управлять этой больницей вам нужно построить Регистратуру и нанять регистратора для работы в ней.",
    cannot_afford = "У вас недостаточно денег, чтобы нанять этого человека!",
    research_screen_open_1 = "Для доступа к разделу исследований, сначала нужно построить Исследовательский кабинет.",
    nurse_needs_desk_1 = "Каждой медсестре нужен собственный стол для работы.",
    researcher_needs_desk_2 = "Ваш исследователь благодарее вам, что вы разрешили сделать ему перерыв. Если вы намереваетесь иметь больше сотрудников для исследований, то каждому из них нужно купить персональный стол для работы.",
    research_screen_open_2 = "Исследования отключены на этом уровне.",
    falling_1 = "Эээй! это не смешно! Смотри куда кликаешь мышью, кое-кто может и пострадать!",
    receptionists_tired2 = "Ваши регистраторы очень устали. Дайти ем отдохнуть немедленно!",
    falling_3 = "Ауч, это было больно, кто-нибудь вызовите доктора!",
    no_desk_5 = "Что ж, это вопрос времени, следует подождать и пациенты скоро начнуть приходить!",
    no_desk_4 = "Регистратору нужен собственных стол, чтобы приветствовать пациентов, когда они заходят",
    falling_2 = "Хватит заниматься ерундой! Как вам это нравится?",
    researcher_needs_desk_3 = "Каждому исследователю нужен собственный стол для работы.",
    cannot_afford_2 = "У вас недостаточно денег в банке, чтобы сделать эту покупку!",
    falling_6 = "Это не боулинг, с больными людьми нельзя обращаться подобным образом!",
    nurse_needs_desk_2 = "Ваша Медсестра очень благодарна, что вы разрешили ей отдохнуть. Если вам нужно чтобы в Палате работало больше 1 медсестры купите каждой отдельный стол.",
    receptionists_tired = "Ваши регистраторы очень устали. Немедленно отправте их отдыхать.",
    falling_4 = "Это больница, а не Парк Развлечений!",
    another_desk = "Вам нужно будет построить еще один регистратурный стол для этой новой регистраторши.",
    fair_prices = "Ваши сборы за %s кажутся справедливыми и сбалансированными.",
    high_prices = "Ваши сборы за %s высоки. Это принесет большую прибыль в краткосрочной перспективе, но в конечном счете вы начнете отталкивать людей.",
    low_prices = "Вы берете слишком мало за %s. Это приведет людей в вашу больницу, но вы не получите большой прибыли от каждого из них.",
    patient_not_paying = "Пациент ушел, не заплатив за %s, потому что цена слишком большая!",
    no_desk_7 = "Вы построили приёмную стойку, как насчёт нанятия регистратора? У Вас не будет пациентов, пока Вы с этим не разберётесь!",
    researcher_needs_desk_1 = "Исследователю нужно рабочее место",
    no_desk_6 = "Вы наняли регистратора, как насчёт приёмной стойки для него?",
    nurse_needs_desk_1 = "Каждая медсестра нуждается в собственном рабочем месте.",
    researcher_needs_desk_2 = "Ваш исследователь рад, что Вы разрешили ему отдохнуть. Если Вы хотели, чтобы у Вас работали несколько исследователей, Вы должны предоставить каждому из них собственное рабочее место.",
    no_desk_5 = "Время пришло, скоро к Вам начнут приходить пациенты!",
    no_desk_4 = "Регистратору нужна приёмная стойка, чтобы он мог приветствовать новых пациентов",
    researcher_needs_desk_3 = "Каждый исследователь нуждается в собственном рабочем месте.",
    cannot_afford_2 = "У вас недостаточно денег в банке, чтобы сделать эту покупку!",
    nurse_needs_desk_2 = "Ваша медсестра рада, что Вы разрешили ей отдохнуть. Если Вы хотели, чтобы у Вас работали несколько медсестёр, Вы должны предоставить каждой из них собственное рабочее место.",
  },
  placement_info = {
    door_cannot_place = "Извините, тут дверь проделать нельзя.",
    staff_cannot_place = "К сожалению, этого человека нельзя здесь поставить.",
    object_cannot_place = "Сюда не поместится.",
    room_cannot_place = "Здесь нельзя устроить кабинет.",
    room_cannot_place_2 = "Тут кабинет не поместится.",
    window_cannot_place = "Здесь нельзя сделать окно.",
    reception_cannot_place = "Регистратура сюда не встанет.",
    reception_can_place = "Вы можете установить регистратуру здесь.",
    window_can_place = "Вы можете расположить окно тут. Оно прекрасно.",
    door_can_place = "Вы можете расположить дверь тут, если хотите.",
    object_can_place = "Вы можете поставить этот объект здесь.",
    staff_can_place = "Вы можете разместить этого сотрудника тут. ",
  },
  information = {
    larger_rooms = "Большие кабинеты повышают самооценку и производительность людей, которые в них работают.",
    extra_items = "Дополнительные предметы в кабинетах нравятся вашим сотрудникам и повышают производительность.",
    epidemic = "У вас в больнице распространяется заразная болезнь. Это нужно немедленно пресечь!",
    promotion_to_doctor = "Один из ваших студентов стал доктором.",
    emergency = "Чрезвычайная ситуация! Караул! Спасайся кто может!",
    patient_abducted = "Вашего клиента похищают пришельцы!",
    first_cure = "Отличная работа! Вы только что вылечили своего первого пациента.",
    promotion_to_consultant = "Один из ваших докторов стал консультантом.",
    handyman_adjust = "Вы можете повысить эффективность рабочих, перераспределив их приоритеты.",
    promotion_to_specialist = "Один из ваших докторов стал %s.",
    initial_general_advice = {
      rats_have_arrived = "В вашей больнице завелись крысы. Попробуйте пострелять их своей мышью.",
      first_patients_thirsty = "Посетители в вашей больнице хотят пить. Поставьте для них автоматы с газировкой.",
      research_now_available = "Вы построили исследовательский отдел. Теперь вы можете открыть окно исследований.",
      decrease_heating = "Посетители жалуются на жару. Понизьте уровень нагрева. Это можно сделать в окне карты.",
      first_emergency = "Над головой чрезвычайных пациентов крутится мигалка. Вылечите их до того, как закончится время.",
      first_epidemic = "У вас в больнице эпидемия! Примите решение, объявите ли вы о ней или попытаетесь скрыть.",
      taking_your_staff = "У вас пытаются переманить сотрудника. Вам придется побороться, если хотите удержать его.",
      place_radiators = "Посетители жалуются на холод. Вы можете заказать дополнительные батареи из меню обстановки коридоров.",
      epidemic_spreading = "Заразная болезнь распространяется по больнице. Постарайтесь вылечить зараженных до того, как они уйдут домой.",
      machine_needs_repair = "Одна из ваших машин требует ремонта. Найдите дымящуюся машину и щелкните на ней. Затем нажмите кнопку вызова рабочего.",
      increase_heating = "Пациенты замерзают. Увеличьте нагрев в окне карты.",
      first_VIP = "Скоро вас посетит с экскурсией какая-то большая шишка. Постарайтесь, чтобы он не заметил антисанитарии и недовольных пациентов.",
      psychiatric_symbol = "Доктора, разбирающиеся в вопросах психиатрии, оборзначены символом: |",
      research_symbol = "Доктора, умеющие проводить исследования, обозначены символом: }",
      surgeon_symbol = "Доктора, кто может проводить операции, обозначены симвовом: {",
      autopsy_available = "Исследована машина для автоматического вскрытия. С ее помощью вы можете избавляться от проблемных или нежелательных пациентов и проводить исследования над их останками. Но предупреждаем, что использование этой машины - это крайне спорная практика.",
    },
    patient_leaving_too_expensive = "Пациент ушел, не заплатив за %s. Для него это слишком дорого.",
    vip_arrived = "Внимание! %s прибыл в вашу больницу с официальным визитом! Проследите, чтобы все прошло как по маслу.",
    epidemic_health_inspector = "Слухи об эпидемии в вашей больнице достигли министерства здравоохранения. Приготовьтесь в приезду инспектора.",
    first_death = "Вы только что угробили своего первого пациента. Надеюсь, вы собой довольны?",
    pay_rise = "Кто-то из ваших сотрудников угрожает уволиться. Вы можете согласиться на повышение зарплаты или отказать. Нажмите на значок слева внизу чтобы увидеть заявление.",
    place_windows = "Дополнительные окна делают комнаты светлее, а персонал - счастливее.",
    fax_received = "Значок, который сейчас вылез слева внизу экрана сообщает вам что-то важное или требует ваше решение по какому-либо вопросу.",
  },
  competitors = {
    staff_poached = "Один из сотрудников вашей больницы перешел на работу в другой госпиталь.",
    land_purchased = "%s купил участок земли.",
    hospital_opened = "%s открыл конкурирующую больницу.",
  },
  praise = {
    many_benches = "пациентам достаточно мест для седения. Прекрасно.",
    few_have_to_stand = "Очень немногим приходится стоять в вашей больнице. пациенты благодарны вам за это.",
    plenty_of_benches = "Тут есть много скамеек, так что это не проблема.",
    plants_thriving = "Очень хорошо. Ваши растения просто процветают. Они выглядят чудесно. Поддерживайте их и вы можете выйграть за них приз.",
    plants_are_well = "Мило. Вы хорошо заботитесь о своих растениях.",
    many_plants = "Прекрасно. У вас есть много растений. пациенты будут благодарны за это.",
    patients_cured = "%d пациентов вылечено."
  },
  build_advice = {
    placing_object_blocks_door = "Расположение этого объета здесь не позволит людям входить в дверь.",
    door_not_reachable = "Люди не слогут входить в эту дверь. Подумайте об этом.",
    blueprint_would_block = "Такая планировка будет блокировать другие комнаты. Попробуйте изменить размер комнаты или переместить ее в другое место!",
    blueprint_invalid = "Это не допустимая планировка.",
  },
  multiplayer = {
    poaching = {
      not_interested = " Ха! Им не интересно работать на вас - они счастливы на своем месте.",
      already_poached_by_someone = "Невозможно! Кто-то уже пытается переманить этого человека.",
      in_progress = "Я дам вам знать когда этот человек захочет перейти работать на вас.",
    },
    objective_failed = "Вы не смогли выполнить поставленную задачу.",
    objective_completed = "Вы выполнили поставленную задачу. Поздравляю!",
    players_failed = "Нижеследующим игрокам не удалось достичь последней цели : ",
    everyone_failed = "Всем не удалось достичь последней цели. Поэтому каждый может поиграть на !",
  },
  cheats = {
    bloaty_cheat = "Обман Надутой головы активирован!",
    th_cheat = "Поздравляем, вы разблокировали обманки!",
    hairyitis_cheat = "Обман Оволосителя активирован!",
    crazy_on_cheat = "О нет! Все доктора сошли с ума!",
    roujin_off_cheat = "Состязание Roujin'а деактивировано.",
    crazy_off_cheat = "Уффф... врачи восстановили свое здравомыслие.",
    hairyitis_off_cheat = "Обман Оволосителя деактивирован.",
    roujin_on_cheat = "Состязание Roujin'а активировано! Удачи...",
    bloaty_off_cheat = "Обман Надутой головы деактивирован.",
  },
}

-- 8.  Письма из министерства
introduction_texts = {
  demo =
    "Добро пожаловать в демонстрационную больницу!//" ..
    "К сожалению демонстрационная версия содержит только этот уровень. Но этого более чем достаточно, чтобы занять вас на некоторое время! " ..
    "Вы будете сталкиваться с разными заболеваниями, которые будет требовать разных кабинетов для лечения. Время от времени, будут поступать пациенты, требующие немедленного лечения. Так же вам необходимо разрабатывать новые кабинеты используя исследовательский кабинет. " ..
    "Ваша цель заработать $100 000, стоимость больницы должна быть $70 000, а репутация 700. Кроме того, вы должны вылечивать не менее 75% своих пациентов. " ..
    "Удостоверьтесь, что ваша репутация не упадет ниже 300 и вы не убиваете более 40% ваших пациентов. Иначе вы проиграете.//" ..
    "Удачи!",
  level1 =
    "Добро пожаловать в вашу первую больницу!//" ..
    "Чтобы начать принимать пациентов, постройте регистратуру и кабинет терапевта, наймите регистраторшу и доктора. " ..
    "Потом просто ждите когда придут первые пациенты." ..
    "Также, вам не помешает построить кабинет психиатра и нанять доктора с соответствующим дипломом. " ..
    "Чтобы лечить больных, вам потребуется аптека и медсестра. " ..
    "Приготовьтесь принимать пациентов с раздутой головой. Для них надо будет построить кабинет со специальной машиной. " ..
    "Попробуйте вылечить 10 человек и смотрите, чтобы ваша репутация не упала ниже 200.",
  level2 =
    "В этой местности встречается больше разных заболеваний. " ..
    "Подготовьте больницу к наплыву пациентов и не забудьте построить исследовательский отдел. " ..
    "Очень важно поддерживать ваше заведение в чистоте и стараться повысить свою репутацию. Ожидайте прибытия пациентов с длинными языками - постройте для них специальный кабинет. " ..
    "Комната кардиографии поможет вам точнее ставить диагнозы. " ..
    "Оба этих кабинета должны быть исследованы прежде, чем вы сможете их построить. В окне карты вы теперь можете приобретать дополнительные корпуса для вашей больницы. " ..
    "Ваша цель - заработать 10 000$, вылечить 40 человек и не уронить репутацию ниже 300.",
  level3 =
    "На этот раз ваша больница будет расположена в богатом районе. " ..
    "Министерство здравоохранения ожидает получить здесь нехилую прибыль. " ..
    "Для начала, вам предстоит заработать хорошую репутацию, затем сосредоточтесь на превращении ее в деньги. " ..
    "Знайте, что вы можете столкнуться с чрезвычайными ситуациями. " ..
    "Это означает, что к вам в больницу прибудет группа людей с серьезным заболеванием. " ..
    "Если вы успеете их вылечить за ограниченное время, то заработаете солидный бонус и хорошую репутацию. " ..
    "Вам придется столкнуться с синдромом Короля, а также выделить деньги на постройку палаты и операционной. " ..
    "Заработайте 20 000$ чтобы добиться успеха.",
  level4 =
    "Проследите, чтобы пациенты были довольны, хорошо обслужены и не умирали. " ..
    "Ваша репутация имеет большое значение, так что постарайтесь поднять ее как можно выше. " ..
    "Не беспокойтесь о деньгах - они придут вместе с высокой репутацией. " ..
    "Теперь вы также можете обучать ваших докторов, чтобы повысить их навыки. " ..
    "Так они смогут справляться даже с самыми необчными болезнями. " ..
    "Поднимите вашу репутацию до 500.",
  level5 =
    "С таким разнообразием заболеваний, как в этой больнице, вам не придется сидеть без дела." ..
    "Ваши доктора - вчерашние студенты, так что им необходимо будет подучиться." ..
    "У вас есть три консультанта, которые помогут обучить новичков, постарайтесь их не разозлить." ..
    "А еще наша больница стоит прямо над разломом Сан Андроид." ..
    "Ожидайте землетрясений." ..
    "Они могут повредить ваши машины и нарушить работу больницы." ..
    "Поддерживайте репутацию не ниже 400 и заработайте 50 000$. Также, вылечите 200 пациентов.",
  level6 =
    "Опираясь на весь свой опыт, постройте хорошо организованную больницу, приносящую стабильный доход и способную вылечить все, что угодно." ..
    "Знайте, что в этой местности особенно быстро распространяются всякие инфекции." ..
    "Если в вашей больнице не будет идеально чисто, ждите вспышек эпидемий среди пациентов." ..
    "Заработайте 150 000$ и доведите стоимость больницы до 140 000$.",
  level7 =
    "Здесь вы будете под неусыпным наблюдением министерства здравоохранения, так что постарайтесь, чтобы деньги текли рекой, а репутация стремилась ввысь. " ..
    "Мы не можем вам позволить убивать пациентов - это плохо для бизнеса. " ..
    "Проследите, чтобы у вас было все необходимое оборудование и высококлассные специалисты. " ..
    "Заработайте 600 репутации плюс 200 000$ на банковский счет.",
  level8 =
    "Ваша задача - построить как можно более эффективную и рентабельную больницу. " ..
    "Народ здесь живет на широкую ногу, так что не стесняйтесь стричь капусту изо всех сил. " ..
    "Нет, конечно, лечить людей - хорошо, и все такое, но вам ОЧЕНЬ нужны их деньги. " ..
    "Проследите, чтобы ваши пациенты были в состоянии дойти до кассы. " ..
    "Накопите на счету, ни много ни мало, 300 000$ чтобы завершить этот уровень.",
  level9 =
    "Теперь, когда на счету министерства полно денег, и сам министр разъезжает на новеньком лимузине, вы вновь можете заняться постройкой приличной, хорошо организованной больницы для самых нуждающихся. " ..
    "Будьте готовы к любым неприятностям." ..
    "Если вы озаботитесь приобретением всего необходимого оборудования и кадров, ничто не сможет причинить вам проблем. " ..
    "Ваша больница должна стоить 200 000$, а на вашем счету должно быть 400 000$. " ..
    "Мы не примем меньшего.",
  level10 =
    "Помимо излечения всех болезней, которые бывают в этом захолустье, министерство просит вас уделить внимание исследованию лекарств." ..
    "К нам поступают жалобы от некоего Овсика, местного активиста, так что улучшайте свои лекарства, чттобы не ударить в грязь лицом." ..
    "Также, не давайте поводов для упреков. Сведите число трупов к минимуму." ..
    "Кстати, отведите место для кабинета лечения ожеления." ..
    "Улучшите все лекарства до 80% эффективности, повысьте репутацию до 650 и соберите 500 000$.",
  level11 =
    "Вам предоставляется шанс построить идеальную больницу. " ..
    "Это невероятно престижное место, и министерство хотело бы видеть здесь соответствующее лечебное учреждение. " ..
    "Мы ожидаем от вас большой прибыли, высокой репутации и использования всех возможных средств для достижения цели. " ..
    "Это очень важная работа. " ..
    "Чтобы ее выполнить, вам придется лезть из кожи вон. " ..
    "Кстати, в этой местности замечены НЛО. Интересно, ваш персонал готов к подобным сюрпризам? " ..
    "Доведите стоимость больницы до $240,000, соберите $500,000 и поднимите репутацию до 700.",
  level12 =
    "Эта задача - вершина всех задач. " ..
    "Восхищенное вашим успехом, министерство предлагает вам сложную работу: им нужен кто-то, кто построит еще одну идеальную больницу, принесет огромное количество денег и заработает невероятную репутацию. " ..
    "От вас ожидается, что вы скупите всю землю в округе, вылечите всех (да-да, именно всех) и получите все награды. " ..
    "Возьметесь за дело?" ..
    "Заработайте $650,000, вылечите 750 человек и ваша репутация не должна быть ниже 800, чтобы выиграть.",
  level13 =
    "Ваше невероятное мастерство владения больницей заинтересовало сверхсекретный отдел сверхсексретной службы. " ..
    "У них есть для вас сюрприз: переполненная крысами больница требует эффективного вмешательства. " ..
    "Уничтожьте как можно больше крыс, пока рабочие не убрали весь мусор. " ..
    "Справитесь?",
  level14 =
    "Перед вами очередное задание: эта больница богата разного рода неожиданностями. " ..
    "Приведите ее к успеху и станьте победителем из победителей. " ..
    "Не думайте, что все будет очень легко. Перед вашим лицом предстанут весьма жесткие условия " ..
    "Удачи!",
  level15 =
    "Итак, освоим важные моменты для создания хорошей больницы.//" ..
    "Иногда вашим врачам требуется помощь в постановке правильного диагноза. Для дополнительных обследований " ..
    "необходимо построить специальные кабинеты, например, кабинет общей диагностики.",
  level16 =
    "Вы уже поставили диагнозы нескольким пациентам, и пора приниматься за их лечение. Для этого необходимо построить различные кабинеты. " ..
    "Для начала постройте аптеку и наймите медсестру, которая будет выдавать пациентам спасительные лекарства.",
  level17 =
    "Последнее предупреждение: зорко следите за репутацией, ведь именно она привлекает к вам пациентов из самых дальних уголков страны, а соответственно и их деньги. " ..
    "Если вы не будете убивать много людей и они будут довольны вашей больницей, особых проблем у вас не возникнет.//" ..
    "Теперь вы сами себе хозяин. Удачи! На этом все.",
  level18 = "",
}
letter = {
  [1] = {
    [1] = "Уважаемый %s,//",
    [2] = "Великолепно! Вы превосходно справляетесь с управлением этой больницей. Мы, большие шишки из министерства здравоохранения, хотим предложить вам заняться более крупным проектом. Вы идеально подходите нам для этой работы. Мы готовы платить вам %d$. Подумайте над нашим предложением.//",
    [3] = "Вас интересует работа в больнице «%s»?",
  },
  [2] = {
    [1] = "Уважаемый %s,//",
    [2] = "Очень хорошо! Вы добились больших успехов в вашей больнице. Если вы не прочь сменить обстановку и не боитесь трудностей, мы можем предложить вам работу в другом месте. Соглашайтесь, и вы не пожалеете. Ваша зарплата составит %d$//",
    [3] = "Вы хотите работать в больнице «%s»?",
  },
  [3] = {
    [1] = "Уважаемый %s,//",
    [2] = "Вы добились огромных успехов, управляя этой больницей. Посему, мы предсказываем вам большое будущее и хотим предложить новый пост. Мы готовы платить вам %d$ и думаем, вы не прочь принять этот вызов.//",
    [3] = "Вы хотите управлять больницей «%s»?",
  },
  [4] = {
    [1] = "Уважаемый %s,//",
    [2] = "Поздравляем! У нас тут в министерстве все под впечатлением от ваши управленческих способностей. Мы возлагаем на вас большие надежды! Поэтому, мы хотим предложить вам работу посложнее. Ваша зарплата составит %d$, решение за вами.//",
    [3] = "Вас интересует работа в больнице «%s»?",
  },
  [5] = {
    [1] = "Уважаемый %s,//",
    [2] = "Снова здравствуйте. Мы понимаем, как вам неохота покидать эту уютную больничку, но все же убедительно просим вас пересмотреть свое мнение. Мы будем платить вам %d$, если вы отправитесь в другую больницу и организуете ее работу так же хорошо.//",
    [3] = "Вы согласны отправиться работать в больницу «%s»?",
  },
  [6] = {
    [1] = "Уважаемый %s,//",
    [2] = "Поздравляем. Представляем, как вы счастливы владеть этой прекрасной больницей, но следующая ступенька карьерной лестницы уже ждет вас. Вы будете получать $%d, если согласитесь. Надеемся, вы сделаете правильный выбор.//",
    [3] = "Согласны ли вы занять свое место в больнице «%s»?",
  },
  [7] = {
    [1] = "Уважаемый %s,//",
    [2] = "Добрый день! В министерстве здравоохранения всем очень интересно, что держит вас в вашей больнице. Может быть, ваше заведение и превосходно, но, все же, хотим предложить вам перевод в новую больницу, где вас ожидают новые песпективы и зарплата в $%d.//",
    [3] = "Вы согласны перейти работать в больницу «%s»?",
  },
  [8] = {
    [1] = "Уважаемый %s//,",
    [2] = "И еще раз, здравствуйте. Вы отклонили наше предыдущее предложение новой работы с зарплатой в %d$. Однако, мы настаиваем на пересмотре вами своего решения. Вот увидите, новое место работы намного лучше!//",
    [3] = "Пожалуйста, согласитесь занять пост руководителя в больнице «%s».",
  },
  [9] = {
    [1] = "Уважаемый %s//,",
    [2] = "На протяжении длительного времени вы зарекомендовали себя как отличный руководитель. Такая заслуга не может остаться без награды, и мы рады предложить вам пост главного управляющего больницами. Это важная должность, и размер зарплаты составит $%d. Вы взойдете на пост по ковровой дорожке, и люди встретят вас с почетом.//",
    [3] = "Вами пройден большой путь. Спасибо за все, что вы делаете.//",
    [4] = "",
  },
  [10] = {
    [1] = "Уважаемый %s//,",
    [2] = "Примите наши поздравления: вы изумительно справляетесь со всеми поставленными задачами. Ваш профессионализм открывает для вас множество путей. Вы будете получать пенсию в размере $%d и иметь личный лимузин, если согласитесь на наше предложение разъезжать по городам, проводя организационную работу в больницах.//",
    [3] = "Мы гордимся вами. Еще никто не отдавал столько сил на спасение человеческих жизней.//",
    [4] = "",
  },
  [11] = {
    [1] = "Уважаемый %s//,",
    [2] = "Ваша карьера была образцовой, вы вдохновляли нас. Спасибо за посещение такого количества больниц и огромную проделанную работу. Предлагаем вам пожизненные выплаты в размере $%d, а вы будете разъезжать в роскошном кабриолете по больницам городов и проводить мастер-классы по достижению успеха в карьере.//",
    [3] = "Вы являетесь примером для каждого здравомыслящего человека, и все, без исключения, хотели бы стать такими же успешными, как вы.//",
    [4] = "",
  },
  [12] = {
    [1] = "Уважаемый %s//,",
    [2] = "Ваша успешная карьера лучшего со времен Моисея управляющего больницей близится к завершению. Однако, учитывая ваши заслуги в медицине, министерство здравоохранения готово предложить вам $%d просто за то, что вы будете появляться на презентациях, открытиях, запусках кораблей и иногда на ток-шоу. Весь мир жаждет видеть вас, и ваше имя будет отличной рекламой для нас!//",
    [3] = "Пожалуйста, примите наше предложение. Работа несложная, и вам будет предоставлена машина и полицейский эскорт, куда бы вы ни отправились.//",
    [4] = "",
  },
  custom_level_completed = "Отличная работа! Вы выполнили все задачи на этой карте!",
  dear_player = "Уважаемый %s",
  return_to_main_menu = "Вернетесь в главное меню или продолжите игру?",
  campaign_level_missing = "Извините, но следующий уровень этой кампании, похоже, отсутствует. (Имя: %s)",
  campaign_level_completed = "Хорошая работа! Вы прошли уровень. Но это еще не конец! Вы хотели бы продолжить играть в больнице %s?",
  campaign_completed = "Невероятно! Вам удалось пройти все уровни. Теперь вы можете расслабиться и насладиться заполнением форумов в Интернете своими достижениями. Удачи! :)"
}

-- 9.  Имена и названия
months = {
  [1] = "янв",
  [2] = "фев",
  [3] = "мар",
  [4] = "апр",
  [5] = "мая",
  [6] = "июн",
  [7] = "июл",
  [8] = "авг",
  [9] = "сен",
  [10] = "окт",
  [11] = "ноя",
  [12] = "дек",
}
humanoid_name_starts = {
  [1] = "Клизм",
  [2] = "Орех",
  [3] = "Стол",
  [4] = "Бочк",
  [5] = "Нос",
  [6] = "Ерш",
  [7] = "Штан",
  [8] = "Болт",
  [9] = "Дуб",
  [10] = "Брод",
  [11] = "Чурб",
  [12] = "Крив",
  [13] = "Торт",
  [14] = "Кос",
  [15] = "Гор",
  [16] = "Долг",
  [17] = "Шар",
  [18] = "Рыж",
  [19] = "Пост",
  [20] = "Разд",
  [21] = "Жир",
  [22] = "Фаф",
  [23] = "Темн",
  [24] = "Пуст",
  [25] = "Морд",
  [26] = "Кот",
  [27] = "Срам",
  [28] = "Винт",
  [29] = "Мал",
  [30] = "Треп",
  [31] = "Остр",
  [32] = "Плот",
  [33] = "Хрен",
}
humanoid_name_ends = {
  [1] = "енко",
  [2] = "ович",
  [3] = "ай-оглы",
  [4] = "ицки",
  [5] = "атюк",
  [6] = "ински",
  [7] = "ецман",
  [8] = "идзе",
  [9] = "инян",
  [10] = "амян",
  [11] = "овски",
  [12] = "евич",
  [13] = "сон",
  [14] = "ски",
  [15] = "берг",
  [16] = "енюк",
  [17] = "ишко",
  [18] = "атко",
  [19] = "ейко",
  [20] = "акец",
  [21] = "елло",
  [22] = "ецки",
  [23] = "орец",
  [24] = "ацки",
  [25] = "анян",
  [26] = "атич",
}
vip_names = {
  [1] = "Мэр Большого Трумптона",
  [2] = "Лоуренс Найтингейл",
  [3] = "Бернард, король Нидерландов",
  [4] = "Онг Сян Су Куй, предводитель бирманской демократической оппозиции",
  [5] = "Сэр Риджинальд Крамбли",
  [6] = "Сэр Вилли Сэвил",
  [7] = "Советник Кроуфорд Первс",
  [8] = "«Ракета» Ронни Джепсон",
  [9] = "Футболист премьер-лиги",
  [10] = "Л. Ф. Пробст III",
  health_minister = "Министр здравоохранения",
}

-- 10  WIP
-- 10.2  Не для перевода
menu_options_volume = {
  [50] = "  50%  ",
  [100] = "  100%  ",
  [30] = "  30%  ",
  [60] = "  60%  ",
  [90] = "  90%  ",
  [10] = "  10%  ",
  [20] = "  20%  ",
  [40] = "  40%  ",
  [80] = "  80%  ",
  [70] = "  70%  ",
}
cheats_window = {
  cheats = {
    end_month = "Закончить Месяц",
    emergency = "Создать Критическое положение",
    win_level = "Выиграть Уровень",
    create_patient = "Создать Пациента",
    money = "Чит на Деньги",
    lose_level = "Проиграть Уровень",
    all_research = "Чит на Все Исследования",
    end_year = "Закончить Год",
    earthquake = "Вызвать землетрясение",
    vip = "Вызвать ВИП",
    toggle_infected = "Переключить значки инфекции",
    decrease_prices = "Снизить цены",
    epidemic = "Создать заразного пациента",
    increase_prices = "Повысить цены",
  },
  close = "Закрыть",
  caption = "Читы",
  cheated = {
    no = "Использование читов: Нет",
    yes = "Использование читов: Да",
  },
  warning = "Внимание: Вы не получите бонусные очки в конце уровня, если Вы будете использовать читы!",
}
original_credits = {
  [1] = " ",
  [2] = " ",
  [3] = " ",
  [4] = " ",
  [5] = " ",
  [6] = " ",
  [7] = " ",
  [8] = " ",
  [9] = " ",
  [10] = " ",
  [11] = " ",
  [12] = ":Designed and Created by",
  [13] = ":Bullfrog Productions",
  [14] = " ",
  [15] = ":Pluto Development Team",
  [16] = ",",
  [17] = "Mark Webley",
  [18] = "Gary Carr",
  [19] = "Matt Chilton",
  [20] = "Matt Sullivan",
  [21] = "Jo Rider",
  [22] = "Rajan Tande",
  [23] = "Wayne Imlach",
  [24] = "Andy Bass",
  [25] = "Jon Rennie",
  [26] = "Adam Coglan",
  [27] = "Natalie White",
  [28] = " ",
  [29] = " ",
  [30] = " ",
  [31] = ":Programming",
  [32] = ",",
  [33] = "Mark Webley",
  [34] = "Matt Chilton",
  [35] = "Matt Sullivan",
  [36] = "Rajan Tande",
  [37] = " ",
  [38] = " ",
  [39] = " ",
  [40] = ":Art",
  [41] = ",",
  [42] = "Gary Carr",
  [43] = "Jo Rider",
  [44] = "Andy Bass",
  [45] = "Adam Coglan",
  [46] = " ",
  [47] = " ",
  [48] = " ",
  [49] = ":Additional Programming",
  [50] = ",",
  [51] = "Ben Deane",
  [52] = "Gary Morgan",
  [53] = "Jonty Barnes",
  [54] = " ",
  [55] = " ",
  [56] = " ",
  [57] = ":Additional Art",
  [58] = ",",
  [59] = "Eoin Rogan",
  [60] = "George Svarovsky",
  [61] = "Saurev Sarkar",
  [62] = "Jason Brown",
  [63] = "John Kershaw",
  [64] = "Dee Lee",
  [65] = " ",
  [66] = " ",
  [67] = " ",
  [68] = ":Intro Sequence",
  [69] = ",",
  [70] = "Stuart Black",
  [71] = " ",
  [72] = " ",
  [73] = " ",
  [74] = ":Music and Sound Effects",
  [75] = ",",
  [76] = "Russell Shaw",
  [77] = "Adrian Moore",
  [78] = " ",
  [79] = " ",
  [80] = " ",
  [81] = ":Additional Music",
  [82] = ",",
  [83] = "Jeremy Longley",
  [84] = "Andy Wood",
  [85] = " ",
  [86] = " ",
  [87] = " ",
  [88] = ":Announcer Voiceover",
  [89] = ",",
  [90] = "Rebecca Green",
  [91] = " ",
  [92] = " ",
  [93] = " ",
  [94] = ":Level Design",
  [95] = ",",
  [96] = "Wayne Imlach",
  [97] = "Natalie White",
  [98] = "Steven Jarrett",
  [99] = "Shin Kanaoya",
  [100] = " ",
  [101] = " ",
  [102] = " ",
  [103] = ":Scripting",
  [104] = ",",
  [105] = "James Leach",
  [106] = "Sean Masterson",
  [107] = "Neil Cook",
  [108] = " ",
  [109] = " ",
  [110] = " ",
  [111] = ":R&D",
  [112] = " ",
  [113] = ":Graphics Engine",
  [114] = ",",
  [115] = "Andy Cakebread",
  [116] = "Richard Reed",
  [117] = " ",
  [118] = " ",
  [119] = " ",
  [120] = ":R&D Support",
  [121] = ",",
  [122] = "Glenn Corpes",
  [123] = "Martin Bell",
  [124] = "Ian Shaw",
  [125] = "Jan Svarovsky",
  [126] = " ",
  [127] = " ",
  [128] = " ",
  [129] = ":Library and Tools",
  [130] = " ",
  [131] = "Dos and Win 95 Library",
  [132] = ",",
  [133] = "Mark Huntley",
  [134] = "Alex Peters",
  [135] = "Rik Heywood",
  [136] = " ",
  [137] = " ",
  [138] = " ",
  [139] = ":Network Library",
  [140] = ",",
  [141] = "Ian Shippen",
  [142] = "Mark Lamport",
  [143] = " ",
  [144] = " ",
  [145] = " ",
  [146] = ":Sound Library",
  [147] = ",",
  [148] = "Russell Shaw",
  [149] = "Tony Cox",
  [150] = " ",
  [151] = " ",
  [152] = " ",
  [153] = ":Installer Programming",
  [154] = ",",
  [155] = "Andy Nuttall",
  [156] = "Tony Cox",
  [157] = "Andy Cakebread",
  [158] = " ",
  [159] = " ",
  [160] = " ",
  [161] = ":Moral Support",
  [162] = ",",
  [163] = "Peter Molyneux",
  [164] = " ",
  [165] = " ",
  [166] = " ",
  [167] = ":Testing Manager",
  [168] = ",",
  [169] = "Andy Robson",
  [170] = " ",
  [171] = " ",
  [172] = " ",
  [173] = ":Lead Testers",
  [174] = ",",
  [175] = "Wayne Imlach",
  [176] = "Jon Rennie",
  [177] = " ",
  [178] = " ",
  [179] = " ",
  [180] = ":Play Testers",
  [181] = ",",
  [182] = "Jeff Brutus",
  [183] = "Wayne Frost",
  [184] = "Steven Lawrie",
  [185] = "Tristan Paramor",
  [186] = "Nathan Smethurst",
  [187] = " ",
  [188] = "Ryan Corkery",
  [189] = "Simon Doherty",
  [190] = "James Dormer",
  [191] = "Martin Gregory",
  [192] = "Ben Lawley",
  [193] = "Joel Lewis",
  [194] = "David Lowe",
  [195] = "Robert Monczak",
  [196] = "Dominic Mortoza",
  [197] = "Karl O'Keeffe",
  [198] = "Michael Singletary",
  [199] = "Andrew Skipper",
  [200] = "Stuart Stephen",
  [201] = "David Wallington",
  [202] = " ",
  [203] = "And all our other Work Experience Play Testers",
  [204] = " ",
  [205] = " ",
  [206] = " ",
  [207] = ":Technical Support",
  [208] = ",",
  [209] = "Kevin Donkin",
  [210] = "Mike Burnham",
  [211] = "Simon Handby",
  [212] = " ",
  [213] = " ",
  [214] = " ",
  [215] = ":Marketing",
  [216] = ",",
  [217] = "Pete Murphy",
  [218] = "Sean Ratcliffe",
  [219] = " ",
  [220] = " ",
  [221] = " ",
  [222] = ":With thanks to:",
  [223] = ",",
  [224] = "Tamara Burke",
  [225] = "Annabel Roose",
  [226] = "Chris Morgan",
  [227] = "Pete Larsen",
  [228] = " ",
  [229] = " ",
  [230] = " ",
  [231] = ":PR",
  [232] = ",",
  [233] = "Cathy Campos",
  [234] = " ",
  [235] = " ",
  [236] = " ",
  [237] = ":Documentation",
  [238] = ",",
  [239] = "Mark Casey",
  [240] = "Richard Johnston",
  [241] = "James Lenoel",
  [242] = "Jon Rennie",
  [243] = " ",
  [244] = " ",
  [245] = " ",
  [246] = ":Documentation & Packaging Design",
  [247] = ",",
  [248] = "Caroline Arthur",
  [249] = "James Nolan",
  [250] = " ",
  [251] = " ",
  [252] = " ",
  [253] = ":Localisation Project Manager",
  [254] = ",",
  [255] = "Carol Aggett",
  [256] = " ",
  [257] = " ",
  [258] = " ",
  [259] = ":Localisation",
  [260] = ",",
  [261] = "Sandra Picaper",
  [262] = "Sonia 'Sam' Yazmadjian",
  [263] = " ",
  [264] = "Bettina Klos",
  [265] = "Alexa Kortsch",
  [266] = "Bianca Normann",
  [267] = " ",
  [268] = "C.T.O. S.p.A. Zola Predosa (BO)",
  [269] = "Gian Maria Battistini",
  [270] = "Maria Ziino",
  [271] = "Gabriele Vegetti",
  [272] = " ",
  [273] = "Elena Ruiz de Velasco",
  [274] = "Julio Valladares",
  [275] = "Ricardo Mart®ez",
  [276] = " ",
  [277] = "Kia Collin",
  [278] = "CBG Consult",
  [279] = "Ulf Thor",
  [280] = " ",
  [281] = " ",
  [282] = " ",
  [283] = ":Production",
  [284] = ",",
  [285] = "Rachel Holman",
  [286] = " ",
  [287] = " ",
  [288] = " ",
  [289] = ":Producer",
  [290] = ",",
  [291] = "Mark Webley",
  [292] = " ",
  [293] = " ",
  [294] = " ",
  [295] = ":Associate Producer",
  [296] = ",",
  [297] = "Andy Nuttall",
  [298] = " ",
  [299] = " ",
  [300] = " ",
  [301] = ":Operations",
  [302] = ",",
  [303] = "Steve Fitton",
  [304] = " ",
  [305] = " ",
  [306] = " ",
  [307] = ":Company Administration",
  [308] = ",",
  [309] = "Audrey Adams",
  [310] = "Annette Dabb",
  [311] = "Emma Gibbs",
  [312] = "Lucia Gobbo",
  [313] = "Jo Goodwin",
  [314] = "Sian Jones",
  [315] = "Kathy McEntee",
  [316] = "Louise Ratcliffe",
  [317] = " ",
  [318] = " ",
  [319] = " ",
  [320] = ":Company Management",
  [321] = ",",
  [322] = "Les Edgar",
  [323] = "Peter Molyneux",
  [324] = "David Byrne",
  [325] = " ",
  [326] = " ",
  [327] = ":All at Bullfrog Productions",
  [328] = " ",
  [329] = " ",
  [330] = " ",
  [331] = ":Special Thanks to",
  [332] = ",",
  [333] = "Everyone at Frimley Park Hospital",
  [334] = " ",
  [335] = ":Especially",
  [336] = ",",
  [337] = "Beverley Cannell",
  [338] = "Doug Carlisle",
  [339] = " ",
  [340] = " ",
  [341] = " ",
  [342] = ":Keep On Thinking",
  [343] = " ",
  [344] = " ",
  [345] = " ",
  [346] = " ",
  [347] = " ",
  [348] = " ",
  [349] = " ",
  [350] = " ",
  [351] = " ",
  [352] = " ",
  [353] = " ",
  [354] = " ",
  [355] = " ",
  [356] = " ",
  [357] = " ",
  [358] = " ",
  [359] = " ",
  [360] = " ",
  [361] = ".",
}
-- 10.3  Непереведенные
tooltip = {
  queue_window = {
    end_of_queue = "Перетащите пациента на этот значок, чтобы переместить его в конец очереди",
    num_entered = "Количество пациентов, посетивших кабинет",
    close = "Закрыть запрос",
    num_in_queue = "Количество пациентов в очереди",
    num_expected = "Количество пациентов, направленных сюда из регистратуры",
    front_of_queue = "Перетащите пациента на этот значок, чтобы переместить его в начало очереди",
    dec_queue_size = "Уменьшить максимальный размер очереди",
    max_queue_size = "Макимальный размер очереди в регистратуру",
    inc_queue_size = "Увеличить  максимальный размер очереди",
    patient = "Перетащите пациента в нужное место очереди. Щелкните на пациенте правой кнопкой, чтобы отправить его домой или в другую больницу",
    patient_dropdown = {
      send_home = "Выгнать пациента из больницы",
      hospital_2 = "Направить пациента в другую больницу",
      reception = "Отправить в регистратуру",
      hospital_1 = "Направить пациента в другую больницу",
      hospital_3 = "Направить пациента в другую больницу",
    },
  },
  jukebox = {
    rewind = "Предыдущая дорожка",
    loop = "Повторять текущую дорожку",
    stop = "Остановить",
    close = "Закрыть",
    current_title = "Текущая дорожка",
    play = "Воспроизвести",
    fast_forward = "Следующая дорожка",
  },
  graphs = {
    deaths = "Показать/скрыть умерших",
    close = "Закрыть окно",
    scale = "Масштаб графика",
    money_out = "Показать/скрыть расходы",
    visitors = "Показать/скрыть посетителей",
    wages = "Показать/скрыть зарплаты",
    balance = "Показать/скрыть баланс",
    money_in = "Показать/скрыть доход",
    cures = "Показать/скрыть вылеченных",
    reputation = "Показать/скрыть репутацию",
  },
  message = {
    button = "Щелкните, чтобы открыть сообщение",
    button_dismiss = "Щелкните левой кнопкой, чтобы просмотреть сообщение, правой - чтобы отклонить его",
  },
  pay_rise_window = {
    accept = "Повысить зарплату",
    decline = "Отказать в повышении зарплаты",
  },
  custom_game_window = {
    start_game_with_name = "Загрузить уровень %s",
    free_build = "Свободное строительство",
    load_selected_level = "Старт",
    choose_game = "Нажмите на уровень, чтобы узнать про него больше.",
    load_selected_level = "Загрузите и играйте в выбранный уровень",
  },
  cheats_window = {
    close = "Закрыть окно с читами",
    cheats = {
      end_month = "Перепрыгивает в конец месяца.",
      emergency = "Создает критическое положение.",
      win_level = "Выиграть уровень.",
      create_patient = "Создает Пациента в конце карты.",
      money = "Добавляет 10.000 к Вашему балансу.",
      lose_level = "Проиграть уровень.",
      all_research = "Завершает все исследования.",
      end_year = "Перепрыгивает в конец года.",
      toggle_infected = "Переключите значки зараженных для активной, обнаруженной эпидемии",
      decrease_prices = "Уменьшить все цены на 50% (мин. 50%)",
      epidemic = "Создает заразного пациента, который может вызвать эпидемию",
      increase_prices = "Увеличить все цены на 50% (макс. 200%)",
      earthquake = "Вызвать землетрясение.",
      vip = "Пригласить ВИП.",
    },
  },
  menu_list_window = {
    back = "Закрыть окно",
    save_date = "Измененялось",
    name = "Имя",
  },
  watch = {
    emergency = "Чрезвычайное происшествие: время, оставшееся на лечение срочных пациентов.",
    hospital_opening = "Время на постройку: по истечении этого времени больница будет открыта. Если вы хотите открыть больницу уже сейчас, нажмите зеленую кнопку.",
    epidemic = "Эпидемия: время на остановку эпидемии. Когда время закончится или зараженный пациент покинет больницу, приедет инспектор. Кнопка включает/отключает режим вакцинации. Щелкните на пациенте, и медсестра введет ему вакцину.",
  },
  calls_dispatcher = {
    assigned = "Это поле отмечено, если кому-то присвоено соответствующее задание.",
    task = "Список заданий - нажмите на задание, чтобы открыть окно назначенного персонала и прокрутить до расположения задачи",
    close = "Закрыть окно диспетчера",
  },
  information = {
    close = "Закрыть окно информации",
  },
  lua_console = {
    textbox = "ВВедите здесь Lua код для запуска",
    execute_code = "Запустить введенный Вами код",
    close = "Закрыть консоль",
  },
  staff_window = {
    doctor_seniority = "Авторитет (Студент, Доктор, Консультант)",
    psychiatrist = "Психиатр",
    close = "Закрыть окно",
    ability = "Компетентность",
    pick_up = "Взять",
    sack = "Уволить",
    surgeon = "Хирург",
    happiness = "Настроение",
    salary = "Ежемесячная зарплата",
    name = "Имя",
    tiredness = "Запас сил",
    center_view = "Левая кнопка - центрировать экран, правая - выбрать следующего сотрудника",
    skills = "Особые умения",
    researcher = "Исследователь",
    face = "Портрет - нажмите, чтобы перейти к экрану управления персоналом",
  },
  research = {
    cure_inc = "Повысить приоритет исследований",
    close = "Закрыть экран исследований",
    specialisation_dec = "Понизить приоритет исследований",
    diagnosis_dec = "Понизить приоритет исследований",
    allocated_amount = "Выделенные ресурсы",
    improvements_inc = "Повысить приоритет исследований",
    drugs_dec = "Понизить приоритет исследований",
    drugs_inc = "Повысить приоритет исследований",
    cure_dec = "Понизить приоритет исследований",
    specialisation_inc = "Повысить приоритет исследований",
    improvements_dec = "Понизить приоритет исследований",
    diagnosis_inc = "Повысить приоритет исследований",
  },
  statement = {
    close = "Закрыть экран баланса",
  },
  buy_objects_window = {
    confirm = "Купить предмет(ы)",
    cancel = "Отмена",
    increase = "Купить на один предмет больше",
    total_value = "Общая сумма покупки",
    price = "Стоимость предмета",
    decrease = "Купить на один предмет меньше",
  },
  fax = {
    close = "Закрыть окно, не удаляя сообщение",
  },
  window_general = {
    confirm = "Подтвердить",
    cancel = "Отмена",
  },
}
totd_window = {
  previous = "Предыдущая подсказка",
  tips = {
    [1] = "Любая больница нуждается в регистратуре и кабинете терапевта. Именно в них решается дальнейшая судьба пациента и он направляется на дальнейшее лечение. Кстати, аптека тоже не помешает.",
    [2] = "Машины, например, аппарат надувания, требуют регулярного ухода. Для этого нужно нанять одного-двух работников. Испорченные машины могут доставить много неприятностей как персоналу, так и пациентам.",
    [3] = "Персоналу свойственно уставать. Не забывайте строить комнаты отдыха для них.",
    [4] = "Устанавливайте достаточно батарей отопления для поддержания тепла в больнице, иначе персонал и пациенты будут недовольны. Распределение тепла по помещению можно посмотреть на карте города.",
    [5] = "Профессионализм доктора сильно влияет на скорость постановки диагноза и качество лечения. Один профессиональный терапевт способен заменить двух неопытных.",
    [6] = "Студенты и доктора могут повышать свой профессиональный уровень на лекциях консультанта. Если консультант обладает специальными навыками (психиатра, хирурга или исследователя), он сможет передать их ученикам.",
    [7] = "А вы пробовали набирать европейский номер службы спасения (112) на факсе? Перед тем, как пробовать, включите звук!",
    [8] = "Вы можете изменить некоторые настройки, например разрешение экрана или язык игры, перейдя в меню настроек из главного меню или непосредственно из игры.",
    [9] = "Везде английские слова, хотя вы выбрали в настройках совсем не английский язык? Помогите закончить перевод игры!",
    [10] = "Команда CorsixTH нуждается в вашей помощи! Если вы хотите помочь в написании кода, создании графики или перевода игры, свяжитесь с нами на форуме, по электронной почте или на IRC-канале (corsix-th at freenode).",
    [11] = "Если вы нашли ошибки, пишите на наш багтрекер: th-issues.corsix.org",
    [12] = "Каждый уровень игры требует выполнения определенных условий для его завершения. Периодически заглядывайте в окно статуса, чтобы знать, какие условия выполнены, а какие - еще нет.",
    [13] = "Для редактирования или удаления кабинета есть специальная кнопка на панели внизу экрана.",
    [14] = "Чтобы разобраться в толпе пациентов, наведите курсор на кабинет, и ожидающие своей очереди посетители будут выделены.",
    [15] = "Щелкните на двери кабинета для просмотра очереди. Пациентов, стоящих в очереди можно перемещать, направлять в другие кабинеты и даже выгонять.",
    [16] = "Недовольный персонал требует повышения зарплат. Убедитесь в том, что ваши работники пребывают в кофортабельных условиях труда.",
    [17] = "Если в помещении больницы становится слишком жарко, пациентов начинает мучать жажда! Во избежание этого установите достаточное количество автоматов с водой в коридорах.",
    [18] = "Вы можете прервать диагностику пациента, будучи уверенным в постановке диагноза. Но будьте осторожны: ваша ошибка может повлечь за собой смерть пациента.",
    [19] = "Чрезвычайные ситуации могут принести вам неплохой доход, конечно, при условии, что у вас есть возможность и время для лечения таких пациентов.",
  },
  next = "Следующая подсказка",
}
trophy_room = {
  reputation = "РЕПУТАЦИЯ",
  gen_repairs = {
    penalty = {
      [1] = "Ваши рабочие не обслуживают оборудование должным образом. Вам следует управлять ими рабочими лучше, возможно потребуется нанять больше рабочих, чтобы справиться с нагрузкой.",
      [2] = "У вас ужасное обслуживание аппаратов. Ваши сотрудники должны ухаживать за оборудованием клиники быстро и с заботой.",
    },
    awards = {
      [1] = "Вы удостоены специальной награды для рабочих за поддержание оборудования клиники в хорошем состоянии. Отлично сработано! Устройте себе выходной.",
      [2] = "Ваши рабочие справляются лучше своих коллег в других больницах. Это главное достижение, с которым вас стоит поздравить.",
      [3] = "Оборудование больницы поддерживается в великолепном состоянии. Усилия ваших рабочих невероятны. Вы все заслуживаете этой престижной награды. Удивительная работа.",
    },
  },
  pop_percentage = {
    awards = {
      [1] = "Заметим, что вы привлекли большую часть населения города в прошлом году. Отлично сработано.",
      [2] = "Поздравляем. Более высокая доля местного населения посещает вашу больницу, нежели любую другую.",
      [3] = "Превосходно. Вы привлекли в свою больницу больше населения, чем посетило все остальные больницы вместе взятые.",
    },
    penalty = {
      [1] = "Очень немногие пришли лечиться в вашу больницу в прошлом году. Чтобы заработать денег вам нужны платежеспособные страдальцы.",
      [2] = "Через двери любой больницы в этой местности проходит большая доля населения, чем через ваши. Вам должно быть очень стыдно.",
    },
  },
  happy_vips = {
    awards = {
      [1] = "Вы получили Нобелевскую премию за впечатления, произведенное на высокопоставленных особ. Все большие шишки, посещавшие вашу больницу за прошедший год, оценили ее выше всяких похвал.",
      [2] = "Поздравляем! Вы награждены орденом Подлизы за потакание всем большим шишкам, посещавшим вашу больницу в прошедшем году. Шикарно.",
    },
    trophies = {
      [1] = "Клуб Важных Персон вручает вам кубок Популярности за оказанное внимание всем VIP-персонам, посетившим ваше заведение в прошедшем году. Теперь вы можете считать себя немного известнее.",
      [2] = "Агентство Известных Людей вручает вам Знаменитую Награду за удовлетворение каждого ВИП, кто посетил ваше предприятие. Считайте себя немного известным, почти одним из нас.",
      [3] = "Поздравляем с выигрышем ВИП Путешествия в награду за то что сделали жизнь трудолюбивых людей в глазах общественности лучше, угождая каждому из них, кто посетил вашу больницу. Просто чудесно.",
    },
  },
  happy_patients = {
    awards = {
      [1] = "Вы может быть самодовольны по поводу того, что в прошлом году пациенты были очень довольны находиться в вашей больнице.",
      [2] = "Люди, посетившие вашу больницу, в среднем были более довольны своим лечением, нежели в любой другой больнице в игре.",
    },
    penalty = {
      [1] = "Люди, приходящие в вашу больницу, находят ее ужасной. Вам нужно лучше работать, чтобы заслужить уважение Министерства.",
      [2] = "Люди, лечащиеся в вашей больнице, очень недовольны ее состоянием. Вы должны тщательнее следить за состоянием пациента.",
    },
  },
  rats_killed = {
    awards = {
    },
    trophies = {
      [1] = "Вы награждены кубком Истребителя за уничтожение %d крыс в вашей больнице за прошедший год.",
      [2] = "Вы номинированы на награду от Аниткрысной Коалиции за выдающиеся успехи в истреблении %d этих мерзких тварей за прошедший год.",
      [3] = "Вы награждены орденом Крысобоя за отвагу и доблесть в уничтожении этих гадких созданий. Было убито %d крыс за прошедший год.",
    },
  },
  happy_staff = {
    awards = {
      [1] = "Ваши сотрудники номинировали вас на эту награду. Они сказали, что хотя и есть что улучшать, ваша забота о них оставалась, в целом, хорошей.",
      [2] = "Ваши сотрудники счастливы работать на вас, у них не сходит улыбка с лица. Вы потрясающий управляющий.",
    },
    trophies = {
      [1] = "Вы награждены кубком Улыбки за поддержание хорошего настроения ваших тружеников в течении прошедшего года.",
      [2] = "Институт Вселенского Счастья вручает вам приз за отсутвие в вашем прекрасном заведении несчастных работников в прошедшем году.",
      [3] = "Эта награда, Сияющий Позолоченный кубок, вручается вам за поддержание в прошедшем году хорошего настроения работников в любой ситуации!",
    },
    regional_bad = {
      [1] = "Ваши сотрудники были очень несчастны в течение прошлого года. Вы должны знать об этом. На самом деле, в любой другой больнице персонал чувствует себя лучше, чем в вашей.",
    },
    regional_good = {
      [1] = "Ваш персонал счастливее коллег в любой другой больнице. Довольный персонал значит больше прибыль и меньше смертность. Министерство этим довольно.",
    },
    penalty = {
      [1] = "Ваши сотрудники хотят чтобы было известно о том, что они несчастны. Хороший персонал - это преимущество. Сделайте ваших людей счастливее или однажды вы многое потеряете.",
    },
  },
  rats_accuracy = {
    awards = {
    },
    trophies = {
      [1] = "Вы несомненно заслужили уважение Общества снайперов за %d%% точность при отстреле крыс.",
      [2] = "Эта награда торжестенно вручается вам за %d%% попадания по крысам вашей больницы в прошедшем году.",
      [3] = "Чтобы отметить истребление %d%% крыс в вашей больнице, вам вручается премия Почётного крысолова!",
    },
  },
  all_cured = {
    awards = {
      [1] = "Поздравляем с получением ордена Марии Кюри за успешное излечение всех пациентов, посетивших вашу больницу в прошедшем году!",
    },
    trophies = {
      [1] = "Международная Ассоциация Излечения с гордостью вручает вам кубок Всездравия за стопроцентное излечение пациентов в прошедшем году.",
      [2] = "Вы получаете Здоровенную премию за заботу о выздоровлении каждого пациента больницы!",
    },
  },
  no_deaths = {
    awards = {
      [1] = "Поздравляем! Вы получаете орден имени В. Безтрупова за стопроцентное выживание ваших пациентов.",
      [2] = "Ваш гейний свел количество смертей в госпитале к минимуму. Вы можете быть очень довольны этим результатом.",
    },
    trophies = {
      [1] = "Общество Продолжения Жизни вручает вам награду за отсутствие смертей среди пациентов в прошедшем году.",
      [2] = "Вы награждены кубком Выживания за то, что в прошедшем году сохранили жизни всех своих пациентов. Поразительно!",
      [3] = "Вы были награждены Кубком ОСТАТЬСЯ В ЖИВЫХ за то что в этом году избежали смертей среди пациентов в вашей милой больнице. Отлично.",
    },
    penalty = {
       [1] = "Количество смертей в вашей больнице в прошлом году было непреемлемо высокое. Уделяйте больше времени своей работе. Убедитесь, что в будущем выживет больше людей.",
       [2] = "Ваша больница опасна для здоровья пациентов. От вас ждали, что вы будете лечить своих пациентов, а не убивать их.",
    },
    regional = {
      [1] = "Число погибших в вашей больнице в прошлом году было ниже, чем в любой другой в округе. Пожалуйста, примите эту награду.",
    },
  },
  many_cured = {
    awards = {
      [1] = "Примите наши поздравления с получением ордена Матери Терезы за большинство вылеченных пациентов в прошедшем году.",
      [2] = "Пожалуйста примите эту награду за то что вылечили пациентов больше, чем любая другая больница.",
    },
    trophies = {
      [1] = "Международная Ассоциация Излечения торжественно вручает вам награду за излечение почти всех пациентов, обратившимся в больницу в прошедшем году.",
      [2] = "Вы получаете такую ценную награду, как кубок Выживания за невероятно высокий процент вылеченных пациентов вашего заведения за прошедший год.",
      [3] = "Вы были представлены к вручению Кубка Gargler за поддержание высокого процента вылеченных людей в прошлом году.",
    },
    penalty = {
      [1] = "Ваша больница не смогла предоставить эффективное лечение, нуждающимся в нем, пациентам. Сконцентрируйтесь на том, чтобы сделать лечение более эффективным.",
      [2] = "Ваша больница наименее эффективная из всех, что касается лечения пациентов. Вы тащите Министерство на дно и сами опускаетесь туда же. Мне больше нечего сказать.",
    },
    regional = {
       [1] = "Вы представлены к награде за беспрецедентное исцеление. Это за то, что вы вылечили больше пациентов, чем все остальные больницы вместе взятые.",
    },
  },
  curesvdeaths = {
    awards = {
      [1] = "Сердечно поздравляем с достижением впечатляющего соотношения вылеченных к убитым в вашей больнице в прошлом году.",
    },
    penalty = {
      [1] = "Ваше соотношение вылеченных к убитым крайне плохое. Вы должны быть уверены в том, что вылечите больше людей, чем убьете. Помните - не наоборот.",
    },
  },
  emergencies = {
    award = {
      [1] = "Поздравляем: ваша эффективность и эффективное решение экстренных случаев приносит вам эту особенную награду. Отличная работа!",
      [2] = "Вы исключительно хорошо справляетесь с экстренными случаями. Эта награда за то что вы лучше всех справляетесь с большим потоком больных и страждущих.",
    },
    regional_good = {
      [1] = "Министерство выяснило, что ваша больница в прошлом году справлялась с экстренными случаями лучше чем любая другая. Поэтому оно вручает вам эту награду.",
    },
    penalty = {
      [1] = "Вы ужасно справляетесь с экстренными пациентами. Прилетающие пациенты для немедленного лечения требуют точного и своевременного внимания, чего вы не смогли им дать.",
    },
    regional_bad = {
      [1] = "Что касается экстренных случаев с пациентами, ваша больница была самой ужасной в регионе. Это ваша вина в том, что вы томитесь в нижней части местной лиги экстренного лечения.",
    },
  },
  high_rep = {
    awards = {
      [1] = "Вам торжественно вручается награда Кабинета Министров за поддержание стабильно высокой репутации больницы в прошедшем году. Отлично!",
      [2] = "Пожалуйста, примите награду команды CorsixTH за высочайшую репутацию вашего заведения. Вы это заслужили.",
    },
    trophies = {
      [1] = "Поздравляем с получением кубка Мегапафоса за достижение такой репутации в прошедшем году. Так держать!",
    },
    penalty = {
      [1] = "Вы были дисциплинированы в поддержании очень плохой репутации на протяжение прошлого года. Убедитесь в том, что она поднимется в будущем.",
      [2] = "Репутация вашей больницы самая ужасная в городе. Вы опозорены. Улучшите ее или найдите другую работу.",
    },
    regional = {
      [1] = "Пожалуйста примите нагдару от Bullfrog за самую высокую репутацию из всех больниц. Наслаждайтесь - вы это заработали.",
      [2] = "В этом году, репутация вашей больницы превысила все остальные вместе взятые. Это крупное достижение.",
    }
  },
  consistant_rep = {
    trophies = {
      [1] = "Настоящим, вы получаете награду от Кабинета Министров за самые безупречные стандарты и наивысшую репутацию какая только может быть. Хорошо сработано.",
      [2] = "Поздравляем с получением Кубка СкуаэкиКлин за лучшую репутацию больницы в прошлом году. Вы это заслужили.",
    },
  },
  sold_drinks = {
    awards = {
    },
    trophies = {
      [1] = "Международная Ассоциация Стоматологов вручает вам награду и медальку за огромное количество проданных газированных напитков за прошедший год.",
      [2] = "Ваша больница награждается кубком Пыщь-пыщь в честь продажи невероятного количества прохладительных напитков в прошедшем году.",
      [3] = "Позвольте нам, при поддержке кондитерской фабрики «Синий Пролетарий», вручить вам покрытый шоколадом кубок за высокий уровень продаж газированных напитков в прошедшем году.",
    },
  },
  wait_times = {
    award = {
      [1] = "Поздравляем. В вашей больнице пациенты почти не проводят время в очередях. Это важная награда.",
    },
    penalty = {
      [1] = "Людям в вашей больнице приходится ждать слишком долго. Здесь всегда непреемлемые очереди. Вы должны управляться с вашими пациентами более эффективно, раз уж за это взялись.",
    },
  },
  healthy_plants = {
    awards = {
      [1] = "Поздравляем! Вы награждены орденом Лопаты и Тяпки за поддержание растений в добром здравии круглый год.",
    },
    trophies = {
      [1] = "В честь того, что вы поддерживали растения в отличном состоянии весь прошедший год, Национальный Ботанический Сад вручает вам премию Листоворотки Дикопроизрастающей.",
      [2] = "Компания «СемеНа, получи» награждает вас премией имени Мичурина в честь своевременного ухода за растениями в прошедшем году.",
    },
  },
  cleanliness = {
    regional_good = {
      [1] = "Ваша больница была отмечена как одна из самых не прибранных в округе. В грязной больнице опасно и воняет. Вы лучше должны за этим следить.",
    },
    award = {
      [1] = "Инспекторы отметили, что ваша больница очень чистая. Чистая больница - это безопасная больница. Поддерживайте ее в том же виде.",
    },
    regional_bad = {
      [1] = "Ваша больница самая грязная в округе. Любой другой управляющий поддерживает свои коридоры более чистыми. Вы - позор медицины!",
    },
  },
  hosp_value = {
    awards = {
      [1] = " Министерство Здравоохранения хочет использовать представившуюся возможность, чтобы поздравить вас с впечатляющей общей стоимостью вашей больницы.",
    },
    penalty = {
      [1] = "Вашей больнице не удалось достичь достойной стоимости. Вы приняли плохие решения по управлению капиталом. Помните, хорошая больница - это так же дорогая больница.",
    },
    regional = {
      [1] = "Вы финансовый волшебник. Ваша больница стоить больше чем все остальные вместе взятые.",
    },
  },
  best_value_hosp = {
    regional = {
      [1] = "Поздравляем с владением самой дорогой больницей в игре. Хорошая работа. Постарайтесь сохранить это вдальнейшем.",
    },
    penalty = {
      [1] = "Любая больница в округе стоит дороже вашей. Сделайте что-нибудь с этой позорной частью дел. Поставте больше дорогого оборудования!",
    },
    trophies = {
      [1] = "Посздравляем с получением Кубка SqueakiKlean за больницу с лучшей репутацией в прошлом году. Вы это заслужили.",
    },
  },
  research = {
    regional_good = {
      [1] = "Ваши исследователи поддерживали вашу больницу в курсе последних разработок. Ваши исследователи заслужили эту награду. Продолжайте в том же духе!",
    },
    regional_bad = {
      [1] = "Любая больница в округе продвинулась в исследованиях лучше вашей. Так как исследования критически важны для вашей больницы, то Министерство пребывает в ярости.",
    },
    penalty = {
      [1] = "Вы били плохи в исследовании новых лекарств оборудования и методов лечения. Это очень плохо. Технологическое превосходство жизненно необходимо.",
    },
    awards = {
      [1] = "Ваши исследования сохранили вашу больницу в курсе последних событий. Ваш исследовательский персонал заслужил эту награду. Хорошо сработано.",
      [2] = "В течение прошлого года вы исследовали больше лекарств и оборудования, чем можно было бы даже надеяться. Пожалуйста примите эту награду от всех нас из Министерства.",

    },
  },
  cash = "ДЕНЬГИ",
}
drug_companies = {
  [1] = "ГосФармХимПром",
  [2] = "ИП Лечилкин",
  [3] = "ОАО Шприцеватор",
  [4] = "КолесоПлюс",
  [5] = "ИП Бергман и Ко",
}
insurance_companies = {
  [1] = "ООО Вектор",
  [2] = "ЧП Луковые Кольца",
  [3] = "ООО Братство Стали",
  [4] = "ЧП Дедушка Вареник",
  [5] = "ОДО Лебединая Песня",
  [6] = "ГосБытСнабСтрах",
  [7] = "ООО Недострах",
  [8] = "ЧП Залкинд и сыновья",
  [9] = "Бивис и Батт-хед Ко",
  [10] = "ООО Застрахуй-ка",
  [11] = "ООО Страховой Синдикат",
  out_of_business = "ВЫШЕЛ ИЗ БИЗНЕСА",
}
competitor_names = {
  [1] = "ПРОФИТ",
  [2] = "МАРВИН",
  [3] = "МЕДИВАН",
  [4] = "ГИППОМЕД",
  [5] = "ТОНУС",
  [6] = "ЛОЩИНА",
  [7] = "ДЗЕН",
  [8] = "САЛВИН",
  [9] = "АКИРА",
  [10] = "ПУЛЬМАН",
  [11] = "ЧАРЛИ",
  [12] = "КРИОНИКА",
  [13] = "ГОРГОНА",
  [14] = "ОЛИФАНТ",
  [15] = "КАЛИНА",
  [16] = "НОРМАЛ",
  [17] = "ВИНСЕНТ",
  [18] = "МОЗЕС",
  [19] = "АМБУЛАНТА",
  [20] = "АХМЕД",
  [21] = "МАКСВЕЛ",
  [22] = "ДАНИЭЛ",
  [23] = "ОЛИВА",
  [24] = "НИК",
}
level_names = {
[1] = "Отравинск",
[2] = "Сонная лощина",
[3] = "Полянск",
[4] = "Правобережино",
[5] = "Простецк",
[6] = "Холмопупинка",
[7] = "Зеленоград",
[8] = "Белочкино",
[9] = "Пограничинск",
[10] = "Яичкино",
[11] = "Квакушкино",
[12] = "Избиваловка",
[13] = "Большие Чумли",
[14] = "Мелкопоповецк",
[15] = "Клептоманск",
}
graphs = {
  deaths = "Умерло",
  money_in = "Доход",
  money_out = "Расход",
  visitors = "Посетители",
  wages = "Зарплата",
  balance = "Баланс",
  time_spans = {
    [1] = "1 год",
    [2] = "12 лет",
    [3] = "48 лет",
  },
  cures = "Вылечено",
  reputation = "Репутация",
}
newspaper = {
  [1] = {
    [1] = "УЖАСЫ НАШЕГО КАБИНЕТА",
    [2] = "ТЕРАПЕВТ ВОЗОМНИЛ СЕБЯ БОГОМ",
    [3] = "КРУЧЕ ФРАНКЕНШТЕЙНА",
    [4] = "ЧТО У НАС НА СТОЛЕ?",
    [5] = "ОБЛАВА НА СУМАСШЕДШИХ ВРАЧЕЙ",
  },
  [2] = {
    [1] = "ВРАЧ УПОРОЛСЯ В ХЛАМ",
    [2] = "ОТЪЯВЛЕННЫЙ ХИРУРГ",
    [3] = "КОНСУЛЬТАНТ-ДЕБОШИР",
    [4] = "АЛКО-ХИРУРГИЯ",
    [5] = "ХИРУРГ ПОД НАРКОЗОМ",
    [6] = "ВРАЧ ДЫШАЛ ПЕРЕГАРОМ",
  },
  [3] = {
    [1] = "НЕУДАЧНАЯ ХИРУРГИЯ",
    [2] = "ВРАЧА ЗАСТАЛИ ВРАСПЛОХ",
    [3] = "ПРОВАЛ ВРАЧА",
    [4] = "НЕНАСЫТНЫЙ ХИРУРГ",
  },
  [4] = {
    [1] = "ПОДПОЛЬНЫЕ ОПЕРАЦИИ",
    [2] = "ОРГАН-ИЗОВАННОЕ ПРЕСТУПЛЕНИЕ",
    [3] = "ОПЕРАЦИИ...С ДЕНЬГАМИ",
    [4] = "ВРАЧ ГРЕБ ДЕНЬГИ ЛОПАТКОЙ",
  },
  [5] = {
    [1] = "МЕДИЦИНСКА НЕКРОФИЛИЯ",
    [2] = "ВРАЧ РАСКАПЫВАЛ МОГИЛЫ",
    [3] = "ЗАСТУКАЛИ С ТРУПОМ",
    [4] = "СУДНЫЙ ДЕНЬ ДЛЯ ДОКТОРА",
    [5] = "ТЕРМИНАЛЬНАЯ СТАДИЯ ПРАКТИКИ",
    [6] = "ДОКАЗАТЕЛЬСТВА ВЫКОПАНЫ!",
  },
  [6] = {
    [1] = "ВРАЧА ПОВЯЗАЛИ!",
    [2] = "РРАЗ! И ВСЕ!",
    [3] = "ДИАГНОСТИКА НА КОФЕЙНОЙ ГУЩЕ",
    [4] = "КОНСУЛЬТАНТ-НЕВЕЖДА",
  },
  [7] = {
    [1] = "ДОКТОР ЗНАЛ, ЧЕМ ВСЕ КОНЧИТСЯ",
    [2] = "ХИРУРГ ВСКРЫЛ САМ СЕБЯ",
    [3] = "В ПУЧИНЕ КОРРУПЦИИ",
    [4] = "ВРАЧ В ЦЕНТРЕ СКАНДАЛА",
    [5] = "ДОКТОР ЗАПУТАЛСЯ В СЛОВАХ",
  },
}
-- 10.4  Неиспользуемые/системные/diff/хз что
debug_patient_window = {
  caption = "Debug Patient",
}
menu_debug = {
  allow_blocking_off_areas = "  РАЗРЕШИТЬ БЛОКИРОВАНИЕ ОБЛАСТЕЙ  ",
  connect_debugger = "  (%1%) СОЕДИНЕНИЕ С LUA DBGp СЕРВЕРОМ  ",
  debug_script = "  (%1%) ЗАПУСК ОТЛАДКИ СКРИПТА  ",
}
lua_console = {
  execute_code = "Выполнить",
  close = "Закрыть",
}
calls_dispatcher = {
  repair = "Починить %s",
  summary = "%d вызовов; %d назначено",
  close = "Закрыть",
  watering = "Полить @ %d,%d",
  staff = "%s - %s",
}
information = {
  level_lost = {
    [1] = "Бум! Вы проиграли этот уровень! Может быть, повезет в следующий раз.",
    [2] = "Причина проигрыша:",
    reputation = "Ваша репутация упала ниже %d.",
    balance = "Ваш банковский баланс опустился ниже %d.",
    percentage_killed = "Более %d ваших пациентов отошли в мир иной.",
    cheat = "Вы это выбрали или просто нажали не ту кнопку? Вы даже нормально обмануть не можете, не смешно, да?",
  },
  cannot_restart = "К сожалению, эта пользовательская игра была сохранена до реализации функции перезапуска.",
  custom_game = "Добро пожаловать в CorsixTH. Развлекайтесь по полной на пользовательской карте!",
  very_old_save = "Произошло много улучшений с того момента, как вы в последний раз запускали этот уровень. Чтобы быть уверенным, что все функции работают как положено, пожалуйста перезапустите его.",
  cheat_not_possible = "Не могу так жульничать на этом уровне. Вы даже обмануть не можете, не смешно, да?",
  no_custom_game_in_demo = "Извините, но в демонстрационной версии вы не можете играть в дополнительные карты.",
}
map_editor_window = {
  pages = {
    parcel_1 = "Участок 1",
    heliport_2 = "Верт. Площадка 2",
    parcel_8 = "Участок 8",
    parcel_7 = "Участок 7",
    pond = "Пруд",
    foliage = "Растительность",
    road = "Дорога",
    parcel_3 = "Участок 3",
    heliport_4 = "Верт. Площадка 4",
    heliport_1 = "Верт. Площадка 1",
    parcel_4 = "Участок 4",
    delete_wall = "Удаление стен",
    parcel_0 = "Участок 0",
    parcel_2 = "Участок 2",
    parcel_6 = "Участок 6",
    west_wall = "Западные стены",
    heliport_3 = "Верт. Площадка 3",
    inside = "Пол",
    helipad = "Helipad",
    camera_2 = "Камера 2",
    camera_1 = "Камера 1",
    hedgerow = "Изгородь",
    outside = "Тропы",
    camera_3 = "Камера 3",
    paste = "Размещать объекты",
    camera_4 = "Камера 4",
    parcel_5 = "Участок 5",
    north_wall = "Северная стена",
    parcel_9 = "Участок 9",
  },
}
custom_campaign_window = {
  caption = "Дополнительные кампании",
  start_selected_campaign = "Начать кампанию",
}
level_progress = {
  hospital_value_enough = "Не давайте стоимости больницы упасть ниже %d и разберитесь с остальными проблемами, чтобы победить.",
  cured_enough_patients = "Вы вылечили достаточно пациентов, но ваша больница еще недостаточно хороша.",
}
disease_discovered_patient_choice.need_to_employ = "Используйте %s чтобы справиться с этой ситуацией." -- This random string is needed but not sure why
multiplayer = {
  players_failed = "Следующие игроки не смогли достичь последней цели:",
  everyone_failed = "Все не смогли достичь последней цели. Так что все могут играть дальше!",
}
warnings = {
  newersave = " Внимание, вы загрузили сохранение из более новой версии CorsixTH. Не рекомендуется продолжать, так как могут произойти сбои. Играйте на свой страх и риск. ",
  levelfile_variable_is_deprecated = "Обратите внимание: Уровень '%s' содержит устаревшее определение переменной в файле уровня. '%LevelFile' был переименован в '%MapFile'. Пожалуйста, посоветуйте создателю карты обновить уровень.",
}
