/******************************************************************************/
/*                                                                            */
/*  GNU Phantom.Security 1.00                                                 */
/*  11/04/1999                                                                */
/*  Copyright (C) 1999 by Joe Thielen <jthielen@accesstoledo.com>             */
/*                                                                            */
/*  This program is free software; you can redistribute it and/or modify it   */
/*  under the terms of the GNU General Public License as published by the     */
/*  Free Software Foundation; either version 2 of the License, or (at your    */
/*  option) any later version.                                                */
/*                                                                            */
/******************************************************************************/

#include <iostream.h>
#include <stdio.h>
#include <unistd.h>
#include <asm/io.h>
#include <sys/io.h>
#include <string>
#include <fstream.h>
#include <time.h>

#define BASEPORT 0x379
#define Phantom_Log "Phantom.Log"
#define Phantom_Conf "Phantom.conf"
#define Phantom_EXIT "Phantom.EXIT"

int system(const char * string);

void get_input(string &Z, int &Z1, int &Z2, int &Z3, int &Z4, int &Z5, bool &SZ1, bool &SZ2, bool &SZ3, bool &SZ4, bool &SZ5, string &Z1_T2, string &Z2_T2, string &Z3_T2, string &Z4_T2, string &Z5_T2)
{
	/* GET_INPUT:                                                       */
	/* The routine that reads the status of the printer port.  However, */
	/* the number returned by the 'INB(X)' statement is an integer      */
	/* between 0-255.  We have five inputs, so that intenger has to be  */
	/* broken down into the five IZx (Input Zone x) variables,          */
	/* which signal if the state of the pin is high or low (on or off)  */

	int X;
	int IZ1, IZ2, IZ3, IZ4, IZ5;

	/* Get the input from the parallel port located at BASEPORT */
	X=inb(BASEPORT);
	
	/* Break 'X' down into the five Input Zones (IZx) */
	switch (X)
	{
		case 135: IZ1=0;IZ2=0;IZ3=0;IZ4=0;IZ5=0;break;
		case 143: IZ1=1;IZ2=0;IZ3=0;IZ4=0;IZ5=0;break;
		case 151: IZ1=0;IZ2=1;IZ3=0;IZ4=0;IZ5=0;break;
		case 167: IZ1=0;IZ2=0;IZ3=1;IZ4=0;IZ5=0;break;
		case 199: IZ1=0;IZ2=0;IZ3=0;IZ4=1;IZ5=0;break;
		case 7  : IZ1=0;IZ2=0;IZ3=0;IZ4=0;IZ5=1;break;
		case 159: IZ1=1;IZ2=1;IZ3=0;IZ4=0;IZ5=0;break;
		case 175: IZ1=1;IZ2=0;IZ3=1;IZ4=0;IZ5=0;break;
		case 207: IZ1=1;IZ2=0;IZ3=0;IZ4=1;IZ5=0;break;
		case 15 : IZ1=1;IZ2=0;IZ3=0;IZ4=0;IZ5=1;break;
		case 183: IZ1=0;IZ2=1;IZ3=1;IZ4=0;IZ5=0;break;
		case 215: IZ1=0;IZ2=1;IZ3=0;IZ4=1;IZ5=0;break;
		case 23 : IZ1=0;IZ2=1;IZ3=0;IZ4=0;IZ5=5;break;
		case 231: IZ1=0;IZ2=0;IZ3=1;IZ4=1;IZ5=0;break;
		case 39 : IZ1=0;IZ2=0;IZ3=1;IZ4=0;IZ5=1;break;
		case 71 : IZ1=0;IZ2=0;IZ3=0;IZ4=1;IZ5=1;break;
		case 127: IZ1=1;IZ2=1;IZ3=1;IZ4=1;IZ5=1;break;
		case 191: IZ1=1;IZ2=1;IZ3=1;IZ4=0;IZ5=0;break;
		case 63 : IZ1=1;IZ2=1;IZ3=1;IZ4=0;IZ5=1;break;
		case 247: IZ1=0;IZ2=1;IZ3=1;IZ4=1;IZ5=0;break;
		case 103: IZ1=0;IZ2=0;IZ3=1;IZ4=1;IZ5=1;break;
		case 255: IZ1=1;IZ2=1;IZ3=1;IZ4=1;IZ5=0;break;
		case 119: IZ1=0;IZ2=1;IZ3=1;IZ4=1;IZ5=1;break;
		case 95 : IZ1=1;IZ2=1;IZ3=0;IZ4=1;IZ5=1;break;
		case 111: IZ1=1;IZ2=0;IZ3=1;IZ4=1;IZ5=1;break;
		case 31 : IZ1=1;IZ2=1;IZ3=0;IZ4=0;IZ5=1;break;
		case 55 : IZ1=0;IZ2=1;IZ3=1;IZ4=0;IZ5=1;break;
		case 87 : IZ1=0;IZ2=1;IZ3=0;IZ4=1;IZ5=1;break;
		case 47 : IZ1=1;IZ2=0;IZ3=1;IZ4=0;IZ5=1;break;
		case 79 : IZ1=1;IZ2=0;IZ3=0;IZ4=1;IZ5=1;break;
		case 239: IZ1=1;IZ2=0;IZ3=1;IZ4=1;IZ5=0;break;
		case 223: IZ1=1;IZ2=1;IZ3=0;IZ4=1;IZ5=0;break;
	}

	/* The following routines are for the '.....' visual display */
	/* If a device is disabled in the .conf file, then even if the pin */
	/* is brought high, then it will still display a '.' */
	if (SZ1 == true)
	{
		if (Z1_T2 == "NC")
		{if (IZ1 == 1) {Z1 = 0;Z = ".";} else {Z1 = 1;Z = "1";}}
		else {if (IZ1 == 1) {Z1 = 1;Z = "1";} else {Z1 = 0;Z = ".";}}
	}
	else  {Z1 = 0;Z = ".";}
	if (SZ2 == true)
	{
		if (Z2_T2 == "NC")
		{if (IZ2 == 1) {Z2 = 0;Z = Z + ".";} else {Z2 = 1;Z=Z+"2";}}
		else {if (IZ2 == 1) {Z2 = 1;Z=Z+"2";} else {Z2 = 0;Z=Z+".";}}
	}
	else  {Z2 = 0;Z = Z + ".";}
	if (SZ3 == true)
	{
		if (Z3_T2 == "NC")
		{if (IZ3 == 1) {Z3 = 0;Z = Z + ".";} else {Z3 = 1;Z=Z+"3";}}
		else {if (IZ3 == 1) {Z3 = 1;Z=Z+"3";} else {Z3 = 0;Z=Z+".";}}
	}
	else  {Z3 = 0;Z = Z + ".";}
	if (SZ4 == true)
	{
		if (Z4_T2 == "NC")
		{if (IZ4 == 1) {Z4 = 0;Z = Z + ".";} else {Z4 = 1;Z=Z+"4";}}
		else {if (IZ4 == 1) {Z4 = 1;Z=Z+"4";} else {Z4 = 0;Z=Z+".";}}
	}
	else  {Z4 = 0;Z = Z + ".";}
	if (SZ5 == true)
	{
		if (Z5_T2 == "NC")
		{if (IZ5 == 1) {Z5 = 0;Z = Z + ".";} else {Z5 = 1;Z=Z+"5";}}
		else {if (IZ5 == 1) {Z5 = 1;Z=Z+"5";} else {Z5 = 0;Z=Z+".";}}
	}
	else  {Z5 = 0;Z = Z + ".";}
}

void update_dsp(bool &plb_dsp_enable, string &Z)
{
	/* If the display is enabled, then update it by displaying 5  */
	/* backspaces and then Z, which is the '.....' status display */
	if (plb_dsp_enable == true) {cout << "\r" << Z;};
}

void init_dsp(bool &plb_dsp_enable)
{
	/* Initialize the display with program name and version info */
	if (plb_dsp_enable == true) 
		{
			cout << endl;
			cout << "Phantom Computer Controlled Security System" << endl << endl;
			cout << "Copyright (C) 1999 by Joe Thielen <jthielen@accesstoledo.com>" << endl << endl;
			cout << "This program is free software; you can redistribute it and/or modify it" << endl;
			cout << "under the terms of the GNU General Public License as published by the " << endl;
			cout << "Free Software Foundation; either version 2 of the License, or (at your" << endl;
			cout << "option) any later version." << endl;
			cout << "See the file COPYING for more details." << endl<< endl;
			cout << "GNU Phantom.Security" << endl;
			cout << "Version: " << VERSION << endl;
			cout << "-------------------" << endl;
		}
}

void update_log(string &Z, ofstream& log, bool &SZ1, bool &SZ2, bool &SZ3, bool &SZ4, bool &SZ5, int &OZ1, int &OZ2, int &OZ3, int &OZ4, int &OZ5, int &Z1, int &Z2, int &Z3, int &Z4, int &Z5, string &Z1_T1, string &Z2_T1, string &Z3_T1, string &Z4_T1, string &Z5_T1, string &Z1_T3, string &Z2_T3, string &Z3_T3, string &Z4_T3, string &Z5_T3, int &Z1W, int &Z2W, int &Z3W, int &Z4W, int &Z5W, int &Z1__T, int &Z2__T, int &Z3__T, int &Z4__T, int &Z5__T, int &Z1__T2, int &Z2__T2, int &Z3__T2, int &Z4__T2, int &Z5__T2, int &SD_D)
{
		/* UPDATE_LOG: */
		/* This is a somewhat complicated function.  Basically,      */
		/* it determines which devices are active and logs this.     */
		/* However, if a device is active for like 60 cycles, then   */
		/* the log would start to get rather large, so I've          */
		/* implemented a system where a device is ONLY logged if     */
		/* it's not been activated the cycle before.  This really    */
		/* cuts down on log space and makes it SOOO much more easier */
		/* to read...                                                */
		
		time_t curtime;
		struct tm *loctime;

		curtime = time (NULL);
		loctime = localtime (&curtime);

		/* Open the log file */
		log.open(Phantom_Log, ios::app);

		/* Uncomment the next line for the OG style logging */
		/* log << Z << " " << asctime(loctime) ;            */

			if (Z1 == 1)
			{
				if (Z1W + 5 <= curtime || Z1W == 0 || Z1W == 1)
				{
					if (Z1W != 1) {Z1W = curtime;}

				if (Z1_T1 == "Door Magnet")
				{
					if (OZ1 == 0) {log << "1.... DM   ACTIVATED: " << Z1_T3 << " " << asctime(loctime); Z1__T2 = 1;}
				}
				if (Z1_T1 == "Motion Sensor")
				{
					if (OZ1 == 0) {log << "1.... MS     TRIPPED: " << Z1_T3 << " " << asctime(loctime);}
				}
				if (Z1_T1 == "Smoke Detector")
				{
					if (OZ1 == 0) {Z1__T = curtime;}
					if (OZ1 == 1 && Z1__T2 == 0) {if (curtime - SD_D >= Z1__T) {Z1__T2 = 1; log << "1.... SD     TRIPPED: " << Z1_T3 << " " << asctime(loctime);}}
				}
				}
				else
				{Z1 = 0;}
			}
			else
			{
				if (Z1_T1 == "Door Magnet")
				{
					if (OZ1 == 1) {log << "1.... DM DEACTIVATED: " << Z1_T3 << " " << asctime(loctime); Z1__T2 = 0;}
				}
				if (Z1_T1 == "Smoke Detector")
				{
					if (OZ1 == 1) 
					{
						Z1__T = 0;
						Z1__T2 = 0;
					}
				}
			}
			OZ1 = Z1;

			if (Z2 == 1)
			{
				if (Z2W + 5 <= curtime || Z2W == 0 || Z2W == 1)
				{
					if (Z2W != 1) {Z2W = curtime;}

				if (Z2_T1 == "Door Magnet")
				{
					if (OZ2 == 0) {log << ".2... DM   ACTIVATED: " << Z2_T3 << " " << asctime(loctime); Z2__T2 = 1;}
				}
				if (Z2_T1 == "Motion Sensor")
				{
					if (OZ2 == 0) {log << ".2... MS     TRIPPED: " << Z2_T3 << " " << asctime(loctime);}
				}
				if (Z2_T1 == "Smoke Detector")
				{
					if (OZ2 == 0) {Z2__T = curtime;}
					if (OZ2 == 1 && Z2__T2 == 0) {if (curtime - SD_D >= Z2__T) {Z2__T2 = 1; log << ".2... SD     TRIPPED: " << Z2_T3 << " " << asctime(loctime);}}
				}
				}
				else
				{Z2 = 0;}
			}
			else
			{
				if (Z2_T1 == "Door Magnet")
				{
					if (OZ2 == 1) {log << ".2... DM DEACTIVATED: " << Z2_T3 << " " << asctime(loctime); Z2__T2 = 0;}
				}
				if (Z2_T1 == "Smoke Detector")
				{
					if (OZ2 == 1) 
					{
						Z2__T = 0;
						Z2__T2 = 0;
					}
				}
			
			}
			OZ2 = Z2;

			if (Z3 == 1)
			{
				if (Z3W + 5 <= curtime || Z3W == 0 || Z3W == 1)
				{
					if (Z3W != 1) {Z3W = curtime;}
	
				if (Z3_T1 == "Door Magnet")
				{
					if (OZ3 == 0) {log << "..3.. DM   ACTIVATED: " << Z3_T3 << " " << asctime(loctime); Z3__T2 = 1;}
				}
				if (Z3_T1 == "Motion Sensor")
				{
					if (OZ3 == 0) {log << "..3.. MS     TRIPPED: " << Z3_T3 << " " << asctime(loctime);}
				}
				if (Z3_T1 == "Smoke Detector")
				{
					if (OZ3 == 0) {Z3__T = curtime;}
					if (OZ3 == 1 && Z3__T2 == 0) {if (curtime - 3 >= Z3__T) {Z3__T2 = 1; log << "..3.. SD     TRIPPED: " << Z3_T3 << " " << asctime(loctime);}}
				}
				}
				else
				{Z3 = 0;}
			}
			else
			{
				if (Z3_T1 == "Door Magnet")
				{
					if (OZ3 == 1) {log << "..3.. DM DEACTIVATED: " << Z3_T3 << " " << asctime(loctime); Z3__T2 = 0;}
				}
				if (Z3_T1 == "Smoke Detector")
				{
					if (OZ3 == 1) 
					{
						Z3__T = 0;
						Z3__T2 = 0;
					}
				}
			}
			OZ3 = Z3;

			if (Z4 == 1)
			{
				if (Z4W + 5 <= curtime || Z4W == 0 || Z4W == 1)
				{
					if (Z4W != 1) {Z4W = curtime;}

				if (Z4_T1 == "Door Magnet")
				{
					if (OZ4 == 0) {log << "...4. DM   ACTIVATED: " << Z4_T3 << " " << asctime(loctime); Z4__T2 = 1;}
				}
				if (Z4_T1 == "Motion Sensor")
				{
					if (OZ4 == 0) {log << "...4. MS     TRIPPED: " << Z4_T3 << " " << asctime(loctime);}
				}
				if (Z4_T1 == "Smoke Detector")
				{
					if (OZ4 == 0) {Z4__T = curtime;}
					if (OZ4 == 1 && Z4__T2 == 0) {if (curtime - SD_D >= Z4__T) {Z4__T2 = 1; log << "...4. SD     TRIPPED: " << Z4_T3 << " " << asctime(loctime);}}
				}
				}
				else
				{Z4 = 0;}
			}
			else
			{
				if (Z4_T1 == "Door Magnet")
				{
					if (OZ4 == 1) {log << "...4. DM DEACTIVATED: " << Z4_T3 << " " << asctime(loctime); Z4__T2 = 0;}
				}
				if (Z4_T1 == "Smoke Detector")
				{
					if (OZ4 == 1) 
					{
						Z4__T = 0;
						Z4__T2 = 0;
					}
				}
			}
			OZ4 = Z4;

			if (Z5 == 1)
			{
				if (Z5W + 5 <= curtime || Z5W == 0 || Z5W == 1)
				{
					if (Z5W != 1) {Z5W = curtime;}

				if (Z5_T1 == "Door Magnet")
				{
					if (OZ5 == 0) {log << "....5 DM   ACTIVATED: " << Z5_T3 << " " << asctime(loctime); Z5__T2 = 1;}
				}
				if (Z5_T1 == "Motion Sensor")
				{
					if (OZ5 == 0) {log << "....5 MS     TRIPPED: " << Z5_T3 << " " << asctime(loctime);}
				}
				if (Z5_T1 == "Smoke Detector")
				{
					if (OZ5 == 0) {Z5__T = curtime;}
					if (OZ5 == 1 && Z5__T2 == 0) {if (curtime - SD_D >= Z5__T) {Z5__T2 = 1; log << "....5 SD     TRIPPED: " << Z5_T3 << " " << asctime(loctime);}}
				}
				}
				else
				{Z5 = 0;}
			}
			else
			{
				if (Z5_T1 == "Door Magnet")
				{
					if (OZ5 == 1) {log << "....5 DM DEACTIVATED: " << Z5_T3 << " " << asctime(loctime); Z5__T2 = 0;}
				}
				if (Z5_T1 == "Smoke Detector")
				{
					if (OZ5 == 1) 
					{
						Z5__T = 0;
						Z5__T2 = 0;
					}
				}
			}
			OZ5 = Z5;

		/* Close the log file */
		log.close();
}

void init_log(ofstream& log, int &OZ1, int &OZ2, int &OZ3, int &OZ4, int &OZ5)
{
		/* INIT_LOG:                                        */
		/* Open and initialize the log.  Put in the program */
		/* name and version info.                           */

		time_t curtime;
		struct tm *loctime;
			
		curtime = time (NULL);
		loctime = localtime (&curtime);
	
		OZ1 = 0;
		OZ2 = 0;
		OZ3 = 0;
		OZ4 = 0;
		OZ5 = 0;

		/* Open the log file */
		log.open(Phantom_Log, ios::app);

		/* Write the program name and version info */
		log << "GNU Phantom.Security " << VERSION << " START: " << asctime(loctime) ;

		/* Close the log file */
		log.close();
}

void parse_conf(ifstream& conf, bool &SZ1, bool &SZ2, bool &SZ3, bool &SZ4, bool &SZ5, string &Z1_T1, string &Z2_T1, string &Z3_T1, string &Z4_T1, string &Z5_T1, string &Z1_T2, string &Z2_T2, string &Z3_T2, string &Z4_T2, string &Z5_T2, string &Z1_T3, string &Z2_T3, string &Z3_T3, string &Z4_T3, string &Z5_T3, bool &plb_dsp_enable, int &Z1W, int &Z2W, int &Z3W, int &Z4W, int &Z5W, bool &ef, int &returnstatus, bool &nologentry)
{
	/* PARSE_CONF:                                                     */
	/* I hate parsing files.  This is a VERY basic file parser, and if */
	/* format is not correct, then it will most likely not work very   */
	/* well.  I loved my Bourne Shell parser, but for the sake of      */
	/* cross-platformability, I've compromised.  Feel free to tweak!   */
	/* And if you have a better system, please LET ME KNOW!!!          */

	const char nwln = '\n';
	char x;
	int i;
	string q1, q2, q3, q4, q5, q6;

	/* Open up the configuration file */
	conf.open (Phantom_Conf);	

	if (!conf.fail())
	{
	/* Start the process by getting the first char */
	conf.get (x);
	while (!conf.eof ())
	{
		i = 1;
		q1 = "";
		q2 = "";
		q3 = "";
		q4 = "";
		q5 = "";
		q6 = "";
		while (x != nwln)
		{
				if (x != ':')
				{
					if (i == 1) {q1 = q1 + x;}
					if (i == 2) {q2 = q2 + x;}
					if (i == 3) {q3 = q3 + x;}
					if (i == 4) {q4 = q4 + x;}
					if (i == 5) {q5 = q5 + x;}
					if (i == 6) {q6 = q6 + x;}
					conf.get (x);
				}
				else 
				{
					i++;
					conf.get (x);
				}
		}
		conf.get (x);

		if (q1 == "ZONE1")
		{
			if (q2 == "Enabled") 
			{
				SZ1 = true;
				Z1_T1 = q3;
				Z1_T2 = q4;
				if (q5 == "0") {Z1W = 1;} else {Z1W = 5;}
				Z1_T3 = q6;
			}
			else
			{
				SZ1 = false;
			}
		}
		if (q1 == "ZONE2")
		{
			if (q2 == "Enabled")
			{
				SZ2 = true;
				Z2_T1 = q3;
				Z2_T2 = q4;
				if (q5 == "0") {Z2W = 1;} else {Z2W = 5;}
				Z2_T3 = q6;
			}
			else
			{
				SZ2 = false;
			}
		}
		if (q1 == "ZONE3")
		{
			if (q2 == "Enabled")
			{
				SZ3 = true;
				Z3_T1 = q3;
				Z3_T2 = q4;
				if (q5 == "0") {Z3W = 1;} else {Z3W = 5;}
				Z3_T3 = q6;
			}
			else
			{
				SZ3 = false;
			}
		}
		if (q1 == "ZONE4")
		{
			if (q2 == "Enabled")
			{
				SZ4 = true;
				Z4_T1 = q3;
				Z4_T2 = q4;
				if (q5 == "0") {Z4W = 1;} else {Z4W = 5;}
				Z4_T3 = q6;
			}
			else
			{
				SZ4 = false;
			}
		}
		if (q1 == "ZONE5")
		{
			if (q2 == "Enabled")
			{
				SZ5 = true;
				Z5_T1 = q3;
				Z5_T2 = q4;
				if (q5 == "0") {Z5W = 1;} else {Z5W = 5;}
				Z5_T3 = q6;
			}
			else
			{
				SZ5 = false;
			}
		}
	}

	/* Close out the file */
	conf.close();

	}
	else
	{
			cout << "FATAL ERROR: Cannot find Phantom.conf" << endl;
			cout << endl;
			ef=true;
			plb_dsp_enable=false;
			returnstatus=1;
			nologentry=true;
	}

	/* Now that we got that all over and done, let's display the results */
	/* IF we're allowed, of course...                                    */
	if (plb_dsp_enable == true) 
	{
		if (SZ1 == true) 
			cout << "ZONE 1 is a " << Z1_T2 << " " << Z1_T1 << " : " << Z1_T3 << endl;
		else
			cout << "ZONE 1 is disabled" << endl;
		if (SZ2 == true)
			cout << "ZONE 2 is a " << Z2_T2 << " " << Z2_T1 << " : " << Z2_T3 << endl;
		else
			cout << "ZONE 2 is disabled" << endl;
		if (SZ3 == true)
			cout << "ZONE 3 is a " << Z3_T2 << " " << Z3_T1 << " : " << Z3_T3 << endl;
		else
			cout << "ZONE 3 is disabled" << endl;
		if (SZ4 == true)
			cout << "ZONE 4 is a " << Z4_T2 << " " << Z4_T1 << " : " << Z4_T3 << endl;
		else
			cout << "ZONE 4 is disabled" << endl;
		if (SZ5 == true)
			cout << "ZONE 5 is a " << Z5_T2 << " " << Z5_T1 << " : " << Z5_T3 << endl;
		else
			cout << "ZONE 5 is disabled" << endl;
	}
}

void exit_prog(bool &plb_dsp_enable, ofstream &log, bool nologentry)
{
	/* EXIT_PROG:                                                     */
	/* If the exit flag has been given, then this function closes the */
	/* log, updates the display, and ends the program (well... kinda) */
	
	time_t curtime;
	struct tm *loctime;
	curtime = time(NULL);
	loctime = localtime(&curtime);

	if (nologentry==false)
	{
		log.open(Phantom_Log, ios::app);
		log << "END PROGRAM : " << asctime(loctime) << endl ;
		log.close ();
	}

	if (plb_dsp_enable == true) {cout << endl << "END PROGRAM : " << asctime(loctime) << endl;}
}

void exit_check(bool &ef, ifstream& exit)
{
	/* EXIT_CHECK:                                                       */
	/* This function checks for the existance of the Phantom.EXIT file.  */
	/* If it exists and contains an 'x', then the exit flag is set.      */
	/* The reason for this approach as apposed to a typped key exit is   */
	/* because someone may want to run this in the background, and won't */
	/* have any other way to stop the program (except to kill the        */
	/* process, but that won't close the log properly).                  */
	char x;
	
	/* Open the Phantom.Exit file) */
	exit.open (Phantom_EXIT);

	/* see if the file contains an 'x' */
	while (!exit.eof ())
	{
		exit.get(x);
		if (x == 'x')
		{
			ef = true;
		}
	}
	/* Close the Phantom.Exit file */
	exit.close();	
}

void cop(int &Z1, int &Z2, int &Z3, int &Z4, int &Z5, bool &SZ1, bool &SZ2, bool &SZ3, bool &SZ4, bool &SZ5, string &Z1_T1, string &Z2_T1, string &Z3_T1, string &Z4_T1, string &Z5_T1, int &Z1__T2, int &Z2__T2, int &Z3__T2, int &Z4__T2, int &Z5__T2)
{
	/* COP:                                                               */
	/* This routine is the interface to the physical world.  This is      */
	/* where the possibilities of Phantom shine.  Using the firealert and */
	/* intruderalert scripts (or batch files???) you can have them send   */
	/* pages, ring an alarm, make computers beep, or even fax you at home!*/
	/* I don't have the Motion Sensor included here, but as you can see,  */
	/* it would be pretty easy to do so.  Look for it in a future version!*/

	if (Z1 == 1)
	{
		if (Z1_T1 == "Smoke Detector")
		{
			if (Z1__T2 == 1) {system("firealert 1 &"); Z1__T2 = 2;}
		}
		if (Z1_T1 == "Door Magnet")
		{
			if (Z1__T2 == 1) {system("intruderalert 1 &"); Z1__T2 = 2;}
		}
	}
	if (Z2 == 1)
	{
		if (Z2_T1 == "Smoke Detector")
		{
			if (Z2__T2 == 1) {system("firealert 2 &"); Z2__T2 = 2;}
		}
		if (Z2_T1 == "Door Magnet")
		{
			if (Z2__T2 == 1) {system("intruderalert 2 &"); Z2__T2 = 2;}
		}
	}
	if (Z3 == 1)
	{
		if (Z3_T1 == "Smoke Detector")
		{
			if (Z3__T2 == 1) {system("firealert 3 &"); Z3__T2 = 2;}
		}
		if (Z3_T1 == "Door Magnet")
		{
			if (Z3__T2 == 1) {system("intruderalert 3 &"); Z3__T2 = 2;}
		}
	}
	if (Z4 == 1)
	{
		if (Z4_T1 == "Smoke Detector")
		{
			if (Z4__T2 == 1) {system("firealert 4 &"); Z4__T2 = 2;}
		}
		if (Z4_T1 == "Door Magnet")
		{
			if (Z4__T2 == 1) {system("intruderalert 4 &"); Z4__T2 = 2;}
		}
	}
	if (Z5 == 1)
	{
		if (Z5_T1 == "Smoke Detector")
		{
			if (Z5__T2 == 1) {system("firealert 5 &"); Z5__T2 = 2;}
		}
		if (Z5_T1 == "Door Magnet")
		{
			if (Z5__T2 == 1) {system("intruderalert 5 &"); Z5__T2 = 2;}
		}
	}
}

int main(int argc, char *argv[])
{
	/* Declare the 5 ZONE variables as Integers */
	int Z1, Z2, Z3, Z4, Z5;
	int OZ1, OZ2, OZ3, OZ4, OZ5;
	/* Declare the 5 ZONE Status vars as booleans */
	bool SZ1, SZ2, SZ3, SZ4, SZ5;
	/* Declare the 5 ZONE Type vars as strings */
	string Z1_T1, Z2_T1, Z3_T1, Z4_T1, Z5_T1;
	/* Declare the 5 ZONE Type vars as strings */
	string Z1_T2, Z2_T2, Z3_T2, Z4_T2, Z5_T2;
	/* Declare the 5 ZONE Loc vars as strings */
	string Z1_T3, Z2_T3, Z3_T3, Z4_T3, Z5_T3;
	/* Declare the 5 ZONE WAIT STATES */
	int Z1W, Z2W, Z3W, Z4W, Z5W;
	/* Declare the Z variable as a strong ZONE indicator */
	string Z;
	/* Decalre the 5 ZONE Smoke Detector Trip State Vars */
	int Z1__T, Z2__T, Z3__T, Z4__T, Z5__T;
	int Z1__T2, Z2__T2, Z3__T2, Z4__T2, Z5__T2;
	/* Declare Smoke Detector 'false read eliminator' delay */
	int SD_D;
	/* Declare log as output file stream */
	ofstream log;
	/* Declare conf as input file stream */
	ifstream conf;
	/* Declare exit as input file stream */
	ifstream exit;
	/* Declare ef as boolean exit flag*/
	bool ef;
	/* Declare counter as int */
	int counter;
	/* Declare temp as a string */
	string temp;
	/* Declare nologentry as a bool */
	bool nologentry;
	/* Declare returnstatus as int */
	int returnstatus;

	/* Do TIME & DATE stuff */
	time_t curtime;
	struct tm *loctime;
	curtime = time(NULL);
	loctime = localtime(&curtime);

	/* ---------- CONTROL PANEL ---------- */
	/* Enable or disable the display (dsp) */
	bool plb_dsp_enable = true;
	/* Length of Smoke Detector 'false read elimiator' delay.       */
	/* This is due to the fact that periodically my smoke detector  */
	/* sends out a short electrical burst.  But it lasts less than  */
	/* a second usually.  So instead, I wait 3 seconds, and if its  */
	/* still going off, then do something!!!  If this doesn't apply */
	/* to yours, simple change it to '0'.                           */
	SD_D = 3;
	/* ---------- CONTROL PANEL ---------- */
	
	/* ---------- INIT VARS ---------- */
	ef = false;
	Z1__T2 = 0;
	Z2__T2 = 0;
	Z3__T2 = 0;
	Z4__T2 = 0;
	Z5__T2 = 0;
	nologentry = false;
	returnstatus = 0;
	/* ---------- INIT VARS ---------- */

	/* ---------- PARSE COMMAND LINE --------- */
	for (counter = 1; counter < argc; counter++)
	{
		temp=argv[counter];

		if (temp=="--version")
		{
			cout << "GNU Phantom.Security " << VERSION << endl;
			cout << "Copyright (C) 1999 by Joe Thielen <jthielen@accesstoledo.com>" << endl;
			cout << "GNU Phantom.Security comes with NO WARRANTY," << endl;
			cout << "to the extent permitted by law." << endl;
			cout << "You may redistribute copies of GNU Phantom.Security" << endl;
			cout << "under the terms of the GNU General Public License" << endl;
			cout << "For more information about these matters," << endl;
			cout << "see the file named COPYING." << endl << endl;
			ef=true;
			plb_dsp_enable=false;
			nologentry = true;
			returnstatus = 0;
		}

		if (temp=="--help")
		{
			cout << "GNU Phantom.Security " << VERSION << endl;
			cout << "Copyright (C) 1999 by Joe Thielen <jthielen@accesstoledo.com>" << endl << endl;
			cout << "Arguments: " << endl;	
			cout << "--help        To get this list" << endl;
			cout << "--version     To get the version" << endl;
			cout << "--noscreen    To disable screen output" << endl << endl << endl;
			cout << "Use 'Phantom.Security --noscreen &' to push processing into the background." << endl; 
			cout << endl;
			ef=true;
			plb_dsp_enable=false;
			nologentry = true;
			returnstatus = 0;
		}

		if (temp=="--noscreen")
		{
			plb_dsp_enable=false;
		}
	}
	/* ---------- PARSE COMMAND LINE --------- */
	

	if (ef==false)
	{

		/* Parse Phantom.conf configuration file */
		parse_conf(conf, SZ1, SZ2, SZ3, SZ4, SZ5, Z1_T1, Z2_T1, Z3_T1, Z4_T1, Z5_T1, Z1_T2, Z2_T2, Z3_T2, Z4_T2, Z5_T2, Z1_T3, Z2_T3, Z3_T3, Z4_T3, Z5_T3, plb_dsp_enable, Z1W, Z2W, Z3W, Z4W, Z5W, ef, returnstatus, nologentry);
		
		/* Enable the program to use I/O */
		ioperm(BASEPORT, 3, 1);

		if (ef==false)
		{
			/* Initialize the display */
			init_dsp(plb_dsp_enable);

			/* Initialize logging */
			init_log(log, OZ1, OZ2, OZ3, OZ4, OZ5);
		}
	}

	/* -----MAIN PROGRAM LOOP----- */
	while (ef != true)
	{	
		/* 1st - Get Input */
		get_input(Z, Z1, Z2, Z3, Z4, Z5, SZ1, SZ2, SZ3, SZ4, SZ5, Z1_T2, Z2_T2, Z3_T2, Z4_T2, Z5_T2);	
		/* 2nd - Update Display */
		update_dsp(plb_dsp_enable, Z);		
		/* 3rd - Update Log */
		update_log(Z, log, SZ1, SZ2, SZ3, SZ4, SZ5, OZ1, OZ2, OZ3, OZ4, OZ5, Z1, Z2, Z3, Z4, Z5, Z1_T1, Z2_T1, Z3_T1, Z4_T1, Z5_T1, Z1_T3, Z2_T3, Z3_T3, Z4_T3, Z5_T3, Z1W, Z2W, Z3W, Z4W, Z5W, Z1__T, Z2__T, Z3__T, Z4__T, Z5__T, Z1__T2, Z2__T2, Z3__T2, Z4__T2, Z5__T2, SD_D);
		/* 5th - Phantom.Cop */
		cop(Z1, Z2, Z3, Z4, Z5, SZ1, SZ2, SZ3, SZ4, SZ5, Z1_T1, Z2_T1, Z3_T1, Z4_T1, Z5_T1, Z1__T2, Z2__T2, Z3__T2, Z4__T2, Z5__T2);
		/* 4th - Check for exitflag */
		exit_check(ef, exit);
	}	
	
	/* If we get here, then we must want to exit! */
	exit_prog(plb_dsp_enable, log, nologentry);

	/* Return something... */
	return returnstatus;
}
