/* -*-c-*- -------------- mixgtk_widgets.c :
 * Implementation of the functions declared in mixgtk_widgets.h
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: "2001-04-29 14:32:17 jao"
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */



#include <glade/glade.h>
#include <mixlib/mix.h>
#include "mixgtk_config.h"
#include "mixgtk_widgets.h"

/* dialog names */
static const gchar * dnames_[] = {
  "main_window",
  "mixvm_window",
  "mixal_window",
  "devices_window",
  "word_dialog",
  "about_dialog",
  "goto_dialog",
  "color_dialog",
  "colorsel_dialog",
  "fontsel_dialog",
  "devform_dialog",
  "external_dialog",
  "symbols_dialog",
  "devdir_dialog"
};

const gchar *SPLIT_MAIN_NAME_ = "split_main_window";
const gchar *MAIN_NAME_ = "main_window";

#define DLG_NO_ (sizeof (dnames_) / sizeof(dnames_[0]))

/* widget names */
static const gchar *names_[] = {
  "main_statusbar",
  "mixvm_widget",
  "command_prompt",
  "command_log",
  "mixal_clist",
  "rA_entry",
  "rX_entry",
  "rJ_entry",
  "rI1_entry",
  "rI2_entry",
  "rI3_entry",
  "rI4_entry",
  "rI5_entry",
  "rI6_entry",
  "lesser_radio",
  "equal_radio",
  "greater_radio",
  "over_toggle",
  "memory_cells",
  "elapsed_label",
  "program_label",
  "uptime_label",
  "memory_scroll",
  "devices_notebook",
  "loc_entry",
  NULL
};

#define WIDGET_NO_ (sizeof (names_) / sizeof (names_[0]))

#define VERSION_LABEL_ "version_label"
#define GPL_TEXT_ "gpl_text"
#define AUTOSAVE_ITEM_ "save_on_exit"

static gboolean split_;

/* the glade specs */
static GladeXML *xml_[DLG_NO_] = {NULL};
/* the about dialog */
static GtkWidget *about_ = NULL;

/* the xml file name */
static const gchar *file_ = NULL;

static void init_xml_ (mixgtk_dialog_id_t dlg)
{
  xml_[dlg] = glade_xml_new (file_, dnames_[dlg]);
  glade_xml_signal_autoconnect (xml_[dlg]);
  g_assert (xml_[dlg] != NULL);
}

static void
init_autosave_ (void)
{
  GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM
    (mixgtk_widget_factory_get_child_by_name
     (MIXGTK_MAIN, AUTOSAVE_ITEM_));
  if (item)
    {
      gtk_check_menu_item_set_active (item, mixgtk_config_is_autosave ());
    }
}

static void
init_about_ (void)
{
  GtkWidget *label;
  about_ = mixgtk_widget_factory_get_dialog (MIXGTK_ABOUT_DIALOG);
  g_assert (about_ != NULL);
  label = mixgtk_widget_factory_get_child_by_name (MIXGTK_ABOUT_DIALOG,
						   VERSION_LABEL_);
  g_assert (label != NULL);
  gtk_label_set_text (GTK_LABEL(label), VERSION);
  gtk_widget_show (label);
}

/* create a new factory from an xml glade file */
gboolean
mixgtk_widget_factory_init (void)
{
  const gchar *glade_file = GLADE_FILE;
  const gchar *local_glade_file = LOCAL_GLADE_FILE;
  FILE *f;
  gboolean split = mixgtk_config_is_split ();
  
  about_ = NULL;
  
  if (!file_)
    {
      glade_init ();
      f = fopen (glade_file, "r");
      if (!f) {
	f = fopen (local_glade_file, "r");
	if (!f) return FALSE;
	glade_file = local_glade_file;
      }
      fclose (f);
      file_ = g_strdup (glade_file);
    }
  else
    {
      gint k;
      for (k = 0; k < DLG_NO_; ++k) if (xml_[k]) xml_[k] = NULL;
    }
  
  split_ = split;
  
  dnames_[MIXGTK_MAIN] = split_? SPLIT_MAIN_NAME_ : MAIN_NAME_;

  init_xml_ (MIXGTK_MAIN);
  init_autosave_ ();
  return TRUE;
}

/* get a widget */
GtkWidget *
mixgtk_widget_factory_get (mixgtk_dialog_id_t dlg, mixgtk_widget_id_t widget)
{
  g_return_val_if_fail (widget < WIDGET_NO_, NULL);
  if (!split_ && dlg < MIXGTK_WORD_DIALOG) dlg = MIXGTK_MAIN;
  return mixgtk_widget_factory_get_child_by_name (dlg, names_[widget]);
}


GtkWidget *
mixgtk_widget_factory_get_dialog (mixgtk_dialog_id_t dlg)
{
  if (!split_ && dlg < MIXGTK_WORD_DIALOG) dlg = MIXGTK_MAIN;
  if (!xml_[dlg]) init_xml_ (dlg);
  return glade_xml_get_widget (xml_[dlg], dnames_[dlg]);
}

GtkWidget *
mixgtk_widget_factory_get_child_by_name (mixgtk_dialog_id_t dlg,
					 const gchar *name)
{
  g_return_val_if_fail (dlg < DLG_NO_, NULL);
  g_return_val_if_fail (name != NULL, NULL);
  if (!split_ && dlg < MIXGTK_WORD_DIALOG) dlg = MIXGTK_MAIN;
  if (!xml_[dlg]) init_xml_ (dlg);
  return glade_xml_get_widget (xml_[dlg], name);
}


/* about box */
void
on_about_activate (GtkWidget *w, gpointer data)
{
  if (!about_) init_about_ ();
  gtk_widget_show (about_);
}
