/*
 * Decompiled with CFR 0.152.
 */
package org.domterm.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class Utf8WriterOutputStream
extends OutputStream {
    Writer out;
    int partialChar;
    int bytesNeeded = 0;

    public Utf8WriterOutputStream(Writer writer) {
        this.out = writer;
    }

    @Override
    public void write(int n) throws IOException {
        if (n >= 0) {
            this.partialChar = n;
            this.bytesNeeded = 0;
        } else if ((n & 0xC0) == 64) {
            this.partialChar = this.partialChar << 6 | n & 0x3F;
            --this.bytesNeeded;
        } else if ((n & 0xE0) == 192) {
            this.partialChar = n & 0x1F;
            this.bytesNeeded = 1;
        } else if ((n & 0xF0) == 224) {
            this.partialChar = n & 0xF;
            this.bytesNeeded = 2;
        } else if ((n & 0xF8) == 240) {
            this.partialChar = n & 7;
            this.bytesNeeded = 3;
        } else if ((n & 0xFC0) == 248) {
            this.partialChar = n & 3;
            this.bytesNeeded = 4;
        }
        if (this.bytesNeeded == 0) {
            int n2 = this.partialChar;
            if (n2 > 65536) {
                this.out.write((char)((n2 - 65536 >> 10) + 55296));
                n2 = (n2 & 0x3FF) + 56320;
            }
            this.out.write((char)n2);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

