/************************************************************
 *
 *         I R I S P L O T
 *                           ------------ graph1.h
 *
 *      Copyright 1989 Zou Maorong
 *
 ************************************************************/

#include "const.h"

/*
 *  User defined axes
 */
struct uaxes
{
  float ox,oy,oz;
  float xx,xy,xz,yx,yy,yz,zx,zy,zz;
  int ticmarks;
};

struct surface 
{
  int    sample,sample1;
  int    is_wire,oren;
  float ***sx, ***snx,**cx;
  struct a_polygon *poly;
  struct a_cvn_point *cvn;
  struct fea_poly *fea_poly;
  struct uaxes *uaxes;
};

struct curve
{
  int    sample,sample1;
  int    color,style;
  float  ***cx;
  struct a_polygon *poly;
  struct a_cvn_point *cvn;
  struct fea_poly *fea_poly;
  struct uaxes *uaxes;
};

struct contour
{
  int   n_cs, nn_cs, **npts;
  float ***sx, **cx;
  struct uaxes *uaxes;
};

struct map
{
  int sample;
  int color;
  float **cx;
  struct uaxes *uaxes;
};

struct eqn
{
  int sample;
  int color;
  float **cx;
  struct uaxes *uaxes;
};

struct tmesh
{
  int sample, sample1,oren;
  float ***sx,***snx;
  struct uaxes *uaxes;
};

struct a_graph
{
  int type,data_type;
  union
    {
      struct surface surface;
      struct curve   curve;
      struct tmesh   tmesh;
      struct contour contour;
      struct map     map;
      struct eqn     eqn;
    }  picture;
};

struct an_object
{
  int num_action;
  float  *actions;
  struct an_object *next;
};

struct a_cvn_point 
{
  float *x;
  char c;
  struct a_cvn_point *next;
};

struct a_polygon
{
  int num_points;
  float **points;
  float **norm;
  struct a_polygon *next;
};

struct fea_poly
{
  float **x;
  float **nx;
  int nv,np, **nn;
  struct fea_poly *next;
};

/****************************************************************************/

