/*-
 * Copyright (c) 2001 The FreeBSD Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/4/include/complex.h 86827 2001-11-23 16:16:18Z dd $
 */

#ifndef _COMPLEX_H
#define _COMPLEX_H

#ifdef __GNUC__
#define _Complex	__complex__
#define _Complex_I	1.0fi
#endif

#define complex		_Complex
#define I		_Complex_I

#include <sys/cdefs.h>

__BEGIN_DECLS

double	cabs __P((double complex));
float	cabsf __P((float complex));
double	cimag __P((double complex));
float	cimagf __P((float complex));
double	creal __P((double complex));
float	crealf __P((float complex));

__END_DECLS

#ifdef __GNUC__
#define cimag(z)	(__imag__ (z))
#define cimagf(z)	(__imag__ (z))
#define creal(z)	(__real__ (z))
#define crealf(z)	(__real__ (z))
#endif

#endif /* _COMPLEX_H */
