#
# $FreeBSD: head/lang/ghc/bsd.hackage.mk 447548 2017-08-08 17:21:45Z tcberner $
#
# bsd.hackage.mk -- List of Haskell Cabal ports.
#
# Created by: Gabor Pali <pgj@FreeBSD.org>,
# Based on works of Giuseppe Pilichi and Ashish Shukla.
#
# Maintained by: haskell@FreeBSD.org
#

# List of packages installed by lang/ghc (stage2 packages).
# In the future we could think of installing only ghc and base packages,
# and using unbundles versions for the rest of these
# ghc-8.0.2 provides:  Cabal-1.24.2.0 array-0.5.1.1 base-4.9.1.0 binary-0.8.3.0
#                      bytestring-0.10.8.1 containers-0.5.7.1 deepseq-1.4.2.0
#                      directory-1.3.0.0 filepath-1.4.1.1 ghc-8.0.2
#                      ghc-boot-8.0.2 ghc-boot-th-8.0.2 ghc-prim-0.5.0.0
#                      ghci-8.0.2 haskeline-0.7.3.0 hoopl-3.10.2.1 hpc-0.6.0.3
#                      integer-gmp-1.0.0.1 pretty-1.1.3.3 process-1.4.3.0
#                      template-haskell-2.11.1.0 terminfo-0.4.0.2 time-1.6.0.1
#                      transformers-0.5.2.0 unix-2.7.2.1 xhtml-3000.2.1
# Note: it's important to make sure that the versions for the hs-* ports are
#       compatible with these, i.e. sometimes we cannot pick the newest one.
GHC_STAGE2_PACKAGES=	Cabal \
			array \
			base \
			binary \
			bytestring \
			containers \
			deepseq \
			directory \
			filepath \
			ghc \
			ghc-boot \
			ghc-boot-th \
			ghc-prim \
			ghci \
			haskeline \
			hoopl \
			hpc \
			integer-gmp \
			pretty \
			process \
			template-haskell \
			terminfo \
			time \
			transformers \
			unix \
			xhtml
STAGE2_DUMMY=		lang/ghc
.for _ghc_stage2_package in ${GHC_STAGE2_PACKAGES} ; do
# Define dummy dependency, so that we can filter it easily and produce a warning
# in bsd.cabal.mk it these depdencies are added to USE_CABAL.
${_ghc_stage2_package}_port=			${STAGE2_DUMMY}
.endfor

# KEEP THE LIST ALPHABETICALLY SORTED!

abstract-deque_port?=                            devel/hs-abstract-deque
abstract-par_port?=                              devel/hs-abstract-par
activehs_port?=                                  www/hs-activehs                                 # executable
activehs-base_port?=                             devel/hs-activehs-base
adjunctions_port?=                               math/hs-adjunctions
aeson_port?=                                     converters/hs-aeson
aeson-compat_port?=                              converters/hs-aeson-compat
aeson-pretty_port?=                              converters/hs-aeson-pretty                      # executable
Agda_port?=                                      math/hs-Agda                                    # executable
alex_port?=                                      devel/hs-alex                                   # executable
ALUT_port?=                                      audio/hs-ALUT
angel_port?=                                     sysutils/hs-angel                               # executable
ansi-terminal_port?=                             devel/hs-ansi-terminal
ansi-wl-pprint_port?=                            devel/hs-ansi-wl-pprint
appar_port?=                                     textproc/hs-appar
arrows_port?=                                    devel/hs-arrows
asn1-data_port?=                                 devel/hs-asn1-data
asn1-encoding_port?=                             devel/hs-asn1-encoding
asn1-parse_port?=                                devel/hs-asn1-parse
asn1-types_port?=                                devel/hs-asn1-types
async_port?=                                     devel/hs-async
atomic-primops_port?=                            devel/hs-atomic-primops
attoparsec_port?=                                textproc/hs-attoparsec
attoparsec-enumerator_port?=                     textproc/hs-attoparsec-enumerator
attoparsec-iso8601_port?=                        textproc/hs-attoparsec-iso8601
authenticate_port?=                              www/hs-authenticate
auto-update_port?=                               devel/hs-auto-update
aws_port?=                                       net/hs-aws
base-compat_port?=                               devel/hs-base-compat
base-orphans_port?=                              devel/hs-base-orphans
base-unicode-symbols_port?=                      devel/hs-base-unicode-symbols
base16-bytestring_port?=                         devel/hs-base16-bytestring
base64-bytestring_port?=                         devel/hs-base64-bytestring
basic-prelude_port?=                             devel/hs-basic-prelude
bencode_port?=                                   textproc/hs-bencode
bifunctors_port?=                                devel/hs-bifunctors
bio_port?=                                       science/hs-bio                                  # executable
bits-atomic_port?=                               devel/hs-bits-atomic
blaze-builder_port?=                             devel/hs-blaze-builder
blaze-builder-enumerator_port?=                  devel/hs-blaze-builder-enumerator
blaze-html_port?=                                textproc/hs-blaze-html
blaze-markup_port?=                              textproc/hs-blaze-markup
blaze-textual_port?=                             devel/hs-blaze-textual
bloomfilter_port?=                               devel/hs-bloomfilter
BNFC_port?=                                      devel/hs-BNFC                                   # executable
Boolean_port?=                                   devel/hs-Boolean
BoundedChan_port?=                               devel/hs-BoundedChan
boxes_port?=                                     devel/hs-boxes
brainfuck_port?=                                 lang/hs-brainfuck                               # executable
bsd-sysctl_port?=                                devel/hs-bsd-sysctl
byteable_port?=                                  devel/hs-byteable
byteorder_port?=                                 devel/hs-byteorder
bytestring-csv_port?=                            textproc/hs-bytestring-csv
bytestring-lexing_port?=                         devel/hs-bytestring-lexing
bytestring-mmap_port?=                           devel/hs-bytestring-mmap
bytestring-nums_port?=                           devel/hs-bytestring-nums                        # executable
bytestring-show_port?=                           devel/hs-bytestring-show
c2hs_port?=                                      devel/hs-c2hs                                   # executable
cabal-install_port?=                             devel/hs-cabal-install                          # executable
call-stack_port?=                                devel/hs-call-stack
cairo_port?=                                     graphics/hs-cairo
case-insensitive_port?=                          textproc/hs-case-insensitive
cassava_port?=                                   textproc/hs-cassava
categories_port?=                                math/hs-categories
cereal_port?=                                    devel/hs-cereal
certificate_port?=                               security/hs-certificate
cgi_port?=                                       www/hs-cgi
checkers_port?=                                  devel/hs-checkers
chunked-data_port?=                              devel/hs-chunked-data
cipher-aes_port?=                                security/hs-cipher-aes
cipher-aes128_port?=                             security/hs-cipher-aes128
cipher-blowfish_port?=                           security/hs-cipher-blowfish
cipher-camellia_port?=                           security/hs-cipher-camellia
cipher-des_port?=                                security/hs-cipher-des
cipher-rc4_port?=                                security/hs-cipher-rc4
classy-prelude_port?=                            devel/hs-classy-prelude
classy-prelude-conduit_port?=                    devel/hs-classy-prelude-conduit
clientsession_port?=                             security/hs-clientsession
clock_port?=                                     devel/hs-clock
cmark_port?=                                     textproc/hs-cmark
cmdargs_port?=                                   devel/hs-cmdargs
code-page_port?=                                 devel/hs-code-page
colour_port?=                                    devel/hs-colour
comonad_port?=                                   math/hs-comonad
concurrent-output_port?=                         devel/hs-concurrent-output
conduit_port?=                                   devel/hs-conduit
conduit-combinators_port?=                       devel/hs-conduit-combinators
conduit-extra_port?=                             devel/hs-conduit-extra
ConfigFile_port?=                                devel/hs-ConfigFile
configurator_port?=                              devel/hs-configurator
connection_port?=                                net/hs-connection
constraints_port?=                               devel/hs-constraints
contravariant_port?=                             math/hs-contravariant
convertible_port?=                               devel/hs-convertible
cookie_port?=                                    www/hs-cookie
cpphs_port?=                                     devel/hs-cpphs                                  # executable
cprng-aes_port?=                                 security/hs-cprng-aes
cpu_port?=                                       sysutils/hs-cpu
criterion_port?=                                 benchmarks/hs-criterion
Crypto_port?=                                    security/hs-Crypto
crypto-api_port?=                                security/hs-crypto-api
crypto-cipher-types_port?=                       security/hs-crypto-cipher-types
crypto-conduit_port?=                            security/hs-crypto-conduit
crypto-numbers_port?=                            security/hs-crypto-numbers
crypto-pubkey_port?=                             security/hs-crypto-pubkey
crypto-pubkey-types_port?=                       security/hs-crypto-pubkey-types
crypto-random_port?=                             security/hs-crypto-random
crypto-random-api_port?=                         security/hs-crypto-random-api
cryptocipher_port?=                              security/hs-cryptocipher
cryptohash_port?=                                security/hs-cryptohash
cryptohash-md5_port?=                            security/hs-cryptohash-md5
cryptohash-sha1_port?=                           security/hs-cryptohash-sha1
cryptohash-sha256_port?=                         security/hs-cryptohash-sha256
cryptohash-conduit_port?=                        security/hs-cryptohash-conduit
cryptohash-cryptoapi_port?=                      security/hs-cryptohash-cryptoapi
cryptonite_port?=                                security/hs-cryptonite
css-text_port?=                                  www/hs-css-text
csv_port?=                                       textproc/hs-csv
curl_port?=                                      ftp/hs-curl                                     # lib_depends
darcs_port?=                                     devel/hs-darcs                                  # executable
data-default_port?=                              devel/hs-data-default
data-default-class_port?=                        devel/hs-data-default-class
data-default-instances-base_port?=               devel/hs-data-default-instances-base
data-default-instances-containers_port?=         devel/hs-data-default-instances-containers
data-default-instances-dlist_port?=              devel/hs-data-default-instances-dlist
data-default-instances-old-locale_port?=         devel/hs-data-default-instances-old-locale
data-endian_port?=                               devel/hs-data-endian
data-hash_port?=                                 devel/hs-data-hash
data-lens_port?=                                 math/hs-data-lens
data-lens-template_port?=                        math/hs-data-lens-template
data-ordlist_port?=                              devel/hs-data-ordlist
data-pprint_port?=                               devel/hs-data-pprint
dataenc_port?=                                   converters/hs-dataenc
date-cache_port?=                                devel/hs-date-cache
datetime_port?=                                  devel/hs-datetime
DAV_port?=                                       www/hs-DAV                                      # executable
dbus_port?=                                      devel/hs-dbus
deepseq-generics_port?=                          devel/hs-deepseq-generics
dia-base_port?=                                  graphics/hs-dia-base
dia-functions_port?=                             graphics/hs-dia-functions
Diff_port?=                                      textproc/hs-Diff
digest_port?=                                    security/hs-digest
directory-tree_port?=                            devel/hs-directory-tree
disk-free-space_port?=                           sysutils/hs-disk-free-space
distributive_port?=                              math/hs-distributive
dlist_port?=                                     devel/hs-dlist
dlist-instances_port?=                           devel/hs-dlist-instances
dns_port?=                                       dns/hs-dns
doctemplates_port?=                              textproc/hs-doctemplates
double-conversion_port?=                         textproc/hs-double-conversion
DRBG_port?=                                      security/hs-DRBG
ed25519_port?=                                   security/hs-ed25519
easy-file_port?=                                 devel/hs-easy-file
EdisonAPI_port?=                                 devel/hs-EdisonAPI
EdisonCore_port?=                                devel/hs-EdisonCore
edit-distance_port?=                             devel/hs-edit-distance
either_port?=                                    devel/hs-either
ekg_port?=                                       sysutils/hs-ekg
ekg-core_port?=                                  sysutils/hs-ekg-core
ekg-json_port?=                                  sysutils/hs-ekg-json
email-validate_port?=                            mail/hs-email-validate
enclosed-exceptions_port?=                       devel/hs-enclosed-exceptions
entropy_port?=                                   security/hs-entropy
enumerator_port?=                                devel/hs-enumerator
equivalence_port?=                               devel/hs-equivalence
erf_port?=                                       math/hs-erf
errors_port?=                                    devel/hs-errors
esqueleto_port?=                                 databases/hs-esqueleto
exceptions_port?=                                devel/hs-exceptions
extensible-exceptions_port?=                     devel/hs-extensible-exceptions
extra_port?=                                     devel/hs-extra
fast-logger_port?=                               devel/hs-fast-logger
fastcgi_port?=                                   www/hs-fastcgi                                  # lib_depends
feed_port?=                                      textproc/hs-feed
fdo-notify_port?=                                deskutils/hs-fdo-notify
fgl_port?=                                       devel/hs-fgl
file-embed_port?=                                devel/hs-file-embed
filemanip_port?=                                 devel/hs-filemanip
filestore_port?=                                 devel/hs-filestore
fixed_port?=                                     math/hs-fixed
foundation_port?=                                devel/hs-foundation
fmlist_port?=                                    devel/hs-fmlist
free_port?=                                      devel/hs-free
fsnotify_port?=                                  devel/hs-fsnotify
gconf_port?=                                     devel/hs-gconf
generic-deriving_port?=                          devel/hs-generic-deriving
geniplate-mirror_port?=                          devel/hs-geniplate-mirror
ghc-events_port?=                                devel/hs-ghc-events                             # executable
ghc-mtl_port?=                                   devel/hs-ghc-mtl
ghc-paths_port?=                                 devel/hs-ghc-paths
gio_port?=                                       devel/hs-gio
git-annex_port?=                                 devel/hs-git-annex                              # executable
gitit_port?=                                     www/hs-gitit                                    # executable
gitrev_port?=                                    devel/hs-gitrev
glib_port?=                                      devel/hs-glib
Glob_port?=                                      devel/hs-Glob
GLURaw_port?=                                    x11-toolkits/hs-GLURaw
GLUT_port?=                                      x11-toolkits/hs-GLUT
gnuidn_port?=                                    dns/hs-gnuidn                                   # lib_depends
gnutls_port?=                                    security/hs-gnutls                              # lib_depends
graphviz_port?=                                  graphics/hs-graphviz
gsasl_port?=                                     net/hs-gsasl                                    # lib_depends
gtk_port?=                                       x11-toolkits/hs-gtk
gtk2hs_port?=                                    x11-toolkits/hs-gtk2hs                          # metaport
gtk2hs-buildtools_port?=                         devel/hs-gtk2hs-buildtools                      # executable
gtksourceview2_port?=                            x11-toolkits/hs-gtksourceview2
hackage-security_port?=                          security/hs-hackage-security
haddock_port?=                                   devel/hs-haddock                                # executable
haddock-api_port?=                               devel/hs-haddock-api
haddock-library_port?=                           devel/hs-haddock-library
half_port?=                                      math/hs-half
happstack_port?=                                 www/hs-happstack                                # executable
happstack-server_port?=                          www/hs-happstack-server
happy_port?=                                     devel/hs-happy                                  # executable
hashable_port?=                                  devel/hs-hashable
hashed-storage_port?=                            devel/hs-hashed-storage
hashtables_port?=                                devel/hs-hashtables
haskell-lexer_port?=                               devel/hs-haskell-lexer
haskell-src_port?=                               devel/hs-haskell-src
haskell-src-exts_port?=                          devel/hs-haskell-src-exts
haskell-xmpp_port?=                              net-im/hs-haskell-xmpp
hasktags_port?=                                  devel/hs-hasktags                               # executable
hastache_port?=                                  devel/hs-hastache
HaXml_port?=                                     textproc/hs-HaXml                               # executable
hedis_port?=                                     databases/hs-hedis
heist_port?=                                     www/hs-heist
hex_port?=                                       devel/hs-hex
hexpat_port?=                                    textproc/hs-hexpat
HGL_port?=                                       graphics/hs-HGL
highlighting-kate_port?=                         textproc/hs-highlighting-kate
hinotify_port?=                                  devel/hs-hinotify                               # lib_depends
hint_port?=                                      devel/hs-hint
hjsmin_port?=                                    www/hs-hjsmin                                   # executable
hlibev_port?=                                    devel/hs-hlibev                                 # lib_depends
hlint_port?=                                     devel/hs-hlint                                  # executable
hoauth2_port?=                                   net/hs-hoauth2
hoogle_port?=                                    devel/hs-hoogle                                 # executable
hostname_port?=                                  net/hs-hostname
hourglass_port?=                                 devel/hs-hourglass
hs-bibutils_port?=                               textproc/hs-hs-bibutils
hS3_port?=                                       www/hs-hS3                                      # executable
hsb2hs_port?=                                    devel/hs-hsb2hs
hscolour_port?=                                  print/hs-hscolour                               # executable
hslogger_port?=                                  devel/hs-hslogger
hslua_port?=                                     devel/hs-hslua
HsOpenSSL_port?=                                 security/hs-HsOpenSSL
hspec_port?=                                     devel/hs-hspec                                  # executable
hspec-core_port?=                                devel/hs-hspec-core
hspec-discover_port?=                            devel/hs-hspec-discover                         # executable
hspec-expectations_port?=                        devel/hs-hspec-expectations
HStringTemplate_port?=                           textproc/hs-HStringTemplate
html_port?=                                      textproc/hs-html
html-conduit_port?=                              textproc/hs-html-conduit
HTTP_port?=                                      www/hs-HTTP
http-api-data_port?=                             www/hs-http-api-data
http-client_port?=                               www/hs-http-client
http-client-tls_port?=                           www/hs-http-client-tls
http-conduit_port?=                              www/hs-http-conduit
http-date_port?=                                 www/hs-http-date
http-reverse-proxy_port?=                        www/hs-http-reverse-proxy
http-server_port?=                               www/hs-http-server
http-types_port?=                                www/hs-http-types
http2_port?=                                     www/hs-http2
HUnit_port?=                                     devel/hs-HUnit
hxt_port?=                                       textproc/hs-hxt
hxt-charproperties_port?=                        textproc/hs-hxt-charproperties
hxt-regex-xmlschema_port?=                       textproc/hs-hxt-regex-xmlschema
hxt-unicode_port?=                               textproc/hs-hxt-unicode
ieee754_port?=                                   math/hs-ieee754
IfElse_port?=                                    devel/hs-IfElse
integer-logarithms_port?=                        math/hs-integer-logarithms
io-streams_port?=                                devel/hs-io-streams
io-streams-haproxy_port?=                        devel/hs-io-streams-haproxy
iproute_port?=                                   net/hs-iproute
js-flot_port?=                                   devel/hs-js-flot
js-jquery_port?=                                 devel/hs-js-jquery
json_port?=                                      converters/hs-json
JuicyPixels_port?=                               graphics/hs-JuicyPixels
kan-extensions_port?=                            math/hs-kan-extensions
keys_port?=                                      devel/hs-keys
kqueue_port?=                                    devel/hs-kqueue
language-c_port?=                                devel/hs-language-c
language-javascript_port?=                       devel/hs-language-javascript
largeword_port?=                                 devel/hs-largeword
lazysmallcheck_port?=                            devel/hs-lazysmallcheck
lens_port?=                                      devel/hs-lens
lhs2tex_port?=                                   textproc/hs-lhs2tex                             # executable
libmpd_port?=                                    audio/hs-libmpd
libxml_port?=                                    textproc/hs-libxml
libxml-sax_port?=                                textproc/hs-libxml-sax                          # lib_depends
lifted-async_port?=                              devel/hs-lifted-async
lifted-base_port?=                               devel/hs-lifted-base
List_port?=                                      devel/hs-List
ListLike_port?=                                  devel/hs-ListLike
logict_port?=                                    devel/hs-logict
maccatcher_port?=                                net/hs-maccatcher
magic_port?=                                     textproc/hs-magic
map-syntax_port?=                                devel/hs-map-syntax
math-functions_port?=                            math/hs-math-functions
memory_port?=                                    devel/hs-memory
MemoTrie_port?=                                  devel/hs-MemoTrie
microlens_port?=                                 devel/hs-microlens
microlens-th_port?=                              devel/hs-microlens-th
microstache_port?=                               devel/hs-microstache
mime_port?=                                      mail/hs-mime
mime-mail_port?=                                 mail/hs-mime-mail
mime-types_port?=                                mail/hs-mime-types
MissingH_port?=                                  devel/hs-MissingH
mmap_port?=                                      devel/hs-mmap
mmorph_port?=                                    devel/hs-mmorph
monad-control_port?=                             devel/hs-monad-control
monad-logger_port?=                              devel/hs-monad-logger
monad-loops_port?=                               devel/hs-monad-loops
monad-par_port?=                                 devel/hs-monad-par
monad-par-extras_port?=                          devel/hs-monad-par-extras
monad-unlift_port?=                              devel/hs-monad-unlift
monadcryptorandom_port?=                         security/hs-monadcryptorandom
monadplus_port?=                                 devel/hs-monadplus
MonadRandom_port?=                               devel/hs-MonadRandom
monads-tf_port?=                                 devel/hs-monads-tf
mono-traversable_port?=                          devel/hs-mono-traversable
mono-traversable-instances_port?=                devel/hs-mono-traversable-instances
mountpoints_port?=                               sysutils/hs-mountpoints
mtl_port?=                                       devel/hs-mtl
mueval_port?=                                    devel/hs-mueval                                 # executable
multipart_port?=                                 www/hs-multipart
murmur-hash_port?=                               devel/hs-murmur-hash
mutable-containers_port?=                        devel/hs-mutable-containers
mwc-random_port?=                                math/hs-mwc-random
mysql_port?=                                     databases/hs-mysql
ncurses_port?=                                   devel/hs-ncurses                                # lib_depends
network_port?=                                   net/hs-network
network-info_port?=                              net/hs-network-info
network-multicast_port?=                         net/hs-network-multicast
network-protocol-xmpp_port?=                     net/hs-network-protocol-xmpp
network-uri_port?=                               net/hs-network-uri
newtype_port?=                                   devel/hs-newtype
newtype-generics_port?=                          devel/hs-newtype-generics
nonce_port?=                                     security/hs-nonce
NumInstances_port?=                              math/hs-NumInstances
ObjectName_port?=                                devel/hs-ObjectName
oeis_port?=                                      www/hs-oeis
old-locale_port?=                                devel/hs-old-locale
old-time_port?=                                  devel/hs-old-time
Only_port?=                                      devel/hs-Only
OpenAL_port?=                                    audio/hs-OpenAL
OpenGL_port?=                                    x11-toolkits/hs-OpenGL
OpenGLRaw_port?=                                 x11-toolkits/hs-OpenGLRaw
optparse-applicative_port?=                      devel/hs-optparse-applicative
pandoc_port?=                                    textproc/hs-pandoc                              # executable
pandoc-citeproc_port?=                           textproc/hs-pandoc-citeproc                     # executable
pandoc-types_port?=                              textproc/hs-pandoc-types
pango_port?=                                     x11-toolkits/hs-pango
parallel_port?=                                  devel/hs-parallel
parsec_port?=                                    textproc/hs-parsec
path-pieces_port?=                               www/hs-path-pieces
pcap_port?=                                      net/hs-pcap
pcre-light_port?=                                devel/hs-pcre-light                             # lib_depends
pem_port?=                                       security/hs-pem
persistent_port?=                                databases/hs-persistent
persistent-sqlite_port?=                         databases/hs-persistent-sqlite
persistent-template_port?=                       databases/hs-persistent-template
pointed_port?=                                   math/hs-pointed
polyparse_port?=                                 textproc/hs-polyparse
porte_port?=                                     ports-mgmt/hs-porte                             # executable
prelude-extras_port?=                            devel/hs-prelude-extras
preprocessor-tools_port?=                        devel/hs-preprocessor-tools
pretty-show_port?=                               textproc/hs-pretty-show
prettyclass_port?=                               devel/hs-prettyclass
primitive_port?=                                 devel/hs-primitive
probability_port?=                               math/hs-probability
process-extras_port?=                            devel/hs-process-extras
profunctors_port?=                               devel/hs-profunctors
project-template_port?=                          devel/hs-project-template
PSQueue_port?=                                   devel/hs-PSQueue
psqueues_port?=                                  devel/hs-psqueues
publicsuffixlist_port?=                          net/hs-publicsuffixlist
pureMD5_port?=                                   security/hs-pureMD5
pwstore-fast_port?=                              security/hs-pwstore-fast
QuickCheck_port?=                                devel/hs-QuickCheck
quickcheck-io_port?=                             devel/hs-quickcheck-io
random_port?=                                    devel/hs-random
ReadArgs_port?=                                  devel/hs-ReadArgs                               # executable
readable_port?=                                  devel/hs-readable
readline_port?=                                  devel/hs-readline
recaptcha_port?=                                 www/hs-recaptcha
refact_port?=                                    devel/hs-refact
reflection_port?=                                devel/hs-reflection
regex-applicative_port?=                         textproc/hs-regex-applicative
regex-base_port?=                                textproc/hs-regex-base
regex-compat_port?=                              textproc/hs-regex-compat
regex-compat-tdfa_port?=                         textproc/hs-regex-compat-tdfa
regex-pcre_port?=                                textproc/hs-regex-pcre
regex-pcre-builtin_port?=                        textproc/hs-regex-pcre-builtin                  # lib_depends
regex-posix_port?=                               textproc/hs-regex-posix
regex-tdfa_port?=                                textproc/hs-regex-tdfa
resource-pool_port?=                             devel/hs-resource-pool
resourcet_port?=                                 devel/hs-resourcet
rfc5051_port?=                                   textproc/hs-rfc5051
RSA_port?=                                       security/hs-RSA
safe_port?=                                      devel/hs-safe
safe-exceptions_port?=                           devel/hs-safe-exceptions
SafeSemaphore_port?=                             devel/hs-SafeSemaphore
sandi_port?=                                     converters/hs-sandi
say_port?=                                       devel/hs-say
scanner_port?=                                   textproc/hs-scanner
scientific_port?=                                devel/hs-scientific
scroll_port?=                                    games/hs-scroll                                 # executable
securemem_port?=                                 devel/hs-securemem
semigroupoids_port?=                             math/hs-semigroupoids
semigroups_port?=                                math/hs-semigroups
sendfile_port?=                                  net/hs-sendfile
setenv_port?=                                    devel/hs-setenv
setlocale_port?=                                 devel/hs-setlocale
SHA_port?=                                       security/hs-SHA                                 # executable
shake_port?=                                     devel/hs-shake                                  # executable
shakespeare_port?=                               www/hs-shakespeare
ShellCheck_port?=                                devel/hs-ShellCheck                             # executable
shelly_port?=                                    shells/hs-shelly
show_port?=                                      devel/hs-show
silently_port?=                                  devel/hs-silently
simple-reflect_port?=                            devel/hs-simple-reflect
simple-sendfile_port?=                           net/hs-simple-sendfile
skein_port?=                                     security/hs-skein
skylighting_port?=                               textproc/hs-skylighting
smallcheck_port?=                                devel/hs-smallcheck
snap_port?=                                      www/hs-snap                                     # executable
snap-core_port?=                                 www/hs-snap-core
snap-server_port?=                               www/hs-snap-server                              # lib_depends
socks_port?=                                     net/hs-socks
split_port?=                                     devel/hs-split
StateVar_port?=                                  devel/hs-StateVar
statistics_port?=                                math/hs-statistics
stm_port?=                                       devel/hs-stm
stm-chans_port?=                                 devel/hs-stm-chans
STMonadTrans_port?=                              devel/hs-STMonadTrans
Stream_port?=                                    devel/hs-Stream
streaming-commons_port?=                         devel/hs-streaming-commons
strict_port?=                                    devel/hs-strict
stringsearch_port?=                              textproc/hs-stringsearch
svgcairo_port?=                                  graphics/hs-svgcairo
syb_port?=                                       devel/hs-syb
syb-with-class_port?=                            devel/hs-syb-with-class
system-fileio_port?=                             devel/hs-system-fileio
system-filepath_port?=                           devel/hs-system-filepath
tagged_port?=                                    devel/hs-tagged
tagsoup_port?=                                   textproc/hs-tagsoup                             # executable
tagstream-conduit_port?=                         textproc/hs-tagstream-conduit
tar_port?=                                       archivers/hs-tar
temporary_port?=                                 devel/hs-temporary
terminal-size_port?=                             devel/hs-terminal-size
test-framework_port?=                            devel/hs-test-framework
test-framework-hunit_port?=                      devel/hs-test-framework-hunit
test-framework-quickcheck2_port?=                devel/hs-test-framework-quickcheck2
texmath_port?=                                   textproc/hs-texmath                             # executable
text_port?=                                      devel/hs-text
text-icu_port?=                                  devel/hs-text-icu                               # lib_depends
text-short_port?=                                devel/hs-text-short
tf-random_port?=                                 devel/hs-tf-random
th-abstraction_port?=                            devel/hs-th-abstraction
th-lift_port?=                                   devel/hs-th-lift
th-lift-instances_port?=                         devel/hs-th-lift-instances
threads_port?=                                   devel/hs-threads
threadscope_port?=                               devel/hs-threadscope                            # executable
time-compat_port?=                               devel/hs-time-compat
time-locale-compat_port?=                        devel/hs-time-locale-compat
timezone-olson_port?=                            devel/hs-timezone-olson
timezone-series_port?=                           devel/hs-timezone-series
tls_port?=                                       security/hs-tls
tls-session-manager_port?=                       security/hs-tls-session-manager
torrent_port?=                                   net-p2p/hs-torrent
transformers-base_port?=                         devel/hs-transformers-base
transformers-compat_port?=                       devel/hs-transformers-compat
TypeCompose_port?=                               devel/hs-TypeCompose
typed-process_port?=                             devel/hs-typed-process
unamb_port?=                                     devel/hs-unamb
unexceptionalio_port?=                           devel/hs-unexceptionalio
uniplate_port?=                                  devel/hs-uniplate
unix-compat_port?=                               devel/hs-unix-compat
unix-time_port?=                                 devel/hs-unix-time
unlambda_port?=                                  lang/hs-unlambda                                # executable
unordered-containers_port?=                      devel/hs-unordered-containers
uri_port?=                                       textproc/hs-uri
uri-bytestring_port?=                            textproc/hs-uri-bytestring
uri-bytestring-aeson_port?=                      textproc/hs-uri-bytestring-aeson
url_port?=                                       www/hs-url
utf8-light_port?=                                devel/hs-utf8-light
utf8-string_port?=                               devel/hs-utf8-string
utility-ht_port?=                                devel/hs-utility-ht
uuagc_port?=                                     devel/hs-uuagc                                  # executable
uuagc-bootstrap_port?=                           devel/hs-uuagc-bootstrap                        # executable
uuagc-cabal_port?=                               devel/hs-uuagc-cabal
uuid_port?=                                      devel/hs-uuid
uuid-types_port?=                                devel/hs-uuid-types
uulib_port?=                                     devel/hs-uulib
vault_port?=                                     devel/hs-vault
vector_port?=                                    devel/hs-vector
vector-algorithms_port?=                         devel/hs-vector-algorithms
vector-binary-instances_port?=                   devel/hs-vector-binary-instances
vector-instances_port?=                          devel/hs-vector-instances
vector-space_port?=                              math/hs-vector-space
vector-th-unbox_port?=                           devel/hs-vector-th-unbox
void_port?=                                      devel/hs-void
vte_port?=                                       x11-toolkits/hs-vte
wai_port?=                                       www/hs-wai
wai-app-static_port?=                            www/hs-wai-app-static                           # executable
wai-extra_port?=                                 www/hs-wai-extra
wai-logger_port?=                                www/hs-wai-logger
warp_port?=                                      www/hs-warp
warp-tls_port?=                                  www/hs-warp-tls
webkit_port?=                                    www/hs-webkit                                   # lib_depends
wl-pprint-text_port?=                            devel/hs-wl-pprint-text
word8_port?=                                     devel/hs-word8
wx_port?=                                        x11-toolkits/hs-wx
wxc_port?=                                       x11-toolkits/hs-wxc                             # lib_depends
wxcore_port?=                                    x11-toolkits/hs-wxcore                          # lib_depends
wxdirect_port?=                                  x11-toolkits/hs-wxdirect                        # executable
X11_port?=                                       x11/hs-X11                                      # lib_depends
X11-xft_port?=                                   x11/hs-X11-xft
x509_port?=                                      security/hs-x509
x509-store_port?=                                security/hs-x509-store
x509-system_port?=                               security/hs-x509-system
x509-validation_port?=                           security/hs-x509-validation
xhtml_port?=                                     textproc/hs-xhtml
xml_port?=                                       textproc/hs-xml
xml-conduit_port?=                               textproc/hs-xml-conduit
xml-hamlet_port?=                                textproc/hs-xml-hamlet
xml-types_port?=                                 textproc/hs-xml-types
xmlhtml_port?=                                   textproc/hs-xmlhtml
xmobar_port?=                                    x11/hs-xmobar                                   # executable
xmonad_port?=                                    x11-wm/hs-xmonad                                # executable
xmonad-contrib_port?=                            x11-wm/hs-xmonad-contrib
xss-sanitize_port?=                              www/hs-xss-sanitize
yaml_port?=                                      textproc/hs-yaml                                # executable
yesod_port?=                                     www/hs-yesod
yesod-auth_port?=                                www/hs-yesod-auth
yesod-auth-hashdb_port?=                         www/hs-yesod-auth-hashdb
yesod-bin_port?=                                 www/hs-yesod-bin                                # executable
yesod-core_port?=                                www/hs-yesod-core
yesod-form_port?=                                www/hs-yesod-form
yesod-persistent_port?=                          www/hs-yesod-persistent
yesod-static_port?=                              www/hs-yesod-static
yesod-test_port?=                                www/hs-yesod-test
zip-archive_port?=                               archivers/hs-zip-archive
zlib_port?=                                      archivers/hs-zlib
zlib-bindings_port?=                             archivers/hs-zlib-bindings
zlib-enum_port?=                                 archivers/hs-zlib-enum
