#!/bin/sh
#
# Simple script to fetch the latest commits via the github API.  Requires
# curl and jq.  Uses unauthenticated access which is ratelimited to 60
# queries per hour.

REPOS_URL=https://api.github.com/repos/CTSRD-CHERI
MAX_DATE=1970101

tmpfile=`mktemp -t gen-Makefile.snapshot`

query_repo()
{
	curl ${REPOS_URL}/$1/branches/master > $tmpfile

	# Accumulate the dates of the last commits to find the snapshot date
	committime=`jq -r '.commit.commit.committer.date' $tmpfile`
	committime=${committime%%T*}
	year=${committime%%-*}
	month=${committime%-*}
	month=${month#*-}
	day=${committime##*-}
	dateint=${year}${month}${day}
	if [ $dateint -gt $MAX_DATE ]; then
		export MAX_DATE=$dateint
	fi

	SHA=`jq -r '.commit.sha' $tmpfile`
}

query_repo llvm
LLVM_COMMIT=$SHA
query_repo clang
CLANG_COMMIT=$SHA
query_repo lld
LLD_COMMIT=$SHA
query_repo lldb
LLDB_COMMIT=$SHA

cat <<EOF > Makefile.snapshot
# \$FreeBSD\$
#
# Generated file!  Do not edit!  
#
# Generated by: files/gen-Makefile.snapshot.sh.
#
LLVM_MAJOR=	7.0
LLVM_RELEASE=	\${LLVM_MAJOR}.0
SNAPDATE=	${MAX_DATE}

LLVM_COMMIT=		${LLVM_COMMIT}
CLANG_COMMIT=		${CLANG_COMMIT}
LLD_COMMIT=		${LLD_COMMIT}
LLDB_COMMIT=		${LLDB_COMMIT}
EOF

rm -f $tmpfile
