<?xml version="1.0" encoding="euc-jp"?>
<!DOCTYPE xsl:stylesheet PUBLIC "-//FreeBSD//DTD FreeBSD XSLT 1.0 DTD//EN"
				"http://www.FreeBSD.org/XML/share/xml/xslt10-freebsd.dtd">
<!-- $FreeBSD: head/ja_JP.eucJP/share/xml/libcommon.xsl 48695 2016-04-21 09:36:38Z ryusuke $ -->
<!-- The FreeBSD Japanese Documentation Project -->
<!-- Original revision: r48667 -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:import href="http://www.FreeBSD.org/XML/share/xml/libcommon.xsl"/>

  <!-- default format for date string -->
  <xsl:param name="param-l10n-date-format-YMD"
             select="'%Y ǯ %M %D '" />
  <xsl:param name="param-l10n-date-format-YM"
             select="'%Y ǯ %M'" />
  <xsl:param name="param-l10n-date-format-MD"
             select="'%M %D '" />

  <!-- template: "html-usergroups-list-regions"
       list all regions in a usergroup database -->

  <xsl:key name="html-usergroups-regions-key" match="entry" use="../../@name" />
  <xsl:key name="html-usergroups-id-key" match="entry" use="@id" />

  <xsl:template name="html-usergroups-map">
    <xsl:param name="mapurl" select="'none'" />

    <img>
      <xsl:attribute name="src">
        <xsl:value-of select="$mapurl" />
      </xsl:attribute>
    </img>
  </xsl:template>

  <xsl:template name="html-usergroups-list-regions">
    <xsl:param name="usergroups.xml" select="'usergroups.xml'" />

    <ul>
      <xsl:for-each select="document($usergroups.xml)//continent">
      <xsl:sort select="format-number(count(country/entry), '000')"
      		order="descending"/>

	<xsl:variable name="id" select="
	  translate(@name,
	  ' ,ABCDEFGHIJKLMNOPQRSTUVWXYZ',
	  '--abcdefghijklmnopqrstuvwxyz')" />

	<li>
	  <p><xsl:element name="a">
	      <xsl:attribute name="href">
		<xsl:value-of select="concat('#', $id)" />
	      </xsl:attribute>

	      <xsl:call-template name="transtable-lookup">
		<xsl:with-param name="word-group" select="'continents'" />
		<xsl:with-param name="word" select="@name" />
	      </xsl:call-template>
	    </xsl:element>
	    ( <xsl:value-of select="count(country/entry)" /> 桼롼)</p>
	</li>
      </xsl:for-each>
    </ul>
  </xsl:template>

  <!-- template: "html-usergroups-list-header"
       print header part of usergroup listing (l10n) -->

  <xsl:template name="html-usergroups-list-header">
    <p>FreeBSD ϹȤƤꡢˤΥ桼롼פޤ</p>
    <p>ΥꥹȤ˺ܤäƤʤ桼롼פ¸ΤǤ顢
      ҡ<a href="https://www.FreeBSD.org/support/bugreports.html">㳲</a>
       Documentation->Website ƥȤäưʲξΤ餻</p>
    <ol>
      <li>桼롼פΥ֥Ȥ URL</li>
      <li>ˬԤȥ֥ȤδΤˡôԤϢΥ᡼륢ɥ쥹</li>
      <li>桼롼פδñ () Ҳʸ</li>
    </ol>

    <p> HTML Ǥꤤޤ
      FreeBSD Υݥꥷ顢
      ȯʥ桼롼פγưθϹޤȤǤ
      ᤯˥桼롼פʤС<a
	href="http://bsd.meetup.com/">http://bsd.meetup.com/</a>
      Ȥäƶˤ붽̣äƤĿͤ򸫤ĤƤ
      ơʤȤΥ桼롼פäƤ!</p>

    <h3>ϰ</h3>
  </xsl:template>

  <!-- template: "html-news-list-newsflash-preface" -->
  <xsl:template name="html-news-list-newsflash-preface">
    <img src="&enbase;/gifs/news.jpg" align="right" border="0" width="193"
      height="144" alt="FreeBSD News"/>

    <p>FreeBSD ϵ®ȯŸ³륪ڥ졼ƥ󥰥ƥʤΤǡ
      ǿοˤĤƹԤΤݤˤʤޤ͡
      ̤ˤʤ뤿ˡΥڡŪ˥å褦ˤޤ礦
      ˥塼ϡ
      <a href="https://lists.freebsd.org/mailman/listinfo/freebsd-announce">freebsd-announce
	᡼󥰥ꥹ</a> 
      <a href="&base;/news/rss.xml">RSS ե</a>
      Ǥ⥢ʥ󥹤ޤ</p>

    <p>줾ΥץȤκǿϡγƥ֥ڡ</p>

    <ul>
      <li><a href="http://freebsd.kde.org/">KDE on FreeBSD</a></li>
      <li><a href="&enbase;/gnome/newsflash.html">GNOME on FreeBSD</a></li>
    </ul>

    <p>ߡƾΥ꡼ξܺ٤ˤĤƤϡ
      <a href="&base;/releases/index.html">꡼</a>
      Υڡ</p>

    <p>FreeBSD ƥ䥻ƥΰϡ
      <a href="&base;/security/">ƥ</a>
      ڡˤޤ</p>
  </xsl:template>

  <!-- template: "html-news-list-newsflash-homelink" -->
  <xsl:template name="html-news-list-newsflash-homelink">
    <a href="&base;/news/news.html">˥塼ڡ</a>
  </xsl:template>

  <xsl:template name="html-news-make-olditems-list">
    <p>Υ˥塼:
      <a href="&enbase;/news/2009/index.html">2009</a>,
      <a href="&enbase;/news/2008/index.html">2008</a>,
      <a href="&enbase;/news/2007/index.html">2007</a>,
      <a href="&enbase;/news/2006/index.html">2006</a>,
      <a href="&enbase;/news/2005/index.html">2005</a>,
      <a href="&enbase;/news/2004/index.html">2004</a>,
      <a href="&enbase;/news/2003/index.html">2003</a>,
      <a href="&enbase;/news/2002/index.html">2002</a>,
      <a href="2001/index.html">2001</a>,
      <a href="&enbase;/news/2000/index.html">2000</a>,
      <a href="&enbase;/news/1999/index.html">1999</a>,
      <a href="&enbase;/news/1998/index.html">1998</a>,
      <a href="1997/index.html">1997</a>,
      <a href="1996/index.html">1996</a>,
      <a href="&enbase;/news/1993/index.html">1993</a></p>
  </xsl:template>

  <!-- template: "html-news-list-press-preface" -->
  <xsl:template name="html-news-list-press-preface">
    <p>FreeBSD ˴Ϣ˥塼ξܺ٤ <a
	href="mailto:freebsd-doc@FreeBSD.org">freebsd-doc@FreeBSD.org</a>
      ޤ (Ѹ) äƤ</p>
  </xsl:template>

  <!-- template: "html-press-make-olditems-list" -->
  <xsl:template name="html-press-make-olditems-list">
    <p>Υ˥塼:
      <a href="&enbase;/news/2009/press.html">2009</a>,
      <a href="&enbase;/news/2008/press.html">2008</a>,
      <a href="&enbase;/news/2007/press.html">2007</a>,
      <a href="&enbase;/news/2006/press.html">2006</a>,
      <a href="&enbase;/news/2005/press.html">2005</a>,
      <a href="&enbase;/news/2004/press.html">2004</a>,
      <a href="&enbase;/news/2003/press.html">2003</a>,
      <a href="&enbase;/news/2002/press.html">2002</a>,
      <a href="&base;/news/2001/press.html">2001</a>,
      <a href="&enbase;/news/2000/press.html">2000</a>,
      <a href="&enbase;/news/1999/press.html">1999</a>,
      <a href="&enbase;/news/1998/press.html">1998-1996</a></p>
  </xsl:template>

  <!-- for l10n -->
  <xsl:template name="html-news-month-headings">
    <xsl:param name="year" />
    <xsl:param name="month" />

    <xsl:value-of select="concat($year, ' ǯ ', $month)" />
  </xsl:template>

  <xsl:template name="html-events-list-preface">
    <p>˷ǺܤƤʤ FreeBSD ˴Ϣ٥Ȥ䡢
      FreeBSD 桼̣ʥ٥Ⱦܺ٤¸ΤǤ顢
      <a href="mailto:freebsd-doc@FreeBSD.org">freebsd-doc@FreeBSD.org</a>
      ޤ (Ѹ) äƤ</p>

    <p>iCalendar б塼եȥȤäƤʤ顢
      ˺ܤäƤ뤹٤ƤΥ٥Ȥ򽸤᤿
      <a href="&base;/events/events.ics">FreeBSD ٥ȥ</a>
      ѤǤޤ</p>
  </xsl:template>

  <xsl:template name="html-events-map">
    <xsl:param name="mapurl" select="'none'" />

    <p> FreeBSD ˴Ϣ٥Ȥ򳫺Ťϰϡ
      ʲϿޤˤưֿɤƤޤ
       FreeBSD ˴Ϣ٥Ȥ򳫺Ťϲ䥪󥸿ɤƤޤ
      Ťɤ줿ϰۤɲ¿Υ٥Ȥ򳫺ŤƤޤ</p>

    <img>
      <xsl:attribute name="src">
        <xsl:value-of select="$mapurl" />
      </xsl:attribute>
    </img>
  </xsl:template>

  <xsl:template name="html-events-list-upcoming-heading">
    <h2 id="upcoming">߳桢ޤϺ峫ͽΥ٥</h2>
  </xsl:template>

  <xsl:template name="html-events-list-past-heading">
    <h2 id="past">Υ٥</h2>
  </xsl:template>

  <!-- Generate a date interval. -->
  <!-- Sample: 27 November, 2002 - 29 December, 2003 -->
  <xsl:template name="gen-date-interval">
    <xsl:param name="startdate"/>
    <xsl:param name="enddate"/>

    <xsl:value-of select="startdate/year"/>
    <xsl:text> ǯ </xsl:text>
    <xsl:value-of select="startdate/month"/>
    <xsl:text>  </xsl:text>
    <xsl:value-of select="startdate/day"/>

    <xsl:if test="number(startdate/month) != number(enddate/month) or
		  number(startdate/day) != number(enddate/day) or
		  number(startdate/year) != number(enddate/year)">

      <xsl:if test="number(startdate/month) != number(enddate/month) or
		    number(startdate/year) != number(enddate/year)">
	<xsl:text> </xsl:text>
      </xsl:if>

      <xsl:text> - </xsl:text>

      <xsl:if test="number(startdate/year) != number(enddate/year)">
	<xsl:value-of select="enddate/year"/>
	<xsl:text> ǯ </xsl:text>
      </xsl:if>

      <xsl:if test="number(startdate/month) != number(enddate/month) or
		    number(startdate/year) != number(enddate/year)">
	<xsl:value-of select="enddate/month"/>
	<xsl:text> </xsl:text>
      </xsl:if>

      <xsl:if test="number(startdate/day) != number(enddate/day) or
		    number(startdate/month) != number(enddate/month) or
		    number(startdate/year) != number(enddate/year)">
	<xsl:text> </xsl:text>
	<xsl:value-of select="enddate/day"/>
	<xsl:text> </xsl:text>
      </xsl:if>
    </xsl:if>
    <xsl:if test="number(startdate/month) = number(enddate/month) and
		  number(startdate/day) = number(enddate/day) and
		  number(startdate/year) = number(enddate/year)">
      <xsl:text> </xsl:text>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
