<?xml version="1.0" encoding="iso-8859-2" ?>
<!DOCTYPE xsl:stylesheet PUBLIC "-//FreeBSD//DTD FreeBSD XSLT 1.0 DTD//EN"
				"http://www.FreeBSD.org/XML/share/xml/xslt10-freebsd.dtd" [
<!ENTITY title "A &os; Projekt">
]>

<!-- $FreeBSD: head/hu_HU.ISO8859-2/htdocs/index.xsl 43181 2013-11-13 06:10:37Z hrs $ -->

<!-- FreeBSD Hungarian Documentation Project
     Translated by: Gabor Kovesdan <gabor@FreeBSD.org>
     %SOURCE%	en/index.xsl
     %SRCID%	1.169
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/1999/xhtml">

  <xsl:import href="http://www.FreeBSD.org/XML/lang/share/xml/libcommon.xsl"/>
  <xsl:import href="http://www.FreeBSD.org/XML/share/xml/xhtml.xsl"/>

  <!-- these params should be externally bound. The values
       here are not used actually -->
  <xsl:param name="advisories.xml" select="'none'"/>
  <xsl:param name="notices.xml" select="'none'"/>
  <xsl:param name="mirrors.xml" select="'none'"/>
  <xsl:param name="news.press.xml-master" select="'none'"/>
  <xsl:param name="news.press.xml" select="'none'"/>
  <xsl:param name="news.project.xml-master" select="'none'"/>
  <xsl:param name="news.project.xml" select="'none'"/>
  <xsl:param name="events.xml-master" select="'none'"/>
  <xsl:param name="events.xml" select="'none'"/>

  <xsl:variable name="svnKeyword">$FreeBSD: head/hu_HU.ISO8859-2/htdocs/index.xsl 43181 2013-11-13 06:10:37Z hrs $</xsl:variable>

  <xsl:variable name="title">&title;</xsl:variable>

  <xsl:template name="process.content">
        <div id="frontcontainer">
          <div id="frontmain">
            <div id="frontfeaturecontainer">

		<div id="frontfeatureleft">
			<div id="frontfeaturecontent">
				<h1>A BSD &unix; alapjain</h1>

				<p>A &os;&reg; napjaink szerver, asztali
				  s begyazott <a
				  href="&base;/platforms/">szmtgpeinek</a>
				  opercis rendszere.  A
				  &os; kdbzisa tbb
				  mint harminc v folyamatos
				  fejlesztsnek,
				  munkjnak s
				  optimalizlsnak
				  eredmnye.  Jelenleg <a
				    href="&enbase;/doc/en/articles/contributors/article.html#STAFF-COMMITTERS">egyni
				    fejlesztk egy nagyobb csoportja</a>
				  tartja karban.  A &os; legfontosabb
				  jellemzi tbbek kzt a
				  fejlett
				  hlzatkezels, a
				  kifinomult biztonsgi
				  lehetsgek s a
				  vilgsznvonal
				  teljestmny, amelyet a
				  vilgban <a
				    href="&enbase;/doc/hu/books/handbook/nutshell.html/#INTRODUCTION-NUTSHELL-USERS">szmos forgalmasabb kiszolgl</a>,
				  hatkony begyazott
				  rendszer s
				  troleszkz
				  hasznl.</p>

				<div id="txtfrontfeaturelink"> &raquo;
				  <a href="&base;/about.html" title="Tovbb">Tovbb</a>
				</div> <!-- TXTFRONTFEATURELINK -->
			</div> <!-- FRONTFEATURECONTENT -->
		</div> <!-- FRONTFEATURELEFT -->

		<div id="frontfeaturemiddle">
			<div class="frontgetroundbox">
			  <div class="frontgettop"><div><b style="display: none">.</b></div></div>
				<div class="frontgetcontent">
				  <a href="&base;/where.html">Letlts</a>
				</div> <!-- frontgetcontent -->
			  <div class="frontgetbot"><div><b style="display: none">.</b></div></div>
			</div> <!-- frontgetroundbox -->

			<div id="frontreleases">
			  <div id="frontreleasescontent" class="txtshortcuts">
				  <h2><a href="&enbase;/releases/">FRISS KIADSOK</a></h2>
				  <ul id="frontreleaseslist">
					<li>
					  <a
					    href="&u.rel.announce;">Stabil kiads: &rel.current;</a>
					</li>
					<li>
					  <a
					    href="&u.rel2.announce;">Stabil (kifut) kiads: &rel2.current;</a>
					</li>
			    <xsl:if test="'&beta.testing;' != 'IGNORE'">
					<li>
					  <a
					    href="&base;/where.html#helptest">Kvetkez kiads: &betarel.current; - &betarel.vers;</a>
					</li>
			    </xsl:if>
			    <xsl:if test="'&beta2.testing;' != 'IGNORE'">
					<li>
					  <a
					    href="&base;/where.html#helptest">Kvetkez kiads: &betarel2.current; - &betarel2.vers;</a>
					</li>
			    </xsl:if>
				  </ul>
			  </div> <!-- FRONTRELEASESCONTENT -->
			</div> <!-- FRONTRELEASES -->
		</div> <!-- FRONTFEATUREMIDDLE -->

		<div id="frontfeatureright">
			<h2 class="blockhide">Nyelvek</h2>
			<div id="languagenav">
				<ul id="languagenavlist">
				  <li>
					<a href="&enbase;/de/" title="Nmet">de</a>
				  </li>
				  <li>
					<a href="&enbase;/" title="Angol">en</a>
				  </li>
				  <li>
					<a href="&enbase;/es/" title="Spanyol">es</a>
				  </li>
				  <li>
					<a href="&enbase;/fr/" title="Francia">fr</a>
				  </li>
				  <li>
					<a href="&base;/" title="Magyar">hu</a>
				  </li>
				  <li>
					<a href="&enbase;/it/" title="Olasz">it</a>
				  </li>
				  <li>
					<a href="&enbase;/ja/" title="Japn">ja</a>
				  </li>
				  <li>
					<a href="&enbase;/nl/" title="Holland">nl</a>
				  </li>
				  <li>
					<a href="&enbase;/ru/" title="Orosz">ru</a>
				  </li>
				  <li class="last-child">
					<a href="&enbase;/zh_CN/" title="Knai (Egyszerstett)">zh_CN</a>
				  </li>
				</ul>
			</div> <!-- LANGUAGENAV -->

			<div id="mirror">
			  <form action="&cgibase;/mirror.cgi" method="get">
				<div>
				  <h2 class="blockhide"><label for="MIRRORSEL">Tkrzsek</label></h2>
				  <select id="mirrorsel" name="goto">
					  <xsl:call-template name="html-index-mirrors-options-list">
					    <xsl:with-param name="mirrors.xml" select="$mirrors.xml" />
					  </xsl:call-template>
				  </select>
				</div> <!-- unnamed -->
				<input type="submit" value="Go" />
			  </form>
			</div> <!-- MIRROR -->

			<div id="frontshortcuts">
			  <div id="frontshortcutscontent" class="txtshortcuts">
				  <h2>GYORSMEN</h2>
				  <ul id="frontshortcutslist">
					<li>
					  <a
					    href="&base;/community/mailinglists.html" title="Levelezsi listk">Levelezsi listk</a>
					</li>
					<li>
					  <a
					    href="&base;/support/bugreports.html" title="Hibajelentsek">Hibajelentsek</a>
					</li>
					<li>
					  <a
					    href="&enbase;/doc/hu/books/faq/index.html" title="GYIK">GYIK</a>
					</li>
					<li>
					  <a
					    href="&enbase;/doc/hu/books/handbook/index.html" title="Kziknyv">Kziknyv</a>
					</li>
					<li>
					  <a
					    href="&enbase;/ports/index.html" title="Portok">Portok</a>
					</li>

				  </ul>
			  </div> <!-- FRONTSHORTCUTSCONTENT -->
			</div> <!-- FRONTSHORTCUTS -->

			<div class="frontnewroundbox">
			  <div class="frontnewtop"><div><b style="display: none">.</b></div></div>
			    <div class="frontnewcontent">
			      <a
				href="&enbase;/projects/newbies.html">j felhasznl?</a>
			    </div> <!-- frontnewcontent -->
			  <div class="frontnewbot"><div><b style="display: none">.</b></div></div>
			</div> <!-- frontnewroundbox -->
		</div> <!-- FEATURERIGHT -->

            </div> <!-- FRONTFEATURECONTAINER -->

	    <br class="clearboth" />
            <div id="frontnemscontainer">
            	<div id="frontnews">
            	   <div id="frontnewscontent" class="txtnewsevent">
			<h2>FRISS HREK</h2>
			<div class="newseventswrap">

			<xsl:call-template name="html-index-news-project-items">
				<xsl:with-param name="news.project.xml-master" select="$news.project.xml-master" />
				<xsl:with-param name="news.project.xml" select="$news.project.xml" />
			</xsl:call-template>

			  <div>
				<ul class="newseventslist">
				  <li class="first-child">
					<a
					  href="&base;/news/newsflash.html" title="Tovbbi hrek">Tovbbi hrek</a>
				  </li>
				  <li class="last-child">
					<a
					  href="&base;/news/rss.xml" title="Hrek RSS Feed"><img class="rssimage" src="&enbase;/layout/images/ico_rss.png" width="27" height="12" alt="Hrek RSS feedben" /></a>
				  </li>
				</ul>
			  </div> <!-- unnamed -->
			</div> <!-- newseventswrap -->

            	   </div> <!-- FRONTNEWSCONTENT -->
            	</div> <!-- FRONTNEWS -->
            	<div class="frontseparator"><b style="display: none">.</b></div>
            	<div id="frontevents">
		   <div id="fronteventscontent" class="txtnewsevent">

			<h2>RENDEZVNYEK</h2>
			<div class="newseventswrap">

			<xsl:call-template name="html-index-events-items">
				<xsl:with-param name="events.xml-master" select="$events.xml-master" />
				<xsl:with-param name="events.xml" select="$events.xml" />
			</xsl:call-template>

			  <div>
				<ul class="newseventslist">
				  <li class="only-child">
					<a
					  href="&base;/events/" title="Tovbbi rendezvnyek">Tovbbi rendezvnyek</a>
				  </li>
				</ul>
			  </div> <!-- unnamed -->
			</div> <!-- newseventswrap -->

		   </div> <!-- FRONTEVENTSCONTENT -->
            	</div> <!-- FRONTEVENTS -->
            	<div class="frontseparator"><b style="display: none">.</b></div>
            	<div id="frontmedia">
		   <div id="frontmediacontent" class="txtnewsevent">

			<h2>A MDIBAN</h2>
			<div class="newseventswrap">

			<xsl:call-template name="html-index-news-press-items">
				<xsl:with-param name="news.press.xml-master" select="$news.press.xml-master" />
				<xsl:with-param name="news.press.xml" select="$news.press.xml" />
			</xsl:call-template>

			  <div>
				<ul class="newseventslist">
				  <li class="only-child">
					<a
					  href="&base;/news/press.html" title="Tovbb esemnyek a mdiban">Tovbb</a>
				  </li>
				</ul>
			  </div> <!-- unnamed -->
			</div> <!-- newseventswrap -->

		   </div> <!-- FRONTMEDIACONTENT -->
            	</div> <!-- FRONTMEDIA -->
		<div class="frontseparator"><b style="display: none">.</b></div>
		<div id="frontsecurity">
		   <div id="frontsecuritycontent" class="txtnewsevent">

			<h2>BIZTONSGI
			  FIGYELMEZTETSEK</h2>
			<div class="newseventswrap">

			<xsl:call-template name="html-index-advisories-items">
				<xsl:with-param name="advisories.xml" select="$advisories.xml" />
				<xsl:with-param name="type" select="'advisory'" />
			</xsl:call-template>

			  <div>
				<ul class="newseventslist">
				  <li class="first-child">
					<a
					  href="&base;/security/advisories.html" title="Tovbbi biztonsgi figyelmeztetsek">Tovbb</a>
				  </li>
				  <li class="last-child">
					<a
					  href="&base;/security/rss.xml" title="Biztonsgi figyelmeztetsek RSS Feed"><img class="rssimage" src="&enbase;/layout/images/ico_rss.png" width="27" height="12" alt="Biztonsgi figyelmeztetsek RSS feedben" /></a>
				  </li>
				</ul>
			  </div> <!-- unnamed -->
			</div> <!-- newseventswrap -->

			<br />
			<h2>HIBAJEGYZK</h2>
			<div class="newseventswrap">

			<xsl:call-template name="html-index-advisories-items">
				<xsl:with-param name="advisories.xml" select="$notices.xml" />
				<xsl:with-param name="type" select="'notice'" />
			</xsl:call-template>

			  <div>
			    <ul class="newseventslist">
			      <li class="first-child">
				<a
				  href="&base;/security/" title="Mg tbb sajthiba mutatsa">Tovbb</a>
			      </li>
			      <li class="last-child">
				<a
				  href="&base;/security/errata.xml" title="Sajthibk RSS Feed"><img class="rssimage" src="&enbase;/layout/images/ico_rss.png" width="27" height="12" alt="Sajthibk RSS feedben"/></a>
			      </li>
			    </ul>
			  </div> <!-- unnamed -->
			</div> <!-- newseventswrap -->

		   </div> <!-- FRONTSECURITYCONTENT -->
            	</div> <!-- FRONTSECURITY -->

		<br class="clearboth" />

            </div> <!-- FRONTNEMSCONTAINER -->
          </div> <!-- FRONTMAIN -->
        </div> <!-- FRONTCONTAINER -->
  </xsl:template>
</xsl:stylesheet>
