#!/usr/bin/perl

package eBay::API::XML::Call::RespondToBestOffer;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. RespondToBestOffer.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::RespondToBestOffer

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::RespondToBestOffer inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::RespondToBestOffer::RespondToBestOfferRequestType;
use eBay::API::XML::Call::RespondToBestOffer::RespondToBestOfferResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'RespondToBestOffer';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::RespondToBestOffer::RespondToBestOfferRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::RespondToBestOffer::RespondToBestOfferResponseType';
}

#
# input properties
#

=head2 setAction()

The action taken on the best offer by the seller (e.g.,
Accept, Decline, or Counter). Bulk Accept and Bulk
Counter are not supported. That is, you cannot accept or
counter multiple offers in a single call. You can,
however, decline multiple offers in a single call.

  RequiredInput: Yes
#    Argument: 'ns:BestOfferActionCodeType'

=cut
       
sub setAction {
   my $self   = shift;
   my $sAction = shift;
   $self->getRequestDataType()->setAction($sAction);
}

=head2 setBestOfferID()

The ID of a Best Offer for the item.

  RequiredInput: Yes
#    Argument: reference to an array  
                      of 'ns:BestOfferIDType'

=cut
       
sub setBestOfferID {
   my $self   = shift;
   my $pBestOfferID = shift;
   $self->getRequestDataType()->setBestOfferID($pBestOfferID);
}

=head2 setCounterOfferPrice()

The counter offer price. When Action is set to Counter,
you must specify the amount for the counteroffer with
CounterOfferPrice. The value of CounterOfferPrice cannot
exceed the Buy It Now price for a single quantity item.
The value of CounterOfferPrice may exceed the Buy It Now
price if the value for CounterOfferQuantity is greater
than 1.

  RequiredInput: Conditionally
#    Argument: 'ns:AmountType'

=cut
       
sub setCounterOfferPrice {
   my $self   = shift;
   my $pCounterOfferPrice = shift;
   $self->getRequestDataType()->setCounterOfferPrice($pCounterOfferPrice);
}

=head2 setCounterOfferQuantity()

The counter offer quantity. When Action is set to
Counter you must specify the quantity of items for the
counteroffer with CounterOfferQuantity.

  RequiredInput: Conditionally
#    Argument: 'xs:int'

=cut
       
sub setCounterOfferQuantity {
   my $self   = shift;
   my $sCounterOfferQuantity = shift;
   $self->getRequestDataType()->setCounterOfferQuantity($sCounterOfferQuantity);
}

=head2 setItemID()

Specifies the item for which the BestOffer data is to be returned.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setSellerResponse()

A comment from the seller to the buyer.

MaxLength: 250

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setSellerResponse {
   my $self   = shift;
   my $sSellerResponse = shift;
   $self->getRequestDataType()->setSellerResponse($sSellerResponse);
}



#
# output properties
#

=head2 getRespondToBestOffer()

A list of BestOffers that were either accepted or declined.

  Returned: Always
#    Returns: 'ns:BestOfferArrayType'

=cut
       
sub getRespondToBestOffer {
   my $self = shift;
   return $self->getResponseDataType()->getRespondToBestOffer();
}





1;   
