#!/usr/bin/env perl

use strict;
use warnings;

use Amazon::API qw{param_n get_api_service};
use Data::Dumper;
use List::Util qw(none);

########################################################################
sub format_attributes {
########################################################################
  my ($attributes) = @_;

  return Amazon::API::param_n( { Attributes => $attributes } );
}

########################################################################
sub format_tags {
########################################################################
  my ($tags) = @_;

  return Amazon::API::param_n( { Tag => $tags } );
}

########################################################################
sub list_queues {
########################################################################
  my (%options) = @_;

  return Amazon::API->new(
    { service     => 'sqs',
      http_method => 'GET',
      %options,
    }
  )->invoke_api('ListQueues');
}

########################################################################
sub queue_url {
########################################################################
  my ( $service, $queue_name ) = @_;

  return $service->GetQueueUrl( { QueueName => $queue_name } );
}

########################################################################
sub create_queue {
########################################################################
  my ( $service, $queue_name ) = @_;

  my $queue_url = eval { queue_url( $service, $queue_name ); };

  return $queue_url
    if $queue_url;

  my $attributes = [ { Name => 'VisibilityTimeout', Value => '100' } ];

  my $tags = [
    { Key   => 'Name',
      Value => $queue_name,
    },
    { Key   => 'Env',
      Value => 'dev'
    },
  ];

  my @attributes = format_attributes($attributes);
  my @tags       = format_tags($tags);

  #  $service->set_action('CreateQueue');
  #
  #  my $serialized = $service->serialize_content(
  #    $service->init_botocore_request(
  #      { QueueName  => $queue_name,
  #        Attributes => { VisibilityTimeout => 100, Foo => 'bar' },
  #        tags       => {
  #          Name => $queue_name,
  #          Env  => 'dev'
  #        }
  #      }
  #    )
  #
  #  );
  #
  #  print {*STDERR} Dumper( [ serialized => $serialized ] );

  return $service->CreateQueue(
    { QueueName  => $queue_name,
      Attributes =>
        { VisibilityTimeout => 100, ReceiveMessageWaitTimeSeconds => 30 },
      tags => {
        Name => $queue_name,
        Env  => 'dev'
      }
    }
  );

  return $service->CreateQueue( [ 'QueueName=foo', @attributes, @tags ] );
}

########################################################################
sub main {
########################################################################

  my %options = (
    debug              => $ENV{DEBUG},
    url                => 'http://localhost:4566',
    no_passkey_warning => 1,
  );

  my $sqs = get_api_service( 'sqs', %options, );

  #  print {*STDERR} Dumper( [ queues => list_queues(%options) ] );

  create_queue( $sqs, 'foo3' );
  #  exit;
  #
  #  #print {*STDERR} Dumper( [ create_queue => create_queue( $sqs, 'foo' ) ] );
  #
  my $queue_url = queue_url( $sqs, 'foo3' );
  #
  #  print {*STDERR} Dumper( [ queue_url => $queue_url ] );
  #
  my $queue_list = $sqs->ListQueues;

  print {*STDERR} Dumper(
    [ queue_list => $queue_list,
      queue_url  => $queue_url,
      attributes => $sqs->GetQueueAttributes(
        { QueueUrl       => $queue_url->{QueueUrl},
          AttributeNames => ['All']
        }
      )
    ]
  );

  return 0;
}

exit main();

1;
__END__
