package Dancer2::Plugin::Menu::Tree ;
$Dancer2::Plugin::Menu::Tree::VERSION = '0.001';
use Moo;
use Data::Dumper qw(Dumper);

has name => (is => 'ro');
has subs => (is => 'rw', isa => sub { die unless ref shift eq 'ARRAY' });

sub add_menu_item {
  my ($self, @names)  = @_;
  my $next_name       = shift @names;

  # names empty: do nothing
  return unless defined $next_name;
  $next_name ||= '/';
  print Dumper $next_name;

  # find or create a matching tree
  my $subtree = first {$_->name eq $next_name} @{$self->subs} if @{$self->subs};
  push @{$self->subs}, $subtree = Dancer2::Plugin::Menu::Tree->new(name => $next_name, subs => [])
      unless defined $subtree;

  # recurse
  $subtree->add_menu_item(@names);
}

1;

__END__

=pod

=head1 NAME

Dancer2::Plugin::Menu::Tree

=head1 VERSION

version 0.001

=head1 REQUIRES

=over 4

=item * L<Data::Dumper|Data::Dumper>

=item * L<Moo|Moo>

=back

=head1 BUGS AND LIMITATIONS

You can make new bug reports, and view existing ones, through the
web interface at L<https://github.com/sdondley/Dancer2-Plugin-Menu/issues>.

=head1 INSTALLATION

See perlmodinstall for information and options on installing Perl modules.

=head1 AUTHOR

Steve Dondley <s@dondley.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Steve Dondley.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
