
#!/usr/bin/perl
use strict;
use warnings;
# This class is generated from DBIx.pm. Do not modify.
package WWW::Shopify::Model::DBIx::Schema::Result::Model::Product::Variant;
use base qw/DBIx::Class::Core/;

__PACKAGE__->load_components(qw/InflateColumn::DateTime/);

__PACKAGE__->table('shopify_products_variants');
__PACKAGE__->add_columns(
	"compare_at_price", { data_type => 'DECIMAL(10,2)', is_nullable => '1' },
	"requires_shipping", { data_type => 'BOOL', is_nullable => '1' },
	"id", { data_type => 'BIGINT', is_nullable => '0' },
	"option3", { is_nullable => '1', data_type => 'VARCHAR(255)' },
	"fufillment_service", { data_type => 'VARCHAR(255)', is_nullable => '1' },
	"title", { is_nullable => '1', data_type => 'VARCHAR(255)' },
	"option1", { data_type => 'VARCHAR(255)', is_nullable => '1' },
	"option2", { is_nullable => '1', data_type => 'VARCHAR(255)' },
	"inventory_management", { data_type => 'VARCHAR(255)', is_nullable => '1' },
	"price", { data_type => 'DECIMAL(10,2)', is_nullable => '1' },
	"grams", { is_nullable => '1', data_type => 'INT' },
	"old_inventory_quantity", { data_type => 'INT', is_nullable => '1' },
	"inventory_policy", { data_type => 'VARCHAR(255)', is_nullable => '1' },
	"inventory_quantity", { is_nullable => '1', data_type => 'INT' },
	"position", { data_type => 'INT', is_nullable => '1' },
	"updated_at", { is_nullable => '1', data_type => 'DATETIME' },
	"taxable", { is_nullable => '1', data_type => 'BOOL' },
	"created_at", { data_type => 'DATETIME', is_nullable => '1' },
	"sku", { is_nullable => '1', data_type => 'VARCHAR(255)' },
	"barcode", { is_nullable => '1', data_type => 'VARCHAR(255)' },
	"product_id", { data_type => 'BIGINT' },
	"shop_id", { data_type => "BIGINT" }
);
__PACKAGE__->set_primary_key('id');



__PACKAGE__->belongs_to(shop => 'WWW::Shopify::Model::DBIx::Schema::Result::Model::Shop', 'shop_id');

__PACKAGE__->belongs_to(product => 'WWW::Shopify::Model::DBIx::Schema::Result::Model::Product', 'product_id');
__PACKAGE__->has_many(metafields_hasmany => 'WWW::Shopify::Model::DBIx::Schema::Result::Model::MetafieldVariant', 'variant_id');
__PACKAGE__->many_to_many(metafields => 'metafields_hasmany', 'metafield');
sub represents { return 'WWW::Shopify::Model::Product::Variant'; }
sub parent_variable { return 'product_id'; }

1;