#!perl
use strict;
use warnings;

use Test::More;
use Test::Number::Delta relative => 1E-10;

BEGIN {
    use_ok('Time::Moment');
}

{
    my @tests = (
        [ '0001-01-01T00:00:00Z',     1.0                ],
        [ '0001-01-01T00:00:00.001Z', 1.0000000116       ],
        [ '0001-01-01T00:00:00.002Z', 1.0000000231       ],
        [ '0001-01-01T00:00:00.010Z', 1.0000001157       ],
        [ '0001-01-01T00:00:00.020Z', 1.0000002315       ],
        [ '0001-01-01T00:00:00.100Z', 1.0000011574       ],
        [ '0001-01-01T00:00:00.200Z', 1.0000023148       ],
        [ '0001-01-01T00:00:00.300Z', 1.0000034722       ],
        [ '0001-01-01T00:00:00.400Z', 1.0000046296       ],
        [ '0001-01-01T00:00:00.490Z', 1.0000056713       ],
        [ '0001-01-01T00:00:00.499Z', 1.0000057755       ],
        [ '0001-01-01T00:00:00.500Z', 1.000005787        ],
        [ '0001-01-01T00:00:00.501Z', 1.0000057986       ],
        [ '0001-01-01T00:00:00.510Z', 1.0000059028       ],
        [ '0001-01-01T00:00:00.600Z', 1.0000069444       ],
        [ '0001-01-01T00:00:00.700Z', 1.0000081019       ],
        [ '0001-01-01T00:00:00.800Z', 1.0000092593       ],
        [ '0001-01-01T00:00:00.900Z', 1.0000104167       ],
        [ '0001-01-01T00:00:00.980Z', 1.0000113426       ],
        [ '0001-01-01T00:00:00.990Z', 1.0000114583       ],
        [ '0001-01-01T00:00:00.998Z', 1.0000115509       ],
        [ '0001-01-01T00:00:00.999Z', 1.0000115625       ],
        [ '0001-01-01T00:00:01Z',     1.0000115741       ],
        [ '0001-01-01T00:00:01.001Z', 1.0000115856       ],
        [ '0001-01-01T00:00:01.002Z', 1.0000115972       ],
        [ '0001-01-01T00:00:01.010Z', 1.0000116898       ],
        [ '0001-01-01T00:00:01.020Z', 1.0000118056       ],
        [ '0001-01-01T00:00:01.100Z', 1.0000127315       ],
        [ '0001-01-01T00:00:01.200Z', 1.0000138889       ],
        [ '1899-12-31T00:00:00Z',     693595.0           ],
        [ '1900-01-01T00:00:00Z',     693596.0           ],
        [ '1900-02-27T00:00:00Z',     693653.0           ],
        [ '1900-02-28T00:00:00Z',     693654.0           ],
        [ '1900-03-01T00:00:00Z',     693655.0           ],
        [ '1900-03-02T00:00:00Z',     693656.0           ],
        [ '1969-12-31T23:59:58Z',     719162.9999768519  ],
        [ '1969-12-31T23:59:58.500Z', 719162.9999826389  ],
        [ '1969-12-31T23:59:58.800Z', 719162.9999861111  ],
        [ '1969-12-31T23:59:58.900Z', 719162.9999872685  ],
        [ '1969-12-31T23:59:58.980Z', 719162.9999881944  ],
        [ '1969-12-31T23:59:58.990Z', 719162.9999883102  ],
        [ '1969-12-31T23:59:58.998Z', 719162.9999884028  ],
        [ '1969-12-31T23:59:58.999Z', 719162.9999884143  ],
        [ '1969-12-31T23:59:59Z',     719162.9999884259  ],
        [ '1969-12-31T23:59:59.001Z', 719162.9999884375  ],
        [ '1969-12-31T23:59:59.002Z', 719162.999988449   ],
        [ '1969-12-31T23:59:59.010Z', 719162.9999885417  ],
        [ '1969-12-31T23:59:59.020Z', 719162.9999886574  ],
        [ '1969-12-31T23:59:59.100Z', 719162.9999895834  ],
        [ '1969-12-31T23:59:59.200Z', 719162.9999907408  ],
        [ '1969-12-31T23:59:59.300Z', 719162.9999918982  ],
        [ '1969-12-31T23:59:59.400Z', 719162.9999930556  ],
        [ '1969-12-31T23:59:59.490Z', 719162.9999940973  ],
        [ '1969-12-31T23:59:59.499Z', 719162.9999942014  ],
        [ '1969-12-31T23:59:59.500Z', 719162.999994213   ],
        [ '1969-12-31T23:59:59.501Z', 719162.9999942245  ],
        [ '1969-12-31T23:59:59.510Z', 719162.9999943287  ],
        [ '1969-12-31T23:59:59.600Z', 719162.9999953704  ],
        [ '1969-12-31T23:59:59.700Z', 719162.9999965278  ],
        [ '1969-12-31T23:59:59.800Z', 719162.9999976852  ],
        [ '1969-12-31T23:59:59.900Z', 719162.9999988426  ],
        [ '1969-12-31T23:59:59.980Z', 719162.9999997686  ],
        [ '1969-12-31T23:59:59.990Z', 719162.9999998843  ],
        [ '1969-12-31T23:59:59.998Z', 719162.9999999768  ],
        [ '1969-12-31T23:59:59.999Z', 719162.9999999885  ],
        [ '1970-01-01T00:00:00Z',     719163.0           ],
        [ '1970-01-01T00:00:00.001Z', 719163.0000000115  ],
        [ '1970-01-01T00:00:00.002Z', 719163.0000000232  ],
        [ '1970-01-01T00:00:00.010Z', 719163.0000001157  ],
        [ '1970-01-01T00:00:00.020Z', 719163.0000002314  ],
        [ '1970-01-01T00:00:00.100Z', 719163.0000011574  ],
        [ '1970-01-01T00:00:00.200Z', 719163.0000023148  ],
        [ '1970-01-01T00:00:00.300Z', 719163.0000034722  ],
        [ '1970-01-01T00:00:00.400Z', 719163.0000046296  ],
        [ '1970-01-01T00:00:00.490Z', 719163.0000056713  ],
        [ '1970-01-01T00:00:00.499Z', 719163.0000057755  ],
        [ '1970-01-01T00:00:00.500Z', 719163.000005787   ],
        [ '1970-01-01T00:00:00.501Z', 719163.0000057986  ],
        [ '1970-01-01T00:00:00.510Z', 719163.0000059027  ],
        [ '1970-01-01T00:00:00.600Z', 719163.0000069444  ],
        [ '1970-01-01T00:00:00.700Z', 719163.0000081018  ],
        [ '1970-01-01T00:00:00.800Z', 719163.0000092592  ],
        [ '1970-01-01T00:00:00.900Z', 719163.0000104166  ],
        [ '1970-01-01T00:00:00.980Z', 719163.0000113426  ],
        [ '1970-01-01T00:00:00.990Z', 719163.0000114583  ],
        [ '1970-01-01T00:00:00.998Z', 719163.000011551   ],
        [ '1970-01-01T00:00:00.999Z', 719163.0000115625  ],
        [ '1970-01-01T00:00:01Z',     719163.0000115741  ],
        [ '1970-01-01T00:00:01.001Z', 719163.0000115857  ],
        [ '1970-01-01T00:00:01.002Z', 719163.0000115972  ],
        [ '1970-01-01T00:00:01.010Z', 719163.0000116898  ],
        [ '1970-01-01T00:00:01.020Z', 719163.0000118056  ],
        [ '1970-01-01T00:00:01.100Z', 719163.0000127315  ],
        [ '1970-01-01T00:00:01.200Z', 719163.0000138889  ],
        [ '1982-08-25T00:15:20.213Z', 723782.0106506135  ],
        [ '2065-04-19T00:16:48.290Z', 753970.0116700232  ],
        [ '2147-12-15T00:55:25.446Z', 784159.0384889584  ],
        [ '2230-08-10T01:02:46.891Z', 814347.0435982755  ],
        [ '2313-04-06T01:04:15.597Z', 844536.0446249653  ],
        [ '2395-11-30T01:09:40.889Z', 874724.048389919   ],
        [ '2478-07-25T01:11:32.560Z', 904912.0496824074  ],
        [ '2561-03-21T01:30:19.169Z', 935101.0627218634  ],
        [ '2643-11-15T01:48:25.580Z', 965289.0752960648  ],
        [ '2726-07-12T02:03:31.919Z', 995478.0857860995  ],
        [ '2809-03-06T02:11:11.986Z', 1025666.0911109491 ],
        [ '2891-10-31T02:24:37.095Z', 1055855.1004293403 ],
        [ '2974-06-26T02:35:07.220Z', 1086043.1077224538 ],
        [ '3057-02-19T02:45:12.109Z', 1116231.1147234838 ],
        [ '3139-10-17T03:06:39.990Z', 1146420.1296295139 ],
        [ '3222-06-11T03:08:08.251Z', 1176608.1306510533 ],
        [ '3305-02-05T03:19:12.576Z', 1206797.1383400001 ],
        [ '3387-10-01T03:29:42.574Z', 1236985.1456316435 ],
        [ '3470-05-27T03:37:30.813Z', 1267173.1510510764 ],
        [ '3553-01-21T04:14:38.231Z', 1297362.1768313772 ],
        [ '3635-09-16T04:16:28.559Z', 1327550.1781083217 ],
        [ '3718-05-13T04:17:58.222Z', 1357739.179146088  ],
        [ '3801-01-06T04:21:41.794Z', 1387927.1817337268 ],
        [ '3883-09-02T04:56:35.792Z', 1418116.2059698149 ],
        [ '3966-04-28T05:25:14.885Z', 1448304.2258667245 ],
        [ '4048-12-21T05:26:05.724Z', 1478492.226455139  ],
        [ '4131-08-18T05:46:44.068Z', 1508681.2407878242 ],
        [ '4214-04-13T05:48:01.141Z', 1538869.2416798726 ],
        [ '4296-12-07T05:53:52.315Z', 1569058.2457443867 ],
        [ '4379-08-03T06:14:48.580Z', 1599246.2602844907 ],
        [ '4462-03-28T06:46:15.738Z', 1629434.2821265971 ],
        [ '4544-11-22T07:31:20.407Z', 1659623.3134306367 ],
        [ '4627-07-19T07:58:33.754Z', 1689811.3323351156 ],
        [ '4710-03-15T08:07:43.130Z', 1720000.3386936344 ],
        [ '4792-11-07T08:29:11.091Z', 1750188.3536005903 ],
        [ '4875-07-04T09:08:15.328Z', 1780377.3807329629 ],
        [ '4958-02-27T09:30:41.781Z', 1810565.3963169097 ],
        [ '5040-10-23T09:34:04.462Z', 1840753.3986627546 ],
        [ '5123-06-20T09:37:23.945Z', 1870942.4009715857 ],
        [ '5206-02-12T09:37:56.655Z', 1901130.4013501736 ],
        [ '5288-10-08T09:45:12.230Z', 1931319.406391551  ],
        [ '5371-06-04T09:54:14.782Z', 1961507.412671088  ],
        [ '5454-01-28T09:54:22.108Z', 1991695.4127558796 ],
        [ '5536-09-24T10:01:36.151Z', 2021884.4177795255 ],
        [ '5619-05-20T12:09:48.602Z', 2052072.5068125231 ],
        [ '5702-01-14T12:34:08.549Z', 2082261.5237100578 ],
        [ '5784-09-08T12:56:06.495Z', 2112449.5389640625 ],
        [ '5867-05-06T12:58:58.217Z', 2142638.5409515859 ],
        [ '5949-12-30T12:59:54.263Z', 2172826.541600266  ],
        [ '6032-08-24T13:34:41.331Z', 2203014.5657561459 ],
        [ '6115-04-21T13:58:28.601Z', 2233203.5822754744 ],
        [ '6197-12-14T14:02:16.899Z', 2263391.5849178126 ],
        [ '6280-08-10T14:36:17.444Z', 2293580.6085352316 ],
        [ '6363-04-06T14:37:57.451Z', 2323768.6096927198 ],
        [ '6445-11-30T14:57:42.757Z', 2353957.6234115395 ],
        [ '6528-07-26T15:10:48.307Z', 2384145.6325035533 ],
        [ '6611-03-22T15:14:39.890Z', 2414333.6351839122 ],
        [ '6693-11-15T15:19:47.988Z', 2444522.6387498612 ],
        [ '6776-07-11T16:04:24.344Z', 2474710.6697262037 ],
        [ '6859-03-07T16:22:23.952Z', 2504899.6822216664 ],
        [ '6941-10-31T16:29:55.999Z', 2535087.6874536923 ],
        [ '7024-06-26T16:58:20.259Z', 2565275.7071789238 ],
        [ '7107-02-21T17:04:02.415Z', 2595464.7111390624 ],
        [ '7189-10-16T17:18:29.630Z', 2625652.7211762732 ],
        [ '7272-06-11T17:47:21.323Z', 2655841.7412190163 ],
        [ '7355-02-05T17:53:29.866Z', 2686029.7454845603 ],
        [ '7437-10-02T17:53:41.076Z', 2716218.7456143056 ],
        [ '7520-05-28T17:55:06.044Z', 2746406.7465977315 ],
        [ '7603-01-21T18:14:49.151Z', 2776594.7602910995 ],
        [ '7685-09-16T18:17:45.738Z', 2806783.7623349307 ],
        [ '7768-05-12T18:29:59.700Z', 2836971.7708298611 ],
        [ '7851-01-07T18:33:21.233Z', 2867160.773162419  ],
        [ '7933-09-02T19:14:24.673Z', 2897348.8016744559 ],
        [ '8016-04-27T19:17:12.816Z', 2927536.8036205554 ],
        [ '8098-12-22T19:23:36.418Z', 2957725.8080603937 ],
        [ '8181-08-17T19:46:25.908Z', 2987913.8239109721 ],
        [ '8264-04-13T20:07:47.314Z', 3018102.8387420601 ],
        [ '8346-12-08T20:31:37.603Z', 3048290.855296331  ],
        [ '8429-08-03T20:39:57.770Z', 3078479.8610853008 ],
        [ '8512-03-29T20:50:17.067Z', 3108667.8682530904 ],
        [ '8594-11-22T21:02:57.827Z', 3138855.8770581828 ],
        [ '8677-07-19T21:23:05.519Z', 3169044.8910360998 ],
        [ '8760-03-14T21:34:49.572Z', 3199232.8991848612 ],
        [ '8842-11-08T21:39:05.944Z', 3229421.9021521294 ],
        [ '8925-07-04T21:39:18.426Z', 3259609.9022965971 ],
        [ '9008-02-28T21:46:07.769Z', 3289797.9070343636 ],
        [ '9090-10-24T21:57:55.662Z', 3319986.9152275696 ],
        [ '9173-06-19T22:19:11.732Z', 3350174.9299968979 ],
        [ '9256-02-13T22:23:51.376Z', 3380363.9332335186 ],
        [ '9338-10-09T22:27:58.771Z', 3410551.9360968866 ],
        [ '9421-06-05T22:43:30.392Z', 3440740.9468795368 ],
        [ '9504-01-30T22:48:25.834Z', 3470928.9502990046 ],
        [ '9586-09-24T22:53:51.727Z', 3501116.9540709145 ],
        [ '9669-05-20T23:12:56.536Z', 3531305.9673210187 ],
        [ '9752-01-14T23:15:54.109Z', 3561493.9693762613 ],
        [ '9834-09-10T23:17:12.632Z', 3591682.9702850925 ],
        [ '9999-12-31T23:59:58Z',     3652059.999976852  ],
        [ '9999-12-31T23:59:58.500Z', 3652059.9999826388 ],
        [ '9999-12-31T23:59:58.800Z', 3652059.9999861112 ],
        [ '9999-12-31T23:59:58.900Z', 3652059.9999872684 ],
        [ '9999-12-31T23:59:58.980Z', 3652059.9999881946 ],
        [ '9999-12-31T23:59:58.990Z', 3652059.99998831   ],
        [ '9999-12-31T23:59:58.998Z', 3652059.9999884027 ],
        [ '9999-12-31T23:59:58.999Z', 3652059.9999884143 ],
        [ '9999-12-31T23:59:59Z',     3652059.999988426  ],
        [ '9999-12-31T23:59:59.001Z', 3652059.9999884376 ],
        [ '9999-12-31T23:59:59.002Z', 3652059.9999884493 ],
        [ '9999-12-31T23:59:59.010Z', 3652059.9999885415 ],
        [ '9999-12-31T23:59:59.020Z', 3652059.9999886574 ],
        [ '9999-12-31T23:59:59.100Z', 3652059.9999895832 ],
        [ '9999-12-31T23:59:59.200Z', 3652059.9999907408 ],
        [ '9999-12-31T23:59:59.300Z', 3652059.999991898  ],
        [ '9999-12-31T23:59:59.400Z', 3652059.9999930556 ],
        [ '9999-12-31T23:59:59.490Z', 3652059.9999940973 ],
        [ '9999-12-31T23:59:59.499Z', 3652059.9999942016 ],
        [ '9999-12-31T23:59:59.500Z', 3652059.9999942128 ],
        [ '9999-12-31T23:59:59.501Z', 3652059.9999942244 ],
        [ '9999-12-31T23:59:59.510Z', 3652059.9999943287 ],
        [ '9999-12-31T23:59:59.600Z', 3652059.9999953704 ],
        [ '9999-12-31T23:59:59.700Z', 3652059.9999965276 ],
        [ '9999-12-31T23:59:59.800Z', 3652059.9999976852 ],
        [ '9999-12-31T23:59:59.900Z', 3652059.9999988424 ],
        [ '9999-12-31T23:59:59.980Z', 3652059.9999997686 ],
        [ '9999-12-31T23:59:59.990Z', 3652059.9999998841 ],
        [ '9999-12-31T23:59:59.998Z', 3652059.9999999767 ],
        [ '9999-12-31T23:59:59.999Z', 3652059.9999999884 ],
    );

    foreach my $test (@tests) {
        my ($string, $rd) = @$test;
    
        my $tm = Time::Moment->from_rd($rd);
        is($tm->to_string, $string, "Time::Moment->from_rd($rd)");
        delta_ok($tm->rd, $rd, "$tm->rd"); 
    }
}

{
    my $tm = Time::Moment->from_rd(719163, offset => 60);
    is($tm->to_string, '1970-01-01T00:00:00+01:00');
}

{
    my $tm = Time::Moment->from_rd(719163, offset => -60);
    is($tm->to_string, '1970-01-01T00:00:00-01:00');
}

{
    my $tm = Time::Moment->from_rd(0, epoch => 719163, offset => 60);
    is($tm->to_string, '1970-01-01T00:00:00+01:00');
}

{
    my $tm = Time::Moment->from_rd(0, epoch => 719163, offset => -60);
    is($tm->to_string, '1970-01-01T00:00:00-01:00');
}

{
    my $tm = Time::Moment->from_rd(0.000001428888889, epoch => 719163, precision => 6);
    is($tm->to_string, '1970-01-01T00:00:00.123456Z');
}

done_testing();
