use Test::More;
use strict;
use warnings;
our ( $sub, $globref );

BEGIN {
	use_ok('Hades::Realm::Mouse');
	$sub     = sub { };
	$globref = \*globref;
}
subtest 'new' => sub {
	plan tests => 3;
	ok( my $obj = Hades::Realm::Mouse->new( {} ),
		q{my $obj = Hades::Realm::Mouse->new({})}
	);
	ok( $obj = Hades::Realm::Mouse->new(),
		q{$obj = Hades::Realm::Mouse->new()}
	);
	isa_ok( $obj, 'Hades::Realm::Mouse' );
};
subtest 'build_as_role' => sub {
	plan tests => 2;
	ok( my $obj = Hades::Realm::Mouse->new( {} ),
		q{my $obj = Hades::Realm::Mouse->new({})}
	);
	can_ok( $obj, 'build_as_role' );
};
subtest 'build_as_class' => sub {
	plan tests => 2;
	ok( my $obj = Hades::Realm::Mouse->new( {} ),
		q{my $obj = Hades::Realm::Mouse->new({})}
	);
	can_ok( $obj, 'build_as_class' );
};
subtest 'build_has' => sub {
	plan tests => 4;
	ok( my $obj = Hades::Realm::Mouse->new( {} ),
		q{my $obj = Hades::Realm::Mouse->new({})}
	);
	can_ok( $obj, 'build_has' );
	eval { $obj->build_has( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->build_has([])} );
	eval { $obj->build_has('limos') };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->build_has('limos')} );
};
subtest 'build_accessor_predicate' => sub {
	plan tests => 6;
	ok( my $obj = Hades::Realm::Mouse->new( {} ),
		q{my $obj = Hades::Realm::Mouse->new({})}
	);
	can_ok( $obj, 'build_accessor_predicate' );
	eval { $obj->build_accessor_predicate( [], 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->build_accessor_predicate([], 'hypnos')}
	);
	eval { $obj->build_accessor_predicate( \1, 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->build_accessor_predicate(\1, 'hypnos')}
	);
	eval { $obj->build_accessor_predicate( 'thanatos', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->build_accessor_predicate('thanatos', [])}
	);
	eval { $obj->build_accessor_predicate( 'thanatos', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->build_accessor_predicate('thanatos', \1)}
	);
};
subtest 'build_accessor_clearer' => sub {
	plan tests => 6;
	ok( my $obj = Hades::Realm::Mouse->new( {} ),
		q{my $obj = Hades::Realm::Mouse->new({})}
	);
	can_ok( $obj, 'build_accessor_clearer' );
	eval { $obj->build_accessor_clearer( [], 'curae' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->build_accessor_clearer([], 'curae')}
	);
	eval { $obj->build_accessor_clearer( \1, 'curae' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->build_accessor_clearer(\1, 'curae')}
	);
	eval { $obj->build_accessor_clearer( 'phobos', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->build_accessor_clearer('phobos', [])}
	);
	eval { $obj->build_accessor_clearer( 'phobos', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->build_accessor_clearer('phobos', \1)}
	);
};
done_testing();
