/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.tilecodec;

import com.sun.media.jai.tilecodec.JaiI18N;
import com.sun.media.jai.tilecodec.TileCodecUtils;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileEncoderImpl;

public class GZIPTileEncoder
extends TileEncoderImpl {
    public GZIPTileEncoder(OutputStream outputStream, TileCodecParameterList tileCodecParameterList) {
        super("gzip", outputStream, tileCodecParameterList);
    }

    public void encode(Raster raster) throws IOException {
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileEncoder1"));
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(this.outputStream));
        Object object = TileCodecUtils.serializeRaster(raster);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
    }
}

