#!/usr/bin/perl

package eBay::API::XML::Call::GetSearchResults;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSearchResults.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSearchResults

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSearchResults inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetSearchResults::GetSearchResultsRequestType;
use eBay::API::XML::Call::GetSearchResults::GetSearchResultsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetSearchResults';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSearchResults::GetSearchResultsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSearchResults::GetSearchResultsResponseType';
}

#
# input properties
#

=head2 setAdFormat()

Restricts listings to return only items that have the Ad Format feature.
If true, the values of ItemTypeFilter and
StoreSearchFilter are ignored (if they are specified). That is, "AND"
logic is not applied.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setAdFormat {
   my $self   = shift;
   my $sAdFormat = shift;
   $self->getRequestDataType()->setAdFormat($sAdFormat);
}

=head2 setAffiliateTrackingDetails()

Container for affiliate tags.
If you use affiliate tags, it is possible to get affiliate commissions
based on calls made by your application.
(See the <a href="https://www.ebaypartnernetwork.com/" target="_blank">eBay Partner Network</a>
for information about commissions.)
Affiliate tags enable the tracking of user activity.
You can use child tags of AffiliateTrackingDetails if you want
call output to include a string that includes
affiliate tracking information.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AffiliateTrackingConcepts
Title: Affiliate Tracking Concepts

  RequiredInput: No
#    Argument: 'ns:AffiliateTrackingDetailsType'

=cut
       
sub setAffiliateTrackingDetails {
   my $self   = shift;
   my $pAffiliateTrackingDetails = shift;
   $self->getRequestDataType()->setAffiliateTrackingDetails($pAffiliateTrackingDetails);
}

=head2 setBidRange()

Limits the results to items with a minimum or maximum number
of bids. You also can specify a bid range by specifying
both a minimum and maximum number of bids in one call.

  RequiredInput: No
#    Argument: 'ns:BidRangeType'

=cut
       
sub setBidRange {
   my $self   = shift;
   my $pBidRange = shift;
   $self->getRequestDataType()->setBidRange($pBidRange);
}

=head2 setCategories()

Retrieves statistical (histogram) information about categories that contain items
that match the query. Can also cause the result to include information
about buying guides that are associated with the matching categories.
Does not control the set of listings to return or the details to return
for each listing.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SearchingForMatchingCategories
Title: Searching for Matching Categories

  RequiredInput: No
#    Argument: 'ns:RequestCategoriesType'

=cut
       
sub setCategories {
   my $self   = shift;
   my $pCategories = shift;
   $self->getRequestDataType()->setCategories($pCategories);
}

=head2 setCategoryID()

Limits the result set to items in the specified category.
If no category ID is specified, all categories
are searched by default.<br>
<br>
<span class="tablenote"><b>Note:</b>
CategoryID does not control whether you will see the
item's categories in the response. Set the value of DetailLevel to
ItemReturnCategories to retrieve each item's primary category and
secondary category (if any) in the response.</span><br>
<br>
If the specified category ID doesn't match an existing category
for the site, an invalid-category error message is returned.
Here are a few ways to determine valid categories:<br>
- Use the Categories input field to retrieve
matching categories, and then submit the request again with one of
those categories.<br>
- Find items in all categories but set DetailLevel to
ItemReturnCategories, determine the primary (or secondary)
category ID for a similar item in the results, and then
submit the request again with that category ID.<br>
- Use another call like GetCategories or GetSuggestedCategories to
find a valid category ID.<br>
<br>
You must pass ProductID, Query, ExternalProductID, or CategoryID
in the request. CategoryID can be used in combination with Query.
It is not allowed with ExternalProductID or ProductID.
If you pass CategoryID without Query, it
must specify a leaf category ID. That is, it cannot be a
meta-category ID (e.g., 267 for "Books").

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SearchingByCategoryID
Title: Searching by Category ID
MaxLength: 10

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setCategoryID {
   my $self   = shift;
   my $sCategoryID = shift;
   $self->getRequestDataType()->setCategoryID($sCategoryID);
}

=head2 setCharityID()

Restricts listings to return only items that support the specified
nonprofit charity organization. Retrieve CharityID values with
GetCharities.

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setCharityID {
   my $self   = shift;
   my $sCharityID = shift;
   $self->getRequestDataType()->setCharityID($sCharityID);
}

=head2 setEndTimeFrom()

Limits the results to items ending within a time range. EndTimeFrom
specifies the beginning of the time range. Specify a time in the future.
If you specify a time in the past, the current time is used. If specified,
EndTimeTo must also be specified (with a value equal to or later than
EndTimeFrom). Express the time in GMT. Cannot be used with the ModTimeFrom
filter.

  RequiredInput: Conditionally
#    Argument: 'xs:dateTime'

=cut
       
sub setEndTimeFrom {
   my $self   = shift;
   my $sEndTimeFrom = shift;
   $self->getRequestDataType()->setEndTimeFrom($sEndTimeFrom);
}

=head2 setEndTimeTo()

Limits the results to items ending within a time range. EndTimeTo specifies
the end of the time range. If specified, EndTimeFrom must also be specified
(with a value equal to or earlier than EndTimeTo). Express the time in GMT.
Cannot be used with the ModTimeFrom filter.

  RequiredInput: Conditionally
#    Argument: 'xs:dateTime'

=cut
       
sub setEndTimeTo {
   my $self   = shift;
   my $sEndTimeTo = shift;
   $self->getRequestDataType()->setEndTimeTo($sEndTimeTo);
}

=head2 setExpandSearch()

Expands search results when a small result set is returned. For example,
on the US site (site ID 0), if a search would normally result in fewer
than 10 items, then if you specify true for this tag, the search results
are expanded. Specifically, the search returns items (if there are
matches) in one or more of the following containers:
InternationalExpansionArray (for items available from international
sellers), FilterRemovedExpansionArray (items that would be returned if
filters such as PriceRangeFilter are removed), StoreExpansionArray (for
items listed in the Store Inventory Format), and
AllCategoriesExpansionArray (for items available if category filters are
removed). Maximum number of items returned in each expansion container is
6 to 10.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setExpandSearch {
   my $self   = shift;
   my $sExpandSearch = shift;
   $self->getRequestDataType()->setExpandSearch($sExpandSearch);
}

=head2 setExternalProductID()

An exclusive query to only retrieve items that were listed with the
specified ISBN or UPC. Only applicable for items that were listed with
Pre-filled Item Information in media categories (Books, Music, DVDs and
Movies, and Video Games). You must pass ProductID, Query,
ExternalProductID, or CategoryID in the request. If you use
ExternalProductID, do not use Query, ProductID, or CategoryID.

  RequiredInput: Conditionally
#    Argument: 'ns:ExternalProductIDType'

=cut
       
sub setExternalProductID {
   my $self   = shift;
   my $pExternalProductID = shift;
   $self->getRequestDataType()->setExternalProductID($pExternalProductID);
}

=head2 setFreeShipping()

If true, only items with free shipping for the user's location are
returned. The user's location is determined from the site ID specified
in the request. If false, no filtering is done via this attribute. A
listing is not considered a free shipping listing if it requires
insurance or requires pick up or requires a shipping surcharge.

Default: false

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setFreeShipping {
   my $self   = shift;
   my $sFreeShipping = shift;
   $self->getRequestDataType()->setFreeShipping($sFreeShipping);
}

=head2 setGranularityLevel()

Optional tag that currently accepts only one value for this call: Coarse.
Other values return an error. If you specify Coarse, the call
returns the fields shown in the
<a href="#GranularityLevel">GranularityLevel table</a>
plus any tags resulting from the detail level you specify.
Controls the fields to return for each listing (not the set of
listings that match the query).

PresentDetails: Yes

  RequiredInput: No
#    Argument: 'ns:GranularityLevelCodeType'

=cut
       
sub setGranularityLevel {
   my $self   = shift;
   my $sGranularityLevel = shift;
   $self->getRequestDataType()->setGranularityLevel($sGranularityLevel);
}

=head2 setGroup()

You can group Best Match search results by category by specifying BestMatchCategoryGroup
in the Order field. When you specify BestMatchCategoryGroup
in the Order field, you can also specify Group.MaxEntriesPerGroup and/or Group.MaxGroups.
When you specify BestMatchCategoryGroup
in the Order field, there will be fewer results returned because Best Matches
in lower-level (leaf) categories and higher-level categories are taken into account.
There is not a direct correlation between the number of items returned in a regular sort (or in a BestMatch sort) and the number of items that are returned when you specify BestMatchCategoryGroup
in the Order field.
When you specify BestMatchCategoryGroup
in the Order field, not more than 2 pages of results are returned.
See also the GroupCategoryID element in ItemType.

  RequiredInput: No
#    Argument: 'ns:GroupType'

=cut
       
sub setGroup {
   my $self   = shift;
   my $pGroup = shift;
   $self->getRequestDataType()->setGroup($pGroup);
}

=head2 setIncludeCondition()

If true, each item in the result set can also
include the item condition (e.g., New or Used) in the
ItemSpecific property of the response. An item only includes
the condition in the response if the seller filled in the
Item Condition in the Item Specifics section of the listing.
(That is, the condition is not returned if the seller
only put the word "New" in the listing's title.) <br>
<br>
Controls the details to return for each listing (not the set of
listings that match the query). <br>
<br>To control whether to retrieve only new or used items,
see ItemCondition (or SearchRequest).

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeCondition {
   my $self   = shift;
   my $sIncludeCondition = shift;
   $self->getRequestDataType()->setIncludeCondition($sIncludeCondition);
}

=head2 setIncludeFeedback()

If true, each item in the result set also includes information about the
seller's feedback. Controls the details to return for each listing (not
the set of listings that match the query).
<br>
For GetSearchResults, if set to true will also return the seller's User ID.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeFeedback {
   my $self   = shift;
   my $sIncludeFeedback = shift;
   $self->getRequestDataType()->setIncludeFeedback($sIncludeFeedback);
}

=head2 setIncludeGetItFastItems()

When passed with a value of true, limits the results to Get It Fast listings.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeGetItFastItems {
   my $self   = shift;
   my $sIncludeGetItFastItems = shift;
   $self->getRequestDataType()->setIncludeGetItFastItems($sIncludeGetItFastItems);
}

=head2 setItemCondition()

Limits the results to new or used items, plus items that have no
condition specified.<br>
<br>
Matches the new or used condition that the seller specified
in the Item Specifics section of the listing.
(That is, this won't specifically match on items where the seller
only put the word "New" in the listing's title.)<br>
<br>
Only applicable to sites and categories that support a
sitewide (global) item condition. For example, the US site
does not currently support this. See GetCategory2CS.
To search for the item condition on the US site,
use a product finder instead (see SearchRequest).

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ItemCondition
Title: Specifying an Item's Condition
, URL: GetSearchResults.html#Request.SearchRequest
Title: (GetSearchResults) SearchRequest
, URL: GetSearchResults.html#Request.IncludeCondition
Title: (GetSearchResults) IncludeCondition


  RequiredInput: No
#    Argument: 'ns:ItemConditionCodeType'

=cut
       
sub setItemCondition {
   my $self   = shift;
   my $sItemCondition = shift;
   $self->getRequestDataType()->setItemCondition($sItemCondition);
}

=head2 setItemTypeFilter()

Filters items based on the ListingType set for the items.
If ItemTypeFilter is not
specified (or if the AllItemTypes value of ItemTypeFilter is specified),
all listing types can be returned unless another relevant filter is
specified. You cannot use GetSearchResults to search eBay Express.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SearchingByListingType
Title: Searching By Listing Type

  RequiredInput: No
  Default: AllItems
#    Argument: 'ns:ItemTypeFilterCodeType'

=cut
       
sub setItemTypeFilter {
   my $self   = shift;
   my $sItemTypeFilter = shift;
   $self->getRequestDataType()->setItemTypeFilter($sItemTypeFilter);
}

=head2 setLocalSearchPostalCode()

Include local items in returning results near this postal code. This
postal code is the basis for local search.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setLocalSearchPostalCode {
   my $self   = shift;
   my $sLocalSearchPostalCode = shift;
   $self->getRequestDataType()->setLocalSearchPostalCode($sLocalSearchPostalCode);
}

=head2 setLot()

Limits the results to only those listings for which Item.LotSize is 2 or greater.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setLot {
   my $self   = shift;
   my $sLot = shift;
   $self->getRequestDataType()->setLot($sLot);
}

=head2 setMaxRelatedSearchKeywords()

The maximum number of related keywords to be retrieved.
Use this field if you want the search results to include
recommended keywords (that is, keywords matching one or more of the
original keywords) in a RelatedSearchKeywordArray container.
A value of 0 (the default) means no related search information is processed.

Max: 100
Min: 0

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setMaxRelatedSearchKeywords {
   my $self   = shift;
   my $sMaxRelatedSearchKeywords = shift;
   $self->getRequestDataType()->setMaxRelatedSearchKeywords($sMaxRelatedSearchKeywords);
}

=head2 setModTimeFrom()

Limits the results to active items whose status has changed
since the specified time. Specify a time in the past.
Time must be in GMT. Cannot be used with the EndTime filters.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut
       
sub setModTimeFrom {
   my $self   = shift;
   my $sModTimeFrom = shift;
   $self->getRequestDataType()->setModTimeFrom($sModTimeFrom);
}

=head2 setMotorsGermanySearchable()

Limits the results based on each item's eligibility to appear on the
mobile.de site. If false, excludes eligible items from search results. If
true, queries for eligible items only. If not specified, the search
results are not affected. Only applicable for items listed on the eBay
Germany site (site ID 77) in subcategories of mobile.de search-enabled
categories.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setMotorsGermanySearchable {
   my $self   = shift;
   my $sMotorsGermanySearchable = shift;
   $self->getRequestDataType()->setMotorsGermanySearchable($sMotorsGermanySearchable);
}

=head2 setOrder()

Specifies the order in which listings are returned in a result set.
Listings may be sorted by end time, start time, and in other ways listed
in the SearchSortOrderCodeType. Controls the way the listings are
organized in the response (not the details to return for each listing).
For most sites, the default sort order is by items ending soonest. Store
Inventory listings are usually returned after other listing types,
regardless of the sort order.

Default: BestMatchSort

  RequiredInput: No
#    Argument: 'ns:SearchSortOrderCodeType'

=cut
       
sub setOrder {
   my $self   = shift;
   my $sOrder = shift;
   $self->getRequestDataType()->setOrder($sOrder);
}

=head2 setPagination()

Controls the pagination of the result set. Child elements specify the
maximum number of item listings to return per call and which page of data
to return. Controls the way the listings are organized in the response
(not the details to return for each listing).

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=PaginatingSearchResults
Title: Paginating Search Results

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut
       
sub setPagination {
   my $self   = shift;
   my $pPagination = shift;
   $self->getRequestDataType()->setPagination($pPagination);
}

=head2 setPaymentMethod()

Limits the results to items that accept a specific payment method or methods.

  RequiredInput: No
#    Argument: 'ns:PaymentMethodSearchCodeType'

=cut
       
sub setPaymentMethod {
   my $self   = shift;
   my $sPaymentMethod = shift;
   $self->getRequestDataType()->setPaymentMethod($sPaymentMethod);
}

=head2 setPriceRangeFilter()

Limits the result set to just those items where the price is within the
specified range. The PriceRangeFilterType includes a minimum and a maximum
price.

  RequiredInput: No
#    Argument: 'ns:PriceRangeFilterType'

=cut
       
sub setPriceRangeFilter {
   my $self   = shift;
   my $pPriceRangeFilter = shift;
   $self->getRequestDataType()->setPriceRangeFilter($pPriceRangeFilter);
}

=head2 setProductID()

An exclusive query to retrieve items that were listed with the specified
eBay catalog product. You must pass ProductID, Query, ExternalProductID,
or CategoryID in the request. If you use ProductID, do not use Query,
ExternalProductID, or CategoryID.<br>
<br>
As of mid-2008, some sites (such as eBay US, Germany, Austria, and Switzerland) are
updating, replacing, deleting, or merging some products (as a result of migrating from one
catalog data provider to another).
If you specify one of these products, the call may return a warning,
or it may return an error if the product has been deleted.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SearchingByProductID
Title: Searching for Listings by ProductID

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setProductID {
   my $self   = shift;
   my $sProductID = shift;
   $self->getRequestDataType()->setProductID($sProductID);
}

=head2 setProximitySearch()

Limits the result set to just those items whose location is within a
specified distance of a postal code. The ProximitySearchType includes
a maximum distance and a postal code.

  RequiredInput: No
#    Argument: 'ns:ProximitySearchType'

=cut
       
sub setProximitySearch {
   my $self   = shift;
   my $pProximitySearch = shift;
   $self->getRequestDataType()->setProximitySearch($pProximitySearch);
}

=head2 setQuantity()

Limits the results to listings that offer a certain number of items
matching the query. If Lot is also specified, then Quantity is the number
of lots multiplied by the number of objects in each lot. Use
QuantityOperator to specify that you are seeking listings with quantities
greater than, equal to, or less than Quantity.

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setQuantity {
   my $self   = shift;
   my $sQuantity = shift;
   $self->getRequestDataType()->setQuantity($sQuantity);
}

=head2 setQuantityOperator()

Limits the results to listings with quantities greater than, equal to, or
less than Quantity. Controls the set of listings to return (not the
details to return for each listing).

  RequiredInput: No
#    Argument: 'ns:QuantityOperatorCodeType'

=cut
       
sub setQuantityOperator {
   my $self   = shift;
   my $sQuantityOperator = shift;
   $self->getRequestDataType()->setQuantityOperator($sQuantityOperator);
}

=head2 setQuery()

A query that specifies a search string. The search string consists of one or more
keywords to search for in the listing title and/or description.
The words "and" and "or" are treated like any other word. Only use "and",
"or", or "the" if you are searching for listings containing these words.
You can use AND or OR logic by including certain modifiers.
Wildcards (e.g., *) are also supported. Be careful when using spaces before
or after modifiers and wildcards (+, -, or *). See the
eBay Web Services Guide	for a list of valid modifiers and examples.
Query is not applicable in combination with ExternalProductID or ProductID.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SearchingByKeywords
Title: Searching by Keywords
MaxLength: 350 (characters)

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setQuery {
   my $self   = shift;
   my $sQuery = shift;
   $self->getRequestDataType()->setQuery($sQuery);
}

=head2 setSearchFlags()

Secondary search criterion that checks item descriptions for keywords that
match the query, limits the search results to only charity items, limits
the result set to those items with PayPal as a payment method, and/or
provides other criteria to refine the search.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'ns:SearchFlagsCodeType'

=cut
       
sub setSearchFlags {
   my $self   = shift;
   my $sSearchFlags = shift;
   $self->getRequestDataType()->setSearchFlags($sSearchFlags);
}

=head2 setSearchLocationFilter()

Limits the result set to just those items that meet location criteria:
listed in a specified eBay site, location where the seller has the item,
location from which the user is searching, and/or items listed with a
specified currency. You cannot use GetSearchResults to search eBay Express.

  RequiredInput: No
#    Argument: 'ns:SearchLocationFilterType'

=cut
       
sub setSearchLocationFilter {
   my $self   = shift;
   my $pSearchLocationFilter = shift;
   $self->getRequestDataType()->setSearchLocationFilter($pSearchLocationFilter);
}

=head2 setSearchRequest()

A query consisting of a set of attributes (Item Specifics). Use this kind
of query to search against the Item Specifics in listings (e.g., to search
for a particular shoe size). If the query includes multiple attributes,
the search engine will apply "AND" logic to the query and narrow the
results. Use GetProductFinder to determine the list of valid attributes
and how many are permitted for the specified characteristic set. Retrieves
items along with any buying guide details that are associated with the
specified product finder. Applicable in combination with the Query
argument. Cannot be used in combination with ProductID or
ExternalProductID.<br>
<br>
If you are searching for tickets, see TicketFinder instead.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SearchingByItemSpecifics
Title: Searching by Item Specifics (Buy-Side Product Finder)
, URL: CallName.html#Request.TicketFinder
Title: (GetSearchResults) TicketFinder


  RequiredInput: No
#    Argument: 'ns:SearchRequestType'

=cut
       
sub setSearchRequest {
   my $self   = shift;
   my $pSearchRequest = shift;
   $self->getRequestDataType()->setSearchRequest($pSearchRequest);
}

=head2 setSearchType()

Limits the listings in the result set based on whether they are in the
Gallery. The choices are items in the Gallery or Gallery and non-Gallery
items.

  RequiredInput: No
#    Argument: 'ns:SearchTypeCodeType'

=cut
       
sub setSearchType {
   my $self   = shift;
   my $sSearchType = shift;
   $self->getRequestDataType()->setSearchType($sSearchType);
}

=head2 setSellerBusinessType()

Limits the results to those of a particular seller business type such as
commercial or private.

  RequiredInput: No
#    Argument: 'ns:SellerBusinessCodeType'

=cut
       
sub setSellerBusinessType {
   my $self   = shift;
   my $sSellerBusinessType = shift;
   $self->getRequestDataType()->setSellerBusinessType($sSellerBusinessType);
}

=head2 setStoreSearchFilter()

Limits the result set to just those items that meet criteria related to
eBay Stores sellers and eBay Stores. Use this to retrieve items listed in
a particular seller's eBay Store or in all store sellers' eBay Stores.
This filter always causes item description text to be searched with the
string specified in the Query field. That is, StoreSearchFilter
forces the type of search that would have occurred if you had specified
SearchInDescription in the SearchFlags field.

  RequiredInput: No
#    Argument: 'ns:SearchStoreFilterType'

=cut
       
sub setStoreSearchFilter {
   my $self   = shift;
   my $pStoreSearchFilter = shift;
   $self->getRequestDataType()->setStoreSearchFilter($pStoreSearchFilter);
}

=head2 setTicketFinder()

Searches for event ticket listings only. If specified, this cannot be empty.
For example, to search for all tickets (with no event, date, city, or quantity constraints),
specify EventType with a value of Any.
If specified, Query is optional. Query is useful when the user wants to search
for a particular event name (like "eric clapton") or a venue that might be
included in the listing title.
If TicketFinder and SearchRequest are both specified in the same request,
SearchRequest is ignored.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=TicketFinder
Title: Performing a Simple Ticket Finder Search

  RequiredInput: No
#    Argument: 'ns:TicketDetailsType'

=cut
       
sub setTicketFinder {
   my $self   = shift;
   my $pTicketFinder = shift;
   $self->getRequestDataType()->setTicketFinder($pTicketFinder);
}

=head2 setTotalOnly()

Retrieves the total quantity of matching items, without returning the item
data. See PaginationResult.TotalNumberOfEntries in the response. If
TotalOnly and Categories.CategoriesOnly are both specified in the request
and their values are inconsistent with each other, TotalOnly overrides
Categories.CategoriesOnly. That is, if TotalOnly is true and
Categories.CategoriesOnly is false, the results include matching
categories but no item data or buying guides. If TotalOnly is false and
Categories.CategoriesOnly is true, the results include matching
categories, item data, and buying guides. If TotalOnly is not specified,
it has no logical effect.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setTotalOnly {
   my $self   = shift;
   my $sTotalOnly = shift;
   $self->getRequestDataType()->setTotalOnly($sTotalOnly);
}

=head2 setUserIdFilter()

Limits the the result set to just those items listed by one or more
specified sellers or those items not listed by the one or more specified
sellers.

  RequiredInput: No
#    Argument: 'ns:UserIdFilterType'

=cut
       
sub setUserIdFilter {
   my $self   = shift;
   my $pUserIdFilter = shift;
   $self->getRequestDataType()->setUserIdFilter($pUserIdFilter);
}



#
# output properties
#

=head2 getAllCategoriesExpansionArray()

Can be returned if the request specifies that ExpandSearch is true.
Provides additional search results when a small result set would have
been returned with the original search. For example, on the US site (site
ID 0), if a search would normally result in fewer than 10 items, and
ExpandSearch is true, the search results are expanded to include (if
matching the query) the AllCategoriesExpansionArray container for items,
as well as other containers. The AllCategoriesExpansionArray container
contains items available if category filters are removed.

  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
#    Returns: 'ns:ExpansionArrayType'

=cut
       
sub getAllCategoriesExpansionArray {
   my $self = shift;
   return $self->getResponseDataType()->getAllCategoriesExpansionArray();
}

=head2 getBuyingGuideDetails()

Contains URLs and other information about relevant buying guides (if
any), as well as the site's buying guide hub. Unavailable in the Sandbox
environment. Buying guides are useful to buyers who do not have a
specific product in mind. For example, a digital camera buying guide
could help a buyer determine what kind of digital camera is right for
them. Only returned for product finder searches (using
SearchRequest.SearchAttributes) and for searches that retrieve matching
categories along with item data (using Categories.CategoriesOnly=false).

  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
#    Returns: 'ns:BuyingGuideDetailsType'

=cut
       
sub getBuyingGuideDetails {
   my $self = shift;
   return $self->getResponseDataType()->getBuyingGuideDetails();
}

=head2 getCategoryArray()

Shows the distribution of items across each category. 
Consists of statistical information about
categories that contain items that match
the query, if any. Returns empty if no matches are found or when the
Categories filter was not passed in the request. (For categories
associated with specific items, see items returned in each search
result.) 
You must use fields within the Categories input container
if you want the CategoryArray response container to be returned.

  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
           GranularityLevel: Coarse

#    Returns: 'ns:CategoryArrayType'

=cut
       
sub getCategoryArray {
   my $self = shift;
   return $self->getResponseDataType()->getCategoryArray();
}

=head2 getFilterRemovedExpansionArray()

Can be returned if the request specifies that ExpandSearch is true.
Provides additional search results when a small result set would have
been returned with the original search. For example, on the US site (site
ID 0), if a search would normally result in fewer than 10 items, and
ExpandSearch is true, the search results are expanded to include (if
matching the query) the FilterRemovedExpansionArray container for items,
as well as other containers. The FilterRemovedExpansionArray container
contains items that would be returned if filters such as PriceRangeFilter
are removed.

  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
#    Returns: 'ns:ExpansionArrayType'

=cut
       
sub getFilterRemovedExpansionArray {
   my $self = shift;
   return $self->getResponseDataType()->getFilterRemovedExpansionArray();
}

=head2 isHasMoreItems()

Indicates whether there are more items, not yet returned, that match the
search criteria.

  Returned: Always
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
           GranularityLevel: Coarse

#    Returns: 'xs:boolean'

=cut
       
sub isHasMoreItems {
   my $self = shift;
   return $self->getResponseDataType()->isHasMoreItems();
}

=head2 getInternationalExpansionArray()

Can be returned if the request specifies that ExpandSearch is true.
Provides additional search results when a small result set would have
been returned with the original search. For example, on the US site (site
ID 0), if a search would normally result in fewer than 10 items, and
ExpandSearch is true, the search results are expanded to include (if
matching the query) the InternationalExpansionArray container for items,
as well as other containers. The InternationalExpansionArray container
contains items available from international sellers.

  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
#    Returns: 'ns:ExpansionArrayType'

=cut
       
sub getInternationalExpansionArray {
   my $self = shift;
   return $self->getResponseDataType()->getInternationalExpansionArray();
}

=head2 getItemsPerPage()

Indicates the maximum number of items that can be returned in a
SearchResultItemArray for any given call.

  Returned: Always
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
           GranularityLevel: Coarse

#    Returns: 'xs:int'

=cut
       
sub getItemsPerPage {
   my $self = shift;
   return $self->getResponseDataType()->getItemsPerPage();
}

=head2 getPageNumber()

Indicates the page of data returned by the current call. For instance,
for the first set of items can be returned, this field has a value of
one.

  Returned: Always
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
           GranularityLevel: Coarse

#    Returns: 'xs:int'

=cut
       
sub getPageNumber {
   my $self = shift;
   return $self->getResponseDataType()->getPageNumber();
}

=head2 getPaginationResult()

Indicates the results of the pagination, including the total number of
pages of data that can be returned and the total number of items that can
be returned.

  Returned: Always
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
           GranularityLevel: Coarse

#    Returns: 'ns:PaginationResultType'

=cut
       
sub getPaginationResult {
   my $self = shift;
   return $self->getResponseDataType()->getPaginationResult();
}

=head2 getRelatedSearchKeywordArray()

Container for keywords related to the original keywords in the request.
Can be returned if the request specified more than zero in the MaxRelatedSearchKeywords field.

  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
#    Returns: 'ns:RelatedSearchKeywordArrayType'

=cut
       
sub getRelatedSearchKeywordArray {
   my $self = shift;
   return $self->getResponseDataType()->getRelatedSearchKeywordArray();
}

=head2 getSearchResultItemArray()

Contains the returned item listings, if any. The data for each listing is
returned in an ItemType object.

  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
           GranularityLevel: Coarse

#    Returns: 'ns:SearchResultItemArrayType'

=cut
       
sub getSearchResultItemArray {
   my $self = shift;
   return $self->getResponseDataType()->getSearchResultItemArray();
}

=head2 getSpellingSuggestion()

Suggestion for a different spelling of the search term or terms, along
with the number of matching items that would have been returned if the
suggestions had been used. The suggestions are given in Text tags and the
suggestion for the first word is given before the suggestion for
subsequent words. Suggestions are based on correctly-spelled terms in
items, so suggestions vary over time and depend on whether a word or word
combination is in one or more items.

  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
#    Returns: 'ns:SpellingSuggestionType'

=cut
       
sub getSpellingSuggestion {
   my $self = shift;
   return $self->getResponseDataType()->getSpellingSuggestion();
}

=head2 getStoreExpansionArray()

Contains items listed in the Store Inventory Format,
if the request specifies that ExpandSearch is true.

  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories, ItemReturnAttributes, ReturnAll, none
#    Returns: 'ns:ExpansionArrayType'

=cut
       
sub getStoreExpansionArray {
   my $self = shift;
   return $self->getResponseDataType()->getStoreExpansionArray();
}





1;   
