use Test::More;

use Crypt::Format;

plan tests => 1;

my $weird = <<END;
-----BEGIN CERTIFICATE-----
MIIFTjCCBDagAwIBAgIRAJj88Oe9epkCKrF9pCHm0XkwDQYJKoZIhvcNAQELBQAwgZAxCzAJBgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcTB1NhbGZvcmQxGjAYBgNVBAoTEUNPTU9ETyBDQSBMaW1pdGVkMTYwNAYDVQQDEy1DT01PRE8gUlNBIERvbWFpbiBWYWxpZGF0aW9uIFNlY3VyZSBTZXJ2ZXIgQ0EwHhcNMTYwMTE0MDAwMDAwWhcNMTcwMTEzMjM1OTU5WjBRMSEwHwYDVQQLExhEb21haW4gQ29udHJvbCBWYWxpZGF0ZWQxEzARBgNVBAsTCkNPTU9ETyBTU0wxFzAVBgNVBAMTDmZleS5jcGFuZWwubmV0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6WdUTld665uTA1il1pxoUVXsALo+YktNcf6wDdWnpegW02vkdun5Mvjln/eFz/2VTltzISRCzAAuqwrGpOHFhiZ2r07IbOW7uPE3ypS/gKSGFZuHlifV0Q6CEUBHWHIMO5puadhTRsELmaMYTcIzzMScazUBubvnCWOa6e/FIYljxLi1L5rV0yixcXu8Bb5VdAfRGo3Y0rRdIYb/Tr3ke0jLrWEGioUDJ5e9jack1o5UVWqI7VFVp353iYnSDaGCTJNEyXIWW6uavZSa7nAF8pcSLoxoxcPhEImRDFdXiRBRz/ahuXLMI9tp3WRE/dcDsTlZcKVVuNJTTFYkm945mwIDAQABo4IB3zCCAdswHwYDVR0jBBgwFoAUkK9qOpRaC9iQ6hJWc99DtDoo2ucwHQYDVR0OBBYEFLLNUzsdcRbcSMedxkcnex3FQ01ZMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjBPBgNVHSAESDBGMDoGCysGAQQBsjEBAgIHMCswKQYIKwYBBQUHAgEWHWh0dHBzOi8vc2VjdXJlLmNvbW9kby5jb20vQ1BTMAgGBmeBDAECATBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vY3JsLmNvbW9kb2NhLmNvbS9DT01PRE9SU0FEb21haW5WYWxpZGF0aW9uU2VjdXJlU2VydmVyQ0EuY3JsMIGFBggrBgEFBQcBAQR5MHcwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9jcnQuY29tb2RvY2EuY29tL0NPTU9ET1JTQURvbWFpblZhbGlkYXRpb25TZWN1cmVTZXJ2ZXJDQS5jcnQwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmNvbW9kb2NhLmNvbTAtBgNVHREEJjAkgg5mZXkuY3BhbmVsLm5ldIISd3d3LmZleS5jcGFuZWwubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBDxr9RJw3Db2ySiuF7+ZB+lZibXbMDQ5ozDVAYdb756Zw/9MRHxte6sItHqenJ4EJK2xXfBd8tltdMe1ziQYFOaJccWwU1KoEzrlNSqhMGL540Djzf6n8x1utGiLoszXHXKeK9JPWiMRJxxXIANAZJXH+pDZhR300b6DKRWZWMB2ZcF3VuS7rsdtE6bwUsv1cg+P4XJsltPZjItuPWHnKIbIv6O2rl189qMqfSkrc+Eo+lohVrRLCW1c1E3+tsaiPjioggRKsc73lB795HK2gmb4IdhSMLW+kuQSdR15GEveRV5m/if+BzlwsKTWma7gii77h51HPWf2yuzm1Rp016
-----END CERTIFICATE-----
END

my $normalized = Crypt::Format::normalize_pem($weird);

my $max = 76;

ok(
    !(grep { length > $max } split m<\x0a>, $normalized),
    "no line longer than $max chars",
) or diag $normalized;
