## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::dataquota;

our $DATE = '2024-08-03'; # DATE
our $VERSION = '0.010'; # VERSION

our $rschema = do{my$var={base=>"dataspeed",clsets_after_base=>[{examples=>[{valid=>1,validated_value=>128000,value=>"1000kbps"},{valid=>1,validated_value=>327680,value=>"2.5 mbit"},{valid=>1,validated_value=>131072,value=>"128KB/s"},{valid=>1,validated_value=>131072,value=>"128K/s"},{valid=>1,validated_value=>131072,value=>"128K"},{valid=>0,value=>"1zzz"}],summary=>"Data transfer quota"}],clsets_after_type=>[{description=>"\nFloat, in bytes/second.\n\nCan be coerced from string that contains units, e.g.:\n\n    1000kbps -> 128000 (kilobits per second, 1024-based)\n    2.5 mbit -> 327680 (megabit per second, 1024-based)\n    128KB/s  -> 131072 (kilobyte per second, 1024-based)\n\n",examples=>[{valid=>1,validated_value=>128000,value=>"1000kbps"},{valid=>1,validated_value=>327680,value=>"2.5 mbit"},{valid=>1,validated_value=>131072,value=>"128KB/s"},{valid=>1,validated_value=>131072,value=>"128K/s"},{valid=>1,validated_value=>131072,value=>"128K"},{valid=>0,value=>"1zzz"}],min=>0,summary=>"Data transfer speed","x.perl.coerce_rules"=>["From_str::suffix_dataspeed"]},'$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_type}[0]','$var->{clsets_after_base}[0]'],resolve_path=>["float","dataspeed"],type=>"float",v=>2};$var->{clsets_after_type}[1]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_type}[0];$var->{"clsets_after_type.alt.merge.merged"}[1]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Data transfer quota

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::dataquota - Data transfer quota

=head1 VERSION

This document describes version 0.010 of Sah::SchemaR::dataquota (from Perl distribution Sah-SchemaBundle-DataSizeSpeed), released on 2024-08-03.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::SchemaBundle during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-SchemaBundle-DataSizeSpeed>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-SchemaBundle-DataSizeSpeed>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2020, 2019 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-SchemaBundle-DataSizeSpeed>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
