#!/usr/bin/perl

package eBay::API::XML::DataType::FeedbackSummaryType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. FeedbackSummaryType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::FeedbackSummaryType

=head1 DESCRIPTION

Specifies all feedback summary information (except Score). Contains
FeedbackPeriodArrayType objects that each convey feedback counts for
positive, negative, neutral, and total feedback counts - for various
time periods each. Also conveys counts of bid retractions for the
predefined time periods.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::FeedbackSummaryType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::BuyerRoleMetricsType;
use eBay::API::XML::DataType::FeedbackPeriodArrayType;
use eBay::API::XML::DataType::SellerRatingSummaryArrayType;
use eBay::API::XML::DataType::SellerRoleMetricsType;


my @gaProperties = ( [ 'BidRetractionFeedbackPeriodArray', 'ns:FeedbackPeriodArrayType', ''
	     ,'eBay::API::XML::DataType::FeedbackPeriodArrayType', '1' ]
	, [ 'BuyerRoleMetrics', 'ns:BuyerRoleMetricsType', ''
	     ,'eBay::API::XML::DataType::BuyerRoleMetricsType', '1' ]
	, [ 'NegativeFeedbackPeriodArray', 'ns:FeedbackPeriodArrayType', ''
	     ,'eBay::API::XML::DataType::FeedbackPeriodArrayType', '1' ]
	, [ 'NeutralCommentCountFromSuspendedUsers', 'xs:int', '', '', '' ]
	, [ 'NeutralFeedbackPeriodArray', 'ns:FeedbackPeriodArrayType', ''
	     ,'eBay::API::XML::DataType::FeedbackPeriodArrayType', '1' ]
	, [ 'PositiveFeedbackPeriodArray', 'ns:FeedbackPeriodArrayType', ''
	     ,'eBay::API::XML::DataType::FeedbackPeriodArrayType', '1' ]
	, [ 'SellerRatingSummaryArray', 'ns:SellerRatingSummaryArrayType', ''
	     ,'eBay::API::XML::DataType::SellerRatingSummaryArrayType', '1' ]
	, [ 'SellerRoleMetrics', 'ns:SellerRoleMetricsType', ''
	     ,'eBay::API::XML::DataType::SellerRoleMetricsType', '1' ]
	, [ 'TotalFeedbackPeriodArray', 'ns:FeedbackPeriodArrayType', ''
	     ,'eBay::API::XML::DataType::FeedbackPeriodArrayType', '1' ]
	, [ 'UniqueNegativeFeedbackCount', 'xs:int', '', '', '' ]
	, [ 'UniqueNeutralFeedbackCount', 'xs:int', '', '', '' ]
	, [ 'UniquePositiveFeedbackCount', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBidRetractionFeedbackPeriodArray()

Bid retractions count, for multiple predefined time periods preceding
the call. Returned if no detail level is specified.

#    Argument: 'ns:FeedbackPeriodArrayType'

=cut

sub setBidRetractionFeedbackPeriodArray {
  my $self = shift;
  $self->{'BidRetractionFeedbackPeriodArray'} = shift
}

=head2 getBidRetractionFeedbackPeriodArray()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:FeedbackPeriodArrayType'

=cut

sub getBidRetractionFeedbackPeriodArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BidRetractionFeedbackPeriodArray'
		,'eBay::API::XML::DataType::FeedbackPeriodArrayType');
}


=head2 setBuyerRoleMetrics()

Container for information about 1 year feedback metric as buyer.

#    Argument: 'ns:BuyerRoleMetricsType'

=cut

sub setBuyerRoleMetrics {
  my $self = shift;
  $self->{'BuyerRoleMetrics'} = shift
}

=head2 getBuyerRoleMetrics()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:BuyerRoleMetricsType'

=cut

sub getBuyerRoleMetrics {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BuyerRoleMetrics'
		,'eBay::API::XML::DataType::BuyerRoleMetricsType');
}


=head2 setNegativeFeedbackPeriodArray()

Negative feedback entries count, for multiple predefined time periods preceding
the call. Returned if no detail level is specified.

#    Argument: 'ns:FeedbackPeriodArrayType'

=cut

sub setNegativeFeedbackPeriodArray {
  my $self = shift;
  $self->{'NegativeFeedbackPeriodArray'} = shift
}

=head2 getNegativeFeedbackPeriodArray()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:FeedbackPeriodArrayType'

=cut

sub getNegativeFeedbackPeriodArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'NegativeFeedbackPeriodArray'
		,'eBay::API::XML::DataType::FeedbackPeriodArrayType');
}


=head2 setNeutralCommentCountFromSuspendedUsers()

Number of neutral comments received from suspended users. Returned if no
detail level is specified.

#    Argument: 'xs:int'

=cut

sub setNeutralCommentCountFromSuspendedUsers {
  my $self = shift;
  $self->{'NeutralCommentCountFromSuspendedUsers'} = shift
}

=head2 getNeutralCommentCountFromSuspendedUsers()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getNeutralCommentCountFromSuspendedUsers {
  my $self = shift;
  return $self->{'NeutralCommentCountFromSuspendedUsers'};
}


=head2 setNeutralFeedbackPeriodArray()

Neutral feedback entries count, for multiple predefined time periods preceding
the call. Returned if no detail level is specified.

#    Argument: 'ns:FeedbackPeriodArrayType'

=cut

sub setNeutralFeedbackPeriodArray {
  my $self = shift;
  $self->{'NeutralFeedbackPeriodArray'} = shift
}

=head2 getNeutralFeedbackPeriodArray()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:FeedbackPeriodArrayType'

=cut

sub getNeutralFeedbackPeriodArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'NeutralFeedbackPeriodArray'
		,'eBay::API::XML::DataType::FeedbackPeriodArrayType');
}


=head2 setPositiveFeedbackPeriodArray()

Positive feedback entries count, for multiple predefined time periods
preceding the call. Returned if no detail level is specified.

#    Argument: 'ns:FeedbackPeriodArrayType'

=cut

sub setPositiveFeedbackPeriodArray {
  my $self = shift;
  $self->{'PositiveFeedbackPeriodArray'} = shift
}

=head2 getPositiveFeedbackPeriodArray()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:FeedbackPeriodArrayType'

=cut

sub getPositiveFeedbackPeriodArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PositiveFeedbackPeriodArray'
		,'eBay::API::XML::DataType::FeedbackPeriodArrayType');
}


=head2 setSellerRatingSummaryArray()

Container for information about detailed seller ratings (DSRs)
that buyers have left for a seller.
Sellers have access to the number of ratings they've received, as well as
to the averages of DSRs they've received in each
DSR area (i.e., to the average of ratings in the item-description area, etc.).
The DSR feature is available on the United Kingdom site
and on the following other sites: AU (site ID 15), BEFR (site ID 23),
BENL (site ID 123), FR (site ID 71), IE (site ID 205), IN (site ID 203),
IT (site ID 101), and PL (site ID 212). The DSR feature is available on the other
API-enabled country sites, including the US site (site ID 0).

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=DetailedSellerRatings
Title: Detailed Seller Ratings

#    Argument: 'ns:SellerRatingSummaryArrayType'

=cut

sub setSellerRatingSummaryArray {
  my $self = shift;
  $self->{'SellerRatingSummaryArray'} = shift
}

=head2 getSellerRatingSummaryArray()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:SellerRatingSummaryArrayType'

=cut

sub getSellerRatingSummaryArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerRatingSummaryArray'
		,'eBay::API::XML::DataType::SellerRatingSummaryArrayType');
}


=head2 setSellerRoleMetrics()

Container for information about 1 year feedback metric as seller.

#    Argument: 'ns:SellerRoleMetricsType'

=cut

sub setSellerRoleMetrics {
  my $self = shift;
  $self->{'SellerRoleMetrics'} = shift
}

=head2 getSellerRoleMetrics()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:SellerRoleMetricsType'

=cut

sub getSellerRoleMetrics {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerRoleMetrics'
		,'eBay::API::XML::DataType::SellerRoleMetricsType');
}


=head2 setTotalFeedbackPeriodArray()

Total feedback score, for multiple predefined time periods preceding the
call. Returned if no detail level is specified.

#    Argument: 'ns:FeedbackPeriodArrayType'

=cut

sub setTotalFeedbackPeriodArray {
  my $self = shift;
  $self->{'TotalFeedbackPeriodArray'} = shift
}

=head2 getTotalFeedbackPeriodArray()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:FeedbackPeriodArrayType'

=cut

sub getTotalFeedbackPeriodArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TotalFeedbackPeriodArray'
		,'eBay::API::XML::DataType::FeedbackPeriodArrayType');
}


=head2 setUniqueNegativeFeedbackCount()

Total number of negative Feedback comments, including weekly repeats. Returned if no detail level is specified.

#    Argument: 'xs:int'

=cut

sub setUniqueNegativeFeedbackCount {
  my $self = shift;
  $self->{'UniqueNegativeFeedbackCount'} = shift
}

=head2 getUniqueNegativeFeedbackCount()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getUniqueNegativeFeedbackCount {
  my $self = shift;
  return $self->{'UniqueNegativeFeedbackCount'};
}


=head2 setUniqueNeutralFeedbackCount()

Total number of neutral Feedback comments, including weekly repeats. Returned if no detail level is specified.

#    Argument: 'xs:int'

=cut

sub setUniqueNeutralFeedbackCount {
  my $self = shift;
  $self->{'UniqueNeutralFeedbackCount'} = shift
}

=head2 getUniqueNeutralFeedbackCount()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getUniqueNeutralFeedbackCount {
  my $self = shift;
  return $self->{'UniqueNeutralFeedbackCount'};
}


=head2 setUniquePositiveFeedbackCount()

Total number of positive Feedback comments, including weekly repeats. Returned if no detail level is specified.

#    Argument: 'xs:int'

=cut

sub setUniquePositiveFeedbackCount {
  my $self = shift;
  $self->{'UniquePositiveFeedbackCount'} = shift
}

=head2 getUniquePositiveFeedbackCount()

  Calls: GetFeedback
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getUniquePositiveFeedbackCount {
  my $self = shift;
  return $self->{'UniquePositiveFeedbackCount'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
