=begin
    
    File:	examples/ex_alpha.pl
	Author: Josiah Bryan, <jdb@wcoil.com>
	Desc: 

		This demonstrates the ability of a neural net to 
		generalize and predict what the correct result is 
		for inputs that it has never seen before.
		
		This teaches the network to classify some twenty-
		nine seperate 35-byte bitmaps, and then it inputs
		an never-before-seen bitmap and displays the 
		classification the network gives for the unknown bitmap.

=cut

	use AI::NeuralNet::Mesh;

	# Create a new network with 2 layers and 35 neurons in each layer, with 1 output neuron
	my $net = new AI::NeuralNet::Mesh(2,35,1);
	
	# Debug level of 4 gives JUST learn loop iteteration benchmark and comparrison data 
	# as learning progresses.
	$net->debug(4);

	my $letters = [            # All prototype inputs        
        [
        2,1,1,1,2,             # Inputs are   
        1,2,2,2,1,             #  5*7 digitalized caracters 
        1,2,2,2,1,              
        1,1,1,1,1,
        1,2,2,2,1,             # This is the alphabet of the
        1,2,2,2,1,             # HP 28S                      
        1,2,2,2,1,
        ],[0],[
        1,1,1,1,2,
        1,2,2,2,1,
        1,2,2,2,1,
        1,1,1,1,2,
        1,2,2,2,1,
        1,2,2,2,1,
        1,1,1,1,2,
        ],[1],[
        2,1,1,1,2,
        1,2,2,2,1,
        1,2,2,2,2,
        1,2,2,2,2,
        1,2,2,2,2,
        1,2,2,2,1,
        2,1,1,1,2,
        ],[2],[
        1,1,1,2,2,
        1,2,2,1,2,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,1,2,
        1,1,1,2,2,
        ],[4],[
        1,1,1,1,1,
        1,2,2,2,2,
        1,2,2,2,2,
        1,1,1,1,2,
        1,2,2,2,2,
        1,2,2,2,2,
        1,1,1,1,1,
        ],[5],[
        1,1,1,1,1,
        1,2,2,2,2,
        1,2,2,2,2,
        1,1,1,1,2,
        1,2,2,2,2,
        1,2,2,2,2,
        1,2,2,2,2,
		],[6],[
        2,1,1,1,2,
        1,2,2,2,1,
        1,2,2,2,2,
        1,2,2,2,2,
        1,2,2,1,1,
        1,2,2,2,1,
        2,1,1,1,2,
		],[7],[
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,1,1,1,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
		],[8],[
        1,1,1,1,1,
        2,1,1,1,2,
        2,1,1,1,2,
        2,1,1,1,2,
        2,1,1,1,2,
        2,1,1,1,2,
        1,1,1,1,1,
		],[9],[
        2,2,2,2,1,
        2,2,2,2,1,
        2,2,2,2,1,
        2,2,2,2,1,
        2,2,2,2,1,
        1,2,2,2,1,
        2,1,1,1,2,
		],[10],[
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,1,2,
        1,1,1,2,2,
        1,2,2,1,2,
        1,2,2,2,1,
        1,2,2,2,1,
		],[11],[
        1,2,2,2,2,
        1,2,2,2,2,
        1,2,2,2,2,
        1,2,2,2,2,
        1,2,2,2,2,
        1,2,2,2,2,
        1,1,1,1,1,
		],[12],[
        1,2,2,2,1,
        1,1,2,1,1,
        1,2,1,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
		],[13],[
        1,2,2,2,1,
        1,2,2,2,1,
        1,1,2,2,1,
        1,2,1,2,1,
        1,2,2,1,1,
        1,2,2,2,1,
        1,2,2,2,1,
		],[14],[
        2,1,1,1,2,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        2,1,1,1,2,
		],[15],[
        1,1,1,1,2,
        1,2,2,2,1,
        1,2,2,2,1,
        1,1,1,1,2,
        1,2,2,2,2,
        1,2,2,2,2,
        1,2,2,2,2,
		],[16],[
        2,1,1,1,2,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,1,2,1,
        1,2,2,1,2,
        2,1,1,2,1,
		],[17],[
        1,1,1,1,2,
        1,2,2,2,1,
        1,2,2,2,1,
        1,1,1,1,2,
        1,2,1,2,2,
        1,2,2,1,2,
        1,2,2,2,1,
		],[18],[
        2,1,1,1,2,
        1,2,2,2,1,
        1,2,2,2,2,
        2,1,1,1,2,
        2,2,2,2,1,
        1,2,2,2,1,
        2,1,1,1,2,
		],[19],[
        1,1,1,1,1,
        2,2,1,2,2,
        2,2,1,2,2,
        2,2,1,2,2,
        2,2,1,2,2,
        2,2,1,2,2,
        2,2,1,2,2,
		],[20],[
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        2,1,1,1,2,
		],[21],[
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        2,1,2,1,2,
        2,2,1,2,2,
		],[22],[
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,1,2,1,
        1,2,1,2,1,
        1,1,2,1,1,
        1,2,2,2,1,
		],[23],[
        1,2,2,2,1,
        1,2,2,2,1,
        2,1,2,1,2,
        2,2,1,2,2,
        2,1,2,1,2,
        1,2,2,2,1,
        1,2,2,2,1,
		],[24],[
        1,2,2,2,1,
        1,2,2,2,1,
        2,1,2,1,2,
        2,2,1,2,2,
        2,2,1,2,2,
        2,2,1,2,2,
        2,2,1,2,2,
		],[25],[
        1,1,1,1,1,
        2,2,2,2,1,
        2,2,2,1,2,
        2,2,1,2,2,
        2,1,2,2,2,
        1,2,2,2,2,
        1,1,1,1,1,
		],[26],[
        2,2,1,2,2,
        2,1,1,1,2,
        2,1,2,1,2,
        1,1,2,1,1,
        1,1,1,1,1,
        1,1,2,1,1,
        1,2,2,2,1,
		],[27],[
        1,2,2,2,1,
        2,1,2,2,1,
        2,2,1,1,2,
        2,2,1,1,2,
        2,2,1,2,2,
        2,1,2,2,2,
        1,2,2,2,2,
		],[28],[
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,1,2,1,
        1,1,1,1,1,
        1,1,1,1,1,
        2,1,2,1,2,
        2,1,2,1,2,
        ],[29],[
        1,2,2,2,1,
        1,2,2,2,1,
        1,2,2,2,1,
        1,1,2,1,1,
        2,1,2,1,2,
        2,1,1,1,2,
        2,2,1,2,2
        ]
     ];
	
	if(!$net->load("letters.mesh")) {
		#$net->range(0..29);
		$net->learn_set($letters);
		$net->save("letters.mesh");
	}
			
	# Build a test map 
	my $tmp	=	[2,1,1,1,2,
				 1,2,2,2,1,
				 1,2,2,2,1,
				 1,1,1,1,1,
				 1,2,2,2,1,
				 1,2,2,2,1,
				 1,2,2,2,1];
	
	# Display test map
	print "\nTest map:\n";
	$net->join_cols($tmp,5);
	
	# Display network results
	print "Letter index matched: ",$net->run($tmp)->[0],"\n";
	
