
use strict;
use warnings;
use Test::More;


use Crypt::NaCl::Sodium qw(:utils);

my $crypto_generichash = Crypt::NaCl::Sodium->generichash();

my (@k, @in);

ok($crypto_generichash->$_ > 0, "$_ > 0") for qw( BYTES BYTES_MIN BYTES_MAX KEYBYTES KEYBYTES_MIN KEYBYTES_MAX );

my $bytes_min = $crypto_generichash->BYTES_MIN;
my $bytes_max = $crypto_generichash->BYTES_MAX;
my $keybytes_max = $crypto_generichash->KEYBYTES_MAX;

for ( 0 .. $bytes_max - 1 ) {
    $in[$_] = chr($_);
}
for ( 0 .. $keybytes_max - 1 ) {
    $k[$_] = chr($_);
}

my $key = join('', @k);
my $msg = join('', @in);

my @tests = getTestData();

for my $bytes ( $bytes_min - 1 .. $bytes_max + 1) {
    my $i = $bytes - 1;

    if ( $bytes < $bytes_min || $bytes > $bytes_max ) {
        eval {
            my $mac = $crypto_generichash->mac($msg,
                key => $key,
                bytes => $bytes
            );
        };
        like($@, qr/Invalid bytes value: $bytes/,
            "BYTES_MIN < bytes < BYTES_MAX is required, requested $bytes");
    } else {

        my $subkey = substr($key, 0, 1 + $i % $keybytes_max);
        my $submsg = substr($msg, 0, $i);
        my $mac = $crypto_generichash->mac($submsg,
            key => $subkey,
            bytes => $bytes
        );

        is(bin2hex($mac), $tests[$i], "correct mac for $bytes bytes");
    }
}

my $mac = $crypto_generichash->mac($msg,
    bytes => $bytes_max
);
is(bin2hex($mac), $tests[65], "correct mac without key");


done_testing();

sub getTestData {
    return qw(
05
5d8c
22221b
d4974470
be8492fb36
edc178279907
26848f2ae0c2e6
045cf1235112b9f6
5110bad569356dfa6c
1339d95145bc8a33d3aa
3dbb39b4d57c5566808a88
22378260939cee01022686a2
e18b37abcead6cc520e6504dac
3cbb356604cf862e62ad2f534323
44c41ba227b191961b475ec5875057
0c7c9c3922d41a7b2b3b20f92685d560
8508c01d19709bdd881866aa1f8c63ca06
f6b2dddfbece6d7d52e114c7e5a97772e18d
d36b5af9591d0cd3747254e26bc6e1de5b6081
f7f7ce69149418d7ec33327bd86e14bcca4b8ed7
2c9aba9a56de21165753c4f3cee9310a9c8fe546b9
ee5e08cee5fbbcb51900341bb30db6695920faecda6a
fe9ffb56dc5716b91bc7d77ce7b05e7cc39c31683bec91
c500ae0f5bff0f1106ce104ae9c291add7207e0d8ebcb1ed
68e23d12000b387158afd6458d3bcef9c26936ca68b5c0f3d6
220efa2c09f67dbb02aa623bbc0cb92107a30f53b633e78d4b44
54df984b47e4bcd489d9c045c488743fac91c9b3e0cbcc37495fac
b4852cf66c6ce164c002bbb62ded0faeb4a39c39fdffb372ff14dd31
d79cafb5565e7775616e1c9b09100d61fb71efaf25affcf2d480d2c980
ae557883145e374adef583ba0550429d5cdd86b254c33bf52d02e070efda
9f53d28c0df7b327c2eb4c8a12c742829225b7f30fda7baf64135098fdb01b
a9f51bb7f6a3e9cdb96ce652c07d177962a348a9cced1b92f948187e59b44463
f2960cf5fd57fc92f549cd5a2803147964f60e7703e1b8897c088cded74c7bd39f
89981acbb690eb03ed2a67510d1d85a1b4f9d496fdfe134550ae14146bb05fd5fedd
6d8245383fd7c418b46511339e711b9d4a0d1f5fdf6de45fdd3d0664164b7bf878a124
1f0b6b083d524e0741710ddef499ce88f51083bb3ad80a1815cc57acf006436e9b6ad72b
fc35bfe34c915020bb8b44fa0a19933774eaaf61919780fd55564e085bc31646dfc1d426e9
117d58f1f8cb2c036102686035975be90550795e5a0e3469a8f7a2cba9bc88961852b18c8ae3
c679c950818729c799bb7f39cef2d89fa80a147817f379a073ef1ccafea5d369815c70373bf5be
d487ad2143024ee8c645a066c035b74abe3a11f1c9fcd738b154b8ca37134d74fb78c40d1a2274cf
2d3ee00828b0ccea6812b40f214fab6d4f23f7e74ae228115bcb208ced2d5e1cb9cdff41de912af7a8
a697b26d4c4475e312288b98ae2ec4954d3c74c8e144c0ab518616ff9f52918a946fd765af75e761178c
f647bcba2a711f431d6d453aa7d75dcf5bb9ab6f8b83f89117230f633e7580f27c71c4f4c211cadd04f587
1fc1d6a4db753e2f4fd1456b2b709dd70ad58547eeda9d5a55762b5cd4097a7a1bd73cc633ec27168ee65631
1cfe0f63ab155379b4a1b5bf694a33635097b8e4b6dbd3b983d62454d36d7bf4550bece301abdd27b2dd76ca9f
73dee8a0a558e7b6f6eefe411280e253b05ef006d499849fea5d6a95f9141ee160322fff3a3f70e10c84025e02ce
edf9e706f4acae4f4bed72404f14458ba075d2b9d9a4a1ed46d1f1c5e23113a74cce9f7735432a922a3d8097f22c7a
95d5cd54c6722ac4335fa0ab38d388c9fd0baea48a9078605e400534ef38f13abb1d770da84b90b0256e1c1b64f54ba9
fe6b85ee8b5eb7da035264ed46e6dcd948571018d1f6976de4102fcb4bb5f1422e7df1b5aaa5b6b56c5961966db29ead6e
499ab83c01e4bf74ea5036392f9f810eae8a066fff49e316e4288baccb2001efa24f64cef7bfae70c90f139b198e53ad87f1
eac6c9d97264241a8adba22ee925438ed9787a547018608a10676a7594bc51c60294bd9159fbcada9022b44880a37c5b07c1b4
0771e3ae24bbfe424800d4bae776fef3da1607990019e7c4b30bc8140061ebf0b64aad7b018a878d579caa67154b98a04402735e
d569e5f5fe197387451441911a2be2effa606dad39820af44cea056bd9d1499dde41fa1c6c3a0459d5866c944bec2ac83328953726
68e523ded865c4d8318d61c312189a59597bbc3995e312e85137611af761a5f73508ac79e359edf729d4508830fc642b432f09185914
601af664ae596166707244adbb4f704593b355c6a659c844d853c6647fb265cdbcea26ed43657251dec37f2d6453fa0ace55f22d303cb0
703d8e552236b2090143444545f0a61a809d8ef9843bcf6883f61671fb31c8d6ac9fd373e7f9f79a0c72fa6a37dc655ba1fb01a5f41e36d1
03896f594afd1bf97acb862106eb05a1d8b54ec08d184812a79f4dc7b287a7486e60927b6c23e5f51fcbc94798648b28fd13438300567bec95
cc66a891768e95a2717b040c111996f14942f10f2475c33aa5f1c97476e6f8386733d6b21c16102d01ff1f715475f01099e1f19aa763238a38a9
007aac8eae29e5bf2be1b54857f5fe80c324424a3273b46e55482fbc4ae1033df4a97016b60c81a5344abd6366f56d8cee2c2e94619418293990de
50c81e92605a6111ea4c7c602acfb3945d4c2631c8c08fa4b594134577f5c2ffcca90d48604162cfdb2a0bb40416ff9134a275461b829ff1b875f995
661b7a1c70170aa7559aa82639fa65c1bdcfb5e336cb23b40a9edf5b4f6eeca1a176a9844da705cafb990dd94b9dc6194eb6b2de3eca9dbd255bb267a1
9ff11c233aaf5e0242b0dbe6e110a42e58b86141ad0ef130fd2bb895700019782de66d435bf0a8d6f5eda5d7d1105e7a6f3ef17a9da8f9c16fc21075431a
bdd3d0fafe8ba2b29d1ac0b79aa46e249cc9d3a82d0f772d690637bbdd353722356658d00436ff5dd5239ab747979329345eb8c7ed11b7331456ae87350fcf
bd965bf31e87d70327536f2a341cebc4768eca275fa05ef98f7f1b71a0351298de006fba73fe6733ed01d75801b4a928e54231b38e38c562b2e33ea1284992fa
2fc6e69fa26a89a5ed269092cb9b2a449a4409a7a44011eecad13d7c4b0456602d402fa5844f1a7a758136ce3d5d8d0e8b86921ffff4f692dd95bdc8e5ff0052
2fc6e69fa26a89a5ed269092cb9b2a449a4409a7a44011eecad13d7c4b0456602d402fa5844f1a7a758136ce3d5d8d0e8b86921ffff4f692dd95bdc8e5ff0052
    );
}
