######################################################################
#
# 2260_sjis2004_by_utf8jp.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xF3\xB0\x80\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x00"],
        ["\xF3\xB0\x80\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x01"],
        ["\xF3\xB0\x80\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x02"],
        ["\xF3\xB0\x80\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x03"],
        ["\xF3\xB0\x80\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x04"],
        ["\xF3\xB0\x80\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x05"],
        ["\xF3\xB0\x80\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x06"],
        ["\xF3\xB0\x80\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x07"],
        ["\xF3\xB0\x80\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x08"],
        ["\xF3\xB0\x80\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x09"],
        ["\xF3\xB0\x80\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0A"],
        ["\xF3\xB0\x80\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0B"],
        ["\xF3\xB0\x80\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0C"],
        ["\xF3\xB0\x80\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0D"],
        ["\xF3\xB0\x80\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0E"],
        ["\xF3\xB0\x80\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0F"],
        ["\xF3\xB0\x80\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x10"],
        ["\xF3\xB0\x80\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x11"],
        ["\xF3\xB0\x80\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x12"],
        ["\xF3\xB0\x80\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x13"],
        ["\xF3\xB0\x80\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x14"],
        ["\xF3\xB0\x80\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x15"],
        ["\xF3\xB0\x80\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x16"],
        ["\xF3\xB0\x80\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x17"],
        ["\xF3\xB0\x80\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x18"],
        ["\xF3\xB0\x80\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x19"],
        ["\xF3\xB0\x80\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1A"],
        ["\xF3\xB0\x80\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1B"],
        ["\xF3\xB0\x80\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1C"],
        ["\xF3\xB0\x80\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1D"],
        ["\xF3\xB0\x80\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1E"],
        ["\xF3\xB0\x80\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1F"],
        ["\xF3\xB0\x80\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x20"],
        ["\xF3\xB0\x80\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21"],
        ["\xF3\xB0\x80\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22"],
        ["\xF3\xB0\x80\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23"],
        ["\xF3\xB0\x80\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24"],
        ["\xF3\xB0\x80\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25"],
        ["\xF3\xB0\x80\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26"],
        ["\xF3\xB0\x80\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27"],
        ["\xF3\xB0\x80\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x28"],
        ["\xF3\xB0\x80\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x29"],
        ["\xF3\xB0\x80\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2A"],
        ["\xF3\xB0\x80\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2B"],
        ["\xF3\xB0\x80\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C"],
        ["\xF3\xB0\x80\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D"],
        ["\xF3\xB0\x80\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2E"],
        ["\xF3\xB0\x80\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2F"],
        ["\xF3\xB0\x80\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30"],
        ["\xF3\xB0\x80\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31"],
        ["\xF3\xB0\x80\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32"],
        ["\xF3\xB0\x80\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33"],
        ["\xF3\xB0\x80\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34"],
        ["\xF3\xB0\x80\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35"],
        ["\xF3\xB0\x80\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36"],
        ["\xF3\xB0\x80\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37"],
        ["\xF3\xB0\x80\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38"],
        ["\xF3\xB0\x80\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39"],
        ["\xF3\xB0\x80\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A"],
        ["\xF3\xB0\x80\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B"],
        ["\xF3\xB0\x80\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C"],
        ["\xF3\xB0\x80\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D"],
        ["\xF3\xB0\x80\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E"],
        ["\xF3\xB0\x80\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F"],
        ["\xF3\xB0\x81\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40"],
        ["\xF3\xB0\x81\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41"],
        ["\xF3\xB0\x81\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42"],
        ["\xF3\xB0\x81\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43"],
        ["\xF3\xB0\x81\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44"],
        ["\xF3\xB0\x81\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45"],
        ["\xF3\xB0\x81\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46"],
        ["\xF3\xB0\x81\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47"],
        ["\xF3\xB0\x81\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48"],
        ["\xF3\xB0\x81\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49"],
        ["\xF3\xB0\x81\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A"],
        ["\xF3\xB0\x81\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B"],
        ["\xF3\xB0\x81\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C"],
        ["\xF3\xB0\x81\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D"],
        ["\xF3\xB0\x81\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E"],
        ["\xF3\xB0\x81\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F"],
        ["\xF3\xB0\x81\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50"],
        ["\xF3\xB0\x81\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51"],
        ["\xF3\xB0\x81\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52"],
        ["\xF3\xB0\x81\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53"],
        ["\xF3\xB0\x81\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54"],
        ["\xF3\xB0\x81\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55"],
        ["\xF3\xB0\x81\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56"],
        ["\xF3\xB0\x81\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57"],
        ["\xF3\xB0\x81\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58"],
        ["\xF3\xB0\x81\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59"],
        ["\xF3\xB0\x81\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A"],
        ["\xF3\xB0\x81\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B"],
        ["\xF3\xB0\x81\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C"],
        ["\xF3\xB0\x81\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D"],
        ["\xF3\xB0\x81\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E"],
        ["\xF3\xB0\x81\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F"],
        ["\xF3\xB0\x81\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60"],
        ["\xF3\xB0\x81\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61"],
        ["\xF3\xB0\x81\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62"],
        ["\xF3\xB0\x81\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63"],
        ["\xF3\xB0\x81\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64"],
        ["\xF3\xB0\x81\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65"],
        ["\xF3\xB0\x81\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66"],
        ["\xF3\xB0\x81\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67"],
        ["\xF3\xB0\x81\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68"],
        ["\xF3\xB0\x81\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69"],
        ["\xF3\xB0\x81\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A"],
        ["\xF3\xB0\x81\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B"],
        ["\xF3\xB0\x81\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C"],
        ["\xF3\xB0\x81\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D"],
        ["\xF3\xB0\x81\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E"],
        ["\xF3\xB0\x81\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F"],
        ["\xF3\xB0\x81\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70"],
        ["\xF3\xB0\x81\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71"],
        ["\xF3\xB0\x81\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72"],
        ["\xF3\xB0\x81\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73"],
        ["\xF3\xB0\x81\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74"],
        ["\xF3\xB0\x81\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75"],
        ["\xF3\xB0\x81\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76"],
        ["\xF3\xB0\x81\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77"],
        ["\xF3\xB0\x81\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78"],
        ["\xF3\xB0\x81\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79"],
        ["\xF3\xB0\x81\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A"],
        ["\xF3\xB0\x81\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B"],
        ["\xF3\xB0\x81\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C"],
        ["\xF3\xB0\x81\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D"],
        ["\xF3\xB0\x81\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E"],
        ["\xF3\xB0\x81\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F"],
        ["\xF3\xB0\x82\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80"],
        ["\xF3\xB0\x82\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81"],
        ["\xF3\xB0\x82\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82"],
        ["\xF3\xB0\x82\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83"],
        ["\xF3\xB0\x82\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84"],
        ["\xF3\xB0\x82\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85"],
        ["\xF3\xB0\x82\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86"],
        ["\xF3\xB0\x82\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87"],
        ["\xF3\xB0\x82\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88"],
        ["\xF3\xB0\x82\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89"],
        ["\xF3\xB0\x82\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A"],
        ["\xF3\xB0\x82\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B"],
        ["\xF3\xB0\x82\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C"],
        ["\xF3\xB0\x82\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D"],
        ["\xF3\xB0\x82\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E"],
        ["\xF3\xB0\x82\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F"],
        ["\xF3\xB0\x82\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90"],
        ["\xF3\xB0\x82\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91"],
        ["\xF3\xB0\x82\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92"],
        ["\xF3\xB0\x82\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93"],
        ["\xF3\xB0\x82\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94"],
        ["\xF3\xB0\x82\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95"],
        ["\xF3\xB0\x82\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96"],
        ["\xF3\xB0\x82\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97"],
        ["\xF3\xB0\x82\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98"],
        ["\xF3\xB0\x82\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99"],
        ["\xF3\xB0\x82\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A"],
        ["\xF3\xB0\x82\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B"],
        ["\xF3\xB0\x82\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C"],
        ["\xF3\xB0\x82\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D"],
        ["\xF3\xB0\x82\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E"],
        ["\xF3\xB0\x82\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F"],
        ["\xF3\xB0\x82\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA0"],
        ["\xF3\xB0\x82\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1"],
        ["\xF3\xB0\x82\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2"],
        ["\xF3\xB0\x82\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3"],
        ["\xF3\xB0\x82\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4"],
        ["\xF3\xB0\x82\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5"],
        ["\xF3\xB0\x82\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6"],
        ["\xF3\xB0\x82\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7"],
        ["\xF3\xB0\x82\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8"],
        ["\xF3\xB0\x82\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9"],
        ["\xF3\xB0\x82\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA"],
        ["\xF3\xB0\x82\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAB"],
        ["\xF3\xB0\x82\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAC"],
        ["\xF3\xB0\x82\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAD"],
        ["\xF3\xB0\x82\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAE"],
        ["\xF3\xB0\x82\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAF"],
        ["\xF3\xB0\x82\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0"],
        ["\xF3\xB0\x82\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1"],
        ["\xF3\xB0\x82\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2"],
        ["\xF3\xB0\x82\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3"],
        ["\xF3\xB0\x82\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4"],
        ["\xF3\xB0\x82\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5"],
        ["\xF3\xB0\x82\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6"],
        ["\xF3\xB0\x82\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7"],
        ["\xF3\xB0\x82\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8"],
        ["\xF3\xB0\x82\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9"],
        ["\xF3\xB0\x82\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA"],
        ["\xF3\xB0\x82\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB"],
        ["\xF3\xB0\x82\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC"],
        ["\xF3\xB0\x82\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD"],
        ["\xF3\xB0\x82\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE"],
        ["\xF3\xB0\x82\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF"],
        ["\xF3\xB0\x83\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0"],
        ["\xF3\xB0\x83\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1"],
        ["\xF3\xB0\x83\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2"],
        ["\xF3\xB0\x83\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3"],
        ["\xF3\xB0\x83\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4"],
        ["\xF3\xB0\x83\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5"],
        ["\xF3\xB0\x83\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6"],
        ["\xF3\xB0\x83\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7"],
        ["\xF3\xB0\x83\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8"],
        ["\xF3\xB0\x83\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9"],
        ["\xF3\xB0\x83\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA"],
        ["\xF3\xB0\x83\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB"],
        ["\xF3\xB0\x83\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC"],
        ["\xF3\xB0\x83\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD"],
        ["\xF3\xB0\x83\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE"],
        ["\xF3\xB0\x83\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF"],
        ["\xF3\xB0\x83\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0"],
        ["\xF3\xB0\x83\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1"],
        ["\xF3\xB0\x83\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2"],
        ["\xF3\xB0\x83\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3"],
        ["\xF3\xB0\x83\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4"],
        ["\xF3\xB0\x83\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5"],
        ["\xF3\xB0\x83\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6"],
        ["\xF3\xB0\x83\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7"],
        ["\xF3\xB0\x83\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8"],
        ["\xF3\xB0\x83\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9"],
        ["\xF3\xB0\x83\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA"],
        ["\xF3\xB0\x83\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB"],
        ["\xF3\xB0\x83\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC"],
        ["\xF3\xB0\x83\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD"],
        ["\xF3\xB0\x83\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE"],
        ["\xF3\xB0\x83\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF"],
        ["\xF3\xB0\x83\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0"],
        ["\xF3\xB0\x83\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1"],
        ["\xF3\xB0\x83\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2"],
        ["\xF3\xB0\x83\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3"],
        ["\xF3\xB0\x83\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4"],
        ["\xF3\xB0\x83\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5"],
        ["\xF3\xB0\x83\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6"],
        ["\xF3\xB0\x83\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7"],
        ["\xF3\xB0\x83\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8"],
        ["\xF3\xB0\x83\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9"],
        ["\xF3\xB0\x83\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA"],
        ["\xF3\xB0\x83\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB"],
        ["\xF3\xB0\x83\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC"],
        ["\xF3\xB0\x83\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED"],
        ["\xF3\xB0\x83\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE"],
        ["\xF3\xB0\x83\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF"],
        ["\xF3\xB0\x83\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0"],
        ["\xF3\xB0\x83\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1"],
        ["\xF3\xB0\x83\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2"],
        ["\xF3\xB0\x83\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3"],
        ["\xF3\xB0\x83\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4"],
        ["\xF3\xB0\x83\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5"],
        ["\xF3\xB0\x83\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6"],
        ["\xF3\xB0\x83\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7"],
        ["\xF3\xB0\x83\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8"],
        ["\xF3\xB0\x83\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9"],
        ["\xF3\xB0\x83\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA"],
        ["\xF3\xB0\x83\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB"],
        ["\xF3\xB0\x83\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC"],
        ["\xF3\xB0\x83\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFD"],
        ["\xF3\xB0\x83\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFE"],
        ["\xF3\xB0\x83\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFF"],
        ["\xF3\xB0\x84\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x40"],
        ["\xF3\xB0\x84\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x41"],
        ["\xF3\xB0\x84\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x42"],
        ["\xF3\xB0\x84\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x43"],
        ["\xF3\xB0\x84\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x44"],
        ["\xF3\xB0\x84\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x45"],
        ["\xF3\xB0\x84\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x46"],
        ["\xF3\xB0\x84\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x47"],
        ["\xF3\xB0\x84\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x48"],
        ["\xF3\xB0\x84\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x49"],
        ["\xF3\xB0\x84\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4A"],
        ["\xF3\xB0\x84\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4B"],
        ["\xF3\xB0\x84\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4C"],
        ["\xF3\xB0\x84\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4D"],
        ["\xF3\xB0\x84\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4E"],
        ["\xF3\xB0\x84\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4F"],
        ["\xF3\xB0\x84\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x50"],
        ["\xF3\xB0\x84\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x51"],
        ["\xF3\xB0\x84\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x52"],
        ["\xF3\xB0\x84\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x53"],
        ["\xF3\xB0\x84\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x54"],
        ["\xF3\xB0\x84\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x55"],
        ["\xF3\xB0\x84\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x56"],
        ["\xF3\xB0\x84\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x57"],
        ["\xF3\xB0\x84\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x58"],
        ["\xF3\xB0\x84\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x59"],
        ["\xF3\xB0\x84\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x5A"],
        ["\xF3\xB0\x84\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x5B"],
        ["\xF3\xB0\x84\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x5D"],
        ["\xF3\xB0\x84\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x5E"],
        ["\xF3\xB0\x84\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x60"],
        ["\xF3\xB0\x84\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xD2"],
        ["\xF3\xB0\x84\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x62"],
        ["\xF3\xB0\x84\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x63"],
        ["\xF3\xB0\x84\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x64"],
        ["\xF3\xB0\x84\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x65"],
        ["\xF3\xB0\x84\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x66"],
        ["\xF3\xB0\x84\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x67"],
        ["\xF3\xB0\x84\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x68"],
        ["\xF3\xB0\x84\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x69"],
        ["\xF3\xB0\x84\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6A"],
        ["\xF3\xB0\x84\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6B"],
        ["\xF3\xB0\x84\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6C"],
        ["\xF3\xB0\x84\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6D"],
        ["\xF3\xB0\x84\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6E"],
        ["\xF3\xB0\x84\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6F"],
        ["\xF3\xB0\x84\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x70"],
        ["\xF3\xB0\x84\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x71"],
        ["\xF3\xB0\x84\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x72"],
        ["\xF3\xB0\x84\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x73"],
        ["\xF3\xB0\x84\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x74"],
        ["\xF3\xB0\x84\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x75"],
        ["\xF3\xB0\x84\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x76"],
        ["\xF3\xB0\x84\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x77"],
        ["\xF3\xB0\x84\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x78"],
        ["\xF3\xB0\x84\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x79"],
        ["\xF3\xB0\x84\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x7A"],
        ["\xF3\xB0\x84\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x7B"],
        ["\xF3\xB0\x84\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xAF"],
        ["\xF3\xB0\x84\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x7D"],
        ["\xF3\xB0\x84\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x7E"],
        ["\xF3\xB0\x84\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x80"],
        ["\xF3\xB0\x85\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x81"],
        ["\xF3\xB0\x85\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x82"],
        ["\xF3\xB0\x85\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x83"],
        ["\xF3\xB0\x85\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x84"],
        ["\xF3\xB0\x85\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x85"],
        ["\xF3\xB0\x85\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x86"],
        ["\xF3\xB0\x85\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x87"],
        ["\xF3\xB0\x85\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x88"],
        ["\xF3\xB0\x85\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x89"],
        ["\xF3\xB0\x85\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8A"],
        ["\xF3\xB0\x85\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8B"],
        ["\xF3\xB0\x85\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8C"],
        ["\xF3\xB0\x85\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8D"],
        ["\xF3\xB0\x85\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8E"],
        ["\xF3\xB0\x85\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8F"],
        ["\xF3\xB0\x85\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x90"],
        ["\xF3\xB0\x85\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x93"],
        ["\xF3\xB0\x85\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x94"],
        ["\xF3\xB0\x85\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x95"],
        ["\xF3\xB0\x85\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x96"],
        ["\xF3\xB0\x85\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x97"],
        ["\xF3\xB0\x85\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x98"],
        ["\xF3\xB0\x85\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x99"],
        ["\xF3\xB0\x85\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9A"],
        ["\xF3\xB0\x85\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9B"],
        ["\xF3\xB0\x85\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9C"],
        ["\xF3\xB0\x85\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9D"],
        ["\xF3\xB0\x85\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9E"],
        ["\xF3\xB0\x85\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9F"],
        ["\xF3\xB0\x85\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA0"],
        ["\xF3\xB0\x85\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA1"],
        ["\xF3\xB0\x85\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA2"],
        ["\xF3\xB0\x85\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA3"],
        ["\xF3\xB0\x85\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA4"],
        ["\xF3\xB0\x85\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA5"],
        ["\xF3\xB0\x85\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA6"],
        ["\xF3\xB0\x85\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA7"],
        ["\xF3\xB0\x85\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA8"],
        ["\xF3\xB0\x85\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA9"],
        ["\xF3\xB0\x85\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xAA"],
        ["\xF3\xB0\x85\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xAB"],
        ["\xF3\xB0\x85\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xF3\xB0\x85\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xB8"],
        ["\xF3\xB0\x85\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xB9"],
        ["\xF3\xB0\x85\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBA"],
        ["\xF3\xB0\x85\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBB"],
        ["\xF3\xB0\x85\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBC"],
        ["\xF3\xB0\x85\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBD"],
        ["\xF3\xB0\x85\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBE"],
        ["\xF3\xB0\x85\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBF"],
        ["\xF3\xB0\x86\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC8"],
        ["\xF3\xB0\x86\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC9"],
        ["\xF3\xB0\x86\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xCB"],
        ["\xF3\xB0\x86\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xCC"],
        ["\xF3\xB0\x86\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xCD"],
        ["\xF3\xB0\x86\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xCE"],
        ["\xF3\xB0\x86\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDA"],
        ["\xF3\xB0\x86\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDB"],
        ["\xF3\xB0\x86\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDC"],
        ["\xF3\xB0\x86\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDD"],
        ["\xF3\xB0\x86\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDE"],
        ["\xF3\xB0\x86\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDF"],
        ["\xF3\xB0\x86\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE0"],
        ["\xF3\xB0\x86\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE1"],
        ["\xF3\xB0\x86\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE2"],
        ["\xF3\xB0\x86\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE3"],
        ["\xF3\xB0\x86\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE4"],
        ["\xF3\xB0\x86\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE5"],
        ["\xF3\xB0\x86\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE6"],
        ["\xF3\xB0\x86\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE7"],
        ["\xF3\xB0\x86\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE8"],
        ["\xF3\xB0\x86\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF0"],
        ["\xF3\xB0\x86\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF1"],
        ["\xF3\xB0\x86\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF2"],
        ["\xF3\xB0\x86\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF3"],
        ["\xF3\xB0\x86\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF4"],
        ["\xF3\xB0\x86\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF5"],
        ["\xF3\xB0\x86\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF6"],
        ["\xF3\xB0\x86\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF7"],
        ["\xF3\xB0\x86\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xFC"],
        ["\xF3\xB0\x87\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x4F"],
        ["\xF3\xB0\x87\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x50"],
        ["\xF3\xB0\x87\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x51"],
        ["\xF3\xB0\x87\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x52"],
        ["\xF3\xB0\x87\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x53"],
        ["\xF3\xB0\x87\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x54"],
        ["\xF3\xB0\x87\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x55"],
        ["\xF3\xB0\x87\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x56"],
        ["\xF3\xB0\x87\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x57"],
        ["\xF3\xB0\x87\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x58"],
        ["\xF3\xB0\x87\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x60"],
        ["\xF3\xB0\x87\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x61"],
        ["\xF3\xB0\x87\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x62"],
        ["\xF3\xB0\x87\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x63"],
        ["\xF3\xB0\x87\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x64"],
        ["\xF3\xB0\x87\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x65"],
        ["\xF3\xB0\x87\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x66"],
        ["\xF3\xB0\x87\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x67"],
        ["\xF3\xB0\x87\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x68"],
        ["\xF3\xB0\x87\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x69"],
        ["\xF3\xB0\x87\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6A"],
        ["\xF3\xB0\x87\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6B"],
        ["\xF3\xB0\x87\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6C"],
        ["\xF3\xB0\x87\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6D"],
        ["\xF3\xB0\x87\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6E"],
        ["\xF3\xB0\x87\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6F"],
        ["\xF3\xB0\x87\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x70"],
        ["\xF3\xB0\x87\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x71"],
        ["\xF3\xB0\x87\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x72"],
        ["\xF3\xB0\x87\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x73"],
        ["\xF3\xB0\x87\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x74"],
        ["\xF3\xB0\x87\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x75"],
        ["\xF3\xB0\x87\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x76"],
        ["\xF3\xB0\x87\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x77"],
        ["\xF3\xB0\x87\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x78"],
        ["\xF3\xB0\x87\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x79"],
        ["\xF3\xB0\x87\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x81"],
        ["\xF3\xB0\x87\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x82"],
        ["\xF3\xB0\x87\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x83"],
        ["\xF3\xB0\x87\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x84"],
        ["\xF3\xB0\x88\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x85"],
        ["\xF3\xB0\x88\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x86"],
        ["\xF3\xB0\x88\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x87"],
        ["\xF3\xB0\x88\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x88"],
        ["\xF3\xB0\x88\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x89"],
        ["\xF3\xB0\x88\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8A"],
        ["\xF3\xB0\x88\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8B"],
        ["\xF3\xB0\x88\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8C"],
        ["\xF3\xB0\x88\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8D"],
        ["\xF3\xB0\x88\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8E"],
        ["\xF3\xB0\x88\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8F"],
        ["\xF3\xB0\x88\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x90"],
        ["\xF3\xB0\x88\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x91"],
        ["\xF3\xB0\x88\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x92"],
        ["\xF3\xB0\x88\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x93"],
        ["\xF3\xB0\x88\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x94"],
        ["\xF3\xB0\x88\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x95"],
        ["\xF3\xB0\x88\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x96"],
        ["\xF3\xB0\x88\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x97"],
        ["\xF3\xB0\x88\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x98"],
        ["\xF3\xB0\x88\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x99"],
        ["\xF3\xB0\x88\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x9A"],
        ["\xF3\xB0\x88\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x9F"],
        ["\xF3\xB0\x88\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA0"],
        ["\xF3\xB0\x88\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA1"],
        ["\xF3\xB0\x88\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA2"],
        ["\xF3\xB0\x88\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA3"],
        ["\xF3\xB0\x88\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA4"],
        ["\xF3\xB0\x88\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA5"],
        ["\xF3\xB0\x88\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA6"],
        ["\xF3\xB0\x88\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA7"],
        ["\xF3\xB0\x88\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA8"],
        ["\xF3\xB0\x88\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA9"],
        ["\xF3\xB0\x88\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAA"],
        ["\xF3\xB0\x88\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAB"],
        ["\xF3\xB0\x88\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAC"],
        ["\xF3\xB0\x88\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAD"],
        ["\xF3\xB0\x88\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAE"],
        ["\xF3\xB0\x88\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAF"],
        ["\xF3\xB0\x88\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB0"],
        ["\xF3\xB0\x88\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB1"],
        ["\xF3\xB0\x88\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB2"],
        ["\xF3\xB0\x88\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB3"],
        ["\xF3\xB0\x88\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB4"],
        ["\xF3\xB0\x88\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB5"],
        ["\xF3\xB0\x88\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB6"],
        ["\xF3\xB0\x88\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB7"],
        ["\xF3\xB0\x88\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB8"],
        ["\xF3\xB0\x88\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB9"],
        ["\xF3\xB0\x88\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBA"],
        ["\xF3\xB0\x88\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBB"],
        ["\xF3\xB0\x88\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBC"],
        ["\xF3\xB0\x88\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBD"],
        ["\xF3\xB0\x88\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBE"],
        ["\xF3\xB0\x88\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBF"],
        ["\xF3\xB0\x88\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC0"],
        ["\xF3\xB0\x88\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC1"],
        ["\xF3\xB0\x88\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC2"],
        ["\xF3\xB0\x88\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC3"],
        ["\xF3\xB0\x88\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC4"],
        ["\xF3\xB0\x89\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC5"],
        ["\xF3\xB0\x89\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC6"],
        ["\xF3\xB0\x89\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC7"],
        ["\xF3\xB0\x89\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC8"],
        ["\xF3\xB0\x89\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC9"],
        ["\xF3\xB0\x89\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCA"],
        ["\xF3\xB0\x89\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCB"],
        ["\xF3\xB0\x89\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCC"],
        ["\xF3\xB0\x89\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCD"],
        ["\xF3\xB0\x89\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCE"],
        ["\xF3\xB0\x89\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCF"],
        ["\xF3\xB0\x89\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD0"],
        ["\xF3\xB0\x89\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD1"],
        ["\xF3\xB0\x89\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD2"],
        ["\xF3\xB0\x89\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD3"],
        ["\xF3\xB0\x89\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD4"],
        ["\xF3\xB0\x89\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD5"],
        ["\xF3\xB0\x89\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD6"],
        ["\xF3\xB0\x89\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD7"],
        ["\xF3\xB0\x89\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD8"],
        ["\xF3\xB0\x89\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD9"],
        ["\xF3\xB0\x89\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDA"],
        ["\xF3\xB0\x89\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDB"],
        ["\xF3\xB0\x89\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDC"],
        ["\xF3\xB0\x89\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDD"],
        ["\xF3\xB0\x89\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDE"],
        ["\xF3\xB0\x89\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDF"],
        ["\xF3\xB0\x89\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE0"],
        ["\xF3\xB0\x89\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE1"],
        ["\xF3\xB0\x89\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE2"],
        ["\xF3\xB0\x89\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE3"],
        ["\xF3\xB0\x89\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE4"],
        ["\xF3\xB0\x89\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE5"],
        ["\xF3\xB0\x89\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE6"],
        ["\xF3\xB0\x89\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE7"],
        ["\xF3\xB0\x89\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE8"],
        ["\xF3\xB0\x89\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE9"],
        ["\xF3\xB0\x89\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEA"],
        ["\xF3\xB0\x89\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEB"],
        ["\xF3\xB0\x89\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEC"],
        ["\xF3\xB0\x89\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xED"],
        ["\xF3\xB0\x89\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEE"],
        ["\xF3\xB0\x89\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEF"],
        ["\xF3\xB0\x89\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF0"],
        ["\xF3\xB0\x89\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF1"],
        ["\xF3\xB0\x89\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x40"],
        ["\xF3\xB0\x89\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x41"],
        ["\xF3\xB0\x89\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x42"],
        ["\xF3\xB0\x89\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x43"],
        ["\xF3\xB0\x89\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x44"],
        ["\xF3\xB0\x89\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x45"],
        ["\xF3\xB0\x89\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x46"],
        ["\xF3\xB0\x89\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x47"],
        ["\xF3\xB0\x8A\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x48"],
        ["\xF3\xB0\x8A\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x49"],
        ["\xF3\xB0\x8A\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4A"],
        ["\xF3\xB0\x8A\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4B"],
        ["\xF3\xB0\x8A\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4C"],
        ["\xF3\xB0\x8A\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4D"],
        ["\xF3\xB0\x8A\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4E"],
        ["\xF3\xB0\x8A\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4F"],
        ["\xF3\xB0\x8A\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x50"],
        ["\xF3\xB0\x8A\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x51"],
        ["\xF3\xB0\x8A\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x52"],
        ["\xF3\xB0\x8A\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x53"],
        ["\xF3\xB0\x8A\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x54"],
        ["\xF3\xB0\x8A\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x55"],
        ["\xF3\xB0\x8A\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x56"],
        ["\xF3\xB0\x8A\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x57"],
        ["\xF3\xB0\x8A\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x58"],
        ["\xF3\xB0\x8A\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x59"],
        ["\xF3\xB0\x8A\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5A"],
        ["\xF3\xB0\x8A\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5B"],
        ["\xF3\xB0\x8A\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5C"],
        ["\xF3\xB0\x8A\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5D"],
        ["\xF3\xB0\x8A\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5E"],
        ["\xF3\xB0\x8A\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5F"],
        ["\xF3\xB0\x8A\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x60"],
        ["\xF3\xB0\x8A\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x61"],
        ["\xF3\xB0\x8A\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x62"],
        ["\xF3\xB0\x8A\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x63"],
        ["\xF3\xB0\x8A\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x64"],
        ["\xF3\xB0\x8A\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x65"],
        ["\xF3\xB0\x8A\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x66"],
        ["\xF3\xB0\x8A\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x67"],
        ["\xF3\xB0\x8A\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x68"],
        ["\xF3\xB0\x8A\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x69"],
        ["\xF3\xB0\x8A\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6A"],
        ["\xF3\xB0\x8A\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6B"],
        ["\xF3\xB0\x8A\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6C"],
        ["\xF3\xB0\x8A\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6D"],
        ["\xF3\xB0\x8A\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6E"],
        ["\xF3\xB0\x8A\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6F"],
        ["\xF3\xB0\x8A\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x70"],
        ["\xF3\xB0\x8A\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x71"],
        ["\xF3\xB0\x8A\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x72"],
        ["\xF3\xB0\x8A\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x73"],
        ["\xF3\xB0\x8A\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x74"],
        ["\xF3\xB0\x8A\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x75"],
        ["\xF3\xB0\x8A\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x76"],
        ["\xF3\xB0\x8A\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x77"],
        ["\xF3\xB0\x8A\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x78"],
        ["\xF3\xB0\x8A\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x79"],
        ["\xF3\xB0\x8A\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x7A"],
        ["\xF3\xB0\x8A\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x7B"],
        ["\xF3\xB0\x8A\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x7C"],
        ["\xF3\xB0\x8A\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x7D"],
        ["\xF3\xB0\x8A\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x7E"],
        ["\xF3\xB0\x8A\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x80"],
        ["\xF3\xB0\x8A\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x81"],
        ["\xF3\xB0\x8A\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x82"],
        ["\xF3\xB0\x8A\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x83"],
        ["\xF3\xB0\x8A\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x84"],
        ["\xF3\xB0\x8A\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x85"],
        ["\xF3\xB0\x8A\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x86"],
        ["\xF3\xB0\x8A\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x87"],
        ["\xF3\xB0\x8A\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x88"],
        ["\xF3\xB0\x8B\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x89"],
        ["\xF3\xB0\x8B\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8A"],
        ["\xF3\xB0\x8B\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8B"],
        ["\xF3\xB0\x8B\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8C"],
        ["\xF3\xB0\x8B\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8D"],
        ["\xF3\xB0\x8B\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8E"],
        ["\xF3\xB0\x8B\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8F"],
        ["\xF3\xB0\x8B\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x90"],
        ["\xF3\xB0\x8B\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x91"],
        ["\xF3\xB0\x8B\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x92"],
        ["\xF3\xB0\x8B\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x93"],
        ["\xF3\xB0\x8B\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x94"],
        ["\xF3\xB0\x8B\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x95"],
        ["\xF3\xB0\x8B\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x96"],
        ["\xF3\xB0\x8B\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x9F"],
        ["\xF3\xB0\x8B\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA0"],
        ["\xF3\xB0\x8B\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA1"],
        ["\xF3\xB0\x8B\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA2"],
        ["\xF3\xB0\x8B\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA3"],
        ["\xF3\xB0\x8B\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA4"],
        ["\xF3\xB0\x8B\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA5"],
        ["\xF3\xB0\x8B\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA6"],
        ["\xF3\xB0\x8B\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA7"],
        ["\xF3\xB0\x8B\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA8"],
        ["\xF3\xB0\x8B\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA9"],
        ["\xF3\xB0\x8B\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAA"],
        ["\xF3\xB0\x8B\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAB"],
        ["\xF3\xB0\x8B\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAC"],
        ["\xF3\xB0\x8B\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAD"],
        ["\xF3\xB0\x8B\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAE"],
        ["\xF3\xB0\x8B\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAF"],
        ["\xF3\xB0\x8B\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB0"],
        ["\xF3\xB0\x8B\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB1"],
        ["\xF3\xB0\x8B\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB2"],
        ["\xF3\xB0\x8B\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB3"],
        ["\xF3\xB0\x8B\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB4"],
        ["\xF3\xB0\x8B\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB5"],
        ["\xF3\xB0\x8B\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB6"],
        ["\xF3\xB0\x8B\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xBF"],
        ["\xF3\xB0\x8B\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC0"],
        ["\xF3\xB0\x8B\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC1"],
        ["\xF3\xB0\x8B\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC2"],
        ["\xF3\xB0\x8B\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC3"],
        ["\xF3\xB0\x8B\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC4"],
        ["\xF3\xB0\x8B\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC5"],
        ["\xF3\xB0\x8B\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC6"],
        ["\xF3\xB0\x8B\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC7"],
        ["\xF3\xB0\x8B\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC8"],
        ["\xF3\xB0\x8C\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC9"],
        ["\xF3\xB0\x8C\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCA"],
        ["\xF3\xB0\x8C\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCB"],
        ["\xF3\xB0\x8C\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCC"],
        ["\xF3\xB0\x8C\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCD"],
        ["\xF3\xB0\x8C\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCE"],
        ["\xF3\xB0\x8C\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCF"],
        ["\xF3\xB0\x8C\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD0"],
        ["\xF3\xB0\x8C\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD1"],
        ["\xF3\xB0\x8C\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD2"],
        ["\xF3\xB0\x8C\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD3"],
        ["\xF3\xB0\x8C\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD4"],
        ["\xF3\xB0\x8C\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD5"],
        ["\xF3\xB0\x8C\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD6"],
        ["\xF3\xB0\x8C\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x40"],
        ["\xF3\xB0\x8C\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x41"],
        ["\xF3\xB0\x8C\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x42"],
        ["\xF3\xB0\x8C\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x43"],
        ["\xF3\xB0\x8C\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x44"],
        ["\xF3\xB0\x8C\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x45"],
        ["\xF3\xB0\x8C\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x46"],
        ["\xF3\xB0\x8C\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x47"],
        ["\xF3\xB0\x8C\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x48"],
        ["\xF3\xB0\x8C\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x49"],
        ["\xF3\xB0\x8C\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4A"],
        ["\xF3\xB0\x8C\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4B"],
        ["\xF3\xB0\x8D\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4C"],
        ["\xF3\xB0\x8D\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4D"],
        ["\xF3\xB0\x8D\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4E"],
        ["\xF3\xB0\x8D\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4F"],
        ["\xF3\xB0\x8D\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x50"],
        ["\xF3\xB0\x8D\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x51"],
        ["\xF3\xB0\x8D\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x52"],
        ["\xF3\xB0\x8D\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x53"],
        ["\xF3\xB0\x8D\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x54"],
        ["\xF3\xB0\x8D\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x55"],
        ["\xF3\xB0\x8D\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x56"],
        ["\xF3\xB0\x8D\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x57"],
        ["\xF3\xB0\x8D\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x58"],
        ["\xF3\xB0\x8D\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x59"],
        ["\xF3\xB0\x8D\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5A"],
        ["\xF3\xB0\x8D\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5B"],
        ["\xF3\xB0\x8D\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5C"],
        ["\xF3\xB0\x8D\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5D"],
        ["\xF3\xB0\x8D\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5E"],
        ["\xF3\xB0\x8D\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5F"],
        ["\xF3\xB0\x8D\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x60"],
        ["\xF3\xB0\x8D\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x70"],
        ["\xF3\xB0\x8D\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x71"],
        ["\xF3\xB0\x8D\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x72"],
        ["\xF3\xB0\x8D\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x73"],
        ["\xF3\xB0\x8D\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x74"],
        ["\xF3\xB0\x8D\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x75"],
        ["\xF3\xB0\x8D\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x76"],
        ["\xF3\xB0\x8D\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x77"],
        ["\xF3\xB0\x8D\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x78"],
        ["\xF3\xB0\x8D\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x79"],
        ["\xF3\xB0\x8D\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x7A"],
        ["\xF3\xB0\x8D\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x7B"],
        ["\xF3\xB0\x8D\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x7C"],
        ["\xF3\xB0\x8D\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x7D"],
        ["\xF3\xB0\x8D\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x7E"],
        ["\xF3\xB0\x8D\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x80"],
        ["\xF3\xB0\x8D\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x81"],
        ["\xF3\xB0\x8D\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x82"],
        ["\xF3\xB0\x8D\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x83"],
        ["\xF3\xB0\x8D\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x84"],
        ["\xF3\xB0\x8D\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x85"],
        ["\xF3\xB0\x8D\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x86"],
        ["\xF3\xB0\x8D\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x87"],
        ["\xF3\xB0\x8D\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x88"],
        ["\xF3\xB0\x8D\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x89"],
        ["\xF3\xB0\x8D\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8A"],
        ["\xF3\xB0\x8D\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8B"],
        ["\xF3\xB0\x8D\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8C"],
        ["\xF3\xB0\x8E\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8D"],
        ["\xF3\xB0\x8E\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8E"],
        ["\xF3\xB0\x8E\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8F"],
        ["\xF3\xB0\x8E\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x90"],
        ["\xF3\xB0\x8E\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x91"],
        ["\xF3\xB0\x8E\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x9F"],
        ["\xF3\xB0\x8E\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA0"],
        ["\xF3\xB0\x8E\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA1"],
        ["\xF3\xB0\x8E\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA2"],
        ["\xF3\xB0\x8E\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA3"],
        ["\xF3\xB0\x8E\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA4"],
        ["\xF3\xB0\x8E\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA5"],
        ["\xF3\xB0\x8E\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA6"],
        ["\xF3\xB0\x8E\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA7"],
        ["\xF3\xB0\x8E\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA8"],
        ["\xF3\xB0\x8E\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA9"],
        ["\xF3\xB0\x8E\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAA"],
        ["\xF3\xB0\x8E\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAB"],
        ["\xF3\xB0\x8E\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAC"],
        ["\xF3\xB0\x8E\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAD"],
        ["\xF3\xB0\x8E\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAE"],
        ["\xF3\xB0\x8E\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAF"],
        ["\xF3\xB0\x8E\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB0"],
        ["\xF3\xB0\x8E\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB1"],
        ["\xF3\xB0\x8E\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB2"],
        ["\xF3\xB0\x8E\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB3"],
        ["\xF3\xB0\x8E\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB4"],
        ["\xF3\xB0\x8E\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB5"],
        ["\xF3\xB0\x8E\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB6"],
        ["\xF3\xB0\x8E\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB7"],
        ["\xF3\xB0\x8E\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB8"],
        ["\xF3\xB0\x8E\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB9"],
        ["\xF3\xB0\x8E\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xBA"],
        ["\xF3\xB0\x8E\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xBB"],
        ["\xF3\xB0\x8E\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xBC"],
        ["\xF3\xB0\x8E\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xBD"],
        ["\xF3\xB0\x8E\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xBE"],
        ["\xF3\xB0\x95\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x40"],
        ["\xF3\xB0\x95\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x41"],
        ["\xF3\xB0\x95\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x42"],
        ["\xF3\xB0\x95\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x43"],
        ["\xF3\xB0\x95\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x44"],
        ["\xF3\xB0\x95\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x45"],
        ["\xF3\xB0\x95\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x46"],
        ["\xF3\xB0\x95\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x47"],
        ["\xF3\xB0\x95\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x48"],
        ["\xF3\xB0\x95\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x49"],
        ["\xF3\xB0\x95\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4A"],
        ["\xF3\xB0\x95\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4B"],
        ["\xF3\xB0\x95\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4C"],
        ["\xF3\xB0\x95\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4D"],
        ["\xF3\xB0\x95\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4E"],
        ["\xF3\xB0\x95\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4F"],
        ["\xF3\xB0\x95\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x50"],
        ["\xF3\xB0\x95\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x51"],
        ["\xF3\xB0\x95\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x52"],
        ["\xF3\xB0\x95\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x53"],
        ["\xF3\xB0\x95\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x54"],
        ["\xF3\xB0\x95\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x55"],
        ["\xF3\xB0\x95\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x56"],
        ["\xF3\xB0\x95\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x57"],
        ["\xF3\xB0\x96\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x58"],
        ["\xF3\xB0\x96\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x59"],
        ["\xF3\xB0\x96\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x5A"],
        ["\xF3\xB0\x96\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x5B"],
        ["\xF3\xB0\x96\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x5C"],
        ["\xF3\xB0\x96\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x5D"],
        ["\xF3\xB0\x96\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x5F"],
        ["\xF3\xB0\x96\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x60"],
        ["\xF3\xB0\x96\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x61"],
        ["\xF3\xB0\x96\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x62"],
        ["\xF3\xB0\x96\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x63"],
        ["\xF3\xB0\x96\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x64"],
        ["\xF3\xB0\x96\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x65"],
        ["\xF3\xB0\x96\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x66"],
        ["\xF3\xB0\x96\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x67"],
        ["\xF3\xB0\x96\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x68"],
        ["\xF3\xB0\x96\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x69"],
        ["\xF3\xB0\x96\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6A"],
        ["\xF3\xB0\x96\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6B"],
        ["\xF3\xB0\x96\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6C"],
        ["\xF3\xB0\x96\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6D"],
        ["\xF3\xB0\x96\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6E"],
        ["\xF3\xB0\x96\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6F"],
        ["\xF3\xB0\x96\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x70"],
        ["\xF3\xB0\x96\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x71"],
        ["\xF3\xB0\x96\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x72"],
        ["\xF3\xB0\x96\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x73"],
        ["\xF3\xB0\x96\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x74"],
        ["\xF3\xB0\x96\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x75"],
        ["\xF3\xB0\x96\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x7E"],
        ["\xF3\xB0\x96\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x80"],
        ["\xF3\xB0\x96\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x81"],
        ["\xF3\xB0\x96\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x82"],
        ["\xF3\xB0\x96\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x83"],
        ["\xF3\xB0\x96\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x84"],
        ["\xF3\xB0\x96\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x85"],
        ["\xF3\xB0\x96\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x86"],
        ["\xF3\xB0\x96\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x87"],
        ["\xF3\xB0\x96\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x88"],
        ["\xF3\xB0\x96\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x89"],
        ["\xF3\xB0\x96\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8A"],
        ["\xF3\xB0\x96\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8B"],
        ["\xF3\xB0\x96\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8C"],
        ["\xF3\xB0\x96\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8D"],
        ["\xF3\xB0\x96\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8E"],
        ["\xF3\xB0\x96\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8F"],
        ["\xF3\xB0\x96\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x93"],
        ["\xF3\xB0\x96\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x98"],
        ["\xF3\xB0\x97\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x99"],
        ["\xF3\xB0\x9A\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x9F"],
        ["\xF3\xB0\x9A\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA0"],
        ["\xF3\xB0\x9A\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA1"],
        ["\xF3\xB0\x9A\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA2"],
        ["\xF3\xB0\x9A\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA3"],
        ["\xF3\xB0\x9A\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA4"],
        ["\xF3\xB0\x9A\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA5"],
        ["\xF3\xB0\x9A\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA6"],
        ["\xF3\xB0\x9A\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA7"],
        ["\xF3\xB0\x9A\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA8"],
        ["\xF3\xB0\x9A\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA9"],
        ["\xF3\xB0\x9A\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAA"],
        ["\xF3\xB0\x9A\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAB"],
        ["\xF3\xB0\x9A\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAC"],
        ["\xF3\xB0\x9A\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAD"],
        ["\xF3\xB0\x9A\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAE"],
        ["\xF3\xB0\x9A\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAF"],
        ["\xF3\xB0\x9A\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB0"],
        ["\xF3\xB0\x9A\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB1"],
        ["\xF3\xB0\x9A\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB2"],
        ["\xF3\xB0\x9A\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB3"],
        ["\xF3\xB0\x9A\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB4"],
        ["\xF3\xB0\x9A\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB5"],
        ["\xF3\xB0\x9A\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB6"],
        ["\xF3\xB0\x9A\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB7"],
        ["\xF3\xB0\x9A\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB8"],
        ["\xF3\xB0\x9A\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB9"],
        ["\xF3\xB0\x9A\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBA"],
        ["\xF3\xB0\x9A\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBB"],
        ["\xF3\xB0\x9A\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBC"],
        ["\xF3\xB0\x9A\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBD"],
        ["\xF3\xB0\x9A\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBE"],
        ["\xF3\xB0\x9A\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBF"],
        ["\xF3\xB0\x9A\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC0"],
        ["\xF3\xB0\x9A\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC1"],
        ["\xF3\xB0\x9A\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC2"],
        ["\xF3\xB0\x9A\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC3"],
        ["\xF3\xB0\x9A\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC4"],
        ["\xF3\xB0\x9A\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC5"],
        ["\xF3\xB0\x9A\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC6"],
        ["\xF3\xB0\x9A\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC7"],
        ["\xF3\xB0\x9A\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC8"],
        ["\xF3\xB0\x9A\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC9"],
        ["\xF3\xB0\x9A\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCA"],
        ["\xF3\xB0\x9A\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCB"],
        ["\xF3\xB0\x9A\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCC"],
        ["\xF3\xB0\x9A\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCD"],
        ["\xF3\xB0\x9A\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCE"],
        ["\xF3\xB0\x9A\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCF"],
        ["\xF3\xB0\x9A\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD0"],
        ["\xF3\xB0\x9A\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD1"],
        ["\xF3\xB0\x9A\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD2"],
        ["\xF3\xB0\x9A\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD3"],
        ["\xF3\xB0\x9A\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD4"],
        ["\xF3\xB0\x9A\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD5"],
        ["\xF3\xB0\x9A\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD6"],
        ["\xF3\xB0\x9A\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD7"],
        ["\xF3\xB0\x9A\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD8"],
        ["\xF3\xB0\x9A\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD9"],
        ["\xF3\xB0\x9A\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDA"],
        ["\xF3\xB0\x9A\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDB"],
        ["\xF3\xB0\x9A\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDC"],
        ["\xF3\xB0\x9B\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDD"],
        ["\xF3\xB0\x9B\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDE"],
        ["\xF3\xB0\x9B\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDF"],
        ["\xF3\xB0\x9B\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE0"],
        ["\xF3\xB0\x9B\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE1"],
        ["\xF3\xB0\x9B\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE2"],
        ["\xF3\xB0\x9B\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE3"],
        ["\xF3\xB0\x9B\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE4"],
        ["\xF3\xB0\x9B\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE5"],
        ["\xF3\xB0\x9B\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE6"],
        ["\xF3\xB0\x9B\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE7"],
        ["\xF3\xB0\x9B\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE8"],
        ["\xF3\xB0\x9B\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE9"],
        ["\xF3\xB0\x9B\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEA"],
        ["\xF3\xB0\x9B\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEB"],
        ["\xF3\xB0\x9B\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEC"],
        ["\xF3\xB0\x9B\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xED"],
        ["\xF3\xB0\x9B\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEE"],
        ["\xF3\xB0\x9B\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEF"],
        ["\xF3\xB0\x9B\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF0"],
        ["\xF3\xB0\x9B\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF1"],
        ["\xF3\xB0\x9B\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF2"],
        ["\xF3\xB0\x9B\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF3"],
        ["\xF3\xB0\x9B\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF4"],
        ["\xF3\xB0\x9B\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF5"],
        ["\xF3\xB0\x9B\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF6"],
        ["\xF3\xB0\x9B\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF7"],
        ["\xF3\xB0\x9B\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF8"],
        ["\xF3\xB0\x9B\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF9"],
        ["\xF3\xB0\x9B\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xFA"],
        ["\xF3\xB0\x9B\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xFB"],
        ["\xF3\xB0\x9B\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xFC"],
        ["\xF3\xB0\x9B\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x40"],
        ["\xF3\xB0\x9B\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x41"],
        ["\xF3\xB0\x9B\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x42"],
        ["\xF3\xB0\x9B\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x43"],
        ["\xF3\xB0\x9B\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x44"],
        ["\xF3\xB0\x9B\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x45"],
        ["\xF3\xB0\x9B\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x46"],
        ["\xF3\xB0\x9B\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x47"],
        ["\xF3\xB0\x9B\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x48"],
        ["\xF3\xB0\x9B\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x49"],
        ["\xF3\xB0\x9B\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4A"],
        ["\xF3\xB0\x9B\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4B"],
        ["\xF3\xB0\x9B\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4C"],
        ["\xF3\xB0\x9B\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4D"],
        ["\xF3\xB0\x9B\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4E"],
        ["\xF3\xB0\x9B\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4F"],
        ["\xF3\xB0\x9B\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x50"],
        ["\xF3\xB0\x9B\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x51"],
        ["\xF3\xB0\x9B\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x52"],
        ["\xF3\xB0\x9B\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x53"],
        ["\xF3\xB0\x9B\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x54"],
        ["\xF3\xB0\x9B\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x55"],
        ["\xF3\xB0\x9B\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x56"],
        ["\xF3\xB0\x9B\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x57"],
        ["\xF3\xB0\x9B\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x58"],
        ["\xF3\xB0\x9B\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x59"],
        ["\xF3\xB0\x9B\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5A"],
        ["\xF3\xB0\x9B\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5B"],
        ["\xF3\xB0\x9B\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5C"],
        ["\xF3\xB0\x9B\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5D"],
        ["\xF3\xB0\x9B\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5E"],
        ["\xF3\xB0\x9B\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5F"],
        ["\xF3\xB0\x9C\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x60"],
        ["\xF3\xB0\x9C\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x61"],
        ["\xF3\xB0\x9C\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x62"],
        ["\xF3\xB0\x9C\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x63"],
        ["\xF3\xB0\x9C\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x64"],
        ["\xF3\xB0\x9C\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x65"],
        ["\xF3\xB0\x9C\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x66"],
        ["\xF3\xB0\x9C\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x67"],
        ["\xF3\xB0\x9C\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x68"],
        ["\xF3\xB0\x9C\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x69"],
        ["\xF3\xB0\x9C\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6A"],
        ["\xF3\xB0\x9C\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6B"],
        ["\xF3\xB0\x9C\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6C"],
        ["\xF3\xB0\x9C\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6D"],
        ["\xF3\xB0\x9C\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6E"],
        ["\xF3\xB0\x9C\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6F"],
        ["\xF3\xB0\x9C\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x70"],
        ["\xF3\xB0\x9C\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x71"],
        ["\xF3\xB0\x9C\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x72"],
        ["\xF3\xB0\x9C\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x73"],
        ["\xF3\xB0\x9C\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x74"],
        ["\xF3\xB0\x9C\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x75"],
        ["\xF3\xB0\x9C\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x76"],
        ["\xF3\xB0\x9C\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x77"],
        ["\xF3\xB0\x9C\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x78"],
        ["\xF3\xB0\x9C\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x79"],
        ["\xF3\xB0\x9C\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x7A"],
        ["\xF3\xB0\x9C\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x7B"],
        ["\xF3\xB0\x9C\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x7C"],
        ["\xF3\xB0\x9C\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x7D"],
        ["\xF3\xB0\x9C\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x7E"],
        ["\xF3\xB0\x9C\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x80"],
        ["\xF3\xB0\x9C\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x81"],
        ["\xF3\xB0\x9C\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x82"],
        ["\xF3\xB0\x9C\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x83"],
        ["\xF3\xB0\x9C\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x84"],
        ["\xF3\xB0\x9C\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x85"],
        ["\xF3\xB0\x9C\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x86"],
        ["\xF3\xB0\x9C\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x87"],
        ["\xF3\xB0\x9C\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x88"],
        ["\xF3\xB0\x9C\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x89"],
        ["\xF3\xB0\x9C\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8A"],
        ["\xF3\xB0\x9C\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8B"],
        ["\xF3\xB0\x9C\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8C"],
        ["\xF3\xB0\x9C\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8D"],
        ["\xF3\xB0\x9C\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8E"],
        ["\xF3\xB0\x9C\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8F"],
        ["\xF3\xB0\x9C\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x90"],
        ["\xF3\xB0\x9C\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x91"],
        ["\xF3\xB0\x9C\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x92"],
        ["\xF3\xB0\x9C\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x93"],
        ["\xF3\xB0\x9C\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x94"],
        ["\xF3\xB0\x9C\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x95"],
        ["\xF3\xB0\x9C\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x96"],
        ["\xF3\xB0\x9C\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x97"],
        ["\xF3\xB0\x9C\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x98"],
        ["\xF3\xB0\x9C\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x99"],
        ["\xF3\xB0\x9C\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9A"],
        ["\xF3\xB0\x9C\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9B"],
        ["\xF3\xB0\x9C\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9C"],
        ["\xF3\xB0\x9C\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9D"],
        ["\xF3\xB0\x9C\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9E"],
        ["\xF3\xB0\x9C\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9F"],
        ["\xF3\xB0\x9C\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA0"],
        ["\xF3\xB0\x9D\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA1"],
        ["\xF3\xB0\x9D\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA2"],
        ["\xF3\xB0\x9D\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA3"],
        ["\xF3\xB0\x9D\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA4"],
        ["\xF3\xB0\x9D\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA5"],
        ["\xF3\xB0\x9D\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA6"],
        ["\xF3\xB0\x9D\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA7"],
        ["\xF3\xB0\x9D\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA8"],
        ["\xF3\xB0\x9D\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA9"],
        ["\xF3\xB0\x9D\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAA"],
        ["\xF3\xB0\x9D\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAB"],
        ["\xF3\xB0\x9D\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAC"],
        ["\xF3\xB0\x9D\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAD"],
        ["\xF3\xB0\x9D\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAE"],
        ["\xF3\xB0\x9D\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAF"],
        ["\xF3\xB0\x9D\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB0"],
        ["\xF3\xB0\x9D\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB1"],
        ["\xF3\xB0\x9D\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB2"],
        ["\xF3\xB0\x9D\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB3"],
        ["\xF3\xB0\x9D\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB4"],
        ["\xF3\xB0\x9D\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB5"],
        ["\xF3\xB0\x9D\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB6"],
        ["\xF3\xB0\x9D\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB7"],
        ["\xF3\xB0\x9D\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB8"],
        ["\xF3\xB0\x9D\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB9"],
        ["\xF3\xB0\x9D\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBA"],
        ["\xF3\xB0\x9D\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBB"],
        ["\xF3\xB0\x9D\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBC"],
        ["\xF3\xB0\x9D\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBD"],
        ["\xF3\xB0\x9D\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBE"],
        ["\xF3\xB0\x9D\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBF"],
        ["\xF3\xB0\x9D\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC0"],
        ["\xF3\xB0\x9D\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC1"],
        ["\xF3\xB0\x9D\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC2"],
        ["\xF3\xB0\x9D\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC3"],
        ["\xF3\xB0\x9D\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC4"],
        ["\xF3\xB0\x9D\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC5"],
        ["\xF3\xB0\x9D\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC6"],
        ["\xF3\xB0\x9D\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC7"],
        ["\xF3\xB0\x9D\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC8"],
        ["\xF3\xB0\x9D\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC9"],
        ["\xF3\xB0\x9D\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCA"],
        ["\xF3\xB0\x9D\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCB"],
        ["\xF3\xB0\x9D\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCC"],
        ["\xF3\xB0\x9D\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCD"],
        ["\xF3\xB0\x9D\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCE"],
        ["\xF3\xB0\x9D\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCF"],
        ["\xF3\xB0\x9D\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD0"],
        ["\xF3\xB0\x9D\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD1"],
        ["\xF3\xB0\x9D\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD2"],
        ["\xF3\xB0\x9D\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD3"],
        ["\xF3\xB0\x9D\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD4"],
        ["\xF3\xB0\x9D\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD5"],
        ["\xF3\xB0\x9D\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD6"],
        ["\xF3\xB0\x9D\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD7"],
        ["\xF3\xB0\x9D\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD8"],
        ["\xF3\xB0\x9D\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD9"],
        ["\xF3\xB0\x9D\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDA"],
        ["\xF3\xB0\x9D\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDB"],
        ["\xF3\xB0\x9D\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDC"],
        ["\xF3\xB0\x9D\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDD"],
        ["\xF3\xB0\x9D\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDE"],
        ["\xF3\xB0\x9D\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDF"],
        ["\xF3\xB0\x9D\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE0"],
        ["\xF3\xB0\x9E\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE1"],
        ["\xF3\xB0\x9E\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE2"],
        ["\xF3\xB0\x9E\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE3"],
        ["\xF3\xB0\x9E\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE4"],
        ["\xF3\xB0\x9E\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE5"],
        ["\xF3\xB0\x9E\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE6"],
        ["\xF3\xB0\x9E\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE7"],
        ["\xF3\xB0\x9E\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE8"],
        ["\xF3\xB0\x9E\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE9"],
        ["\xF3\xB0\x9E\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xEA"],
        ["\xF3\xB0\x9E\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xEB"],
        ["\xF3\xB0\x9E\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xEC"],
        ["\xF3\xB0\x9E\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xED"],
        ["\xF3\xB0\x9E\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xEE"],
        ["\xF3\xB0\x9E\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xEF"],
        ["\xF3\xB0\x9E\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF0"],
        ["\xF3\xB0\x9E\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF1"],
        ["\xF3\xB0\x9E\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF2"],
        ["\xF3\xB0\x9E\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF3"],
        ["\xF3\xB0\x9E\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF4"],
        ["\xF3\xB0\x9E\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF5"],
        ["\xF3\xB0\x9E\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF6"],
        ["\xF3\xB0\x9E\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF7"],
        ["\xF3\xB0\x9E\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF8"],
        ["\xF3\xB0\x9E\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF9"],
        ["\xF3\xB0\x9E\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xFA"],
        ["\xF3\xB0\x9E\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xFB"],
        ["\xF3\xB0\x9E\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xFC"],
        ["\xF3\xB0\x9E\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x40"],
        ["\xF3\xB0\x9E\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x41"],
        ["\xF3\xB0\x9E\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x42"],
        ["\xF3\xB0\x9E\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x43"],
        ["\xF3\xB0\x9E\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x44"],
        ["\xF3\xB0\x9E\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x45"],
        ["\xF3\xB0\x9E\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x46"],
        ["\xF3\xB0\x9E\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x47"],
        ["\xF3\xB0\x9E\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x48"],
        ["\xF3\xB0\x9E\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x49"],
        ["\xF3\xB0\x9E\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4A"],
        ["\xF3\xB0\x9E\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4B"],
        ["\xF3\xB0\x9E\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4C"],
        ["\xF3\xB0\x9E\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4D"],
        ["\xF3\xB0\x9E\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4E"],
        ["\xF3\xB0\x9E\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4F"],
        ["\xF3\xB0\x9E\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x50"],
        ["\xF3\xB0\x9E\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x51"],
        ["\xF3\xB0\x9E\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x52"],
        ["\xF3\xB0\x9E\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x53"],
        ["\xF3\xB0\x9E\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x54"],
        ["\xF3\xB0\x9E\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x55"],
        ["\xF3\xB0\x9E\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x56"],
        ["\xF3\xB0\x9E\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x57"],
        ["\xF3\xB0\x9E\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x58"],
        ["\xF3\xB0\x9E\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x59"],
        ["\xF3\xB0\x9E\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5A"],
        ["\xF3\xB0\x9E\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5B"],
        ["\xF3\xB0\x9E\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5C"],
        ["\xF3\xB0\x9E\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5D"],
        ["\xF3\xB0\x9E\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5E"],
        ["\xF3\xB0\x9E\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5F"],
        ["\xF3\xB0\x9E\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x60"],
        ["\xF3\xB0\x9E\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x61"],
        ["\xF3\xB0\x9E\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x62"],
        ["\xF3\xB0\x9E\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x63"],
        ["\xF3\xB0\x9F\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x64"],
        ["\xF3\xB0\x9F\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x65"],
        ["\xF3\xB0\x9F\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x66"],
        ["\xF3\xB0\x9F\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x67"],
        ["\xF3\xB0\x9F\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x68"],
        ["\xF3\xB0\x9F\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x69"],
        ["\xF3\xB0\x9F\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6A"],
        ["\xF3\xB0\x9F\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6B"],
        ["\xF3\xB0\x9F\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6C"],
        ["\xF3\xB0\x9F\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6D"],
        ["\xF3\xB0\x9F\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6E"],
        ["\xF3\xB0\x9F\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6F"],
        ["\xF3\xB0\x9F\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x70"],
        ["\xF3\xB0\x9F\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x71"],
        ["\xF3\xB0\x9F\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x72"],
        ["\xF3\xB0\x9F\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x73"],
        ["\xF3\xB0\x9F\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x74"],
        ["\xF3\xB0\x9F\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x75"],
        ["\xF3\xB0\x9F\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x76"],
        ["\xF3\xB0\x9F\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x77"],
        ["\xF3\xB0\x9F\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x78"],
        ["\xF3\xB0\x9F\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x79"],
        ["\xF3\xB0\x9F\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x7A"],
        ["\xF3\xB0\x9F\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x7B"],
        ["\xF3\xB0\x9F\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x7C"],
        ["\xF3\xB0\x9F\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x7D"],
        ["\xF3\xB0\x9F\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x7E"],
        ["\xF3\xB0\x9F\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x80"],
        ["\xF3\xB0\x9F\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x81"],
        ["\xF3\xB0\x9F\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x82"],
        ["\xF3\xB0\x9F\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x83"],
        ["\xF3\xB0\x9F\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x84"],
        ["\xF3\xB0\x9F\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x85"],
        ["\xF3\xB0\x9F\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x86"],
        ["\xF3\xB0\x9F\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x87"],
        ["\xF3\xB0\x9F\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x88"],
        ["\xF3\xB0\x9F\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x89"],
        ["\xF3\xB0\x9F\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8A"],
        ["\xF3\xB0\x9F\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8B"],
        ["\xF3\xB0\x9F\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8C"],
        ["\xF3\xB0\x9F\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8D"],
        ["\xF3\xB0\x9F\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8E"],
        ["\xF3\xB0\x9F\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8F"],
        ["\xF3\xB0\x9F\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x90"],
        ["\xF3\xB0\x9F\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x91"],
        ["\xF3\xB0\x9F\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x92"],
        ["\xF3\xB0\x9F\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x93"],
        ["\xF3\xB0\x9F\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x94"],
        ["\xF3\xB0\x9F\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x95"],
        ["\xF3\xB0\x9F\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x96"],
        ["\xF3\xB0\x9F\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x97"],
        ["\xF3\xB0\x9F\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x98"],
        ["\xF3\xB0\x9F\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x99"],
        ["\xF3\xB0\x9F\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9A"],
        ["\xF3\xB0\x9F\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9B"],
        ["\xF3\xB0\x9F\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9C"],
        ["\xF3\xB0\x9F\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9D"],
        ["\xF3\xB0\x9F\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9E"],
        ["\xF3\xB0\x9F\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9F"],
        ["\xF3\xB0\x9F\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA0"],
        ["\xF3\xB0\x9F\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA1"],
        ["\xF3\xB0\x9F\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA2"],
        ["\xF3\xB0\x9F\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA3"],
        ["\xF3\xB0\x9F\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA4"],
        ["\xF3\xB0\xA0\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA5"],
        ["\xF3\xB0\xA0\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA6"],
        ["\xF3\xB0\xA0\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA7"],
        ["\xF3\xB0\xA0\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA8"],
        ["\xF3\xB0\xA0\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA9"],
        ["\xF3\xB0\xA0\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAA"],
        ["\xF3\xB0\xA0\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAB"],
        ["\xF3\xB0\xA0\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAC"],
        ["\xF3\xB0\xA0\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAD"],
        ["\xF3\xB0\xA0\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAE"],
        ["\xF3\xB0\xA0\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAF"],
        ["\xF3\xB0\xA0\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB0"],
        ["\xF3\xB0\xA0\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB1"],
        ["\xF3\xB0\xA0\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB2"],
        ["\xF3\xB0\xA0\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB3"],
        ["\xF3\xB0\xA0\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB4"],
        ["\xF3\xB0\xA0\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB5"],
        ["\xF3\xB0\xA0\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB6"],
        ["\xF3\xB0\xA0\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB7"],
        ["\xF3\xB0\xA0\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB8"],
        ["\xF3\xB0\xA0\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB9"],
        ["\xF3\xB0\xA0\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBA"],
        ["\xF3\xB0\xA0\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBB"],
        ["\xF3\xB0\xA0\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBC"],
        ["\xF3\xB0\xA0\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBD"],
        ["\xF3\xB0\xA0\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBE"],
        ["\xF3\xB0\xA0\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBF"],
        ["\xF3\xB0\xA0\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC0"],
        ["\xF3\xB0\xA0\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC1"],
        ["\xF3\xB0\xA0\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC2"],
        ["\xF3\xB0\xA0\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC3"],
        ["\xF3\xB0\xA0\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC4"],
        ["\xF3\xB0\xA0\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC5"],
        ["\xF3\xB0\xA0\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC6"],
        ["\xF3\xB0\xA0\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC7"],
        ["\xF3\xB0\xA0\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC8"],
        ["\xF3\xB0\xA0\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC9"],
        ["\xF3\xB0\xA0\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCA"],
        ["\xF3\xB0\xA0\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCB"],
        ["\xF3\xB0\xA0\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCC"],
        ["\xF3\xB0\xA0\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCD"],
        ["\xF3\xB0\xA0\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCE"],
        ["\xF3\xB0\xA0\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCF"],
        ["\xF3\xB0\xA0\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD0"],
        ["\xF3\xB0\xA0\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD1"],
        ["\xF3\xB0\xA0\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD2"],
        ["\xF3\xB0\xA0\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD3"],
        ["\xF3\xB0\xA0\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD4"],
        ["\xF3\xB0\xA0\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD5"],
        ["\xF3\xB0\xA0\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD6"],
        ["\xF3\xB0\xA0\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD7"],
        ["\xF3\xB0\xA0\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD8"],
        ["\xF3\xB0\xA0\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD9"],
        ["\xF3\xB0\xA0\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDA"],
        ["\xF3\xB0\xA0\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDB"],
        ["\xF3\xB0\xA0\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDC"],
        ["\xF3\xB0\xA0\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDD"],
        ["\xF3\xB0\xA0\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDE"],
        ["\xF3\xB0\xA0\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDF"],
        ["\xF3\xB0\xA0\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE0"],
        ["\xF3\xB0\xA0\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE1"],
        ["\xF3\xB0\xA0\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE2"],
        ["\xF3\xB0\xA0\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE3"],
        ["\xF3\xB0\xA0\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE4"],
        ["\xF3\xB0\xA1\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE5"],
        ["\xF3\xB0\xA1\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE6"],
        ["\xF3\xB0\xA1\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE7"],
        ["\xF3\xB0\xA1\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE8"],
        ["\xF3\xB0\xA1\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE9"],
        ["\xF3\xB0\xA1\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEA"],
        ["\xF3\xB0\xA1\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEB"],
        ["\xF3\xB0\xA1\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEC"],
        ["\xF3\xB0\xA1\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xED"],
        ["\xF3\xB0\xA1\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEE"],
        ["\xF3\xB0\xA1\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEF"],
        ["\xF3\xB0\xA1\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF0"],
        ["\xF3\xB0\xA1\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF1"],
        ["\xF3\xB0\xA1\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF2"],
        ["\xF3\xB0\xA1\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF3"],
        ["\xF3\xB0\xA1\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF4"],
        ["\xF3\xB0\xA1\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF5"],
        ["\xF3\xB0\xA1\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF6"],
        ["\xF3\xB0\xA1\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF7"],
        ["\xF3\xB0\xA1\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF8"],
        ["\xF3\xB0\xA1\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF9"],
        ["\xF3\xB0\xA1\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xFA"],
        ["\xF3\xB0\xA1\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xFB"],
        ["\xF3\xB0\xA1\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xFC"],
        ["\xF3\xB0\xA1\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x40"],
        ["\xF3\xB0\xA1\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x41"],
        ["\xF3\xB0\xA1\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x42"],
        ["\xF3\xB0\xA1\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x43"],
        ["\xF3\xB0\xA1\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x44"],
        ["\xF3\xB0\xA1\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x45"],
        ["\xF3\xB0\xA1\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x46"],
        ["\xF3\xB0\xA1\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x47"],
        ["\xF3\xB0\xA1\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x48"],
        ["\xF3\xB0\xA1\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x49"],
        ["\xF3\xB0\xA1\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4A"],
        ["\xF3\xB0\xA1\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4B"],
        ["\xF3\xB0\xA1\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4C"],
        ["\xF3\xB0\xA1\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4D"],
        ["\xF3\xB0\xA1\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4E"],
        ["\xF3\xB0\xA1\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4F"],
        ["\xF3\xB0\xA1\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x50"],
        ["\xF3\xB0\xA1\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x51"],
        ["\xF3\xB0\xA1\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x52"],
        ["\xF3\xB0\xA1\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x53"],
        ["\xF3\xB0\xA1\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x54"],
        ["\xF3\xB0\xA1\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x55"],
        ["\xF3\xB0\xA1\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x56"],
        ["\xF3\xB0\xA1\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x57"],
        ["\xF3\xB0\xA1\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x58"],
        ["\xF3\xB0\xA1\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x59"],
        ["\xF3\xB0\xA1\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5A"],
        ["\xF3\xB0\xA1\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5B"],
        ["\xF3\xB0\xA1\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5C"],
        ["\xF3\xB0\xA1\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5D"],
        ["\xF3\xB0\xA1\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5E"],
        ["\xF3\xB0\xA1\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5F"],
        ["\xF3\xB0\xA1\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x60"],
        ["\xF3\xB0\xA1\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x61"],
        ["\xF3\xB0\xA1\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x62"],
        ["\xF3\xB0\xA1\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x63"],
        ["\xF3\xB0\xA1\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x64"],
        ["\xF3\xB0\xA1\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x65"],
        ["\xF3\xB0\xA1\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x66"],
        ["\xF3\xB0\xA1\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x67"],
        ["\xF3\xB0\xA2\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x68"],
        ["\xF3\xB0\xA2\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x69"],
        ["\xF3\xB0\xA2\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6A"],
        ["\xF3\xB0\xA2\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6B"],
        ["\xF3\xB0\xA2\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6C"],
        ["\xF3\xB0\xA2\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6D"],
        ["\xF3\xB0\xA2\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6E"],
        ["\xF3\xB0\xA2\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6F"],
        ["\xF3\xB0\xA2\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x70"],
        ["\xF3\xB0\xA2\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x71"],
        ["\xF3\xB0\xA2\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x72"],
        ["\xF3\xB0\xA2\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x73"],
        ["\xF3\xB0\xA2\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x74"],
        ["\xF3\xB0\xA2\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x75"],
        ["\xF3\xB0\xA2\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x76"],
        ["\xF3\xB0\xA2\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x77"],
        ["\xF3\xB0\xA2\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x78"],
        ["\xF3\xB0\xA2\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x79"],
        ["\xF3\xB0\xA2\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x7A"],
        ["\xF3\xB0\xA2\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x7B"],
        ["\xF3\xB0\xA2\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x7C"],
        ["\xF3\xB0\xA2\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x7D"],
        ["\xF3\xB0\xA2\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x7E"],
        ["\xF3\xB0\xA2\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x80"],
        ["\xF3\xB0\xA2\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x81"],
        ["\xF3\xB0\xA2\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x82"],
        ["\xF3\xB0\xA2\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x83"],
        ["\xF3\xB0\xA2\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x84"],
        ["\xF3\xB0\xA2\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x85"],
        ["\xF3\xB0\xA2\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x86"],
        ["\xF3\xB0\xA2\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x87"],
        ["\xF3\xB0\xA2\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x88"],
        ["\xF3\xB0\xA2\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x89"],
        ["\xF3\xB0\xA2\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8A"],
        ["\xF3\xB0\xA2\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8B"],
        ["\xF3\xB0\xA2\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8C"],
        ["\xF3\xB0\xA2\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8D"],
        ["\xF3\xB0\xA2\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8E"],
        ["\xF3\xB0\xA2\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8F"],
        ["\xF3\xB0\xA2\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x90"],
        ["\xF3\xB0\xA2\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x91"],
        ["\xF3\xB0\xA2\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x92"],
        ["\xF3\xB0\xA2\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x93"],
        ["\xF3\xB0\xA2\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x94"],
        ["\xF3\xB0\xA2\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x95"],
        ["\xF3\xB0\xA2\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x96"],
        ["\xF3\xB0\xA2\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x97"],
        ["\xF3\xB0\xA2\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x98"],
        ["\xF3\xB0\xA2\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x99"],
        ["\xF3\xB0\xA2\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9A"],
        ["\xF3\xB0\xA2\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9B"],
        ["\xF3\xB0\xA2\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9C"],
        ["\xF3\xB0\xA2\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9D"],
        ["\xF3\xB0\xA2\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9E"],
        ["\xF3\xB0\xA2\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9F"],
        ["\xF3\xB0\xA2\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA0"],
        ["\xF3\xB0\xA2\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA1"],
        ["\xF3\xB0\xA2\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA2"],
        ["\xF3\xB0\xA2\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA3"],
        ["\xF3\xB0\xA2\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA4"],
        ["\xF3\xB0\xA2\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA5"],
        ["\xF3\xB0\xA2\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA6"],
        ["\xF3\xB0\xA2\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA7"],
        ["\xF3\xB0\xA2\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA8"],
        ["\xF3\xB0\xA3\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA9"],
        ["\xF3\xB0\xA3\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAA"],
        ["\xF3\xB0\xA3\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAB"],
        ["\xF3\xB0\xA3\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAC"],
        ["\xF3\xB0\xA3\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAD"],
        ["\xF3\xB0\xA3\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAE"],
        ["\xF3\xB0\xA3\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAF"],
        ["\xF3\xB0\xA3\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB0"],
        ["\xF3\xB0\xA3\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB1"],
        ["\xF3\xB0\xA3\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB2"],
        ["\xF3\xB0\xA3\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB3"],
        ["\xF3\xB0\xA3\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB4"],
        ["\xF3\xB0\xA3\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB5"],
        ["\xF3\xB0\xA3\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB6"],
        ["\xF3\xB0\xA3\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB7"],
        ["\xF3\xB0\xA3\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB8"],
        ["\xF3\xB0\xA3\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB9"],
        ["\xF3\xB0\xA3\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBA"],
        ["\xF3\xB0\xA3\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBB"],
        ["\xF3\xB0\xA3\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBC"],
        ["\xF3\xB0\xA3\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBD"],
        ["\xF3\xB0\xA3\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBE"],
        ["\xF3\xB0\xA3\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBF"],
        ["\xF3\xB0\xA3\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC0"],
        ["\xF3\xB0\xA3\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC1"],
        ["\xF3\xB0\xA3\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC2"],
        ["\xF3\xB0\xA3\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC3"],
        ["\xF3\xB0\xA3\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC4"],
        ["\xF3\xB0\xA3\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC5"],
        ["\xF3\xB0\xA3\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC6"],
        ["\xF3\xB0\xA3\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC7"],
        ["\xF3\xB0\xA3\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC8"],
        ["\xF3\xB0\xA3\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC9"],
        ["\xF3\xB0\xA3\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCA"],
        ["\xF3\xB0\xA3\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCB"],
        ["\xF3\xB0\xA3\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCC"],
        ["\xF3\xB0\xA3\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCD"],
        ["\xF3\xB0\xA3\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCE"],
        ["\xF3\xB0\xA3\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCF"],
        ["\xF3\xB0\xA3\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD0"],
        ["\xF3\xB0\xA3\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD1"],
        ["\xF3\xB0\xA3\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD2"],
        ["\xF3\xB0\xA3\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD3"],
        ["\xF3\xB0\xA3\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD4"],
        ["\xF3\xB0\xA3\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD5"],
        ["\xF3\xB0\xA3\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD6"],
        ["\xF3\xB0\xA3\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD7"],
        ["\xF3\xB0\xA3\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD8"],
        ["\xF3\xB0\xA3\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD9"],
        ["\xF3\xB0\xA3\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDA"],
        ["\xF3\xB0\xA3\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDB"],
        ["\xF3\xB0\xA3\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDC"],
        ["\xF3\xB0\xA3\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDD"],
        ["\xF3\xB0\xA3\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDE"],
        ["\xF3\xB0\xA3\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDF"],
        ["\xF3\xB0\xA3\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE0"],
        ["\xF3\xB0\xA3\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE1"],
        ["\xF3\xB0\xA3\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE2"],
        ["\xF3\xB0\xA3\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE3"],
        ["\xF3\xB0\xA3\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE4"],
        ["\xF3\xB0\xA3\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE5"],
        ["\xF3\xB0\xA3\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE6"],
        ["\xF3\xB0\xA3\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE7"],
        ["\xF3\xB0\xA3\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE8"],
        ["\xF3\xB0\xA4\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE9"],
        ["\xF3\xB0\xA4\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xEA"],
        ["\xF3\xB0\xA4\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xEB"],
        ["\xF3\xB0\xA4\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xEC"],
        ["\xF3\xB0\xA4\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xED"],
        ["\xF3\xB0\xA4\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xEE"],
        ["\xF3\xB0\xA4\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xEF"],
        ["\xF3\xB0\xA4\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF0"],
        ["\xF3\xB0\xA4\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF1"],
        ["\xF3\xB0\xA4\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF2"],
        ["\xF3\xB0\xA4\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF3"],
        ["\xF3\xB0\xA4\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF4"],
        ["\xF3\xB0\xA4\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF5"],
        ["\xF3\xB0\xA4\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF6"],
        ["\xF3\xB0\xA4\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF7"],
        ["\xF3\xB0\xA4\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF8"],
        ["\xF3\xB0\xA4\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF9"],
        ["\xF3\xB0\xA4\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xFA"],
        ["\xF3\xB0\xA4\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xFB"],
        ["\xF3\xB0\xA4\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xFC"],
        ["\xF3\xB0\xA4\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x40"],
        ["\xF3\xB0\xA4\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x41"],
        ["\xF3\xB0\xA4\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x42"],
        ["\xF3\xB0\xA4\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x43"],
        ["\xF3\xB0\xA4\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x44"],
        ["\xF3\xB0\xA4\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x45"],
        ["\xF3\xB0\xA4\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x46"],
        ["\xF3\xB0\xA4\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x47"],
        ["\xF3\xB0\xA4\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x48"],
        ["\xF3\xB0\xA4\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x49"],
        ["\xF3\xB0\xA4\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4A"],
        ["\xF3\xB0\xA4\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4B"],
        ["\xF3\xB0\xA4\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4C"],
        ["\xF3\xB0\xA4\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4D"],
        ["\xF3\xB0\xA4\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4E"],
        ["\xF3\xB0\xA4\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4F"],
        ["\xF3\xB0\xA4\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x50"],
        ["\xF3\xB0\xA4\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x51"],
        ["\xF3\xB0\xA4\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x52"],
        ["\xF3\xB0\xA4\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x53"],
        ["\xF3\xB0\xA4\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x54"],
        ["\xF3\xB0\xA4\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x55"],
        ["\xF3\xB0\xA4\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x56"],
        ["\xF3\xB0\xA4\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x57"],
        ["\xF3\xB0\xA4\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x58"],
        ["\xF3\xB0\xA4\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x59"],
        ["\xF3\xB0\xA4\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5A"],
        ["\xF3\xB0\xA4\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5B"],
        ["\xF3\xB0\xA4\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5C"],
        ["\xF3\xB0\xA4\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5D"],
        ["\xF3\xB0\xA4\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5E"],
        ["\xF3\xB0\xA4\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5F"],
        ["\xF3\xB0\xA4\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x60"],
        ["\xF3\xB0\xA4\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x61"],
        ["\xF3\xB0\xA4\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x62"],
        ["\xF3\xB0\xA4\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x63"],
        ["\xF3\xB0\xA4\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x64"],
        ["\xF3\xB0\xA4\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x65"],
        ["\xF3\xB0\xA4\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x66"],
        ["\xF3\xB0\xA4\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x67"],
        ["\xF3\xB0\xA4\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x68"],
        ["\xF3\xB0\xA4\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x69"],
        ["\xF3\xB0\xA4\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6A"],
        ["\xF3\xB0\xA4\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6B"],
        ["\xF3\xB0\xA5\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6C"],
        ["\xF3\xB0\xA5\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6D"],
        ["\xF3\xB0\xA5\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6E"],
        ["\xF3\xB0\xA5\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6F"],
        ["\xF3\xB0\xA5\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x70"],
        ["\xF3\xB0\xA5\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x71"],
        ["\xF3\xB0\xA5\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x72"],
        ["\xF3\xB0\xA5\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x73"],
        ["\xF3\xB0\xA5\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x74"],
        ["\xF3\xB0\xA5\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x75"],
        ["\xF3\xB0\xA5\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x76"],
        ["\xF3\xB0\xA5\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x77"],
        ["\xF3\xB0\xA5\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x78"],
        ["\xF3\xB0\xA5\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x79"],
        ["\xF3\xB0\xA5\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x7A"],
        ["\xF3\xB0\xA5\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x7B"],
        ["\xF3\xB0\xA5\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x7C"],
        ["\xF3\xB0\xA5\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x7D"],
        ["\xF3\xB0\xA5\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x7E"],
        ["\xF3\xB0\xA5\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x80"],
        ["\xF3\xB0\xA5\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x81"],
        ["\xF3\xB0\xA5\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x82"],
        ["\xF3\xB0\xA5\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x83"],
        ["\xF3\xB0\xA5\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x84"],
        ["\xF3\xB0\xA5\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x85"],
        ["\xF3\xB0\xA5\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x86"],
        ["\xF3\xB0\xA5\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x87"],
        ["\xF3\xB0\xA5\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x88"],
        ["\xF3\xB0\xA5\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x89"],
        ["\xF3\xB0\xA5\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8A"],
        ["\xF3\xB0\xA5\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8B"],
        ["\xF3\xB0\xA5\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8C"],
        ["\xF3\xB0\xA5\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8D"],
        ["\xF3\xB0\xA5\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8E"],
        ["\xF3\xB0\xA5\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8F"],
        ["\xF3\xB0\xA5\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x90"],
        ["\xF3\xB0\xA5\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x91"],
        ["\xF3\xB0\xA5\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x92"],
        ["\xF3\xB0\xA5\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x93"],
        ["\xF3\xB0\xA5\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x94"],
        ["\xF3\xB0\xA5\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x95"],
        ["\xF3\xB0\xA5\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x96"],
        ["\xF3\xB0\xA5\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x97"],
        ["\xF3\xB0\xA5\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x98"],
        ["\xF3\xB0\xA5\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x99"],
        ["\xF3\xB0\xA5\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9A"],
        ["\xF3\xB0\xA5\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9B"],
        ["\xF3\xB0\xA5\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9C"],
        ["\xF3\xB0\xA5\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9D"],
        ["\xF3\xB0\xA5\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9E"],
        ["\xF3\xB0\xA5\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9F"],
        ["\xF3\xB0\xA5\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA0"],
        ["\xF3\xB0\xA5\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA1"],
        ["\xF3\xB0\xA5\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA2"],
        ["\xF3\xB0\xA5\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA3"],
        ["\xF3\xB0\xA5\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA4"],
        ["\xF3\xB0\xA5\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA5"],
        ["\xF3\xB0\xA5\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA6"],
        ["\xF3\xB0\xA5\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA7"],
        ["\xF3\xB0\xA5\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA8"],
        ["\xF3\xB0\xA5\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA9"],
        ["\xF3\xB0\xA5\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAA"],
        ["\xF3\xB0\xA5\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAB"],
        ["\xF3\xB0\xA5\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAC"],
        ["\xF3\xB0\xA6\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAD"],
        ["\xF3\xB0\xA6\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAE"],
        ["\xF3\xB0\xA6\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAF"],
        ["\xF3\xB0\xA6\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB0"],
        ["\xF3\xB0\xA6\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB1"],
        ["\xF3\xB0\xA6\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB2"],
        ["\xF3\xB0\xA6\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB3"],
        ["\xF3\xB0\xA6\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB4"],
        ["\xF3\xB0\xA6\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB5"],
        ["\xF3\xB0\xA6\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB6"],
        ["\xF3\xB0\xA6\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB7"],
        ["\xF3\xB0\xA6\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB8"],
        ["\xF3\xB0\xA6\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB9"],
        ["\xF3\xB0\xA6\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBA"],
        ["\xF3\xB0\xA6\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBB"],
        ["\xF3\xB0\xA6\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBC"],
        ["\xF3\xB0\xA6\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBD"],
        ["\xF3\xB0\xA6\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBE"],
        ["\xF3\xB0\xA6\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBF"],
        ["\xF3\xB0\xA6\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC0"],
        ["\xF3\xB0\xA6\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC1"],
        ["\xF3\xB0\xA6\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC2"],
        ["\xF3\xB0\xA6\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC3"],
        ["\xF3\xB0\xA6\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC4"],
        ["\xF3\xB0\xA6\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC5"],
        ["\xF3\xB0\xA6\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC6"],
        ["\xF3\xB0\xA6\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC7"],
        ["\xF3\xB0\xA6\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC8"],
        ["\xF3\xB0\xA6\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC9"],
        ["\xF3\xB0\xA6\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCA"],
        ["\xF3\xB0\xA6\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCB"],
        ["\xF3\xB0\xA6\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCC"],
        ["\xF3\xB0\xA6\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCD"],
        ["\xF3\xB0\xA6\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCE"],
        ["\xF3\xB0\xA6\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCF"],
        ["\xF3\xB0\xA6\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD0"],
        ["\xF3\xB0\xA6\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD1"],
        ["\xF3\xB0\xA6\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD2"],
        ["\xF3\xB0\xA6\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD3"],
        ["\xF3\xB0\xA6\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD4"],
        ["\xF3\xB0\xA6\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD5"],
        ["\xF3\xB0\xA6\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD6"],
        ["\xF3\xB0\xA6\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD7"],
        ["\xF3\xB0\xA6\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD8"],
        ["\xF3\xB0\xA6\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD9"],
        ["\xF3\xB0\xA6\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDA"],
        ["\xF3\xB0\xA6\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDB"],
        ["\xF3\xB0\xA6\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDC"],
        ["\xF3\xB0\xA6\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDD"],
        ["\xF3\xB0\xA6\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDE"],
        ["\xF3\xB0\xA6\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDF"],
        ["\xF3\xB0\xA6\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE0"],
        ["\xF3\xB0\xA6\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE1"],
        ["\xF3\xB0\xA6\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE2"],
        ["\xF3\xB0\xA6\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE3"],
        ["\xF3\xB0\xA6\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE4"],
        ["\xF3\xB0\xA6\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE5"],
        ["\xF3\xB0\xA6\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE6"],
        ["\xF3\xB0\xA6\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE7"],
        ["\xF3\xB0\xA6\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE8"],
        ["\xF3\xB0\xA6\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE9"],
        ["\xF3\xB0\xA6\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xEA"],
        ["\xF3\xB0\xA6\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xEB"],
        ["\xF3\xB0\xA6\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xEC"],
        ["\xF3\xB0\xA7\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xED"],
        ["\xF3\xB0\xA7\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xEE"],
        ["\xF3\xB0\xA7\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xEF"],
        ["\xF3\xB0\xA7\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF0"],
        ["\xF3\xB0\xA7\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF1"],
        ["\xF3\xB0\xA7\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF2"],
        ["\xF3\xB0\xA7\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF3"],
        ["\xF3\xB0\xA7\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF4"],
        ["\xF3\xB0\xA7\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF5"],
        ["\xF3\xB0\xA7\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF6"],
        ["\xF3\xB0\xA7\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF7"],
        ["\xF3\xB0\xA7\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF8"],
        ["\xF3\xB0\xA7\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF9"],
        ["\xF3\xB0\xA7\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xFA"],
        ["\xF3\xB0\xA7\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xFB"],
        ["\xF3\xB0\xA7\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xFC"],
        ["\xF3\xB0\xA7\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x40"],
        ["\xF3\xB0\xA7\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x41"],
        ["\xF3\xB0\xA7\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x42"],
        ["\xF3\xB0\xA7\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x43"],
        ["\xF3\xB0\xA7\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x44"],
        ["\xF3\xB0\xA7\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x45"],
        ["\xF3\xB0\xA7\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x46"],
        ["\xF3\xB0\xA7\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x47"],
        ["\xF3\xB0\xA7\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x48"],
        ["\xF3\xB0\xA7\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x49"],
        ["\xF3\xB0\xA7\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4A"],
        ["\xF3\xB0\xA7\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4B"],
        ["\xF3\xB0\xA7\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4C"],
        ["\xF3\xB0\xA7\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4D"],
        ["\xF3\xB0\xA7\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4E"],
        ["\xF3\xB0\xA7\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4F"],
        ["\xF3\xB0\xA7\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x50"],
        ["\xF3\xB0\xA7\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x51"],
        ["\xF3\xB0\xA7\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x52"],
        ["\xF3\xB0\xA7\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x53"],
        ["\xF3\xB0\xA7\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x54"],
        ["\xF3\xB0\xA7\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x55"],
        ["\xF3\xB0\xA7\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x56"],
        ["\xF3\xB0\xA7\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x57"],
        ["\xF3\xB0\xA7\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x58"],
        ["\xF3\xB0\xA7\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x59"],
        ["\xF3\xB0\xA7\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5A"],
        ["\xF3\xB0\xA7\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5B"],
        ["\xF3\xB0\xA7\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5C"],
        ["\xF3\xB0\xA7\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5D"],
        ["\xF3\xB0\xA7\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5E"],
        ["\xF3\xB0\xA7\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5F"],
        ["\xF3\xB0\xA7\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x60"],
        ["\xF3\xB0\xA7\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x61"],
        ["\xF3\xB0\xA7\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x62"],
        ["\xF3\xB0\xA7\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x63"],
        ["\xF3\xB0\xA7\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x64"],
        ["\xF3\xB0\xA7\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x65"],
        ["\xF3\xB0\xA7\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x66"],
        ["\xF3\xB0\xA7\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x67"],
        ["\xF3\xB0\xA7\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x68"],
        ["\xF3\xB0\xA7\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x69"],
        ["\xF3\xB0\xA7\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6A"],
        ["\xF3\xB0\xA7\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6B"],
        ["\xF3\xB0\xA7\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6C"],
        ["\xF3\xB0\xA7\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6D"],
        ["\xF3\xB0\xA7\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6E"],
        ["\xF3\xB0\xA7\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6F"],
        ["\xF3\xB0\xA8\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x70"],
        ["\xF3\xB0\xA8\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x71"],
        ["\xF3\xB0\xA8\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x72"],
        ["\xF3\xB0\xA8\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x73"],
        ["\xF3\xB0\xA8\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x74"],
        ["\xF3\xB0\xA8\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x75"],
        ["\xF3\xB0\xA8\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x76"],
        ["\xF3\xB0\xA8\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x77"],
        ["\xF3\xB0\xA8\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x78"],
        ["\xF3\xB0\xA8\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x79"],
        ["\xF3\xB0\xA8\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x7A"],
        ["\xF3\xB0\xA8\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x7B"],
        ["\xF3\xB0\xA8\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x7C"],
        ["\xF3\xB0\xA8\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x7D"],
        ["\xF3\xB0\xA8\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x7E"],
        ["\xF3\xB0\xA8\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x80"],
        ["\xF3\xB0\xA8\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x81"],
        ["\xF3\xB0\xA8\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x82"],
        ["\xF3\xB0\xA8\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x83"],
        ["\xF3\xB0\xA8\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x84"],
        ["\xF3\xB0\xA8\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x85"],
        ["\xF3\xB0\xA8\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x86"],
        ["\xF3\xB0\xA8\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x87"],
        ["\xF3\xB0\xA8\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x88"],
        ["\xF3\xB0\xA8\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x89"],
        ["\xF3\xB0\xA8\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8A"],
        ["\xF3\xB0\xA8\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8B"],
        ["\xF3\xB0\xA8\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8C"],
        ["\xF3\xB0\xA8\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8D"],
        ["\xF3\xB0\xA8\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8E"],
        ["\xF3\xB0\xA8\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8F"],
        ["\xF3\xB0\xA8\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x90"],
        ["\xF3\xB0\xA8\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x91"],
        ["\xF3\xB0\xA8\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x92"],
        ["\xF3\xB0\xA8\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x93"],
        ["\xF3\xB0\xA8\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x94"],
        ["\xF3\xB0\xA8\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x95"],
        ["\xF3\xB0\xA8\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x96"],
        ["\xF3\xB0\xA8\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x97"],
        ["\xF3\xB0\xA8\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x98"],
        ["\xF3\xB0\xA8\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x99"],
        ["\xF3\xB0\xA8\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9A"],
        ["\xF3\xB0\xA8\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9B"],
        ["\xF3\xB0\xA8\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9C"],
        ["\xF3\xB0\xA8\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9D"],
        ["\xF3\xB0\xA8\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9E"],
        ["\xF3\xB0\xA8\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9F"],
        ["\xF3\xB0\xA8\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA0"],
        ["\xF3\xB0\xA8\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA1"],
        ["\xF3\xB0\xA8\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA2"],
        ["\xF3\xB0\xA8\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA3"],
        ["\xF3\xB0\xA8\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA4"],
        ["\xF3\xB0\xA8\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA5"],
        ["\xF3\xB0\xA8\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA6"],
        ["\xF3\xB0\xA8\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA7"],
        ["\xF3\xB0\xA8\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA8"],
        ["\xF3\xB0\xA8\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA9"],
        ["\xF3\xB0\xA8\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAA"],
        ["\xF3\xB0\xA8\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAB"],
        ["\xF3\xB0\xA8\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAC"],
        ["\xF3\xB0\xA8\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAD"],
        ["\xF3\xB0\xA8\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAE"],
        ["\xF3\xB0\xA8\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAF"],
        ["\xF3\xB0\xA8\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB0"],
        ["\xF3\xB0\xA9\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB1"],
        ["\xF3\xB0\xA9\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB2"],
        ["\xF3\xB0\xA9\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB3"],
        ["\xF3\xB0\xA9\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB4"],
        ["\xF3\xB0\xA9\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB5"],
        ["\xF3\xB0\xA9\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB6"],
        ["\xF3\xB0\xA9\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB7"],
        ["\xF3\xB0\xA9\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB8"],
        ["\xF3\xB0\xA9\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB9"],
        ["\xF3\xB0\xA9\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBA"],
        ["\xF3\xB0\xA9\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBB"],
        ["\xF3\xB0\xA9\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBC"],
        ["\xF3\xB0\xA9\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBD"],
        ["\xF3\xB0\xA9\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBE"],
        ["\xF3\xB0\xA9\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBF"],
        ["\xF3\xB0\xA9\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC0"],
        ["\xF3\xB0\xA9\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC1"],
        ["\xF3\xB0\xA9\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC2"],
        ["\xF3\xB0\xA9\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC3"],
        ["\xF3\xB0\xA9\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC4"],
        ["\xF3\xB0\xA9\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC5"],
        ["\xF3\xB0\xA9\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC6"],
        ["\xF3\xB0\xA9\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC7"],
        ["\xF3\xB0\xA9\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC8"],
        ["\xF3\xB0\xA9\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC9"],
        ["\xF3\xB0\xA9\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCA"],
        ["\xF3\xB0\xA9\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCB"],
        ["\xF3\xB0\xA9\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCC"],
        ["\xF3\xB0\xA9\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCD"],
        ["\xF3\xB0\xA9\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCE"],
        ["\xF3\xB0\xA9\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCF"],
        ["\xF3\xB0\xA9\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD0"],
        ["\xF3\xB0\xA9\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD1"],
        ["\xF3\xB0\xA9\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD2"],
        ["\xF3\xB0\xA9\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD3"],
        ["\xF3\xB0\xA9\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD4"],
        ["\xF3\xB0\xA9\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD5"],
        ["\xF3\xB0\xA9\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD6"],
        ["\xF3\xB0\xA9\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD7"],
        ["\xF3\xB0\xA9\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD8"],
        ["\xF3\xB0\xA9\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD9"],
        ["\xF3\xB0\xA9\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDA"],
        ["\xF3\xB0\xA9\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDB"],
        ["\xF3\xB0\xA9\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDC"],
        ["\xF3\xB0\xA9\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDD"],
        ["\xF3\xB0\xA9\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDE"],
        ["\xF3\xB0\xA9\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDF"],
        ["\xF3\xB0\xA9\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE0"],
        ["\xF3\xB0\xA9\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE1"],
        ["\xF3\xB0\xA9\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE2"],
        ["\xF3\xB0\xA9\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE3"],
        ["\xF3\xB0\xA9\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE4"],
        ["\xF3\xB0\xA9\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE5"],
        ["\xF3\xB0\xA9\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE6"],
        ["\xF3\xB0\xA9\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE7"],
        ["\xF3\xB0\xA9\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE8"],
        ["\xF3\xB0\xA9\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE9"],
        ["\xF3\xB0\xA9\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEA"],
        ["\xF3\xB0\xA9\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEB"],
        ["\xF3\xB0\xA9\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEC"],
        ["\xF3\xB0\xA9\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xED"],
        ["\xF3\xB0\xA9\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEE"],
        ["\xF3\xB0\xA9\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEF"],
        ["\xF3\xB0\xA9\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF0"],
        ["\xF3\xB0\xAA\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF1"],
        ["\xF3\xB0\xAA\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF2"],
        ["\xF3\xB0\xAA\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF3"],
        ["\xF3\xB0\xAA\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF4"],
        ["\xF3\xB0\xAA\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF5"],
        ["\xF3\xB0\xAA\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF6"],
        ["\xF3\xB0\xAA\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF7"],
        ["\xF3\xB0\xAA\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF8"],
        ["\xF3\xB0\xAA\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF9"],
        ["\xF3\xB0\xAA\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xFA"],
        ["\xF3\xB0\xAA\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xFB"],
        ["\xF3\xB0\xAA\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xFC"],
        ["\xF3\xB0\xAA\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x40"],
        ["\xF3\xB0\xAA\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x41"],
        ["\xF3\xB0\xAA\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x42"],
        ["\xF3\xB0\xAA\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x43"],
        ["\xF3\xB0\xAA\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x44"],
        ["\xF3\xB0\xAA\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x45"],
        ["\xF3\xB0\xAA\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x46"],
        ["\xF3\xB0\xAA\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x47"],
        ["\xF3\xB0\xAA\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x48"],
        ["\xF3\xB0\xAA\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x49"],
        ["\xF3\xB0\xAA\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4A"],
        ["\xF3\xB0\xAA\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4B"],
        ["\xF3\xB0\xAA\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4C"],
        ["\xF3\xB0\xAA\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4D"],
        ["\xF3\xB0\xAA\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4E"],
        ["\xF3\xB0\xAA\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4F"],
        ["\xF3\xB0\xAA\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x50"],
        ["\xF3\xB0\xAA\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x51"],
        ["\xF3\xB0\xAA\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x52"],
        ["\xF3\xB0\xAA\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x53"],
        ["\xF3\xB0\xAA\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x54"],
        ["\xF3\xB0\xAA\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x55"],
        ["\xF3\xB0\xAA\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x56"],
        ["\xF3\xB0\xAA\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x57"],
        ["\xF3\xB0\xAA\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x58"],
        ["\xF3\xB0\xAA\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x59"],
        ["\xF3\xB0\xAA\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5A"],
        ["\xF3\xB0\xAA\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5B"],
        ["\xF3\xB0\xAA\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5C"],
        ["\xF3\xB0\xAA\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5D"],
        ["\xF3\xB0\xAA\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5E"],
        ["\xF3\xB0\xAA\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5F"],
        ["\xF3\xB0\xAA\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x60"],
        ["\xF3\xB0\xAA\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x61"],
        ["\xF3\xB0\xAA\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x62"],
        ["\xF3\xB0\xAA\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x63"],
        ["\xF3\xB0\xAA\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x64"],
        ["\xF3\xB0\xAA\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x65"],
        ["\xF3\xB0\xAA\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x66"],
        ["\xF3\xB0\xAA\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x67"],
        ["\xF3\xB0\xAA\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x68"],
        ["\xF3\xB0\xAA\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x69"],
        ["\xF3\xB0\xAA\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6A"],
        ["\xF3\xB0\xAA\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6B"],
        ["\xF3\xB0\xAA\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6C"],
        ["\xF3\xB0\xAA\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6D"],
        ["\xF3\xB0\xAA\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6E"],
        ["\xF3\xB0\xAA\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6F"],
        ["\xF3\xB0\xAA\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x70"],
        ["\xF3\xB0\xAA\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x71"],
        ["\xF3\xB0\xAA\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x72"],
        ["\xF3\xB0\xAA\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x73"],
        ["\xF3\xB0\xAB\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x74"],
        ["\xF3\xB0\xAB\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x75"],
        ["\xF3\xB0\xAB\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x76"],
        ["\xF3\xB0\xAB\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x77"],
        ["\xF3\xB0\xAB\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x78"],
        ["\xF3\xB0\xAB\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x79"],
        ["\xF3\xB0\xAB\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x7A"],
        ["\xF3\xB0\xAB\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x7B"],
        ["\xF3\xB0\xAB\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x7C"],
        ["\xF3\xB0\xAB\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x7D"],
        ["\xF3\xB0\xAB\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x7E"],
        ["\xF3\xB0\xAB\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x80"],
        ["\xF3\xB0\xAB\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x81"],
        ["\xF3\xB0\xAB\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x82"],
        ["\xF3\xB0\xAB\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x83"],
        ["\xF3\xB0\xAB\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x84"],
        ["\xF3\xB0\xAB\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x85"],
        ["\xF3\xB0\xAB\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x86"],
        ["\xF3\xB0\xAB\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x87"],
        ["\xF3\xB0\xAB\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x88"],
        ["\xF3\xB0\xAB\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x89"],
        ["\xF3\xB0\xAB\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8A"],
        ["\xF3\xB0\xAB\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8B"],
        ["\xF3\xB0\xAB\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8C"],
        ["\xF3\xB0\xAB\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8D"],
        ["\xF3\xB0\xAB\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8E"],
        ["\xF3\xB0\xAB\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8F"],
        ["\xF3\xB0\xAB\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x90"],
        ["\xF3\xB0\xAB\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x91"],
        ["\xF3\xB0\xAB\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x92"],
        ["\xF3\xB0\xAB\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x93"],
        ["\xF3\xB0\xAB\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x94"],
        ["\xF3\xB0\xAB\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x95"],
        ["\xF3\xB0\xAB\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x96"],
        ["\xF3\xB0\xAB\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x97"],
        ["\xF3\xB0\xAB\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x98"],
        ["\xF3\xB0\xAB\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x99"],
        ["\xF3\xB0\xAB\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9A"],
        ["\xF3\xB0\xAB\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9B"],
        ["\xF3\xB0\xAB\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9C"],
        ["\xF3\xB0\xAB\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9D"],
        ["\xF3\xB0\xAB\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9E"],
        ["\xF3\xB0\xAB\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9F"],
        ["\xF3\xB0\xAB\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA0"],
        ["\xF3\xB0\xAB\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA1"],
        ["\xF3\xB0\xAB\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA2"],
        ["\xF3\xB0\xAB\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA3"],
        ["\xF3\xB0\xAB\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA4"],
        ["\xF3\xB0\xAB\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA5"],
        ["\xF3\xB0\xAB\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA6"],
        ["\xF3\xB0\xAB\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA7"],
        ["\xF3\xB0\xAB\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA8"],
        ["\xF3\xB0\xAB\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA9"],
        ["\xF3\xB0\xAB\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAA"],
        ["\xF3\xB0\xAB\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAB"],
        ["\xF3\xB0\xAB\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAC"],
        ["\xF3\xB0\xAB\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAD"],
        ["\xF3\xB0\xAB\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAE"],
        ["\xF3\xB0\xAB\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAF"],
        ["\xF3\xB0\xAB\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB0"],
        ["\xF3\xB0\xAB\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB1"],
        ["\xF3\xB0\xAB\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB2"],
        ["\xF3\xB0\xAB\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB3"],
        ["\xF3\xB0\xAB\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB4"],
        ["\xF3\xB0\xAC\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB5"],
        ["\xF3\xB0\xAC\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB6"],
        ["\xF3\xB0\xAC\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB7"],
        ["\xF3\xB0\xAC\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB8"],
        ["\xF3\xB0\xAC\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB9"],
        ["\xF3\xB0\xAC\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBA"],
        ["\xF3\xB0\xAC\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBB"],
        ["\xF3\xB0\xAC\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBC"],
        ["\xF3\xB0\xAC\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBD"],
        ["\xF3\xB0\xAC\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBE"],
        ["\xF3\xB0\xAC\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBF"],
        ["\xF3\xB0\xAC\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC0"],
        ["\xF3\xB0\xAC\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC1"],
        ["\xF3\xB0\xAC\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC2"],
        ["\xF3\xB0\xAC\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC3"],
        ["\xF3\xB0\xAC\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC4"],
        ["\xF3\xB0\xAC\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC5"],
        ["\xF3\xB0\xAC\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC6"],
        ["\xF3\xB0\xAC\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC7"],
        ["\xF3\xB0\xAC\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC8"],
        ["\xF3\xB0\xAC\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC9"],
        ["\xF3\xB0\xAC\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCA"],
        ["\xF3\xB0\xAC\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCB"],
        ["\xF3\xB0\xAC\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCC"],
        ["\xF3\xB0\xAC\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCD"],
        ["\xF3\xB0\xAC\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCE"],
        ["\xF3\xB0\xAC\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCF"],
        ["\xF3\xB0\xAC\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD0"],
        ["\xF3\xB0\xAC\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD1"],
        ["\xF3\xB0\xAC\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD2"],
        ["\xF3\xB0\xAC\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD3"],
        ["\xF3\xB0\xAC\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD4"],
        ["\xF3\xB0\xAC\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD5"],
        ["\xF3\xB0\xAC\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD6"],
        ["\xF3\xB0\xAC\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD7"],
        ["\xF3\xB0\xAC\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD8"],
        ["\xF3\xB0\xAC\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD9"],
        ["\xF3\xB0\xAC\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDA"],
        ["\xF3\xB0\xAC\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDB"],
        ["\xF3\xB0\xAC\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDC"],
        ["\xF3\xB0\xAC\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDD"],
        ["\xF3\xB0\xAC\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDE"],
        ["\xF3\xB0\xAC\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDF"],
        ["\xF3\xB0\xAC\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE0"],
        ["\xF3\xB0\xAC\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE1"],
        ["\xF3\xB0\xAC\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE2"],
        ["\xF3\xB0\xAC\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE3"],
        ["\xF3\xB0\xAC\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE4"],
        ["\xF3\xB0\xAC\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE5"],
        ["\xF3\xB0\xAC\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE6"],
        ["\xF3\xB0\xAC\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE7"],
        ["\xF3\xB0\xAC\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE8"],
        ["\xF3\xB0\xAC\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE9"],
        ["\xF3\xB0\xAC\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xEA"],
        ["\xF3\xB0\xAC\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xEB"],
        ["\xF3\xB0\xAC\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xEC"],
        ["\xF3\xB0\xAC\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xED"],
        ["\xF3\xB0\xAC\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xEE"],
        ["\xF3\xB0\xAC\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xEF"],
        ["\xF3\xB0\xAC\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF0"],
        ["\xF3\xB0\xAC\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF1"],
        ["\xF3\xB0\xAC\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF2"],
        ["\xF3\xB0\xAC\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF3"],
        ["\xF3\xB0\xAC\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF4"],
        ["\xF3\xB0\xAD\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF5"],
        ["\xF3\xB0\xAD\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF6"],
        ["\xF3\xB0\xAD\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF7"],
        ["\xF3\xB0\xAD\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF8"],
        ["\xF3\xB0\xAD\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF9"],
        ["\xF3\xB0\xAD\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xFA"],
        ["\xF3\xB0\xAD\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xFB"],
        ["\xF3\xB0\xAD\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xFC"],
        ["\xF3\xB0\xAD\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x40"],
        ["\xF3\xB0\xAD\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x41"],
        ["\xF3\xB0\xAD\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x42"],
        ["\xF3\xB0\xAD\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x43"],
        ["\xF3\xB0\xAD\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x44"],
        ["\xF3\xB0\xAD\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x45"],
        ["\xF3\xB0\xAD\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x46"],
        ["\xF3\xB0\xAD\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x47"],
        ["\xF3\xB0\xAD\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x48"],
        ["\xF3\xB0\xAD\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x49"],
        ["\xF3\xB0\xAD\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4A"],
        ["\xF3\xB0\xAD\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4B"],
        ["\xF3\xB0\xAD\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4C"],
        ["\xF3\xB0\xAD\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4D"],
        ["\xF3\xB0\xAD\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4E"],
        ["\xF3\xB0\xAD\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4F"],
        ["\xF3\xB0\xAD\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x50"],
        ["\xF3\xB0\xAD\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x51"],
        ["\xF3\xB0\xAD\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x52"],
        ["\xF3\xB0\xAD\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x53"],
        ["\xF3\xB0\xAD\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x54"],
        ["\xF3\xB0\xAD\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x55"],
        ["\xF3\xB0\xAD\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x56"],
        ["\xF3\xB0\xAD\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x57"],
        ["\xF3\xB0\xAD\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x58"],
        ["\xF3\xB0\xAD\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x59"],
        ["\xF3\xB0\xAD\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5A"],
        ["\xF3\xB0\xAD\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5B"],
        ["\xF3\xB0\xAD\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5C"],
        ["\xF3\xB0\xAD\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5D"],
        ["\xF3\xB0\xAD\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5E"],
        ["\xF3\xB0\xAD\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5F"],
        ["\xF3\xB0\xAD\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x60"],
        ["\xF3\xB0\xAD\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x61"],
        ["\xF3\xB0\xAD\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x62"],
        ["\xF3\xB0\xAD\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x63"],
        ["\xF3\xB0\xAD\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x64"],
        ["\xF3\xB0\xAD\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x65"],
        ["\xF3\xB0\xAD\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x66"],
        ["\xF3\xB0\xAD\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x67"],
        ["\xF3\xB0\xAD\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x68"],
        ["\xF3\xB0\xAD\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x69"],
        ["\xF3\xB0\xAD\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6A"],
        ["\xF3\xB0\xAD\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6B"],
        ["\xF3\xB0\xAD\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6C"],
        ["\xF3\xB0\xAD\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6D"],
        ["\xF3\xB0\xAD\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6E"],
        ["\xF3\xB0\xAD\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6F"],
        ["\xF3\xB0\xAD\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x70"],
        ["\xF3\xB0\xAD\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x71"],
        ["\xF3\xB0\xAD\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x72"],
        ["\xF3\xB0\xAD\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x73"],
        ["\xF3\xB0\xAD\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x74"],
        ["\xF3\xB0\xAD\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x75"],
        ["\xF3\xB0\xAD\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x76"],
        ["\xF3\xB0\xAD\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x77"],
        ["\xF3\xB0\xAE\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x78"],
        ["\xF3\xB0\xAE\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x79"],
        ["\xF3\xB0\xAE\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x7A"],
        ["\xF3\xB0\xAE\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x7B"],
        ["\xF3\xB0\xAE\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x7C"],
        ["\xF3\xB0\xAE\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x7D"],
        ["\xF3\xB0\xAE\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x7E"],
        ["\xF3\xB0\xAE\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x80"],
        ["\xF3\xB0\xAE\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x81"],
        ["\xF3\xB0\xAE\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x82"],
        ["\xF3\xB0\xAE\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x83"],
        ["\xF3\xB0\xAE\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x84"],
        ["\xF3\xB0\xAE\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x85"],
        ["\xF3\xB0\xAE\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x86"],
        ["\xF3\xB0\xAE\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x87"],
        ["\xF3\xB0\xAE\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x88"],
        ["\xF3\xB0\xAE\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x89"],
        ["\xF3\xB0\xAE\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8A"],
        ["\xF3\xB0\xAE\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8B"],
        ["\xF3\xB0\xAE\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8C"],
        ["\xF3\xB0\xAE\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8D"],
        ["\xF3\xB0\xAE\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8E"],
        ["\xF3\xB0\xAE\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8F"],
        ["\xF3\xB0\xAE\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x90"],
        ["\xF3\xB0\xAE\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x91"],
        ["\xF3\xB0\xAE\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x92"],
        ["\xF3\xB0\xAE\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x93"],
        ["\xF3\xB0\xAE\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x94"],
        ["\xF3\xB0\xAE\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x95"],
        ["\xF3\xB0\xAE\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x96"],
        ["\xF3\xB0\xAE\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x97"],
        ["\xF3\xB0\xAE\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x98"],
        ["\xF3\xB0\xAE\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x99"],
        ["\xF3\xB0\xAE\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9A"],
        ["\xF3\xB0\xAE\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9B"],
        ["\xF3\xB0\xAE\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9C"],
        ["\xF3\xB0\xAE\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9D"],
        ["\xF3\xB0\xAE\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9E"],
        ["\xF3\xB0\xAE\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9F"],
        ["\xF3\xB0\xAE\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA0"],
        ["\xF3\xB0\xAE\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA1"],
        ["\xF3\xB0\xAE\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA2"],
        ["\xF3\xB0\xAE\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA3"],
        ["\xF3\xB0\xAE\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA4"],
        ["\xF3\xB0\xAE\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA5"],
        ["\xF3\xB0\xAE\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA6"],
        ["\xF3\xB0\xAE\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA7"],
        ["\xF3\xB0\xAE\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA8"],
        ["\xF3\xB0\xAE\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA9"],
        ["\xF3\xB0\xAE\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAA"],
        ["\xF3\xB0\xAE\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAB"],
        ["\xF3\xB0\xAE\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAC"],
        ["\xF3\xB0\xAE\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAD"],
        ["\xF3\xB0\xAE\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAE"],
        ["\xF3\xB0\xAE\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAF"],
        ["\xF3\xB0\xAE\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB0"],
        ["\xF3\xB0\xAE\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB1"],
        ["\xF3\xB0\xAE\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB2"],
        ["\xF3\xB0\xAE\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB3"],
        ["\xF3\xB0\xAE\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB4"],
        ["\xF3\xB0\xAE\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB5"],
        ["\xF3\xB0\xAE\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB6"],
        ["\xF3\xB0\xAE\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB7"],
        ["\xF3\xB0\xAE\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB8"],
        ["\xF3\xB0\xAF\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB9"],
        ["\xF3\xB0\xAF\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBA"],
        ["\xF3\xB0\xAF\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBB"],
        ["\xF3\xB0\xAF\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBC"],
        ["\xF3\xB0\xAF\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBD"],
        ["\xF3\xB0\xAF\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBE"],
        ["\xF3\xB0\xAF\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBF"],
        ["\xF3\xB0\xAF\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC0"],
        ["\xF3\xB0\xAF\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC1"],
        ["\xF3\xB0\xAF\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC2"],
        ["\xF3\xB0\xAF\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC3"],
        ["\xF3\xB0\xAF\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC4"],
        ["\xF3\xB0\xAF\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC5"],
        ["\xF3\xB0\xAF\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC6"],
        ["\xF3\xB0\xAF\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC7"],
        ["\xF3\xB0\xAF\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC8"],
        ["\xF3\xB0\xAF\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC9"],
        ["\xF3\xB0\xAF\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCA"],
        ["\xF3\xB0\xAF\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCB"],
        ["\xF3\xB0\xAF\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCC"],
        ["\xF3\xB0\xAF\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCD"],
        ["\xF3\xB0\xAF\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCE"],
        ["\xF3\xB0\xAF\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCF"],
        ["\xF3\xB0\xAF\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD0"],
        ["\xF3\xB0\xAF\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD1"],
        ["\xF3\xB0\xAF\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD2"],
        ["\xF3\xB0\xAF\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD3"],
        ["\xF3\xB0\xAF\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD4"],
        ["\xF3\xB0\xAF\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD5"],
        ["\xF3\xB0\xAF\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD6"],
        ["\xF3\xB0\xAF\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD7"],
        ["\xF3\xB0\xAF\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD8"],
        ["\xF3\xB0\xAF\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD9"],
        ["\xF3\xB0\xAF\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDA"],
        ["\xF3\xB0\xAF\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDB"],
        ["\xF3\xB0\xAF\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDC"],
        ["\xF3\xB0\xAF\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDD"],
        ["\xF3\xB0\xAF\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDE"],
        ["\xF3\xB0\xAF\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDF"],
        ["\xF3\xB0\xAF\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE0"],
        ["\xF3\xB0\xAF\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE1"],
        ["\xF3\xB0\xAF\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE2"],
        ["\xF3\xB0\xAF\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE3"],
        ["\xF3\xB0\xAF\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE4"],
        ["\xF3\xB0\xAF\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE5"],
        ["\xF3\xB0\xAF\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE6"],
        ["\xF3\xB0\xAF\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE7"],
        ["\xF3\xB0\xAF\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE8"],
        ["\xF3\xB0\xAF\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE9"],
        ["\xF3\xB0\xAF\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xEA"],
        ["\xF3\xB0\xAF\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xEB"],
        ["\xF3\xB0\xAF\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xEC"],
        ["\xF3\xB0\xAF\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xED"],
        ["\xF3\xB0\xAF\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xEE"],
        ["\xF3\xB0\xAF\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xEF"],
        ["\xF3\xB0\xAF\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF0"],
        ["\xF3\xB0\xAF\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF1"],
        ["\xF3\xB0\xAF\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF2"],
        ["\xF3\xB0\xAF\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF3"],
        ["\xF3\xB0\xAF\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF4"],
        ["\xF3\xB0\xAF\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF5"],
        ["\xF3\xB0\xAF\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF6"],
        ["\xF3\xB0\xAF\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF7"],
        ["\xF3\xB0\xAF\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF8"],
        ["\xF3\xB0\xB0\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF9"],
        ["\xF3\xB0\xB0\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xFA"],
        ["\xF3\xB0\xB0\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xFB"],
        ["\xF3\xB0\xB0\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xFC"],
        ["\xF3\xB0\xB0\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x40"],
        ["\xF3\xB0\xB0\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x41"],
        ["\xF3\xB0\xB0\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x42"],
        ["\xF3\xB0\xB0\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x43"],
        ["\xF3\xB0\xB0\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x44"],
        ["\xF3\xB0\xB0\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x45"],
        ["\xF3\xB0\xB0\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x46"],
        ["\xF3\xB0\xB0\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x47"],
        ["\xF3\xB0\xB0\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x48"],
        ["\xF3\xB0\xB0\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x49"],
        ["\xF3\xB0\xB0\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4A"],
        ["\xF3\xB0\xB0\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4B"],
        ["\xF3\xB0\xB0\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4C"],
        ["\xF3\xB0\xB0\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4D"],
        ["\xF3\xB0\xB0\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4E"],
        ["\xF3\xB0\xB0\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4F"],
        ["\xF3\xB0\xB0\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x50"],
        ["\xF3\xB0\xB0\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x51"],
        ["\xF3\xB0\xB0\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x52"],
        ["\xF3\xB0\xB0\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x53"],
        ["\xF3\xB0\xB0\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x54"],
        ["\xF3\xB0\xB0\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x55"],
        ["\xF3\xB0\xB0\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x56"],
        ["\xF3\xB0\xB0\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x57"],
        ["\xF3\xB0\xB0\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x58"],
        ["\xF3\xB0\xB0\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x59"],
        ["\xF3\xB0\xB0\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5A"],
        ["\xF3\xB0\xB0\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5B"],
        ["\xF3\xB0\xB0\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5C"],
        ["\xF3\xB0\xB0\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5D"],
        ["\xF3\xB0\xB0\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5E"],
        ["\xF3\xB0\xB0\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5F"],
        ["\xF3\xB0\xB0\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x60"],
        ["\xF3\xB0\xB0\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x61"],
        ["\xF3\xB0\xB0\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x62"],
        ["\xF3\xB0\xB0\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x63"],
        ["\xF3\xB0\xB0\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x64"],
        ["\xF3\xB0\xB0\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x65"],
        ["\xF3\xB0\xB0\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x66"],
        ["\xF3\xB0\xB0\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x67"],
        ["\xF3\xB0\xB0\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x68"],
        ["\xF3\xB0\xB0\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x69"],
        ["\xF3\xB0\xB0\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6A"],
        ["\xF3\xB0\xB0\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6B"],
        ["\xF3\xB0\xB0\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6C"],
        ["\xF3\xB0\xB0\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6D"],
        ["\xF3\xB0\xB0\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6E"],
        ["\xF3\xB0\xB0\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6F"],
        ["\xF3\xB0\xB0\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x70"],
        ["\xF3\xB0\xB0\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x71"],
        ["\xF3\xB0\xB0\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x72"],
        ["\xF3\xB0\xB0\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x73"],
        ["\xF3\xB0\xB0\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x74"],
        ["\xF3\xB0\xB0\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x75"],
        ["\xF3\xB0\xB0\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x76"],
        ["\xF3\xB0\xB0\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x77"],
        ["\xF3\xB0\xB0\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x78"],
        ["\xF3\xB0\xB0\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x79"],
        ["\xF3\xB0\xB0\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x7A"],
        ["\xF3\xB0\xB0\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x7B"],
        ["\xF3\xB0\xB1\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x7C"],
        ["\xF3\xB0\xB1\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x7D"],
        ["\xF3\xB0\xB1\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x7E"],
        ["\xF3\xB0\xB1\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x80"],
        ["\xF3\xB0\xB1\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x81"],
        ["\xF3\xB0\xB1\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x82"],
        ["\xF3\xB0\xB1\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x83"],
        ["\xF3\xB0\xB1\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x84"],
        ["\xF3\xB0\xB1\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x85"],
        ["\xF3\xB0\xB1\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x86"],
        ["\xF3\xB0\xB1\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x87"],
        ["\xF3\xB0\xB1\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x88"],
        ["\xF3\xB0\xB1\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x89"],
        ["\xF3\xB0\xB1\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8A"],
        ["\xF3\xB0\xB1\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8B"],
        ["\xF3\xB0\xB1\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8C"],
        ["\xF3\xB0\xB1\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8D"],
        ["\xF3\xB0\xB1\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8E"],
        ["\xF3\xB0\xB1\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8F"],
        ["\xF3\xB0\xB1\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x90"],
        ["\xF3\xB0\xB1\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x91"],
        ["\xF3\xB0\xB1\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x92"],
        ["\xF3\xB0\xB1\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x93"],
        ["\xF3\xB0\xB1\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x94"],
        ["\xF3\xB0\xB1\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x95"],
        ["\xF3\xB0\xB1\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x96"],
        ["\xF3\xB0\xB1\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x97"],
        ["\xF3\xB0\xB1\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x98"],
        ["\xF3\xB0\xB1\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x99"],
        ["\xF3\xB0\xB1\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9A"],
        ["\xF3\xB0\xB1\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9B"],
        ["\xF3\xB0\xB1\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9C"],
        ["\xF3\xB0\xB1\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9D"],
        ["\xF3\xB0\xB1\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9E"],
        ["\xF3\xB0\xB1\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9F"],
        ["\xF3\xB0\xB1\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA0"],
        ["\xF3\xB0\xB1\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA1"],
        ["\xF3\xB0\xB1\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA2"],
        ["\xF3\xB0\xB1\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA3"],
        ["\xF3\xB0\xB1\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA4"],
        ["\xF3\xB0\xB1\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA5"],
        ["\xF3\xB0\xB1\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA6"],
        ["\xF3\xB0\xB1\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA7"],
        ["\xF3\xB0\xB1\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA8"],
        ["\xF3\xB0\xB1\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA9"],
        ["\xF3\xB0\xB1\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAA"],
        ["\xF3\xB0\xB1\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAB"],
        ["\xF3\xB0\xB1\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAC"],
        ["\xF3\xB0\xB1\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAD"],
        ["\xF3\xB0\xB1\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAE"],
        ["\xF3\xB0\xB1\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAF"],
        ["\xF3\xB0\xB1\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB0"],
        ["\xF3\xB0\xB1\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB1"],
        ["\xF3\xB0\xB1\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB2"],
        ["\xF3\xB0\xB1\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB3"],
        ["\xF3\xB0\xB1\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB4"],
        ["\xF3\xB0\xB1\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB5"],
        ["\xF3\xB0\xB1\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB6"],
        ["\xF3\xB0\xB1\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB7"],
        ["\xF3\xB0\xB1\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB8"],
        ["\xF3\xB0\xB1\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB9"],
        ["\xF3\xB0\xB1\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBA"],
        ["\xF3\xB0\xB1\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBB"],
        ["\xF3\xB0\xB1\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBC"],
        ["\xF3\xB0\xB2\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBD"],
        ["\xF3\xB0\xB2\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBE"],
        ["\xF3\xB0\xB2\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBF"],
        ["\xF3\xB0\xB2\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC0"],
        ["\xF3\xB0\xB2\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC1"],
        ["\xF3\xB0\xB2\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC2"],
        ["\xF3\xB0\xB2\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC3"],
        ["\xF3\xB0\xB2\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC4"],
        ["\xF3\xB0\xB2\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC5"],
        ["\xF3\xB0\xB2\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC6"],
        ["\xF3\xB0\xB2\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC7"],
        ["\xF3\xB0\xB2\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC8"],
        ["\xF3\xB0\xB2\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC9"],
        ["\xF3\xB0\xB2\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCA"],
        ["\xF3\xB0\xB2\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCB"],
        ["\xF3\xB0\xB2\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCC"],
        ["\xF3\xB0\xB2\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCD"],
        ["\xF3\xB0\xB2\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCE"],
        ["\xF3\xB0\xB2\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCF"],
        ["\xF3\xB0\xB2\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD0"],
        ["\xF3\xB0\xB2\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD1"],
        ["\xF3\xB0\xB2\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD2"],
        ["\xF3\xB0\xB2\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD3"],
        ["\xF3\xB0\xB2\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD4"],
        ["\xF3\xB0\xB2\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD5"],
        ["\xF3\xB0\xB2\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD6"],
        ["\xF3\xB0\xB2\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD7"],
        ["\xF3\xB0\xB2\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD8"],
        ["\xF3\xB0\xB2\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD9"],
        ["\xF3\xB0\xB2\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDA"],
        ["\xF3\xB0\xB2\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDB"],
        ["\xF3\xB0\xB2\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDC"],
        ["\xF3\xB0\xB2\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDD"],
        ["\xF3\xB0\xB2\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDE"],
        ["\xF3\xB0\xB2\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDF"],
        ["\xF3\xB0\xB2\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE0"],
        ["\xF3\xB0\xB2\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE1"],
        ["\xF3\xB0\xB2\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE2"],
        ["\xF3\xB0\xB2\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE3"],
        ["\xF3\xB0\xB2\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE4"],
        ["\xF3\xB0\xB2\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE5"],
        ["\xF3\xB0\xB2\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE6"],
        ["\xF3\xB0\xB2\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE7"],
        ["\xF3\xB0\xB2\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE8"],
        ["\xF3\xB0\xB2\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE9"],
        ["\xF3\xB0\xB2\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEA"],
        ["\xF3\xB0\xB2\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEB"],
        ["\xF3\xB0\xB2\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEC"],
        ["\xF3\xB0\xB2\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xED"],
        ["\xF3\xB0\xB2\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEE"],
        ["\xF3\xB0\xB2\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEF"],
        ["\xF3\xB0\xB2\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF0"],
        ["\xF3\xB0\xB2\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF1"],
        ["\xF3\xB0\xB2\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF2"],
        ["\xF3\xB0\xB2\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF3"],
        ["\xF3\xB0\xB2\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF4"],
        ["\xF3\xB0\xB2\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF5"],
        ["\xF3\xB0\xB2\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF6"],
        ["\xF3\xB0\xB2\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF7"],
        ["\xF3\xB0\xB2\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF8"],
        ["\xF3\xB0\xB2\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF9"],
        ["\xF3\xB0\xB2\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xFA"],
        ["\xF3\xB0\xB2\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xFB"],
        ["\xF3\xB0\xB2\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xFC"],
        ["\xF3\xB0\xB3\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x40"],
        ["\xF3\xB0\xB3\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x41"],
        ["\xF3\xB0\xB3\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x42"],
        ["\xF3\xB0\xB3\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x43"],
        ["\xF3\xB0\xB3\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x44"],
        ["\xF3\xB0\xB3\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x45"],
        ["\xF3\xB0\xB3\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x46"],
        ["\xF3\xB0\xB3\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x47"],
        ["\xF3\xB0\xB3\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x48"],
        ["\xF3\xB0\xB3\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x49"],
        ["\xF3\xB0\xB3\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4A"],
        ["\xF3\xB0\xB3\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4B"],
        ["\xF3\xB0\xB3\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4C"],
        ["\xF3\xB0\xB3\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4D"],
        ["\xF3\xB0\xB3\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4E"],
        ["\xF3\xB0\xB3\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4F"],
        ["\xF3\xB0\xB3\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x50"],
        ["\xF3\xB0\xB3\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x51"],
        ["\xF3\xB0\xB3\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x52"],
        ["\xF3\xB0\xB3\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x53"],
        ["\xF3\xB0\xB3\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x54"],
        ["\xF3\xB0\xB3\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x55"],
        ["\xF3\xB0\xB3\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x56"],
        ["\xF3\xB0\xB3\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x57"],
        ["\xF3\xB0\xB3\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x58"],
        ["\xF3\xB0\xB3\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x59"],
        ["\xF3\xB0\xB3\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5A"],
        ["\xF3\xB0\xB3\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5B"],
        ["\xF3\xB0\xB3\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5C"],
        ["\xF3\xB0\xB3\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5D"],
        ["\xF3\xB0\xB3\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5E"],
        ["\xF3\xB0\xB3\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5F"],
        ["\xF3\xB0\xB3\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x60"],
        ["\xF3\xB0\xB3\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x61"],
        ["\xF3\xB0\xB3\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x62"],
        ["\xF3\xB0\xB3\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x63"],
        ["\xF3\xB0\xB3\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x64"],
        ["\xF3\xB0\xB3\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x65"],
        ["\xF3\xB0\xB3\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x66"],
        ["\xF3\xB0\xB3\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x67"],
        ["\xF3\xB0\xB3\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x68"],
        ["\xF3\xB0\xB3\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x69"],
        ["\xF3\xB0\xB3\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6A"],
        ["\xF3\xB0\xB3\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6B"],
        ["\xF3\xB0\xB3\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6C"],
        ["\xF3\xB0\xB3\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6D"],
        ["\xF3\xB0\xB3\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6E"],
        ["\xF3\xB0\xB3\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6F"],
        ["\xF3\xB0\xB3\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x70"],
        ["\xF3\xB0\xB3\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x71"],
        ["\xF3\xB0\xB3\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x72"],
        ["\xF3\xB0\xB3\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x73"],
        ["\xF3\xB0\xB3\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x74"],
        ["\xF3\xB0\xB3\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x75"],
        ["\xF3\xB0\xB3\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x76"],
        ["\xF3\xB0\xB3\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x77"],
        ["\xF3\xB0\xB3\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x78"],
        ["\xF3\xB0\xB3\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x79"],
        ["\xF3\xB0\xB3\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x7A"],
        ["\xF3\xB0\xB3\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x7B"],
        ["\xF3\xB0\xB3\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x7C"],
        ["\xF3\xB0\xB3\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x7D"],
        ["\xF3\xB0\xB3\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x7E"],
        ["\xF3\xB0\xB3\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x80"],
        ["\xF3\xB0\xB4\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x81"],
        ["\xF3\xB0\xB4\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x82"],
        ["\xF3\xB0\xB4\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x83"],
        ["\xF3\xB0\xB4\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x84"],
        ["\xF3\xB0\xB4\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x85"],
        ["\xF3\xB0\xB4\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x86"],
        ["\xF3\xB0\xB4\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x87"],
        ["\xF3\xB0\xB4\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x88"],
        ["\xF3\xB0\xB4\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x89"],
        ["\xF3\xB0\xB4\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8A"],
        ["\xF3\xB0\xB4\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8B"],
        ["\xF3\xB0\xB4\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8C"],
        ["\xF3\xB0\xB4\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8D"],
        ["\xF3\xB0\xB4\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8E"],
        ["\xF3\xB0\xB4\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8F"],
        ["\xF3\xB0\xB4\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x90"],
        ["\xF3\xB0\xB4\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x91"],
        ["\xF3\xB0\xB4\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x92"],
        ["\xF3\xB0\xB4\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x93"],
        ["\xF3\xB0\xB4\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x94"],
        ["\xF3\xB0\xB4\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x95"],
        ["\xF3\xB0\xB4\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x96"],
        ["\xF3\xB0\xB4\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x97"],
        ["\xF3\xB0\xB4\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x98"],
        ["\xF3\xB0\xB4\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x99"],
        ["\xF3\xB0\xB4\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9A"],
        ["\xF3\xB0\xB4\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9B"],
        ["\xF3\xB0\xB4\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9C"],
        ["\xF3\xB0\xB4\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9D"],
        ["\xF3\xB0\xB4\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9E"],
        ["\xF3\xB0\xB4\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9F"],
        ["\xF3\xB0\xB4\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA0"],
        ["\xF3\xB0\xB4\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA1"],
        ["\xF3\xB0\xB4\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA2"],
        ["\xF3\xB0\xB4\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA3"],
        ["\xF3\xB0\xB4\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA4"],
        ["\xF3\xB0\xB4\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA5"],
        ["\xF3\xB0\xB4\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA6"],
        ["\xF3\xB0\xB4\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA7"],
        ["\xF3\xB0\xB4\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA8"],
        ["\xF3\xB0\xB4\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA9"],
        ["\xF3\xB0\xB4\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAA"],
        ["\xF3\xB0\xB4\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAB"],
        ["\xF3\xB0\xB4\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAC"],
        ["\xF3\xB0\xB4\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAD"],
        ["\xF3\xB0\xB4\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAE"],
        ["\xF3\xB0\xB4\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAF"],
        ["\xF3\xB0\xB4\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB0"],
        ["\xF3\xB0\xB4\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB1"],
        ["\xF3\xB0\xB4\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB2"],
        ["\xF3\xB0\xB4\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB3"],
        ["\xF3\xB0\xB4\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB4"],
        ["\xF3\xB0\xB4\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB5"],
        ["\xF3\xB0\xB4\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB6"],
        ["\xF3\xB0\xB4\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB7"],
        ["\xF3\xB0\xB4\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB8"],
        ["\xF3\xB0\xB4\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB9"],
        ["\xF3\xB0\xB4\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBA"],
        ["\xF3\xB0\xB4\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBB"],
        ["\xF3\xB0\xB4\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBC"],
        ["\xF3\xB0\xB4\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBD"],
        ["\xF3\xB0\xB4\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBE"],
        ["\xF3\xB0\xB4\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBF"],
        ["\xF3\xB0\xB4\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC0"],
        ["\xF3\xB0\xB5\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC1"],
        ["\xF3\xB0\xB5\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC2"],
        ["\xF3\xB0\xB5\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC3"],
        ["\xF3\xB0\xB5\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC4"],
        ["\xF3\xB0\xB5\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC5"],
        ["\xF3\xB0\xB5\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC6"],
        ["\xF3\xB0\xB5\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC7"],
        ["\xF3\xB0\xB5\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC8"],
        ["\xF3\xB0\xB5\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC9"],
        ["\xF3\xB0\xB5\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCA"],
        ["\xF3\xB0\xB5\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCB"],
        ["\xF3\xB0\xB5\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCC"],
        ["\xF3\xB0\xB5\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCD"],
        ["\xF3\xB0\xB5\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCE"],
        ["\xF3\xB0\xB5\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCF"],
        ["\xF3\xB0\xB5\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD0"],
        ["\xF3\xB0\xB5\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD1"],
        ["\xF3\xB0\xB5\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD2"],
        ["\xF3\xB0\xB5\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD3"],
        ["\xF3\xB0\xB5\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD4"],
        ["\xF3\xB0\xB5\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD5"],
        ["\xF3\xB0\xB5\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD6"],
        ["\xF3\xB0\xB5\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD7"],
        ["\xF3\xB0\xB5\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD8"],
        ["\xF3\xB0\xB5\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD9"],
        ["\xF3\xB0\xB5\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDA"],
        ["\xF3\xB0\xB5\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDB"],
        ["\xF3\xB0\xB5\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDC"],
        ["\xF3\xB0\xB5\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDD"],
        ["\xF3\xB0\xB5\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDE"],
        ["\xF3\xB0\xB5\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDF"],
        ["\xF3\xB0\xB5\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE0"],
        ["\xF3\xB0\xB5\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE1"],
        ["\xF3\xB0\xB5\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE2"],
        ["\xF3\xB0\xB5\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE3"],
        ["\xF3\xB0\xB5\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE4"],
        ["\xF3\xB0\xB5\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE5"],
        ["\xF3\xB0\xB5\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE6"],
        ["\xF3\xB0\xB5\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE7"],
        ["\xF3\xB0\xB5\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE8"],
        ["\xF3\xB0\xB5\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE9"],
        ["\xF3\xB0\xB5\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEA"],
        ["\xF3\xB0\xB5\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEB"],
        ["\xF3\xB0\xB5\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEC"],
        ["\xF3\xB0\xB5\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xED"],
        ["\xF3\xB0\xB5\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEE"],
        ["\xF3\xB0\xB5\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEF"],
        ["\xF3\xB0\xB5\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF0"],
        ["\xF3\xB0\xB5\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF1"],
        ["\xF3\xB0\xB5\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF2"],
        ["\xF3\xB0\xB5\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF3"],
        ["\xF3\xB0\xB5\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF4"],
        ["\xF3\xB0\xB5\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF5"],
        ["\xF3\xB0\xB5\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF6"],
        ["\xF3\xB0\xB5\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF7"],
        ["\xF3\xB0\xB5\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF8"],
        ["\xF3\xB0\xB5\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF9"],
        ["\xF3\xB0\xB5\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xFA"],
        ["\xF3\xB0\xB5\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xFB"],
        ["\xF3\xB0\xB5\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xFC"],
        ["\xF3\xB0\xB5\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x40"],
        ["\xF3\xB0\xB5\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x41"],
        ["\xF3\xB0\xB5\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x42"],
        ["\xF3\xB0\xB5\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x43"],
        ["\xF3\xB0\xB6\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x44"],
        ["\xF3\xB0\xB6\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x45"],
        ["\xF3\xB0\xB6\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x46"],
        ["\xF3\xB0\xB6\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x47"],
        ["\xF3\xB0\xB6\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x48"],
        ["\xF3\xB0\xB6\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x49"],
        ["\xF3\xB0\xB6\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4A"],
        ["\xF3\xB0\xB6\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4B"],
        ["\xF3\xB0\xB6\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4C"],
        ["\xF3\xB0\xB6\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4D"],
        ["\xF3\xB0\xB6\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4E"],
        ["\xF3\xB0\xB6\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4F"],
        ["\xF3\xB0\xB6\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x50"],
        ["\xF3\xB0\xB6\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x51"],
        ["\xF3\xB0\xB6\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x52"],
        ["\xF3\xB0\xB6\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x53"],
        ["\xF3\xB0\xB6\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x54"],
        ["\xF3\xB0\xB6\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x55"],
        ["\xF3\xB0\xB6\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x56"],
        ["\xF3\xB0\xB6\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x57"],
        ["\xF3\xB0\xB6\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x58"],
        ["\xF3\xB0\xB6\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x59"],
        ["\xF3\xB0\xB6\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5A"],
        ["\xF3\xB0\xB6\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5B"],
        ["\xF3\xB0\xB6\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5C"],
        ["\xF3\xB0\xB6\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5D"],
        ["\xF3\xB0\xB6\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5E"],
        ["\xF3\xB0\xB6\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5F"],
        ["\xF3\xB0\xB6\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x60"],
        ["\xF3\xB0\xB6\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x61"],
        ["\xF3\xB0\xB6\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x62"],
        ["\xF3\xB0\xB6\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x63"],
        ["\xF3\xB0\xB6\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x64"],
        ["\xF3\xB0\xB6\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x65"],
        ["\xF3\xB0\xB6\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x66"],
        ["\xF3\xB0\xB6\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x67"],
        ["\xF3\xB0\xB6\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x68"],
        ["\xF3\xB0\xB6\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x69"],
        ["\xF3\xB0\xB6\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6A"],
        ["\xF3\xB0\xB6\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6B"],
        ["\xF3\xB0\xB6\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6C"],
        ["\xF3\xB0\xB6\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6D"],
        ["\xF3\xB0\xB6\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6E"],
        ["\xF3\xB0\xB6\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6F"],
        ["\xF3\xB0\xB6\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x70"],
        ["\xF3\xB0\xB6\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x71"],
        ["\xF3\xB0\xB6\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x72"],
        ["\xF3\xB0\xB6\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x73"],
        ["\xF3\xB0\xB6\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x74"],
        ["\xF3\xB0\xB6\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x75"],
        ["\xF3\xB0\xB6\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x76"],
        ["\xF3\xB0\xB6\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x77"],
        ["\xF3\xB0\xB6\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x78"],
        ["\xF3\xB0\xB6\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x79"],
        ["\xF3\xB0\xB6\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x7A"],
        ["\xF3\xB0\xB6\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x7B"],
        ["\xF3\xB0\xB6\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x7C"],
        ["\xF3\xB0\xB6\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x7D"],
        ["\xF3\xB0\xB6\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x7E"],
        ["\xF3\xB0\xB6\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x80"],
        ["\xF3\xB0\xB6\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x81"],
        ["\xF3\xB0\xB6\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x82"],
        ["\xF3\xB0\xB6\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x83"],
        ["\xF3\xB0\xB6\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x84"],
        ["\xF3\xB0\xB7\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x85"],
        ["\xF3\xB0\xB7\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x86"],
        ["\xF3\xB0\xB7\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x87"],
        ["\xF3\xB0\xB7\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x88"],
        ["\xF3\xB0\xB7\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x89"],
        ["\xF3\xB0\xB7\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8A"],
        ["\xF3\xB0\xB7\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8B"],
        ["\xF3\xB0\xB7\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8C"],
        ["\xF3\xB0\xB7\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8D"],
        ["\xF3\xB0\xB7\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8E"],
        ["\xF3\xB0\xB7\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8F"],
        ["\xF3\xB0\xB7\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x90"],
        ["\xF3\xB0\xB7\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x91"],
        ["\xF3\xB0\xB7\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x92"],
        ["\xF3\xB0\xB7\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x93"],
        ["\xF3\xB0\xB7\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x94"],
        ["\xF3\xB0\xB7\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x95"],
        ["\xF3\xB0\xB7\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x96"],
        ["\xF3\xB0\xB7\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x97"],
        ["\xF3\xB0\xB7\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x98"],
        ["\xF3\xB0\xB7\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x99"],
        ["\xF3\xB0\xB7\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9A"],
        ["\xF3\xB0\xB7\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9B"],
        ["\xF3\xB0\xB7\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9C"],
        ["\xF3\xB0\xB7\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9D"],
        ["\xF3\xB0\xB7\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9E"],
        ["\xF3\xB0\xB7\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9F"],
        ["\xF3\xB0\xB7\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA0"],
        ["\xF3\xB0\xB7\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA1"],
        ["\xF3\xB0\xB7\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA2"],
        ["\xF3\xB0\xB7\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA3"],
        ["\xF3\xB0\xB7\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA4"],
        ["\xF3\xB0\xB7\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA5"],
        ["\xF3\xB0\xB7\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA6"],
        ["\xF3\xB0\xB7\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA7"],
        ["\xF3\xB0\xB7\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA8"],
        ["\xF3\xB0\xB7\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA9"],
        ["\xF3\xB0\xB7\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAA"],
        ["\xF3\xB0\xB7\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAB"],
        ["\xF3\xB0\xB7\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAC"],
        ["\xF3\xB0\xB7\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAD"],
        ["\xF3\xB0\xB7\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAE"],
        ["\xF3\xB0\xB7\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAF"],
        ["\xF3\xB0\xB7\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB0"],
        ["\xF3\xB0\xB7\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB1"],
        ["\xF3\xB0\xB7\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB2"],
        ["\xF3\xB0\xB7\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB3"],
        ["\xF3\xB0\xB7\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB4"],
        ["\xF3\xB0\xB7\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB5"],
        ["\xF3\xB0\xB7\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB6"],
        ["\xF3\xB0\xB7\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB7"],
        ["\xF3\xB0\xB7\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB8"],
        ["\xF3\xB0\xB7\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB9"],
        ["\xF3\xB0\xB7\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBA"],
        ["\xF3\xB0\xB7\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBB"],
        ["\xF3\xB0\xB7\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBC"],
        ["\xF3\xB0\xB7\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBD"],
        ["\xF3\xB0\xB7\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBE"],
        ["\xF3\xB0\xB7\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBF"],
        ["\xF3\xB0\xB7\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC0"],
        ["\xF3\xB0\xB7\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC1"],
        ["\xF3\xB0\xB7\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC2"],
        ["\xF3\xB0\xB7\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC3"],
        ["\xF3\xB0\xB7\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC4"],
        ["\xF3\xB0\xB8\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC5"],
        ["\xF3\xB0\xB8\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC6"],
        ["\xF3\xB0\xB8\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC7"],
        ["\xF3\xB0\xB8\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC8"],
        ["\xF3\xB0\xB8\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC9"],
        ["\xF3\xB0\xB8\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCA"],
        ["\xF3\xB0\xB8\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCB"],
        ["\xF3\xB0\xB8\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCC"],
        ["\xF3\xB0\xB8\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCD"],
        ["\xF3\xB0\xB8\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCE"],
        ["\xF3\xB0\xB8\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCF"],
        ["\xF3\xB0\xB8\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD0"],
        ["\xF3\xB0\xB8\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD1"],
        ["\xF3\xB0\xB8\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD2"],
        ["\xF3\xB0\xB8\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD3"],
        ["\xF3\xB0\xB8\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD4"],
        ["\xF3\xB0\xB8\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD5"],
        ["\xF3\xB0\xB8\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD6"],
        ["\xF3\xB0\xB8\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD7"],
        ["\xF3\xB0\xB8\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD8"],
        ["\xF3\xB0\xB8\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD9"],
        ["\xF3\xB0\xB8\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDA"],
        ["\xF3\xB0\xB8\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDB"],
        ["\xF3\xB0\xB8\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDC"],
        ["\xF3\xB0\xB8\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDD"],
        ["\xF3\xB0\xB8\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDE"],
        ["\xF3\xB0\xB8\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDF"],
        ["\xF3\xB0\xB8\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE0"],
        ["\xF3\xB0\xB8\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE1"],
        ["\xF3\xB0\xB8\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE2"],
        ["\xF3\xB0\xB8\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE3"],
        ["\xF3\xB0\xB8\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE4"],
        ["\xF3\xB0\xB8\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE5"],
        ["\xF3\xB0\xB8\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE6"],
        ["\xF3\xB0\xB8\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE7"],
        ["\xF3\xB0\xB8\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE8"],
        ["\xF3\xB0\xB8\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE9"],
        ["\xF3\xB0\xB8\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xEA"],
        ["\xF3\xB0\xB8\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xEB"],
        ["\xF3\xB0\xB8\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xEC"],
        ["\xF3\xB0\xB8\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xED"],
        ["\xF3\xB0\xB8\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xEE"],
        ["\xF3\xB0\xB8\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xEF"],
        ["\xF3\xB0\xB8\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF0"],
        ["\xF3\xB0\xB8\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF1"],
        ["\xF3\xB0\xB8\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF2"],
        ["\xF3\xB0\xB8\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF3"],
        ["\xF3\xB0\xB8\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF4"],
        ["\xF3\xB0\xB8\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF5"],
        ["\xF3\xB0\xB8\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF6"],
        ["\xF3\xB0\xB8\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF7"],
        ["\xF3\xB0\xB8\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF8"],
        ["\xF3\xB0\xB8\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF9"],
        ["\xF3\xB0\xB8\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xFA"],
        ["\xF3\xB0\xB8\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xFB"],
        ["\xF3\xB0\xB8\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xFC"],
        ["\xF3\xB0\xB8\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x40"],
        ["\xF3\xB0\xB8\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x41"],
        ["\xF3\xB0\xB8\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x42"],
        ["\xF3\xB0\xB8\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x43"],
        ["\xF3\xB0\xB8\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x44"],
        ["\xF3\xB0\xB8\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x45"],
        ["\xF3\xB0\xB8\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x46"],
        ["\xF3\xB0\xB8\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x47"],
        ["\xF3\xB0\xB9\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x48"],
        ["\xF3\xB0\xB9\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x49"],
        ["\xF3\xB0\xB9\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4A"],
        ["\xF3\xB0\xB9\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4B"],
        ["\xF3\xB0\xB9\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4C"],
        ["\xF3\xB0\xB9\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4D"],
        ["\xF3\xB0\xB9\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4E"],
        ["\xF3\xB0\xB9\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4F"],
        ["\xF3\xB0\xB9\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x50"],
        ["\xF3\xB0\xB9\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x51"],
        ["\xF3\xB0\xB9\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x52"],
        ["\xF3\xB0\xB9\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x53"],
        ["\xF3\xB0\xB9\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x54"],
        ["\xF3\xB0\xB9\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x55"],
        ["\xF3\xB0\xB9\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x56"],
        ["\xF3\xB0\xB9\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x57"],
        ["\xF3\xB0\xB9\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x58"],
        ["\xF3\xB0\xB9\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x59"],
        ["\xF3\xB0\xB9\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5A"],
        ["\xF3\xB0\xB9\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5B"],
        ["\xF3\xB0\xB9\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5C"],
        ["\xF3\xB0\xB9\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5D"],
        ["\xF3\xB0\xB9\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5E"],
        ["\xF3\xB0\xB9\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5F"],
        ["\xF3\xB0\xB9\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x60"],
        ["\xF3\xB0\xB9\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x61"],
        ["\xF3\xB0\xB9\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x62"],
        ["\xF3\xB0\xB9\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x63"],
        ["\xF3\xB0\xB9\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x64"],
        ["\xF3\xB0\xB9\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x65"],
        ["\xF3\xB0\xB9\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x66"],
        ["\xF3\xB0\xB9\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x67"],
        ["\xF3\xB0\xB9\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x68"],
        ["\xF3\xB0\xB9\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x69"],
        ["\xF3\xB0\xB9\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6A"],
        ["\xF3\xB0\xB9\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6B"],
        ["\xF3\xB0\xB9\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6C"],
        ["\xF3\xB0\xB9\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6D"],
        ["\xF3\xB0\xB9\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6E"],
        ["\xF3\xB0\xB9\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6F"],
        ["\xF3\xB0\xB9\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x70"],
        ["\xF3\xB0\xB9\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x71"],
        ["\xF3\xB0\xB9\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x72"],
        ["\xF3\xB0\xB9\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x73"],
        ["\xF3\xB0\xB9\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x74"],
        ["\xF3\xB0\xB9\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x75"],
        ["\xF3\xB0\xB9\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x76"],
        ["\xF3\xB0\xB9\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x77"],
        ["\xF3\xB0\xB9\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x78"],
        ["\xF3\xB0\xB9\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x79"],
        ["\xF3\xB0\xB9\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x7A"],
        ["\xF3\xB0\xB9\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x7B"],
        ["\xF3\xB0\xB9\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x7C"],
        ["\xF3\xB0\xB9\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x7D"],
        ["\xF3\xB0\xB9\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x7E"],
        ["\xF3\xB0\xB9\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x80"],
        ["\xF3\xB0\xB9\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x81"],
        ["\xF3\xB0\xB9\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x82"],
        ["\xF3\xB0\xB9\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x83"],
        ["\xF3\xB0\xB9\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x84"],
        ["\xF3\xB0\xB9\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x85"],
        ["\xF3\xB0\xB9\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x86"],
        ["\xF3\xB0\xB9\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x87"],
        ["\xF3\xB0\xB9\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x88"],
        ["\xF3\xB0\xBA\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x89"],
        ["\xF3\xB0\xBA\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8A"],
        ["\xF3\xB0\xBA\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8B"],
        ["\xF3\xB0\xBA\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8C"],
        ["\xF3\xB0\xBA\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8D"],
        ["\xF3\xB0\xBA\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8E"],
        ["\xF3\xB0\xBA\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8F"],
        ["\xF3\xB0\xBA\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x90"],
        ["\xF3\xB0\xBA\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x91"],
        ["\xF3\xB0\xBA\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x92"],
        ["\xF3\xB0\xBA\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x93"],
        ["\xF3\xB0\xBA\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x94"],
        ["\xF3\xB0\xBA\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x95"],
        ["\xF3\xB0\xBA\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x96"],
        ["\xF3\xB0\xBA\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x97"],
        ["\xF3\xB0\xBA\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x98"],
        ["\xF3\xB0\xBA\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x99"],
        ["\xF3\xB0\xBA\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9A"],
        ["\xF3\xB0\xBA\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9B"],
        ["\xF3\xB0\xBA\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9C"],
        ["\xF3\xB0\xBA\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9D"],
        ["\xF3\xB0\xBA\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9E"],
        ["\xF3\xB0\xBA\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9F"],
        ["\xF3\xB0\xBA\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA0"],
        ["\xF3\xB0\xBA\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA1"],
        ["\xF3\xB0\xBA\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA2"],
        ["\xF3\xB0\xBA\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA3"],
        ["\xF3\xB0\xBA\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA4"],
        ["\xF3\xB0\xBA\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA5"],
        ["\xF3\xB0\xBA\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA6"],
        ["\xF3\xB0\xBA\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA7"],
        ["\xF3\xB0\xBA\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA8"],
        ["\xF3\xB0\xBA\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA9"],
        ["\xF3\xB0\xBA\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAA"],
        ["\xF3\xB0\xBA\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAB"],
        ["\xF3\xB0\xBA\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAC"],
        ["\xF3\xB0\xBA\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAD"],
        ["\xF3\xB0\xBA\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAE"],
        ["\xF3\xB0\xBA\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAF"],
        ["\xF3\xB0\xBA\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB0"],
        ["\xF3\xB0\xBA\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB1"],
        ["\xF3\xB0\xBA\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB2"],
        ["\xF3\xB0\xBA\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB3"],
        ["\xF3\xB0\xBA\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB4"],
        ["\xF3\xB0\xBA\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB5"],
        ["\xF3\xB0\xBA\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB6"],
        ["\xF3\xB0\xBA\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB7"],
        ["\xF3\xB0\xBA\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB8"],
        ["\xF3\xB0\xBA\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB9"],
        ["\xF3\xB0\xBA\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBA"],
        ["\xF3\xB0\xBA\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBB"],
        ["\xF3\xB0\xBA\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBC"],
        ["\xF3\xB0\xBA\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBD"],
        ["\xF3\xB0\xBA\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBE"],
        ["\xF3\xB0\xBA\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBF"],
        ["\xF3\xB0\xBA\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC0"],
        ["\xF3\xB0\xBA\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC1"],
        ["\xF3\xB0\xBA\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC2"],
        ["\xF3\xB0\xBA\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC3"],
        ["\xF3\xB0\xBA\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC4"],
        ["\xF3\xB0\xBA\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC5"],
        ["\xF3\xB0\xBA\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC6"],
        ["\xF3\xB0\xBA\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC7"],
        ["\xF3\xB0\xBA\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC8"],
        ["\xF3\xB0\xBB\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC9"],
        ["\xF3\xB0\xBB\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCA"],
        ["\xF3\xB0\xBB\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCB"],
        ["\xF3\xB0\xBB\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCC"],
        ["\xF3\xB0\xBB\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCD"],
        ["\xF3\xB0\xBB\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCE"],
        ["\xF3\xB0\xBB\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCF"],
        ["\xF3\xB0\xBB\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD0"],
        ["\xF3\xB0\xBB\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD1"],
        ["\xF3\xB0\xBB\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD2"],
        ["\xF3\xB0\xBB\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD3"],
        ["\xF3\xB0\xBB\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD4"],
        ["\xF3\xB0\xBB\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD5"],
        ["\xF3\xB0\xBB\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD6"],
        ["\xF3\xB0\xBB\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD7"],
        ["\xF3\xB0\xBB\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD8"],
        ["\xF3\xB0\xBB\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD9"],
        ["\xF3\xB0\xBB\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDA"],
        ["\xF3\xB0\xBB\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDB"],
        ["\xF3\xB0\xBB\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDC"],
        ["\xF3\xB0\xBB\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDD"],
        ["\xF3\xB0\xBB\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDE"],
        ["\xF3\xB0\xBB\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDF"],
        ["\xF3\xB0\xBB\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE0"],
        ["\xF3\xB0\xBB\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE1"],
        ["\xF3\xB0\xBB\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE2"],
        ["\xF3\xB0\xBB\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE3"],
        ["\xF3\xB0\xBB\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE4"],
        ["\xF3\xB0\xBB\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE5"],
        ["\xF3\xB0\xBB\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE6"],
        ["\xF3\xB0\xBB\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE7"],
        ["\xF3\xB0\xBB\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE8"],
        ["\xF3\xB0\xBB\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE9"],
        ["\xF3\xB0\xBB\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEA"],
        ["\xF3\xB0\xBB\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEB"],
        ["\xF3\xB0\xBB\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEC"],
        ["\xF3\xB0\xBB\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xED"],
        ["\xF3\xB0\xBB\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEE"],
        ["\xF3\xB0\xBB\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEF"],
        ["\xF3\xB0\xBB\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF0"],
        ["\xF3\xB0\xBB\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF1"],
        ["\xF3\xB0\xBB\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF2"],
        ["\xF3\xB0\xBB\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF3"],
        ["\xF3\xB0\xBB\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF4"],
        ["\xF3\xB0\xBB\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF5"],
        ["\xF3\xB0\xBB\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF6"],
        ["\xF3\xB0\xBB\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF7"],
        ["\xF3\xB0\xBB\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF8"],
        ["\xF3\xB0\xBB\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF9"],
        ["\xF3\xB0\xBB\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xFA"],
        ["\xF3\xB0\xBB\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xFB"],
        ["\xF3\xB0\xBB\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xFC"],
        ["\xF3\xB0\xBB\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x40"],
        ["\xF3\xB0\xBB\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x41"],
        ["\xF3\xB0\xBB\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x42"],
        ["\xF3\xB0\xBB\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x43"],
        ["\xF3\xB0\xBB\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x44"],
        ["\xF3\xB0\xBB\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x45"],
        ["\xF3\xB0\xBB\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x46"],
        ["\xF3\xB0\xBB\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x47"],
        ["\xF3\xB0\xBB\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x48"],
        ["\xF3\xB0\xBB\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x49"],
        ["\xF3\xB0\xBB\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4A"],
        ["\xF3\xB0\xBB\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4B"],
        ["\xF3\xB0\xBC\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4C"],
        ["\xF3\xB0\xBC\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4D"],
        ["\xF3\xB0\xBC\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4E"],
        ["\xF3\xB0\xBC\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4F"],
        ["\xF3\xB0\xBC\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x50"],
        ["\xF3\xB0\xBC\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x51"],
        ["\xF3\xB0\xBC\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x52"],
        ["\xF3\xB0\xBC\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x53"],
        ["\xF3\xB0\xBC\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x54"],
        ["\xF3\xB0\xBC\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x55"],
        ["\xF3\xB0\xBC\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x56"],
        ["\xF3\xB0\xBC\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x57"],
        ["\xF3\xB0\xBC\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x58"],
        ["\xF3\xB0\xBC\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x59"],
        ["\xF3\xB0\xBC\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5A"],
        ["\xF3\xB0\xBC\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5B"],
        ["\xF3\xB0\xBC\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5C"],
        ["\xF3\xB0\xBC\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5D"],
        ["\xF3\xB0\xBC\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5E"],
        ["\xF3\xB0\xBC\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5F"],
        ["\xF3\xB0\xBC\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x60"],
        ["\xF3\xB0\xBC\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x61"],
        ["\xF3\xB0\xBC\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x62"],
        ["\xF3\xB0\xBC\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x63"],
        ["\xF3\xB0\xBC\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x64"],
        ["\xF3\xB0\xBC\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x65"],
        ["\xF3\xB0\xBC\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x66"],
        ["\xF3\xB0\xBC\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x67"],
        ["\xF3\xB0\xBC\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x68"],
        ["\xF3\xB0\xBC\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x69"],
        ["\xF3\xB0\xBC\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6A"],
        ["\xF3\xB0\xBC\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6B"],
        ["\xF3\xB0\xBC\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6C"],
        ["\xF3\xB0\xBC\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6D"],
        ["\xF3\xB0\xBC\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6E"],
        ["\xF3\xB0\xBC\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6F"],
        ["\xF3\xB0\xBC\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x70"],
        ["\xF3\xB0\xBC\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x71"],
        ["\xF3\xB0\xBC\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x72"],
        ["\xF3\xB0\xBC\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x73"],
        ["\xF3\xB0\xBC\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x74"],
        ["\xF3\xB0\xBC\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x75"],
        ["\xF3\xB0\xBC\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x76"],
        ["\xF3\xB0\xBC\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x77"],
        ["\xF3\xB0\xBC\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x78"],
        ["\xF3\xB0\xBC\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x79"],
        ["\xF3\xB0\xBC\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x7A"],
        ["\xF3\xB0\xBC\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x7B"],
        ["\xF3\xB0\xBC\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x7C"],
        ["\xF3\xB0\xBC\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x7D"],
        ["\xF3\xB0\xBC\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x7E"],
        ["\xF3\xB0\xBC\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x80"],
        ["\xF3\xB0\xBC\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x81"],
        ["\xF3\xB0\xBC\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x82"],
        ["\xF3\xB0\xBC\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x83"],
        ["\xF3\xB0\xBC\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x84"],
        ["\xF3\xB0\xBC\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x85"],
        ["\xF3\xB0\xBC\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x86"],
        ["\xF3\xB0\xBC\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x87"],
        ["\xF3\xB0\xBC\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x88"],
        ["\xF3\xB0\xBC\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x89"],
        ["\xF3\xB0\xBC\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8A"],
        ["\xF3\xB0\xBC\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8B"],
        ["\xF3\xB0\xBC\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8C"],
        ["\xF3\xB0\xBD\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8D"],
        ["\xF3\xB0\xBD\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8E"],
        ["\xF3\xB0\xBD\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8F"],
        ["\xF3\xB0\xBD\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x90"],
        ["\xF3\xB0\xBD\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x91"],
        ["\xF3\xB0\xBD\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x92"],
        ["\xF3\xB0\xBD\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x93"],
        ["\xF3\xB0\xBD\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x94"],
        ["\xF3\xB0\xBD\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x95"],
        ["\xF3\xB0\xBD\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x96"],
        ["\xF3\xB0\xBD\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x97"],
        ["\xF3\xB0\xBD\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x98"],
        ["\xF3\xB0\xBD\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x99"],
        ["\xF3\xB0\xBD\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9A"],
        ["\xF3\xB0\xBD\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9B"],
        ["\xF3\xB0\xBD\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9C"],
        ["\xF3\xB0\xBD\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9D"],
        ["\xF3\xB0\xBD\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9E"],
        ["\xF3\xB0\xBD\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9F"],
        ["\xF3\xB0\xBD\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA0"],
        ["\xF3\xB0\xBD\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA1"],
        ["\xF3\xB0\xBD\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA2"],
        ["\xF3\xB0\xBD\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA3"],
        ["\xF3\xB0\xBD\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA4"],
        ["\xF3\xB0\xBD\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA5"],
        ["\xF3\xB0\xBD\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA6"],
        ["\xF3\xB0\xBD\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA7"],
        ["\xF3\xB0\xBD\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA8"],
        ["\xF3\xB0\xBD\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA9"],
        ["\xF3\xB0\xBD\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAA"],
        ["\xF3\xB0\xBD\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAB"],
        ["\xF3\xB0\xBD\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAC"],
        ["\xF3\xB0\xBD\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAD"],
        ["\xF3\xB0\xBD\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAE"],
        ["\xF3\xB0\xBD\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAF"],
        ["\xF3\xB0\xBD\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB0"],
        ["\xF3\xB0\xBD\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB1"],
        ["\xF3\xB0\xBD\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB2"],
        ["\xF3\xB0\xBD\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB3"],
        ["\xF3\xB0\xBD\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB4"],
        ["\xF3\xB0\xBD\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB5"],
        ["\xF3\xB0\xBD\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB6"],
        ["\xF3\xB0\xBD\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB7"],
        ["\xF3\xB0\xBD\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB8"],
        ["\xF3\xB0\xBD\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB9"],
        ["\xF3\xB0\xBD\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBA"],
        ["\xF3\xB0\xBD\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBB"],
        ["\xF3\xB0\xBD\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBC"],
        ["\xF3\xB0\xBD\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBD"],
        ["\xF3\xB0\xBD\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBE"],
        ["\xF3\xB0\xBD\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBF"],
        ["\xF3\xB0\xBD\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC0"],
        ["\xF3\xB0\xBD\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC1"],
        ["\xF3\xB0\xBD\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC2"],
        ["\xF3\xB0\xBD\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC3"],
        ["\xF3\xB0\xBD\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC4"],
        ["\xF3\xB0\xBD\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC5"],
        ["\xF3\xB0\xBD\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC6"],
        ["\xF3\xB0\xBD\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC7"],
        ["\xF3\xB0\xBD\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC8"],
        ["\xF3\xB0\xBD\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC9"],
        ["\xF3\xB0\xBD\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCA"],
        ["\xF3\xB0\xBD\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCB"],
        ["\xF3\xB0\xBD\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCC"],
        ["\xF3\xB0\xBE\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCD"],
        ["\xF3\xB0\xBE\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCE"],
        ["\xF3\xB0\xBE\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCF"],
        ["\xF3\xB0\xBE\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD0"],
        ["\xF3\xB0\xBE\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD1"],
        ["\xF3\xB0\xBE\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD2"],
        ["\xF3\xB0\xBE\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD3"],
        ["\xF3\xB0\xBE\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD4"],
        ["\xF3\xB0\xBE\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD5"],
        ["\xF3\xB0\xBE\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD6"],
        ["\xF3\xB0\xBE\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD7"],
        ["\xF3\xB0\xBE\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD8"],
        ["\xF3\xB0\xBE\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD9"],
        ["\xF3\xB0\xBE\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDA"],
        ["\xF3\xB0\xBE\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDB"],
        ["\xF3\xB0\xBE\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDC"],
        ["\xF3\xB0\xBE\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDD"],
        ["\xF3\xB0\xBE\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDE"],
        ["\xF3\xB0\xBE\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDF"],
        ["\xF3\xB0\xBE\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE0"],
        ["\xF3\xB0\xBE\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE1"],
        ["\xF3\xB0\xBE\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE2"],
        ["\xF3\xB0\xBE\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE3"],
        ["\xF3\xB0\xBE\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE4"],
        ["\xF3\xB0\xBE\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE5"],
        ["\xF3\xB0\xBE\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE6"],
        ["\xF3\xB0\xBE\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE7"],
        ["\xF3\xB0\xBE\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE8"],
        ["\xF3\xB0\xBE\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE9"],
        ["\xF3\xB0\xBE\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEA"],
        ["\xF3\xB0\xBE\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEB"],
        ["\xF3\xB0\xBE\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEC"],
        ["\xF3\xB0\xBE\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xED"],
        ["\xF3\xB0\xBE\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEE"],
        ["\xF3\xB0\xBE\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEF"],
        ["\xF3\xB0\xBE\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF0"],
        ["\xF3\xB0\xBE\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF1"],
        ["\xF3\xB0\xBE\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF2"],
        ["\xF3\xB0\xBE\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF3"],
        ["\xF3\xB0\xBE\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF4"],
        ["\xF3\xB0\xBE\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF5"],
        ["\xF3\xB0\xBE\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF6"],
        ["\xF3\xB0\xBE\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF7"],
        ["\xF3\xB0\xBE\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF8"],
        ["\xF3\xB0\xBE\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF9"],
        ["\xF3\xB0\xBE\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xFA"],
        ["\xF3\xB0\xBE\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xFB"],
        ["\xF3\xB0\xBE\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xFC"],
        ["\xF3\xB0\xBE\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x40"],
        ["\xF3\xB0\xBE\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x41"],
        ["\xF3\xB0\xBE\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x42"],
        ["\xF3\xB0\xBE\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x43"],
        ["\xF3\xB0\xBE\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x44"],
        ["\xF3\xB0\xBE\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x45"],
        ["\xF3\xB0\xBE\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x46"],
        ["\xF3\xB0\xBE\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x47"],
        ["\xF3\xB0\xBE\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x48"],
        ["\xF3\xB0\xBE\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x49"],
        ["\xF3\xB0\xBE\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4A"],
        ["\xF3\xB0\xBE\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4B"],
        ["\xF3\xB0\xBE\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4C"],
        ["\xF3\xB0\xBE\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4D"],
        ["\xF3\xB0\xBE\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4E"],
        ["\xF3\xB0\xBE\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4F"],
        ["\xF3\xB0\xBF\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x50"],
        ["\xF3\xB0\xBF\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x51"],
        ["\xF3\xB0\xBF\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x52"],
        ["\xF3\xB0\xBF\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x53"],
        ["\xF3\xB0\xBF\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x54"],
        ["\xF3\xB0\xBF\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x55"],
        ["\xF3\xB0\xBF\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x56"],
        ["\xF3\xB0\xBF\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x57"],
        ["\xF3\xB0\xBF\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x58"],
        ["\xF3\xB0\xBF\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x59"],
        ["\xF3\xB0\xBF\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5A"],
        ["\xF3\xB0\xBF\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5B"],
        ["\xF3\xB0\xBF\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5C"],
        ["\xF3\xB0\xBF\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5D"],
        ["\xF3\xB0\xBF\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5E"],
        ["\xF3\xB0\xBF\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5F"],
        ["\xF3\xB0\xBF\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x60"],
        ["\xF3\xB0\xBF\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x61"],
        ["\xF3\xB0\xBF\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x62"],
        ["\xF3\xB0\xBF\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x63"],
        ["\xF3\xB0\xBF\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x64"],
        ["\xF3\xB0\xBF\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x65"],
        ["\xF3\xB0\xBF\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x66"],
        ["\xF3\xB0\xBF\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x67"],
        ["\xF3\xB0\xBF\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x68"],
        ["\xF3\xB0\xBF\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x69"],
        ["\xF3\xB0\xBF\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6A"],
        ["\xF3\xB0\xBF\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6B"],
        ["\xF3\xB0\xBF\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6C"],
        ["\xF3\xB0\xBF\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6D"],
        ["\xF3\xB0\xBF\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6E"],
        ["\xF3\xB0\xBF\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6F"],
        ["\xF3\xB0\xBF\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x70"],
        ["\xF3\xB0\xBF\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x71"],
        ["\xF3\xB0\xBF\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x72"],
        ["\xF3\xB0\xBF\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x73"],
        ["\xF3\xB0\xBF\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x74"],
        ["\xF3\xB0\xBF\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x75"],
        ["\xF3\xB0\xBF\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x76"],
        ["\xF3\xB0\xBF\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x77"],
        ["\xF3\xB0\xBF\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x78"],
        ["\xF3\xB0\xBF\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x79"],
        ["\xF3\xB0\xBF\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x7A"],
        ["\xF3\xB0\xBF\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x7B"],
        ["\xF3\xB0\xBF\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x7C"],
        ["\xF3\xB0\xBF\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x7D"],
        ["\xF3\xB0\xBF\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x7E"],
        ["\xF3\xB0\xBF\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x80"],
        ["\xF3\xB0\xBF\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x81"],
        ["\xF3\xB0\xBF\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x82"],
        ["\xF3\xB0\xBF\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x83"],
        ["\xF3\xB0\xBF\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x84"],
        ["\xF3\xB0\xBF\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x85"],
        ["\xF3\xB0\xBF\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x86"],
        ["\xF3\xB0\xBF\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x87"],
        ["\xF3\xB0\xBF\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x88"],
        ["\xF3\xB0\xBF\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x89"],
        ["\xF3\xB0\xBF\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8A"],
        ["\xF3\xB0\xBF\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8B"],
        ["\xF3\xB0\xBF\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8C"],
        ["\xF3\xB0\xBF\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8D"],
        ["\xF3\xB0\xBF\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8E"],
        ["\xF3\xB0\xBF\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8F"],
        ["\xF3\xB0\xBF\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x90"],
        ["\xF3\xB1\x80\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x91"],
        ["\xF3\xB1\x80\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x92"],
        ["\xF3\xB1\x80\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x93"],
        ["\xF3\xB1\x80\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x94"],
        ["\xF3\xB1\x80\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x95"],
        ["\xF3\xB1\x80\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x96"],
        ["\xF3\xB1\x80\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x97"],
        ["\xF3\xB1\x80\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x98"],
        ["\xF3\xB1\x80\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x99"],
        ["\xF3\xB1\x80\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9A"],
        ["\xF3\xB1\x80\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9B"],
        ["\xF3\xB1\x80\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9C"],
        ["\xF3\xB1\x80\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9D"],
        ["\xF3\xB1\x80\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9E"],
        ["\xF3\xB1\x80\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9F"],
        ["\xF3\xB1\x80\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA0"],
        ["\xF3\xB1\x80\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA1"],
        ["\xF3\xB1\x80\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA2"],
        ["\xF3\xB1\x80\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA3"],
        ["\xF3\xB1\x80\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA4"],
        ["\xF3\xB1\x80\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA5"],
        ["\xF3\xB1\x80\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA6"],
        ["\xF3\xB1\x80\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA7"],
        ["\xF3\xB1\x80\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA8"],
        ["\xF3\xB1\x80\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA9"],
        ["\xF3\xB1\x80\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAA"],
        ["\xF3\xB1\x80\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAB"],
        ["\xF3\xB1\x80\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAC"],
        ["\xF3\xB1\x80\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAD"],
        ["\xF3\xB1\x80\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAE"],
        ["\xF3\xB1\x80\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAF"],
        ["\xF3\xB1\x80\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB0"],
        ["\xF3\xB1\x80\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB1"],
        ["\xF3\xB1\x80\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB2"],
        ["\xF3\xB1\x80\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB3"],
        ["\xF3\xB1\x80\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB4"],
        ["\xF3\xB1\x80\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB5"],
        ["\xF3\xB1\x80\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB6"],
        ["\xF3\xB1\x80\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB7"],
        ["\xF3\xB1\x80\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB8"],
        ["\xF3\xB1\x80\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB9"],
        ["\xF3\xB1\x80\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBA"],
        ["\xF3\xB1\x80\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBB"],
        ["\xF3\xB1\x80\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBC"],
        ["\xF3\xB1\x80\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBD"],
        ["\xF3\xB1\x80\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBE"],
        ["\xF3\xB1\x80\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBF"],
        ["\xF3\xB1\x80\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC0"],
        ["\xF3\xB1\x80\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC1"],
        ["\xF3\xB1\x80\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC2"],
        ["\xF3\xB1\x80\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC3"],
        ["\xF3\xB1\x80\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC4"],
        ["\xF3\xB1\x80\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC5"],
        ["\xF3\xB1\x80\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC6"],
        ["\xF3\xB1\x80\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC7"],
        ["\xF3\xB1\x80\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC8"],
        ["\xF3\xB1\x80\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC9"],
        ["\xF3\xB1\x80\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCA"],
        ["\xF3\xB1\x80\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCB"],
        ["\xF3\xB1\x80\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCC"],
        ["\xF3\xB1\x80\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCD"],
        ["\xF3\xB1\x80\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCE"],
        ["\xF3\xB1\x80\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCF"],
        ["\xF3\xB1\x80\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD0"],
        ["\xF3\xB1\x81\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD1"],
        ["\xF3\xB1\x81\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD2"],
        ["\xF3\xB1\x81\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD3"],
        ["\xF3\xB1\x81\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD4"],
        ["\xF3\xB1\x81\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD5"],
        ["\xF3\xB1\x81\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD6"],
        ["\xF3\xB1\x81\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD7"],
        ["\xF3\xB1\x81\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD8"],
        ["\xF3\xB1\x81\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD9"],
        ["\xF3\xB1\x81\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDA"],
        ["\xF3\xB1\x81\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDB"],
        ["\xF3\xB1\x81\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDC"],
        ["\xF3\xB1\x81\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDD"],
        ["\xF3\xB1\x81\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDE"],
        ["\xF3\xB1\x81\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDF"],
        ["\xF3\xB1\x81\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE0"],
        ["\xF3\xB1\x81\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE1"],
        ["\xF3\xB1\x81\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE2"],
        ["\xF3\xB1\x81\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE3"],
        ["\xF3\xB1\x81\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE4"],
        ["\xF3\xB1\x81\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE5"],
        ["\xF3\xB1\x81\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE6"],
        ["\xF3\xB1\x81\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE7"],
        ["\xF3\xB1\x81\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE8"],
        ["\xF3\xB1\x81\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE9"],
        ["\xF3\xB1\x81\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xEA"],
        ["\xF3\xB1\x81\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xEB"],
        ["\xF3\xB1\x81\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xEC"],
        ["\xF3\xB1\x81\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xED"],
        ["\xF3\xB1\x81\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xEE"],
        ["\xF3\xB1\x81\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xEF"],
        ["\xF3\xB1\x81\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF0"],
        ["\xF3\xB1\x81\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF1"],
        ["\xF3\xB1\x81\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF2"],
        ["\xF3\xB1\x81\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF3"],
        ["\xF3\xB1\x81\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF4"],
        ["\xF3\xB1\x81\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF5"],
        ["\xF3\xB1\x81\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF6"],
        ["\xF3\xB1\x81\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF7"],
        ["\xF3\xB1\x81\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF8"],
        ["\xF3\xB1\x81\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF9"],
        ["\xF3\xB1\x81\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xFA"],
        ["\xF3\xB1\x81\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xFB"],
        ["\xF3\xB1\x81\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xFC"],
        ["\xF3\xB1\x81\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x40"],
        ["\xF3\xB1\x81\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x41"],
        ["\xF3\xB1\x81\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x42"],
        ["\xF3\xB1\x81\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x43"],
        ["\xF3\xB1\x81\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x44"],
        ["\xF3\xB1\x81\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x45"],
        ["\xF3\xB1\x81\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x46"],
        ["\xF3\xB1\x81\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x47"],
        ["\xF3\xB1\x81\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x48"],
        ["\xF3\xB1\x81\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x49"],
        ["\xF3\xB1\x81\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4A"],
        ["\xF3\xB1\x81\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4B"],
        ["\xF3\xB1\x81\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4C"],
        ["\xF3\xB1\x81\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4D"],
        ["\xF3\xB1\x81\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4E"],
        ["\xF3\xB1\x81\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4F"],
        ["\xF3\xB1\x81\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x50"],
        ["\xF3\xB1\x81\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x51"],
        ["\xF3\xB1\x81\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x52"],
        ["\xF3\xB1\x81\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x53"],
        ["\xF3\xB1\x82\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x54"],
        ["\xF3\xB1\x82\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x55"],
        ["\xF3\xB1\x82\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x56"],
        ["\xF3\xB1\x82\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x57"],
        ["\xF3\xB1\x82\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x58"],
        ["\xF3\xB1\x82\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x59"],
        ["\xF3\xB1\x82\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5A"],
        ["\xF3\xB1\x82\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5B"],
        ["\xF3\xB1\x82\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5C"],
        ["\xF3\xB1\x82\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5D"],
        ["\xF3\xB1\x82\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5E"],
        ["\xF3\xB1\x82\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5F"],
        ["\xF3\xB1\x82\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x60"],
        ["\xF3\xB1\x82\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x61"],
        ["\xF3\xB1\x82\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x62"],
        ["\xF3\xB1\x82\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x63"],
        ["\xF3\xB1\x82\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x64"],
        ["\xF3\xB1\x82\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x65"],
        ["\xF3\xB1\x82\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x66"],
        ["\xF3\xB1\x82\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x67"],
        ["\xF3\xB1\x82\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x68"],
        ["\xF3\xB1\x82\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x69"],
        ["\xF3\xB1\x82\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6A"],
        ["\xF3\xB1\x82\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6B"],
        ["\xF3\xB1\x82\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6C"],
        ["\xF3\xB1\x82\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6D"],
        ["\xF3\xB1\x82\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6E"],
        ["\xF3\xB1\x82\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6F"],
        ["\xF3\xB1\x82\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x70"],
        ["\xF3\xB1\x82\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x71"],
        ["\xF3\xB1\x82\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x72"],
        ["\xF3\xB1\x82\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x73"],
        ["\xF3\xB1\x82\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x74"],
        ["\xF3\xB1\x82\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x75"],
        ["\xF3\xB1\x82\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x76"],
        ["\xF3\xB1\x82\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x77"],
        ["\xF3\xB1\x82\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x78"],
        ["\xF3\xB1\x82\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x79"],
        ["\xF3\xB1\x82\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x7A"],
        ["\xF3\xB1\x82\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x7B"],
        ["\xF3\xB1\x82\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x7C"],
        ["\xF3\xB1\x82\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x7D"],
        ["\xF3\xB1\x82\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x7E"],
        ["\xF3\xB1\x82\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x80"],
        ["\xF3\xB1\x82\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x81"],
        ["\xF3\xB1\x82\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x82"],
        ["\xF3\xB1\x82\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x83"],
        ["\xF3\xB1\x82\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x84"],
        ["\xF3\xB1\x82\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x85"],
        ["\xF3\xB1\x82\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x86"],
        ["\xF3\xB1\x82\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x87"],
        ["\xF3\xB1\x82\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x88"],
        ["\xF3\xB1\x82\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x89"],
        ["\xF3\xB1\x82\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8A"],
        ["\xF3\xB1\x82\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8B"],
        ["\xF3\xB1\x82\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8C"],
        ["\xF3\xB1\x82\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8D"],
        ["\xF3\xB1\x82\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8E"],
        ["\xF3\xB1\x82\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8F"],
        ["\xF3\xB1\x82\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x90"],
        ["\xF3\xB1\x82\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x91"],
        ["\xF3\xB1\x82\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x92"],
        ["\xF3\xB1\x82\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x93"],
        ["\xF3\xB1\x82\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x94"],
        ["\xF3\xB1\x83\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x95"],
        ["\xF3\xB1\x83\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x96"],
        ["\xF3\xB1\x83\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x97"],
        ["\xF3\xB1\x83\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x98"],
        ["\xF3\xB1\x83\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x99"],
        ["\xF3\xB1\x83\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9A"],
        ["\xF3\xB1\x83\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9B"],
        ["\xF3\xB1\x83\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9C"],
        ["\xF3\xB1\x83\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9D"],
        ["\xF3\xB1\x83\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9E"],
        ["\xF3\xB1\x83\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9F"],
        ["\xF3\xB1\x83\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA0"],
        ["\xF3\xB1\x83\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA1"],
        ["\xF3\xB1\x83\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA2"],
        ["\xF3\xB1\x83\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA3"],
        ["\xF3\xB1\x83\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA4"],
        ["\xF3\xB1\x83\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA5"],
        ["\xF3\xB1\x83\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA6"],
        ["\xF3\xB1\x83\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA7"],
        ["\xF3\xB1\x83\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA8"],
        ["\xF3\xB1\x83\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA9"],
        ["\xF3\xB1\x83\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAA"],
        ["\xF3\xB1\x83\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAB"],
        ["\xF3\xB1\x83\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAC"],
        ["\xF3\xB1\x83\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAD"],
        ["\xF3\xB1\x83\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAE"],
        ["\xF3\xB1\x83\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAF"],
        ["\xF3\xB1\x83\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB0"],
        ["\xF3\xB1\x83\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB1"],
        ["\xF3\xB1\x83\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB2"],
        ["\xF3\xB1\x83\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB3"],
        ["\xF3\xB1\x83\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB4"],
        ["\xF3\xB1\x83\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB5"],
        ["\xF3\xB1\x83\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB6"],
        ["\xF3\xB1\x83\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB7"],
        ["\xF3\xB1\x83\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB8"],
        ["\xF3\xB1\x83\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB9"],
        ["\xF3\xB1\x83\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBA"],
        ["\xF3\xB1\x83\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBB"],
        ["\xF3\xB1\x83\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBC"],
        ["\xF3\xB1\x83\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBD"],
        ["\xF3\xB1\x83\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBE"],
        ["\xF3\xB1\x83\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBF"],
        ["\xF3\xB1\x83\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC0"],
        ["\xF3\xB1\x83\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC1"],
        ["\xF3\xB1\x83\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC2"],
        ["\xF3\xB1\x83\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC3"],
        ["\xF3\xB1\x83\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC4"],
        ["\xF3\xB1\x83\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC5"],
        ["\xF3\xB1\x83\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC6"],
        ["\xF3\xB1\x83\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC7"],
        ["\xF3\xB1\x83\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC8"],
        ["\xF3\xB1\x83\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC9"],
        ["\xF3\xB1\x83\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCA"],
        ["\xF3\xB1\x83\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCB"],
        ["\xF3\xB1\x83\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCC"],
        ["\xF3\xB1\x83\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCD"],
        ["\xF3\xB1\x83\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCE"],
        ["\xF3\xB1\x83\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCF"],
        ["\xF3\xB1\x83\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD0"],
        ["\xF3\xB1\x83\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD1"],
        ["\xF3\xB1\x83\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD2"],
        ["\xF3\xB1\x83\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD3"],
        ["\xF3\xB1\x83\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD4"],
        ["\xF3\xB1\x84\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD5"],
        ["\xF3\xB1\x84\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD6"],
        ["\xF3\xB1\x84\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD7"],
        ["\xF3\xB1\x84\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD8"],
        ["\xF3\xB1\x84\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD9"],
        ["\xF3\xB1\x84\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDA"],
        ["\xF3\xB1\x84\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDB"],
        ["\xF3\xB1\x84\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDC"],
        ["\xF3\xB1\x84\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDD"],
        ["\xF3\xB1\x84\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDE"],
        ["\xF3\xB1\x84\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDF"],
        ["\xF3\xB1\x84\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE0"],
        ["\xF3\xB1\x84\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE1"],
        ["\xF3\xB1\x84\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE2"],
        ["\xF3\xB1\x84\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE3"],
        ["\xF3\xB1\x84\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE4"],
        ["\xF3\xB1\x84\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE5"],
        ["\xF3\xB1\x84\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE6"],
        ["\xF3\xB1\x84\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE7"],
        ["\xF3\xB1\x84\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE8"],
        ["\xF3\xB1\x84\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE9"],
        ["\xF3\xB1\x84\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEA"],
        ["\xF3\xB1\x84\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEB"],
        ["\xF3\xB1\x84\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEC"],
        ["\xF3\xB1\x84\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xED"],
        ["\xF3\xB1\x84\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEE"],
        ["\xF3\xB1\x84\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEF"],
        ["\xF3\xB1\x84\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF0"],
        ["\xF3\xB1\x84\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF1"],
        ["\xF3\xB1\x84\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF2"],
        ["\xF3\xB1\x84\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF3"],
        ["\xF3\xB1\x84\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF4"],
        ["\xF3\xB1\x84\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF5"],
        ["\xF3\xB1\x84\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF6"],
        ["\xF3\xB1\x84\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF7"],
        ["\xF3\xB1\x84\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF8"],
        ["\xF3\xB1\x84\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF9"],
        ["\xF3\xB1\x84\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xFA"],
        ["\xF3\xB1\x84\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xFB"],
        ["\xF3\xB1\x84\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xFC"],
        ["\xF3\xB1\x84\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x40"],
        ["\xF3\xB1\x84\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x41"],
        ["\xF3\xB1\x84\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x42"],
        ["\xF3\xB1\x84\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x43"],
        ["\xF3\xB1\x84\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x44"],
        ["\xF3\xB1\x84\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x45"],
        ["\xF3\xB1\x84\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x46"],
        ["\xF3\xB1\x84\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x47"],
        ["\xF3\xB1\x84\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x48"],
        ["\xF3\xB1\x84\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x49"],
        ["\xF3\xB1\x84\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4A"],
        ["\xF3\xB1\x84\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4B"],
        ["\xF3\xB1\x84\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4C"],
        ["\xF3\xB1\x84\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4D"],
        ["\xF3\xB1\x84\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4E"],
        ["\xF3\xB1\x84\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4F"],
        ["\xF3\xB1\x84\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x50"],
        ["\xF3\xB1\x84\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x51"],
        ["\xF3\xB1\x84\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x52"],
        ["\xF3\xB1\x84\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x53"],
        ["\xF3\xB1\x84\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x54"],
        ["\xF3\xB1\x84\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x55"],
        ["\xF3\xB1\x84\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x56"],
        ["\xF3\xB1\x84\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x57"],
        ["\xF3\xB1\x85\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x58"],
        ["\xF3\xB1\x85\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x59"],
        ["\xF3\xB1\x85\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5A"],
        ["\xF3\xB1\x85\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5B"],
        ["\xF3\xB1\x85\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5C"],
        ["\xF3\xB1\x85\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5D"],
        ["\xF3\xB1\x85\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5E"],
        ["\xF3\xB1\x85\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5F"],
        ["\xF3\xB1\x85\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x60"],
        ["\xF3\xB1\x85\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x61"],
        ["\xF3\xB1\x85\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x62"],
        ["\xF3\xB1\x85\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x63"],
        ["\xF3\xB1\x85\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x64"],
        ["\xF3\xB1\x85\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x65"],
        ["\xF3\xB1\x85\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x66"],
        ["\xF3\xB1\x85\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x67"],
        ["\xF3\xB1\x85\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x68"],
        ["\xF3\xB1\x85\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x69"],
        ["\xF3\xB1\x85\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6A"],
        ["\xF3\xB1\x85\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6B"],
        ["\xF3\xB1\x85\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6C"],
        ["\xF3\xB1\x85\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6D"],
        ["\xF3\xB1\x85\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6E"],
        ["\xF3\xB1\x85\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6F"],
        ["\xF3\xB1\x85\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x70"],
        ["\xF3\xB1\x85\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x71"],
        ["\xF3\xB1\x85\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x72"],
        ["\xF3\xB1\x85\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x73"],
        ["\xF3\xB1\x85\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x74"],
        ["\xF3\xB1\x85\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x75"],
        ["\xF3\xB1\x85\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x76"],
        ["\xF3\xB1\x85\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x77"],
        ["\xF3\xB1\x85\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x78"],
        ["\xF3\xB1\x85\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x79"],
        ["\xF3\xB1\x85\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x7A"],
        ["\xF3\xB1\x85\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x7B"],
        ["\xF3\xB1\x85\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x7C"],
        ["\xF3\xB1\x85\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x7D"],
        ["\xF3\xB1\x85\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x7E"],
        ["\xF3\xB1\x85\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x80"],
        ["\xF3\xB1\x85\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x81"],
        ["\xF3\xB1\x85\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x82"],
        ["\xF3\xB1\x85\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x83"],
        ["\xF3\xB1\x85\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x84"],
        ["\xF3\xB1\x85\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x85"],
        ["\xF3\xB1\x85\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x86"],
        ["\xF3\xB1\x85\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x87"],
        ["\xF3\xB1\x85\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x88"],
        ["\xF3\xB1\x85\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x89"],
        ["\xF3\xB1\x85\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8A"],
        ["\xF3\xB1\x85\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8B"],
        ["\xF3\xB1\x85\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8C"],
        ["\xF3\xB1\x85\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8D"],
        ["\xF3\xB1\x85\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8E"],
        ["\xF3\xB1\x85\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8F"],
        ["\xF3\xB1\x85\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x90"],
        ["\xF3\xB1\x85\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x91"],
        ["\xF3\xB1\x85\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x92"],
        ["\xF3\xB1\x85\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x93"],
        ["\xF3\xB1\x85\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x94"],
        ["\xF3\xB1\x85\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x95"],
        ["\xF3\xB1\x85\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x96"],
        ["\xF3\xB1\x85\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x97"],
        ["\xF3\xB1\x85\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x98"],
        ["\xF3\xB1\x86\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x99"],
        ["\xF3\xB1\x86\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9A"],
        ["\xF3\xB1\x86\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9B"],
        ["\xF3\xB1\x86\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9C"],
        ["\xF3\xB1\x86\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9D"],
        ["\xF3\xB1\x86\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9E"],
        ["\xF3\xB1\x86\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9F"],
        ["\xF3\xB1\x86\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA0"],
        ["\xF3\xB1\x86\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA1"],
        ["\xF3\xB1\x86\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA2"],
        ["\xF3\xB1\x86\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA3"],
        ["\xF3\xB1\x86\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA4"],
        ["\xF3\xB1\x86\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA5"],
        ["\xF3\xB1\x86\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA6"],
        ["\xF3\xB1\x86\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA7"],
        ["\xF3\xB1\x86\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA8"],
        ["\xF3\xB1\x86\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA9"],
        ["\xF3\xB1\x86\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAA"],
        ["\xF3\xB1\x86\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAB"],
        ["\xF3\xB1\x86\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAC"],
        ["\xF3\xB1\x86\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAD"],
        ["\xF3\xB1\x86\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAE"],
        ["\xF3\xB1\x86\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAF"],
        ["\xF3\xB1\x86\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB0"],
        ["\xF3\xB1\x86\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB1"],
        ["\xF3\xB1\x86\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB2"],
        ["\xF3\xB1\x86\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB3"],
        ["\xF3\xB1\x86\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB4"],
        ["\xF3\xB1\x86\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB5"],
        ["\xF3\xB1\x86\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB6"],
        ["\xF3\xB1\x86\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB7"],
        ["\xF3\xB1\x86\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB8"],
        ["\xF3\xB1\x86\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB9"],
        ["\xF3\xB1\x86\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBA"],
        ["\xF3\xB1\x86\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBB"],
        ["\xF3\xB1\x86\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBC"],
        ["\xF3\xB1\x86\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBD"],
        ["\xF3\xB1\x86\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBE"],
        ["\xF3\xB1\x86\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBF"],
        ["\xF3\xB1\x86\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC0"],
        ["\xF3\xB1\x86\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC1"],
        ["\xF3\xB1\x86\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC2"],
        ["\xF3\xB1\x86\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC3"],
        ["\xF3\xB1\x86\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC4"],
        ["\xF3\xB1\x86\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC5"],
        ["\xF3\xB1\x86\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC6"],
        ["\xF3\xB1\x86\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC7"],
        ["\xF3\xB1\x86\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC8"],
        ["\xF3\xB1\x86\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC9"],
        ["\xF3\xB1\x86\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCA"],
        ["\xF3\xB1\x86\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCB"],
        ["\xF3\xB1\x86\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCC"],
        ["\xF3\xB1\x86\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCD"],
        ["\xF3\xB1\x86\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCE"],
        ["\xF3\xB1\x86\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCF"],
        ["\xF3\xB1\x86\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD0"],
        ["\xF3\xB1\x86\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD1"],
        ["\xF3\xB1\x86\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD2"],
        ["\xF3\xB1\x86\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD3"],
        ["\xF3\xB1\x86\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD4"],
        ["\xF3\xB1\x86\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD5"],
        ["\xF3\xB1\x86\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD6"],
        ["\xF3\xB1\x86\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD7"],
        ["\xF3\xB1\x86\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD8"],
        ["\xF3\xB1\x87\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD9"],
        ["\xF3\xB1\x87\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDA"],
        ["\xF3\xB1\x87\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDB"],
        ["\xF3\xB1\x87\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDC"],
        ["\xF3\xB1\x87\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDD"],
        ["\xF3\xB1\x87\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDE"],
        ["\xF3\xB1\x87\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDF"],
        ["\xF3\xB1\x87\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE0"],
        ["\xF3\xB1\x87\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE1"],
        ["\xF3\xB1\x87\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE2"],
        ["\xF3\xB1\x87\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE3"],
        ["\xF3\xB1\x87\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE4"],
        ["\xF3\xB1\x87\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE5"],
        ["\xF3\xB1\x87\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE6"],
        ["\xF3\xB1\x87\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE7"],
        ["\xF3\xB1\x87\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE8"],
        ["\xF3\xB1\x87\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE9"],
        ["\xF3\xB1\x87\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xEA"],
        ["\xF3\xB1\x87\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xEB"],
        ["\xF3\xB1\x87\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xEC"],
        ["\xF3\xB1\x87\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xED"],
        ["\xF3\xB1\x87\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xEE"],
        ["\xF3\xB1\x87\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xEF"],
        ["\xF3\xB1\x87\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF0"],
        ["\xF3\xB1\x87\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF1"],
        ["\xF3\xB1\x87\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF2"],
        ["\xF3\xB1\x87\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF3"],
        ["\xF3\xB1\x87\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF4"],
        ["\xF3\xB1\x87\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF5"],
        ["\xF3\xB1\x87\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF6"],
        ["\xF3\xB1\x87\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF7"],
        ["\xF3\xB1\x87\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF8"],
        ["\xF3\xB1\x87\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF9"],
        ["\xF3\xB1\x87\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xFA"],
        ["\xF3\xB1\x87\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xFB"],
        ["\xF3\xB1\x87\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xFC"],
        ["\xF3\xB1\x87\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x40"],
        ["\xF3\xB1\x87\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x41"],
        ["\xF3\xB1\x87\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x42"],
        ["\xF3\xB1\x87\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x43"],
        ["\xF3\xB1\x87\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x44"],
        ["\xF3\xB1\x87\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x45"],
        ["\xF3\xB1\x87\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x46"],
        ["\xF3\xB1\x87\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x47"],
        ["\xF3\xB1\x87\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x48"],
        ["\xF3\xB1\x87\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x49"],
        ["\xF3\xB1\x87\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4A"],
        ["\xF3\xB1\x87\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4B"],
        ["\xF3\xB1\x87\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4C"],
        ["\xF3\xB1\x87\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4D"],
        ["\xF3\xB1\x87\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4E"],
        ["\xF3\xB1\x87\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4F"],
        ["\xF3\xB1\x87\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x50"],
        ["\xF3\xB1\x87\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x51"],
        ["\xF3\xB1\x87\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x52"],
        ["\xF3\xB1\x87\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x53"],
        ["\xF3\xB1\x87\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x54"],
        ["\xF3\xB1\x87\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x55"],
        ["\xF3\xB1\x87\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x56"],
        ["\xF3\xB1\x87\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x57"],
        ["\xF3\xB1\x87\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x58"],
        ["\xF3\xB1\x87\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x59"],
        ["\xF3\xB1\x87\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5A"],
        ["\xF3\xB1\x87\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5B"],
        ["\xF3\xB1\x88\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5C"],
        ["\xF3\xB1\x88\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5D"],
        ["\xF3\xB1\x88\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5E"],
        ["\xF3\xB1\x88\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5F"],
        ["\xF3\xB1\x88\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x60"],
        ["\xF3\xB1\x88\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x61"],
        ["\xF3\xB1\x88\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x62"],
        ["\xF3\xB1\x88\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x63"],
        ["\xF3\xB1\x88\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x64"],
        ["\xF3\xB1\x88\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x65"],
        ["\xF3\xB1\x88\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x66"],
        ["\xF3\xB1\x88\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x67"],
        ["\xF3\xB1\x88\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x68"],
        ["\xF3\xB1\x88\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x69"],
        ["\xF3\xB1\x88\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6A"],
        ["\xF3\xB1\x88\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6B"],
        ["\xF3\xB1\x88\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6C"],
        ["\xF3\xB1\x88\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6D"],
        ["\xF3\xB1\x88\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6E"],
        ["\xF3\xB1\x88\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6F"],
        ["\xF3\xB1\x88\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x70"],
        ["\xF3\xB1\x88\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x71"],
        ["\xF3\xB1\x88\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x72"],
        ["\xF3\xB1\x89\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x9F"],
        ["\xF3\xB1\x89\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA0"],
        ["\xF3\xB1\x89\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA1"],
        ["\xF3\xB1\x89\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA2"],
        ["\xF3\xB1\x89\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA3"],
        ["\xF3\xB1\x89\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA4"],
        ["\xF3\xB1\x89\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA5"],
        ["\xF3\xB1\x89\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA6"],
        ["\xF3\xB1\x89\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA7"],
        ["\xF3\xB1\x89\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA8"],
        ["\xF3\xB1\x89\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA9"],
        ["\xF3\xB1\x89\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAA"],
        ["\xF3\xB1\x89\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAB"],
        ["\xF3\xB1\x89\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAC"],
        ["\xF3\xB1\x89\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAD"],
        ["\xF3\xB1\x89\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAE"],
        ["\xF3\xB1\x89\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAF"],
        ["\xF3\xB1\x89\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB0"],
        ["\xF3\xB1\x89\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB1"],
        ["\xF3\xB1\x89\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB2"],
        ["\xF3\xB1\x89\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB3"],
        ["\xF3\xB1\x89\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB4"],
        ["\xF3\xB1\x89\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB5"],
        ["\xF3\xB1\x89\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB6"],
        ["\xF3\xB1\x89\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB7"],
        ["\xF3\xB1\x89\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB8"],
        ["\xF3\xB1\x89\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB9"],
        ["\xF3\xB1\x89\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBA"],
        ["\xF3\xB1\x89\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBB"],
        ["\xF3\xB1\x89\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBC"],
        ["\xF3\xB1\x89\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBD"],
        ["\xF3\xB1\x89\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBE"],
        ["\xF3\xB1\x89\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBF"],
        ["\xF3\xB1\x89\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC0"],
        ["\xF3\xB1\x89\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC1"],
        ["\xF3\xB1\x89\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC2"],
        ["\xF3\xB1\x89\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC3"],
        ["\xF3\xB1\x89\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC4"],
        ["\xF3\xB1\x89\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC5"],
        ["\xF3\xB1\x89\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC6"],
        ["\xF3\xB1\x89\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC7"],
        ["\xF3\xB1\x89\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC8"],
        ["\xF3\xB1\x89\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC9"],
        ["\xF3\xB1\x89\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCA"],
        ["\xF3\xB1\x89\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCB"],
        ["\xF3\xB1\x89\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCC"],
        ["\xF3\xB1\x89\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCD"],
        ["\xF3\xB1\x89\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCE"],
        ["\xF3\xB1\x89\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCF"],
        ["\xF3\xB1\x89\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD0"],
        ["\xF3\xB1\x89\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD1"],
        ["\xF3\xB1\x89\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD2"],
        ["\xF3\xB1\x89\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD3"],
        ["\xF3\xB1\x89\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD4"],
        ["\xF3\xB1\x89\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD5"],
        ["\xF3\xB1\x89\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD6"],
        ["\xF3\xB1\x89\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD7"],
        ["\xF3\xB1\x89\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD8"],
        ["\xF3\xB1\x89\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD9"],
        ["\xF3\xB1\x89\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDA"],
        ["\xF3\xB1\x89\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDB"],
        ["\xF3\xB1\x89\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDC"],
        ["\xF3\xB1\x8A\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDD"],
        ["\xF3\xB1\x8A\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDE"],
        ["\xF3\xB1\x8A\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDF"],
        ["\xF3\xB1\x8A\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE0"],
        ["\xF3\xB1\x8A\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE1"],
        ["\xF3\xB1\x8A\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE2"],
        ["\xF3\xB1\x8A\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE3"],
        ["\xF3\xB1\x8A\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE4"],
        ["\xF3\xB1\x8A\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE5"],
        ["\xF3\xB1\x8A\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE6"],
        ["\xF3\xB1\x8A\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE7"],
        ["\xF3\xB1\x8A\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE8"],
        ["\xF3\xB1\x8A\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE9"],
        ["\xF3\xB1\x8A\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEA"],
        ["\xF3\xB1\x8A\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEB"],
        ["\xF3\xB1\x8A\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEC"],
        ["\xF3\xB1\x8A\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xED"],
        ["\xF3\xB1\x8A\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEE"],
        ["\xF3\xB1\x8A\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEF"],
        ["\xF3\xB1\x8A\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF0"],
        ["\xF3\xB1\x8A\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF1"],
        ["\xF3\xB1\x8A\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF2"],
        ["\xF3\xB1\x8A\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF3"],
        ["\xF3\xB1\x8A\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF4"],
        ["\xF3\xB1\x8A\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF5"],
        ["\xF3\xB1\x8A\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF6"],
        ["\xF3\xB1\x8A\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF7"],
        ["\xF3\xB1\x8A\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF8"],
        ["\xF3\xB1\x8A\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF9"],
        ["\xF3\xB1\x8A\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xFA"],
        ["\xF3\xB1\x8A\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xFB"],
        ["\xF3\xB1\x8A\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xFC"],
        ["\xF3\xB1\x8A\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x40"],
        ["\xF3\xB1\x8A\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x41"],
        ["\xF3\xB1\x8A\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x42"],
        ["\xF3\xB1\x8A\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x43"],
        ["\xF3\xB1\x8A\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x44"],
        ["\xF3\xB1\x8A\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x45"],
        ["\xF3\xB1\x8A\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x46"],
        ["\xF3\xB1\x8A\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x47"],
        ["\xF3\xB1\x8A\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x48"],
        ["\xF3\xB1\x8A\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x49"],
        ["\xF3\xB1\x8A\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4A"],
        ["\xF3\xB1\x8A\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4B"],
        ["\xF3\xB1\x8A\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4C"],
        ["\xF3\xB1\x8A\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4D"],
        ["\xF3\xB1\x8A\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4E"],
        ["\xF3\xB1\x8A\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4F"],
        ["\xF3\xB1\x8A\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x50"],
        ["\xF3\xB1\x8A\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x51"],
        ["\xF3\xB1\x8A\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x52"],
        ["\xF3\xB1\x8A\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x53"],
        ["\xF3\xB1\x8A\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x54"],
        ["\xF3\xB1\x8A\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x55"],
        ["\xF3\xB1\x8A\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x56"],
        ["\xF3\xB1\x8A\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x57"],
        ["\xF3\xB1\x8A\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x58"],
        ["\xF3\xB1\x8A\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x59"],
        ["\xF3\xB1\x8A\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5A"],
        ["\xF3\xB1\x8A\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5B"],
        ["\xF3\xB1\x8A\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5C"],
        ["\xF3\xB1\x8A\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5D"],
        ["\xF3\xB1\x8A\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5E"],
        ["\xF3\xB1\x8A\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5F"],
        ["\xF3\xB1\x8B\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x60"],
        ["\xF3\xB1\x8B\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x61"],
        ["\xF3\xB1\x8B\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x62"],
        ["\xF3\xB1\x8B\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x63"],
        ["\xF3\xB1\x8B\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x64"],
        ["\xF3\xB1\x8B\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x65"],
        ["\xF3\xB1\x8B\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x66"],
        ["\xF3\xB1\x8B\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x67"],
        ["\xF3\xB1\x8B\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x68"],
        ["\xF3\xB1\x8B\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x69"],
        ["\xF3\xB1\x8B\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6A"],
        ["\xF3\xB1\x8B\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6B"],
        ["\xF3\xB1\x8B\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6C"],
        ["\xF3\xB1\x8B\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6D"],
        ["\xF3\xB1\x8B\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6E"],
        ["\xF3\xB1\x8B\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6F"],
        ["\xF3\xB1\x8B\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x70"],
        ["\xF3\xB1\x8B\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x71"],
        ["\xF3\xB1\x8B\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x72"],
        ["\xF3\xB1\x8B\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x73"],
        ["\xF3\xB1\x8B\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x74"],
        ["\xF3\xB1\x8B\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x75"],
        ["\xF3\xB1\x8B\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x76"],
        ["\xF3\xB1\x8B\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x77"],
        ["\xF3\xB1\x8B\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x78"],
        ["\xF3\xB1\x8B\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x79"],
        ["\xF3\xB1\x8B\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x7A"],
        ["\xF3\xB1\x8B\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x7B"],
        ["\xF3\xB1\x8B\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x7C"],
        ["\xF3\xB1\x8B\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x7D"],
        ["\xF3\xB1\x8B\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x7E"],
        ["\xF3\xB1\x8B\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x80"],
        ["\xF3\xB1\x8B\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x81"],
        ["\xF3\xB1\x8B\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x82"],
        ["\xF3\xB1\x8B\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x83"],
        ["\xF3\xB1\x8B\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x84"],
        ["\xF3\xB1\x8B\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x85"],
        ["\xF3\xB1\x8B\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x86"],
        ["\xF3\xB1\x8B\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x87"],
        ["\xF3\xB1\x8B\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x88"],
        ["\xF3\xB1\x8B\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x89"],
        ["\xF3\xB1\x8B\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8A"],
        ["\xF3\xB1\x8B\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8B"],
        ["\xF3\xB1\x8B\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8C"],
        ["\xF3\xB1\x8B\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8D"],
        ["\xF3\xB1\x8B\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8E"],
        ["\xF3\xB1\x8B\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8F"],
        ["\xF3\xB1\x8B\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x90"],
        ["\xF3\xB1\x8B\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x91"],
        ["\xF3\xB1\x8B\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x92"],
        ["\xF3\xB1\x8B\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x93"],
        ["\xF3\xB1\x8B\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x94"],
        ["\xF3\xB1\x8B\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x95"],
        ["\xF3\xB1\x8B\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x96"],
        ["\xF3\xB1\x8B\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x97"],
        ["\xF3\xB1\x8B\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x98"],
        ["\xF3\xB1\x8B\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x99"],
        ["\xF3\xB1\x8B\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9A"],
        ["\xF3\xB1\x8B\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9B"],
        ["\xF3\xB1\x8B\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9C"],
        ["\xF3\xB1\x8B\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9D"],
        ["\xF3\xB1\x8B\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9E"],
        ["\xF3\xB1\x8B\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9F"],
        ["\xF3\xB1\x8B\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA0"],
        ["\xF3\xB1\x8C\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA1"],
        ["\xF3\xB1\x8C\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA2"],
        ["\xF3\xB1\x8C\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA3"],
        ["\xF3\xB1\x8C\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA4"],
        ["\xF3\xB1\x8C\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA5"],
        ["\xF3\xB1\x8C\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA6"],
        ["\xF3\xB1\x8C\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA7"],
        ["\xF3\xB1\x8C\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA8"],
        ["\xF3\xB1\x8C\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA9"],
        ["\xF3\xB1\x8C\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAA"],
        ["\xF3\xB1\x8C\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAB"],
        ["\xF3\xB1\x8C\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAC"],
        ["\xF3\xB1\x8C\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAD"],
        ["\xF3\xB1\x8C\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAE"],
        ["\xF3\xB1\x8C\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAF"],
        ["\xF3\xB1\x8C\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB0"],
        ["\xF3\xB1\x8C\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB1"],
        ["\xF3\xB1\x8C\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB2"],
        ["\xF3\xB1\x8C\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB3"],
        ["\xF3\xB1\x8C\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB4"],
        ["\xF3\xB1\x8C\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB5"],
        ["\xF3\xB1\x8C\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB6"],
        ["\xF3\xB1\x8C\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB7"],
        ["\xF3\xB1\x8C\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB8"],
        ["\xF3\xB1\x8C\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB9"],
        ["\xF3\xB1\x8C\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBA"],
        ["\xF3\xB1\x8C\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBB"],
        ["\xF3\xB1\x8C\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBC"],
        ["\xF3\xB1\x8C\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBD"],
        ["\xF3\xB1\x8C\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBE"],
        ["\xF3\xB1\x8C\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBF"],
        ["\xF3\xB1\x8C\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC0"],
        ["\xF3\xB1\x8C\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC1"],
        ["\xF3\xB1\x8C\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC2"],
        ["\xF3\xB1\x8C\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC3"],
        ["\xF3\xB1\x8C\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC4"],
        ["\xF3\xB1\x8C\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC5"],
        ["\xF3\xB1\x8C\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC6"],
        ["\xF3\xB1\x8C\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC7"],
        ["\xF3\xB1\x8C\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC8"],
        ["\xF3\xB1\x8C\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC9"],
        ["\xF3\xB1\x8C\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCA"],
        ["\xF3\xB1\x8C\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCB"],
        ["\xF3\xB1\x8C\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCC"],
        ["\xF3\xB1\x8C\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCD"],
        ["\xF3\xB1\x8C\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCE"],
        ["\xF3\xB1\x8C\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCF"],
        ["\xF3\xB1\x8C\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD0"],
        ["\xF3\xB1\x8C\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD1"],
        ["\xF3\xB1\x8C\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD2"],
        ["\xF3\xB1\x8C\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD3"],
        ["\xF3\xB1\x8C\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD4"],
        ["\xF3\xB1\x8C\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD5"],
        ["\xF3\xB1\x8C\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD6"],
        ["\xF3\xB1\x8C\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD7"],
        ["\xF3\xB1\x8C\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD8"],
        ["\xF3\xB1\x8C\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD9"],
        ["\xF3\xB1\x8C\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDA"],
        ["\xF3\xB1\x8C\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDB"],
        ["\xF3\xB1\x8C\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDC"],
        ["\xF3\xB1\x8C\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDD"],
        ["\xF3\xB1\x8C\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDE"],
        ["\xF3\xB1\x8C\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDF"],
        ["\xF3\xB1\x8C\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE0"],
        ["\xF3\xB1\x8D\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE1"],
        ["\xF3\xB1\x8D\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE2"],
        ["\xF3\xB1\x8D\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE3"],
        ["\xF3\xB1\x8D\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE4"],
        ["\xF3\xB1\x8D\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE5"],
        ["\xF3\xB1\x8D\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE6"],
        ["\xF3\xB1\x8D\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE7"],
        ["\xF3\xB1\x8D\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE8"],
        ["\xF3\xB1\x8D\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE9"],
        ["\xF3\xB1\x8D\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEA"],
        ["\xF3\xB1\x8D\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEB"],
        ["\xF3\xB1\x8D\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEC"],
        ["\xF3\xB1\x8D\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xED"],
        ["\xF3\xB1\x8D\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEE"],
        ["\xF3\xB1\x8D\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEF"],
        ["\xF3\xB1\x8D\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF0"],
        ["\xF3\xB1\x8D\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF1"],
        ["\xF3\xB1\x8D\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF2"],
        ["\xF3\xB1\x8D\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF3"],
        ["\xF3\xB1\x8D\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF4"],
        ["\xF3\xB1\x8D\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF5"],
        ["\xF3\xB1\x8D\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF6"],
        ["\xF3\xB1\x8D\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF7"],
        ["\xF3\xB1\x8D\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF8"],
        ["\xF3\xB1\x8D\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF9"],
        ["\xF3\xB1\x8D\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xFA"],
        ["\xF3\xB1\x8D\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xFB"],
        ["\xF3\xB1\x8D\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xFC"],
        ["\xF3\xB1\x8D\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x40"],
        ["\xF3\xB1\x8D\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x41"],
        ["\xF3\xB1\x8D\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x42"],
        ["\xF3\xB1\x8D\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x43"],
        ["\xF3\xB1\x8D\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x44"],
        ["\xF3\xB1\x8D\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x45"],
        ["\xF3\xB1\x8D\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x46"],
        ["\xF3\xB1\x8D\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x47"],
        ["\xF3\xB1\x8D\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x48"],
        ["\xF3\xB1\x8D\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x49"],
        ["\xF3\xB1\x8D\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4A"],
        ["\xF3\xB1\x8D\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4B"],
        ["\xF3\xB1\x8D\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4C"],
        ["\xF3\xB1\x8D\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4D"],
        ["\xF3\xB1\x8D\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4E"],
        ["\xF3\xB1\x8D\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4F"],
        ["\xF3\xB1\x8D\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x50"],
        ["\xF3\xB1\x8D\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x51"],
        ["\xF3\xB1\x8D\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x52"],
        ["\xF3\xB1\x8D\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x53"],
        ["\xF3\xB1\x8D\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x54"],
        ["\xF3\xB1\x8D\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x55"],
        ["\xF3\xB1\x8D\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x56"],
        ["\xF3\xB1\x8D\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x57"],
        ["\xF3\xB1\x8D\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x58"],
        ["\xF3\xB1\x8D\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x59"],
        ["\xF3\xB1\x8D\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5A"],
        ["\xF3\xB1\x8D\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5B"],
        ["\xF3\xB1\x8D\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5C"],
        ["\xF3\xB1\x8D\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5D"],
        ["\xF3\xB1\x8D\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5E"],
        ["\xF3\xB1\x8D\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5F"],
        ["\xF3\xB1\x8D\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x60"],
        ["\xF3\xB1\x8D\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x61"],
        ["\xF3\xB1\x8D\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x62"],
        ["\xF3\xB1\x8D\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x63"],
        ["\xF3\xB1\x8E\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x64"],
        ["\xF3\xB1\x8E\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x65"],
        ["\xF3\xB1\x8E\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x66"],
        ["\xF3\xB1\x8E\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x67"],
        ["\xF3\xB1\x8E\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x68"],
        ["\xF3\xB1\x8E\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x69"],
        ["\xF3\xB1\x8E\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6A"],
        ["\xF3\xB1\x8E\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6B"],
        ["\xF3\xB1\x8E\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6C"],
        ["\xF3\xB1\x8E\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6D"],
        ["\xF3\xB1\x8E\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6E"],
        ["\xF3\xB1\x8E\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6F"],
        ["\xF3\xB1\x8E\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x70"],
        ["\xF3\xB1\x8E\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x71"],
        ["\xF3\xB1\x8E\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x72"],
        ["\xF3\xB1\x8E\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x73"],
        ["\xF3\xB1\x8E\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x74"],
        ["\xF3\xB1\x8E\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x75"],
        ["\xF3\xB1\x8E\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x76"],
        ["\xF3\xB1\x8E\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x77"],
        ["\xF3\xB1\x8E\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x78"],
        ["\xF3\xB1\x8E\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x79"],
        ["\xF3\xB1\x8E\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x7A"],
        ["\xF3\xB1\x8E\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x7B"],
        ["\xF3\xB1\x8E\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x7C"],
        ["\xF3\xB1\x8E\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x7D"],
        ["\xF3\xB1\x8E\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x7E"],
        ["\xF3\xB1\x8E\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x80"],
        ["\xF3\xB1\x8E\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x81"],
        ["\xF3\xB1\x8E\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x82"],
        ["\xF3\xB1\x8E\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x83"],
        ["\xF3\xB1\x8E\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x84"],
        ["\xF3\xB1\x8E\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x85"],
        ["\xF3\xB1\x8E\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x86"],
        ["\xF3\xB1\x8E\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x87"],
        ["\xF3\xB1\x8E\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x88"],
        ["\xF3\xB1\x8E\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x89"],
        ["\xF3\xB1\x8E\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8A"],
        ["\xF3\xB1\x8E\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8B"],
        ["\xF3\xB1\x8E\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8C"],
        ["\xF3\xB1\x8E\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8D"],
        ["\xF3\xB1\x8E\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8E"],
        ["\xF3\xB1\x8E\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8F"],
        ["\xF3\xB1\x8E\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x90"],
        ["\xF3\xB1\x8E\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x91"],
        ["\xF3\xB1\x8E\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x92"],
        ["\xF3\xB1\x8E\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x93"],
        ["\xF3\xB1\x8E\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x94"],
        ["\xF3\xB1\x8E\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x95"],
        ["\xF3\xB1\x8E\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x96"],
        ["\xF3\xB1\x8E\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x97"],
        ["\xF3\xB1\x8E\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x98"],
        ["\xF3\xB1\x8E\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x99"],
        ["\xF3\xB1\x8E\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9A"],
        ["\xF3\xB1\x8E\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9B"],
        ["\xF3\xB1\x8E\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9C"],
        ["\xF3\xB1\x8E\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9D"],
        ["\xF3\xB1\x8E\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9E"],
        ["\xF3\xB1\x8E\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9F"],
        ["\xF3\xB1\x8E\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA0"],
        ["\xF3\xB1\x8E\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA1"],
        ["\xF3\xB1\x8E\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA2"],
        ["\xF3\xB1\x8E\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA3"],
        ["\xF3\xB1\x8E\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA4"],
        ["\xF3\xB1\x8F\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA5"],
        ["\xF3\xB1\x8F\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA6"],
        ["\xF3\xB1\x8F\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA7"],
        ["\xF3\xB1\x8F\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA8"],
        ["\xF3\xB1\x8F\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA9"],
        ["\xF3\xB1\x8F\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAA"],
        ["\xF3\xB1\x8F\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAB"],
        ["\xF3\xB1\x8F\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAC"],
        ["\xF3\xB1\x8F\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAD"],
        ["\xF3\xB1\x8F\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAE"],
        ["\xF3\xB1\x8F\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAF"],
        ["\xF3\xB1\x8F\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB0"],
        ["\xF3\xB1\x8F\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB1"],
        ["\xF3\xB1\x8F\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB2"],
        ["\xF3\xB1\x8F\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB3"],
        ["\xF3\xB1\x8F\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB4"],
        ["\xF3\xB1\x8F\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB5"],
        ["\xF3\xB1\x8F\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB6"],
        ["\xF3\xB1\x8F\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB7"],
        ["\xF3\xB1\x8F\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB8"],
        ["\xF3\xB1\x8F\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB9"],
        ["\xF3\xB1\x8F\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBA"],
        ["\xF3\xB1\x8F\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBB"],
        ["\xF3\xB1\x8F\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBC"],
        ["\xF3\xB1\x8F\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBD"],
        ["\xF3\xB1\x8F\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBE"],
        ["\xF3\xB1\x8F\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBF"],
        ["\xF3\xB1\x8F\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC0"],
        ["\xF3\xB1\x8F\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC1"],
        ["\xF3\xB1\x8F\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC2"],
        ["\xF3\xB1\x8F\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC3"],
        ["\xF3\xB1\x8F\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC4"],
        ["\xF3\xB1\x8F\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC5"],
        ["\xF3\xB1\x8F\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC6"],
        ["\xF3\xB1\x8F\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC7"],
        ["\xF3\xB1\x8F\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC8"],
        ["\xF3\xB1\x8F\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC9"],
        ["\xF3\xB1\x8F\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCA"],
        ["\xF3\xB1\x8F\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCB"],
        ["\xF3\xB1\x8F\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCC"],
        ["\xF3\xB1\x8F\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCD"],
        ["\xF3\xB1\x8F\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCE"],
        ["\xF3\xB1\x8F\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCF"],
        ["\xF3\xB1\x8F\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD0"],
        ["\xF3\xB1\x8F\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD1"],
        ["\xF3\xB1\x8F\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD2"],
        ["\xF3\xB1\x8F\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD3"],
        ["\xF3\xB1\x8F\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD4"],
        ["\xF3\xB1\x8F\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD5"],
        ["\xF3\xB1\x8F\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD6"],
        ["\xF3\xB1\x8F\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD7"],
        ["\xF3\xB1\x8F\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD8"],
        ["\xF3\xB1\x8F\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD9"],
        ["\xF3\xB1\x8F\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDA"],
        ["\xF3\xB1\x8F\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDB"],
        ["\xF3\xB1\x8F\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDC"],
        ["\xF3\xB1\x8F\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDD"],
        ["\xF3\xB1\x8F\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDE"],
        ["\xF3\xB1\x8F\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDF"],
        ["\xF3\xB1\x8F\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE0"],
        ["\xF3\xB1\x8F\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE1"],
        ["\xF3\xB1\x8F\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE2"],
        ["\xF3\xB1\x8F\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE3"],
        ["\xF3\xB1\x8F\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE4"],
        ["\xF3\xB1\x90\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE5"],
        ["\xF3\xB1\x90\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE6"],
        ["\xF3\xB1\x90\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE7"],
        ["\xF3\xB1\x90\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE8"],
        ["\xF3\xB1\x90\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE9"],
        ["\xF3\xB1\x90\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEA"],
        ["\xF3\xB1\x90\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEB"],
        ["\xF3\xB1\x90\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEC"],
        ["\xF3\xB1\x90\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xED"],
        ["\xF3\xB1\x90\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEE"],
        ["\xF3\xB1\x90\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEF"],
        ["\xF3\xB1\x90\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF0"],
        ["\xF3\xB1\x90\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF1"],
        ["\xF3\xB1\x90\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF2"],
        ["\xF3\xB1\x90\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF3"],
        ["\xF3\xB1\x90\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF4"],
        ["\xF3\xB1\x90\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF5"],
        ["\xF3\xB1\x90\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF6"],
        ["\xF3\xB1\x90\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF7"],
        ["\xF3\xB1\x90\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF8"],
        ["\xF3\xB1\x90\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF9"],
        ["\xF3\xB1\x90\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xFA"],
        ["\xF3\xB1\x90\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xFB"],
        ["\xF3\xB1\x90\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xFC"],
        ["\xF3\xB1\x90\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x40"],
        ["\xF3\xB1\x90\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x41"],
        ["\xF3\xB1\x90\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x42"],
        ["\xF3\xB1\x90\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x43"],
        ["\xF3\xB1\x90\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x44"],
        ["\xF3\xB1\x90\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x45"],
        ["\xF3\xB1\x90\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x46"],
        ["\xF3\xB1\x90\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x47"],
        ["\xF3\xB1\x90\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x48"],
        ["\xF3\xB1\x90\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x49"],
        ["\xF3\xB1\x90\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4A"],
        ["\xF3\xB1\x90\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4B"],
        ["\xF3\xB1\x90\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4C"],
        ["\xF3\xB1\x90\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4D"],
        ["\xF3\xB1\x90\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4E"],
        ["\xF3\xB1\x90\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4F"],
        ["\xF3\xB1\x90\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x50"],
        ["\xF3\xB1\x90\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x51"],
        ["\xF3\xB1\x90\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x52"],
        ["\xF3\xB1\x90\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x53"],
        ["\xF3\xB1\x90\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x54"],
        ["\xF3\xB1\x90\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x55"],
        ["\xF3\xB1\x90\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x56"],
        ["\xF3\xB1\x90\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x57"],
        ["\xF3\xB1\x90\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x58"],
        ["\xF3\xB1\x90\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x59"],
        ["\xF3\xB1\x90\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5A"],
        ["\xF3\xB1\x90\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5B"],
        ["\xF3\xB1\x90\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5C"],
        ["\xF3\xB1\x90\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5D"],
        ["\xF3\xB1\x90\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5E"],
        ["\xF3\xB1\x90\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5F"],
        ["\xF3\xB1\x90\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x60"],
        ["\xF3\xB1\x90\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x61"],
        ["\xF3\xB1\x90\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x62"],
        ["\xF3\xB1\x90\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x63"],
        ["\xF3\xB1\x90\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x64"],
        ["\xF3\xB1\x90\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x65"],
        ["\xF3\xB1\x90\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x66"],
        ["\xF3\xB1\x90\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x67"],
        ["\xF3\xB1\x91\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x68"],
        ["\xF3\xB1\x91\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x69"],
        ["\xF3\xB1\x91\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6A"],
        ["\xF3\xB1\x91\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6B"],
        ["\xF3\xB1\x91\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6C"],
        ["\xF3\xB1\x91\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6D"],
        ["\xF3\xB1\x91\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6E"],
        ["\xF3\xB1\x91\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6F"],
        ["\xF3\xB1\x91\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x70"],
        ["\xF3\xB1\x91\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x71"],
        ["\xF3\xB1\x91\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x72"],
        ["\xF3\xB1\x91\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x73"],
        ["\xF3\xB1\x91\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x74"],
        ["\xF3\xB1\x91\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x75"],
        ["\xF3\xB1\x91\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x76"],
        ["\xF3\xB1\x91\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x77"],
        ["\xF3\xB1\x91\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x78"],
        ["\xF3\xB1\x91\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x79"],
        ["\xF3\xB1\x91\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x7A"],
        ["\xF3\xB1\x91\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x7B"],
        ["\xF3\xB1\x91\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x7C"],
        ["\xF3\xB1\x91\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x7D"],
        ["\xF3\xB1\x91\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x7E"],
        ["\xF3\xB1\x91\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x80"],
        ["\xF3\xB1\x91\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x81"],
        ["\xF3\xB1\x91\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x82"],
        ["\xF3\xB1\x91\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x83"],
        ["\xF3\xB1\x91\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x84"],
        ["\xF3\xB1\x91\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x85"],
        ["\xF3\xB1\x91\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x86"],
        ["\xF3\xB1\x91\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x87"],
        ["\xF3\xB1\x91\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x88"],
        ["\xF3\xB1\x91\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x89"],
        ["\xF3\xB1\x91\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8A"],
        ["\xF3\xB1\x91\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8B"],
        ["\xF3\xB1\x91\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8C"],
        ["\xF3\xB1\x91\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8D"],
        ["\xF3\xB1\x91\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8E"],
        ["\xF3\xB1\x91\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8F"],
        ["\xF3\xB1\x91\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x90"],
        ["\xF3\xB1\x91\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x91"],
        ["\xF3\xB1\x91\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x92"],
        ["\xF3\xB1\x91\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x93"],
        ["\xF3\xB1\x91\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x94"],
        ["\xF3\xB1\x91\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x95"],
        ["\xF3\xB1\x91\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x96"],
        ["\xF3\xB1\x91\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x97"],
        ["\xF3\xB1\x91\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x98"],
        ["\xF3\xB1\x91\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x99"],
        ["\xF3\xB1\x91\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9A"],
        ["\xF3\xB1\x91\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9B"],
        ["\xF3\xB1\x91\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9C"],
        ["\xF3\xB1\x91\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9D"],
        ["\xF3\xB1\x91\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9E"],
        ["\xF3\xB1\x91\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9F"],
        ["\xF3\xB1\x91\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA0"],
        ["\xF3\xB1\x91\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA1"],
        ["\xF3\xB1\x91\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA2"],
        ["\xF3\xB1\x91\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA3"],
        ["\xF3\xB1\x91\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA4"],
        ["\xF3\xB1\x91\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA5"],
        ["\xF3\xB1\x91\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA6"],
        ["\xF3\xB1\x91\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA7"],
        ["\xF3\xB1\x91\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA8"],
        ["\xF3\xB1\x92\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA9"],
        ["\xF3\xB1\x92\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAA"],
        ["\xF3\xB1\x92\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAB"],
        ["\xF3\xB1\x92\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAC"],
        ["\xF3\xB1\x92\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAD"],
        ["\xF3\xB1\x92\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAE"],
        ["\xF3\xB1\x92\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAF"],
        ["\xF3\xB1\x92\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB0"],
        ["\xF3\xB1\x92\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB1"],
        ["\xF3\xB1\x92\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB2"],
        ["\xF3\xB1\x92\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB3"],
        ["\xF3\xB1\x92\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB4"],
        ["\xF3\xB1\x92\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB5"],
        ["\xF3\xB1\x92\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB6"],
        ["\xF3\xB1\x92\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB7"],
        ["\xF3\xB1\x92\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB8"],
        ["\xF3\xB1\x92\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB9"],
        ["\xF3\xB1\x92\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBA"],
        ["\xF3\xB1\x92\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBB"],
        ["\xF3\xB1\x92\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBC"],
        ["\xF3\xB1\x92\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBD"],
        ["\xF3\xB1\x92\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBE"],
        ["\xF3\xB1\x92\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBF"],
        ["\xF3\xB1\x92\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC0"],
        ["\xF3\xB1\x92\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC1"],
        ["\xF3\xB1\x92\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC2"],
        ["\xF3\xB1\x92\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC3"],
        ["\xF3\xB1\x92\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC4"],
        ["\xF3\xB1\x92\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC5"],
        ["\xF3\xB1\x92\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC6"],
        ["\xF3\xB1\x92\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC7"],
        ["\xF3\xB1\x92\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC8"],
        ["\xF3\xB1\x92\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC9"],
        ["\xF3\xB1\x92\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCA"],
        ["\xF3\xB1\x92\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCB"],
        ["\xF3\xB1\x92\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCC"],
        ["\xF3\xB1\x92\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCD"],
        ["\xF3\xB1\x92\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCE"],
        ["\xF3\xB1\x92\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCF"],
        ["\xF3\xB1\x92\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD0"],
        ["\xF3\xB1\x92\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD1"],
        ["\xF3\xB1\x92\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD2"],
        ["\xF3\xB1\x92\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD3"],
        ["\xF3\xB1\x92\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD4"],
        ["\xF3\xB1\x92\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD5"],
        ["\xF3\xB1\x92\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD6"],
        ["\xF3\xB1\x92\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD7"],
        ["\xF3\xB1\x92\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD8"],
        ["\xF3\xB1\x92\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD9"],
        ["\xF3\xB1\x92\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDA"],
        ["\xF3\xB1\x92\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDB"],
        ["\xF3\xB1\x92\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDC"],
        ["\xF3\xB1\x92\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDD"],
        ["\xF3\xB1\x92\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDE"],
        ["\xF3\xB1\x92\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDF"],
        ["\xF3\xB1\x92\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE0"],
        ["\xF3\xB1\x92\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE1"],
        ["\xF3\xB1\x92\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE2"],
        ["\xF3\xB1\x92\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE3"],
        ["\xF3\xB1\x92\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE4"],
        ["\xF3\xB1\x92\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE5"],
        ["\xF3\xB1\x92\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE6"],
        ["\xF3\xB1\x92\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE7"],
        ["\xF3\xB1\x92\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE8"],
        ["\xF3\xB1\x93\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE9"],
        ["\xF3\xB1\x93\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xEA"],
        ["\xF3\xB1\x93\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xEB"],
        ["\xF3\xB1\x93\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xEC"],
        ["\xF3\xB1\x93\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xED"],
        ["\xF3\xB1\x93\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xEE"],
        ["\xF3\xB1\x93\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xEF"],
        ["\xF3\xB1\x93\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF0"],
        ["\xF3\xB1\x93\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF1"],
        ["\xF3\xB1\x93\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF2"],
        ["\xF3\xB1\x93\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF3"],
        ["\xF3\xB1\x93\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF4"],
        ["\xF3\xB1\x93\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF5"],
        ["\xF3\xB1\x93\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF6"],
        ["\xF3\xB1\x93\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF7"],
        ["\xF3\xB1\x93\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF8"],
        ["\xF3\xB1\x93\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF9"],
        ["\xF3\xB1\x93\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xFA"],
        ["\xF3\xB1\x93\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xFB"],
        ["\xF3\xB1\x93\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xFC"],
        ["\xF3\xB1\x93\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x40"],
        ["\xF3\xB1\x93\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x41"],
        ["\xF3\xB1\x93\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x42"],
        ["\xF3\xB1\x93\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x43"],
        ["\xF3\xB1\x93\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x44"],
        ["\xF3\xB1\x93\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x45"],
        ["\xF3\xB1\x93\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x46"],
        ["\xF3\xB1\x93\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x47"],
        ["\xF3\xB1\x93\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x48"],
        ["\xF3\xB1\x93\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x49"],
        ["\xF3\xB1\x93\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4A"],
        ["\xF3\xB1\x93\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4B"],
        ["\xF3\xB1\x93\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4C"],
        ["\xF3\xB1\x93\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4D"],
        ["\xF3\xB1\x93\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4E"],
        ["\xF3\xB1\x93\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4F"],
        ["\xF3\xB1\x93\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x50"],
        ["\xF3\xB1\x93\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x51"],
        ["\xF3\xB1\x93\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x52"],
        ["\xF3\xB1\x93\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x53"],
        ["\xF3\xB1\x93\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x54"],
        ["\xF3\xB1\x93\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x55"],
        ["\xF3\xB1\x93\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x56"],
        ["\xF3\xB1\x93\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x57"],
        ["\xF3\xB1\x93\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x58"],
        ["\xF3\xB1\x93\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x59"],
        ["\xF3\xB1\x93\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x5B"],
        ["\xF3\xB1\x93\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x5C"],
        ["\xF3\xB1\x93\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x5D"],
        ["\xF3\xB1\x93\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x5E"],
        ["\xF3\xB1\x93\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x5F"],
        ["\xF3\xB1\x93\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x60"],
        ["\xF3\xB1\x93\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x61"],
        ["\xF3\xB1\x93\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x62"],
        ["\xF3\xB1\x93\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x63"],
        ["\xF3\xB1\x93\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x64"],
        ["\xF3\xB1\x93\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x65"],
        ["\xF3\xB1\x93\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x66"],
        ["\xF3\xB1\x93\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x67"],
        ["\xF3\xB1\x93\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x68"],
        ["\xF3\xB1\x93\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x69"],
        ["\xF3\xB1\x93\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6A"],
        ["\xF3\xB1\x93\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6B"],
        ["\xF3\xB1\x94\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6C"],
        ["\xF3\xB1\x94\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6D"],
        ["\xF3\xB1\x94\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6E"],
        ["\xF3\xB1\x94\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6F"],
        ["\xF3\xB1\x94\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x70"],
        ["\xF3\xB1\x94\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x71"],
        ["\xF3\xB1\x94\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x72"],
        ["\xF3\xB1\x94\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x73"],
        ["\xF3\xB1\x94\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x74"],
        ["\xF3\xB1\x94\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x75"],
        ["\xF3\xB1\x94\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x76"],
        ["\xF3\xB1\x94\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x77"],
        ["\xF3\xB1\x94\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x78"],
        ["\xF3\xB1\x94\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x79"],
        ["\xF3\xB1\x94\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x7A"],
        ["\xF3\xB1\x94\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x7B"],
        ["\xF3\xB1\x94\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x7C"],
        ["\xF3\xB1\x94\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x7D"],
        ["\xF3\xB1\x94\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x7E"],
        ["\xF3\xB1\x94\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x80"],
        ["\xF3\xB1\x94\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x81"],
        ["\xF3\xB1\x94\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x82"],
        ["\xF3\xB1\x94\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x83"],
        ["\xF3\xB1\x94\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x84"],
        ["\xF3\xB1\x94\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x85"],
        ["\xF3\xB1\x94\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x86"],
        ["\xF3\xB1\x94\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x87"],
        ["\xF3\xB1\x94\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x88"],
        ["\xF3\xB1\x94\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x89"],
        ["\xF3\xB1\x94\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8A"],
        ["\xF3\xB1\x94\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8B"],
        ["\xF3\xB1\x94\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8C"],
        ["\xF3\xB1\x94\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8D"],
        ["\xF3\xB1\x94\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8E"],
        ["\xF3\xB1\x94\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8F"],
        ["\xF3\xB1\x94\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x90"],
        ["\xF3\xB1\x94\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x91"],
        ["\xF3\xB1\x94\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x92"],
        ["\xF3\xB1\x94\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x93"],
        ["\xF3\xB1\x94\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x94"],
        ["\xF3\xB1\x94\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x95"],
        ["\xF3\xB1\x94\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x96"],
        ["\xF3\xB1\x94\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x97"],
        ["\xF3\xB1\x94\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x98"],
        ["\xF3\xB1\x94\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x99"],
        ["\xF3\xB1\x94\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9A"],
        ["\xF3\xB1\x94\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9B"],
        ["\xF3\xB1\x94\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9C"],
        ["\xF3\xB1\x94\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9D"],
        ["\xF3\xB1\x94\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9E"],
        ["\xF3\xB1\x94\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9F"],
        ["\xF3\xB1\x94\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA0"],
        ["\xF3\xB1\x94\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA1"],
        ["\xF3\xB1\x94\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA2"],
        ["\xF3\xB1\x94\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA3"],
        ["\xF3\xB1\x94\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA4"],
        ["\xF3\xB1\x94\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA5"],
        ["\xF3\xB1\x94\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA6"],
        ["\xF3\xB1\x94\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA7"],
        ["\xF3\xB1\x94\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA8"],
        ["\xF3\xB1\x94\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA9"],
        ["\xF3\xB1\x94\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAA"],
        ["\xF3\xB1\x94\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAB"],
        ["\xF3\xB1\x94\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAC"],
        ["\xF3\xB1\x95\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAD"],
        ["\xF3\xB1\x95\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAE"],
        ["\xF3\xB1\x95\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAF"],
        ["\xF3\xB1\x95\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB0"],
        ["\xF3\xB1\x95\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB1"],
        ["\xF3\xB1\x95\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB2"],
        ["\xF3\xB1\x95\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB3"],
        ["\xF3\xB1\x95\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB4"],
        ["\xF3\xB1\x95\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB5"],
        ["\xF3\xB1\x95\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB6"],
        ["\xF3\xB1\x95\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB7"],
        ["\xF3\xB1\x95\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB8"],
        ["\xF3\xB1\x95\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB9"],
        ["\xF3\xB1\x95\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBA"],
        ["\xF3\xB1\x95\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBB"],
        ["\xF3\xB1\x95\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBC"],
        ["\xF3\xB1\x95\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBD"],
        ["\xF3\xB1\x95\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBE"],
        ["\xF3\xB1\x95\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBF"],
        ["\xF3\xB1\x95\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC0"],
        ["\xF3\xB1\x95\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC1"],
        ["\xF3\xB1\x95\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC2"],
        ["\xF3\xB1\x95\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC3"],
        ["\xF3\xB1\x95\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC4"],
        ["\xF3\xB1\x95\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC5"],
        ["\xF3\xB1\x95\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC6"],
        ["\xF3\xB1\x95\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC7"],
        ["\xF3\xB1\x95\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC8"],
        ["\xF3\xB1\x95\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC9"],
        ["\xF3\xB1\x95\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCA"],
        ["\xF3\xB1\x95\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCB"],
        ["\xF3\xB1\x95\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCC"],
        ["\xF3\xB1\x95\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCD"],
        ["\xF3\xB1\x95\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCE"],
        ["\xF3\xB1\x95\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCF"],
        ["\xF3\xB1\x95\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD0"],
        ["\xF3\xB1\x95\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD1"],
        ["\xF3\xB1\x95\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD2"],
        ["\xF3\xB1\x95\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD3"],
        ["\xF3\xB1\x95\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD4"],
        ["\xF3\xB1\x95\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD5"],
        ["\xF3\xB1\x95\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD6"],
        ["\xF3\xB1\x95\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD7"],
        ["\xF3\xB1\x95\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD8"],
        ["\xF3\xB1\x95\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD9"],
        ["\xF3\xB1\x95\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDA"],
        ["\xF3\xB1\x95\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDB"],
        ["\xF3\xB1\x95\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDC"],
        ["\xF3\xB1\x95\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDD"],
        ["\xF3\xB1\x95\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDE"],
        ["\xF3\xB1\x95\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDF"],
        ["\xF3\xB1\x95\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE0"],
        ["\xF3\xB1\x95\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE1"],
        ["\xF3\xB1\x95\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE2"],
        ["\xF3\xB1\x95\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE3"],
        ["\xF3\xB1\x95\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE4"],
        ["\xF3\xB1\x95\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE5"],
        ["\xF3\xB1\x95\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE6"],
        ["\xF3\xB1\x95\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE7"],
        ["\xF3\xB1\x95\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE8"],
        ["\xF3\xB1\x95\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE9"],
        ["\xF3\xB1\x95\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xEA"],
        ["\xF3\xB1\x95\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xEB"],
        ["\xF3\xB1\x95\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xEC"],
        ["\xF3\xB1\x96\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xED"],
        ["\xF3\xB1\x96\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xEE"],
        ["\xF3\xB1\x96\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xEF"],
        ["\xF3\xB1\x96\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF0"],
        ["\xF3\xB1\x96\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF1"],
        ["\xF3\xB1\x96\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF2"],
        ["\xF3\xB1\x96\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF3"],
        ["\xF3\xB1\x96\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF4"],
        ["\xF3\xB1\x96\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF5"],
        ["\xF3\xB1\x96\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF6"],
        ["\xF3\xB1\x96\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF7"],
        ["\xF3\xB1\x96\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF8"],
        ["\xF3\xB1\x96\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF9"],
        ["\xF3\xB1\x96\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xFA"],
        ["\xF3\xB1\x96\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xFB"],
        ["\xF3\xB1\x96\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xFC"],
        ["\xF3\xB1\x96\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x40"],
        ["\xF3\xB1\x96\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x41"],
        ["\xF3\xB1\x96\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x42"],
        ["\xF3\xB1\x96\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x43"],
        ["\xF3\xB1\x96\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x44"],
        ["\xF3\xB1\x96\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x45"],
        ["\xF3\xB1\x96\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x46"],
        ["\xF3\xB1\x96\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x47"],
        ["\xF3\xB1\x96\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x48"],
        ["\xF3\xB1\x96\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x49"],
        ["\xF3\xB1\x96\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4A"],
        ["\xF3\xB1\x96\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4B"],
        ["\xF3\xB1\x96\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4C"],
        ["\xF3\xB1\x96\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4D"],
        ["\xF3\xB1\x96\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4E"],
        ["\xF3\xB1\x96\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4F"],
        ["\xF3\xB1\x96\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x50"],
        ["\xF3\xB1\x96\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x51"],
        ["\xF3\xB1\x96\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x52"],
        ["\xF3\xB1\x96\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x53"],
        ["\xF3\xB1\x96\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x54"],
        ["\xF3\xB1\x96\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x55"],
        ["\xF3\xB1\x96\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x56"],
        ["\xF3\xB1\x96\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x57"],
        ["\xF3\xB1\x96\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x58"],
        ["\xF3\xB1\x96\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x59"],
        ["\xF3\xB1\x96\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5A"],
        ["\xF3\xB1\x96\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5B"],
        ["\xF3\xB1\x96\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5C"],
        ["\xF3\xB1\x96\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5D"],
        ["\xF3\xB1\x96\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5E"],
        ["\xF3\xB1\x96\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5F"],
        ["\xF3\xB1\x96\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x60"],
        ["\xF3\xB1\x96\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x61"],
        ["\xF3\xB1\x96\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x62"],
        ["\xF3\xB1\x96\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x63"],
        ["\xF3\xB1\x96\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x64"],
        ["\xF3\xB1\x96\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x65"],
        ["\xF3\xB1\x96\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x66"],
        ["\xF3\xB1\x96\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x67"],
        ["\xF3\xB1\x96\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x68"],
        ["\xF3\xB1\x96\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x69"],
        ["\xF3\xB1\x96\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6A"],
        ["\xF3\xB1\x96\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6B"],
        ["\xF3\xB1\x96\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6C"],
        ["\xF3\xB1\x96\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6D"],
        ["\xF3\xB1\x96\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6E"],
        ["\xF3\xB1\x96\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6F"],
        ["\xF3\xB1\x97\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x70"],
        ["\xF3\xB1\x97\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x71"],
        ["\xF3\xB1\x97\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x72"],
        ["\xF3\xB1\x97\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x73"],
        ["\xF3\xB1\x97\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x74"],
        ["\xF3\xB1\x97\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x75"],
        ["\xF3\xB1\x97\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x76"],
        ["\xF3\xB1\x97\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x77"],
        ["\xF3\xB1\x97\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x78"],
        ["\xF3\xB1\x97\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x79"],
        ["\xF3\xB1\x97\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x7A"],
        ["\xF3\xB1\x97\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x7B"],
        ["\xF3\xB1\x97\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x7C"],
        ["\xF3\xB1\x97\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x7D"],
        ["\xF3\xB1\x97\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x7E"],
        ["\xF3\xB1\x97\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x80"],
        ["\xF3\xB1\x97\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x81"],
        ["\xF3\xB1\x97\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x82"],
        ["\xF3\xB1\x97\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x83"],
        ["\xF3\xB1\x97\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x84"],
        ["\xF3\xB1\x97\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x85"],
        ["\xF3\xB1\x97\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x86"],
        ["\xF3\xB1\x97\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x87"],
        ["\xF3\xB1\x97\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x88"],
        ["\xF3\xB1\x97\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x89"],
        ["\xF3\xB1\x97\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8A"],
        ["\xF3\xB1\x97\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8B"],
        ["\xF3\xB1\x97\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8C"],
        ["\xF3\xB1\x97\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8D"],
        ["\xF3\xB1\x97\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8E"],
        ["\xF3\xB1\x97\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8F"],
        ["\xF3\xB1\x97\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x90"],
        ["\xF3\xB1\x97\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x91"],
        ["\xF3\xB1\x97\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x92"],
        ["\xF3\xB1\x97\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x93"],
        ["\xF3\xB1\x97\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x94"],
        ["\xF3\xB1\x97\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x95"],
        ["\xF3\xB1\x97\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x96"],
        ["\xF3\xB1\x97\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x97"],
        ["\xF3\xB1\x97\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x98"],
        ["\xF3\xB1\x97\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x99"],
        ["\xF3\xB1\x97\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9A"],
        ["\xF3\xB1\x97\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9B"],
        ["\xF3\xB1\x97\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9C"],
        ["\xF3\xB1\x97\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9D"],
        ["\xF3\xB1\x97\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9E"],
        ["\xF3\xB1\x97\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9F"],
        ["\xF3\xB1\x97\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA0"],
        ["\xF3\xB1\x97\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA1"],
        ["\xF3\xB1\x97\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA2"],
        ["\xF3\xB1\x97\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA3"],
        ["\xF3\xB1\x97\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA4"],
        ["\xF3\xB1\x97\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA5"],
        ["\xF3\xB1\x97\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA6"],
        ["\xF3\xB1\x97\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA7"],
        ["\xF3\xB1\x97\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA8"],
        ["\xF3\xB1\x97\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA9"],
        ["\xF3\xB1\x97\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAA"],
        ["\xF3\xB1\x97\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAB"],
        ["\xF3\xB1\x97\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAC"],
        ["\xF3\xB1\x97\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAD"],
        ["\xF3\xB1\x97\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAE"],
        ["\xF3\xB1\x97\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAF"],
        ["\xF3\xB1\x97\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB0"],
        ["\xF3\xB1\x98\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB1"],
        ["\xF3\xB1\x98\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB2"],
        ["\xF3\xB1\x98\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB3"],
        ["\xF3\xB1\x98\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB4"],
        ["\xF3\xB1\x98\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB5"],
        ["\xF3\xB1\x98\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB6"],
        ["\xF3\xB1\x98\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB7"],
        ["\xF3\xB1\x98\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB8"],
        ["\xF3\xB1\x98\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB9"],
        ["\xF3\xB1\x98\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBA"],
        ["\xF3\xB1\x98\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBB"],
        ["\xF3\xB1\x98\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBC"],
        ["\xF3\xB1\x98\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBD"],
        ["\xF3\xB1\x98\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBE"],
        ["\xF3\xB1\x98\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBF"],
        ["\xF3\xB1\x98\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC0"],
        ["\xF3\xB1\x98\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC1"],
        ["\xF3\xB1\x98\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC2"],
        ["\xF3\xB1\x98\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC3"],
        ["\xF3\xB1\x98\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC4"],
        ["\xF3\xB1\x98\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC5"],
        ["\xF3\xB1\x98\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC6"],
        ["\xF3\xB1\x98\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC7"],
        ["\xF3\xB1\x98\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC8"],
        ["\xF3\xB1\x98\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC9"],
        ["\xF3\xB1\x98\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCA"],
        ["\xF3\xB1\x98\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCB"],
        ["\xF3\xB1\x98\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCC"],
        ["\xF3\xB1\x98\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCD"],
        ["\xF3\xB1\x98\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCE"],
        ["\xF3\xB1\x98\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCF"],
        ["\xF3\xB1\x98\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD0"],
        ["\xF3\xB1\x98\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD1"],
        ["\xF3\xB1\x98\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD2"],
        ["\xF3\xB1\x98\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD3"],
        ["\xF3\xB1\x98\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD4"],
        ["\xF3\xB1\x98\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD5"],
        ["\xF3\xB1\x98\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD6"],
        ["\xF3\xB1\x98\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD7"],
        ["\xF3\xB1\x98\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD8"],
        ["\xF3\xB1\x98\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD9"],
        ["\xF3\xB1\x98\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDA"],
        ["\xF3\xB1\x98\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDB"],
        ["\xF3\xB1\x98\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDC"],
        ["\xF3\xB1\x98\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDD"],
        ["\xF3\xB1\x98\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDE"],
        ["\xF3\xB1\x98\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDF"],
        ["\xF3\xB1\x98\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE0"],
        ["\xF3\xB1\x98\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE1"],
        ["\xF3\xB1\x98\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE2"],
        ["\xF3\xB1\x98\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE3"],
        ["\xF3\xB1\x98\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE4"],
        ["\xF3\xB1\x98\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE5"],
        ["\xF3\xB1\x98\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE6"],
        ["\xF3\xB1\x98\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE7"],
        ["\xF3\xB1\x98\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE8"],
        ["\xF3\xB1\x98\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE9"],
        ["\xF3\xB1\x98\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xEA"],
        ["\xF3\xB1\x98\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xEB"],
        ["\xF3\xB1\x98\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xEC"],
        ["\xF3\xB1\x98\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xED"],
        ["\xF3\xB1\x98\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xEE"],
        ["\xF3\xB1\x98\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xEF"],
        ["\xF3\xB1\x98\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF0"],
        ["\xF3\xB1\x99\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF1"],
        ["\xF3\xB1\x99\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF2"],
        ["\xF3\xB1\x99\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF3"],
        ["\xF3\xB1\x99\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF4"],
        ["\xF3\xB1\x99\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF5"],
        ["\xF3\xB1\x99\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF6"],
        ["\xF3\xB1\x99\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF7"],
        ["\xF3\xB1\x99\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF8"],
        ["\xF3\xB1\x99\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF9"],
        ["\xF3\xB1\x99\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xFA"],
        ["\xF3\xB1\x99\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xFB"],
        ["\xF3\xB1\x99\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xFC"],
        ["\xF3\xB1\x99\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x40"],
        ["\xF3\xB1\x99\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x41"],
        ["\xF3\xB1\x99\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x42"],
        ["\xF3\xB1\x99\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x43"],
        ["\xF3\xB1\x99\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x44"],
        ["\xF3\xB1\x99\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x45"],
        ["\xF3\xB1\x99\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x46"],
        ["\xF3\xB1\x99\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x47"],
        ["\xF3\xB1\x99\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x48"],
        ["\xF3\xB1\x99\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x49"],
        ["\xF3\xB1\x99\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4A"],
        ["\xF3\xB1\x99\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4B"],
        ["\xF3\xB1\x99\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4C"],
        ["\xF3\xB1\x99\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4D"],
        ["\xF3\xB1\x99\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4E"],
        ["\xF3\xB1\x99\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4F"],
        ["\xF3\xB1\x99\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x50"],
        ["\xF3\xB1\x99\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x51"],
        ["\xF3\xB1\x99\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x52"],
        ["\xF3\xB1\x99\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x53"],
        ["\xF3\xB1\x99\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x54"],
        ["\xF3\xB1\x99\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x55"],
        ["\xF3\xB1\x99\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x56"],
        ["\xF3\xB1\x99\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x57"],
        ["\xF3\xB1\x99\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x58"],
        ["\xF3\xB1\x99\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x59"],
        ["\xF3\xB1\x99\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5A"],
        ["\xF3\xB1\x99\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5B"],
        ["\xF3\xB1\x99\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5C"],
        ["\xF3\xB1\x99\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5D"],
        ["\xF3\xB1\x99\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5E"],
        ["\xF3\xB1\x99\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5F"],
        ["\xF3\xB1\x99\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x60"],
        ["\xF3\xB1\x99\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x61"],
        ["\xF3\xB1\x99\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x62"],
        ["\xF3\xB1\x99\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x63"],
        ["\xF3\xB1\x99\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x64"],
        ["\xF3\xB1\x99\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x65"],
        ["\xF3\xB1\x99\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x66"],
        ["\xF3\xB1\x99\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x67"],
        ["\xF3\xB1\x99\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x68"],
        ["\xF3\xB1\x99\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x69"],
        ["\xF3\xB1\x99\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6A"],
        ["\xF3\xB1\x99\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6B"],
        ["\xF3\xB1\x99\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6C"],
        ["\xF3\xB1\x99\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6D"],
        ["\xF3\xB1\x99\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6E"],
        ["\xF3\xB1\x99\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6F"],
        ["\xF3\xB1\x99\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x70"],
        ["\xF3\xB1\x99\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x71"],
        ["\xF3\xB1\x99\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x72"],
        ["\xF3\xB1\x99\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x73"],
        ["\xF3\xB1\x9A\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x74"],
        ["\xF3\xB1\x9A\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x75"],
        ["\xF3\xB1\x9A\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x76"],
        ["\xF3\xB1\x9A\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x77"],
        ["\xF3\xB1\x9A\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x78"],
        ["\xF3\xB1\x9A\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x79"],
        ["\xF3\xB1\x9A\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x7A"],
        ["\xF3\xB1\x9A\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x7B"],
        ["\xF3\xB1\x9A\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x7C"],
        ["\xF3\xB1\x9A\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x7D"],
        ["\xF3\xB1\x9A\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x7E"],
        ["\xF3\xB1\x9A\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x80"],
        ["\xF3\xB1\x9A\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x81"],
        ["\xF3\xB1\x9A\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x82"],
        ["\xF3\xB1\x9A\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x83"],
        ["\xF3\xB1\x9A\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x84"],
        ["\xF3\xB1\x9A\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x85"],
        ["\xF3\xB1\x9A\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x86"],
        ["\xF3\xB1\x9A\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x87"],
        ["\xF3\xB1\x9A\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x88"],
        ["\xF3\xB1\x9A\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x89"],
        ["\xF3\xB1\x9A\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8A"],
        ["\xF3\xB1\x9A\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8B"],
        ["\xF3\xB1\x9A\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8C"],
        ["\xF3\xB1\x9A\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8D"],
        ["\xF3\xB1\x9A\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8E"],
        ["\xF3\xB1\x9A\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8F"],
        ["\xF3\xB1\x9A\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x90"],
        ["\xF3\xB1\x9A\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x91"],
        ["\xF3\xB1\x9A\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x92"],
        ["\xF3\xB1\x9A\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x93"],
        ["\xF3\xB1\x9A\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x94"],
        ["\xF3\xB1\x9A\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x95"],
        ["\xF3\xB1\x9A\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x96"],
        ["\xF3\xB1\x9A\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x97"],
        ["\xF3\xB1\x9A\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x98"],
        ["\xF3\xB1\x9A\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x99"],
        ["\xF3\xB1\x9A\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9A"],
        ["\xF3\xB1\x9A\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9B"],
        ["\xF3\xB1\x9A\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9C"],
        ["\xF3\xB1\x9A\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9D"],
        ["\xF3\xB1\x9A\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9E"],
        ["\xF3\xB1\x9A\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9F"],
        ["\xF3\xB1\x9A\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA0"],
        ["\xF3\xB1\x9A\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA1"],
        ["\xF3\xB1\x9A\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA2"],
        ["\xF3\xB1\x9A\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA3"],
        ["\xF3\xB1\x9A\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA4"],
        ["\xF3\xB1\x9A\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA5"],
        ["\xF3\xB1\x9A\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA6"],
        ["\xF3\xB1\x9A\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA7"],
        ["\xF3\xB1\x9A\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA8"],
        ["\xF3\xB1\x9A\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA9"],
        ["\xF3\xB1\x9A\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAA"],
        ["\xF3\xB1\x9A\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAB"],
        ["\xF3\xB1\x9A\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAC"],
        ["\xF3\xB1\x9A\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAD"],
        ["\xF3\xB1\x9A\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAE"],
        ["\xF3\xB1\x9A\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAF"],
        ["\xF3\xB1\x9A\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB0"],
        ["\xF3\xB1\x9A\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB1"],
        ["\xF3\xB1\x9A\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB2"],
        ["\xF3\xB1\x9A\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB3"],
        ["\xF3\xB1\x9A\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB4"],
        ["\xF3\xB1\x9B\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB5"],
        ["\xF3\xB1\x9B\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB6"],
        ["\xF3\xB1\x9B\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB7"],
        ["\xF3\xB1\x9B\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB8"],
        ["\xF3\xB1\x9B\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB9"],
        ["\xF3\xB1\x9B\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBA"],
        ["\xF3\xB1\x9B\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBB"],
        ["\xF3\xB1\x9B\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBC"],
        ["\xF3\xB1\x9B\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBD"],
        ["\xF3\xB1\x9B\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBE"],
        ["\xF3\xB1\x9B\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBF"],
        ["\xF3\xB1\x9B\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC0"],
        ["\xF3\xB1\x9B\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC1"],
        ["\xF3\xB1\x9B\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC2"],
        ["\xF3\xB1\x9B\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC3"],
        ["\xF3\xB1\x9B\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC4"],
        ["\xF3\xB1\x9B\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC5"],
        ["\xF3\xB1\x9B\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC6"],
        ["\xF3\xB1\x9B\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC7"],
        ["\xF3\xB1\x9B\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC8"],
        ["\xF3\xB1\x9B\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC9"],
        ["\xF3\xB1\x9B\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCA"],
        ["\xF3\xB1\x9B\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCB"],
        ["\xF3\xB1\x9B\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCC"],
        ["\xF3\xB1\x9B\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCD"],
        ["\xF3\xB1\x9B\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCE"],
        ["\xF3\xB1\x9B\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCF"],
        ["\xF3\xB1\x9B\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD0"],
        ["\xF3\xB1\x9B\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD1"],
        ["\xF3\xB1\x9B\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD2"],
        ["\xF3\xB1\x9B\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD3"],
        ["\xF3\xB1\x9B\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD4"],
        ["\xF3\xB1\x9B\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD5"],
        ["\xF3\xB1\x9B\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD6"],
        ["\xF3\xB1\x9B\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD7"],
        ["\xF3\xB1\x9B\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD8"],
        ["\xF3\xB1\x9B\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD9"],
        ["\xF3\xB1\x9B\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDA"],
        ["\xF3\xB1\x9B\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDB"],
        ["\xF3\xB1\x9B\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDC"],
        ["\xF3\xB1\x9B\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDD"],
        ["\xF3\xB1\x9B\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDE"],
        ["\xF3\xB1\x9B\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDF"],
        ["\xF3\xB1\x9B\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE0"],
        ["\xF3\xB1\x9B\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE1"],
        ["\xF3\xB1\x9B\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE2"],
        ["\xF3\xB1\x9B\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE3"],
        ["\xF3\xB1\x9B\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE4"],
        ["\xF3\xB1\x9B\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE5"],
        ["\xF3\xB1\x9B\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE6"],
        ["\xF3\xB1\x9B\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE7"],
        ["\xF3\xB1\x9B\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE8"],
        ["\xF3\xB1\x9B\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE9"],
        ["\xF3\xB1\x9B\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEA"],
        ["\xF3\xB1\x9B\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEB"],
        ["\xF3\xB1\x9B\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEC"],
        ["\xF3\xB1\x9B\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xED"],
        ["\xF3\xB1\x9B\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEE"],
        ["\xF3\xB1\x9B\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEF"],
        ["\xF3\xB1\x9B\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF0"],
        ["\xF3\xB1\x9B\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF1"],
        ["\xF3\xB1\x9B\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF2"],
        ["\xF3\xB1\x9B\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF3"],
        ["\xF3\xB1\x9B\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF4"],
        ["\xF3\xB1\x9C\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF5"],
        ["\xF3\xB1\x9C\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF6"],
        ["\xF3\xB1\x9C\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF7"],
        ["\xF3\xB1\x9C\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF8"],
        ["\xF3\xB1\x9C\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF9"],
        ["\xF3\xB1\x9C\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xFA"],
        ["\xF3\xB1\x9C\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xFB"],
        ["\xF3\xB1\x9C\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xFC"],
        ["\xF3\xB1\x9C\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x40"],
        ["\xF3\xB1\x9C\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x41"],
        ["\xF3\xB1\x9C\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x42"],
        ["\xF3\xB1\x9C\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x43"],
        ["\xF3\xB1\x9C\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x44"],
        ["\xF3\xB1\x9C\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x45"],
        ["\xF3\xB1\x9C\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x46"],
        ["\xF3\xB1\x9C\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x47"],
        ["\xF3\xB1\x9C\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x48"],
        ["\xF3\xB1\x9C\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x49"],
        ["\xF3\xB1\x9C\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4A"],
        ["\xF3\xB1\x9C\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4B"],
        ["\xF3\xB1\x9C\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4C"],
        ["\xF3\xB1\x9C\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4D"],
        ["\xF3\xB1\x9C\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4E"],
        ["\xF3\xB1\x9C\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4F"],
        ["\xF3\xB1\x9C\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x50"],
        ["\xF3\xB1\x9C\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x51"],
        ["\xF3\xB1\x9C\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x52"],
        ["\xF3\xB1\x9C\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x53"],
        ["\xF3\xB1\x9C\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x54"],
        ["\xF3\xB1\x9C\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x55"],
        ["\xF3\xB1\x9C\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x56"],
        ["\xF3\xB1\x9C\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x57"],
        ["\xF3\xB1\x9C\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x58"],
        ["\xF3\xB1\x9C\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x59"],
        ["\xF3\xB1\x9C\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5A"],
        ["\xF3\xB1\x9C\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5B"],
        ["\xF3\xB1\x9C\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5C"],
        ["\xF3\xB1\x9C\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5D"],
        ["\xF3\xB1\x9C\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5E"],
        ["\xF3\xB1\x9C\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5F"],
        ["\xF3\xB1\x9C\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x60"],
        ["\xF3\xB1\x9C\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x61"],
        ["\xF3\xB1\x9C\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x62"],
        ["\xF3\xB1\x9C\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x63"],
        ["\xF3\xB1\x9C\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x64"],
        ["\xF3\xB1\x9C\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x65"],
        ["\xF3\xB1\x9C\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x66"],
        ["\xF3\xB1\x9C\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x67"],
        ["\xF3\xB1\x9C\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x68"],
        ["\xF3\xB1\x9C\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x69"],
        ["\xF3\xB1\x9C\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6A"],
        ["\xF3\xB1\x9C\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6B"],
        ["\xF3\xB1\x9C\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6C"],
        ["\xF3\xB1\x9C\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6D"],
        ["\xF3\xB1\x9C\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6E"],
        ["\xF3\xB1\x9C\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6F"],
        ["\xF3\xB1\x9C\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x70"],
        ["\xF3\xB1\x9C\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x71"],
        ["\xF3\xB1\x9C\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x72"],
        ["\xF3\xB1\x9C\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x73"],
        ["\xF3\xB1\x9C\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x74"],
        ["\xF3\xB1\x9C\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x75"],
        ["\xF3\xB1\x9C\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x76"],
        ["\xF3\xB1\x9C\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x77"],
        ["\xF3\xB1\x9D\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x78"],
        ["\xF3\xB1\x9D\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x79"],
        ["\xF3\xB1\x9D\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x7A"],
        ["\xF3\xB1\x9D\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x7B"],
        ["\xF3\xB1\x9D\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x7C"],
        ["\xF3\xB1\x9D\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x7D"],
        ["\xF3\xB1\x9D\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x7E"],
        ["\xF3\xB1\x9D\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x80"],
        ["\xF3\xB1\x9D\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x81"],
        ["\xF3\xB1\x9D\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x82"],
        ["\xF3\xB1\x9D\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x83"],
        ["\xF3\xB1\x9D\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x84"],
        ["\xF3\xB1\x9D\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x85"],
        ["\xF3\xB1\x9D\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x86"],
        ["\xF3\xB1\x9D\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x87"],
        ["\xF3\xB1\x9D\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x88"],
        ["\xF3\xB1\x9D\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x89"],
        ["\xF3\xB1\x9D\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8A"],
        ["\xF3\xB1\x9D\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8B"],
        ["\xF3\xB1\x9D\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8C"],
        ["\xF3\xB1\x9D\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8D"],
        ["\xF3\xB1\x9D\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8E"],
        ["\xF3\xB1\x9D\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8F"],
        ["\xF3\xB1\x9D\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x90"],
        ["\xF3\xB1\x9D\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x91"],
        ["\xF3\xB1\x9D\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x92"],
        ["\xF3\xB1\x9D\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x93"],
        ["\xF3\xB1\x9D\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x94"],
        ["\xF3\xB1\x9D\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x95"],
        ["\xF3\xB1\x9D\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x96"],
        ["\xF3\xB1\x9D\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x97"],
        ["\xF3\xB1\x9D\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x98"],
        ["\xF3\xB1\x9D\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x99"],
        ["\xF3\xB1\x9D\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9A"],
        ["\xF3\xB1\x9D\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9B"],
        ["\xF3\xB1\x9D\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9C"],
        ["\xF3\xB1\x9D\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9D"],
        ["\xF3\xB1\x9D\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9E"],
        ["\xF3\xB1\x9D\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9F"],
        ["\xF3\xB1\x9D\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA0"],
        ["\xF3\xB1\x9D\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA1"],
        ["\xF3\xB1\x9D\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA2"],
        ["\xF3\xB1\x9D\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA3"],
        ["\xF3\xB1\x9D\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA4"],
        ["\xF3\xB1\x9D\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA5"],
        ["\xF3\xB1\x9D\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA6"],
        ["\xF3\xB1\x9D\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA7"],
        ["\xF3\xB1\x9D\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA8"],
        ["\xF3\xB1\x9D\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA9"],
        ["\xF3\xB1\x9D\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAA"],
        ["\xF3\xB1\x9D\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAB"],
        ["\xF3\xB1\x9D\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAC"],
        ["\xF3\xB1\x9D\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAD"],
        ["\xF3\xB1\x9D\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAE"],
        ["\xF3\xB1\x9D\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAF"],
        ["\xF3\xB1\x9D\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB0"],
        ["\xF3\xB1\x9D\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB1"],
        ["\xF3\xB1\x9D\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB2"],
        ["\xF3\xB1\x9D\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB3"],
        ["\xF3\xB1\x9D\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB4"],
        ["\xF3\xB1\x9D\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB5"],
        ["\xF3\xB1\x9D\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB6"],
        ["\xF3\xB1\x9D\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB7"],
        ["\xF3\xB1\x9D\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB8"],
        ["\xF3\xB1\x9E\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB9"],
        ["\xF3\xB1\x9E\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBA"],
        ["\xF3\xB1\x9E\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBB"],
        ["\xF3\xB1\x9E\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBC"],
        ["\xF3\xB1\x9E\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBD"],
        ["\xF3\xB1\x9E\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBE"],
        ["\xF3\xB1\x9E\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBF"],
        ["\xF3\xB1\x9E\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC0"],
        ["\xF3\xB1\x9E\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC1"],
        ["\xF3\xB1\x9E\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC2"],
        ["\xF3\xB1\x9E\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC3"],
        ["\xF3\xB1\x9E\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC4"],
        ["\xF3\xB1\x9E\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC5"],
        ["\xF3\xB1\x9E\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC6"],
        ["\xF3\xB1\x9E\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC7"],
        ["\xF3\xB1\x9E\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC8"],
        ["\xF3\xB1\x9E\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC9"],
        ["\xF3\xB1\x9E\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCA"],
        ["\xF3\xB1\x9E\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCB"],
        ["\xF3\xB1\x9E\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCC"],
        ["\xF3\xB1\x9E\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCD"],
        ["\xF3\xB1\x9E\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCE"],
        ["\xF3\xB1\x9E\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"],
        ["\xF3\xB1\x9E\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD0"],
        ["\xF3\xB1\x9E\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD1"],
        ["\xF3\xB1\x9E\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD2"],
        ["\xF3\xB1\x9E\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD3"],
        ["\xF3\xB1\x9E\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD4"],
        ["\xF3\xB1\x9E\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD5"],
        ["\xF3\xB1\x9E\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD6"],
        ["\xF3\xB1\x9E\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD7"],
        ["\xF3\xB1\x9E\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD8"],
        ["\xF3\xB1\x9E\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD9"],
        ["\xF3\xB1\x9E\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDA"],
        ["\xF3\xB1\x9E\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDB"],
        ["\xF3\xB1\x9E\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDC"],
        ["\xF3\xB1\x9E\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDD"],
        ["\xF3\xB1\x9E\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDE"],
        ["\xF3\xB1\x9E\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDF"],
        ["\xF3\xB1\x9E\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE0"],
        ["\xF3\xB1\x9E\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE1"],
        ["\xF3\xB1\x9E\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE2"],
        ["\xF3\xB1\x9E\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE3"],
        ["\xF3\xB1\x9E\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE4"],
        ["\xF3\xB1\x9E\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE5"],
        ["\xF3\xB1\x9E\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE6"],
        ["\xF3\xB1\x9E\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE7"],
        ["\xF3\xB1\x9E\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE8"],
        ["\xF3\xB1\x9E\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE9"],
        ["\xF3\xB1\x9E\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xEA"],
        ["\xF3\xB1\x9E\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xEB"],
        ["\xF3\xB1\x9E\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xEC"],
        ["\xF3\xB1\x9E\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xED"],
        ["\xF3\xB1\x9E\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xEE"],
        ["\xF3\xB1\x9E\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xEF"],
        ["\xF3\xB1\x9E\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF0"],
        ["\xF3\xB1\x9E\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF1"],
        ["\xF3\xB1\x9E\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF2"],
        ["\xF3\xB1\x9E\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF3"],
        ["\xF3\xB1\x9E\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF4"],
        ["\xF3\xB1\x9E\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF5"],
        ["\xF3\xB1\x9E\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF6"],
        ["\xF3\xB1\x9E\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF7"],
        ["\xF3\xB1\x9E\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF8"],
        ["\xF3\xB1\x9F\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF9"],
        ["\xF3\xB1\x9F\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xFA"],
        ["\xF3\xB1\x9F\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xFB"],
        ["\xF3\xB1\x9F\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xFC"],
        ["\xF3\xB1\x9F\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x40"],
        ["\xF3\xB1\x9F\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x41"],
        ["\xF3\xB1\x9F\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x42"],
        ["\xF3\xB1\x9F\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x43"],
        ["\xF3\xB1\x9F\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x44"],
        ["\xF3\xB1\x9F\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x45"],
        ["\xF3\xB1\x9F\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x46"],
        ["\xF3\xB1\x9F\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x47"],
        ["\xF3\xB1\x9F\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x48"],
        ["\xF3\xB1\x9F\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x49"],
        ["\xF3\xB1\x9F\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4A"],
        ["\xF3\xB1\x9F\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4B"],
        ["\xF3\xB1\x9F\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4C"],
        ["\xF3\xB1\x9F\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4D"],
        ["\xF3\xB1\x9F\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4E"],
        ["\xF3\xB1\x9F\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4F"],
        ["\xF3\xB1\x9F\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x50"],
        ["\xF3\xB1\x9F\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x51"],
        ["\xF3\xB1\x9F\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x52"],
        ["\xF3\xB1\x9F\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x53"],
        ["\xF3\xB1\x9F\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x54"],
        ["\xF3\xB1\x9F\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x55"],
        ["\xF3\xB1\x9F\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x56"],
        ["\xF3\xB1\x9F\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x57"],
        ["\xF3\xB1\x9F\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x58"],
        ["\xF3\xB1\x9F\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],
        ["\xF3\xB1\x9F\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5A"],
        ["\xF3\xB1\x9F\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5B"],
        ["\xF3\xB1\x9F\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5C"],
        ["\xF3\xB1\x9F\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5D"],
        ["\xF3\xB1\x9F\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5E"],
        ["\xF3\xB1\x9F\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5F"],
        ["\xF3\xB1\x9F\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x60"],
        ["\xF3\xB1\x9F\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x61"],
        ["\xF3\xB1\x9F\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x62"],
        ["\xF3\xB1\x9F\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],
        ["\xF3\xB1\x9F\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x64"],
        ["\xF3\xB1\x9F\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x65"],
        ["\xF3\xB1\x9F\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x66"],
        ["\xF3\xB1\x9F\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x67"],
        ["\xF3\xB1\x9F\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\xF3\xB1\x9F\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\xF3\xB1\x9F\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6A"],
        ["\xF3\xB1\x9F\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6B"],
        ["\xF3\xB1\x9F\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6C"],
        ["\xF3\xB1\x9F\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6D"],
        ["\xF3\xB1\x9F\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],
        ["\xF3\xB1\x9F\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6F"],
        ["\xF3\xB1\x9F\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x70"],
        ["\xF3\xB1\x9F\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x71"],
        ["\xF3\xB1\x9F\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x72"],
        ["\xF3\xB1\x9F\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x73"],
        ["\xF3\xB1\x9F\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\xF3\xB1\x9F\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\xF3\xB1\x9F\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],
        ["\xF3\xB1\x9F\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x77"],
        ["\xF3\xB1\x9F\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\xF3\xB1\x9F\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\xF3\xB1\x9F\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7A"],
        ["\xF3\xB1\x9F\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7B"],
        ["\xF3\xB1\xA0\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7C"],
        ["\xF3\xB1\xA0\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7D"],
        ["\xF3\xB1\xA0\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7E"],
        ["\xF3\xB1\xA0\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x80"],
        ["\xF3\xB1\xA0\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x81"],
        ["\xF3\xB1\xA0\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x82"],
        ["\xF3\xB1\xA0\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x83"],
        ["\xF3\xB1\xA0\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x84"],
        ["\xF3\xB1\xA0\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x85"],
        ["\xF3\xB1\xA0\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x86"],
        ["\xF3\xB1\xA0\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x87"],
        ["\xF3\xB1\xA0\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x88"],
        ["\xF3\xB1\xA0\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x89"],
        ["\xF3\xB1\xA0\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8A"],
        ["\xF3\xB1\xA0\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8B"],
        ["\xF3\xB1\xA0\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8C"],
        ["\xF3\xB1\xA0\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8D"],
        ["\xF3\xB1\xA0\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8E"],
        ["\xF3\xB1\xA0\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8F"],
        ["\xF3\xB1\xA0\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x90"],
        ["\xF3\xB1\xA0\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x91"],
        ["\xF3\xB1\xA0\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x92"],
        ["\xF3\xB1\xA0\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x93"],
        ["\xF3\xB1\xA0\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x94"],
        ["\xF3\xB1\xA0\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x95"],
        ["\xF3\xB1\xA0\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x96"],
        ["\xF3\xB1\xA0\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x97"],
        ["\xF3\xB1\xA0\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x98"],
        ["\xF3\xB1\xA0\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x99"],
        ["\xF3\xB1\xA0\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9A"],
        ["\xF3\xB1\xA0\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9B"],
        ["\xF3\xB1\xA0\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9C"],
        ["\xF3\xB1\xA0\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9D"],
        ["\xF3\xB1\xA0\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9E"],
        ["\xF3\xB1\xA0\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9F"],
        ["\xF3\xB1\xA0\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA0"],
        ["\xF3\xB1\xA0\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xF3\xB1\xA0\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xF3\xB1\xA0\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xF3\xB1\xA0\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xF3\xB1\xA0\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xF3\xB1\xA0\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xF3\xB1\xA0\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xF3\xB1\xA0\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xF3\xB1\xA0\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xF3\xB1\xA0\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xF3\xB1\xA0\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xF3\xB1\xA0\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xF3\xB1\xA0\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xF3\xB1\xA0\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xF3\xB1\xA0\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xF3\xB1\xA0\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xF3\xB1\xA0\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xF3\xB1\xA0\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xF3\xB1\xA0\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xF3\xB1\xA0\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xF3\xB1\xA0\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xF3\xB1\xA0\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xF3\xB1\xA0\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xF3\xB1\xA0\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xF3\xB1\xA0\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xF3\xB1\xA0\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xF3\xB1\xA0\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xF3\xB1\xA0\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xF3\xB1\xA1\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xF3\xB1\xA1\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xF3\xB1\xA1\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xF3\xB1\xA1\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xF3\xB1\xA1\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xF3\xB1\xA1\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xF3\xB1\xA1\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xF3\xB1\xA1\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xF3\xB1\xA1\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xF3\xB1\xA1\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xF3\xB1\xA1\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xF3\xB1\xA1\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xF3\xB1\xA1\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xF3\xB1\xA1\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xF3\xB1\xA1\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xF3\xB1\xA1\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xF3\xB1\xA1\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xF3\xB1\xA1\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xF3\xB1\xA1\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xF3\xB1\xA1\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xF3\xB1\xA1\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xF3\xB1\xA1\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xF3\xB1\xA1\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xF3\xB1\xA1\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xF3\xB1\xA1\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xF3\xB1\xA1\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xF3\xB1\xA1\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xF3\xB1\xA1\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xF3\xB1\xA1\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xF3\xB1\xA1\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xF3\xB1\xA1\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xF3\xB1\xA1\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xF3\xB1\xA1\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xF3\xB1\xA1\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xF3\xB1\xA1\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xF3\xB1\xA1\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xF3\xB1\xA1\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xF3\xB1\xA1\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xF3\xB1\xA1\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xF3\xB1\xA1\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xF3\xB1\xA1\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xF3\xB1\xA1\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xF3\xB1\xA1\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xF3\xB1\xA1\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xF3\xB1\xA1\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xF3\xB1\xA1\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xF3\xB1\xA1\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xF3\xB1\xA1\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xF3\xB1\xA1\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xF3\xB1\xA1\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xF3\xB1\xA1\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xF3\xB1\xA1\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xF3\xB1\xA1\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xF3\xB1\xA1\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xF3\xB1\xA1\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xF3\xB1\xA1\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xF3\xB1\xA1\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xF3\xB1\xA1\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xF3\xB1\xA1\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xF3\xB1\xA1\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xF3\xB1\xA1\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xF3\xB1\xA1\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xF3\xB1\xA1\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xF3\xB1\xA1\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xF3\xB1\xA2\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x40"],
        ["\xF3\xB1\xA2\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x41"],
        ["\xF3\xB1\xA2\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x42"],
        ["\xF3\xB1\xA2\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x43"],
        ["\xF3\xB1\xA2\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x44"],
        ["\xF3\xB1\xA2\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x45"],
        ["\xF3\xB1\xA2\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x46"],
        ["\xF3\xB1\xA2\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x47"],
        ["\xF3\xB1\xA2\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x48"],
        ["\xF3\xB1\xA2\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x49"],
        ["\xF3\xB1\xA2\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4A"],
        ["\xF3\xB1\xA2\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4B"],
        ["\xF3\xB1\xA2\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4C"],
        ["\xF3\xB1\xA2\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4D"],
        ["\xF3\xB1\xA2\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4E"],
        ["\xF3\xB1\xA2\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4F"],
        ["\xF3\xB1\xA2\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x50"],
        ["\xF3\xB1\xA2\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x51"],
        ["\xF3\xB1\xA2\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x52"],
        ["\xF3\xB1\xA2\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x53"],
        ["\xF3\xB1\xA2\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x54"],
        ["\xF3\xB1\xA2\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x55"],
        ["\xF3\xB1\xA2\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x56"],
        ["\xF3\xB1\xA2\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x57"],
        ["\xF3\xB1\xA2\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x58"],
        ["\xF3\xB1\xA2\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x59"],
        ["\xF3\xB1\xA2\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5A"],
        ["\xF3\xB1\xA2\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5B"],
        ["\xF3\xB1\xA2\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5C"],
        ["\xF3\xB1\xA2\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5D"],
        ["\xF3\xB1\xA2\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5E"],
        ["\xF3\xB1\xA2\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5F"],
        ["\xF3\xB1\xA2\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x60"],
        ["\xF3\xB1\xA2\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x61"],
        ["\xF3\xB1\xA2\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x62"],
        ["\xF3\xB1\xA2\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x63"],
        ["\xF3\xB1\xA2\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x64"],
        ["\xF3\xB1\xA2\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x65"],
        ["\xF3\xB1\xA2\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x66"],
        ["\xF3\xB1\xA2\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x67"],
        ["\xF3\xB1\xA2\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x68"],
        ["\xF3\xB1\xA2\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x69"],
        ["\xF3\xB1\xA2\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6A"],
        ["\xF3\xB1\xA2\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6B"],
        ["\xF3\xB1\xA2\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6C"],
        ["\xF3\xB1\xA2\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6D"],
        ["\xF3\xB1\xA2\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6E"],
        ["\xF3\xB1\xA2\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6F"],
        ["\xF3\xB1\xA2\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x70"],
        ["\xF3\xB1\xA2\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x71"],
        ["\xF3\xB1\xA2\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x72"],
        ["\xF3\xB1\xA2\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x73"],
        ["\xF3\xB1\xA2\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x74"],
        ["\xF3\xB1\xA2\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x75"],
        ["\xF3\xB1\xA2\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x76"],
        ["\xF3\xB1\xA2\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x77"],
        ["\xF3\xB1\xA2\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x78"],
        ["\xF3\xB1\xA2\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x79"],
        ["\xF3\xB1\xA2\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x7A"],
        ["\xF3\xB1\xA2\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x7B"],
        ["\xF3\xB1\xA2\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x7C"],
        ["\xF3\xB1\xA2\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x7D"],
        ["\xF3\xB1\xA2\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x7E"],
        ["\xF3\xB1\xA2\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x80"],
        ["\xF3\xB1\xA3\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x81"],
        ["\xF3\xB1\xA3\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x82"],
        ["\xF3\xB1\xA3\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x83"],
        ["\xF3\xB1\xA3\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x84"],
        ["\xF3\xB1\xA3\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x85"],
        ["\xF3\xB1\xA3\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x86"],
        ["\xF3\xB1\xA3\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x87"],
        ["\xF3\xB1\xA3\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x88"],
        ["\xF3\xB1\xA3\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x89"],
        ["\xF3\xB1\xA3\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8A"],
        ["\xF3\xB1\xA3\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8B"],
        ["\xF3\xB1\xA3\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8C"],
        ["\xF3\xB1\xA3\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8D"],
        ["\xF3\xB1\xA3\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8E"],
        ["\xF3\xB1\xA3\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8F"],
        ["\xF3\xB1\xA3\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x90"],
        ["\xF3\xB1\xA3\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x91"],
        ["\xF3\xB1\xA3\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x92"],
        ["\xF3\xB1\xA3\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x93"],
        ["\xF3\xB1\xA3\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x94"],
        ["\xF3\xB1\xA3\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x95"],
        ["\xF3\xB1\xA3\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x96"],
        ["\xF3\xB1\xA3\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x97"],
        ["\xF3\xB1\xA3\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x98"],
        ["\xF3\xB1\xA3\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x99"],
        ["\xF3\xB1\xA3\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9A"],
        ["\xF3\xB1\xA3\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9B"],
        ["\xF3\xB1\xA3\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9C"],
        ["\xF3\xB1\xA3\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9D"],
        ["\xF3\xB1\xA3\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9E"],
        ["\xF3\xB1\xA3\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9F"],
        ["\xF3\xB1\xA3\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA0"],
        ["\xF3\xB1\xA3\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xF3\xB1\xA3\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xF3\xB1\xA3\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xF3\xB1\xA3\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xF3\xB1\xA3\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xF3\xB1\xA3\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xF3\xB1\xA3\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xF3\xB1\xA3\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xF3\xB1\xA3\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xF3\xB1\xA3\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xF3\xB1\xA3\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xF3\xB1\xA3\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xF3\xB1\xA3\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xF3\xB1\xA3\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xF3\xB1\xA3\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xF3\xB1\xA3\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xF3\xB1\xA3\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xF3\xB1\xA3\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xF3\xB1\xA3\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xF3\xB1\xA3\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xF3\xB1\xA3\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xF3\xB1\xA3\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xF3\xB1\xA3\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xF3\xB1\xA3\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xF3\xB1\xA3\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xF3\xB1\xA3\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xF3\xB1\xA3\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xF3\xB1\xA3\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xF3\xB1\xA3\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xF3\xB1\xA3\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xF3\xB1\xA3\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xF3\xB1\xA3\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xF3\xB1\xA4\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xF3\xB1\xA4\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xF3\xB1\xA4\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xF3\xB1\xA4\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xF3\xB1\xA4\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xF3\xB1\xA4\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xF3\xB1\xA4\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xF3\xB1\xA4\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xF3\xB1\xA4\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xF3\xB1\xA4\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xF3\xB1\xA4\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xF3\xB1\xA4\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xF3\xB1\xA4\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xF3\xB1\xA4\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xF3\xB1\xA4\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xF3\xB1\xA4\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xF3\xB1\xA4\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xF3\xB1\xA4\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xF3\xB1\xA4\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xF3\xB1\xA4\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xF3\xB1\xA4\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xF3\xB1\xA4\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xF3\xB1\xA4\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xF3\xB1\xA4\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xF3\xB1\xA4\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xF3\xB1\xA4\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xF3\xB1\xA4\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xF3\xB1\xA4\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xF3\xB1\xA4\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xF3\xB1\xA4\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xF3\xB1\xA4\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xF3\xB1\xA4\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xF3\xB1\xA4\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xF3\xB1\xA4\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xF3\xB1\xA4\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xF3\xB1\xA4\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xF3\xB1\xA4\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xF3\xB1\xA4\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xF3\xB1\xA4\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xF3\xB1\xA4\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xF3\xB1\xA4\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xF3\xB1\xA4\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xF3\xB1\xA4\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xF3\xB1\xA4\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xF3\xB1\xA4\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xF3\xB1\xA4\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xF3\xB1\xA4\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xF3\xB1\xA4\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xF3\xB1\xA4\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xF3\xB1\xA4\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xF3\xB1\xA4\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xF3\xB1\xA4\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xF3\xB1\xA4\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xF3\xB1\xA4\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xF3\xB1\xA4\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xF3\xB1\xA4\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xF3\xB1\xA4\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xF3\xB1\xA4\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xF3\xB1\xA4\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xF3\xB1\xA4\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xF3\xB1\xA4\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x40"],
        ["\xF3\xB1\xA4\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x41"],
        ["\xF3\xB1\xA4\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x42"],
        ["\xF3\xB1\xA4\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x43"],
        ["\xF3\xB1\xA5\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x44"],
        ["\xF3\xB1\xA5\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x45"],
        ["\xF3\xB1\xA5\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x46"],
        ["\xF3\xB1\xA5\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x47"],
        ["\xF3\xB1\xA5\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x48"],
        ["\xF3\xB1\xA5\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x49"],
        ["\xF3\xB1\xA5\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],
        ["\xF3\xB1\xA5\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],
        ["\xF3\xB1\xA5\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],
        ["\xF3\xB1\xA5\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4D"],
        ["\xF3\xB1\xA5\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4E"],
        ["\xF3\xB1\xA5\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4F"],
        ["\xF3\xB1\xA5\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x50"],
        ["\xF3\xB1\xA5\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x51"],
        ["\xF3\xB1\xA5\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x52"],
        ["\xF3\xB1\xA5\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x53"],
        ["\xF3\xB1\xA5\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x54"],
        ["\xF3\xB1\xA5\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x55"],
        ["\xF3\xB1\xA5\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x56"],
        ["\xF3\xB1\xA5\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x57"],
        ["\xF3\xB1\xA5\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x58"],
        ["\xF3\xB1\xA5\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x59"],
        ["\xF3\xB1\xA5\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5A"],
        ["\xF3\xB1\xA5\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],
        ["\xF3\xB1\xA5\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5C"],
        ["\xF3\xB1\xA5\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5D"],
        ["\xF3\xB1\xA5\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5E"],
        ["\xF3\xB1\xA5\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5F"],
        ["\xF3\xB1\xA5\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x60"],
        ["\xF3\xB1\xA5\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x61"],
        ["\xF3\xB1\xA5\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x62"],
        ["\xF3\xB1\xA5\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x63"],
        ["\xF3\xB1\xA5\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x64"],
        ["\xF3\xB1\xA5\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x65"],
        ["\xF3\xB1\xA5\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x66"],
        ["\xF3\xB1\xA5\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x67"],
        ["\xF3\xB1\xA5\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x68"],
        ["\xF3\xB1\xA5\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x69"],
        ["\xF3\xB1\xA5\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6A"],
        ["\xF3\xB1\xA5\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6B"],
        ["\xF3\xB1\xA5\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6C"],
        ["\xF3\xB1\xA5\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6D"],
        ["\xF3\xB1\xA5\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6E"],
        ["\xF3\xB1\xA5\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],
        ["\xF3\xB1\xA5\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xF3\xB1\xA5\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xF3\xB1\xA5\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xF3\xB1\xA5\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xF3\xB1\xA5\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xF3\xB1\xA5\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xF3\xB1\xA5\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xF3\xB1\xA5\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xF3\xB1\xA5\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xF3\xB1\xA5\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xF3\xB1\xA5\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xF3\xB1\xA5\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xF3\xB1\xA5\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xF3\xB1\xA5\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xF3\xB1\xA5\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xF3\xB1\xA5\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xF3\xB1\xA5\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\xF3\xB1\xA5\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\xF3\xB1\xA5\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\xF3\xB1\xA5\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x84"],
        ["\xF3\xB1\xA6\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85"],
        ["\xF3\xB1\xA6\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x86"],
        ["\xF3\xB1\xA6\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x87"],
        ["\xF3\xB1\xA6\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88"],
        ["\xF3\xB1\xA6\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89"],
        ["\xF3\xB1\xA6\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A"],
        ["\xF3\xB1\xA6\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B"],
        ["\xF3\xB1\xA6\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C"],
        ["\xF3\xB1\xA6\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8D"],
        ["\xF3\xB1\xA6\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E"],
        ["\xF3\xB1\xA6\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F"],
        ["\xF3\xB1\xA6\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x90"],
        ["\xF3\xB1\xA6\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91"],
        ["\xF3\xB1\xA6\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x92"],
        ["\xF3\xB1\xA6\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93"],
        ["\xF3\xB1\xA6\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94"],
        ["\xF3\xB1\xA6\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x95"],
        ["\xF3\xB1\xA6\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x96"],
        ["\xF3\xB1\xA6\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97"],
        ["\xF3\xB1\xA6\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98"],
        ["\xF3\xB1\xA6\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99"],
        ["\xF3\xB1\xA6\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9A"],
        ["\xF3\xB1\xA6\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9B"],
        ["\xF3\xB1\xA6\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C"],
        ["\xF3\xB1\xA6\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D"],
        ["\xF3\xB1\xA6\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9E"],
        ["\xF3\xB1\xA6\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9F"],
        ["\xF3\xB1\xA6\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA0"],
        ["\xF3\xB1\xA6\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xF3\xB1\xA6\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xF3\xB1\xA6\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xF3\xB1\xA6\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xF3\xB1\xA6\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xF3\xB1\xA6\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xF3\xB1\xA6\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xF3\xB1\xA6\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xF3\xB1\xA6\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xF3\xB1\xA6\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xF3\xB1\xA6\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xF3\xB1\xA6\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xF3\xB1\xA6\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xF3\xB1\xA6\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xF3\xB1\xA6\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xF3\xB1\xA6\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xF3\xB1\xA6\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xF3\xB1\xA6\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xF3\xB1\xA6\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xF3\xB1\xA6\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xF3\xB1\xA6\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xF3\xB1\xA6\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xF3\xB1\xA6\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xF3\xB1\xA6\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xF3\xB1\xA6\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xF3\xB1\xA6\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xF3\xB1\xA6\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xF3\xB1\xA6\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xF3\xB1\xA6\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xF3\xB1\xA6\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xF3\xB1\xA6\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xF3\xB1\xA6\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xF3\xB1\xA6\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xF3\xB1\xA6\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xF3\xB1\xA6\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xF3\xB1\xA6\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xF3\xB1\xA7\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xF3\xB1\xA7\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xF3\xB1\xA7\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xF3\xB1\xA7\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xF3\xB1\xA7\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xF3\xB1\xA7\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xF3\xB1\xA7\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xF3\xB1\xA7\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xF3\xB1\xA7\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xF3\xB1\xA7\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xF3\xB1\xA7\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xF3\xB1\xA7\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xF3\xB1\xA7\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xF3\xB1\xA7\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xF3\xB1\xA7\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xF3\xB1\xA7\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xF3\xB1\xA7\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xF3\xB1\xA7\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xF3\xB1\xA7\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xF3\xB1\xA7\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xF3\xB1\xA7\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xF3\xB1\xA7\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xF3\xB1\xA7\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xF3\xB1\xA7\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xF3\xB1\xA7\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xF3\xB1\xA7\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xF3\xB1\xA7\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xF3\xB1\xA7\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xF3\xB1\xA7\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xF3\xB1\xA7\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xF3\xB1\xA7\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xF3\xB1\xA7\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xF3\xB1\xA7\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xF3\xB1\xA7\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xF3\xB1\xA7\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xF3\xB1\xA7\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xF3\xB1\xA7\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xF3\xB1\xA7\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xF3\xB1\xA7\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xF3\xB1\xA7\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xF3\xB1\xA7\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xF3\xB1\xA7\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xF3\xB1\xA7\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xF3\xB1\xA7\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xF3\xB1\xA7\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xF3\xB1\xA7\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xF3\xB1\xA7\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xF3\xB1\xA7\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xF3\xB1\xA7\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xF3\xB1\xA7\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xF3\xB1\xA7\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xF3\xB1\xA7\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xF3\xB1\xA7\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xF3\xB1\xA7\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xF3\xB1\xA7\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xF3\xB1\xA7\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xF3\xB1\xA7\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x40"],
        ["\xF3\xB1\xA7\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x41"],
        ["\xF3\xB1\xA7\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x42"],
        ["\xF3\xB1\xA7\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x43"],
        ["\xF3\xB1\xA7\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x44"],
        ["\xF3\xB1\xA7\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x45"],
        ["\xF3\xB1\xA7\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x46"],
        ["\xF3\xB1\xA7\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x47"],
        ["\xF3\xB1\xA8\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x48"],
        ["\xF3\xB1\xA8\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x49"],
        ["\xF3\xB1\xA8\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\xF3\xB1\xA8\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\xF3\xB1\xA8\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\xF3\xB1\xA8\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\xF3\xB1\xA8\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\xF3\xB1\xA8\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\xF3\xB1\xA8\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\xF3\xB1\xA8\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x51"],
        ["\xF3\xB1\xA8\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x52"],
        ["\xF3\xB1\xA8\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x53"],
        ["\xF3\xB1\xA8\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x54"],
        ["\xF3\xB1\xA8\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x55"],
        ["\xF3\xB1\xA8\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x56"],
        ["\xF3\xB1\xA8\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x57"],
        ["\xF3\xB1\xA8\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x58"],
        ["\xF3\xB1\xA8\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x59"],
        ["\xF3\xB1\xA8\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],
        ["\xF3\xB1\xA8\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5B"],
        ["\xF3\xB1\xA8\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5C"],
        ["\xF3\xB1\xA8\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5D"],
        ["\xF3\xB1\xA8\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5E"],
        ["\xF3\xB1\xA8\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],
        ["\xF3\xB1\xA8\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],
        ["\xF3\xB1\xA8\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],
        ["\xF3\xB1\xA8\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x62"],
        ["\xF3\xB1\xA8\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],
        ["\xF3\xB1\xA8\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x64"],
        ["\xF3\xB1\xA8\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x65"],
        ["\xF3\xB1\xA8\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x66"],
        ["\xF3\xB1\xA8\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x67"],
        ["\xF3\xB1\xA8\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],
        ["\xF3\xB1\xA8\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],
        ["\xF3\xB1\xA8\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6A"],
        ["\xF3\xB1\xA8\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6B"],
        ["\xF3\xB1\xA8\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6C"],
        ["\xF3\xB1\xA8\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6D"],
        ["\xF3\xB1\xA8\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6E"],
        ["\xF3\xB1\xA8\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6F"],
        ["\xF3\xB1\xA8\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x70"],
        ["\xF3\xB1\xA8\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],
        ["\xF3\xB1\xA8\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],
        ["\xF3\xB1\xA8\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x73"],
        ["\xF3\xB1\xA8\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x74"],
        ["\xF3\xB1\xA8\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x75"],
        ["\xF3\xB1\xA8\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x76"],
        ["\xF3\xB1\xA8\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x77"],
        ["\xF3\xB1\xA8\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\xF3\xB1\xA8\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],
        ["\xF3\xB1\xA8\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7A"],
        ["\xF3\xB1\xA8\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7B"],
        ["\xF3\xB1\xA8\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7C"],
        ["\xF3\xB1\xA8\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7D"],
        ["\xF3\xB1\xA8\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7E"],
        ["\xF3\xB1\xA8\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80"],
        ["\xF3\xB1\xA8\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81"],
        ["\xF3\xB1\xA8\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82"],
        ["\xF3\xB1\xA8\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83"],
        ["\xF3\xB1\xA8\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x84"],
        ["\xF3\xB1\xA8\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x85"],
        ["\xF3\xB1\xA8\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x86"],
        ["\xF3\xB1\xA8\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87"],
        ["\xF3\xB1\xA8\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x88"],
        ["\xF3\xB1\xA9\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89"],
        ["\xF3\xB1\xA9\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A"],
        ["\xF3\xB1\xA9\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B"],
        ["\xF3\xB1\xA9\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C"],
        ["\xF3\xB1\xA9\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D"],
        ["\xF3\xB1\xA9\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E"],
        ["\xF3\xB1\xA9\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F"],
        ["\xF3\xB1\xA9\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x90"],
        ["\xF3\xB1\xA9\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x91"],
        ["\xF3\xB1\xA9\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x92"],
        ["\xF3\xB1\xA9\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x93"],
        ["\xF3\xB1\xA9\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x94"],
        ["\xF3\xB1\xA9\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x95"],
        ["\xF3\xB1\xA9\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x96"],
        ["\xF3\xB1\xA9\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x97"],
        ["\xF3\xB1\xA9\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x98"],
        ["\xF3\xB1\xA9\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x99"],
        ["\xF3\xB1\xA9\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A"],
        ["\xF3\xB1\xA9\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B"],
        ["\xF3\xB1\xA9\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9C"],
        ["\xF3\xB1\xA9\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D"],
        ["\xF3\xB1\xA9\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9E"],
        ["\xF3\xB1\xA9\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F"],
        ["\xF3\xB1\xA9\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0"],
        ["\xF3\xB1\xA9\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xF3\xB1\xA9\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xF3\xB1\xA9\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xF3\xB1\xA9\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xF3\xB1\xA9\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xF3\xB1\xA9\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xF3\xB1\xA9\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xF3\xB1\xA9\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xF3\xB1\xA9\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xF3\xB1\xA9\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xF3\xB1\xA9\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xF3\xB1\xA9\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xF3\xB1\xA9\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xF3\xB1\xA9\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xF3\xB1\xA9\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xF3\xB1\xA9\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xF3\xB1\xA9\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xF3\xB1\xA9\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xF3\xB1\xA9\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xF3\xB1\xA9\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xF3\xB1\xA9\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xF3\xB1\xA9\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xF3\xB1\xA9\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xF3\xB1\xA9\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xF3\xB1\xA9\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xF3\xB1\xA9\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xF3\xB1\xA9\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xF3\xB1\xA9\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xF3\xB1\xA9\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xF3\xB1\xA9\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xF3\xB1\xA9\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xF3\xB1\xA9\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xF3\xB1\xA9\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xF3\xB1\xA9\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xF3\xB1\xA9\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xF3\xB1\xA9\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xF3\xB1\xA9\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xF3\xB1\xA9\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xF3\xB1\xA9\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xF3\xB1\xA9\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xF3\xB1\xAA\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xF3\xB1\xAA\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xF3\xB1\xAA\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xF3\xB1\xAA\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xF3\xB1\xAA\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xF3\xB1\xAA\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xF3\xB1\xAA\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xF3\xB1\xAA\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xF3\xB1\xAA\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xF3\xB1\xAA\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xF3\xB1\xAA\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xF3\xB1\xAA\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xF3\xB1\xAA\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xF3\xB1\xAA\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xF3\xB1\xAA\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xF3\xB1\xAA\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xF3\xB1\xAA\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xF3\xB1\xAA\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xF3\xB1\xAA\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xF3\xB1\xAA\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xF3\xB1\xAA\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xF3\xB1\xAA\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xF3\xB1\xAA\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xF3\xB1\xAA\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xF3\xB1\xAA\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xF3\xB1\xAA\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xF3\xB1\xAA\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xF3\xB1\xAA\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xF3\xB1\xAA\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xF3\xB1\xAA\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xF3\xB1\xAA\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xF3\xB1\xAA\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xF3\xB1\xAA\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xF3\xB1\xAA\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xF3\xB1\xAA\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xF3\xB1\xAA\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xF3\xB1\xAA\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xF3\xB1\xAA\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xF3\xB1\xAA\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xF3\xB1\xAA\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xF3\xB1\xAA\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xF3\xB1\xAA\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xF3\xB1\xAA\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xF3\xB1\xAA\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xF3\xB1\xAA\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xF3\xB1\xAA\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xF3\xB1\xAA\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xF3\xB1\xAA\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xF3\xB1\xAA\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xF3\xB1\xAA\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xF3\xB1\xAA\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xF3\xB1\xAA\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xF3\xB1\xAA\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x40"],
        ["\xF3\xB1\xAA\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x41"],
        ["\xF3\xB1\xAA\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x42"],
        ["\xF3\xB1\xAA\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x43"],
        ["\xF3\xB1\xAA\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x44"],
        ["\xF3\xB1\xAA\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x45"],
        ["\xF3\xB1\xAA\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x46"],
        ["\xF3\xB1\xAA\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x47"],
        ["\xF3\xB1\xAA\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x48"],
        ["\xF3\xB1\xAA\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x49"],
        ["\xF3\xB1\xAA\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4A"],
        ["\xF3\xB1\xAA\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],
        ["\xF3\xB1\xAB\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4C"],
        ["\xF3\xB1\xAB\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4D"],
        ["\xF3\xB1\xAB\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4E"],
        ["\xF3\xB1\xAB\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\xF3\xB1\xAB\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\xF3\xB1\xAB\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x51"],
        ["\xF3\xB1\xAB\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x52"],
        ["\xF3\xB1\xAB\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x53"],
        ["\xF3\xB1\xAB\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x54"],
        ["\xF3\xB1\xAB\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x55"],
        ["\xF3\xB1\xAB\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x56"],
        ["\xF3\xB1\xAB\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x57"],
        ["\xF3\xB1\xAB\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x58"],
        ["\xF3\xB1\xAB\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x59"],
        ["\xF3\xB1\xAB\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5A"],
        ["\xF3\xB1\xAB\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],
        ["\xF3\xB1\xAB\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],
        ["\xF3\xB1\xAB\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],
        ["\xF3\xB1\xAB\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],
        ["\xF3\xB1\xAB\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5F"],
        ["\xF3\xB1\xAB\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],
        ["\xF3\xB1\xAB\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x61"],
        ["\xF3\xB1\xAB\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x62"],
        ["\xF3\xB1\xAB\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x63"],
        ["\xF3\xB1\xAB\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x64"],
        ["\xF3\xB1\xAB\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x65"],
        ["\xF3\xB1\xAB\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x66"],
        ["\xF3\xB1\xAB\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x67"],
        ["\xF3\xB1\xAB\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\xF3\xB1\xAB\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xF3\xB1\xAB\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\xF3\xB1\xAB\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\xF3\xB1\xAB\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6C"],
        ["\xF3\xB1\xAB\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6D"],
        ["\xF3\xB1\xAB\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6E"],
        ["\xF3\xB1\xAB\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],
        ["\xF3\xB1\xAB\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x70"],
        ["\xF3\xB1\xAB\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x71"],
        ["\xF3\xB1\xAB\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x72"],
        ["\xF3\xB1\xAB\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],
        ["\xF3\xB1\xAB\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\xF3\xB1\xAB\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x75"],
        ["\xF3\xB1\xAB\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x76"],
        ["\xF3\xB1\xAB\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x77"],
        ["\xF3\xB1\xAB\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x78"],
        ["\xF3\xB1\xAB\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x79"],
        ["\xF3\xB1\xAB\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],
        ["\xF3\xB1\xAB\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7B"],
        ["\xF3\xB1\xAB\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7C"],
        ["\xF3\xB1\xAB\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7D"],
        ["\xF3\xB1\xAB\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\xF3\xB1\xAB\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x80"],
        ["\xF3\xB1\xAB\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x81"],
        ["\xF3\xB1\xAB\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x82"],
        ["\xF3\xB1\xAB\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x83"],
        ["\xF3\xB1\xAB\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x84"],
        ["\xF3\xB1\xAB\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x85"],
        ["\xF3\xB1\xAB\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x86"],
        ["\xF3\xB1\xAB\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x87"],
        ["\xF3\xB1\xAB\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x88"],
        ["\xF3\xB1\xAB\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x89"],
        ["\xF3\xB1\xAB\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8A"],
        ["\xF3\xB1\xAB\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B"],
        ["\xF3\xB1\xAB\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C"],
        ["\xF3\xB1\xAC\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8D"],
        ["\xF3\xB1\xAC\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8E"],
        ["\xF3\xB1\xAC\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F"],
        ["\xF3\xB1\xAC\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x90"],
        ["\xF3\xB1\xAC\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x91"],
        ["\xF3\xB1\xAC\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x92"],
        ["\xF3\xB1\xAC\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x93"],
        ["\xF3\xB1\xAC\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x94"],
        ["\xF3\xB1\xAC\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x95"],
        ["\xF3\xB1\xAC\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x96"],
        ["\xF3\xB1\xAC\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x97"],
        ["\xF3\xB1\xAC\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x98"],
        ["\xF3\xB1\xAC\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x99"],
        ["\xF3\xB1\xAC\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A"],
        ["\xF3\xB1\xAC\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9B"],
        ["\xF3\xB1\xAC\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C"],
        ["\xF3\xB1\xAC\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9D"],
        ["\xF3\xB1\xAC\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9E"],
        ["\xF3\xB1\xAC\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9F"],
        ["\xF3\xB1\xAC\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0"],
        ["\xF3\xB1\xAC\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xF3\xB1\xAC\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xF3\xB1\xAC\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xF3\xB1\xAC\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xF3\xB1\xAC\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xF3\xB1\xAC\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xF3\xB1\xAC\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xF3\xB1\xAC\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xF3\xB1\xAC\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xF3\xB1\xAC\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xF3\xB1\xAC\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xF3\xB1\xAC\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xF3\xB1\xAC\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xF3\xB1\xAC\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xF3\xB1\xAC\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xF3\xB1\xAC\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xF3\xB1\xAC\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xF3\xB1\xAC\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xF3\xB1\xAC\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xF3\xB1\xAC\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xF3\xB1\xAC\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xF3\xB1\xAC\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xF3\xB1\xAC\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xF3\xB1\xAC\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xF3\xB1\xAC\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xF3\xB1\xAC\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xF3\xB1\xAC\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xF3\xB1\xAC\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xF3\xB1\xAC\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xF3\xB1\xAC\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xF3\xB1\xAC\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xF3\xB1\xAC\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xF3\xB1\xAC\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xF3\xB1\xAC\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xF3\xB1\xAC\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xF3\xB1\xAC\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xF3\xB1\xAC\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xF3\xB1\xAC\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xF3\xB1\xAC\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xF3\xB1\xAC\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xF3\xB1\xAC\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xF3\xB1\xAC\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xF3\xB1\xAC\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xF3\xB1\xAC\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xF3\xB1\xAD\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xF3\xB1\xAD\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xF3\xB1\xAD\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xF3\xB1\xAD\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xF3\xB1\xAD\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xF3\xB1\xAD\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xF3\xB1\xAD\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xF3\xB1\xAD\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xF3\xB1\xAD\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xF3\xB1\xAD\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xF3\xB1\xAD\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xF3\xB1\xAD\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xF3\xB1\xAD\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xF3\xB1\xAD\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xF3\xB1\xAD\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xF3\xB1\xAD\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xF3\xB1\xAD\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xF3\xB1\xAD\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xF3\xB1\xAD\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xF3\xB1\xAD\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xF3\xB1\xAD\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xF3\xB1\xAD\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xF3\xB1\xAD\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xF3\xB1\xAD\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xF3\xB1\xAD\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xF3\xB1\xAD\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xF3\xB1\xAD\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xF3\xB1\xAD\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xF3\xB1\xAD\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xF3\xB1\xAD\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xF3\xB1\xAD\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xF3\xB1\xAD\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xF3\xB1\xAD\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xF3\xB1\xAD\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xF3\xB1\xAD\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xF3\xB1\xAD\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xF3\xB1\xAD\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xF3\xB1\xAD\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xF3\xB1\xAD\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xF3\xB1\xAD\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xF3\xB1\xAD\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xF3\xB1\xAD\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xF3\xB1\xAD\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xF3\xB1\xAD\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xF3\xB1\xAD\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xF3\xB1\xAD\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xF3\xB1\xAD\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xF3\xB1\xAD\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xF3\xB1\xAD\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x40"],
        ["\xF3\xB1\xAD\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x41"],
        ["\xF3\xB1\xAD\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x42"],
        ["\xF3\xB1\xAD\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x43"],
        ["\xF3\xB1\xAD\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x44"],
        ["\xF3\xB1\xAD\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x45"],
        ["\xF3\xB1\xAD\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x46"],
        ["\xF3\xB1\xAD\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x47"],
        ["\xF3\xB1\xAD\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x48"],
        ["\xF3\xB1\xAD\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x49"],
        ["\xF3\xB1\xAD\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],
        ["\xF3\xB1\xAD\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4B"],
        ["\xF3\xB1\xAD\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4C"],
        ["\xF3\xB1\xAD\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4D"],
        ["\xF3\xB1\xAD\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4E"],
        ["\xF3\xB1\xAD\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4F"],
        ["\xF3\xB1\xAE\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],
        ["\xF3\xB1\xAE\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x51"],
        ["\xF3\xB1\xAE\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x52"],
        ["\xF3\xB1\xAE\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x53"],
        ["\xF3\xB1\xAE\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x54"],
        ["\xF3\xB1\xAE\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x55"],
        ["\xF3\xB1\xAE\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x56"],
        ["\xF3\xB1\xAE\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x57"],
        ["\xF3\xB1\xAE\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x58"],
        ["\xF3\xB1\xAE\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x59"],
        ["\xF3\xB1\xAE\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5A"],
        ["\xF3\xB1\xAE\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5B"],
        ["\xF3\xB1\xAE\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5C"],
        ["\xF3\xB1\xAE\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5D"],
        ["\xF3\xB1\xAE\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5E"],
        ["\xF3\xB1\xAE\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5F"],
        ["\xF3\xB1\xAE\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x60"],
        ["\xF3\xB1\xAE\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x61"],
        ["\xF3\xB1\xAE\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],
        ["\xF3\xB1\xAE\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x63"],
        ["\xF3\xB1\xAE\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],
        ["\xF3\xB1\xAE\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x65"],
        ["\xF3\xB1\xAE\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x66"],
        ["\xF3\xB1\xAE\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x67"],
        ["\xF3\xB1\xAE\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x68"],
        ["\xF3\xB1\xAE\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x69"],
        ["\xF3\xB1\xAE\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],
        ["\xF3\xB1\xAE\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],
        ["\xF3\xB1\xAE\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],
        ["\xF3\xB1\xAE\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6D"],
        ["\xF3\xB1\xAE\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6E"],
        ["\xF3\xB1\xAE\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6F"],
        ["\xF3\xB1\xAE\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x70"],
        ["\xF3\xB1\xAE\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x71"],
        ["\xF3\xB1\xAE\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x72"],
        ["\xF3\xB1\xAE\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x73"],
        ["\xF3\xB1\xAE\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x74"],
        ["\xF3\xB1\xAE\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],
        ["\xF3\xB1\xAE\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x76"],
        ["\xF3\xB1\xAE\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x77"],
        ["\xF3\xB1\xAE\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x78"],
        ["\xF3\xB1\xAE\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],
        ["\xF3\xB1\xAE\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7A"],
        ["\xF3\xB1\xAE\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7B"],
        ["\xF3\xB1\xAE\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7C"],
        ["\xF3\xB1\xAE\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7D"],
        ["\xF3\xB1\xAE\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7E"],
        ["\xF3\xB1\xAE\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80"],
        ["\xF3\xB1\xAE\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81"],
        ["\xF3\xB1\xAE\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82"],
        ["\xF3\xB1\xAE\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83"],
        ["\xF3\xB1\xAE\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84"],
        ["\xF3\xB1\xAE\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85"],
        ["\xF3\xB1\xAE\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86"],
        ["\xF3\xB1\xAE\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87"],
        ["\xF3\xB1\xAE\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88"],
        ["\xF3\xB1\xAE\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89"],
        ["\xF3\xB1\xAE\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A"],
        ["\xF3\xB1\xAE\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B"],
        ["\xF3\xB1\xAE\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C"],
        ["\xF3\xB1\xAE\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D"],
        ["\xF3\xB1\xAE\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E"],
        ["\xF3\xB1\xAE\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F"],
        ["\xF3\xB1\xAE\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90"],
        ["\xF3\xB1\xAF\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91"],
        ["\xF3\xB1\xAF\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92"],
        ["\xF3\xB1\xAF\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93"],
        ["\xF3\xB1\xAF\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94"],
        ["\xF3\xB1\xAF\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95"],
        ["\xF3\xB1\xAF\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96"],
        ["\xF3\xB1\xAF\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97"],
        ["\xF3\xB1\xAF\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98"],
        ["\xF3\xB1\xAF\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99"],
        ["\xF3\xB1\xAF\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A"],
        ["\xF3\xB1\xAF\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B"],
        ["\xF3\xB1\xAF\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C"],
        ["\xF3\xB1\xAF\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D"],
        ["\xF3\xB1\xAF\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E"],
        ["\xF3\xB1\xAF\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F"],
        ["\xF3\xB1\xAF\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0"],
        ["\xF3\xB1\xAF\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xF3\xB1\xAF\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xF3\xB1\xAF\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xF3\xB1\xAF\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xF3\xB1\xAF\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xF3\xB1\xAF\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xF3\xB1\xAF\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xF3\xB1\xAF\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xF3\xB1\xAF\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xF3\xB1\xAF\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xF3\xB1\xAF\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xF3\xB1\xAF\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xF3\xB1\xAF\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xF3\xB1\xAF\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xF3\xB1\xAF\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xF3\xB1\xAF\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xF3\xB1\xAF\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xF3\xB1\xAF\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xF3\xB1\xAF\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xF3\xB1\xAF\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xF3\xB1\xAF\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xF3\xB1\xAF\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xF3\xB1\xAF\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xF3\xB1\xAF\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xF3\xB1\xAF\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xF3\xB1\xAF\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xF3\xB1\xAF\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xF3\xB1\xAF\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xF3\xB1\xAF\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xF3\xB1\xAF\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xF3\xB1\xAF\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xF3\xB1\xAF\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xF3\xB1\xAF\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xF3\xB1\xAF\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xF3\xB1\xAF\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xF3\xB1\xAF\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xF3\xB1\xAF\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xF3\xB1\xAF\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xF3\xB1\xAF\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xF3\xB1\xAF\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xF3\xB1\xAF\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xF3\xB1\xAF\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xF3\xB1\xAF\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xF3\xB1\xAF\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xF3\xB1\xAF\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xF3\xB1\xAF\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xF3\xB1\xAF\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xF3\xB1\xAF\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xF3\xB1\xB0\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xF3\xB1\xB0\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xF3\xB1\xB0\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xF3\xB1\xB0\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xF3\xB1\xB0\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xF3\xB1\xB0\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xF3\xB1\xB0\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xF3\xB1\xB0\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xF3\xB1\xB0\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xF3\xB1\xB0\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xF3\xB1\xB0\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xF3\xB1\xB0\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xF3\xB1\xB0\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xF3\xB1\xB0\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xF3\xB1\xB0\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xF3\xB1\xB0\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xF3\xB1\xB0\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xF3\xB1\xB0\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xF3\xB1\xB0\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xF3\xB1\xB0\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xF3\xB1\xB0\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xF3\xB1\xB0\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xF3\xB1\xB0\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xF3\xB1\xB0\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xF3\xB1\xB0\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xF3\xB1\xB0\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xF3\xB1\xB0\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xF3\xB1\xB0\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xF3\xB1\xB0\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xF3\xB1\xB0\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xF3\xB1\xB0\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xF3\xB1\xB0\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xF3\xB1\xB0\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xF3\xB1\xB0\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xF3\xB1\xB0\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xF3\xB1\xB0\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xF3\xB1\xB0\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xF3\xB1\xB0\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xF3\xB1\xB0\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xF3\xB1\xB0\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xF3\xB1\xB0\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xF3\xB1\xB0\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xF3\xB1\xB0\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xF3\xB1\xB0\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xF3\xB1\xB0\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x40"],
        ["\xF3\xB1\xB0\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x41"],
        ["\xF3\xB1\xB0\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x42"],
        ["\xF3\xB1\xB0\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x43"],
        ["\xF3\xB1\xB0\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x44"],
        ["\xF3\xB1\xB0\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x45"],
        ["\xF3\xB1\xB0\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x46"],
        ["\xF3\xB1\xB0\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x47"],
        ["\xF3\xB1\xB0\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x48"],
        ["\xF3\xB1\xB0\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x49"],
        ["\xF3\xB1\xB0\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],
        ["\xF3\xB1\xB0\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4B"],
        ["\xF3\xB1\xB0\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4C"],
        ["\xF3\xB1\xB0\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4D"],
        ["\xF3\xB1\xB0\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4E"],
        ["\xF3\xB1\xB0\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4F"],
        ["\xF3\xB1\xB0\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x50"],
        ["\xF3\xB1\xB0\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x51"],
        ["\xF3\xB1\xB0\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x52"],
        ["\xF3\xB1\xB0\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x53"],
        ["\xF3\xB1\xB1\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x54"],
        ["\xF3\xB1\xB1\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x55"],
        ["\xF3\xB1\xB1\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x56"],
        ["\xF3\xB1\xB1\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x57"],
        ["\xF3\xB1\xB1\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x58"],
        ["\xF3\xB1\xB1\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x59"],
        ["\xF3\xB1\xB1\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5A"],
        ["\xF3\xB1\xB1\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5B"],
        ["\xF3\xB1\xB1\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5C"],
        ["\xF3\xB1\xB1\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5D"],
        ["\xF3\xB1\xB1\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5E"],
        ["\xF3\xB1\xB1\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5F"],
        ["\xF3\xB1\xB1\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x60"],
        ["\xF3\xB1\xB1\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x61"],
        ["\xF3\xB1\xB1\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x62"],
        ["\xF3\xB1\xB1\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x63"],
        ["\xF3\xB1\xB1\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x64"],
        ["\xF3\xB1\xB1\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x65"],
        ["\xF3\xB1\xB1\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x66"],
        ["\xF3\xB1\xB1\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x67"],
        ["\xF3\xB1\xB1\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x68"],
        ["\xF3\xB1\xB1\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x69"],
        ["\xF3\xB1\xB1\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6A"],
        ["\xF3\xB1\xB1\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6B"],
        ["\xF3\xB1\xB1\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6C"],
        ["\xF3\xB1\xB1\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6D"],
        ["\xF3\xB1\xB1\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6E"],
        ["\xF3\xB1\xB1\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6F"],
        ["\xF3\xB1\xB1\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x70"],
        ["\xF3\xB1\xB1\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x71"],
        ["\xF3\xB1\xB1\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x72"],
        ["\xF3\xB1\xB1\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x73"],
        ["\xF3\xB1\xB1\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x74"],
        ["\xF3\xB1\xB1\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x75"],
        ["\xF3\xB1\xB1\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x76"],
        ["\xF3\xB1\xB1\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x77"],
        ["\xF3\xB1\xB1\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x78"],
        ["\xF3\xB1\xB1\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x79"],
        ["\xF3\xB1\xB1\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x7A"],
        ["\xF3\xB1\xB1\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x7B"],
        ["\xF3\xB1\xB1\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x7C"],
        ["\xF3\xB1\xB1\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x7D"],
        ["\xF3\xB1\xB1\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x7E"],
        ["\xF3\xB1\xB1\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80"],
        ["\xF3\xB1\xB1\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81"],
        ["\xF3\xB1\xB1\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82"],
        ["\xF3\xB1\xB1\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83"],
        ["\xF3\xB1\xB1\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84"],
        ["\xF3\xB1\xB1\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85"],
        ["\xF3\xB1\xB1\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86"],
        ["\xF3\xB1\xB1\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87"],
        ["\xF3\xB1\xB1\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88"],
        ["\xF3\xB1\xB1\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89"],
        ["\xF3\xB1\xB1\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A"],
        ["\xF3\xB1\xB1\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B"],
        ["\xF3\xB1\xB1\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C"],
        ["\xF3\xB1\xB1\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D"],
        ["\xF3\xB1\xB1\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E"],
        ["\xF3\xB1\xB1\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F"],
        ["\xF3\xB1\xB1\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90"],
        ["\xF3\xB1\xB1\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91"],
        ["\xF3\xB1\xB1\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92"],
        ["\xF3\xB1\xB1\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93"],
        ["\xF3\xB1\xB1\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94"],
        ["\xF3\xB1\xB2\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95"],
        ["\xF3\xB1\xB2\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96"],
        ["\xF3\xB1\xB2\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97"],
        ["\xF3\xB1\xB2\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98"],
        ["\xF3\xB1\xB2\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99"],
        ["\xF3\xB1\xB2\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A"],
        ["\xF3\xB1\xB2\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B"],
        ["\xF3\xB1\xB2\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C"],
        ["\xF3\xB1\xB2\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D"],
        ["\xF3\xB1\xB2\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E"],
        ["\xF3\xB1\xB2\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F"],
        ["\xF3\xB1\xB2\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0"],
        ["\xF3\xB1\xB2\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xF3\xB1\xB2\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\xF3\xB1\xB2\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\xF3\xB1\xB2\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\xF3\xB1\xB2\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\xF3\xB1\xB2\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xF3\xB1\xB2\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xF3\xB1\xB2\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xF3\xB1\xB2\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xF3\xB1\xB2\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\xF3\xB1\xB2\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xF3\xB1\xB2\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xF3\xB1\xB2\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\xF3\xB1\xB2\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xF3\xB1\xB2\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xF3\xB1\xB2\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xF3\xB1\xB2\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\xF3\xB1\xB2\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\xF3\xB1\xB2\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xF3\xB1\xB2\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xF3\xB1\xB2\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xF3\xB1\xB2\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\xF3\xB1\xB2\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\xF3\xB1\xB2\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xF3\xB1\xB2\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xF3\xB1\xB2\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xF3\xB1\xB2\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\xF3\xB1\xB2\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\xF3\xB1\xB2\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\xF3\xB1\xB2\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\xF3\xB1\xB2\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\xF3\xB1\xB2\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xF3\xB1\xB2\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xF3\xB1\xB2\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xF3\xB1\xB2\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xF3\xB1\xB2\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xF3\xB1\xB2\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xF3\xB1\xB2\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xF3\xB1\xB2\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xF3\xB1\xB2\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xF3\xB1\xB2\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xF3\xB1\xB2\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\xF3\xB1\xB2\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\xF3\xB1\xB2\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\xF3\xB1\xB2\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\xF3\xB1\xB2\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\xF3\xB1\xB2\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xF3\xB1\xB2\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xF3\xB1\xB2\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xF3\xB1\xB2\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xF3\xB1\xB2\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xF3\xB1\xB2\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xF3\xB1\xB3\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xF3\xB1\xB3\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xF3\xB1\xB3\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xF3\xB1\xB3\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xF3\xB1\xB3\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xF3\xB1\xB3\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xF3\xB1\xB3\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xF3\xB1\xB3\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xF3\xB1\xB3\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xF3\xB1\xB3\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\xF3\xB1\xB3\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\xF3\xB1\xB3\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xF3\xB1\xB3\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\xF3\xB1\xB3\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xF3\xB1\xB3\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xF3\xB1\xB3\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xF3\xB1\xB3\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xF3\xB1\xB3\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xF3\xB1\xB3\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xF3\xB1\xB3\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xF3\xB1\xB3\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xF3\xB1\xB3\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\xF3\xB1\xB3\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\xF3\xB1\xB3\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\xF3\xB1\xB3\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\xF3\xB1\xB3\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\xF3\xB1\xB3\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xF3\xB1\xB3\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xF3\xB1\xB3\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xF3\xB1\xB3\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xF3\xB1\xB3\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xF3\xB1\xB3\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xF3\xB1\xB3\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xF3\xB1\xB3\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xF3\xB1\xB3\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xF3\xB1\xB3\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xF3\xB1\xB3\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xF3\xB1\xB3\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\xF3\xB1\xB3\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\xF3\xB1\xB3\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\xF3\xB1\xB3\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x40"],
        ["\xF3\xB1\xB3\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x41"],
        ["\xF3\xB1\xB3\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x42"],
        ["\xF3\xB1\xB3\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x43"],
        ["\xF3\xB1\xB3\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x44"],
        ["\xF3\xB1\xB3\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x45"],
        ["\xF3\xB1\xB3\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x46"],
        ["\xF3\xB1\xB3\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x47"],
        ["\xF3\xB1\xB3\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x48"],
        ["\xF3\xB1\xB3\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x49"],
        ["\xF3\xB1\xB3\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4A"],
        ["\xF3\xB1\xB3\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4B"],
        ["\xF3\xB1\xB3\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4C"],
        ["\xF3\xB1\xB3\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4D"],
        ["\xF3\xB1\xB3\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4E"],
        ["\xF3\xB1\xB3\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4F"],
        ["\xF3\xB1\xB3\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x50"],
        ["\xF3\xB1\xB3\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x51"],
        ["\xF3\xB1\xB3\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x52"],
        ["\xF3\xB1\xB3\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x53"],
        ["\xF3\xB1\xB3\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x54"],
        ["\xF3\xB1\xB3\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x55"],
        ["\xF3\xB1\xB3\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x56"],
        ["\xF3\xB1\xB3\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x57"],
        ["\xF3\xB1\xB4\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x58"],
        ["\xF3\xB1\xB4\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x59"],
        ["\xF3\xB1\xB4\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5A"],
        ["\xF3\xB1\xB4\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5B"],
        ["\xF3\xB1\xB4\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5C"],
        ["\xF3\xB1\xB4\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5D"],
        ["\xF3\xB1\xB4\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5E"],
        ["\xF3\xB1\xB4\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5F"],
        ["\xF3\xB1\xB4\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x60"],
        ["\xF3\xB1\xB4\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x61"],
        ["\xF3\xB1\xB4\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x62"],
        ["\xF3\xB1\xB4\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x63"],
        ["\xF3\xB1\xB4\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x64"],
        ["\xF3\xB1\xB4\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x65"],
        ["\xF3\xB1\xB4\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x66"],
        ["\xF3\xB1\xB4\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\xF3\xB1\xB4\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xF3\xB1\xB4\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\xF3\xB1\xB4\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\xF3\xB1\xB4\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\xF3\xB1\xB4\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6C"],
        ["\xF3\xB1\xB4\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6D"],
        ["\xF3\xB1\xB4\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6E"],
        ["\xF3\xB1\xB4\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6F"],
        ["\xF3\xB1\xB4\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x70"],
        ["\xF3\xB1\xB4\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x71"],
        ["\xF3\xB1\xB4\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x72"],
        ["\xF3\xB1\xB4\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x73"],
        ["\xF3\xB1\xB4\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x74"],
        ["\xF3\xB1\xB4\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x75"],
        ["\xF3\xB1\xB4\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x76"],
        ["\xF3\xB1\xB4\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x77"],
        ["\xF3\xB1\xB4\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x78"],
        ["\xF3\xB1\xB4\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x79"],
        ["\xF3\xB1\xB4\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x7A"],
        ["\xF3\xB1\xB4\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x7B"],
        ["\xF3\xB1\xB4\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x7C"],
        ["\xF3\xB1\xB4\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x7D"],
        ["\xF3\xB1\xB4\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x7E"],
        ["\xF3\xB1\xB4\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],
        ["\xF3\xB1\xB4\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81"],
        ["\xF3\xB1\xB4\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82"],
        ["\xF3\xB1\xB4\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83"],
        ["\xF3\xB1\xB4\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84"],
        ["\xF3\xB1\xB4\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85"],
        ["\xF3\xB1\xB4\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86"],
        ["\xF3\xB1\xB4\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87"],
        ["\xF3\xB1\xB4\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88"],
        ["\xF3\xB1\xB4\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89"],
        ["\xF3\xB1\xB4\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A"],
        ["\xF3\xB1\xB4\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],
        ["\xF3\xB1\xB4\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C"],
        ["\xF3\xB1\xB4\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D"],
        ["\xF3\xB1\xB4\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E"],
        ["\xF3\xB1\xB4\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F"],
        ["\xF3\xB1\xB4\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90"],
        ["\xF3\xB1\xB4\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91"],
        ["\xF3\xB1\xB4\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92"],
        ["\xF3\xB1\xB4\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93"],
        ["\xF3\xB1\xB4\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94"],
        ["\xF3\xB1\xB4\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95"],
        ["\xF3\xB1\xB4\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96"],
        ["\xF3\xB1\xB4\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97"],
        ["\xF3\xB1\xB4\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98"],
        ["\xF3\xB1\xB5\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99"],
        ["\xF3\xB1\xB5\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A"],
        ["\xF3\xB1\xB5\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B"],
        ["\xF3\xB1\xB5\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],
        ["\xF3\xB1\xB5\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D"],
        ["\xF3\xB1\xB5\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E"],
        ["\xF3\xB1\xB5\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F"],
        ["\xF3\xB1\xB5\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0"],
        ["\xF3\xB1\xB5\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xF3\xB1\xB5\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\xF3\xB1\xB5\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\xF3\xB1\xB5\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\xF3\xB1\xB5\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\xF3\xB1\xB5\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\xF3\xB1\xB5\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\xF3\xB1\xB5\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\xF3\xB1\xB5\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\xF3\xB1\xB5\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xF3\xB1\xB5\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xF3\xB1\xB5\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\xF3\xB1\xB5\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\xF3\xB1\xB5\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\xF3\xB1\xB5\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xF3\xB1\xB5\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xF3\xB1\xB5\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xF3\xB1\xB5\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xF3\xB1\xB5\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xF3\xB1\xB5\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xF3\xB1\xB5\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xF3\xB1\xB5\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xF3\xB1\xB5\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xF3\xB1\xB5\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xF3\xB1\xB5\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xF3\xB1\xB5\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xF3\xB1\xB5\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xF3\xB1\xB5\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xF3\xB1\xB5\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xF3\xB1\xB5\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xF3\xB1\xB5\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xF3\xB1\xB5\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xF3\xB1\xB5\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xF3\xB1\xB5\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xF3\xB1\xB5\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xF3\xB1\xB5\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xF3\xB1\xB5\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xF3\xB1\xB5\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xF3\xB1\xB5\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xF3\xB1\xB5\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xF3\xB1\xB5\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xF3\xB1\xB5\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xF3\xB1\xB5\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xF3\xB1\xB5\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xF3\xB1\xB5\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\xF3\xB1\xB5\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\xF3\xB1\xB5\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\xF3\xB1\xB5\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xF3\xB1\xB5\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xF3\xB1\xB5\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xF3\xB1\xB5\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xF3\xB1\xB5\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xF3\xB1\xB5\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xF3\xB1\xB5\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xF3\xB1\xB5\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xF3\xB1\xB5\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xF3\xB1\xB6\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xF3\xB1\xB6\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\xF3\xB1\xB6\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\xF3\xB1\xB6\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\xF3\xB1\xB6\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\xF3\xB1\xB6\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\xF3\xB1\xB6\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\xF3\xB1\xB6\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xF3\xB1\xB6\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\xF3\xB1\xB6\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xF3\xB1\xB6\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xF3\xB1\xB6\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xF3\xB1\xB6\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xF3\xB1\xB6\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xF3\xB1\xB6\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xF3\xB1\xB6\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xF3\xB1\xB6\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xF3\xB1\xB6\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\xF3\xB1\xB6\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\xF3\xB1\xB6\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\xF3\xB1\xB6\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\xF3\xB1\xB6\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\xF3\xB1\xB6\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\xF3\xB1\xB6\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xF3\xB1\xB6\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xF3\xB1\xB6\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xF3\xB1\xB6\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xF3\xB1\xB6\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xF3\xB1\xB6\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xF3\xB1\xB6\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xF3\xB1\xB6\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xF3\xB1\xB6\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xF3\xB1\xB6\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xF3\xB1\xB6\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\xF3\xB1\xB6\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\xF3\xB1\xB6\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\xF3\xB1\xB6\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x40"],
        ["\xF3\xB1\xB6\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x41"],
        ["\xF3\xB1\xB6\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x42"],
        ["\xF3\xB1\xB6\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x43"],
        ["\xF3\xB1\xB6\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x44"],
        ["\xF3\xB1\xB6\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x45"],
        ["\xF3\xB1\xB6\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x46"],
        ["\xF3\xB1\xB6\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x47"],
        ["\xF3\xB1\xB6\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x48"],
        ["\xF3\xB1\xB6\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x49"],
        ["\xF3\xB1\xB6\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4A"],
        ["\xF3\xB1\xB6\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4B"],
        ["\xF3\xB1\xB6\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4C"],
        ["\xF3\xB1\xB6\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4D"],
        ["\xF3\xB1\xB6\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4E"],
        ["\xF3\xB1\xB6\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4F"],
        ["\xF3\xB1\xB6\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x50"],
        ["\xF3\xB1\xB6\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x51"],
        ["\xF3\xB1\xB6\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x52"],
        ["\xF3\xB1\xB6\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x53"],
        ["\xF3\xB1\xB6\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x54"],
        ["\xF3\xB1\xB6\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x55"],
        ["\xF3\xB1\xB6\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x56"],
        ["\xF3\xB1\xB6\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x57"],
        ["\xF3\xB1\xB6\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x58"],
        ["\xF3\xB1\xB6\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x59"],
        ["\xF3\xB1\xB6\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5A"],
        ["\xF3\xB1\xB6\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5B"],
        ["\xF3\xB1\xB7\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5C"],
        ["\xF3\xB1\xB7\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5D"],
        ["\xF3\xB1\xB7\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5E"],
        ["\xF3\xB1\xB7\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5F"],
        ["\xF3\xB1\xB7\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x60"],
        ["\xF3\xB1\xB7\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x61"],
        ["\xF3\xB1\xB7\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x62"],
        ["\xF3\xB1\xB7\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x63"],
        ["\xF3\xB1\xB7\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\xF3\xB1\xB7\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x65"],
        ["\xF3\xB1\xB7\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x66"],
        ["\xF3\xB1\xB7\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x67"],
        ["\xF3\xB1\xB7\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x68"],
        ["\xF3\xB1\xB7\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x69"],
        ["\xF3\xB1\xB7\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6A"],
        ["\xF3\xB1\xB7\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6B"],
        ["\xF3\xB1\xB7\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6C"],
        ["\xF3\xB1\xB7\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6D"],
        ["\xF3\xB1\xB7\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\xF3\xB1\xB7\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6F"],
        ["\xF3\xB1\xB7\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x70"],
        ["\xF3\xB1\xB7\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x71"],
        ["\xF3\xB1\xB7\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x72"],
        ["\xF3\xB1\xB7\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x73"],
        ["\xF3\xB1\xB7\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x74"],
        ["\xF3\xB1\xB7\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\xF3\xB1\xB7\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x76"],
        ["\xF3\xB1\xB7\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x77"],
        ["\xF3\xB1\xB7\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x78"],
        ["\xF3\xB1\xB7\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\xF3\xB1\xB7\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x7A"],
        ["\xF3\xB1\xB7\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x7B"],
        ["\xF3\xB1\xB7\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x7C"],
        ["\xF3\xB1\xB7\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x7D"],
        ["\xF3\xB1\xB7\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x7E"],
        ["\xF3\xB1\xB7\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80"],
        ["\xF3\xB1\xB7\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81"],
        ["\xF3\xB1\xB7\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82"],
        ["\xF3\xB1\xB7\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83"],
        ["\xF3\xB1\xB7\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84"],
        ["\xF3\xB1\xB7\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85"],
        ["\xF3\xB1\xB7\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86"],
        ["\xF3\xB1\xB7\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87"],
        ["\xF3\xB1\xB7\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88"],
        ["\xF3\xB1\xB7\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89"],
        ["\xF3\xB1\xB7\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A"],
        ["\xF3\xB1\xB7\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B"],
        ["\xF3\xB1\xB7\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C"],
        ["\xF3\xB1\xB7\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D"],
        ["\xF3\xB1\xB7\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E"],
        ["\xF3\xB1\xB7\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F"],
        ["\xF3\xB1\xB7\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90"],
        ["\xF3\xB1\xB7\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91"],
        ["\xF3\xB1\xB7\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92"],
        ["\xF3\xB1\xB7\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93"],
        ["\xF3\xB1\xB7\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94"],
        ["\xF3\xB1\xB7\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95"],
        ["\xF3\xB1\xB7\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96"],
        ["\xF3\xB1\xB7\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97"],
        ["\xF3\xB1\xB7\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98"],
        ["\xF3\xB1\xB7\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99"],
        ["\xF3\xB1\xB7\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A"],
        ["\xF3\xB1\xB7\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B"],
        ["\xF3\xB1\xB7\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\xF3\xB1\xB8\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D"],
        ["\xF3\xB1\xB8\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E"],
        ["\xF3\xB1\xB8\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F"],
        ["\xF3\xB1\xB8\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0"],
        ["\xF3\xB1\xB8\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xF3\xB1\xB8\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\xF3\xB1\xB8\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\xF3\xB1\xB8\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\xF3\xB1\xB8\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\xF3\xB1\xB8\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\xF3\xB1\xB8\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\xF3\xB1\xB8\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\xF3\xB1\xB8\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\xF3\xB1\xB8\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xF3\xB1\xB8\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xF3\xB1\xB8\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\xF3\xB1\xB8\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\xF3\xB1\xB8\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xF3\xB1\xB8\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\xF3\xB1\xB8\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xF3\xB1\xB8\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\xF3\xB1\xB8\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xF3\xB1\xB8\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\xF3\xB1\xB8\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\xF3\xB1\xB8\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\xF3\xB1\xB8\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\xF3\xB1\xB8\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\xF3\xB1\xB8\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xF3\xB1\xB8\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\xF3\xB1\xB8\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\xF3\xB1\xB8\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\xF3\xB1\xB8\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\xF3\xB1\xB8\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\xF3\xB1\xB8\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\xF3\xB1\xB8\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\xF3\xB1\xB8\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xF3\xB1\xB8\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xF3\xB1\xB8\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xF3\xB1\xB8\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xF3\xB1\xB8\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xF3\xB1\xB8\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xF3\xB1\xB8\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xF3\xB1\xB8\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xF3\xB1\xB8\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xF3\xB1\xB8\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xF3\xB1\xB8\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\xF3\xB1\xB8\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\xF3\xB1\xB8\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\xF3\xB1\xB8\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\xF3\xB1\xB8\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\xF3\xB1\xB8\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\xF3\xB1\xB8\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xF3\xB1\xB8\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xF3\xB1\xB8\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xF3\xB1\xB8\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xF3\xB1\xB8\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xF3\xB1\xB8\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xF3\xB1\xB8\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xF3\xB1\xB8\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xF3\xB1\xB8\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xF3\xB1\xB8\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xF3\xB1\xB8\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xF3\xB1\xB8\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xF3\xB1\xB8\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\xF3\xB1\xB9\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\xF3\xB1\xB9\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\xF3\xB1\xB9\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\xF3\xB1\xB9\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xF3\xB1\xB9\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\xF3\xB1\xB9\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xF3\xB1\xB9\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xF3\xB1\xB9\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xF3\xB1\xB9\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xF3\xB1\xB9\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xF3\xB1\xB9\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xF3\xB1\xB9\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xF3\xB1\xB9\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xF3\xB1\xB9\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\xF3\xB1\xB9\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xF3\xB1\xB9\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xF3\xB1\xB9\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\xF3\xB1\xB9\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\xF3\xB1\xB9\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\xF3\xB1\xB9\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xF3\xB1\xB9\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xF3\xB1\xB9\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xF3\xB1\xB9\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xF3\xB1\xB9\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xF3\xB1\xB9\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xF3\xB1\xB9\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xF3\xB1\xB9\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xF3\xB1\xB9\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xF3\xB1\xB9\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xF3\xB1\xB9\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xF3\xB1\xB9\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xF3\xB1\xB9\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\xF3\xB1\xB9\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x40"],
        ["\xF3\xB1\xB9\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x41"],
        ["\xF3\xB1\xB9\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x42"],
        ["\xF3\xB1\xB9\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x43"],
        ["\xF3\xB1\xB9\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x44"],
        ["\xF3\xB1\xB9\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x45"],
        ["\xF3\xB1\xB9\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x46"],
        ["\xF3\xB1\xB9\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x47"],
        ["\xF3\xB1\xB9\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x48"],
        ["\xF3\xB1\xB9\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x49"],
        ["\xF3\xB1\xB9\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4A"],
        ["\xF3\xB1\xB9\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4B"],
        ["\xF3\xB1\xB9\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4C"],
        ["\xF3\xB1\xB9\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4D"],
        ["\xF3\xB1\xB9\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4E"],
        ["\xF3\xB1\xB9\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4F"],
        ["\xF3\xB1\xB9\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x50"],
        ["\xF3\xB1\xB9\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x51"],
        ["\xF3\xB1\xB9\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x52"],
        ["\xF3\xB1\xB9\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x53"],
        ["\xF3\xB1\xB9\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x54"],
        ["\xF3\xB1\xB9\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x55"],
        ["\xF3\xB1\xB9\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x56"],
        ["\xF3\xB1\xB9\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x57"],
        ["\xF3\xB1\xB9\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x58"],
        ["\xF3\xB1\xB9\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x59"],
        ["\xF3\xB1\xB9\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5A"],
        ["\xF3\xB1\xB9\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5B"],
        ["\xF3\xB1\xB9\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5C"],
        ["\xF3\xB1\xB9\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5D"],
        ["\xF3\xB1\xB9\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5E"],
        ["\xF3\xB1\xB9\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5F"],
        ["\xF3\xB1\xBA\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x60"],
        ["\xF3\xB1\xBA\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x61"],
        ["\xF3\xB1\xBA\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x62"],
        ["\xF3\xB1\xBA\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\xF3\xB1\xBA\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x64"],
        ["\xF3\xB1\xBA\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x65"],
        ["\xF3\xB1\xBA\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x66"],
        ["\xF3\xB1\xBA\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x67"],
        ["\xF3\xB1\xBA\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x68"],
        ["\xF3\xB1\xBA\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x69"],
        ["\xF3\xB1\xBA\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],
        ["\xF3\xB1\xBA\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6B"],
        ["\xF3\xB1\xBA\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\xF3\xB1\xBA\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6D"],
        ["\xF3\xB1\xBA\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6E"],
        ["\xF3\xB1\xBA\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6F"],
        ["\xF3\xB1\xBA\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x70"],
        ["\xF3\xB1\xBA\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x71"],
        ["\xF3\xB1\xBA\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x72"],
        ["\xF3\xB1\xBA\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x73"],
        ["\xF3\xB1\xBA\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x74"],
        ["\xF3\xB1\xBA\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x75"],
        ["\xF3\xB1\xBA\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x76"],
        ["\xF3\xB1\xBA\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x77"],
        ["\xF3\xB1\xBA\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x78"],
        ["\xF3\xB1\xBA\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x79"],
        ["\xF3\xB1\xBA\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x7A"],
        ["\xF3\xB1\xBA\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x7B"],
        ["\xF3\xB1\xBA\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x7C"],
        ["\xF3\xB1\xBA\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x7D"],
        ["\xF3\xB1\xBA\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x7E"],
        ["\xF3\xB1\xBA\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80"],
        ["\xF3\xB1\xBA\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81"],
        ["\xF3\xB1\xBA\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82"],
        ["\xF3\xB1\xBA\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83"],
        ["\xF3\xB1\xBA\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84"],
        ["\xF3\xB1\xBA\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85"],
        ["\xF3\xB1\xBA\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86"],
        ["\xF3\xB1\xBA\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87"],
        ["\xF3\xB1\xBA\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88"],
        ["\xF3\xB1\xBA\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89"],
        ["\xF3\xB1\xBA\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A"],
        ["\xF3\xB1\xBA\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B"],
        ["\xF3\xB1\xBA\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C"],
        ["\xF3\xB1\xBA\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D"],
        ["\xF3\xB1\xBA\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E"],
        ["\xF3\xB1\xBA\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F"],
        ["\xF3\xB1\xBA\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90"],
        ["\xF3\xB1\xBA\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91"],
        ["\xF3\xB1\xBA\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x92"],
        ["\xF3\xB1\xBA\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x93"],
        ["\xF3\xB1\xBA\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x94"],
        ["\xF3\xB1\xBA\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x95"],
        ["\xF3\xB1\xBA\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96"],
        ["\xF3\xB1\xBA\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97"],
        ["\xF3\xB1\xBA\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98"],
        ["\xF3\xB1\xBA\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99"],
        ["\xF3\xB1\xBA\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A"],
        ["\xF3\xB1\xBA\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B"],
        ["\xF3\xB1\xBA\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C"],
        ["\xF3\xB1\xBA\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D"],
        ["\xF3\xB1\xBA\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E"],
        ["\xF3\xB1\xBA\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F"],
        ["\xF3\xB1\xBA\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0"],
        ["\xF3\xB1\xBB\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xF3\xB1\xBB\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\xF3\xB1\xBB\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\xF3\xB1\xBB\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\xF3\xB1\xBB\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\xF3\xB1\xBB\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\xF3\xB1\xBB\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\xF3\xB1\xBB\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\xF3\xB1\xBB\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\xF3\xB1\xBB\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\xF3\xB1\xBB\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xF3\xB1\xBB\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\xF3\xB1\xBB\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xF3\xB1\xBB\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\xF3\xB1\xBB\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\xF3\xB1\xBB\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xF3\xB1\xBB\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\xF3\xB1\xBB\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\xF3\xB1\xBB\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\xF3\xB1\xBB\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\xF3\xB1\xBB\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\xF3\xB1\xBB\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\xF3\xB1\xBB\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\xF3\xB1\xBB\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\xF3\xB1\xBB\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\xF3\xB1\xBB\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\xF3\xB1\xBB\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\xF3\xB1\xBB\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\xF3\xB1\xBB\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\xF3\xB1\xBB\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\xF3\xB1\xBB\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\xF3\xB1\xBB\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xF3\xB1\xBB\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xF3\xB1\xBB\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xF3\xB1\xBB\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xF3\xB1\xBB\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xF3\xB1\xBB\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xF3\xB1\xBB\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xF3\xB1\xBB\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xF3\xB1\xBB\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xF3\xB1\xBB\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xF3\xB1\xBB\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\xF3\xB1\xBB\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\xF3\xB1\xBB\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\xF3\xB1\xBB\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\xF3\xB1\xBB\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\xF3\xB1\xBB\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\xF3\xB1\xBB\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xF3\xB1\xBB\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xF3\xB1\xBB\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xF3\xB1\xBB\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xF3\xB1\xBB\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xF3\xB1\xBB\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xF3\xB1\xBB\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xF3\xB1\xBB\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xF3\xB1\xBB\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xF3\xB1\xBB\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xF3\xB1\xBB\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\xF3\xB1\xBB\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\xF3\xB1\xBB\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\xF3\xB1\xBB\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\xF3\xB1\xBB\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\xF3\xB1\xBB\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\xF3\xB1\xBB\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xF3\xB1\xBC\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\xF3\xB1\xBC\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xF3\xB1\xBC\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xF3\xB1\xBC\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xF3\xB1\xBC\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xF3\xB1\xBC\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xF3\xB1\xBC\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xF3\xB1\xBC\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xF3\xB1\xBC\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xF3\xB1\xBC\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\xF3\xB1\xBC\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\xF3\xB1\xBC\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\xF3\xB1\xBC\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\xF3\xB1\xBC\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\xF3\xB1\xBC\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\xF3\xB1\xBC\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xF3\xB1\xBC\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xF3\xB1\xBC\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xF3\xB1\xBC\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xF3\xB1\xBC\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xF3\xB1\xBC\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xF3\xB1\xBC\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xF3\xB1\xBC\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xF3\xB1\xBC\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xF3\xB1\xBC\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xF3\xB1\xBC\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\xF3\xB1\xBC\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\xF3\xB1\xBC\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\xF3\xB1\xBC\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x40"],
        ["\xF3\xB1\xBC\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x41"],
        ["\xF3\xB1\xBC\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x42"],
        ["\xF3\xB1\xBC\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x43"],
        ["\xF3\xB1\xBC\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x44"],
        ["\xF3\xB1\xBC\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x45"],
        ["\xF3\xB1\xBC\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x46"],
        ["\xF3\xB1\xBC\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x47"],
        ["\xF3\xB1\xBC\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x48"],
        ["\xF3\xB1\xBC\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x49"],
        ["\xF3\xB1\xBC\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x4A"],
        ["\xF3\xB1\xBC\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x4B"],
        ["\xF3\xB1\xBC\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x4C"],
        ["\xF3\xB1\xBC\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x4D"],
        ["\xF3\xB1\xBC\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x4E"],
        ["\xF3\xB1\xBC\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x4F"],
        ["\xF3\xB1\xBC\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x50"],
        ["\xF3\xB1\xBC\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x51"],
        ["\xF3\xB1\xBC\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x52"],
        ["\xF3\xB1\xBC\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x53"],
        ["\xF3\xB1\xBC\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x54"],
        ["\xF3\xB1\xBC\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x55"],
        ["\xF3\xB1\xBC\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x56"],
        ["\xF3\xB1\xBC\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x57"],
        ["\xF3\xB1\xBC\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x58"],
        ["\xF3\xB1\xBC\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x59"],
        ["\xF3\xB1\xBC\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x5A"],
        ["\xF3\xB1\xBC\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x5B"],
        ["\xF3\xB1\xBC\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x5C"],
        ["\xF3\xB1\xBC\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x5D"],
        ["\xF3\xB1\xBC\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x5E"],
        ["\xF3\xB1\xBC\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x5F"],
        ["\xF3\xB1\xBC\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x60"],
        ["\xF3\xB1\xBC\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x61"],
        ["\xF3\xB1\xBC\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x62"],
        ["\xF3\xB1\xBC\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x63"],
        ["\xF3\xB1\xBD\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x64"],
        ["\xF3\xB1\xBD\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x65"],
        ["\xF3\xB1\xBD\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x66"],
        ["\xF3\xB1\xBD\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x67"],
        ["\xF3\xB1\xBD\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x68"],
        ["\xF3\xB1\xBD\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x69"],
        ["\xF3\xB1\xBD\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x6A"],
        ["\xF3\xB1\xBD\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x6B"],
        ["\xF3\xB1\xBD\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x6C"],
        ["\xF3\xB1\xBD\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x6D"],
        ["\xF3\xB1\xBD\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x6E"],
        ["\xF3\xB1\xBD\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x6F"],
        ["\xF3\xB1\xBD\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x70"],
        ["\xF3\xB1\xBD\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x71"],
        ["\xF3\xB1\xBD\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x72"],
        ["\xF3\xB1\xBD\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x73"],
        ["\xF3\xB1\xBD\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x74"],
        ["\xF3\xB1\xBD\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x75"],
        ["\xF3\xB1\xBD\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x76"],
        ["\xF3\xB1\xBD\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x77"],
        ["\xF3\xB1\xBD\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x78"],
        ["\xF3\xB1\xBD\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x79"],
        ["\xF3\xB1\xBD\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x7A"],
        ["\xF3\xB1\xBD\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x7B"],
        ["\xF3\xB1\xBD\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x7C"],
        ["\xF3\xB1\xBD\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x7D"],
        ["\xF3\xB1\xBD\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x7E"],
        ["\xF3\xB1\xBD\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x80"],
        ["\xF3\xB1\xBD\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x81"],
        ["\xF3\xB1\xBD\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x82"],
        ["\xF3\xB1\xBD\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x83"],
        ["\xF3\xB1\xBD\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x84"],
        ["\xF3\xB1\xBD\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x85"],
        ["\xF3\xB1\xBD\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x86"],
        ["\xF3\xB1\xBD\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x87"],
        ["\xF3\xB1\xBD\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x88"],
        ["\xF3\xB1\xBD\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x89"],
        ["\xF3\xB1\xBD\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x8A"],
        ["\xF3\xB1\xBD\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x8B"],
        ["\xF3\xB1\xBD\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x8C"],
        ["\xF3\xB1\xBD\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x8D"],
        ["\xF3\xB1\xBD\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x8E"],
        ["\xF3\xB1\xBD\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x8F"],
        ["\xF3\xB1\xBD\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x90"],
        ["\xF3\xB1\xBD\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x91"],
        ["\xF3\xB1\xBD\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x92"],
        ["\xF3\xB1\xBD\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x93"],
        ["\xF3\xB1\xBD\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x94"],
        ["\xF3\xB1\xBD\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x95"],
        ["\xF3\xB1\xBD\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x96"],
        ["\xF3\xB1\xBD\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x97"],
        ["\xF3\xB1\xBD\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x98"],
        ["\xF3\xB1\xBD\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x99"],
        ["\xF3\xB1\xBD\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x9A"],
        ["\xF3\xB1\xBD\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x9B"],
        ["\xF3\xB1\xBD\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x9C"],
        ["\xF3\xB1\xBD\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x9D"],
        ["\xF3\xB1\xBD\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x9E"],
        ["\xF3\xB1\xBD\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\x9F"],
        ["\xF3\xB1\xBD\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA0"],
        ["\xF3\xB1\xBD\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\xF3\xB1\xBD\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\xF3\xB1\xBD\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\xF3\xB1\xBD\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\xF3\xB2\xAB\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB3"],
        ["\xF3\xB2\xAB\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB4"],
        ["\xF3\xB2\xAB\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB5"],
        ["\xF3\xB2\xAB\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB6"],
        ["\xF3\xB2\xAB\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB7"],
        ["\xF3\xB2\xAB\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB8"],
        ["\xF3\xB2\xAB\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB9"],
        ["\xF3\xB2\xAB\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xBA"],
        ["\xF3\xB2\xAB\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xBB"],
        ["\xF3\xB2\xAB\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xBC"],
        ["\xF3\xB2\xAB\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xAD"],
        ["\xF3\xB2\xAB\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xAE"],
        ["\xF3\xB2\xAB\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],
        ["\xF3\xB2\xAB\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x8E"],
        ["\xF3\xB2\xAB\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x58"],
        ["\xF3\xB2\xAB\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x4D"],
        ["\xF3\xB2\xAB\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD3"],
        ["\xF3\xB2\xAB\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB7"],
        ["\xF3\xB2\xAB\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x80"],
        ["\xF3\xB2\xAB\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x54"],
        ["\xF3\xB2\xAC\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x89"],
        ["\xF3\xB2\xAC\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x42"],
        ["\xF3\xB2\xAC\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x56"],
        ["\xF3\xB2\xAC\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],
        ["\xF3\xB2\xAC\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA2"],
        ["\xF3\xB2\xAC\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA6"],
        ["\xF3\xB2\xAC\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5E"],
        ["\xF3\xB2\xAC\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA9"],
        ["\xF3\xB2\xAC\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xAE"],
        ["\xF3\xB2\xAC\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6C"],
        ["\xF3\xB2\xAC\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB3"],
        ["\xF3\xB2\xAC\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6D"],
        ["\xF3\xB2\xAC\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB4"],
        ["\xF3\xB2\xAC\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xBF"],
        ["\xF3\xB2\xAC\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x7C"],
        ["\xF3\xB2\xAC\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x7B"],
        ["\xF3\xB2\xAC\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x80"],
        ["\xF3\xB2\xAC\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x87"],
        ["\xF3\xB2\xAC\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x7E"],
        ["\xF3\xB2\xAC\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xC2"],
        ["\xF3\xB2\xAC\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xCD"],
        ["\xF3\xB2\xAC\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xD2"],
        ["\xF3\xB2\xAC\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xDB"],
        ["\xF3\xB2\xAC\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x62"],
        ["\xF3\xB2\xAC\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xE5"],
        ["\xF3\xB2\xAC\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xE9"],
        ["\xF3\xB2\xAC\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xEA"],
        ["\xF3\xB2\xAC\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6D"],
        ["\xF3\xB2\xAC\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xF0"],
        ["\xF3\xB2\xAC\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xF2"],
        ["\xF3\xB2\xAC\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xF6"],
        ["\xF3\xB2\xAC\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x8C"],
        ["\xF3\xB2\xAC\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x40"],
        ["\xF3\xB2\xAC\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x42"],
        ["\xF3\xB2\xAC\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x49"],
        ["\xF3\xB2\xAC\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],
        ["\xF3\xB2\xAC\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x6E"],
        ["\xF3\xB2\xAC\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x6D"],
        ["\xF3\xB2\xAC\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x6A"],
        ["\xF3\xB2\xAC\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x76"],
        ["\xF3\xB2\xAC\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x7C"],
        ["\xF3\xB2\xAC\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x59"],
        ["\xF3\xB2\xAC\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x64"],
        ["\xF3\xB2\xAC\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x89"],
        ["\xF3\xB2\xAC\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x8D"],
        ["\xF3\xB2\xAD\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x75"],
        ["\xF3\xB2\xAD\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],
        ["\xF3\xB2\xAD\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],
        ["\xF3\xB2\xAD\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x78"],
        ["\xF3\xB2\xAD\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x79"],
        ["\xF3\xB2\xAD\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x7B"],
        ["\xF3\xB2\xAD\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],
        ["\xF3\xB2\xAD\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x89"],
        ["\xF3\xB2\xAD\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x91"],
        ["\xF3\xB2\xAD\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x95"],
        ["\xF3\xB2\xAD\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x92"],
        ["\xF3\xB2\xAD\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],
        ["\xF3\xB2\xAD\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x97"],
        ["\xF3\xB2\xAD\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x9C"],
        ["\xF3\xB2\xAD\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],
        ["\xF3\xB2\xAD\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],
        ["\xF3\xB2\xAD\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],
        ["\xF3\xB2\xAD\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],
        ["\xF3\xB2\xAD\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],
        ["\xF3\xB2\xAD\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCB"],
        ["\xF3\xB2\xAD\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],
        ["\xF3\xB2\xAD\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],
        ["\xF3\xB2\xAD\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],
        ["\xF3\xB2\xAD\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],
        ["\xF3\xB2\xAD\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],
        ["\xF3\xB2\xAD\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x41"],
        ["\xF3\xB2\xAD\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],
        ["\xF3\xB2\xAD\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],
        ["\xF3\xB2\xAD\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6F"],
        ["\xF3\xB2\xAD\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],
        ["\xF3\xB2\xAD\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x4B"],
        ["\xF3\xB2\xAD\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x4D"],
        ["\xF3\xB2\xAD\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x4C"],
        ["\xF3\xB2\xAD\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x4E"],
        ["\xF3\xB2\xAD\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x51"],
        ["\xF3\xB2\xAD\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x5D"],
        ["\xF3\xB2\xAD\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x9E"],
        ["\xF3\xB2\xAD\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x5A"],
        ["\xF3\xB2\xAD\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x5E"],
        ["\xF3\xB2\xAD\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],
        ["\xF3\xB2\xAD\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x63"],
        ["\xF3\xB2\xAD\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x64"],
        ["\xF3\xB2\xAD\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1"],
        ["\xF3\xB2\xAD\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x6B"],
        ["\xF3\xB2\xAD\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x6D"],
        ["\xF3\xB2\xAD\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x6F"],
        ["\xF3\xB2\xAD\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x77"],
        ["\xF3\xB2\xAD\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x7D"],
        ["\xF3\xB2\xAD\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x79"],
        ["\xF3\xB2\xAE\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x7C"],
        ["\xF3\xB2\xAE\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDD"],
        ["\xF3\xB2\xAE\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xFB"],
        ["\xF3\xB2\xAE\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],
        ["\xF3\xB2\xAE\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x98"],
        ["\xF3\xB2\xAE\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x9A"],
        ["\xF3\xB2\xAE\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x55"],
        ["\xF3\xB2\xAE\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA0"],
        ["\xF3\xB2\xAE\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x60"],
        ["\xF3\xB2\xAE\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],
        ["\xF3\xB2\xAE\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x72"],
        ["\xF3\xB2\xAE\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],
        ["\xF3\xB2\xAE\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x79"],
        ["\xF3\xB2\xAE\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],
        ["\xF3\xB2\xAE\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],
        ["\xF3\xB2\xAE\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xB3"],
        ["\xF3\xB2\xAE\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],
        ["\xF3\xB2\xAE\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],
        ["\xF3\xB2\xAE\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC2"],
        ["\xF3\xB2\xAE\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],
        ["\xF3\xB2\xAE\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],
        ["\xF3\xB2\xAE\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],
        ["\xF3\xB2\xAE\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE6"],
        ["\xF3\xB2\xAE\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],
        ["\xF3\xB2\xAE\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],
        ["\xF3\xB2\xAE\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xEE"],
        ["\xF3\xB2\xAE\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF1"],
        ["\xF3\xB2\xAE\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x43"],
        ["\xF3\xB2\xAE\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x4E"],
        ["\xF3\xB2\xAE\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x60"],
        ["\xF3\xB2\xAE\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x5A"],
        ["\xF3\xB2\xAE\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x5B"],
        ["\xF3\xB2\xAE\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x69"],
        ["\xF3\xB2\xAE\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x5D"],
        ["\xF3\xB2\xAE\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x64"],
        ["\xF3\xB2\xAE\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x66"],
        ["\xF3\xB2\xAE\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x6B"],
        ["\xF3\xB2\xAE\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x8B"],
        ["\xF3\xB2\xAE\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x76"],
        ["\xF3\xB2\xAE\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x71"],
        ["\xF3\xB2\xAE\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x72"],
        ["\xF3\xB2\xAE\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x79"],
        ["\xF3\xB2\xAE\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x7D"],
        ["\xF3\xB2\xAE\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x81"],
        ["\xF3\xB2\xAE\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xBB"],
        ["\xF3\xB2\xAE\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x89"],
        ["\xF3\xB2\xAE\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x8F"],
        ["\xF3\xB2\xAE\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD5"],
        ["\xF3\xB2\xAE\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x99"],
        ["\xF3\xB2\xAE\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x9B"],
        ["\xF3\xB2\xAE\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x9D"],
        ["\xF3\xB2\xAE\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x9F"],
        ["\xF3\xB2\xAE\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],
        ["\xF3\xB2\xAF\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],
        ["\xF3\xB2\xAF\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],
        ["\xF3\xB2\xAF\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],
        ["\xF3\xB2\xAF\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],
        ["\xF3\xB2\xAF\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],
        ["\xF3\xB2\xAF\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],
        ["\xF3\xB2\xAF\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],
        ["\xF3\xB2\xAF\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x8F"],
        ["\xF3\xB2\xAF\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],
        ["\xF3\xB2\xAF\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],
        ["\xF3\xB2\xAF\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],
        ["\xF3\xB2\xAF\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],
        ["\xF3\xB2\xAF\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x63"],
        ["\xF3\xB2\xAF\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC1"],
        ["\xF3\xB2\xAF\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x41"],
        ["\xF3\xB2\xAF\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC4"],
        ["\xF3\xB2\xAF\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xDC"],
        ["\xF3\xB2\xAF\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x5B"],
        ["\xF3\xB2\xAF\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x5C"],
        ["\xF3\xB2\xAF\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE5"],
        ["\xF3\xB2\xAF\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x60"],
        ["\xF3\xB2\xAF\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE8"],
        ["\xF3\xB2\xAF\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x58"],
        ["\xF3\xB2\xAF\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x59"],
        ["\xF3\xB2\xAF\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x77"],
        ["\xF3\xB2\xAF\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x83"],
        ["\xF3\xB2\xAF\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA0"],
        ["\xF3\xB2\xAF\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],
        ["\xF3\xB2\xAF\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC5"],
        ["\xF3\xB2\xAF\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],
        ["\xF3\xB2\xAF\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],
        ["\xF3\xB2\xAF\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],
        ["\xF3\xB2\xAF\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],
        ["\xF3\xB2\xAF\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],
        ["\xF3\xB2\xAF\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],
        ["\xF3\xB2\xAF\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xB1"],
        ["\xF3\xB2\xAF\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],
        ["\xF3\xB2\xAF\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x47"],
        ["\xF3\xB2\xAF\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x4E"],
        ["\xF3\xB2\xAF\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xEF"],
        ["\xF3\xB2\xAF\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x57"],
        ["\xF3\xB2\xAF\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x59"],
        ["\xF3\xB2\xAF\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x5F"],
        ["\xF3\xB2\xAF\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x57"],
        ["\xF3\xB2\xAF\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x64"],
        ["\xF3\xB2\xAF\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x8D"],
        ["\xF3\xB2\xAF\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x9D"],
        ["\xF3\xB2\xAF\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA0"],
        ["\xF3\xB2\xAF\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],
        ["\xF3\xB2\xAF\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],
        ["\xF3\xB2\xAF\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xDE"],
        ["\xF3\xB2\xAF\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],
        ["\xF3\xB2\xB0\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],
        ["\xF3\xB2\xB0\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],
        ["\xF3\xB2\xB0\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xED"],
        ["\xF3\xB2\xB0\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x4F"],
        ["\xF3\xB2\xB0\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],
        ["\xF3\xB2\xB0\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],
        ["\xF3\xB2\xB0\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x8E"],
        ["\xF3\xB2\xB0\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],
        ["\xF3\xB2\xB0\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],
        ["\xF3\xB2\xB0\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],
        ["\xF3\xB2\xB0\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],
        ["\xF3\xB2\xB0\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xCC"],
        ["\xF3\xB2\xB0\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],
        ["\xF3\xB2\xB0\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x41"],
        ["\xF3\xB2\xB0\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xD0"],
        ["\xF3\xB2\xB0\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],
        ["\xF3\xB2\xB0\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x40"],
        ["\xF3\xB2\xB0\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x44"],
        ["\xF3\xB2\xB0\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xD2"],
        ["\xF3\xB2\xB0\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x47"],
        ["\xF3\xB2\xB0\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x49"],
        ["\xF3\xB2\xB0\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x48"],
        ["\xF3\xB2\xB0\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xDA"],
        ["\xF3\xB2\xB0\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xDD"],
        ["\xF3\xB2\xB0\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xDB"],
        ["\xF3\xB2\xB0\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x46"],
        ["\xF3\xB2\xB0\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xE1"],
        ["\xF3\xB2\xB0\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xED"],
        ["\xF3\xB2\xB0\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x4C"],
        ["\xF3\xB2\xB0\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xFA"],
        ["\xF3\xB2\xB0\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xF7"],
        ["\xF3\xB2\xB0\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xF8"],
        ["\xF3\xB2\xB0\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xF6"],
        ["\xF3\xB2\xB0\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x52"],
        ["\xF3\xB2\xB0\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x51"],
        ["\xF3\xB2\xB0\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x57"],
        ["\xF3\xB2\xB0\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x56"],
        ["\xF3\xB2\xB0\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x43"],
        ["\xF3\xB2\xB0\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x48"],
        ["\xF3\xB2\xB0\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x53"],
        ["\xF3\xB2\xB0\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x47"],
        ["\xF3\xB2\xB0\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x44"],
        ["\xF3\xB2\xB0\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x5E"],
        ["\xF3\xB2\xB0\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x4F"],
        ["\xF3\xB2\xB0\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x62"],
        ["\xF3\xB2\xB0\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x63"],
        ["\xF3\xB2\xB0\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x6C"],
        ["\xF3\xB2\xB1\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x7C"],
        ["\xF3\xB2\xB1\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x7D"],
        ["\xF3\xB2\xB1\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x8C"],
        ["\xF3\xB2\xB1\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x86"],
        ["\xF3\xB2\xB1\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x87"],
        ["\xF3\xB2\xB1\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x88"],
        ["\xF3\xB2\xB1\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x8A"],
        ["\xF3\xB2\xB1\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x9C"],
        ["\xF3\xB2\xB1\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x9F"],
        ["\xF3\xB2\xB1\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],
        ["\xF3\xB2\xB1\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],
        ["\xF3\xB2\xB1\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],
        ["\xF3\xB2\xB1\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x51"],
        ["\xF3\xB2\xB1\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],
        ["\xF3\xB2\xB1\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],
        ["\xF3\xB2\xB1\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],
        ["\xF3\xB2\xB1\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x69"],
        ["\xF3\xB2\xB1\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],
        ["\xF3\xB2\xB1\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],
        ["\xF3\xB2\xB1\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xB2"],
        ["\xF3\xB2\xB1\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xCD"],
        ["\xF3\xB2\xB1\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],
        ["\xF3\xB2\xB4\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x5C"],
        ["\xF3\xB2\xB4\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x61"],
        ["\xF3\xB2\xB5\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x7C"],
        ["\xF3\xB2\xB5\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x91"],
        ["\xF3\xB2\xB5\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x92"],
        ["\xF3\xB2\xB6\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xB1"],
        ["\xF3\xB2\xB6\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xB2"],
        ["\xF3\xB2\xB6\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xB3"],
        ["\xF3\xB2\xB6\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xB4"],
        ["\xF3\xB2\xB6\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xB5"],
        ["\xF3\xB2\xB6\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xB6"],
        ["\xF3\xB2\xB6\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xB7"],
        ["\xF3\xB2\xB6\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC0"],
        ["\xF3\xB2\xB6\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC1"],
        ["\xF3\xB2\xB6\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC2"],
        ["\xF3\xB2\xB6\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC3"],
        ["\xF3\xB2\xB6\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC4"],
        ["\xF3\xB2\xB6\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC5"],
        ["\xF3\xB2\xB6\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC6"],
        ["\xF3\xB2\xB6\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC7"],
        ["\xF3\xB2\xB6\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xCA"],
        ["\xF3\xB2\xB6\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xCF"],
        ["\xF3\xB2\xB6\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xD0"],
        ["\xF3\xB2\xB6\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xD1"],
        ["\xF3\xB2\xB6\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xD3"],
        ["\xF3\xB2\xB6\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xD4"],
        ["\xF3\xB2\xB6\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xD5"],
        ["\xF3\xB2\xB6\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xD6"],
        ["\xF3\xB2\xB6\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xD7"],
        ["\xF3\xB2\xB6\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xD8"],
        ["\xF3\xB2\xB6\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xD9"],
        ["\xF3\xB2\xB6\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE9"],
        ["\xF3\xB2\xB6\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xEA"],
        ["\xF3\xB2\xB6\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xEB"],
        ["\xF3\xB2\xB6\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xEC"],
        ["\xF3\xB2\xB6\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xED"],
        ["\xF3\xB2\xB6\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xEE"],
        ["\xF3\xB2\xB6\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xEF"],
        ["\xF3\xB2\xB7\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF8"],
        ["\xF3\xB2\xB7\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF9"],
        ["\xF3\xB2\xB7\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xFA"],
        ["\xF3\xB2\xB7\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xFB"],
        ["\xF3\xB2\xB7\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x40"],
        ["\xF3\xB2\xB7\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x41"],
        ["\xF3\xB2\xB7\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x42"],
        ["\xF3\xB2\xB7\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x43"],
        ["\xF3\xB2\xB7\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x44"],
        ["\xF3\xB2\xB7\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x45"],
        ["\xF3\xB2\xB7\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x46"],
        ["\xF3\xB2\xB7\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x47"],
        ["\xF3\xB2\xB7\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x48"],
        ["\xF3\xB2\xB7\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x49"],
        ["\xF3\xB2\xB7\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x4A"],
        ["\xF3\xB2\xB7\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x4B"],
        ["\xF3\xB2\xB7\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x4C"],
        ["\xF3\xB2\xB7\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x4D"],
        ["\xF3\xB2\xB7\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x4E"],
        ["\xF3\xB2\xB7\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x59"],
        ["\xF3\xB2\xB7\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x5A"],
        ["\xF3\xB2\xB7\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x5B"],
        ["\xF3\xB2\xB7\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x5C"],
        ["\xF3\xB2\xB7\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x5D"],
        ["\xF3\xB2\xB7\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x5E"],
        ["\xF3\xB2\xB7\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x5F"],
        ["\xF3\xB2\xB8\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x7A"],
        ["\xF3\xB2\xB8\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x7B"],
        ["\xF3\xB2\xB8\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x7C"],
        ["\xF3\xB2\xB8\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x7D"],
        ["\xF3\xB2\xB8\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x7E"],
        ["\xF3\xB2\xB8\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x80"],
        ["\xF3\xB2\xB8\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x9B"],
        ["\xF3\xB2\xB8\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x9C"],
        ["\xF3\xB2\xB8\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x9D"],
        ["\xF3\xB2\xB8\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x9E"],
        ["\xF3\xB2\xB9\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF2"],
        ["\xF3\xB2\xB9\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF3"],
        ["\xF3\xB2\xB9\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF4"],
        ["\xF3\xB2\xBA\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF5"],
        ["\xF3\xB2\xBA\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF6"],
        ["\xF3\xB2\xBA\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF7"],
        ["\xF3\xB2\xBA\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF8"],
        ["\xF3\xB2\xBA\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF9"],
        ["\xF3\xB2\xBB\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x97"],
        ["\xF3\xB2\xBB\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x98"],
        ["\xF3\xB2\xBB\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x99"],
        ["\xF3\xB2\xBB\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x9A"],
        ["\xF3\xB2\xBB\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x9B"],
        ["\xF3\xB2\xBB\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x9C"],
        ["\xF3\xB2\xBB\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x9D"],
        ["\xF3\xB2\xBB\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x9E"],
        ["\xF3\xB2\xBB\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB7"],
        ["\xF3\xB2\xBB\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB8"],
        ["\xF3\xB2\xBC\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB9"],
        ["\xF3\xB2\xBC\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xBA"],
        ["\xF3\xB2\xBC\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xBB"],
        ["\xF3\xB2\xBC\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xBC"],
        ["\xF3\xB2\xBC\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xBD"],
        ["\xF3\xB2\xBC\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xBE"],
        ["\xF3\xB2\xBC\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD7"],
        ["\xF3\xB2\xBC\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD8"],
        ["\xF3\xB2\xBC\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD9"],
        ["\xF3\xB2\xBC\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xDA"],
        ["\xF3\xB2\xBC\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xDB"],
        ["\xF3\xB2\xBC\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xDC"],
        ["\xF3\xB2\xBC\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xDD"],
        ["\xF3\xB2\xBC\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xDE"],
        ["\xF3\xB2\xBC\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xDF"],
        ["\xF3\xB2\xBC\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xE0"],
        ["\xF3\xB2\xBC\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xE1"],
        ["\xF3\xB2\xBC\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xE2"],
        ["\xF3\xB2\xBC\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xE3"],
        ["\xF3\xB2\xBC\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xE4"],
        ["\xF3\xB2\xBC\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xE5"],
        ["\xF3\xB2\xBC\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xE6"],
        ["\xF3\xB2\xBC\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xE7"],
        ["\xF3\xB2\xBC\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xE8"],
        ["\xF3\xB2\xBC\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xE9"],
        ["\xF3\xB2\xBC\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xEA"],
        ["\xF3\xB2\xBC\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xEB"],
        ["\xF3\xB2\xBC\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xEC"],
        ["\xF3\xB2\xBC\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xED"],
        ["\xF3\xB2\xBC\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xEE"],
        ["\xF3\xB2\xBC\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xEF"],
        ["\xF3\xB2\xBC\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xF0"],
        ["\xF3\xB2\xBC\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xF1"],
        ["\xF3\xB2\xBC\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xF2"],
        ["\xF3\xB2\xBC\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xF3"],
        ["\xF3\xB2\xBC\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xF4"],
        ["\xF3\xB2\xBC\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xF5"],
        ["\xF3\xB2\xBC\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xF6"],
        ["\xF3\xB2\xBC\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xF7"],
        ["\xF3\xB2\xBC\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xF8"],
        ["\xF3\xB2\xBD\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xF9"],
        ["\xF3\xB2\xBD\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xFA"],
        ["\xF3\xB2\xBD\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xFB"],
        ["\xF3\xB2\xBD\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xFC"],
        ["\xF3\xB2\xBD\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x61"],
        ["\xF3\xB2\xBD\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x62"],
        ["\xF3\xB2\xBD\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x63"],
        ["\xF3\xB2\xBD\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x64"],
        ["\xF3\xB2\xBD\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x65"],
        ["\xF3\xB2\xBD\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x66"],
        ["\xF3\xB2\xBD\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x67"],
        ["\xF3\xB2\xBD\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x68"],
        ["\xF3\xB2\xBD\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x69"],
        ["\xF3\xB2\xBD\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x6A"],
        ["\xF3\xB2\xBD\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x6B"],
        ["\xF3\xB2\xBD\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x6C"],
        ["\xF3\xB2\xBD\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x6D"],
        ["\xF3\xB2\xBD\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x6E"],
        ["\xF3\xB2\xBD\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x6F"],
        ["\xF3\xB2\xBE\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x92"],
        ["\xF3\xB2\xBE\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x93"],
        ["\xF3\xB2\xBE\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x94"],
        ["\xF3\xB2\xBE\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x95"],
        ["\xF3\xB2\xBE\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x96"],
        ["\xF3\xB2\xBE\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x97"],
        ["\xF3\xB2\xBE\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x98"],
        ["\xF3\xB2\xBE\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x99"],
        ["\xF3\xB2\xBE\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x9A"],
        ["\xF3\xB2\xBE\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x9B"],
        ["\xF3\xB2\xBE\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x9C"],
        ["\xF3\xB2\xBE\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x9D"],
        ["\xF3\xB2\xBE\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x9E"],
        ["\xF3\xB2\xBF\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xBF"],
        ["\xF3\xB2\xBF\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xC0"],
        ["\xF3\xB2\xBF\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xC1"],
        ["\xF3\xB2\xBF\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xC2"],
        ["\xF3\xB2\xBF\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xC3"],
        ["\xF3\xB2\xBF\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xC4"],
        ["\xF3\xB2\xBF\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xC5"],
        ["\xF3\xB2\xBF\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xC6"],
        ["\xF3\xB2\xBF\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xC7"],
        ["\xF3\xB2\xBF\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xC8"],
        ["\xF3\xB2\xBF\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xC9"],
        ["\xF3\xB2\xBF\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xCA"],
        ["\xF3\xB2\xBF\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xCB"],
        ["\xF3\xB2\xBF\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xCC"],
        ["\xF3\xB2\xBF\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xCD"],
        ["\xF3\xB2\xBF\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xCE"],
        ["\xF3\xB2\xBF\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xCF"],
        ["\xF3\xB2\xBF\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xD0"],
        ["\xF3\xB2\xBF\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xD1"],
        ["\xF3\xB2\xBF\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xD2"],
        ["\xF3\xB2\xBF\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xD3"],
        ["\xF3\xB2\xBF\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xD4"],
        ["\xF3\xB2\xBF\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xD5"],
        ["\xF3\xB2\xBF\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xD6"],
        ["\xF3\xB2\xBF\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xD7"],
        ["\xF3\xB2\xBF\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xD8"],
        ["\xF3\xB2\xBF\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xD9"],
        ["\xF3\xB2\xBF\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xDA"],
        ["\xF3\xB2\xBF\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xDB"],
        ["\xF3\xB2\xBF\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xDC"],
        ["\xF3\xB2\xBF\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xE5"],
        ["\xF3\xB2\xBF\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xE6"],
        ["\xF3\xB2\xBF\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xE7"],
        ["\xF3\xB2\xBF\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xE8"],
        ["\xF3\xB2\xBF\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xE9"],
        ["\xF3\xB2\xBF\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xEA"],
        ["\xF3\xB2\xBF\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xEB"],
        ["\xF3\xB2\xBF\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xEC"],
        ["\xF3\xB2\xBF\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xED"],
        ["\xF3\xB2\xBF\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xEE"],
        ["\xF3\xB2\xBF\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xEF"],
        ["\xF3\xB2\xBF\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xF0"],
        ["\xF3\xB2\xBF\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xF1"],
        ["\xF3\xB2\xBF\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xF2"],
        ["\xF3\xB2\xBF\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xF3"],
        ["\xF3\xB2\xBF\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xF4"],
        ["\xF3\xB2\xBF\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xF5"],
        ["\xF3\xB2\xBF\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xF6"],
        ["\xF3\xB2\xBF\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xF7"],
        ["\xF3\xB2\xBF\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xF8"],
        ["\xF3\xB2\xBF\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xF9"],
        ["\xF3\xB2\xBF\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xFA"],
        ["\xF3\xB3\x80\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x40"],
        ["\xF3\xB3\x80\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x41"],
        ["\xF3\xB3\x80\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x42"],
        ["\xF3\xB3\x80\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x43"],
        ["\xF3\xB3\x80\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x44"],
        ["\xF3\xB3\x80\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x45"],
        ["\xF3\xB3\x80\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x46"],
        ["\xF3\xB3\x80\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x47"],
        ["\xF3\xB3\x80\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x48"],
        ["\xF3\xB3\x80\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x49"],
        ["\xF3\xB3\x80\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x4A"],
        ["\xF3\xB3\x80\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x4B"],
        ["\xF3\xB3\x80\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x4C"],
        ["\xF3\xB3\x80\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x4D"],
        ["\xF3\xB3\x80\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x4E"],
        ["\xF3\xB3\x80\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x4F"],
        ["\xF3\xB3\x80\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x50"],
        ["\xF3\xB3\x80\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x51"],
        ["\xF3\xB3\x80\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x52"],
        ["\xF3\xB3\x80\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x53"],
        ["\xF3\xB3\x80\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x54"],
        ["\xF3\xB3\x80\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x55"],
        ["\xF3\xB3\x80\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x56"],
        ["\xF3\xB3\x80\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x57"],
        ["\xF3\xB3\x80\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x58"],
        ["\xF3\xB3\x80\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x59"],
        ["\xF3\xB3\x80\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x5A"],
        ["\xF3\xB3\x80\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x5B"],
        ["\xF3\xB3\x80\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x5C"],
        ["\xF3\xB3\x80\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x5D"],
        ["\xF3\xB3\x80\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x5E"],
        ["\xF3\xB3\x80\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x5F"],
        ["\xF3\xB3\x80\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x60"],
        ["\xF3\xB3\x80\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x61"],
        ["\xF3\xB3\x80\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x62"],
        ["\xF3\xB3\x80\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x63"],
        ["\xF3\xB3\x80\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x64"],
        ["\xF3\xB3\x80\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x65"],
        ["\xF3\xB3\x80\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x66"],
        ["\xF3\xB3\x80\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x67"],
        ["\xF3\xB3\x80\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x68"],
        ["\xF3\xB3\x80\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x69"],
        ["\xF3\xB3\x80\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x6A"],
        ["\xF3\xB3\x80\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x6B"],
        ["\xF3\xB3\x80\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x6C"],
        ["\xF3\xB3\x80\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x6D"],
        ["\xF3\xB3\x80\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x6E"],
        ["\xF3\xB3\x80\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x6F"],
        ["\xF3\xB3\x80\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x70"],
        ["\xF3\xB3\x80\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x71"],
        ["\xF3\xB3\x80\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x72"],
        ["\xF3\xB3\x80\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x73"],
        ["\xF3\xB3\x80\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x74"],
        ["\xF3\xB3\x80\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x75"],
        ["\xF3\xB3\x80\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x76"],
        ["\xF3\xB3\x80\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x77"],
        ["\xF3\xB3\x80\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x78"],
        ["\xF3\xB3\x80\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x79"],
        ["\xF3\xB3\x80\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x7A"],
        ["\xF3\xB3\x80\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x7B"],
        ["\xF3\xB3\x80\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x7C"],
        ["\xF3\xB3\x80\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x7D"],
        ["\xF3\xB3\x80\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x7E"],
        ["\xF3\xB3\x80\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x80"],
        ["\xF3\xB3\x81\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x81"],
        ["\xF3\xB3\x81\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x82"],
        ["\xF3\xB3\x81\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x83"],
        ["\xF3\xB3\x81\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x84"],
        ["\xF3\xB3\x81\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x85"],
        ["\xF3\xB3\x81\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x86"],
        ["\xF3\xB3\x81\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x87"],
        ["\xF3\xB3\x81\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x88"],
        ["\xF3\xB3\x81\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x89"],
        ["\xF3\xB3\x81\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x8A"],
        ["\xF3\xB3\x81\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x8B"],
        ["\xF3\xB3\x81\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x8C"],
        ["\xF3\xB3\x81\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x8D"],
        ["\xF3\xB3\x81\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x8E"],
        ["\xF3\xB3\x81\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x8F"],
        ["\xF3\xB3\x81\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x90"],
        ["\xF3\xB3\x81\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x91"],
        ["\xF3\xB3\x81\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x92"],
        ["\xF3\xB3\x81\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x93"],
        ["\xF3\xB3\x81\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x94"],
        ["\xF3\xB3\x81\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x95"],
        ["\xF3\xB3\x81\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x96"],
        ["\xF3\xB3\x81\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x97"],
        ["\xF3\xB3\x81\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x98"],
        ["\xF3\xB3\x81\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x99"],
        ["\xF3\xB3\x81\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x9A"],
        ["\xF3\xB3\x81\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x9B"],
        ["\xF3\xB3\x81\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x9C"],
        ["\xF3\xB3\x81\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x9D"],
        ["\xF3\xB3\x81\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x9E"],
        ["\xF3\xB3\x81\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x9F"],
        ["\xF3\xB3\x81\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA0"],
        ["\xF3\xB3\x81\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA1"],
        ["\xF3\xB3\x81\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA2"],
        ["\xF3\xB3\x81\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA3"],
        ["\xF3\xB3\x81\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA4"],
        ["\xF3\xB3\x81\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA5"],
        ["\xF3\xB3\x81\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA6"],
        ["\xF3\xB3\x81\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA7"],
        ["\xF3\xB3\x81\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA8"],
        ["\xF3\xB3\x81\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA9"],
        ["\xF3\xB3\x81\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xAA"],
        ["\xF3\xB3\x81\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xAB"],
        ["\xF3\xB3\x81\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xAC"],
        ["\xF3\xB3\x81\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xAD"],
        ["\xF3\xB3\x81\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xAE"],
        ["\xF3\xB3\x81\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xAF"],
        ["\xF3\xB3\x81\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB0"],
        ["\xF3\xB3\x81\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB1"],
        ["\xF3\xB3\x81\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB2"],
        ["\xF3\xB3\x81\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB3"],
        ["\xF3\xB3\x81\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB4"],
        ["\xF3\xB3\x81\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB5"],
        ["\xF3\xB3\x81\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB6"],
        ["\xF3\xB3\x81\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB7"],
        ["\xF3\xB3\x81\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB8"],
        ["\xF3\xB3\x81\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB9"],
        ["\xF3\xB3\x81\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xBA"],
        ["\xF3\xB3\x81\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xBB"],
        ["\xF3\xB3\x81\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xBC"],
        ["\xF3\xB3\x81\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xBD"],
        ["\xF3\xB3\x81\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xBE"],
        ["\xF3\xB3\x81\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xBF"],
        ["\xF3\xB3\x81\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xC0"],
        ["\xF3\xB3\x82\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xC1"],
        ["\xF3\xB3\x82\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xC2"],
        ["\xF3\xB3\x82\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xC3"],
        ["\xF3\xB3\x82\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xC4"],
        ["\xF3\xB3\x82\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xC5"],
        ["\xF3\xB3\x82\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xC6"],
        ["\xF3\xB3\x82\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xC7"],
        ["\xF3\xB3\x82\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xC8"],
        ["\xF3\xB3\x82\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xC9"],
        ["\xF3\xB3\x82\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xCA"],
        ["\xF3\xB3\x82\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xCB"],
        ["\xF3\xB3\x82\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xCC"],
        ["\xF3\xB3\x82\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xCD"],
        ["\xF3\xB3\x82\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xCE"],
        ["\xF3\xB3\x82\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xCF"],
        ["\xF3\xB3\x82\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xD0"],
        ["\xF3\xB3\x82\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xD1"],
        ["\xF3\xB3\x82\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xD2"],
        ["\xF3\xB3\x82\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xD3"],
        ["\xF3\xB3\x82\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xD4"],
        ["\xF3\xB3\x82\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xD5"],
        ["\xF3\xB3\x82\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xD6"],
        ["\xF3\xB3\x82\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xD7"],
        ["\xF3\xB3\x82\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xD8"],
        ["\xF3\xB3\x82\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xD9"],
        ["\xF3\xB3\x82\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xDA"],
        ["\xF3\xB3\x82\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xDB"],
        ["\xF3\xB3\x82\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xDC"],
        ["\xF3\xB3\x82\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xDD"],
        ["\xF3\xB3\x82\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xDE"],
        ["\xF3\xB3\x82\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xDF"],
        ["\xF3\xB3\x82\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xE0"],
        ["\xF3\xB3\x82\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xE1"],
        ["\xF3\xB3\x82\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xE2"],
        ["\xF3\xB3\x82\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xE3"],
        ["\xF3\xB3\x82\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xE4"],
        ["\xF3\xB3\x82\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xE5"],
        ["\xF3\xB3\x82\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xE6"],
        ["\xF3\xB3\x82\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xE7"],
        ["\xF3\xB3\x82\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xE8"],
        ["\xF3\xB3\x82\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xE9"],
        ["\xF3\xB3\x82\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xEA"],
        ["\xF3\xB3\x82\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xEB"],
        ["\xF3\xB3\x82\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xEC"],
        ["\xF3\xB3\x82\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xED"],
        ["\xF3\xB3\x82\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xEE"],
        ["\xF3\xB3\x82\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xEF"],
        ["\xF3\xB3\x82\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xF0"],
        ["\xF3\xB3\x82\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xF1"],
        ["\xF3\xB3\x82\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xF2"],
        ["\xF3\xB3\x82\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xF3"],
        ["\xF3\xB3\x82\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xF4"],
        ["\xF3\xB3\x82\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xF5"],
        ["\xF3\xB3\x82\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xF6"],
        ["\xF3\xB3\x82\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xF7"],
        ["\xF3\xB3\x82\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xF8"],
        ["\xF3\xB3\x82\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xF9"],
        ["\xF3\xB3\x82\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xFA"],
        ["\xF3\xB3\x82\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xFB"],
        ["\xF3\xB3\x82\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xFC"],
        ["\xF3\xB3\x82\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x40"],
        ["\xF3\xB3\x82\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x41"],
        ["\xF3\xB3\x82\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x42"],
        ["\xF3\xB3\x82\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x43"],
        ["\xF3\xB3\x83\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x44"],
        ["\xF3\xB3\x83\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x45"],
        ["\xF3\xB3\x83\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x46"],
        ["\xF3\xB3\x83\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x47"],
        ["\xF3\xB3\x83\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x48"],
        ["\xF3\xB3\x83\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x49"],
        ["\xF3\xB3\x83\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x4A"],
        ["\xF3\xB3\x83\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x4B"],
        ["\xF3\xB3\x83\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x4C"],
        ["\xF3\xB3\x83\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x4D"],
        ["\xF3\xB3\x83\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x4E"],
        ["\xF3\xB3\x83\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x4F"],
        ["\xF3\xB3\x83\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x50"],
        ["\xF3\xB3\x83\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x51"],
        ["\xF3\xB3\x83\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x52"],
        ["\xF3\xB3\x83\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x53"],
        ["\xF3\xB3\x83\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x54"],
        ["\xF3\xB3\x83\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x55"],
        ["\xF3\xB3\x83\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x56"],
        ["\xF3\xB3\x83\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x57"],
        ["\xF3\xB3\x83\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x58"],
        ["\xF3\xB3\x83\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x59"],
        ["\xF3\xB3\x83\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x5A"],
        ["\xF3\xB3\x83\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x5B"],
        ["\xF3\xB3\x83\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x5C"],
        ["\xF3\xB3\x83\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x5D"],
        ["\xF3\xB3\x83\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x5E"],
        ["\xF3\xB3\x83\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x5F"],
        ["\xF3\xB3\x83\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x60"],
        ["\xF3\xB3\x83\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x61"],
        ["\xF3\xB3\x83\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x62"],
        ["\xF3\xB3\x83\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x63"],
        ["\xF3\xB3\x83\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x64"],
        ["\xF3\xB3\x83\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x65"],
        ["\xF3\xB3\x83\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x66"],
        ["\xF3\xB3\x83\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x67"],
        ["\xF3\xB3\x83\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x68"],
        ["\xF3\xB3\x83\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x69"],
        ["\xF3\xB3\x83\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x6A"],
        ["\xF3\xB3\x83\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x6B"],
        ["\xF3\xB3\x83\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x6C"],
        ["\xF3\xB3\x83\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x6D"],
        ["\xF3\xB3\x83\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x6E"],
        ["\xF3\xB3\x83\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x6F"],
        ["\xF3\xB3\x83\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x70"],
        ["\xF3\xB3\x83\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x71"],
        ["\xF3\xB3\x83\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x72"],
        ["\xF3\xB3\x83\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x73"],
        ["\xF3\xB3\x83\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x74"],
        ["\xF3\xB3\x83\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x75"],
        ["\xF3\xB3\x83\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x76"],
        ["\xF3\xB3\x83\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x77"],
        ["\xF3\xB3\x83\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x78"],
        ["\xF3\xB3\x83\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x79"],
        ["\xF3\xB3\x83\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x7A"],
        ["\xF3\xB3\x83\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x7B"],
        ["\xF3\xB3\x83\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x7C"],
        ["\xF3\xB3\x83\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x7D"],
        ["\xF3\xB3\x83\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x7E"],
        ["\xF3\xB3\x83\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x80"],
        ["\xF3\xB3\x83\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x81"],
        ["\xF3\xB3\x83\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x82"],
        ["\xF3\xB3\x83\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x83"],
        ["\xF3\xB3\x83\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x84"],
        ["\xF3\xB3\x84\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x85"],
        ["\xF3\xB3\x84\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x86"],
        ["\xF3\xB3\x84\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x87"],
        ["\xF3\xB3\x84\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x88"],
        ["\xF3\xB3\x84\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x89"],
        ["\xF3\xB3\x84\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x8A"],
        ["\xF3\xB3\x84\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x8B"],
        ["\xF3\xB3\x84\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x8C"],
        ["\xF3\xB3\x84\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x8D"],
        ["\xF3\xB3\x84\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x8E"],
        ["\xF3\xB3\x84\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x8F"],
        ["\xF3\xB3\x84\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x90"],
        ["\xF3\xB3\x84\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x91"],
        ["\xF3\xB3\x84\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x92"],
        ["\xF3\xB3\x84\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x93"],
        ["\xF3\xB3\x84\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x94"],
        ["\xF3\xB3\x84\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x95"],
        ["\xF3\xB3\x84\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x96"],
        ["\xF3\xB3\x84\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x97"],
        ["\xF3\xB3\x84\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x98"],
        ["\xF3\xB3\x84\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x99"],
        ["\xF3\xB3\x84\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x9A"],
        ["\xF3\xB3\x84\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x9B"],
        ["\xF3\xB3\x84\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x9C"],
        ["\xF3\xB3\x84\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x9D"],
        ["\xF3\xB3\x84\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x9E"],
        ["\xF3\xB3\x84\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x9F"],
        ["\xF3\xB3\x84\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA0"],
        ["\xF3\xB3\x84\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA1"],
        ["\xF3\xB3\x84\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA2"],
        ["\xF3\xB3\x84\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA3"],
        ["\xF3\xB3\x84\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA4"],
        ["\xF3\xB3\x84\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA5"],
        ["\xF3\xB3\x84\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA6"],
        ["\xF3\xB3\x84\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA7"],
        ["\xF3\xB3\x84\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA8"],
        ["\xF3\xB3\x84\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA9"],
        ["\xF3\xB3\x84\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xAA"],
        ["\xF3\xB3\x84\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xAB"],
        ["\xF3\xB3\x84\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xAC"],
        ["\xF3\xB3\x84\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xAD"],
        ["\xF3\xB3\x84\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xAE"],
        ["\xF3\xB3\x84\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xAF"],
        ["\xF3\xB3\x84\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB0"],
        ["\xF3\xB3\x84\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB1"],
        ["\xF3\xB3\x84\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB2"],
        ["\xF3\xB3\x84\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xBD"],
        ["\xF3\xB3\x84\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xBE"],
        ["\xF3\xB3\x84\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xBF"],
        ["\xF3\xB3\x84\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xC0"],
        ["\xF3\xB3\x84\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xC1"],
        ["\xF3\xB3\x84\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xC2"],
        ["\xF3\xB3\x84\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xC3"],
        ["\xF3\xB3\x84\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xC4"],
        ["\xF3\xB3\x85\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xC5"],
        ["\xF3\xB3\x85\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xC6"],
        ["\xF3\xB3\x85\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xC7"],
        ["\xF3\xB3\x85\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xC8"],
        ["\xF3\xB3\x85\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xC9"],
        ["\xF3\xB3\x85\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xCA"],
        ["\xF3\xB3\x85\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xCB"],
        ["\xF3\xB3\x85\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xCC"],
        ["\xF3\xB3\x85\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xCD"],
        ["\xF3\xB3\x85\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xCE"],
        ["\xF3\xB3\x85\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xCF"],
        ["\xF3\xB3\x85\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xD0"],
        ["\xF3\xB3\x85\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xD1"],
        ["\xF3\xB3\x85\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xD2"],
        ["\xF3\xB3\x85\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xD3"],
        ["\xF3\xB3\x85\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xD4"],
        ["\xF3\xB3\x85\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xD5"],
        ["\xF3\xB3\x85\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xD6"],
        ["\xF3\xB3\x85\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xD7"],
        ["\xF3\xB3\x85\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xD8"],
        ["\xF3\xB3\x85\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xD9"],
        ["\xF3\xB3\x85\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xDA"],
        ["\xF3\xB3\x85\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xDB"],
        ["\xF3\xB3\x85\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xDC"],
        ["\xF3\xB3\x85\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xDD"],
        ["\xF3\xB3\x85\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xDE"],
        ["\xF3\xB3\x85\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xDF"],
        ["\xF3\xB3\x85\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xE0"],
        ["\xF3\xB3\x85\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xE1"],
        ["\xF3\xB3\x85\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xE2"],
        ["\xF3\xB3\x85\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xE3"],
        ["\xF3\xB3\x85\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xE4"],
        ["\xF3\xB3\x85\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xE5"],
        ["\xF3\xB3\x85\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xE6"],
        ["\xF3\xB3\x85\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xE7"],
        ["\xF3\xB3\x85\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xE8"],
        ["\xF3\xB3\x85\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xE9"],
        ["\xF3\xB3\x85\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xEA"],
        ["\xF3\xB3\x85\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xEB"],
        ["\xF3\xB3\x85\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xEC"],
        ["\xF3\xB3\x85\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xED"],
        ["\xF3\xB3\x85\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xEE"],
        ["\xF3\xB3\x85\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xEF"],
        ["\xF3\xB3\x85\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xF0"],
        ["\xF3\xB3\x85\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xF1"],
        ["\xF3\xB3\x85\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xFB"],
        ["\xF3\xB3\x85\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xFC"],
        ["\xF3\xB3\x86\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x5E"],
        ["\xF3\xB3\x86\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x76"],
        ["\xF3\xB3\x87\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x9D"],
        ["\xF3\xB3\x87\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x9E"],
        ["\xF3\xB3\x87\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x9F"],
        ["\xF3\xB3\x87\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA0"],
        ["\xF3\xB3\x87\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA1"],
        ["\xF3\xB3\x87\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA3"],
        ["\xF3\xB3\x87\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA4"],
        ["\xF3\xB3\x87\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA5"],
        ["\xF3\xB3\x87\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA7"],
        ["\xF3\xB3\x87\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA8"],
        ["\xF3\xB3\x87\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xAA"],
        ["\xF3\xB3\x87\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xAB"],
        ["\xF3\xB3\x87\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xAC"],
        ["\xF3\xB3\x87\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xAD"],
        ["\xF3\xB3\x87\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xAF"],
        ["\xF3\xB3\x87\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB0"],
        ["\xF3\xB3\x87\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB1"],
        ["\xF3\xB3\x87\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB2"],
        ["\xF3\xB3\x87\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB5"],
        ["\xF3\xB3\x87\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB6"],
        ["\xF3\xB3\x87\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB8"],
        ["\xF3\xB3\x87\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB9"],
        ["\xF3\xB3\x87\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xBA"],
        ["\xF3\xB3\x87\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xBB"],
        ["\xF3\xB3\x87\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xBC"],
        ["\xF3\xB3\x87\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xBD"],
        ["\xF3\xB3\x87\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xBE"],
        ["\xF3\xB3\x87\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xC0"],
        ["\xF3\xB3\x87\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xC1"],
        ["\xF3\xB3\x87\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xC3"],
        ["\xF3\xB3\x87\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xC4"],
        ["\xF3\xB3\x87\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xC5"],
        ["\xF3\xB3\x87\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xC6"],
        ["\xF3\xB3\x87\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xC7"],
        ["\xF3\xB3\x87\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xC8"],
        ["\xF3\xB3\x88\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xC9"],
        ["\xF3\xB3\x88\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xCA"],
        ["\xF3\xB3\x88\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xCB"],
        ["\xF3\xB3\x88\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xCC"],
        ["\xF3\xB3\x88\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xCE"],
        ["\xF3\xB3\x88\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xCF"],
        ["\xF3\xB3\x88\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xD0"],
        ["\xF3\xB3\x88\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xD1"],
        ["\xF3\xB3\x88\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xD3"],
        ["\xF3\xB3\x88\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xD4"],
        ["\xF3\xB3\x88\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xD5"],
        ["\xF3\xB3\x88\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xD6"],
        ["\xF3\xB3\x88\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xD7"],
        ["\xF3\xB3\x88\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xD8"],
        ["\xF3\xB3\x88\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xD9"],
        ["\xF3\xB3\x88\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xDA"],
        ["\xF3\xB3\x88\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xDC"],
        ["\xF3\xB3\x88\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xDD"],
        ["\xF3\xB3\x88\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xDE"],
        ["\xF3\xB3\x88\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xDF"],
        ["\xF3\xB3\x88\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xE0"],
        ["\xF3\xB3\x88\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xE1"],
        ["\xF3\xB3\x88\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xE2"],
        ["\xF3\xB3\x88\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xE3"],
        ["\xF3\xB3\x88\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xE4"],
        ["\xF3\xB3\x88\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xE6"],
        ["\xF3\xB3\x88\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xE7"],
        ["\xF3\xB3\x88\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xE8"],
        ["\xF3\xB3\x88\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xEB"],
        ["\xF3\xB3\x88\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xEC"],
        ["\xF3\xB3\x88\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xED"],
        ["\xF3\xB3\x88\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xEE"],
        ["\xF3\xB3\x88\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xEF"],
        ["\xF3\xB3\x88\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xF1"],
        ["\xF3\xB3\x88\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xF3"],
        ["\xF3\xB3\x88\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xF4"],
        ["\xF3\xB3\x88\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xF5"],
        ["\xF3\xB3\x88\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xF7"],
        ["\xF3\xB3\x88\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xF8"],
        ["\xF3\xB3\x88\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xF9"],
        ["\xF3\xB3\x88\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xFA"],
        ["\xF3\xB3\x88\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xFB"],
        ["\xF3\xB3\x88\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xFC"],
        ["\xF3\xB3\x88\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x41"],
        ["\xF3\xB3\x88\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x43"],
        ["\xF3\xB3\x88\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x44"],
        ["\xF3\xB3\x88\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x45"],
        ["\xF3\xB3\x88\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x46"],
        ["\xF3\xB3\x88\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x47"],
        ["\xF3\xB3\x88\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x48"],
        ["\xF3\xB3\x88\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x4A"],
        ["\xF3\xB3\x88\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x4B"],
        ["\xF3\xB3\x89\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x4C"],
        ["\xF3\xB3\x89\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x4D"],
        ["\xF3\xB3\x89\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x4E"],
        ["\xF3\xB3\x89\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x4F"],
        ["\xF3\xB3\x89\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x50"],
        ["\xF3\xB3\x89\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x51"],
        ["\xF3\xB3\x89\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x52"],
        ["\xF3\xB3\x89\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x53"],
        ["\xF3\xB3\x89\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x54"],
        ["\xF3\xB3\x89\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x55"],
        ["\xF3\xB3\x89\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x56"],
        ["\xF3\xB3\x89\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x57"],
        ["\xF3\xB3\x89\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x58"],
        ["\xF3\xB3\x89\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x59"],
        ["\xF3\xB3\x89\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x5A"],
        ["\xF3\xB3\x89\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x5B"],
        ["\xF3\xB3\x89\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x5C"],
        ["\xF3\xB3\x89\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x5D"],
        ["\xF3\xB3\x89\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x5E"],
        ["\xF3\xB3\x89\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x5F"],
        ["\xF3\xB3\x89\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x60"],
        ["\xF3\xB3\x89\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x61"],
        ["\xF3\xB3\x89\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x62"],
        ["\xF3\xB3\x89\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x63"],
        ["\xF3\xB3\x89\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x64"],
        ["\xF3\xB3\x89\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x65"],
        ["\xF3\xB3\x89\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x66"],
        ["\xF3\xB3\x89\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x67"],
        ["\xF3\xB3\x89\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x68"],
        ["\xF3\xB3\x89\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x69"],
        ["\xF3\xB3\x89\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x6B"],
        ["\xF3\xB3\x89\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x6C"],
        ["\xF3\xB3\x89\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x6F"],
        ["\xF3\xB3\x89\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x70"],
        ["\xF3\xB3\x89\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x71"],
        ["\xF3\xB3\x89\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x72"],
        ["\xF3\xB3\x89\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x73"],
        ["\xF3\xB3\x89\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x74"],
        ["\xF3\xB3\x89\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x75"],
        ["\xF3\xB3\x89\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x77"],
        ["\xF3\xB3\x89\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x78"],
        ["\xF3\xB3\x89\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x79"],
        ["\xF3\xB3\x89\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x7A"],
        ["\xF3\xB3\x89\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x7B"],
        ["\xF3\xB3\x89\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x7D"],
        ["\xF3\xB3\x89\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x7E"],
        ["\xF3\xB3\x89\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x80"],
        ["\xF3\xB3\x89\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x81"],
        ["\xF3\xB3\x89\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x82"],
        ["\xF3\xB3\x89\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x83"],
        ["\xF3\xB3\x89\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x84"],
        ["\xF3\xB3\x89\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x85"],
        ["\xF3\xB3\x89\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x86"],
        ["\xF3\xB3\x89\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x87"],
        ["\xF3\xB3\x89\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x88"],
        ["\xF3\xB3\x89\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x8A"],
        ["\xF3\xB3\x89\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x8B"],
        ["\xF3\xB3\x89\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x8C"],
        ["\xF3\xB3\x8A\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x8E"],
        ["\xF3\xB3\x8A\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x8F"],
        ["\xF3\xB3\x8A\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x90"],
        ["\xF3\xB3\x8A\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x91"],
        ["\xF3\xB3\x8A\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x92"],
        ["\xF3\xB3\x8A\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x93"],
        ["\xF3\xB3\x8A\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x94"],
        ["\xF3\xB3\x8A\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x95"],
        ["\xF3\xB3\x8A\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x96"],
        ["\xF3\xB3\x8A\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x97"],
        ["\xF3\xB3\x8A\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x98"],
        ["\xF3\xB3\x8A\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x99"],
        ["\xF3\xB3\x8A\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x9A"],
        ["\xF3\xB3\x8A\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x9B"],
        ["\xF3\xB3\x8A\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x9C"],
        ["\xF3\xB3\x8A\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x9D"],
        ["\xF3\xB3\x8A\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x9E"],
        ["\xF3\xB3\xB8\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x73"],
        ["\xF3\xB3\xB8\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x74"],
        ["\xF3\xB3\xB8\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x76"],
        ["\xF3\xB3\xB8\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x77"],
        ["\xF3\xB3\xB8\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x7A"],
        ["\xF3\xB3\xB8\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x7C"],
        ["\xF3\xB3\xB8\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x7D"],
        ["\xF3\xB3\xB8\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x7E"],
        ["\xF3\xB3\xB8\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x80"],
        ["\xF3\xB3\xB8\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x81"],
        ["\xF3\xB3\xB8\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x82"],
        ["\xF3\xB3\xB8\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x83"],
        ["\xF3\xB3\xB8\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x84"],
        ["\xF3\xB3\xB8\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x85"],
        ["\xF3\xB3\xB8\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x86"],
        ["\xF3\xB3\xB8\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x87"],
        ["\xF3\xB3\xB8\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x88"],
        ["\xF3\xB3\xB8\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x8A"],
        ["\xF3\xB3\xB8\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x8B"],
        ["\xF3\xB3\xB8\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x8C"],
        ["\xF3\xB3\xB9\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x8D"],
        ["\xF3\xB3\xB9\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x8E"],
        ["\xF3\xB3\xB9\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x8F"],
        ["\xF3\xB3\xB9\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x90"],
        ["\xF3\xB3\xB9\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x93"],
        ["\xF3\xB3\xB9\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x94"],
        ["\xF3\xB3\xB9\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x96"],
        ["\xF3\xB3\xB9\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x98"],
        ["\xF3\xB3\xB9\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x99"],
        ["\xF3\xB3\xB9\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x9A"],
        ["\xF3\xB3\xB9\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x9B"],
        ["\xF3\xB3\xB9\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x9D"],
        ["\xF3\xB3\xB9\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x9E"],
        ["\xF3\xB4\x83\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x5A"],
        ["\xF3\xB4\xAE\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],
        ["\xF3\xB4\xAE\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],
        ["\xF3\xB4\xAE\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],
        ["\xF3\xB4\xAE\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],
        ["\xF3\xB4\xAE\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],
        ["\xF3\xB4\xAE\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],
        ["\xF3\xB4\xAE\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],
        ["\xF3\xB4\xAE\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],
        ["\xF3\xB4\xAE\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],
        ["\xF3\xB4\xAE\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],
        ["\xF3\xB4\xAE\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],
        ["\xF3\xB4\xAE\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],
        ["\xF3\xB4\xAE\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],
        ["\xF3\xB4\xAE\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],
        ["\xF3\xB4\xAE\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],
        ["\xF3\xB4\xAE\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],
        ["\xF3\xB4\xAE\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],
        ["\xF3\xB4\xAE\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],
        ["\xF3\xB4\xAE\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],
        ["\xF3\xB4\xAE\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],
        ["\xF3\xB4\xAE\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],
        ["\xF3\xB4\xAE\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],
        ["\xF3\xB4\xAE\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],
        ["\xF3\xB4\xAE\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],
        ["\xF3\xB4\xAE\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],
        ["\xF3\xB4\xAE\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],
        ["\xF3\xB4\xAE\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],
        ["\xF3\xB4\xAE\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],
        ["\xF3\xB4\xAE\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],
        ["\xF3\xB4\xAE\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],
        ["\xF3\xB4\xAE\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],
        ["\xF3\xB4\xAE\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],
        ["\xF3\xB4\xAE\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],
        ["\xF3\xB4\xAE\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],
        ["\xF3\xB4\xAE\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],
        ["\xF3\xB4\xAE\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],
        ["\xF3\xB4\xAE\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],
        ["\xF3\xB4\xAE\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],
        ["\xF3\xB4\xAE\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],
        ["\xF3\xB4\xAE\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],
        ["\xF3\xB4\xAE\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],
        ["\xF3\xB4\xAE\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],
        ["\xF3\xB4\xAF\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],
        ["\xF3\xB4\xAF\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],
        ["\xF3\xB4\xAF\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],
        ["\xF3\xB4\xAF\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],
        ["\xF3\xB4\xAF\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],
        ["\xF3\xB4\xAF\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],
        ["\xF3\xB4\xAF\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],
        ["\xF3\xB4\xAF\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],
        ["\xF3\xB4\xAF\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],
        ["\xF3\xB4\xAF\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],
        ["\xF3\xB4\xAF\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],
        ["\xF3\xB4\xAF\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],
        ["\xF3\xB4\xAF\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],
        ["\xF3\xB4\xAF\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],
        ["\xF3\xB4\xAF\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],
        ["\xF3\xB4\xAF\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],
        ["\xF3\xB4\xAF\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],
        ["\xF3\xB4\xAF\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],
        ["\xF3\xB4\xAF\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],
        ["\xF3\xB4\xAF\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],
        ["\xF3\xB4\xAF\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],
        ["\xF3\xB4\xAF\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],
        ["\xF3\xB4\xAF\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],
        ["\xF3\xB4\xAF\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],
        ["\xF3\xB4\xAF\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],
        ["\xF3\xB4\xAF\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],
        ["\xF3\xB4\xAF\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],
        ["\xF3\xB4\xAF\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],
        ["\xF3\xB4\xAF\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],
        ["\xF3\xB4\xAF\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],
        ["\xF3\xB4\xAF\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],
        ["\xF3\xB4\xAF\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],
        ["\xF3\xB4\xAF\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],
        ["\xF3\xB4\xAF\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],
        ["\xF3\xB4\xAF\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],
        ["\xF3\xB4\xAF\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x40"],
        ["\xF3\xB4\xAF\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x41"],
        ["\xF3\xB4\xAF\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x42"],
        ["\xF3\xB4\xAF\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x43"],
        ["\xF3\xB4\xAF\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x44"],
        ["\xF3\xB4\xAF\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x45"],
        ["\xF3\xB4\xAF\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x46"],
        ["\xF3\xB4\xAF\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x47"],
        ["\xF3\xB4\xAF\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x48"],
        ["\xF3\xB4\xAF\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x49"],
        ["\xF3\xB4\xAF\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x4A"],
        ["\xF3\xB4\xAF\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x4F"],
        ["\xF3\xB4\xAF\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x50"],
        ["\xF3\xB4\xAF\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x52"],
        ["\xF3\xB4\xAF\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x53"],
        ["\xF3\xB4\xAF\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x55"],
        ["\xF3\xB4\xAF\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x57"],
        ["\xF3\xB4\xB0\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x58"],
        ["\xF3\xB4\xB0\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x59"],
        ["\xF3\xB4\xB0\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x5B"],
        ["\xF3\xB4\xB0\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x5C"],
        ["\xF3\xB4\xB0\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x5F"],
        ["\xF3\xB4\xB0\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x60"],
        ["\xF3\xB4\xB0\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x61"],
        ["\xF3\xB4\xB0\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x62"],
        ["\xF3\xB4\xB0\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x65"],
        ["\xF3\xB4\xB0\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x66"],
        ["\xF3\xB4\xB0\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x67"],
        ["\xF3\xB4\xB0\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x68"],
        ["\xF3\xB4\xB0\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x69"],
        ["\xF3\xB4\xB0\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x6A"],
        ["\xF3\xB4\xB0\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x6C"],
        ["\xF3\xB4\xB0\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x6E"],
        ["\xF3\xB4\xB0\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x70"],
        ["\xF3\xB4\xB0\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x71"],
        ["\xF3\xB4\xB0\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x72"],
        ["\xF3\xB4\xB0\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x73"],
        ["\xF3\xB4\xB0\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x74"],
        ["\xF3\xB4\xB0\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x75"],
        ["\xF3\xB4\xB0\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x76"],
        ["\xF3\xB4\xB0\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x78"],
        ["\xF3\xB4\xB0\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x7A"],
        ["\xF3\xB4\xB0\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x7B"],
        ["\xF3\xB4\xB0\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x7E"],
        ["\xF3\xB4\xB0\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x80"],
        ["\xF3\xB4\xB0\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x81"],
        ["\xF3\xB4\xB0\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x82"],
        ["\xF3\xB4\xB0\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x83"],
        ["\xF3\xB4\xB0\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x84"],
        ["\xF3\xB4\xB0\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x85"],
        ["\xF3\xB4\xB0\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x86"],
        ["\xF3\xB4\xB0\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x87"],
        ["\xF3\xB4\xB0\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x88"],
        ["\xF3\xB4\xB0\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x8A"],
        ["\xF3\xB4\xB0\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x8B"],
        ["\xF3\xB4\xB0\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x8C"],
        ["\xF3\xB4\xB0\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x8D"],
        ["\xF3\xB4\xB0\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x8E"],
        ["\xF3\xB4\xB0\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x8F"],
        ["\xF3\xB4\xB0\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x90"],
        ["\xF3\xB4\xB0\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x91"],
        ["\xF3\xB4\xB0\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x92"],
        ["\xF3\xB4\xB0\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x93"],
        ["\xF3\xB4\xB0\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x94"],
        ["\xF3\xB4\xB0\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x95"],
        ["\xF3\xB4\xB0\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x96"],
        ["\xF3\xB4\xB0\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x97"],
        ["\xF3\xB4\xB1\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x99"],
        ["\xF3\xB4\xB1\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x9B"],
        ["\xF3\xB4\xB1\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x9C"],
        ["\xF3\xB4\xB1\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x9D"],
        ["\xF3\xB4\xB1\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x9E"],
        ["\xF3\xB4\xB1\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\x9F"],
        ["\xF3\xB4\xB1\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],
        ["\xF3\xB4\xB1\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],
        ["\xF3\xB4\xB1\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],
        ["\xF3\xB4\xB1\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],
        ["\xF3\xB4\xB1\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],
        ["\xF3\xB4\xB1\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],
        ["\xF3\xB4\xB1\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],
        ["\xF3\xB4\xB1\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],
        ["\xF3\xB4\xB1\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],
        ["\xF3\xB4\xB1\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],
        ["\xF3\xB4\xB1\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],
        ["\xF3\xB4\xB1\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],
        ["\xF3\xB4\xB1\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],
        ["\xF3\xB4\xB1\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],
        ["\xF3\xB4\xB1\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],
        ["\xF3\xB4\xB1\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],
        ["\xF3\xB4\xB1\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],
        ["\xF3\xB4\xB1\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],
        ["\xF3\xB4\xB1\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],
        ["\xF3\xB4\xB1\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],
        ["\xF3\xB4\xB1\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],
        ["\xF3\xB4\xB1\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],
        ["\xF3\xB4\xB1\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],
        ["\xF3\xB4\xB1\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],
        ["\xF3\xB4\xB1\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],
        ["\xF3\xB4\xB1\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],
        ["\xF3\xB4\xB1\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],
        ["\xF3\xB4\xB1\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],
        ["\xF3\xB4\xB1\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],
        ["\xF3\xB4\xB1\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],
        ["\xF3\xB4\xB1\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],
        ["\xF3\xB4\xB1\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],
        ["\xF3\xB4\xB1\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],
        ["\xF3\xB4\xB1\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],
        ["\xF3\xB4\xB1\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],
        ["\xF3\xB4\xB1\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],
        ["\xF3\xB4\xB1\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],
        ["\xF3\xB4\xB1\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],
        ["\xF3\xB4\xB1\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],
        ["\xF3\xB4\xB1\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],
        ["\xF3\xB4\xB1\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],
        ["\xF3\xB4\xB1\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],
        ["\xF3\xB4\xB1\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],
        ["\xF3\xB4\xB1\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],
        ["\xF3\xB4\xB1\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],
        ["\xF3\xB4\xB1\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],
        ["\xF3\xB4\xB1\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],
        ["\xF3\xB4\xB1\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],
        ["\xF3\xB4\xB1\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],
        ["\xF3\xB4\xB1\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],
        ["\xF3\xB4\xB2\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],
        ["\xF3\xB4\xB2\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],
        ["\xF3\xB4\xB2\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],
        ["\xF3\xB4\xB2\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],
        ["\xF3\xB4\xB2\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],
        ["\xF3\xB4\xB2\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],
        ["\xF3\xB4\xB2\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],
        ["\xF3\xB4\xB2\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],
        ["\xF3\xB4\xB2\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],
        ["\xF3\xB4\xB2\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],
        ["\xF3\xB4\xB2\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],
        ["\xF3\xB4\xB2\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],
        ["\xF3\xB4\xB2\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],
        ["\xF3\xB4\xB2\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],
        ["\xF3\xB4\xB2\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],
        ["\xF3\xB4\xB2\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],
        ["\xF3\xB4\xB2\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],
        ["\xF3\xB4\xB2\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],
        ["\xF3\xB4\xB2\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],
        ["\xF3\xB4\xB2\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],
        ["\xF3\xB4\xB2\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],
        ["\xF3\xB4\xB2\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],
        ["\xF3\xB4\xB2\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],
        ["\xF3\xB4\xB2\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],
        ["\xF3\xB4\xB2\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],
        ["\xF3\xB4\xB2\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],
        ["\xF3\xB4\xB2\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],
        ["\xF3\xB4\xB2\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],
        ["\xF3\xB4\xB2\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],
        ["\xF3\xB4\xB2\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],
        ["\xF3\xB4\xB2\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],
        ["\xF3\xB4\xB2\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x40"],
        ["\xF3\xB4\xB2\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x41"],
        ["\xF3\xB4\xB2\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x42"],
        ["\xF3\xB4\xB2\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x43"],
        ["\xF3\xB4\xB2\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x44"],
        ["\xF3\xB4\xB2\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x45"],
        ["\xF3\xB4\xB2\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x46"],
        ["\xF3\xB4\xB2\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x47"],
        ["\xF3\xB4\xB2\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x48"],
        ["\xF3\xB4\xB2\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x49"],
        ["\xF3\xB4\xB2\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x4A"],
        ["\xF3\xB4\xB2\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x4B"],
        ["\xF3\xB4\xB2\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x4C"],
        ["\xF3\xB4\xB2\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x4D"],
        ["\xF3\xB4\xB2\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x4F"],
        ["\xF3\xB4\xB2\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x50"],
        ["\xF3\xB4\xB2\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x51"],
        ["\xF3\xB4\xB2\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x52"],
        ["\xF3\xB4\xB2\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x53"],
        ["\xF3\xB4\xB2\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x54"],
        ["\xF3\xB4\xB2\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x55"],
        ["\xF3\xB4\xB2\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x56"],
        ["\xF3\xB4\xB2\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x57"],
        ["\xF3\xB4\xB2\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x58"],
        ["\xF3\xB4\xB2\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x59"],
        ["\xF3\xB4\xB3\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x5C"],
        ["\xF3\xB4\xB3\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x5E"],
        ["\xF3\xB4\xB3\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x5F"],
        ["\xF3\xB4\xB3\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x60"],
        ["\xF3\xB4\xB3\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x61"],
        ["\xF3\xB4\xB3\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x62"],
        ["\xF3\xB4\xB3\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x63"],
        ["\xF3\xB4\xB3\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x65"],
        ["\xF3\xB4\xB3\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x67"],
        ["\xF3\xB4\xB3\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x68"],
        ["\xF3\xB4\xB3\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x69"],
        ["\xF3\xB4\xB3\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x6A"],
        ["\xF3\xB4\xB3\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x6C"],
        ["\xF3\xB4\xB3\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x6D"],
        ["\xF3\xB4\xB3\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x6E"],
        ["\xF3\xB4\xB3\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x6F"],
        ["\xF3\xB4\xB3\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x70"],
        ["\xF3\xB4\xB3\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x73"],
        ["\xF3\xB4\xB3\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x74"],
        ["\xF3\xB4\xB3\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x75"],
        ["\xF3\xB4\xB3\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x77"],
        ["\xF3\xB4\xB3\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x78"],
        ["\xF3\xB4\xB3\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x7A"],
        ["\xF3\xB4\xB3\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x7B"],
        ["\xF3\xB4\xB3\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x7C"],
        ["\xF3\xB4\xB3\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x7E"],
        ["\xF3\xB4\xB3\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x80"],
        ["\xF3\xB4\xB3\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x82"],
        ["\xF3\xB4\xB3\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x83"],
        ["\xF3\xB4\xB3\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x84"],
        ["\xF3\xB4\xB3\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x85"],
        ["\xF3\xB4\xB3\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x86"],
        ["\xF3\xB4\xB3\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x87"],
        ["\xF3\xB4\xB3\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x88"],
        ["\xF3\xB4\xB3\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x8A"],
        ["\xF3\xB4\xB3\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x8B"],
        ["\xF3\xB4\xB3\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x8C"],
        ["\xF3\xB4\xB3\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x8D"],
        ["\xF3\xB4\xB3\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x8E"],
        ["\xF3\xB4\xB3\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x90"],
        ["\xF3\xB4\xB3\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x91"],
        ["\xF3\xB4\xB3\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x92"],
        ["\xF3\xB4\xB3\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x93"],
        ["\xF3\xB4\xB3\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x94"],
        ["\xF3\xB4\xB3\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x95"],
        ["\xF3\xB4\xB3\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x96"],
        ["\xF3\xB4\xB3\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x97"],
        ["\xF3\xB4\xB3\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x98"],
        ["\xF3\xB4\xB3\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x9A"],
        ["\xF3\xB4\xB3\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x9C"],
        ["\xF3\xB4\xB4\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\x9E"],
        ["\xF3\xB4\xB4\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA0"],
        ["\xF3\xB4\xB4\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],
        ["\xF3\xB4\xB4\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],
        ["\xF3\xB4\xB4\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],
        ["\xF3\xB4\xB4\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],
        ["\xF3\xB4\xB4\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],
        ["\xF3\xB4\xB4\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],
        ["\xF3\xB4\xB4\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],
        ["\xF3\xB4\xB4\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],
        ["\xF3\xB4\xB4\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],
        ["\xF3\xB4\xB4\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],
        ["\xF3\xB4\xB4\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],
        ["\xF3\xB4\xB4\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],
        ["\xF3\xB4\xB4\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],
        ["\xF3\xB4\xB4\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],
        ["\xF3\xB4\xB4\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],
        ["\xF3\xB4\xB4\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],
        ["\xF3\xB4\xB4\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],
        ["\xF3\xB4\xB4\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],
        ["\xF3\xB4\xB4\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],
        ["\xF3\xB4\xB4\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],
        ["\xF3\xB4\xB4\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],
        ["\xF3\xB4\xB4\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],
        ["\xF3\xB4\xB4\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],
        ["\xF3\xB4\xB4\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],
        ["\xF3\xB4\xB4\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],
        ["\xF3\xB4\xB4\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],
        ["\xF3\xB4\xB4\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],
        ["\xF3\xB4\xB4\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],
        ["\xF3\xB4\xB4\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],
        ["\xF3\xB4\xB4\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],
        ["\xF3\xB4\xB4\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],
        ["\xF3\xB4\xB4\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],
        ["\xF3\xB4\xB4\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],
        ["\xF3\xB4\xB4\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],
        ["\xF3\xB4\xB4\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],
        ["\xF3\xB4\xB4\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],
        ["\xF3\xB4\xB4\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],
        ["\xF3\xB4\xB4\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],
        ["\xF3\xB4\xB4\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],
        ["\xF3\xB4\xB4\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],
        ["\xF3\xB4\xB4\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],
        ["\xF3\xB4\xB4\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],
        ["\xF3\xB4\xB4\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],
        ["\xF3\xB4\xB4\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],
        ["\xF3\xB4\xB4\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],
        ["\xF3\xB4\xB4\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],
        ["\xF3\xB4\xB4\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],
        ["\xF3\xB4\xB4\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],
        ["\xF3\xB4\xB4\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],
        ["\xF3\xB4\xB4\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],
        ["\xF3\xB4\xB4\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],
        ["\xF3\xB4\xB5\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],
        ["\xF3\xB4\xB5\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],
        ["\xF3\xB4\xB5\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],
        ["\xF3\xB4\xB5\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],
        ["\xF3\xB4\xB5\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],
        ["\xF3\xB4\xB5\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],
        ["\xF3\xB4\xB5\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],
        ["\xF3\xB4\xB5\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],
        ["\xF3\xB4\xB5\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],
        ["\xF3\xB4\xB5\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],
        ["\xF3\xB4\xB5\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],
        ["\xF3\xB4\xB5\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],
        ["\xF3\xB4\xB5\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],
        ["\xF3\xB4\xB5\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],
        ["\xF3\xB4\xB5\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],
        ["\xF3\xB4\xB5\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],
        ["\xF3\xB4\xB5\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],
        ["\xF3\xB4\xB5\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],
        ["\xF3\xB4\xB5\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],
        ["\xF3\xB4\xB5\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],
        ["\xF3\xB4\xB5\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],
        ["\xF3\xB4\xB5\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],
        ["\xF3\xB4\xB5\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],
        ["\xF3\xB4\xB5\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],
        ["\xF3\xB4\xB5\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],
        ["\xF3\xB4\xB5\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],
        ["\xF3\xB4\xB5\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],
        ["\xF3\xB4\xB5\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],
        ["\xF3\xB4\xB5\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x40"],
        ["\xF3\xB4\xB5\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x42"],
        ["\xF3\xB4\xB5\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x43"],
        ["\xF3\xB4\xB5\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x44"],
        ["\xF3\xB4\xB5\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x45"],
        ["\xF3\xB4\xB5\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x46"],
        ["\xF3\xB4\xB5\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x47"],
        ["\xF3\xB4\xB5\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x48"],
        ["\xF3\xB4\xB5\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x49"],
        ["\xF3\xB4\xB5\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x4A"],
        ["\xF3\xB4\xB5\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x4B"],
        ["\xF3\xB4\xB5\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x4C"],
        ["\xF3\xB4\xB5\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x4D"],
        ["\xF3\xB4\xB5\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x4E"],
        ["\xF3\xB4\xB5\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x4F"],
        ["\xF3\xB4\xB5\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x50"],
        ["\xF3\xB4\xB5\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x51"],
        ["\xF3\xB4\xB5\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x52"],
        ["\xF3\xB4\xB5\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x53"],
        ["\xF3\xB4\xB5\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x54"],
        ["\xF3\xB4\xB5\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x55"],
        ["\xF3\xB4\xB5\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x56"],
        ["\xF3\xB4\xB5\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x57"],
        ["\xF3\xB4\xB5\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x58"],
        ["\xF3\xB4\xB5\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x59"],
        ["\xF3\xB4\xB5\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x5A"],
        ["\xF3\xB4\xB5\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x5D"],
        ["\xF3\xB4\xB5\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x5E"],
        ["\xF3\xB4\xB5\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x5F"],
        ["\xF3\xB4\xB6\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x61"],
        ["\xF3\xB4\xB6\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x62"],
        ["\xF3\xB4\xB6\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x63"],
        ["\xF3\xB4\xB6\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x64"],
        ["\xF3\xB4\xB6\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x65"],
        ["\xF3\xB4\xB6\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x66"],
        ["\xF3\xB4\xB6\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x67"],
        ["\xF3\xB4\xB6\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x68"],
        ["\xF3\xB4\xB6\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x69"],
        ["\xF3\xB4\xB6\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x6A"],
        ["\xF3\xB4\xB6\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x6B"],
        ["\xF3\xB4\xB6\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x6C"],
        ["\xF3\xB4\xB6\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x6D"],
        ["\xF3\xB4\xB6\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x6E"],
        ["\xF3\xB4\xB6\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x6F"],
        ["\xF3\xB4\xB6\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x70"],
        ["\xF3\xB4\xB6\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x71"],
        ["\xF3\xB4\xB6\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x72"],
        ["\xF3\xB4\xB6\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x73"],
        ["\xF3\xB4\xB6\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x74"],
        ["\xF3\xB4\xB6\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x75"],
        ["\xF3\xB4\xB6\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x76"],
        ["\xF3\xB4\xB6\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x78"],
        ["\xF3\xB4\xB6\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x79"],
        ["\xF3\xB4\xB6\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x7A"],
        ["\xF3\xB4\xB6\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x7B"],
        ["\xF3\xB4\xB6\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x7C"],
        ["\xF3\xB4\xB6\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x7D"],
        ["\xF3\xB4\xB6\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x7E"],
        ["\xF3\xB4\xB6\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x80"],
        ["\xF3\xB4\xB6\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x81"],
        ["\xF3\xB4\xB6\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x82"],
        ["\xF3\xB4\xB6\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x84"],
        ["\xF3\xB4\xB6\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x85"],
        ["\xF3\xB4\xB6\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x86"],
        ["\xF3\xB4\xB6\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x87"],
        ["\xF3\xB4\xB6\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x88"],
        ["\xF3\xB4\xB6\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x89"],
        ["\xF3\xB4\xB6\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x8A"],
        ["\xF3\xB4\xB6\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x8B"],
        ["\xF3\xB4\xB6\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x8C"],
        ["\xF3\xB4\xB6\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x8D"],
        ["\xF3\xB4\xB6\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x8E"],
        ["\xF3\xB4\xB6\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x8F"],
        ["\xF3\xB4\xB6\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x90"],
        ["\xF3\xB4\xB6\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x91"],
        ["\xF3\xB4\xB6\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x92"],
        ["\xF3\xB4\xB6\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x93"],
        ["\xF3\xB4\xB6\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x94"],
        ["\xF3\xB4\xB6\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x95"],
        ["\xF3\xB4\xB6\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x96"],
        ["\xF3\xB4\xB6\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x97"],
        ["\xF3\xB4\xB6\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x98"],
        ["\xF3\xB4\xB6\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x99"],
        ["\xF3\xB4\xB6\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x9A"],
        ["\xF3\xB4\xB6\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x9B"],
        ["\xF3\xB4\xB6\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x9C"],
        ["\xF3\xB4\xB6\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x9D"],
        ["\xF3\xB4\xB6\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x9E"],
        ["\xF3\xB4\xB6\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\x9F"],
        ["\xF3\xB4\xB7\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],
        ["\xF3\xB4\xB7\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],
        ["\xF3\xB4\xB7\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],
        ["\xF3\xB4\xB7\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],
        ["\xF3\xB4\xB7\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],
        ["\xF3\xB4\xB7\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],
        ["\xF3\xB4\xB7\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],
        ["\xF3\xB4\xB7\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],
        ["\xF3\xB4\xB7\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],
        ["\xF3\xB4\xB7\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],
        ["\xF3\xB4\xB7\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],
        ["\xF3\xB4\xB7\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],
        ["\xF3\xB4\xB7\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],
        ["\xF3\xB4\xB7\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],
        ["\xF3\xB4\xB7\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],
        ["\xF3\xB4\xB7\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],
        ["\xF3\xB4\xB7\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],
        ["\xF3\xB4\xB7\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],
        ["\xF3\xB4\xB7\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],
        ["\xF3\xB4\xB7\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],
        ["\xF3\xB4\xB7\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],
        ["\xF3\xB4\xB7\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],
        ["\xF3\xB4\xB7\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],
        ["\xF3\xB4\xB7\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],
        ["\xF3\xB4\xB7\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],
        ["\xF3\xB4\xB7\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],
        ["\xF3\xB4\xB7\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],
        ["\xF3\xB4\xB7\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],
        ["\xF3\xB4\xB7\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],
        ["\xF3\xB4\xB7\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],
        ["\xF3\xB4\xB7\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],
        ["\xF3\xB4\xB7\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],
        ["\xF3\xB4\xB7\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],
        ["\xF3\xB4\xB7\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],
        ["\xF3\xB4\xB7\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],
        ["\xF3\xB4\xB7\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],
        ["\xF3\xB4\xB7\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],
        ["\xF3\xB4\xB7\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],
        ["\xF3\xB4\xB7\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],
        ["\xF3\xB4\xB7\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],
        ["\xF3\xB4\xB7\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],
        ["\xF3\xB4\xB7\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],
        ["\xF3\xB4\xB7\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],
        ["\xF3\xB4\xB7\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],
        ["\xF3\xB4\xB7\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],
        ["\xF3\xB4\xB7\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],
        ["\xF3\xB4\xB7\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],
        ["\xF3\xB4\xB7\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],
        ["\xF3\xB4\xB7\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],
        ["\xF3\xB4\xB7\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],
        ["\xF3\xB4\xB7\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],
        ["\xF3\xB4\xB7\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],
        ["\xF3\xB4\xB7\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],
        ["\xF3\xB4\xB7\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],
        ["\xF3\xB4\xB7\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],
        ["\xF3\xB4\xB7\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],
        ["\xF3\xB4\xB7\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],
        ["\xF3\xB4\xB7\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],
        ["\xF3\xB4\xB8\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],
        ["\xF3\xB4\xB8\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],
        ["\xF3\xB4\xB8\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],
        ["\xF3\xB4\xB8\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],
        ["\xF3\xB4\xB8\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],
        ["\xF3\xB4\xB8\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],
        ["\xF3\xB4\xB8\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],
        ["\xF3\xB4\xB8\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],
        ["\xF3\xB4\xB8\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],
        ["\xF3\xB4\xB8\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],
        ["\xF3\xB4\xB8\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],
        ["\xF3\xB4\xB8\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],
        ["\xF3\xB4\xB8\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],
        ["\xF3\xB4\xB8\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],
        ["\xF3\xB4\xB8\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],
        ["\xF3\xB4\xB8\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],
        ["\xF3\xB4\xB8\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],
        ["\xF3\xB4\xB8\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],
        ["\xF3\xB4\xB8\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],
        ["\xF3\xB4\xB8\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],
        ["\xF3\xB4\xB8\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],
        ["\xF3\xB4\xB8\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],
        ["\xF3\xB4\xB8\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],
        ["\xF3\xB4\xB8\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],
        ["\xF3\xB4\xB8\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],
        ["\xF3\xB4\xB8\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x40"],
        ["\xF3\xB4\xB8\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x41"],
        ["\xF3\xB4\xB8\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x42"],
        ["\xF3\xB4\xB8\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x43"],
        ["\xF3\xB4\xB8\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x44"],
        ["\xF3\xB4\xB8\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x45"],
        ["\xF3\xB4\xB8\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x46"],
        ["\xF3\xB4\xB8\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x48"],
        ["\xF3\xB4\xB8\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x49"],
        ["\xF3\xB4\xB8\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x4A"],
        ["\xF3\xB4\xB8\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x4B"],
        ["\xF3\xB4\xB8\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x4C"],
        ["\xF3\xB4\xB8\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x4D"],
        ["\xF3\xB4\xB8\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x4F"],
        ["\xF3\xB4\xB8\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x50"],
        ["\xF3\xB4\xB8\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x51"],
        ["\xF3\xB4\xB8\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x52"],
        ["\xF3\xB4\xB8\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x53"],
        ["\xF3\xB4\xB8\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x54"],
        ["\xF3\xB4\xB8\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x55"],
        ["\xF3\xB4\xB8\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x56"],
        ["\xF3\xB4\xB8\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x58"],
        ["\xF3\xB4\xB8\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x5A"],
        ["\xF3\xB4\xB8\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x5B"],
        ["\xF3\xB4\xB8\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x5C"],
        ["\xF3\xB4\xB8\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x5D"],
        ["\xF3\xB4\xB8\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x5E"],
        ["\xF3\xB4\xB8\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x60"],
        ["\xF3\xB4\xB8\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x61"],
        ["\xF3\xB4\xB8\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x62"],
        ["\xF3\xB4\xB8\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x63"],
        ["\xF3\xB4\xB9\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x64"],
        ["\xF3\xB4\xB9\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x65"],
        ["\xF3\xB4\xB9\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x66"],
        ["\xF3\xB4\xB9\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x67"],
        ["\xF3\xB4\xB9\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x68"],
        ["\xF3\xB4\xB9\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x69"],
        ["\xF3\xB4\xB9\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x6A"],
        ["\xF3\xB4\xB9\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x6B"],
        ["\xF3\xB4\xB9\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x6C"],
        ["\xF3\xB4\xB9\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x6D"],
        ["\xF3\xB4\xB9\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x6E"],
        ["\xF3\xB4\xB9\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x6F"],
        ["\xF3\xB4\xB9\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x70"],
        ["\xF3\xB4\xB9\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x71"],
        ["\xF3\xB4\xB9\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x72"],
        ["\xF3\xB4\xB9\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x73"],
        ["\xF3\xB4\xB9\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x74"],
        ["\xF3\xB4\xB9\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x75"],
        ["\xF3\xB4\xB9\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x76"],
        ["\xF3\xB4\xB9\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x77"],
        ["\xF3\xB4\xB9\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x78"],
        ["\xF3\xB4\xB9\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x79"],
        ["\xF3\xB4\xB9\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x7A"],
        ["\xF3\xB4\xB9\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x7B"],
        ["\xF3\xB4\xB9\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x7C"],
        ["\xF3\xB4\xB9\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x7D"],
        ["\xF3\xB4\xB9\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x7E"],
        ["\xF3\xB4\xB9\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x80"],
        ["\xF3\xB4\xB9\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x81"],
        ["\xF3\xB4\xB9\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x82"],
        ["\xF3\xB4\xB9\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x83"],
        ["\xF3\xB4\xB9\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x84"],
        ["\xF3\xB4\xB9\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x85"],
        ["\xF3\xB4\xB9\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x86"],
        ["\xF3\xB4\xB9\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x87"],
        ["\xF3\xB4\xB9\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x88"],
        ["\xF3\xB4\xB9\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x89"],
        ["\xF3\xB4\xB9\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x8A"],
        ["\xF3\xB4\xB9\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x8B"],
        ["\xF3\xB4\xB9\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x8C"],
        ["\xF3\xB4\xB9\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x8F"],
        ["\xF3\xB4\xB9\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x90"],
        ["\xF3\xB4\xB9\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x91"],
        ["\xF3\xB4\xB9\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x92"],
        ["\xF3\xB4\xB9\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x93"],
        ["\xF3\xB4\xB9\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x94"],
        ["\xF3\xB4\xB9\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x95"],
        ["\xF3\xB4\xB9\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x96"],
        ["\xF3\xB4\xB9\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x97"],
        ["\xF3\xB4\xB9\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x98"],
        ["\xF3\xB4\xB9\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x99"],
        ["\xF3\xB4\xB9\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x9A"],
        ["\xF3\xB4\xB9\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x9B"],
        ["\xF3\xB4\xB9\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x9C"],
        ["\xF3\xB4\xB9\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x9E"],
        ["\xF3\xB4\xB9\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\x9F"],
        ["\xF3\xB4\xB9\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],
        ["\xF3\xB4\xB9\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],
        ["\xF3\xB4\xB9\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],
        ["\xF3\xB4\xB9\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],
        ["\xF3\xB4\xBA\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],
        ["\xF3\xB4\xBA\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],
        ["\xF3\xB4\xBA\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],
        ["\xF3\xB4\xBA\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],
        ["\xF3\xB4\xBA\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],
        ["\xF3\xB4\xBA\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],
        ["\xF3\xB4\xBA\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],
        ["\xF3\xB4\xBA\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],
        ["\xF3\xB4\xBA\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],
        ["\xF3\xB4\xBA\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],
        ["\xF3\xB4\xBA\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],
        ["\xF3\xB4\xBA\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],
        ["\xF3\xB4\xBA\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],
        ["\xF3\xB4\xBA\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],
        ["\xF3\xB4\xBA\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],
        ["\xF3\xB4\xBA\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],
        ["\xF3\xB4\xBA\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],
        ["\xF3\xB4\xBA\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],
        ["\xF3\xB4\xBA\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],
        ["\xF3\xB4\xBA\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],
        ["\xF3\xB4\xBA\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],
        ["\xF3\xB4\xBA\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],
        ["\xF3\xB4\xBA\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],
        ["\xF3\xB4\xBA\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],
        ["\xF3\xB4\xBA\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],
        ["\xF3\xB4\xBA\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],
        ["\xF3\xB4\xBA\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],
        ["\xF3\xB4\xBA\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],
        ["\xF3\xB4\xBA\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],
        ["\xF3\xB4\xBA\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],
        ["\xF3\xB4\xBA\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],
        ["\xF3\xB4\xBA\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],
        ["\xF3\xB4\xBA\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],
        ["\xF3\xB4\xBA\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],
        ["\xF3\xB4\xBA\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],
        ["\xF3\xB4\xBA\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],
        ["\xF3\xB4\xBA\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],
        ["\xF3\xB4\xBA\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],
        ["\xF3\xB4\xBA\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],
        ["\xF3\xB4\xBA\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],
        ["\xF3\xB4\xBA\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],
        ["\xF3\xB4\xBA\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],
        ["\xF3\xB4\xBA\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],
        ["\xF3\xB4\xBA\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],
        ["\xF3\xB4\xBA\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],
        ["\xF3\xB4\xBA\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],
        ["\xF3\xB4\xBA\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],
        ["\xF3\xB4\xBA\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],
        ["\xF3\xB4\xBA\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],
        ["\xF3\xB4\xBA\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],
        ["\xF3\xB4\xBA\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],
        ["\xF3\xB4\xBA\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],
        ["\xF3\xB4\xBA\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],
        ["\xF3\xB4\xBA\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],
        ["\xF3\xB4\xBA\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],
        ["\xF3\xB4\xBA\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],
        ["\xF3\xB4\xBA\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],
        ["\xF3\xB4\xBB\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],
        ["\xF3\xB4\xBB\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],
        ["\xF3\xB4\xBB\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],
        ["\xF3\xB4\xBB\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],
        ["\xF3\xB4\xBB\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],
        ["\xF3\xB4\xBB\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],
        ["\xF3\xB4\xBB\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],
        ["\xF3\xB4\xBB\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],
        ["\xF3\xB4\xBB\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],
        ["\xF3\xB4\xBB\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],
        ["\xF3\xB4\xBB\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],
        ["\xF3\xB4\xBB\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],
        ["\xF3\xB4\xBB\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],
        ["\xF3\xB4\xBB\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],
        ["\xF3\xB4\xBB\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],
        ["\xF3\xB4\xBB\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],
        ["\xF3\xB4\xBB\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],
        ["\xF3\xB4\xBB\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],
        ["\xF3\xB4\xBB\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x42"],
        ["\xF3\xB4\xBB\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x43"],
        ["\xF3\xB4\xBB\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x45"],
        ["\xF3\xB4\xBB\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x4A"],
        ["\xF3\xB4\xBB\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x4B"],
        ["\xF3\xB4\xBB\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x4E"],
        ["\xF3\xB4\xBB\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x4F"],
        ["\xF3\xB4\xBB\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x50"],
        ["\xF3\xB4\xBB\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x54"],
        ["\xF3\xB4\xBB\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x55"],
        ["\xF3\xB4\xBB\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x59"],
        ["\xF3\xB4\xBB\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x5A"],
        ["\xF3\xB4\xBB\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x5B"],
        ["\xF3\xB4\xBB\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x5C"],
        ["\xF3\xB4\xBB\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x5D"],
        ["\xF3\xB4\xBB\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x5F"],
        ["\xF3\xB4\xBB\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x60"],
        ["\xF3\xB4\xBB\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x61"],
        ["\xF3\xB4\xBB\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x64"],
        ["\xF3\xB4\xBB\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x65"],
        ["\xF3\xB4\xBB\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x66"],
        ["\xF3\xB4\xBB\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x67"],
        ["\xF3\xB4\xBC\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x68"],
        ["\xF3\xB4\xBC\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x69"],
        ["\xF3\xB4\xBC\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x6A"],
        ["\xF3\xB4\xBC\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x6B"],
        ["\xF3\xB4\xBC\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x6C"],
        ["\xF3\xB4\xBC\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x6D"],
        ["\xF3\xB4\xBC\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x6E"],
        ["\xF3\xB4\xBC\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x6F"],
        ["\xF3\xB4\xBC\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x70"],
        ["\xF3\xB4\xBC\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x71"],
        ["\xF3\xB4\xBC\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x72"],
        ["\xF3\xB4\xBC\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x73"],
        ["\xF3\xB4\xBC\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x74"],
        ["\xF3\xB4\xBC\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x75"],
        ["\xF3\xB4\xBC\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x76"],
        ["\xF3\xB4\xBC\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x77"],
        ["\xF3\xB4\xBC\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x78"],
        ["\xF3\xB4\xBC\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x79"],
        ["\xF3\xB4\xBC\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x7A"],
        ["\xF3\xB4\xBC\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x7B"],
        ["\xF3\xB4\xBC\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x7E"],
        ["\xF3\xB4\xBC\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x80"],
        ["\xF3\xB4\xBC\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x81"],
        ["\xF3\xB4\xBC\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x82"],
        ["\xF3\xB4\xBC\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x83"],
        ["\xF3\xB4\xBC\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x84"],
        ["\xF3\xB4\xBC\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x85"],
        ["\xF3\xB4\xBC\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x89"],
        ["\xF3\xB4\xBC\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x8B"],
        ["\xF3\xB4\xBC\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x8C"],
        ["\xF3\xB4\xBC\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x8D"],
        ["\xF3\xB4\xBC\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x8E"],
        ["\xF3\xB4\xBC\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x8F"],
        ["\xF3\xB4\xBC\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x90"],
        ["\xF3\xB4\xBC\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x91"],
        ["\xF3\xB4\xBC\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x92"],
        ["\xF3\xB4\xBC\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x93"],
        ["\xF3\xB4\xBC\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x94"],
        ["\xF3\xB4\xBC\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x95"],
        ["\xF3\xB4\xBC\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x96"],
        ["\xF3\xB4\xBC\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x97"],
        ["\xF3\xB4\xBC\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x98"],
        ["\xF3\xB4\xBC\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x99"],
        ["\xF3\xB4\xBC\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x9A"],
        ["\xF3\xB4\xBC\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x9B"],
        ["\xF3\xB4\xBC\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x9C"],
        ["\xF3\xB4\xBC\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x9D"],
        ["\xF3\xB4\xBC\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\x9E"],
        ["\xF3\xB4\xBC\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA0"],
        ["\xF3\xB4\xBC\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],
        ["\xF3\xB4\xBC\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],
        ["\xF3\xB4\xBC\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],
        ["\xF3\xB4\xBC\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],
        ["\xF3\xB4\xBC\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],
        ["\xF3\xB4\xBC\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],
        ["\xF3\xB4\xBC\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],
        ["\xF3\xB4\xBD\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],
        ["\xF3\xB4\xBD\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],
        ["\xF3\xB4\xBD\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],
        ["\xF3\xB4\xBD\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],
        ["\xF3\xB4\xBD\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],
        ["\xF3\xB4\xBD\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],
        ["\xF3\xB4\xBD\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],
        ["\xF3\xB4\xBD\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],
        ["\xF3\xB4\xBD\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],
        ["\xF3\xB4\xBD\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],
        ["\xF3\xB4\xBD\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],
        ["\xF3\xB4\xBD\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],
        ["\xF3\xB4\xBD\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],
        ["\xF3\xB4\xBD\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],
        ["\xF3\xB4\xBD\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],
        ["\xF3\xB4\xBD\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],
        ["\xF3\xB4\xBD\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],
        ["\xF3\xB4\xBD\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],
        ["\xF3\xB4\xBD\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],
        ["\xF3\xB4\xBD\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],
        ["\xF3\xB4\xBD\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],
        ["\xF3\xB4\xBD\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],
        ["\xF3\xB4\xBD\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],
        ["\xF3\xB4\xBD\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],
        ["\xF3\xB4\xBD\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],
        ["\xF3\xB4\xBD\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],
        ["\xF3\xB4\xBD\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],
        ["\xF3\xB4\xBD\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],
        ["\xF3\xB4\xBD\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],
        ["\xF3\xB4\xBD\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],
        ["\xF3\xB4\xBD\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],
        ["\xF3\xB4\xBD\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],
        ["\xF3\xB4\xBD\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],
        ["\xF3\xB4\xBD\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],
        ["\xF3\xB4\xBD\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],
        ["\xF3\xB4\xBD\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],
        ["\xF3\xB4\xBD\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],
        ["\xF3\xB4\xBD\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],
        ["\xF3\xB4\xBD\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],
        ["\xF3\xB4\xBD\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],
        ["\xF3\xB4\xBD\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],
        ["\xF3\xB4\xBD\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],
        ["\xF3\xB4\xBD\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],
        ["\xF3\xB4\xBD\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],
        ["\xF3\xB4\xBD\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],
        ["\xF3\xB4\xBD\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],
        ["\xF3\xB4\xBD\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],
        ["\xF3\xB4\xBD\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],
        ["\xF3\xB4\xBD\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],
        ["\xF3\xB4\xBD\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],
        ["\xF3\xB4\xBD\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],
        ["\xF3\xB4\xBD\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],
        ["\xF3\xB4\xBD\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],
        ["\xF3\xB4\xBD\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],
        ["\xF3\xB4\xBD\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],
        ["\xF3\xB4\xBD\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],
        ["\xF3\xB4\xBD\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],
        ["\xF3\xB4\xBE\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],
        ["\xF3\xB4\xBE\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],
        ["\xF3\xB4\xBE\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],
        ["\xF3\xB4\xBE\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],
        ["\xF3\xB4\xBE\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],
        ["\xF3\xB4\xBE\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],
        ["\xF3\xB4\xBE\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],
        ["\xF3\xB4\xBE\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],
        ["\xF3\xB4\xBE\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],
        ["\xF3\xB4\xBE\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],
        ["\xF3\xB4\xBE\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],
        ["\xF3\xB4\xBE\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],
        ["\xF3\xB4\xBE\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],
        ["\xF3\xB4\xBE\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],
        ["\xF3\xB4\xBE\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],
        ["\xF3\xB4\xBE\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],
        ["\xF3\xB4\xBE\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],
        ["\xF3\xB4\xBE\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],
        ["\xF3\xB4\xBE\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],
        ["\xF3\xB4\xBE\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x40"],
        ["\xF3\xB4\xBE\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x41"],
        ["\xF3\xB4\xBE\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x42"],
        ["\xF3\xB4\xBE\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x43"],
        ["\xF3\xB4\xBE\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x44"],
        ["\xF3\xB4\xBE\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x45"],
        ["\xF3\xB4\xBE\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x46"],
        ["\xF3\xB4\xBE\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x47"],
        ["\xF3\xB4\xBE\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x48"],
        ["\xF3\xB4\xBE\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x49"],
        ["\xF3\xB4\xBE\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4A"],
        ["\xF3\xB4\xBE\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4B"],
        ["\xF3\xB4\xBE\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4C"],
        ["\xF3\xB4\xBE\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4D"],
        ["\xF3\xB4\xBE\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4E"],
        ["\xF3\xB4\xBE\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4F"],
        ["\xF3\xB4\xBE\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x50"],
        ["\xF3\xB4\xBE\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x51"],
        ["\xF3\xB4\xBE\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x52"],
        ["\xF3\xB4\xBE\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x53"],
        ["\xF3\xB4\xBE\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x54"],
        ["\xF3\xB4\xBE\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x55"],
        ["\xF3\xB4\xBE\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x56"],
        ["\xF3\xB4\xBE\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x57"],
        ["\xF3\xB4\xBE\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x58"],
        ["\xF3\xB4\xBE\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x59"],
        ["\xF3\xB4\xBE\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5A"],
        ["\xF3\xB4\xBE\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5B"],
        ["\xF3\xB4\xBE\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5C"],
        ["\xF3\xB4\xBE\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5D"],
        ["\xF3\xB4\xBE\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5F"],
        ["\xF3\xB4\xBE\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x60"],
        ["\xF3\xB4\xBE\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x61"],
        ["\xF3\xB4\xBE\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x62"],
        ["\xF3\xB4\xBE\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x63"],
        ["\xF3\xB4\xBE\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x64"],
        ["\xF3\xB4\xBE\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x65"],
        ["\xF3\xB4\xBE\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x66"],
        ["\xF3\xB4\xBE\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x67"],
        ["\xF3\xB4\xBE\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x68"],
        ["\xF3\xB4\xBE\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x69"],
        ["\xF3\xB4\xBE\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6A"],
        ["\xF3\xB4\xBE\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6B"],
        ["\xF3\xB4\xBF\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6E"],
        ["\xF3\xB4\xBF\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6F"],
        ["\xF3\xB4\xBF\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x70"],
        ["\xF3\xB4\xBF\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x71"],
        ["\xF3\xB4\xBF\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x72"],
        ["\xF3\xB4\xBF\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x73"],
        ["\xF3\xB4\xBF\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x74"],
        ["\xF3\xB4\xBF\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x75"],
        ["\xF3\xB4\xBF\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x76"],
        ["\xF3\xB4\xBF\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x77"],
        ["\xF3\xB4\xBF\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x78"],
        ["\xF3\xB4\xBF\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x79"],
        ["\xF3\xB4\xBF\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x7A"],
        ["\xF3\xB4\xBF\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x7D"],
        ["\xF3\xB4\xBF\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x81"],
        ["\xF3\xB4\xBF\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x82"],
        ["\xF3\xB4\xBF\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x83"],
        ["\xF3\xB4\xBF\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x84"],
        ["\xF3\xB4\xBF\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x85"],
        ["\xF3\xB4\xBF\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x86"],
        ["\xF3\xB4\xBF\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x88"],
        ["\xF3\xB4\xBF\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x89"],
        ["\xF3\xB4\xBF\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x8A"],
        ["\xF3\xB4\xBF\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x8B"],
        ["\xF3\xB4\xBF\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x8C"],
        ["\xF3\xB4\xBF\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x8D"],
        ["\xF3\xB4\xBF\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x8E"],
        ["\xF3\xB4\xBF\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x8F"],
        ["\xF3\xB4\xBF\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x90"],
        ["\xF3\xB4\xBF\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x91"],
        ["\xF3\xB4\xBF\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x92"],
        ["\xF3\xB4\xBF\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x93"],
        ["\xF3\xB4\xBF\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x94"],
        ["\xF3\xB4\xBF\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x95"],
        ["\xF3\xB4\xBF\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x96"],
        ["\xF3\xB4\xBF\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x97"],
        ["\xF3\xB4\xBF\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x98"],
        ["\xF3\xB4\xBF\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x99"],
        ["\xF3\xB4\xBF\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x9A"],
        ["\xF3\xB4\xBF\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x9B"],
        ["\xF3\xB4\xBF\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x9C"],
        ["\xF3\xB4\xBF\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x9D"],
        ["\xF3\xB4\xBF\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x9E"],
        ["\xF3\xB4\xBF\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x9F"],
        ["\xF3\xB4\xBF\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0"],
        ["\xF3\xB4\xBF\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],
        ["\xF3\xB4\xBF\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],
        ["\xF3\xB4\xBF\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],
        ["\xF3\xB4\xBF\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],
        ["\xF3\xB4\xBF\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],
        ["\xF3\xB4\xBF\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],
        ["\xF3\xB4\xBF\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],
        ["\xF3\xB4\xBF\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],
        ["\xF3\xB4\xBF\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],
        ["\xF3\xB4\xBF\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],
        ["\xF3\xB4\xBF\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],
        ["\xF3\xB5\x80\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],
        ["\xF3\xB5\x80\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],
        ["\xF3\xB5\x80\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],
        ["\xF3\xB5\x80\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],
        ["\xF3\xB5\x80\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],
        ["\xF3\xB5\x80\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],
        ["\xF3\xB5\x80\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],
        ["\xF3\xB5\x80\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],
        ["\xF3\xB5\x80\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],
        ["\xF3\xB5\x80\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],
        ["\xF3\xB5\x80\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],
        ["\xF3\xB5\x80\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],
        ["\xF3\xB5\x80\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],
        ["\xF3\xB5\x80\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],
        ["\xF3\xB5\x80\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],
        ["\xF3\xB5\x80\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],
        ["\xF3\xB5\x80\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],
        ["\xF3\xB5\x80\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],
        ["\xF3\xB5\x80\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],
        ["\xF3\xB5\x80\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],
        ["\xF3\xB5\x80\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],
        ["\xF3\xB5\x80\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],
        ["\xF3\xB5\x80\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],
        ["\xF3\xB5\x80\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],
        ["\xF3\xB5\x80\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],
        ["\xF3\xB5\x80\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],
        ["\xF3\xB5\x80\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],
        ["\xF3\xB5\x80\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],
        ["\xF3\xB5\x80\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],
        ["\xF3\xB5\x80\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],
        ["\xF3\xB5\x80\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],
        ["\xF3\xB5\x80\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],
        ["\xF3\xB5\x80\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],
        ["\xF3\xB5\x80\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],
        ["\xF3\xB5\x80\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],
        ["\xF3\xB5\x80\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],
        ["\xF3\xB5\x80\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],
        ["\xF3\xB5\x80\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],
        ["\xF3\xB5\x80\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],
        ["\xF3\xB5\x80\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],
        ["\xF3\xB5\x80\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],
        ["\xF3\xB5\x80\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],
        ["\xF3\xB5\x80\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],
        ["\xF3\xB5\x80\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],
        ["\xF3\xB5\x80\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],
        ["\xF3\xB5\x80\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],
        ["\xF3\xB5\x80\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],
        ["\xF3\xB5\x80\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],
        ["\xF3\xB5\x80\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],
        ["\xF3\xB5\x80\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],
        ["\xF3\xB5\x80\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],
        ["\xF3\xB5\x80\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],
        ["\xF3\xB5\x80\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],
        ["\xF3\xB5\x80\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],
        ["\xF3\xB5\x80\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],
        ["\xF3\xB5\x80\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],
        ["\xF3\xB5\x80\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],
        ["\xF3\xB5\x80\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],
        ["\xF3\xB5\x80\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],
        ["\xF3\xB5\x80\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],
        ["\xF3\xB5\x80\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],
        ["\xF3\xB5\x81\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],
        ["\xF3\xB5\x81\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],
        ["\xF3\xB5\x81\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],
        ["\xF3\xB5\x81\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],
        ["\xF3\xB5\x81\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],
        ["\xF3\xB5\x81\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],
        ["\xF3\xB5\x81\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],
        ["\xF3\xB5\x81\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],
        ["\xF3\xB5\x81\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],
        ["\xF3\xB5\x81\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],
        ["\xF3\xB5\x81\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],
        ["\xF3\xB5\x81\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],
        ["\xF3\xB5\x81\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],
        ["\xF3\xB5\x81\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],
        ["\xF3\xB5\x81\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],
        ["\xF3\xB5\x81\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],
        ["\xF3\xB5\x81\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x40"],
        ["\xF3\xB5\x81\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x41"],
        ["\xF3\xB5\x81\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x42"],
        ["\xF3\xB5\x81\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x43"],
        ["\xF3\xB5\x81\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x44"],
        ["\xF3\xB5\x81\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x45"],
        ["\xF3\xB5\x81\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x46"],
        ["\xF3\xB5\x81\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x47"],
        ["\xF3\xB5\x81\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x48"],
        ["\xF3\xB5\x81\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x49"],
        ["\xF3\xB5\x81\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4A"],
        ["\xF3\xB5\x81\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4B"],
        ["\xF3\xB5\x81\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4C"],
        ["\xF3\xB5\x81\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4D"],
        ["\xF3\xB5\x81\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4E"],
        ["\xF3\xB5\x81\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4F"],
        ["\xF3\xB5\x81\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x50"],
        ["\xF3\xB5\x81\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x51"],
        ["\xF3\xB5\x81\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x52"],
        ["\xF3\xB5\x81\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x53"],
        ["\xF3\xB5\x81\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x54"],
        ["\xF3\xB5\x81\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x55"],
        ["\xF3\xB5\x81\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x56"],
        ["\xF3\xB5\x81\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x57"],
        ["\xF3\xB5\x81\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x58"],
        ["\xF3\xB5\x81\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x59"],
        ["\xF3\xB5\x81\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5A"],
        ["\xF3\xB5\x81\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5B"],
        ["\xF3\xB5\x81\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5C"],
        ["\xF3\xB5\x81\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5D"],
        ["\xF3\xB5\x81\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5E"],
        ["\xF3\xB5\x81\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5F"],
        ["\xF3\xB5\x81\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x60"],
        ["\xF3\xB5\x81\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x61"],
        ["\xF3\xB5\x81\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x64"],
        ["\xF3\xB5\x81\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x65"],
        ["\xF3\xB5\x81\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x66"],
        ["\xF3\xB5\x81\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x67"],
        ["\xF3\xB5\x81\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x68"],
        ["\xF3\xB5\x81\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x69"],
        ["\xF3\xB5\x81\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6A"],
        ["\xF3\xB5\x81\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6B"],
        ["\xF3\xB5\x81\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6C"],
        ["\xF3\xB5\x81\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6E"],
        ["\xF3\xB5\x81\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6F"],
        ["\xF3\xB5\x82\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x70"],
        ["\xF3\xB5\x82\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x71"],
        ["\xF3\xB5\x82\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x72"],
        ["\xF3\xB5\x82\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x73"],
        ["\xF3\xB5\x82\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x74"],
        ["\xF3\xB5\x82\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x75"],
        ["\xF3\xB5\x82\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x76"],
        ["\xF3\xB5\x82\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x77"],
        ["\xF3\xB5\x82\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x78"],
        ["\xF3\xB5\x82\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x79"],
        ["\xF3\xB5\x82\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x7A"],
        ["\xF3\xB5\x82\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x7B"],
        ["\xF3\xB5\x82\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x7C"],
        ["\xF3\xB5\x82\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x7D"],
        ["\xF3\xB5\x82\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x7E"],
        ["\xF3\xB5\x82\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x80"],
        ["\xF3\xB5\x82\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x81"],
        ["\xF3\xB5\x82\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x82"],
        ["\xF3\xB5\x82\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x83"],
        ["\xF3\xB5\x82\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x84"],
        ["\xF3\xB5\x82\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x85"],
        ["\xF3\xB5\x82\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x86"],
        ["\xF3\xB5\x82\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x87"],
        ["\xF3\xB5\x82\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x88"],
        ["\xF3\xB5\x82\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x89"],
        ["\xF3\xB5\x82\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x8A"],
        ["\xF3\xB5\x82\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x8B"],
        ["\xF3\xB5\x82\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x8D"],
        ["\xF3\xB5\x82\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x8E"],
        ["\xF3\xB5\x82\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x8F"],
        ["\xF3\xB5\x82\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x90"],
        ["\xF3\xB5\x82\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x91"],
        ["\xF3\xB5\x82\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x92"],
        ["\xF3\xB5\x82\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x93"],
        ["\xF3\xB5\x82\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x94"],
        ["\xF3\xB5\x82\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x95"],
        ["\xF3\xB5\x82\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x96"],
        ["\xF3\xB5\x82\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x97"],
        ["\xF3\xB5\x82\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x98"],
        ["\xF3\xB5\x82\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x99"],
        ["\xF3\xB5\x82\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x9A"],
        ["\xF3\xB5\x82\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x9B"],
        ["\xF3\xB5\x82\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x9C"],
        ["\xF3\xB5\x82\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x9D"],
        ["\xF3\xB5\x82\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x9E"],
        ["\xF3\xB5\x82\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x9F"],
        ["\xF3\xB5\x82\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA0"],
        ["\xF3\xB5\x82\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],
        ["\xF3\xB5\x82\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],
        ["\xF3\xB5\x82\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],
        ["\xF3\xB5\x82\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],
        ["\xF3\xB5\x82\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],
        ["\xF3\xB5\x82\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],
        ["\xF3\xB5\x82\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],
        ["\xF3\xB5\x82\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],
        ["\xF3\xB5\x82\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],
        ["\xF3\xB5\x82\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],
        ["\xF3\xB5\x82\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],
        ["\xF3\xB5\x82\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],
        ["\xF3\xB5\x82\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],
        ["\xF3\xB5\x82\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],
        ["\xF3\xB5\x82\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],
        ["\xF3\xB5\x82\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],
        ["\xF3\xB5\x83\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],
        ["\xF3\xB5\x83\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],
        ["\xF3\xB5\x83\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],
        ["\xF3\xB5\x83\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],
        ["\xF3\xB5\x83\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],
        ["\xF3\xB5\x83\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],
        ["\xF3\xB5\x83\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],
        ["\xF3\xB5\x83\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],
        ["\xF3\xB5\x83\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],
        ["\xF3\xB5\x83\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],
        ["\xF3\xB5\x83\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],
        ["\xF3\xB5\x83\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],
        ["\xF3\xB5\x83\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],
        ["\xF3\xB5\x83\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],
        ["\xF3\xB5\x83\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],
        ["\xF3\xB5\x83\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],
        ["\xF3\xB5\x83\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],
        ["\xF3\xB5\x83\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],
        ["\xF3\xB5\x83\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],
        ["\xF3\xB5\x83\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],
        ["\xF3\xB5\x83\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],
        ["\xF3\xB5\x83\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],
        ["\xF3\xB5\x83\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],
        ["\xF3\xB5\x83\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],
        ["\xF3\xB5\x83\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],
        ["\xF3\xB5\x83\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],
        ["\xF3\xB5\x83\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],
        ["\xF3\xB5\x83\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],
        ["\xF3\xB5\x83\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],
        ["\xF3\xB5\x83\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],
        ["\xF3\xB5\x83\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],
        ["\xF3\xB5\x83\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],
        ["\xF3\xB5\x83\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],
        ["\xF3\xB5\x83\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],
        ["\xF3\xB5\x83\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],
        ["\xF3\xB5\x83\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],
        ["\xF3\xB5\x83\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],
        ["\xF3\xB5\x83\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],
        ["\xF3\xB5\x83\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],
        ["\xF3\xB5\x83\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],
        ["\xF3\xB5\x83\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],
        ["\xF3\xB5\x83\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],
        ["\xF3\xB5\x83\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],
        ["\xF3\xB5\x83\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],
        ["\xF3\xB5\x83\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],
        ["\xF3\xB5\x83\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],
        ["\xF3\xB5\x83\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],
        ["\xF3\xB5\x83\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],
        ["\xF3\xB5\x83\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],
        ["\xF3\xB5\x83\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],
        ["\xF3\xB5\x83\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],
        ["\xF3\xB5\x83\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],
        ["\xF3\xB5\x83\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],
        ["\xF3\xB5\x83\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],
        ["\xF3\xB5\x83\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],
        ["\xF3\xB5\x83\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],
        ["\xF3\xB5\x83\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],
        ["\xF3\xB5\x83\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],
        ["\xF3\xB5\x83\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],
        ["\xF3\xB5\x83\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],
        ["\xF3\xB5\x83\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],
        ["\xF3\xB5\x83\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],
        ["\xF3\xB5\x83\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],
        ["\xF3\xB5\x84\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],
        ["\xF3\xB5\x84\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],
        ["\xF3\xB5\x84\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],
        ["\xF3\xB5\x84\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],
        ["\xF3\xB5\x84\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],
        ["\xF3\xB5\x84\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],
        ["\xF3\xB5\x84\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],
        ["\xF3\xB5\x84\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],
        ["\xF3\xB5\x84\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],
        ["\xF3\xB5\x84\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],
        ["\xF3\xB5\x84\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],
        ["\xF3\xB5\x84\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],
        ["\xF3\xB5\x84\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x40"],
        ["\xF3\xB5\x84\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x41"],
        ["\xF3\xB5\x84\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x42"],
        ["\xF3\xB5\x84\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x43"],
        ["\xF3\xB5\x84\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x44"],
        ["\xF3\xB5\x84\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x45"],
        ["\xF3\xB5\x84\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x46"],
        ["\xF3\xB5\x84\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x47"],
        ["\xF3\xB5\x84\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x48"],
        ["\xF3\xB5\x84\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x49"],
        ["\xF3\xB5\x84\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4A"],
        ["\xF3\xB5\x84\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4B"],
        ["\xF3\xB5\x84\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4C"],
        ["\xF3\xB5\x84\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4D"],
        ["\xF3\xB5\x84\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4E"],
        ["\xF3\xB5\x84\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4F"],
        ["\xF3\xB5\x84\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x50"],
        ["\xF3\xB5\x84\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x51"],
        ["\xF3\xB5\x84\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x52"],
        ["\xF3\xB5\x84\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x53"],
        ["\xF3\xB5\x84\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x54"],
        ["\xF3\xB5\x84\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x55"],
        ["\xF3\xB5\x84\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x56"],
        ["\xF3\xB5\x84\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x57"],
        ["\xF3\xB5\x84\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x58"],
        ["\xF3\xB5\x84\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5A"],
        ["\xF3\xB5\x84\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5B"],
        ["\xF3\xB5\x84\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5C"],
        ["\xF3\xB5\x84\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5D"],
        ["\xF3\xB5\x84\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5E"],
        ["\xF3\xB5\x84\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5F"],
        ["\xF3\xB5\x84\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x60"],
        ["\xF3\xB5\x84\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x61"],
        ["\xF3\xB5\x84\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x62"],
        ["\xF3\xB5\x84\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x63"],
        ["\xF3\xB5\x84\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x65"],
        ["\xF3\xB5\x84\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x66"],
        ["\xF3\xB5\x84\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x67"],
        ["\xF3\xB5\x84\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x68"],
        ["\xF3\xB5\x84\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x69"],
        ["\xF3\xB5\x84\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6A"],
        ["\xF3\xB5\x84\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6B"],
        ["\xF3\xB5\x84\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6C"],
        ["\xF3\xB5\x84\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6D"],
        ["\xF3\xB5\x84\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6E"],
        ["\xF3\xB5\x84\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6F"],
        ["\xF3\xB5\x84\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x70"],
        ["\xF3\xB5\x84\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x71"],
        ["\xF3\xB5\x84\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x72"],
        ["\xF3\xB5\x84\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x73"],
        ["\xF3\xB5\x85\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x74"],
        ["\xF3\xB5\x85\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x75"],
        ["\xF3\xB5\x85\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x76"],
        ["\xF3\xB5\x85\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x77"],
        ["\xF3\xB5\x85\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x78"],
        ["\xF3\xB5\x85\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x79"],
        ["\xF3\xB5\x85\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x7A"],
        ["\xF3\xB5\x85\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x7B"],
        ["\xF3\xB5\x85\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x7C"],
        ["\xF3\xB5\x85\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x7D"],
        ["\xF3\xB5\x85\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x7E"],
        ["\xF3\xB5\x85\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x80"],
        ["\xF3\xB5\x85\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x81"],
        ["\xF3\xB5\x85\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x82"],
        ["\xF3\xB5\x85\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x83"],
        ["\xF3\xB5\x85\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x84"],
        ["\xF3\xB5\x85\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x85"],
        ["\xF3\xB5\x85\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x86"],
        ["\xF3\xB5\x85\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x87"],
        ["\xF3\xB5\x85\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x88"],
        ["\xF3\xB5\x85\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x89"],
        ["\xF3\xB5\x85\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x8A"],
        ["\xF3\xB5\x85\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x8B"],
        ["\xF3\xB5\x85\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x8C"],
        ["\xF3\xB5\x85\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x8D"],
        ["\xF3\xB5\x85\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x8E"],
        ["\xF3\xB5\x85\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x8F"],
        ["\xF3\xB5\x85\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x90"],
        ["\xF3\xB5\x85\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x91"],
        ["\xF3\xB5\x85\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x92"],
        ["\xF3\xB5\x85\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x93"],
        ["\xF3\xB5\x85\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x94"],
        ["\xF3\xB5\x85\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x95"],
        ["\xF3\xB5\x85\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x96"],
        ["\xF3\xB5\x85\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x97"],
        ["\xF3\xB5\x85\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x98"],
        ["\xF3\xB5\x85\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x99"],
        ["\xF3\xB5\x85\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x9A"],
        ["\xF3\xB5\x85\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x9B"],
        ["\xF3\xB5\x85\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x9C"],
        ["\xF3\xB5\x85\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x9D"],
        ["\xF3\xB5\x85\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x9E"],
        ["\xF3\xB5\x85\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x9F"],
        ["\xF3\xB5\x85\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA0"],
        ["\xF3\xB5\x85\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],
        ["\xF3\xB5\x85\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],
        ["\xF3\xB5\x85\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],
        ["\xF3\xB5\x85\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],
        ["\xF3\xB5\x85\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],
        ["\xF3\xB5\x85\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],
        ["\xF3\xB5\x85\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],
        ["\xF3\xB5\x85\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],
        ["\xF3\xB5\x85\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],
        ["\xF3\xB5\x85\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],
        ["\xF3\xB5\x85\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],
        ["\xF3\xB5\x85\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],
        ["\xF3\xB5\x85\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],
        ["\xF3\xB5\x85\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],
        ["\xF3\xB5\x85\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],
        ["\xF3\xB5\x85\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],
        ["\xF3\xB5\x85\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],
        ["\xF3\xB5\x85\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],
        ["\xF3\xB5\x85\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],
        ["\xF3\xB5\x85\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],
        ["\xF3\xB5\x86\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],
        ["\xF3\xB5\x86\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],
        ["\xF3\xB5\x86\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],
        ["\xF3\xB5\x86\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],
        ["\xF3\xB5\x86\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],
        ["\xF3\xB5\x86\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],
        ["\xF3\xB5\x86\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],
        ["\xF3\xB5\x86\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],
        ["\xF3\xB5\x86\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],
        ["\xF3\xB5\x86\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],
        ["\xF3\xB5\x86\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],
        ["\xF3\xB5\x86\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],
        ["\xF3\xB5\x86\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],
        ["\xF3\xB5\x86\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],
        ["\xF3\xB5\x86\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],
        ["\xF3\xB5\x86\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],
        ["\xF3\xB5\x86\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],
        ["\xF3\xB5\x86\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],
        ["\xF3\xB5\x86\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],
        ["\xF3\xB5\x86\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],
        ["\xF3\xB5\x86\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],
        ["\xF3\xB5\x86\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],
        ["\xF3\xB5\x86\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCC"],
        ["\xF3\xB5\x86\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],
        ["\xF3\xB5\x86\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCE"],
        ["\xF3\xB5\x86\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCF"],
        ["\xF3\xB5\x86\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],
        ["\xF3\xB5\x86\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],
        ["\xF3\xB5\x86\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],
        ["\xF3\xB5\x86\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],
        ["\xF3\xB5\x86\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],
        ["\xF3\xB5\x86\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],
        ["\xF3\xB5\x86\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],
        ["\xF3\xB5\x86\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],
        ["\xF3\xB5\x86\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],
        ["\xF3\xB5\x86\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDA"],
        ["\xF3\xB5\x86\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDB"],
        ["\xF3\xB5\x86\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDC"],
        ["\xF3\xB5\x86\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDD"],
        ["\xF3\xB5\x86\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDE"],
        ["\xF3\xB5\x86\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xDF"],
        ["\xF3\xB5\x86\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],
        ["\xF3\xB5\x86\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE1"],
        ["\xF3\xB5\x86\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],
        ["\xF3\xB5\x86\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],
        ["\xF3\xB5\x86\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],
        ["\xF3\xB5\x86\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],
        ["\xF3\xB5\x86\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],
        ["\xF3\xB5\x86\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],
        ["\xF3\xB5\x86\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],
        ["\xF3\xB5\x86\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xEA"],
        ["\xF3\xB5\x86\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xEB"],
        ["\xF3\xB5\x86\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xEC"],
        ["\xF3\xB5\x86\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xED"],
        ["\xF3\xB5\x86\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xEE"],
        ["\xF3\xB5\x86\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xEF"],
        ["\xF3\xB5\x86\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],
        ["\xF3\xB5\x86\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],
        ["\xF3\xB5\x86\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],
        ["\xF3\xB5\x86\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],
        ["\xF3\xB5\x86\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],
        ["\xF3\xB5\x87\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],
        ["\xF3\xB5\x87\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],
        ["\xF3\xB5\x87\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],
        ["\xF3\xB5\x87\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],
        ["\xF3\xB5\x87\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],
        ["\xF3\xB5\x87\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xFA"],
        ["\xF3\xB5\x87\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xFB"],
        ["\xF3\xB5\x87\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xFC"],
        ["\xF3\xB5\x87\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x40"],
        ["\xF3\xB5\x87\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x42"],
        ["\xF3\xB5\x87\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x43"],
        ["\xF3\xB5\x87\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x44"],
        ["\xF3\xB5\x87\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x45"],
        ["\xF3\xB5\x87\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x46"],
        ["\xF3\xB5\x87\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x47"],
        ["\xF3\xB5\x87\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x48"],
        ["\xF3\xB5\x87\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x49"],
        ["\xF3\xB5\x87\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4A"],
        ["\xF3\xB5\x87\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4B"],
        ["\xF3\xB5\x87\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4C"],
        ["\xF3\xB5\x87\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4D"],
        ["\xF3\xB5\x87\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4E"],
        ["\xF3\xB5\x87\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4F"],
        ["\xF3\xB5\x87\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x50"],
        ["\xF3\xB5\x87\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x51"],
        ["\xF3\xB5\x87\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x52"],
        ["\xF3\xB5\x87\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x53"],
        ["\xF3\xB5\x87\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x54"],
        ["\xF3\xB5\x87\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x55"],
        ["\xF3\xB5\x87\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x56"],
        ["\xF3\xB5\x87\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x57"],
        ["\xF3\xB5\x87\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x58"],
        ["\xF3\xB5\x87\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x59"],
        ["\xF3\xB5\x87\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5A"],
        ["\xF3\xB5\x87\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5B"],
        ["\xF3\xB5\x87\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5C"],
        ["\xF3\xB5\x87\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5D"],
        ["\xF3\xB5\x87\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5E"],
        ["\xF3\xB5\x87\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5F"],
        ["\xF3\xB5\x87\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x60"],
        ["\xF3\xB5\x87\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x61"],
        ["\xF3\xB5\x87\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x62"],
        ["\xF3\xB5\x87\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x63"],
        ["\xF3\xB5\x87\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x64"],
        ["\xF3\xB5\x87\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x65"],
        ["\xF3\xB5\x87\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x66"],
        ["\xF3\xB5\x87\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x67"],
        ["\xF3\xB5\x87\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x68"],
        ["\xF3\xB5\x87\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x69"],
        ["\xF3\xB5\x87\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6A"],
        ["\xF3\xB5\x87\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6B"],
        ["\xF3\xB5\x87\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6C"],
        ["\xF3\xB5\x87\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6D"],
        ["\xF3\xB5\x87\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6E"],
        ["\xF3\xB5\x87\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x70"],
        ["\xF3\xB5\x87\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x71"],
        ["\xF3\xB5\x87\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x72"],
        ["\xF3\xB5\x87\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x73"],
        ["\xF3\xB5\x87\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x74"],
        ["\xF3\xB5\x87\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x75"],
        ["\xF3\xB5\x87\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x76"],
        ["\xF3\xB5\x87\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x77"],
        ["\xF3\xB5\x88\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x78"],
        ["\xF3\xB5\x88\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x79"],
        ["\xF3\xB5\x88\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x7A"],
        ["\xF3\xB5\x88\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x7B"],
        ["\xF3\xB5\x88\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x7C"],
        ["\xF3\xB5\x88\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x7D"],
        ["\xF3\xB5\x88\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x7E"],
        ["\xF3\xB5\x88\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x80"],
        ["\xF3\xB5\x88\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x81"],
        ["\xF3\xB5\x88\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x82"],
        ["\xF3\xB5\x88\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x83"],
        ["\xF3\xB5\x88\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x84"],
        ["\xF3\xB5\x88\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x85"],
        ["\xF3\xB5\x88\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x86"],
        ["\xF3\xB5\x88\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x87"],
        ["\xF3\xB5\x88\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x88"],
        ["\xF3\xB5\x88\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x89"],
        ["\xF3\xB5\x88\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x8A"],
        ["\xF3\xB5\x88\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x8B"],
        ["\xF3\xB5\x88\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x8C"],
        ["\xF3\xB5\x88\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x8D"],
        ["\xF3\xB5\x88\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x8E"],
        ["\xF3\xB5\x88\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x8F"],
        ["\xF3\xB5\x88\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x90"],
        ["\xF3\xB5\x88\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x91"],
        ["\xF3\xB5\x88\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x92"],
        ["\xF3\xB5\x88\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x93"],
        ["\xF3\xB5\x88\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x94"],
        ["\xF3\xB5\x88\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x95"],
        ["\xF3\xB5\x88\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x96"],
        ["\xF3\xB5\x88\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x97"],
        ["\xF3\xB5\x88\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x98"],
        ["\xF3\xB5\x88\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x99"],
        ["\xF3\xB5\x88\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x9A"],
        ["\xF3\xB5\x88\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x9B"],
        ["\xF3\xB5\x88\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x9C"],
        ["\xF3\xB5\x88\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x9D"],
        ["\xF3\xB5\x88\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x9F"],
        ["\xF3\xB5\x88\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA0"],
        ["\xF3\xB5\x88\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],
        ["\xF3\xB5\x88\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA2"],
        ["\xF3\xB5\x88\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA3"],
        ["\xF3\xB5\x88\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA4"],
        ["\xF3\xB5\x88\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA5"],
        ["\xF3\xB5\x88\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA6"],
        ["\xF3\xB5\x88\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA7"],
        ["\xF3\xB5\x88\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA8"],
        ["\xF3\xB5\x88\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA9"],
        ["\xF3\xB5\x88\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAA"],
        ["\xF3\xB5\x88\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAC"],
        ["\xF3\xB5\x88\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAD"],
        ["\xF3\xB5\x88\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAE"],
        ["\xF3\xB5\x88\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAF"],
        ["\xF3\xB5\x88\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],
        ["\xF3\xB5\x88\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2"],
        ["\xF3\xB5\x88\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3"],
        ["\xF3\xB5\x88\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4"],
        ["\xF3\xB5\x88\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5"],
        ["\xF3\xB5\x88\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB6"],
        ["\xF3\xB5\x88\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB7"],
        ["\xF3\xB5\x88\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB8"],
        ["\xF3\xB5\x89\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB9"],
        ["\xF3\xB5\x89\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBA"],
        ["\xF3\xB5\x89\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBB"],
        ["\xF3\xB5\x89\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBC"],
        ["\xF3\xB5\x89\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBD"],
        ["\xF3\xB5\x89\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBE"],
        ["\xF3\xB5\x89\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xBF"],
        ["\xF3\xB5\x89\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],
        ["\xF3\xB5\x89\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],
        ["\xF3\xB5\x89\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],
        ["\xF3\xB5\x89\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],
        ["\xF3\xB5\x89\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],
        ["\xF3\xB5\x89\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],
        ["\xF3\xB5\x89\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],
        ["\xF3\xB5\x89\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],
        ["\xF3\xB5\x89\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],
        ["\xF3\xB5\x89\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],
        ["\xF3\xB5\x89\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCA"],
        ["\xF3\xB5\x89\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCB"],
        ["\xF3\xB5\x89\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCC"],
        ["\xF3\xB5\x89\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCD"],
        ["\xF3\xB5\x89\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCE"],
        ["\xF3\xB5\x89\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xCF"],
        ["\xF3\xB5\x89\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],
        ["\xF3\xB5\x89\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],
        ["\xF3\xB5\x89\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],
        ["\xF3\xB5\x89\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],
        ["\xF3\xB5\x89\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],
        ["\xF3\xB5\x89\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],
        ["\xF3\xB5\x89\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],
        ["\xF3\xB5\x89\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],
        ["\xF3\xB5\x89\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],
        ["\xF3\xB5\x89\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],
        ["\xF3\xB5\x89\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDA"],
        ["\xF3\xB5\x89\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDB"],
        ["\xF3\xB5\x89\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDC"],
        ["\xF3\xB5\x89\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDE"],
        ["\xF3\xB5\x89\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xDF"],
        ["\xF3\xB5\x89\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],
        ["\xF3\xB5\x89\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE1"],
        ["\xF3\xB5\x89\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],
        ["\xF3\xB5\x89\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],
        ["\xF3\xB5\x89\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],
        ["\xF3\xB5\x89\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],
        ["\xF3\xB5\x89\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],
        ["\xF3\xB5\x89\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],
        ["\xF3\xB5\x89\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],
        ["\xF3\xB5\x89\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],
        ["\xF3\xB5\x89\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xEA"],
        ["\xF3\xB5\x89\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xEB"],
        ["\xF3\xB5\x89\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xEC"],
        ["\xF3\xB5\x89\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xED"],
        ["\xF3\xB5\x89\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xEE"],
        ["\xF3\xB5\x89\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xEF"],
        ["\xF3\xB5\x89\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],
        ["\xF3\xB5\x89\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],
        ["\xF3\xB5\x89\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],
        ["\xF3\xB5\x89\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],
        ["\xF3\xB5\x89\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],
        ["\xF3\xB5\x89\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],
        ["\xF3\xB5\x89\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],
        ["\xF3\xB5\x89\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],
        ["\xF3\xB5\x8A\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],
        ["\xF3\xB5\x8A\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xFA"],
        ["\xF3\xB5\x8A\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xFC"],
        ["\xF3\xB5\x8A\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x40"],
        ["\xF3\xB5\x8A\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x41"],
        ["\xF3\xB5\x8A\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x42"],
        ["\xF3\xB5\x8A\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x43"],
        ["\xF3\xB5\x8A\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x44"],
        ["\xF3\xB5\x8A\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x45"],
        ["\xF3\xB5\x8A\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x46"],
        ["\xF3\xB5\x8A\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x47"],
        ["\xF3\xB5\x8A\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x48"],
        ["\xF3\xB5\x8A\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x49"],
        ["\xF3\xB5\x8A\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4A"],
        ["\xF3\xB5\x8A\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4B"],
        ["\xF3\xB5\x8A\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4C"],
        ["\xF3\xB5\x8A\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4D"],
        ["\xF3\xB5\x8A\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4E"],
        ["\xF3\xB5\x8A\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4F"],
        ["\xF3\xB5\x8A\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x50"],
        ["\xF3\xB5\x8A\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x51"],
        ["\xF3\xB5\x8A\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x52"],
        ["\xF3\xB5\x8A\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x53"],
        ["\xF3\xB5\x8A\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x54"],
        ["\xF3\xB5\x8A\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x56"],
        ["\xF3\xB5\x8A\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x57"],
        ["\xF3\xB5\x8A\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x58"],
        ["\xF3\xB5\x8A\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x59"],
        ["\xF3\xB5\x8A\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5A"],
        ["\xF3\xB5\x8A\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5B"],
        ["\xF3\xB5\x8A\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5C"],
        ["\xF3\xB5\x8A\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5D"],
        ["\xF3\xB5\x8A\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5E"],
        ["\xF3\xB5\x8A\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5F"],
        ["\xF3\xB5\x8A\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x61"],
        ["\xF3\xB5\x8A\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x62"],
        ["\xF3\xB5\x8A\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x63"],
        ["\xF3\xB5\x8A\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x64"],
        ["\xF3\xB5\x8A\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x65"],
        ["\xF3\xB5\x8A\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x66"],
        ["\xF3\xB5\x8A\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x67"],
        ["\xF3\xB5\x8A\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x68"],
        ["\xF3\xB5\x8A\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x69"],
        ["\xF3\xB5\x8A\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6A"],
        ["\xF3\xB5\x8A\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6B"],
        ["\xF3\xB5\x8A\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6C"],
        ["\xF3\xB5\x8A\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6D"],
        ["\xF3\xB5\x8A\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6E"],
        ["\xF3\xB5\x8A\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6F"],
        ["\xF3\xB5\x8A\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x70"],
        ["\xF3\xB5\x8A\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x71"],
        ["\xF3\xB5\x8A\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x73"],
        ["\xF3\xB5\x8A\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x74"],
        ["\xF3\xB5\x8A\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x75"],
        ["\xF3\xB5\x8A\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x76"],
        ["\xF3\xB5\x8A\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x77"],
        ["\xF3\xB5\x8A\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x78"],
        ["\xF3\xB5\x8A\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x7A"],
        ["\xF3\xB5\x8A\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x7B"],
        ["\xF3\xB5\x8B\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x7C"],
        ["\xF3\xB5\x8B\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x7D"],
        ["\xF3\xB5\x8B\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x7E"],
        ["\xF3\xB5\x8B\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x80"],
        ["\xF3\xB5\x8B\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x81"],
        ["\xF3\xB5\x8B\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x82"],
        ["\xF3\xB5\x8B\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x83"],
        ["\xF3\xB5\x8B\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x84"],
        ["\xF3\xB5\x8B\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x85"],
        ["\xF3\xB5\x8B\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x86"],
        ["\xF3\xB5\x8B\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x87"],
        ["\xF3\xB5\x8B\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x88"],
        ["\xF3\xB5\x8B\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x89"],
        ["\xF3\xB5\x8B\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x8A"],
        ["\xF3\xB5\x8B\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x8B"],
        ["\xF3\xB5\x8B\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x8C"],
        ["\xF3\xB5\x8B\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x8D"],
        ["\xF3\xB5\x8B\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x8E"],
        ["\xF3\xB5\x8B\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x8F"],
        ["\xF3\xB5\x8B\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x90"],
        ["\xF3\xB5\x8B\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x91"],
        ["\xF3\xB5\x8B\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x92"],
        ["\xF3\xB5\x8B\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x93"],
        ["\xF3\xB5\x8B\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x94"],
        ["\xF3\xB5\x8B\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x95"],
        ["\xF3\xB5\x8B\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x96"],
        ["\xF3\xB5\x8B\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x97"],
        ["\xF3\xB5\x8B\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x98"],
        ["\xF3\xB5\x8B\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x99"],
        ["\xF3\xB5\x8B\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x9A"],
        ["\xF3\xB5\x8B\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x9B"],
        ["\xF3\xB5\x8B\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x9C"],
        ["\xF3\xB5\x8B\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x9D"],
        ["\xF3\xB5\x8B\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x9E"],
        ["\xF3\xB5\x8B\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x9F"],
        ["\xF3\xB5\x8B\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA0"],
        ["\xF3\xB5\x8B\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA1"],
        ["\xF3\xB5\x8B\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA2"],
        ["\xF3\xB5\x8B\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA3"],
        ["\xF3\xB5\x8B\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA4"],
        ["\xF3\xB5\x8B\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA5"],
        ["\xF3\xB5\x8B\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA6"],
        ["\xF3\xB5\x8B\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA7"],
        ["\xF3\xB5\x8B\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA8"],
        ["\xF3\xB5\x8B\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA9"],
        ["\xF3\xB5\x8B\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xAA"],
        ["\xF3\xB5\x8B\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xAB"],
        ["\xF3\xB5\x8B\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xAC"],
        ["\xF3\xB5\x8B\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xAD"],
        ["\xF3\xB5\x8B\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xAE"],
        ["\xF3\xB5\x8B\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xAF"],
        ["\xF3\xB5\x8B\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xB0"],
        ["\xF3\xB5\x8B\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xB1"],
        ["\xF3\xB5\x8B\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xB2"],
        ["\xF3\xB5\x8B\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xB4"],
        ["\xF3\xB5\x8B\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xB5"],
        ["\xF3\xB5\x8B\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xB6"],
        ["\xF3\xB5\x8B\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xB7"],
        ["\xF3\xB5\x8B\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xB8"],
        ["\xF3\xB5\x8B\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xB9"],
        ["\xF3\xB5\x8B\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xBA"],
        ["\xF3\xB5\x8B\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xBB"],
        ["\xF3\xB5\x8B\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xBC"],
        ["\xF3\xB5\x8C\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xBD"],
        ["\xF3\xB5\x8C\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xBE"],
        ["\xF3\xB5\x8C\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xBF"],
        ["\xF3\xB5\x8C\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC0"],
        ["\xF3\xB5\x8C\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC1"],
        ["\xF3\xB5\x8C\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC3"],
        ["\xF3\xB5\x8C\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC4"],
        ["\xF3\xB5\x8C\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC5"],
        ["\xF3\xB5\x8C\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC6"],
        ["\xF3\xB5\x8C\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC7"],
        ["\xF3\xB5\x8C\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC8"],
        ["\xF3\xB5\x8C\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC9"],
        ["\xF3\xB5\x8C\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xCA"],
        ["\xF3\xB5\x8C\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xCB"],
        ["\xF3\xB5\x8C\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xCC"],
        ["\xF3\xB5\x8C\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xCD"],
        ["\xF3\xB5\x8C\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xCE"],
        ["\xF3\xB5\x8C\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xCF"],
        ["\xF3\xB5\x8C\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD0"],
        ["\xF3\xB5\x8C\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD1"],
        ["\xF3\xB5\x8C\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD2"],
        ["\xF3\xB5\x8C\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD3"],
        ["\xF3\xB5\x8C\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD4"],
        ["\xF3\xB5\x8C\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD5"],
        ["\xF3\xB5\x8C\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD6"],
        ["\xF3\xB5\x8C\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD7"],
        ["\xF3\xB5\x8C\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD8"],
        ["\xF3\xB5\x8C\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD9"],
        ["\xF3\xB5\x8C\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xDA"],
        ["\xF3\xB5\x8C\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xDB"],
        ["\xF3\xB5\x8C\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xDC"],
        ["\xF3\xB5\x8C\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xDD"],
        ["\xF3\xB5\x8C\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xDE"],
        ["\xF3\xB5\x8C\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xDF"],
        ["\xF3\xB5\x8C\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE0"],
        ["\xF3\xB5\x8C\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE1"],
        ["\xF3\xB5\x8C\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE2"],
        ["\xF3\xB5\x8C\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE3"],
        ["\xF3\xB5\x8C\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE4"],
        ["\xF3\xB5\x8C\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE5"],
        ["\xF3\xB5\x8C\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE7"],
        ["\xF3\xB5\x8C\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE8"],
        ["\xF3\xB5\x8C\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE9"],
        ["\xF3\xB5\x8C\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xEA"],
        ["\xF3\xB5\x8C\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xEB"],
        ["\xF3\xB5\x8C\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xEC"],
        ["\xF3\xB5\x8C\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xED"],
        ["\xF3\xB5\x8C\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xEF"],
        ["\xF3\xB5\x8C\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF0"],
        ["\xF3\xB5\x8C\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF2"],
        ["\xF3\xB5\x8C\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF3"],
        ["\xF3\xB5\x8C\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF4"],
        ["\xF3\xB5\x8C\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF5"],
        ["\xF3\xB5\x8C\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF6"],
        ["\xF3\xB5\x8C\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF7"],
        ["\xF3\xB5\x8C\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF8"],
        ["\xF3\xB5\x8C\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF9"],
        ["\xF3\xB5\x8C\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xFA"],
        ["\xF3\xB5\x8C\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xFB"],
        ["\xF3\xB5\x8C\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xFC"],
        ["\xF3\xB5\x8D\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x40"],
        ["\xF3\xB5\x8D\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x41"],
        ["\xF3\xB5\x8D\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x42"],
        ["\xF3\xB5\x8D\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x44"],
        ["\xF3\xB5\x8D\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x45"],
        ["\xF3\xB5\x8D\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x46"],
        ["\xF3\xB5\x8D\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x47"],
        ["\xF3\xB5\x8D\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x48"],
        ["\xF3\xB5\x8D\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x49"],
        ["\xF3\xB5\x8D\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4A"],
        ["\xF3\xB5\x8D\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4B"],
        ["\xF3\xB5\x8D\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4C"],
        ["\xF3\xB5\x8D\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4D"],
        ["\xF3\xB5\x8D\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4E"],
        ["\xF3\xB5\x8D\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4F"],
        ["\xF3\xB5\x8D\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x50"],
        ["\xF3\xB5\x8D\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x51"],
        ["\xF3\xB5\x8D\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x52"],
        ["\xF3\xB5\x8D\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x53"],
        ["\xF3\xB5\x8D\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x54"],
        ["\xF3\xB5\x8D\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x55"],
        ["\xF3\xB5\x8D\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x56"],
        ["\xF3\xB5\x8D\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x57"],
        ["\xF3\xB5\x8D\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x58"],
        ["\xF3\xB5\x8D\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x59"],
        ["\xF3\xB5\x8D\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5A"],
        ["\xF3\xB5\x8D\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5B"],
        ["\xF3\xB5\x8D\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5C"],
        ["\xF3\xB5\x8D\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5D"],
        ["\xF3\xB5\x8D\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5E"],
        ["\xF3\xB5\x8D\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5F"],
        ["\xF3\xB5\x8D\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x61"],
        ["\xF3\xB5\x8D\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x62"],
        ["\xF3\xB5\x8D\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x63"],
        ["\xF3\xB5\x8D\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x64"],
        ["\xF3\xB5\x8D\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x65"],
        ["\xF3\xB5\x8D\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x66"],
        ["\xF3\xB5\x8D\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x67"],
        ["\xF3\xB5\x8D\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x68"],
        ["\xF3\xB5\x8D\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6A"],
        ["\xF3\xB5\x8D\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6B"],
        ["\xF3\xB5\x8D\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6C"],
        ["\xF3\xB5\x8D\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6D"],
        ["\xF3\xB5\x8D\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6E"],
        ["\xF3\xB5\x8D\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6F"],
        ["\xF3\xB5\x8D\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x70"],
        ["\xF3\xB5\x8D\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x71"],
        ["\xF3\xB5\x8D\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x72"],
        ["\xF3\xB5\x8D\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x73"],
        ["\xF3\xB5\x8D\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x74"],
        ["\xF3\xB5\x8D\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x75"],
        ["\xF3\xB5\x8D\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x76"],
        ["\xF3\xB5\x8D\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x77"],
        ["\xF3\xB5\x8D\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x78"],
        ["\xF3\xB5\x8D\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x79"],
        ["\xF3\xB5\x8D\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x7A"],
        ["\xF3\xB5\x8D\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x7B"],
        ["\xF3\xB5\x8D\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x7C"],
        ["\xF3\xB5\x8D\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x7D"],
        ["\xF3\xB5\x8D\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x7E"],
        ["\xF3\xB5\x8E\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x81"],
        ["\xF3\xB5\x8E\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x82"],
        ["\xF3\xB5\x8E\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x83"],
        ["\xF3\xB5\x8E\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x84"],
        ["\xF3\xB5\x8E\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x85"],
        ["\xF3\xB5\x8E\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x86"],
        ["\xF3\xB5\x8E\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x87"],
        ["\xF3\xB5\x8E\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x88"],
        ["\xF3\xB5\x8E\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x89"],
        ["\xF3\xB5\x8E\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x8A"],
        ["\xF3\xB5\x8E\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x8C"],
        ["\xF3\xB5\x8E\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x8D"],
        ["\xF3\xB5\x8E\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x8E"],
        ["\xF3\xB5\x8E\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x8F"],
        ["\xF3\xB5\x8E\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x90"],
        ["\xF3\xB5\x8E\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x91"],
        ["\xF3\xB5\x8E\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x92"],
        ["\xF3\xB5\x8E\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x93"],
        ["\xF3\xB5\x8E\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x94"],
        ["\xF3\xB5\x8E\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x95"],
        ["\xF3\xB5\x8E\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x96"],
        ["\xF3\xB5\x8E\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x97"],
        ["\xF3\xB5\x8E\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x98"],
        ["\xF3\xB5\x8E\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x99"],
        ["\xF3\xB5\x8E\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x9A"],
        ["\xF3\xB5\x8E\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x9B"],
        ["\xF3\xB5\x8E\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x9C"],
        ["\xF3\xB5\x8E\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x9D"],
        ["\xF3\xB5\x8E\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x9E"],
        ["\xF3\xB5\x8E\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x9F"],
        ["\xF3\xB5\x8E\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA0"],
        ["\xF3\xB5\x8E\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA1"],
        ["\xF3\xB5\x8E\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA2"],
        ["\xF3\xB5\x8E\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA3"],
        ["\xF3\xB5\x8E\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA4"],
        ["\xF3\xB5\x8E\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA5"],
        ["\xF3\xB5\x8E\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA6"],
        ["\xF3\xB5\x8E\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA7"],
        ["\xF3\xB5\x8E\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA8"],
        ["\xF3\xB5\x8E\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA9"],
        ["\xF3\xB5\x8E\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xAA"],
        ["\xF3\xB5\x8E\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xAB"],
        ["\xF3\xB5\x8E\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xAC"],
        ["\xF3\xB5\x8E\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xAD"],
        ["\xF3\xB5\x8E\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xAE"],
        ["\xF3\xB5\x8E\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xAF"],
        ["\xF3\xB5\x8E\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xB0"],
        ["\xF3\xB5\x8E\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xB1"],
        ["\xF3\xB5\x8E\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xB2"],
        ["\xF3\xB5\x8E\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xB3"],
        ["\xF3\xB5\x8E\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xB4"],
        ["\xF3\xB5\x8E\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xB5"],
        ["\xF3\xB5\x8E\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xB6"],
        ["\xF3\xB5\x8E\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xB7"],
        ["\xF3\xB5\x8E\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xB8"],
        ["\xF3\xB5\x8E\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xB9"],
        ["\xF3\xB5\x8E\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xBA"],
        ["\xF3\xB5\x8E\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xBC"],
        ["\xF3\xB5\x8E\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xBD"],
        ["\xF3\xB5\x8E\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xBE"],
        ["\xF3\xB5\x8E\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xBF"],
        ["\xF3\xB5\x8E\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC0"],
        ["\xF3\xB5\x8F\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC1"],
        ["\xF3\xB5\x8F\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC2"],
        ["\xF3\xB5\x8F\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC3"],
        ["\xF3\xB5\x8F\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC4"],
        ["\xF3\xB5\x8F\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC5"],
        ["\xF3\xB5\x8F\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC6"],
        ["\xF3\xB5\x8F\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC7"],
        ["\xF3\xB5\x8F\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC8"],
        ["\xF3\xB5\x8F\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC9"],
        ["\xF3\xB5\x8F\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xCA"],
        ["\xF3\xB5\x8F\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xCB"],
        ["\xF3\xB5\x8F\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xCC"],
        ["\xF3\xB5\x8F\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xCD"],
        ["\xF3\xB5\x8F\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xCE"],
        ["\xF3\xB5\x8F\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xCF"],
        ["\xF3\xB5\x8F\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD0"],
        ["\xF3\xB5\x8F\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD1"],
        ["\xF3\xB5\x8F\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD2"],
        ["\xF3\xB5\x8F\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD3"],
        ["\xF3\xB5\x8F\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD4"],
        ["\xF3\xB5\x8F\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD6"],
        ["\xF3\xB5\x8F\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD7"],
        ["\xF3\xB5\x8F\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD8"],
        ["\xF3\xB5\x8F\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD9"],
        ["\xF3\xB5\x8F\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xDA"],
        ["\xF3\xB5\x8F\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xDB"],
        ["\xF3\xB5\x8F\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xDC"],
        ["\xF3\xB5\x8F\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xDD"],
        ["\xF3\xB5\x8F\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xDE"],
        ["\xF3\xB5\x8F\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xDF"],
        ["\xF3\xB5\x8F\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE0"],
        ["\xF3\xB5\x8F\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE1"],
        ["\xF3\xB5\x8F\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE2"],
        ["\xF3\xB5\x8F\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE3"],
        ["\xF3\xB5\x8F\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE4"],
        ["\xF3\xB5\x8F\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE5"],
        ["\xF3\xB5\x8F\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE6"],
        ["\xF3\xB5\x8F\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE7"],
        ["\xF3\xB5\x8F\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE8"],
        ["\xF3\xB5\x8F\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE9"],
        ["\xF3\xB5\x8F\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xEA"],
        ["\xF3\xB5\x8F\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xEB"],
        ["\xF3\xB5\x8F\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xEC"],
        ["\xF3\xB5\x8F\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xED"],
        ["\xF3\xB5\x8F\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xEE"],
        ["\xF3\xB5\x8F\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xEF"],
        ["\xF3\xB5\x8F\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF0"],
        ["\xF3\xB5\x8F\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF1"],
        ["\xF3\xB5\x8F\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF2"],
        ["\xF3\xB5\x8F\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF3"],
        ["\xF3\xB5\x8F\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF4"],
        ["\xF3\xB5\x8F\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF5"],
        ["\xF3\xB5\x8F\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF6"],
        ["\xF3\xB5\x8F\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF7"],
        ["\xF3\xB5\x8F\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF8"],
        ["\xF3\xB5\x8F\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF9"],
        ["\xF3\xB5\x8F\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xFA"],
        ["\xF3\xB5\x8F\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xFB"],
        ["\xF3\xB5\x8F\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xFC"],
        ["\xF3\xB5\x8F\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x40"],
        ["\xF3\xB5\x8F\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x41"],
        ["\xF3\xB5\x8F\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x42"],
        ["\xF3\xB5\x8F\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x43"],
        ["\xF3\xB5\x90\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x44"],
        ["\xF3\xB5\x90\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x45"],
        ["\xF3\xB5\x90\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x46"],
        ["\xF3\xB5\x90\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x47"],
        ["\xF3\xB5\x90\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x48"],
        ["\xF3\xB5\x90\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x49"],
        ["\xF3\xB5\x90\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4A"],
        ["\xF3\xB5\x90\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4B"],
        ["\xF3\xB5\x90\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4C"],
        ["\xF3\xB5\x90\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4D"],
        ["\xF3\xB5\x90\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4E"],
        ["\xF3\xB5\x90\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4F"],
        ["\xF3\xB5\x90\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x50"],
        ["\xF3\xB5\x90\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x51"],
        ["\xF3\xB5\x90\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x52"],
        ["\xF3\xB5\x90\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x53"],
        ["\xF3\xB5\x90\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x54"],
        ["\xF3\xB5\x90\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x55"],
        ["\xF3\xB5\x90\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x56"],
        ["\xF3\xB5\x90\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x57"],
        ["\xF3\xB5\x90\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x58"],
        ["\xF3\xB5\x90\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x59"],
        ["\xF3\xB5\x90\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5A"],
        ["\xF3\xB5\x90\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5B"],
        ["\xF3\xB5\x90\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5C"],
        ["\xF3\xB5\x90\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5D"],
        ["\xF3\xB5\x90\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5E"],
        ["\xF3\xB5\x90\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5F"],
        ["\xF3\xB5\x90\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x60"],
        ["\xF3\xB5\x90\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x61"],
        ["\xF3\xB5\x90\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x62"],
        ["\xF3\xB5\x90\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x63"],
        ["\xF3\xB5\x90\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x64"],
        ["\xF3\xB5\x90\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x65"],
        ["\xF3\xB5\x90\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x66"],
        ["\xF3\xB5\x90\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x67"],
        ["\xF3\xB5\x90\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x68"],
        ["\xF3\xB5\x90\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x69"],
        ["\xF3\xB5\x90\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6A"],
        ["\xF3\xB5\x90\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6B"],
        ["\xF3\xB5\x90\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6C"],
        ["\xF3\xB5\x90\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6D"],
        ["\xF3\xB5\x90\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6E"],
        ["\xF3\xB5\x90\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6F"],
        ["\xF3\xB5\x90\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x70"],
        ["\xF3\xB5\x90\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x71"],
        ["\xF3\xB5\x90\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x72"],
        ["\xF3\xB5\x90\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x73"],
        ["\xF3\xB5\x90\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x74"],
        ["\xF3\xB5\x90\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x75"],
        ["\xF3\xB5\x90\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x76"],
        ["\xF3\xB5\x90\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x77"],
        ["\xF3\xB5\x90\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x78"],
        ["\xF3\xB5\x90\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x79"],
        ["\xF3\xB5\x90\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x7A"],
        ["\xF3\xB5\x90\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x7B"],
        ["\xF3\xB5\x90\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x7C"],
        ["\xF3\xB5\x90\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x7D"],
        ["\xF3\xB5\x90\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x7E"],
        ["\xF3\xB5\x90\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x80"],
        ["\xF3\xB5\x90\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x81"],
        ["\xF3\xB5\x90\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x82"],
        ["\xF3\xB5\x90\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x83"],
        ["\xF3\xB5\x90\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x84"],
        ["\xF3\xB5\x91\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x85"],
        ["\xF3\xB5\x91\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x86"],
        ["\xF3\xB5\x91\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x87"],
        ["\xF3\xB5\x91\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x88"],
        ["\xF3\xB5\x91\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x89"],
        ["\xF3\xB5\x91\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x8A"],
        ["\xF3\xB5\x91\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x8B"],
        ["\xF3\xB5\x91\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x8C"],
        ["\xF3\xB5\x91\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x8D"],
        ["\xF3\xB5\x91\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x8E"],
        ["\xF3\xB5\x91\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x90"],
        ["\xF3\xB5\x91\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x91"],
        ["\xF3\xB5\x91\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x92"],
        ["\xF3\xB5\x91\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x93"],
        ["\xF3\xB5\x91\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x94"],
        ["\xF3\xB5\x91\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x95"],
        ["\xF3\xB5\x91\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x96"],
        ["\xF3\xB5\x91\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x97"],
        ["\xF3\xB5\x91\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x98"],
        ["\xF3\xB5\x91\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x99"],
        ["\xF3\xB5\x91\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x9A"],
        ["\xF3\xB5\x91\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x9B"],
        ["\xF3\xB5\x91\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x9C"],
        ["\xF3\xB5\x91\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x9D"],
        ["\xF3\xB5\x91\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x9E"],
        ["\xF3\xB5\x91\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x9F"],
        ["\xF3\xB5\x91\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA0"],
        ["\xF3\xB5\x91\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA1"],
        ["\xF3\xB5\x91\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA2"],
        ["\xF3\xB5\x91\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA3"],
        ["\xF3\xB5\x91\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA4"],
        ["\xF3\xB5\x91\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA5"],
        ["\xF3\xB5\x91\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA6"],
        ["\xF3\xB5\x91\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA7"],
        ["\xF3\xB5\x91\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA8"],
        ["\xF3\xB5\x91\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA9"],
        ["\xF3\xB5\x91\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xAA"],
        ["\xF3\xB5\x91\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xAB"],
        ["\xF3\xB5\x91\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xAC"],
        ["\xF3\xB5\x91\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xAD"],
        ["\xF3\xB5\x91\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xAE"],
        ["\xF3\xB5\x91\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xAF"],
        ["\xF3\xB5\x91\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xB0"],
        ["\xF3\xB5\x91\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xB1"],
        ["\xF3\xB5\x91\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xB2"],
        ["\xF3\xB5\x91\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xB3"],
        ["\xF3\xB5\x91\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xB4"],
        ["\xF3\xB5\x91\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xB5"],
        ["\xF3\xB5\x91\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xB6"],
        ["\xF3\xB5\x91\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xB7"],
        ["\xF3\xB5\x91\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xB8"],
        ["\xF3\xB5\x91\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xB9"],
        ["\xF3\xB5\x91\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xBA"],
        ["\xF3\xB5\x91\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xBB"],
        ["\xF3\xB5\x91\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xBC"],
        ["\xF3\xB5\x91\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xBD"],
        ["\xF3\xB5\x91\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xBE"],
        ["\xF3\xB5\x91\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xBF"],
        ["\xF3\xB5\x91\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC0"],
        ["\xF3\xB5\x91\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC2"],
        ["\xF3\xB5\x91\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC3"],
        ["\xF3\xB5\x92\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC5"],
        ["\xF3\xB5\x92\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC6"],
        ["\xF3\xB5\x92\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC7"],
        ["\xF3\xB5\x92\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC8"],
        ["\xF3\xB5\x92\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC9"],
        ["\xF3\xB5\x92\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xCA"],
        ["\xF3\xB5\x92\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xCB"],
        ["\xF3\xB5\x92\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xCC"],
        ["\xF3\xB5\x92\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xCD"],
        ["\xF3\xB5\x92\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xCE"],
        ["\xF3\xB5\x92\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xCF"],
        ["\xF3\xB5\x92\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD0"],
        ["\xF3\xB5\x92\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD1"],
        ["\xF3\xB5\x92\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD2"],
        ["\xF3\xB5\x92\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD3"],
        ["\xF3\xB5\x92\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD4"],
        ["\xF3\xB5\x92\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD5"],
        ["\xF3\xB5\x92\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD6"],
        ["\xF3\xB5\x92\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD7"],
        ["\xF3\xB5\x92\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD8"],
        ["\xF3\xB5\x92\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD9"],
        ["\xF3\xB5\x92\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xDA"],
        ["\xF3\xB5\x92\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xDB"],
        ["\xF3\xB5\x92\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xDD"],
        ["\xF3\xB5\x92\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xDE"],
        ["\xF3\xB5\x92\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xDF"],
        ["\xF3\xB5\x92\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE0"],
        ["\xF3\xB5\x92\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE1"],
        ["\xF3\xB5\x92\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE2"],
        ["\xF3\xB5\x92\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE3"],
        ["\xF3\xB5\x92\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE4"],
        ["\xF3\xB5\x92\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE6"],
        ["\xF3\xB5\x92\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE7"],
        ["\xF3\xB5\x92\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE9"],
        ["\xF3\xB5\x92\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xEA"],
        ["\xF3\xB5\x92\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xEB"],
        ["\xF3\xB5\x92\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xEC"],
        ["\xF3\xB5\x92\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xED"],
        ["\xF3\xB5\x92\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xEE"],
        ["\xF3\xB5\x92\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xEF"],
        ["\xF3\xB5\x92\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF0"],
        ["\xF3\xB5\x92\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF1"],
        ["\xF3\xB5\x92\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF2"],
        ["\xF3\xB5\x92\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF3"],
        ["\xF3\xB5\x92\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF4"],
        ["\xF3\xB5\x92\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF5"],
        ["\xF3\xB5\x92\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF6"],
        ["\xF3\xB5\x92\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF7"],
        ["\xF3\xB5\x92\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF8"],
        ["\xF3\xB5\x92\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF9"],
        ["\xF3\xB5\x92\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xFA"],
        ["\xF3\xB5\x92\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xFB"],
        ["\xF3\xB5\x92\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xFC"],
        ["\xF3\xB5\x92\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x40"],
        ["\xF3\xB5\x92\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x41"],
        ["\xF3\xB5\x92\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x42"],
        ["\xF3\xB5\x92\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x43"],
        ["\xF3\xB5\x92\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x44"],
        ["\xF3\xB5\x92\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x45"],
        ["\xF3\xB5\x92\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x46"],
        ["\xF3\xB5\x92\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x47"],
        ["\xF3\xB5\x93\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x48"],
        ["\xF3\xB5\x93\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x49"],
        ["\xF3\xB5\x93\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4A"],
        ["\xF3\xB5\x93\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4B"],
        ["\xF3\xB5\x93\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4C"],
        ["\xF3\xB5\x93\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4D"],
        ["\xF3\xB5\x93\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4E"],
        ["\xF3\xB5\x93\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4F"],
        ["\xF3\xB5\x93\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x50"],
        ["\xF3\xB5\x93\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x51"],
        ["\xF3\xB5\x93\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x52"],
        ["\xF3\xB5\x93\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x53"],
        ["\xF3\xB5\x93\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x54"],
        ["\xF3\xB5\x93\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x55"],
        ["\xF3\xB5\x93\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x56"],
        ["\xF3\xB5\x93\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x57"],
        ["\xF3\xB5\x93\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5A"],
        ["\xF3\xB5\x93\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5B"],
        ["\xF3\xB5\x93\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5C"],
        ["\xF3\xB5\x93\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5D"],
        ["\xF3\xB5\x93\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5E"],
        ["\xF3\xB5\x93\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5F"],
        ["\xF3\xB5\x93\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x60"],
        ["\xF3\xB5\x93\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x61"],
        ["\xF3\xB5\x93\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x62"],
        ["\xF3\xB5\x93\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x63"],
        ["\xF3\xB5\x93\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x64"],
        ["\xF3\xB5\x93\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x65"],
        ["\xF3\xB5\x93\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x66"],
        ["\xF3\xB5\x93\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x67"],
        ["\xF3\xB5\x93\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x68"],
        ["\xF3\xB5\x93\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x69"],
        ["\xF3\xB5\x93\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6A"],
        ["\xF3\xB5\x93\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6B"],
        ["\xF3\xB5\x93\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6C"],
        ["\xF3\xB5\x93\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6D"],
        ["\xF3\xB5\x93\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6E"],
        ["\xF3\xB5\x93\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6F"],
        ["\xF3\xB5\x93\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x70"],
        ["\xF3\xB5\x93\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x71"],
        ["\xF3\xB5\x93\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x72"],
        ["\xF3\xB5\x93\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x73"],
        ["\xF3\xB5\x93\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x74"],
        ["\xF3\xB5\x93\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x75"],
        ["\xF3\xB5\x93\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x76"],
        ["\xF3\xB5\x93\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x77"],
        ["\xF3\xB5\x93\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x78"],
        ["\xF3\xB5\x93\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x79"],
        ["\xF3\xB5\x93\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x7A"],
        ["\xF3\xB5\x93\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x7B"],
        ["\xF3\xB5\x93\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x7C"],
        ["\xF3\xB5\x93\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x7D"],
        ["\xF3\xB5\x93\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x7E"],
        ["\xF3\xB5\x93\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x80"],
        ["\xF3\xB5\x93\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x81"],
        ["\xF3\xB5\x93\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x82"],
        ["\xF3\xB5\x93\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x83"],
        ["\xF3\xB5\x93\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x84"],
        ["\xF3\xB5\x93\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x85"],
        ["\xF3\xB5\x93\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x86"],
        ["\xF3\xB5\x93\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x87"],
        ["\xF3\xB5\x93\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x88"],
        ["\xF3\xB5\x94\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x89"],
        ["\xF3\xB5\x94\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x8A"],
        ["\xF3\xB5\x94\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x8B"],
        ["\xF3\xB5\x94\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x8C"],
        ["\xF3\xB5\x94\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x8D"],
        ["\xF3\xB5\x94\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x8E"],
        ["\xF3\xB5\x94\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x8F"],
        ["\xF3\xB5\x94\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x90"],
        ["\xF3\xB5\x94\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x91"],
        ["\xF3\xB5\x94\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x92"],
        ["\xF3\xB5\x94\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x93"],
        ["\xF3\xB5\x94\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x94"],
        ["\xF3\xB5\x94\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x95"],
        ["\xF3\xB5\x94\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x96"],
        ["\xF3\xB5\x94\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x97"],
        ["\xF3\xB5\x94\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x98"],
        ["\xF3\xB5\x94\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x99"],
        ["\xF3\xB5\x94\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x9A"],
        ["\xF3\xB5\x94\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x9B"],
        ["\xF3\xB5\x94\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x9C"],
        ["\xF3\xB5\x94\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x9D"],
        ["\xF3\xB5\x94\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x9E"],
        ["\xF3\xB5\x94\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x9F"],
        ["\xF3\xB5\x94\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA0"],
        ["\xF3\xB5\x94\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA1"],
        ["\xF3\xB5\x94\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA2"],
        ["\xF3\xB5\x94\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA3"],
        ["\xF3\xB5\x94\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA4"],
        ["\xF3\xB5\x94\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA5"],
        ["\xF3\xB5\x94\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA6"],
        ["\xF3\xB5\x94\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA7"],
        ["\xF3\xB5\x94\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA8"],
        ["\xF3\xB5\x94\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA9"],
        ["\xF3\xB5\x94\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xAA"],
        ["\xF3\xB5\x94\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xAB"],
        ["\xF3\xB5\x94\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xAC"],
        ["\xF3\xB5\x94\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xAD"],
        ["\xF3\xB5\x94\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xAE"],
        ["\xF3\xB5\x94\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xAF"],
        ["\xF3\xB5\x94\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xB0"],
        ["\xF3\xB5\x94\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xB1"],
        ["\xF3\xB5\x94\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xB2"],
        ["\xF3\xB5\x94\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xB3"],
        ["\xF3\xB5\x94\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xB4"],
        ["\xF3\xB5\x94\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xB5"],
        ["\xF3\xB5\x94\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xB6"],
        ["\xF3\xB5\x94\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xB7"],
        ["\xF3\xB5\x94\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xB8"],
        ["\xF3\xB5\x94\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xB9"],
        ["\xF3\xB5\x94\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xBA"],
        ["\xF3\xB5\x94\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xBB"],
        ["\xF3\xB5\x94\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xBC"],
        ["\xF3\xB5\x94\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xBD"],
        ["\xF3\xB5\x94\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xBE"],
        ["\xF3\xB5\x94\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xBF"],
        ["\xF3\xB5\x94\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC0"],
        ["\xF3\xB5\x94\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC1"],
        ["\xF3\xB5\x94\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC2"],
        ["\xF3\xB5\x94\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC3"],
        ["\xF3\xB5\x94\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC4"],
        ["\xF3\xB5\x94\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC6"],
        ["\xF3\xB5\x94\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC7"],
        ["\xF3\xB5\x94\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC8"],
        ["\xF3\xB5\x95\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC9"],
        ["\xF3\xB5\x95\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xCA"],
        ["\xF3\xB5\x95\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xCB"],
        ["\xF3\xB5\x95\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xCC"],
        ["\xF3\xB5\x95\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xCD"],
        ["\xF3\xB5\x95\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xCE"],
        ["\xF3\xB5\x95\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xCF"],
        ["\xF3\xB5\x95\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD0"],
        ["\xF3\xB5\x95\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD1"],
        ["\xF3\xB5\x95\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD2"],
        ["\xF3\xB5\x95\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD3"],
        ["\xF3\xB5\x95\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD4"],
        ["\xF3\xB5\x95\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD5"],
        ["\xF3\xB5\x95\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD6"],
        ["\xF3\xB5\x95\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD7"],
        ["\xF3\xB5\x95\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD8"],
        ["\xF3\xB5\x95\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD9"],
        ["\xF3\xB5\x95\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xDA"],
        ["\xF3\xB5\x95\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xDB"],
        ["\xF3\xB5\x95\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xDC"],
        ["\xF3\xB5\x95\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xDD"],
        ["\xF3\xB5\x95\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xDE"],
        ["\xF3\xB5\x95\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xDF"],
        ["\xF3\xB5\x95\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE0"],
        ["\xF3\xB5\x95\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE1"],
        ["\xF3\xB5\x95\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE2"],
        ["\xF3\xB5\x95\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE3"],
        ["\xF3\xB5\x95\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE4"],
        ["\xF3\xB5\x95\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE5"],
        ["\xF3\xB5\x95\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE6"],
        ["\xF3\xB5\x95\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE7"],
        ["\xF3\xB5\x95\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE8"],
        ["\xF3\xB5\x95\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE9"],
        ["\xF3\xB5\x95\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xEA"],
        ["\xF3\xB5\x95\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xEB"],
        ["\xF3\xB5\x95\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xEC"],
        ["\xF3\xB5\x95\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xED"],
        ["\xF3\xB5\x95\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xEE"],
        ["\xF3\xB5\x95\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xEF"],
        ["\xF3\xB5\x95\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF0"],
        ["\xF3\xB5\x95\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF1"],
        ["\xF3\xB5\x95\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF2"],
        ["\xF3\xB5\x95\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF3"],
        ["\xF3\xB5\x95\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF4"],
        ["\xF3\xB5\x95\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF5"],
        ["\xF3\xB5\x95\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF6"],
        ["\xF3\xB5\x95\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF7"],
        ["\xF3\xB5\x95\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF8"],
        ["\xF3\xB5\x95\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF9"],
        ["\xF3\xB5\x95\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xFA"],
        ["\xF3\xB5\x95\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xFB"],
        ["\xF3\xB5\x95\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xFC"],
        ["\xF3\xB5\x95\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x40"],
        ["\xF3\xB5\x95\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x41"],
        ["\xF3\xB5\x95\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x42"],
        ["\xF3\xB5\x95\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x43"],
        ["\xF3\xB5\x95\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x44"],
        ["\xF3\xB5\x95\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x45"],
        ["\xF3\xB5\x95\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x46"],
        ["\xF3\xB5\x95\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x47"],
        ["\xF3\xB5\x95\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x48"],
        ["\xF3\xB5\x95\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x49"],
        ["\xF3\xB5\x95\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4A"],
        ["\xF3\xB5\x95\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4B"],
        ["\xF3\xB5\x96\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4C"],
        ["\xF3\xB5\x96\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4D"],
        ["\xF3\xB5\x96\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4E"],
        ["\xF3\xB5\x96\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4F"],
        ["\xF3\xB5\x96\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x50"],
        ["\xF3\xB5\x96\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x51"],
        ["\xF3\xB5\x96\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x52"],
        ["\xF3\xB5\x96\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x53"],
        ["\xF3\xB5\x96\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x54"],
        ["\xF3\xB5\x96\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x55"],
        ["\xF3\xB5\x96\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x56"],
        ["\xF3\xB5\x96\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x57"],
        ["\xF3\xB5\x96\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x58"],
        ["\xF3\xB5\x96\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x59"],
        ["\xF3\xB5\x96\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5A"],
        ["\xF3\xB5\x96\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5B"],
        ["\xF3\xB5\x96\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5C"],
        ["\xF3\xB5\x96\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5D"],
        ["\xF3\xB5\x96\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5E"],
        ["\xF3\xB5\x96\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5F"],
        ["\xF3\xB5\x96\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x60"],
        ["\xF3\xB5\x96\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x61"],
        ["\xF3\xB5\x96\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x62"],
        ["\xF3\xB5\x96\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x63"],
        ["\xF3\xB5\x96\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x64"],
        ["\xF3\xB5\x96\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x65"],
        ["\xF3\xB5\x96\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x66"],
        ["\xF3\xB5\x96\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x67"],
        ["\xF3\xB5\x96\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x68"],
        ["\xF3\xB5\x96\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x69"],
        ["\xF3\xB5\x96\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6A"],
        ["\xF3\xB5\x96\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6B"],
        ["\xF3\xB5\x96\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6C"],
        ["\xF3\xB5\x96\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6D"],
        ["\xF3\xB5\x96\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6E"],
        ["\xF3\xB5\x96\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6F"],
        ["\xF3\xB5\x96\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x70"],
        ["\xF3\xB5\x96\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x71"],
        ["\xF3\xB5\x96\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x72"],
        ["\xF3\xB5\x96\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x73"],
        ["\xF3\xB5\x96\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x74"],
        ["\xF3\xB5\x96\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x75"],
        ["\xF3\xB5\x96\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x76"],
        ["\xF3\xB5\x96\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x77"],
        ["\xF3\xB5\x96\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x78"],
        ["\xF3\xB5\x96\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x79"],
        ["\xF3\xB5\x96\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x7A"],
        ["\xF3\xB5\x96\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x7B"],
        ["\xF3\xB5\x96\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x7C"],
        ["\xF3\xB5\x96\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x7D"],
        ["\xF3\xB5\x96\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x7E"],
        ["\xF3\xB5\x96\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x80"],
        ["\xF3\xB5\x96\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x81"],
        ["\xF3\xB5\x96\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x82"],
        ["\xF3\xB5\x96\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x83"],
        ["\xF3\xB5\x96\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x84"],
        ["\xF3\xB5\x96\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x85"],
        ["\xF3\xB5\x96\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x86"],
        ["\xF3\xB5\x96\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x87"],
        ["\xF3\xB5\x96\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x88"],
        ["\xF3\xB5\x96\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x89"],
        ["\xF3\xB5\x96\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x8A"],
        ["\xF3\xB5\x96\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x8B"],
        ["\xF3\xB5\x96\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x8C"],
        ["\xF3\xB5\x97\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x8D"],
        ["\xF3\xB5\x97\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x8E"],
        ["\xF3\xB5\x97\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x8F"],
        ["\xF3\xB5\x97\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x90"],
        ["\xF3\xB5\x97\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x91"],
        ["\xF3\xB5\x97\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x92"],
        ["\xF3\xB5\x97\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x93"],
        ["\xF3\xB5\x97\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x94"],
        ["\xF3\xB5\x97\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x95"],
        ["\xF3\xB5\x97\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x96"],
        ["\xF3\xB5\x97\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x97"],
        ["\xF3\xB5\x97\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x98"],
        ["\xF3\xB5\x97\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x99"],
        ["\xF3\xB5\x97\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x9A"],
        ["\xF3\xB5\x97\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x9B"],
        ["\xF3\xB5\x97\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x9C"],
        ["\xF3\xB5\x97\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x9D"],
        ["\xF3\xB5\x97\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x9E"],
        ["\xF3\xB5\x97\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x9F"],
        ["\xF3\xB5\x97\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA0"],
        ["\xF3\xB5\x97\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA1"],
        ["\xF3\xB5\x97\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA2"],
        ["\xF3\xB5\x97\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA3"],
        ["\xF3\xB5\x97\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA4"],
        ["\xF3\xB5\x97\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA5"],
        ["\xF3\xB5\x97\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA6"],
        ["\xF3\xB5\x97\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA7"],
        ["\xF3\xB5\x97\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA8"],
        ["\xF3\xB5\x97\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA9"],
        ["\xF3\xB5\x97\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xAA"],
        ["\xF3\xB5\x97\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xAB"],
        ["\xF3\xB5\x97\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xAC"],
        ["\xF3\xB5\x97\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xAD"],
        ["\xF3\xB5\x97\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xAE"],
        ["\xF3\xB5\x97\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xAF"],
        ["\xF3\xB5\x97\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xB0"],
        ["\xF3\xB5\x97\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xB2"],
        ["\xF3\xB5\x97\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xB3"],
        ["\xF3\xB5\x97\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xB4"],
        ["\xF3\xB5\x97\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xB5"],
        ["\xF3\xB5\x97\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xB6"],
        ["\xF3\xB5\x97\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xB7"],
        ["\xF3\xB5\x97\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xB8"],
        ["\xF3\xB5\x97\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xB9"],
        ["\xF3\xB5\x97\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xBA"],
        ["\xF3\xB5\x97\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xBB"],
        ["\xF3\xB5\x97\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xBC"],
        ["\xF3\xB5\x97\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xBD"],
        ["\xF3\xB5\x97\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xBE"],
        ["\xF3\xB5\x97\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xBF"],
        ["\xF3\xB5\x97\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC0"],
        ["\xF3\xB5\x97\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC1"],
        ["\xF3\xB5\x97\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC2"],
        ["\xF3\xB5\x97\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC3"],
        ["\xF3\xB5\x97\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC4"],
        ["\xF3\xB5\x97\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC5"],
        ["\xF3\xB5\x97\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC6"],
        ["\xF3\xB5\x97\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC7"],
        ["\xF3\xB5\x97\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC8"],
        ["\xF3\xB5\x97\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC9"],
        ["\xF3\xB5\x97\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xCA"],
        ["\xF3\xB5\x97\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xCB"],
        ["\xF3\xB5\x97\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xCC"],
        ["\xF3\xB5\x98\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xCD"],
        ["\xF3\xB5\x98\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xCE"],
        ["\xF3\xB5\x98\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xCF"],
        ["\xF3\xB5\x98\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD0"],
        ["\xF3\xB5\x98\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD1"],
        ["\xF3\xB5\x98\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD2"],
        ["\xF3\xB5\x98\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD4"],
        ["\xF3\xB5\x98\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD5"],
        ["\xF3\xB5\x98\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD6"],
        ["\xF3\xB5\x98\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD7"],
        ["\xF3\xB5\x98\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD8"],
        ["\xF3\xB5\x98\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD9"],
        ["\xF3\xB5\x98\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xDA"],
        ["\xF3\xB5\x98\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xDB"],
        ["\xF3\xB5\x98\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xDC"],
        ["\xF3\xB5\x98\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xDD"],
        ["\xF3\xB5\x98\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xDE"],
        ["\xF3\xB5\x98\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xDF"],
        ["\xF3\xB5\x98\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE0"],
        ["\xF3\xB5\x98\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE1"],
        ["\xF3\xB5\x98\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE2"],
        ["\xF3\xB5\x98\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE3"],
        ["\xF3\xB5\x98\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE4"],
        ["\xF3\xB5\x98\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE5"],
        ["\xF3\xB5\x98\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE6"],
        ["\xF3\xB5\x98\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE7"],
        ["\xF3\xB5\x98\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE8"],
        ["\xF3\xB5\x98\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE9"],
        ["\xF3\xB5\x98\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xEA"],
        ["\xF3\xB5\x98\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xEB"],
        ["\xF3\xB5\x98\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xEC"],
        ["\xF3\xB5\x98\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xED"],
        ["\xF3\xB5\x98\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xEE"],
        ["\xF3\xB5\x98\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF0"],
        ["\xF3\xB5\x98\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF1"],
        ["\xF3\xB5\x98\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF2"],
        ["\xF3\xB5\x98\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF3"],
        ["\xF3\xB5\x98\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF4"],
        ["\xF3\xB5\x98\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF5"],
        ["\xF3\xB5\x98\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF6"],
        ["\xF3\xB5\x98\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF7"],
        ["\xF3\xB5\x98\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF8"],
        ["\xF3\xB5\x98\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF9"],
        ["\xF3\xB5\x98\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xFA"],
        ["\xF3\xB5\x98\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xFB"],
        ["\xF3\xB5\x98\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xFC"],
        ["\xF3\xB5\x98\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x40"],
        ["\xF3\xB5\x98\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x41"],
        ["\xF3\xB5\x98\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x42"],
        ["\xF3\xB5\x98\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x43"],
        ["\xF3\xB5\x98\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x44"],
        ["\xF3\xB5\x98\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x45"],
        ["\xF3\xB5\x98\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x46"],
        ["\xF3\xB5\x98\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x47"],
        ["\xF3\xB5\x98\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x48"],
        ["\xF3\xB5\x98\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x49"],
        ["\xF3\xB5\x98\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4A"],
        ["\xF3\xB5\x98\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4B"],
        ["\xF3\xB5\x98\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4C"],
        ["\xF3\xB5\x98\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4D"],
        ["\xF3\xB5\x98\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4E"],
        ["\xF3\xB5\x98\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4F"],
        ["\xF3\xB5\x99\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x50"],
        ["\xF3\xB5\x99\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x51"],
        ["\xF3\xB5\x99\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x52"],
        ["\xF3\xB5\x99\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x53"],
        ["\xF3\xB5\x99\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x54"],
        ["\xF3\xB5\x99\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x55"],
        ["\xF3\xB5\x99\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x56"],
        ["\xF3\xB5\x99\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x58"],
        ["\xF3\xB5\x99\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x59"],
        ["\xF3\xB5\x99\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5A"],
        ["\xF3\xB5\x99\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5B"],
        ["\xF3\xB5\x99\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5C"],
        ["\xF3\xB5\x99\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5D"],
        ["\xF3\xB5\x99\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5E"],
        ["\xF3\xB5\x99\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5F"],
        ["\xF3\xB5\x99\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x60"],
        ["\xF3\xB5\x99\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x61"],
        ["\xF3\xB5\x99\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x62"],
        ["\xF3\xB5\x99\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x63"],
        ["\xF3\xB5\x99\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x65"],
        ["\xF3\xB5\x99\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x66"],
        ["\xF3\xB5\x99\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x67"],
        ["\xF3\xB5\x99\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x68"],
        ["\xF3\xB5\x99\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x69"],
        ["\xF3\xB5\x99\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6A"],
        ["\xF3\xB5\x99\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6B"],
        ["\xF3\xB5\x99\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6C"],
        ["\xF3\xB5\x99\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6D"],
        ["\xF3\xB5\x99\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6E"],
        ["\xF3\xB5\x99\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6F"],
        ["\xF3\xB5\x99\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x70"],
        ["\xF3\xB5\x99\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x71"],
        ["\xF3\xB5\x99\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x72"],
        ["\xF3\xB5\x99\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x73"],
        ["\xF3\xB5\x99\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x74"],
        ["\xF3\xB5\x99\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x75"],
        ["\xF3\xB5\x99\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x76"],
        ["\xF3\xB5\x99\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x77"],
        ["\xF3\xB5\x99\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x78"],
        ["\xF3\xB5\x99\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x79"],
        ["\xF3\xB5\x99\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x7A"],
        ["\xF3\xB5\x99\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x7B"],
        ["\xF3\xB5\x99\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x7C"],
        ["\xF3\xB5\x99\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x7D"],
        ["\xF3\xB5\x99\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x7E"],
        ["\xF3\xB5\x99\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x80"],
        ["\xF3\xB5\x99\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x81"],
        ["\xF3\xB5\x99\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x82"],
        ["\xF3\xB5\x99\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x83"],
        ["\xF3\xB5\x99\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x84"],
        ["\xF3\xB5\x99\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x85"],
        ["\xF3\xB5\x99\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x86"],
        ["\xF3\xB5\x99\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x87"],
        ["\xF3\xB5\x99\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x88"],
        ["\xF3\xB5\x99\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x89"],
        ["\xF3\xB5\x99\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x8A"],
        ["\xF3\xB5\x99\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x8B"],
        ["\xF3\xB5\x99\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x8C"],
        ["\xF3\xB5\x99\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x8D"],
        ["\xF3\xB5\x99\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x8E"],
        ["\xF3\xB5\x99\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x8F"],
        ["\xF3\xB5\x99\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x90"],
        ["\xF3\xB5\x9A\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x91"],
        ["\xF3\xB5\x9A\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x92"],
        ["\xF3\xB5\x9A\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x93"],
        ["\xF3\xB5\x9A\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x94"],
        ["\xF3\xB5\x9A\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x95"],
        ["\xF3\xB5\x9A\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x96"],
        ["\xF3\xB5\x9A\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x97"],
        ["\xF3\xB5\x9A\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x98"],
        ["\xF3\xB5\x9A\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x99"],
        ["\xF3\xB5\x9A\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x9A"],
        ["\xF3\xB5\x9A\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x9B"],
        ["\xF3\xB5\x9A\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x9C"],
        ["\xF3\xB5\x9A\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x9D"],
        ["\xF3\xB5\x9A\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x9E"],
        ["\xF3\xB5\x9A\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x9F"],
        ["\xF3\xB5\x9A\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA0"],
        ["\xF3\xB5\x9A\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA1"],
        ["\xF3\xB5\x9A\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA2"],
        ["\xF3\xB5\x9A\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA3"],
        ["\xF3\xB5\x9A\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA4"],
        ["\xF3\xB5\x9A\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA5"],
        ["\xF3\xB5\x9A\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA6"],
        ["\xF3\xB5\x9A\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA7"],
        ["\xF3\xB5\x9A\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA8"],
        ["\xF3\xB5\x9A\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA9"],
        ["\xF3\xB5\x9A\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xAA"],
        ["\xF3\xB5\x9A\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xAB"],
        ["\xF3\xB5\x9A\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xAC"],
        ["\xF3\xB5\x9A\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xAD"],
        ["\xF3\xB5\x9A\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xAE"],
        ["\xF3\xB5\x9A\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xAF"],
        ["\xF3\xB5\x9A\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xB0"],
        ["\xF3\xB5\x9A\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xB1"],
        ["\xF3\xB5\x9A\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xB2"],
        ["\xF3\xB5\x9A\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xB3"],
        ["\xF3\xB5\x9A\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xB4"],
        ["\xF3\xB5\x9A\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xB5"],
        ["\xF3\xB5\x9A\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xB6"],
        ["\xF3\xB5\x9A\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xB7"],
        ["\xF3\xB5\x9A\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xB8"],
        ["\xF3\xB5\x9A\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xB9"],
        ["\xF3\xB5\x9A\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xBA"],
        ["\xF3\xB5\x9A\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xBB"],
        ["\xF3\xB5\x9A\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xBC"],
        ["\xF3\xB5\x9A\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xBD"],
        ["\xF3\xB5\x9A\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xBE"],
        ["\xF3\xB5\x9A\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xBF"],
        ["\xF3\xB5\x9A\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC0"],
        ["\xF3\xB5\x9A\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC1"],
        ["\xF3\xB5\x9A\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC2"],
        ["\xF3\xB5\x9A\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC3"],
        ["\xF3\xB5\x9A\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC4"],
        ["\xF3\xB5\x9A\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC5"],
        ["\xF3\xB5\x9A\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC6"],
        ["\xF3\xB5\x9A\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC7"],
        ["\xF3\xB5\x9A\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC8"],
        ["\xF3\xB5\x9A\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC9"],
        ["\xF3\xB5\x9A\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xCA"],
        ["\xF3\xB5\x9A\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xCB"],
        ["\xF3\xB5\x9A\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xCC"],
        ["\xF3\xB5\x9A\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xCD"],
        ["\xF3\xB5\x9A\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xCE"],
        ["\xF3\xB5\x9A\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xCF"],
        ["\xF3\xB5\x9A\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD0"],
        ["\xF3\xB5\x9B\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD1"],
        ["\xF3\xB5\x9B\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD2"],
        ["\xF3\xB5\x9B\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD3"],
        ["\xF3\xB5\x9B\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD4"],
        ["\xF3\xB5\x9B\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD5"],
        ["\xF3\xB5\x9B\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD6"],
        ["\xF3\xB5\x9B\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD7"],
        ["\xF3\xB5\x9B\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD8"],
        ["\xF3\xB5\x9B\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD9"],
        ["\xF3\xB5\x9B\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xDA"],
        ["\xF3\xB5\x9B\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xDB"],
        ["\xF3\xB5\x9B\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xDC"],
        ["\xF3\xB5\x9B\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xDD"],
        ["\xF3\xB5\x9B\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xDF"],
        ["\xF3\xB5\x9B\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE0"],
        ["\xF3\xB5\x9B\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE1"],
        ["\xF3\xB5\x9B\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE2"],
        ["\xF3\xB5\x9B\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE3"],
        ["\xF3\xB5\x9B\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE4"],
        ["\xF3\xB5\x9B\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE5"],
        ["\xF3\xB5\x9B\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE6"],
        ["\xF3\xB5\x9B\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE7"],
        ["\xF3\xB5\x9B\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE8"],
        ["\xF3\xB5\x9B\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE9"],
        ["\xF3\xB5\x9B\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xEA"],
        ["\xF3\xB5\x9B\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xEB"],
        ["\xF3\xB5\x9B\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xEC"],
        ["\xF3\xB5\x9B\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xEE"],
        ["\xF3\xB5\x9B\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xEF"],
        ["\xF3\xB5\x9B\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF0"],
        ["\xF3\xB5\x9B\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF1"],
        ["\xF3\xB5\x9B\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF2"],
        ["\xF3\xB5\x9B\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF3"],
        ["\xF3\xB5\x9B\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF4"],
        ["\xF3\xB5\x9B\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF5"],
        ["\xF3\xB5\x9B\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF6"],
        ["\xF3\xB5\x9B\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF7"],
        ["\xF3\xB5\x9B\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF8"],
        ["\xF3\xB5\x9B\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF9"],
        ["\xF3\xB5\x9B\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xFA"],
        ["\xF3\xB5\x9B\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xFB"],
        ["\xF3\xB5\x9B\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xFC"],
        ["\xF3\xB5\x9B\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x4A"],
        ["\xF3\xB5\x9B\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x4B"],
        ["\xF3\xB5\x9B\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x4C"],
        ["\xF3\xB5\x9B\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x4D"],
        ["\xF3\xB5\x9B\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x4E"],
        ["\xF3\xB5\x9B\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x50"],
        ["\xF3\xB5\x9B\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x51"],
        ["\xF3\xB5\x9B\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x52"],
        ["\xF3\xB5\x9B\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x53"],
        ["\xF3\xB5\x9C\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x54"],
        ["\xF3\xB5\x9C\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x55"],
        ["\xF3\xB5\x9C\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x56"],
        ["\xF3\xB5\x9C\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x57"],
        ["\xF3\xB5\x9C\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x58"],
        ["\xF3\xB5\x9C\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x59"],
        ["\xF3\xB5\x9C\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x5A"],
        ["\xF3\xB5\x9C\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x5B"],
        ["\xF3\xB5\x9C\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x5E"],
        ["\xF3\xB5\x9C\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x5F"],
        ["\xF3\xB5\x9C\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x65"],
        ["\xF3\xB5\x9C\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x68"],
        ["\xF3\xB5\x9C\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x7B"],
        ["\xF3\xB5\x9C\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x90"],
        ["\xF3\xB5\x9D\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x9B"],
        ["\xF3\xB5\x9D\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\x9C"],
        ["\xF3\xB5\x9D\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xA5"],
        ["\xF3\xB5\x9D\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xB1"],
        ["\xF3\xB5\x9E\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xD8"],
        ["\xF3\xB5\x9E\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xE0"],
        ["\xF3\xB5\x9E\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xE8"],
        ["\xF3\xB5\x9E\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA\xEA"],
        ["\xF3\xB5\x9F\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x58"],
        ["\xF3\xB5\x9F\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x5E"],
        ["\xF3\xB5\x9F\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x75"],
        ["\xF3\xB5\x9F\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x7D"],
        ["\xF3\xB5\x9F\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x7E"],
        ["\xF3\xB5\x9F\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x80"],
        ["\xF3\xB5\x9F\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x82"],
        ["\xF3\xB5\x9F\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x86"],
        ["\xF3\xB5\x9F\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x8A"],
        ["\xF3\xB5\x9F\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x90"],
        ["\xF3\xB5\x9F\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x92"],
        ["\xF3\xB5\x9F\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x95"],
        ["\xF3\xB5\x9F\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x98"],
        ["\xF3\xB5\xA0\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x9D"],
        ["\xF3\xB5\xA0\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\x9F"],
        ["\xF3\xB5\xA0\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xA9"],
        ["\xF3\xB5\xA0\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xB1"],
        ["\xF3\xB5\xA0\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xB3"],
        ["\xF3\xB5\xA0\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xB4"],
        ["\xF3\xB5\xA0\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xB5"],
        ["\xF3\xB5\xA0\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xB7"],
        ["\xF3\xB5\xA0\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xD3"],
        ["\xF3\xB5\xA1\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xDA"],
        ["\xF3\xB5\xA1\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xE9"],
        ["\xF3\xB5\xA1\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xEA"],
        ["\xF3\xB5\xA1\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xF6"],
        ["\xF3\xB5\xA1\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xF7"],
        ["\xF3\xB5\xA1\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xF9"],
        ["\xF3\xB5\xA1\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xFB"],
        ["\xF3\xB5\xA1\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB\xFC"],
        ["\xF3\xB5\xA1\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x40"],
        ["\xF3\xB5\xA1\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x41"],
        ["\xF3\xB5\xA1\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x42"],
        ["\xF3\xB5\xA1\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x43"],
        ["\xF3\xB5\xA1\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x44"],
        ["\xF3\xB5\xA1\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x45"],
        ["\xF3\xB5\xA1\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x46"],
        ["\xF3\xB5\xA1\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x47"],
        ["\xF3\xB5\xA1\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x48"],
        ["\xF3\xB5\xA1\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x49"],
        ["\xF3\xB5\xA1\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x4A"],
        ["\xF3\xB5\xA1\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x4C"],
        ["\xF3\xB5\xA1\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x4D"],
        ["\xF3\xB5\xA1\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x4E"],
        ["\xF3\xB5\xA1\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x4F"],
        ["\xF3\xB5\xA1\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x50"],
        ["\xF3\xB5\xA1\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x52"],
        ["\xF3\xB5\xA1\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x53"],
        ["\xF3\xB5\xA1\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x54"],
        ["\xF3\xB5\xA1\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x55"],
        ["\xF3\xB5\xA1\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x56"],
        ["\xF3\xB5\xA1\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x57"],
        ["\xF3\xB5\xA1\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x58"],
        ["\xF3\xB5\xA1\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x59"],
        ["\xF3\xB5\xA1\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x5A"],
        ["\xF3\xB5\xA1\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x5B"],
        ["\xF3\xB5\xA2\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x5C"],
        ["\xF3\xB5\xA2\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x5D"],
        ["\xF3\xB5\xA2\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x5E"],
        ["\xF3\xB5\xA2\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x5F"],
        ["\xF3\xB5\xA2\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x60"],
        ["\xF3\xB5\xA2\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x61"],
        ["\xF3\xB5\xA2\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x62"],
        ["\xF3\xB5\xA2\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x63"],
        ["\xF3\xB5\xA2\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x64"],
        ["\xF3\xB5\xA2\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x65"],
        ["\xF3\xB5\xA2\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x66"],
        ["\xF3\xB5\xA2\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x67"],
        ["\xF3\xB5\xA2\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x68"],
        ["\xF3\xB5\xA2\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x6A"],
        ["\xF3\xB5\xA2\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x6B"],
        ["\xF3\xB5\xA2\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x6C"],
        ["\xF3\xB5\xA2\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x6D"],
        ["\xF3\xB5\xA2\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x6E"],
        ["\xF3\xB5\xA2\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x6F"],
        ["\xF3\xB5\xA2\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x70"],
        ["\xF3\xB5\xA2\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x71"],
        ["\xF3\xB5\xA2\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x72"],
        ["\xF3\xB5\xA2\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x73"],
        ["\xF3\xB5\xA2\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x74"],
        ["\xF3\xB5\xA2\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x75"],
        ["\xF3\xB5\xA2\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x76"],
        ["\xF3\xB5\xA2\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x77"],
        ["\xF3\xB5\xA2\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x78"],
        ["\xF3\xB5\xA2\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x79"],
        ["\xF3\xB5\xA2\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x7A"],
        ["\xF3\xB5\xA2\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x7B"],
        ["\xF3\xB5\xA2\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x7C"],
        ["\xF3\xB5\xA2\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x7D"],
        ["\xF3\xB5\xA2\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x7E"],
        ["\xF3\xB5\xA2\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x80"],
        ["\xF3\xB5\xA2\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x81"],
        ["\xF3\xB5\xA2\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x82"],
        ["\xF3\xB5\xA2\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x83"],
        ["\xF3\xB5\xA2\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x84"],
        ["\xF3\xB5\xA2\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x85"],
        ["\xF3\xB5\xA2\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x86"],
        ["\xF3\xB5\xA2\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x87"],
        ["\xF3\xB5\xA2\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x88"],
        ["\xF3\xB5\xA2\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x89"],
        ["\xF3\xB5\xA2\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x8A"],
        ["\xF3\xB5\xA2\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x8B"],
        ["\xF3\xB5\xA2\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x8C"],
        ["\xF3\xB5\xA2\xB0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x8D"],
        ["\xF3\xB5\xA2\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x8E"],
        ["\xF3\xB5\xA2\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x8F"],
        ["\xF3\xB5\xA2\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x90"],
        ["\xF3\xB5\xA2\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x91"],
        ["\xF3\xB5\xA2\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x92"],
        ["\xF3\xB5\xA2\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x93"],
        ["\xF3\xB5\xA2\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x94"],
        ["\xF3\xB5\xA2\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x95"],
        ["\xF3\xB5\xA2\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x96"],
        ["\xF3\xB5\xA2\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x97"],
        ["\xF3\xB5\xA2\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x98"],
        ["\xF3\xB5\xA2\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x99"],
        ["\xF3\xB5\xA2\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x9A"],
        ["\xF3\xB5\xA2\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x9B"],
        ["\xF3\xB5\xA2\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x9C"],
        ["\xF3\xB5\xA3\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x9D"],
        ["\xF3\xB5\xA3\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x9E"],
        ["\xF3\xB5\xA3\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\x9F"],
        ["\xF3\xB5\xA3\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xA0"],
        ["\xF3\xB5\xA3\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xA1"],
        ["\xF3\xB5\xA3\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xA2"],
        ["\xF3\xB5\xA3\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xA3"],
        ["\xF3\xB5\xA3\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xA4"],
        ["\xF3\xB5\xA3\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xA5"],
        ["\xF3\xB5\xA3\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xA6"],
        ["\xF3\xB5\xA3\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xA7"],
        ["\xF3\xB5\xA3\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xA8"],
        ["\xF3\xB5\xA3\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xA9"],
        ["\xF3\xB5\xA3\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xAA"],
        ["\xF3\xB5\xA3\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xAB"],
        ["\xF3\xB5\xA3\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xAC"],
        ["\xF3\xB5\xA3\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xAD"],
        ["\xF3\xB5\xA3\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xAE"],
        ["\xF3\xB5\xA3\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xAF"],
        ["\xF3\xB5\xA3\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xB0"],
        ["\xF3\xB5\xA3\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xB1"],
        ["\xF3\xB5\xA3\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xB3"],
        ["\xF3\xB5\xA3\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xB4"],
        ["\xF3\xB5\xA3\x98",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xB5"],
        ["\xF3\xB5\xA3\x99",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xB6"],
        ["\xF3\xB5\xA3\x9A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xB7"],
        ["\xF3\xB5\xA3\x9B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xB8"],
        ["\xF3\xB5\xA3\x9C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xB9"],
        ["\xF3\xB5\xA3\x9D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xBA"],
        ["\xF3\xB5\xA3\x9E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xBB"],
        ["\xF3\xB5\xA3\x9F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xBC"],
        ["\xF3\xB5\xA3\xA0",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xBD"],
        ["\xF3\xB5\xA3\xA1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xBE"],
        ["\xF3\xB5\xA3\xA2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xBF"],
        ["\xF3\xB5\xA3\xA3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xC0"],
        ["\xF3\xB5\xA3\xA4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xC1"],
        ["\xF3\xB5\xA3\xA5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xC2"],
        ["\xF3\xB5\xA3\xA6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xC3"],
        ["\xF3\xB5\xA3\xA7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xC4"],
        ["\xF3\xB5\xA3\xA8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xC5"],
        ["\xF3\xB5\xA3\xA9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xC6"],
        ["\xF3\xB5\xA3\xAA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xC7"],
        ["\xF3\xB5\xA3\xAB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xC8"],
        ["\xF3\xB5\xA3\xAC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xC9"],
        ["\xF3\xB5\xA3\xAD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xCA"],
        ["\xF3\xB5\xA3\xAE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xCB"],
        ["\xF3\xB5\xA3\xAF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xCC"],
        ["\xF3\xB5\xA3\xB1",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xCE"],
        ["\xF3\xB5\xA3\xB2",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xCF"],
        ["\xF3\xB5\xA3\xB3",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xD0"],
        ["\xF3\xB5\xA3\xB4",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xD1"],
        ["\xF3\xB5\xA3\xB5",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xD2"],
        ["\xF3\xB5\xA3\xB6",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xD3"],
        ["\xF3\xB5\xA3\xB7",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xD4"],
        ["\xF3\xB5\xA3\xB8",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xD5"],
        ["\xF3\xB5\xA3\xB9",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xD6"],
        ["\xF3\xB5\xA3\xBA",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xD7"],
        ["\xF3\xB5\xA3\xBB",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xD8"],
        ["\xF3\xB5\xA3\xBC",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xD9"],
        ["\xF3\xB5\xA3\xBD",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xDA"],
        ["\xF3\xB5\xA3\xBE",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xDB"],
        ["\xF3\xB5\xA3\xBF",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xDC"],
        ["\xF3\xB5\xA4\x80",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xDD"],
        ["\xF3\xB5\xA4\x81",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xDE"],
        ["\xF3\xB5\xA4\x82",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xDF"],
        ["\xF3\xB5\xA4\x83",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xE0"],
        ["\xF3\xB5\xA4\x84",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xE1"],
        ["\xF3\xB5\xA4\x85",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xE2"],
        ["\xF3\xB5\xA4\x86",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xE3"],
        ["\xF3\xB5\xA4\x87",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xE4"],
        ["\xF3\xB5\xA4\x88",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xE5"],
        ["\xF3\xB5\xA4\x89",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xE6"],
        ["\xF3\xB5\xA4\x8A",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xE7"],
        ["\xF3\xB5\xA4\x8B",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xE8"],
        ["\xF3\xB5\xA4\x8C",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xE9"],
        ["\xF3\xB5\xA4\x8D",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xEA"],
        ["\xF3\xB5\xA4\x8E",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xEB"],
        ["\xF3\xB5\xA4\x8F",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xEC"],
        ["\xF3\xB5\xA4\x90",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xED"],
        ["\xF3\xB5\xA4\x91",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xEE"],
        ["\xF3\xB5\xA4\x92",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xEF"],
        ["\xF3\xB5\xA4\x93",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xF0"],
        ["\xF3\xB5\xA4\x94",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xF1"],
        ["\xF3\xB5\xA4\x95",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xF2"],
        ["\xF3\xB5\xA4\x96",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xF3"],
        ["\xF3\xB5\xA4\x97",'sjis2004','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC\xF4"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e::RoundTrip;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::RoundTrip::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
