######################################################################
#
# 0118_cp932_vs_keis83_test.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

# HITAC Character code table (KEIS83)
# Document number 8080-2-100-10

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x8B\xC4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"], #  8BC4 B6C6
        ["\x96\x8A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"], #  968A CBEA
        ["\x97\x79",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"], # y 9779 CDDA
        ["\xE0\xF4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"], #  E0F4 E0F6
        ["\xEA\x9F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xF4\xA1"], #  EA9F F4A1
        ["\xEA\xA0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xF4\xA2"], #  EAA0 F4A2
        ["\xEA\xA1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xF4\xA3"], #  EAA1 F4A3
        ["\xEA\xA2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xF4\xA4"], #  EAA2 F4A4
        ["\xEA\xA4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xB8"], #  EAA4 64B8
        ["\x81\xBE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"], #  81BE A2C0
        ["\x81\xBF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"], #  81BF A2C1
        ["\x81\xCA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xCC"], #  81CA A2CC
        ["\x81\xDA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xDC"], #  81DA A2DC
        ["\x81\xDB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xDD"], #  81DB A2DD
        ["\x81\xDF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xE1"], #  81DF A2E1
        ["\x81\xE0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xE2"], #  81E0 A2E2
        ["\x81\xE3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xE5"], #  81E3 A2E5
        ["\x81\xE6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xE8"], #  81E6 A2E8
        ["\xFA\x9C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xC7"], #  FA9C 5CC7
        ["\xFA\xD0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xB6"], #  FAD0 60B6
        ["\x87\x40",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xB1"], # @ 8740 76B1
        ["\x87\x41",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xB2"], # A 8741 76B2
        ["\x87\x42",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xB3"], # B 8742 76B3
        ["\x87\x43",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xB4"], # C 8743 76B4
        ["\x87\x44",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xB5"], # D 8744 76B5
        ["\x87\x45",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xB6"], # E 8745 76B6
        ["\x87\x46",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xB7"], # F 8746 76B7
        ["\x87\x47",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xB8"], # G 8747 76B8
        ["\x87\x48",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xB9"], # H 8748 76B9
        ["\x87\x49",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xBA"], # I 8749 76BA
        ["\x87\x4A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xA1"], # J 874A 77A1
        ["\x87\x4B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xA2"], # K 874B 77A2
        ["\x87\x4C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xA3"], # L 874C 77A3
        ["\x87\x4D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xA4"], # M 874D 77A4
        ["\x87\x4E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xA5"], # N 874E 77A5
        ["\x87\x4F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xA6"], # O 874F 77A6
        ["\x87\x50",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xA7"], # P 8750 77A7
        ["\x87\x51",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xA8"], # Q 8751 77A8
        ["\x87\x52",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xA9"], # R 8752 77A9
        ["\x87\x53",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xAA"], # S 8753 77AA
        ["\x87\x54",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xB1"], # T 8754 74B1
        ["\x87\x55",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xB2"], # U 8755 74B2
        ["\x87\x56",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xB3"], # V 8756 74B3
        ["\x87\x57",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xB4"], # W 8757 74B4
        ["\x87\x58",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xB5"], # X 8758 74B5
        ["\x87\x59",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xB6"], # Y 8759 74B6
        ["\x87\x5A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xB7"], # Z 875A 74B7
        ["\x87\x5B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xB8"], # [ 875B 74B8
        ["\x87\x5C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xB9"], # \ 875C 74B9
        ["\x87\x5D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xBA"], # ] 875D 74BA
        ["\x87\x5F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xCF"], # _ 875F 70CF
        ["\x87\x60",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xD1"], # ` 8760 70D1
        ["\x87\x61",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xD0"], # a 8761 70D0
        ["\x87\x62",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xD3"], # b 8762 70D3
        ["\x87\x63",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xD5"], # c 8763 70D5
        ["\x87\x64",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xD7"], # d 8764 70D7
        ["\x87\x65",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xD8"], # e 8765 70D8
        ["\x87\x66",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xD9"], # f 8766 70D9
        ["\x87\x68",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xDB"], # h 8768 70DB
        ["\x87\x69",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xDC"], # i 8769 70DC
        ["\x87\x6A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xE2"], # j 876A 70E2
        ["\x87\x6B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xE1"], # k 876B 70E1
        ["\x87\x6C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xE0"], # l 876C 70E0
        ["\x87\x6D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xDA"], # m 876D 70DA
        ["\x87\x6E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xDF"], # n 876E 70DF
        ["\x87\x6F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xCC"], # o 876F 6FCC
        ["\x87\x70",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xCB"], # p 8770 6FCB
        ["\x87\x71",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xCA"], # q 8771 6FCA
        ["\x87\x72",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xDA"], # r 8772 6FDA
        ["\x87\x73",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xD9"], # s 8773 6FD9
        ["\x87\x74",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xFA"], # t 8774 6FFA
        ["\x87\x75",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xD0"], # u 8775 6FD0
        ["\x87\x82",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x72\xBE"], #  8782 72BE
        ["\x87\x83",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x72\xB6"], #  8783 72B6
        ["\x87\x84",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x72\xB8"], #  8784 72B8
        ["\x87\x8A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x73\xD0"], #  878A 73D0
        ["\x87\x8B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x73\xB1"], #  878B 73B1
        ["\x87\x8C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x73\xBD"], #  878C 73BD
        ["\xFA\x40",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xC1"], # @ FA40 74C1
        ["\xFA\x41",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xC2"], # A FA41 74C2
        ["\xFA\x42",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xC3"], # B FA42 74C3
        ["\xFA\x43",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xC4"], # C FA43 74C4
        ["\xFA\x44",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xC5"], # D FA44 74C5
        ["\xFA\x45",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xC6"], # E FA45 74C6
        ["\xFA\x46",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xC7"], # F FA46 74C7
        ["\xFA\x47",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xC8"], # G FA47 74C8
        ["\xFA\x48",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xC9"], # H FA48 74C9
        ["\xFA\x49",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x74\xCA"], # I FA49 74CA
        ["\xFA\x5C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xFE"], # \ FA5C 67FE
        ["\xFA\x5D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xE8"], # ] FA5D 69E8
        ["\xFA\x5E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xC7"], # ^ FA5E 6CC7
        ["\xFA\x5F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xA3"], # _ FA5F 6CA3
        ["\xFA\x60",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xAE"], # ` FA60 69AE
        ["\xFA\x61",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xE4"], # a FA61 59E4
        ["\xFA\x62",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xFE"], # b FA62 63FE
        ["\xFA\x63",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xF8"], # c FA63 60F8
        ["\xFA\x64",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xDC"], # d FA64 61DC
        ["\xFA\x65",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xBB"], # e FA65 6CBB
        ["\xFA\x66",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xD3"], # f FA66 60D3
        ["\xFA\x67",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xD8"], # g FA67 5ED8
        ["\xFA\x68",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xAC"], # h FA68 59AC
        ["\xFA\x69",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xC1"], # i FA69 59C1
        ["\xFA\x6A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xC8"], # j FA6A 59C8
        ["\xFA\x6B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xC7"], # k FA6B 59C7
        ["\xFA\x6C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xA1"], # l FA6C 9FA1
        ["\xFA\x6D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xCE"], # m FA6D 59CE
        ["\xFA\x6E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xCB"], # n FA6E 59CB
        ["\xFA\x6F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xDB"], # o FA6F 59DB
        ["\xFA\x70",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xE0"], # p FA70 59E0
        ["\xFA\x71",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xDA"], # q FA71 59DA
        ["\xFA\x72",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"], # r FA72 59D9
        ["\xFA\x73",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xE6"], # s FA73 59E6
        ["\xFA\x74",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xA1"], # t FA74 5AA1
        ["\xFA\x75",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xF1"], # u FA75 59F1
        ["\xFA\x76",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xFA"], # v FA76 59FA
        ["\xFA\x77",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xF3"], # w FA77 59F3
        ["\xFA\x78",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xA7"], # x FA78 5AA7
        ["\xFA\x79",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xAC"], # y FA79 5AAC
        ["\xFA\x7A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xA6"], # z FA7A 5AA6
        ["\xFA\x7B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xB0"], # { FA7B 5AB0
        ["\xFA\x7C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xBE"], # | FA7C 5ABE
        ["\xFA\x7D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xC1"], # } FA7D 5AC1
        ["\xFA\x7E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xCB"], # ~ FA7E 5ACB
        ["\xFA\x80",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xD3"], #  FA80 5AD3
        ["\xFA\x81",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xE1"], #  FA81 5AE1
        ["\xFA\x82",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xE4"], #  FA82 5AE4
        ["\xFA\x83",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xC3"], #  FA83 6DC3
        ["\xFA\x84",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xA3"], #  FA84 9FA3
        ["\xFA\x85",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xF0"], #  FA85 5AF0
        ["\xFA\x86",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xF1"], #  FA86 5AF1
        ["\xFA\x87",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xF7"], #  FA87 5AF7
        ["\xFA\x88",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xA1"], #  FA88 5BA1
        ["\xFA\x89",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xA9"], #  FA89 5BA9
        ["\xFA\x8A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xAB"], #  FA8A 5BAB
        ["\xFA\x8B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xAF"], #  FA8B 5BAF
        ["\xFA\x8C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xBC"], #  FA8C 5BBC
        ["\xFA\x8D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xC4"], #  FA8D 5BC4
        ["\xFA\x8E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xC9"], #  FA8E 5BC9
        ["\xFA\x8F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xCE"], #  FA8F 5BCE
        ["\xFA\x90",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xD3"], #  FA90 5BD3
        ["\xFA\x91",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xDB"], #  FA91 5BDB
        ["\xFA\x92",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xDA"], #  FA92 5BDA
        ["\xFA\x93",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xE1"], #  FA93 5BE1
        ["\xFA\x94",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xE3"], #  FA94 5BE3
        ["\xFA\x95",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xED"], #  FA95 5BED
        ["\xFA\x96",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xB2"], #  FA96 5CB2
        ["\xFA\x97",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xB6"], #  FA97 5CB6
        ["\xFA\x98",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xB9"], #  FA98 5CB9
        ["\xFA\x99",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xBD"], #  FA99 5CBD
        ["\xFA\x9A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xA6"], #  FA9A 9FA6
        ["\xFA\x9B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xBB"], #  FA9B 5CBB
        ["\xFA\x9D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xD1"], #  FA9D 5CD1
        ["\xFA\x9E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xD3"], #  FA9E 5CD3
        ["\xFA\x9F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xCD"], #  FA9F 5BCD
        ["\xFA\xA0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xE4"], #  FAA0 5CE4
        ["\xFA\xA1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xE6"], #  FAA1 5CE6
        ["\xFA\xA2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xE8"], #  FAA2 5CE8
        ["\xFA\xA3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xE9"], #  FAA3 5CE9
        ["\xFA\xA4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xF4"], #  FAA4 5CF4
        ["\xFA\xA5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xF7"], #  FAA5 5CF7
        ["\xFA\xA6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xB3"], #  FAA6 5DB3
        ["\xFA\xA7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xC2"], #  FAA7 5DC2
        ["\xFA\xA8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xC5"], #  FAA8 5DC5
        ["\xFA\xA9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xC6"], #  FAA9 5DC6
        ["\xFA\xAA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xC7"], #  FAAA 5DC7
        ["\xFA\xAB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xD2"], #  FAAB 5DD2
        ["\xFA\xAC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xDE"], #  FAAC 5DDE
        ["\xFA\xAD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xDD"], #  FAAD 5DDD
        ["\xFA\xAE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xE6"], #  FAAE 5DE6
        ["\xFA\xAF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xE8"], #  FAAF 5DE8
        ["\xFA\xB0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xF0"], #  FAB0 5DF0
        ["\xFA\xB1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xEC"], #  FAB1 5DEC
        ["\xFA\xB2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xEF"], #  FAB2 5DEF
        ["\xFA\xB3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xA9"], #  FAB3 9FA9
        ["\xFA\xB4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xA3"], #  FAB4 5EA3
        ["\xFA\xB5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xA5"], #  FAB5 5EA5
        ["\xFA\xB6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xA7"], #  FAB6 5EA7
        ["\xFA\xB7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xD2"], #  FAB7 5ED2
        ["\xFA\xB8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"], #  FAB8 5ED3
        ["\xFA\xB9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xCA"], #  FAB9 5FCA
        ["\xFA\xBA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xE6"], #  FABA 5EE6
        ["\xFA\xBB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xEE"], #  FABB 5EEE
        ["\xFA\xBC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xF8"], #  FABC 5EF8
        ["\xFA\xBD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xF9"], #  FABD 5EF9
        ["\xFA\xBE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xF6"], #  FABE 5EF6
        ["\xFA\xBF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xA5"], #  FABF 5FA5
        ["\xFA\xC0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xA3"], #  FAC0 5FA3
        ["\xFA\xC1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xAA"], #  FAC1 5FAA
        ["\xFA\xC2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xAD"], #  FAC2 5FAD
        ["\xFA\xC3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xAF"], #  FAC3 5FAF
        ["\xFA\xC4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xB1"], #  FAC4 5FB1
        ["\xFA\xC5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xB3"], #  FAC5 5FB3
        ["\xFA\xC6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xBE"], #  FAC6 5FBE
        ["\xFA\xC7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xD7"], #  FAC7 5BD7
        ["\xFA\xC8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"], #  FAC8 5FD6
        ["\xFA\xC9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xE2"], #  FAC9 5FE2
        ["\xFA\xCA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xEB"], #  FACA 5FEB
        ["\xFA\xCB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xEE"], #  FACB 5FEE
        ["\xFA\xCC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xF2"], #  FACC 5FF2
        ["\xFA\xCD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xF8"], #  FACD 5FF8
        ["\xFA\xCE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xB3"], #  FACE 60B3
        ["\xFA\xCF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xB1"], #  FACF 60B1
        ["\xFA\xD1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xAF"], #  FAD1 60AF
        ["\xFA\xD2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xBE"], #  FAD2 60BE
        ["\xFA\xD3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xC4"], #  FAD3 60C4
        ["\xFA\xD4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xB9"], #  FAD4 60B9
        ["\xFA\xD5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xD1"], #  FAD5 60D1
        ["\xFA\xD6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xD6"], #  FAD6 60D6
        ["\xFA\xD7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xD7"], #  FAD7 60D7
        ["\xFA\xD8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xDD"], #  FAD8 60DD
        ["\xFA\xD9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xE1"], #  FAD9 60E1
        ["\xFA\xDA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xE6"], #  FADA 60E6
        ["\xFA\xDB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xEA"], #  FADB 60EA
        ["\xFA\xDC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xEE"], #  FADC 60EE
        ["\xFA\xDD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xEF"], #  FADD 60EF
        ["\xFA\xDE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xC7"], #  FADE 60C7
        ["\xFA\xDF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xFC"], #  FADF 60FC
        ["\xFA\xE0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xA7"], #  FAE0 61A7
        ["\xFA\xE1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xB2"], #  FAE1 61B2
        ["\xFA\xE2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xBB"], #  FAE2 61BB
        ["\xFA\xE3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xBE"], #  FAE3 61BE
        ["\xFA\xE4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xAC"], #  FAE4 9FAC
        ["\xFA\xE5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xCC"], #  FAE5 61CC
        ["\xFA\xE6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xC6"], #  FAE6 61C6
        ["\xFA\xE7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xDF"], #  FAE7 61DF
        ["\xFA\xE8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xE0"], #  FAE8 61E0
        ["\xFA\xE9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xE9"], #  FAE9 61E9
        ["\xFA\xEA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xF8"], #  FAEA 61F8
        ["\xFA\xEB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xF4"], #  FAEB 65F4
        ["\xFA\xEC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xEF"], #  FAEC 61EF
        ["\xFA\xED",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xA3"], #  FAED 62A3
        ["\xFA\xEE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xA9"], #  FAEE 62A9
        ["\xFA\xEF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xAE"], #  FAEF 62AE
        ["\xFA\xF0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xB2"], #  FAF0 62B2
        ["\xFA\xF1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xB3"], #  FAF1 62B3
        ["\xFA\xF2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xB9"], #  FAF2 62B9
        ["\xFA\xF3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xB8"], #  FAF3 62B8
        ["\xFA\xF4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xD0"], #  FAF4 62D0
        ["\xFA\xF5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xD5"], #  FAF5 62D5
        ["\xFA\xF6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xD6"], #  FAF6 62D6
        ["\xFA\xF7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xD8"], #  FAF7 62D8
        ["\xFA\xF8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"], #  FAF8 62D9
        ["\xFA\xF9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xE2"], #  FAF9 62E2
        ["\xFA\xFA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"], #  FAFA 62E4
        ["\xFA\xFB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xEB"], #  FAFB 62EB
        ["\xFA\xFC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xF2"], #  FAFC 62F2
        ["\xFB\x40",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xEE"], # @ FB40 62EE
        ["\xFB\x41",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xFC"], # A FB41 62FC
        ["\xFB\x42",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xA4"], # B FB42 63A4
        ["\xFB\x43",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xFD"], # C FB43 62FD
        ["\xFB\x44",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xA6"], # D FB44 63A6
        ["\xFB\x45",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xBD"], # E FB45 63BD
        ["\xFB\x46",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xB7"], # F FB46 63B7
        ["\xFB\x47",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xB4"], # G FB47 63B4
        ["\xFB\x48",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xAE"], # H FB48 63AE
        ["\xFB\x49",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xB8"], # I FB49 63B8
        ["\xFB\x4A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xB6"], # J FB4A 9FB6
        ["\xFB\x4B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xD8"], # K FB4B 63D8
        ["\xFB\x4C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xDF"], # L FB4C 63DF
        ["\xFB\x4D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xE4"], # M FB4D 63E4
        ["\xFB\x4E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xEB"], # N FB4E 63EB
        ["\xFB\x4F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xE8"], # O FB4F 63E8
        ["\xFB\x50",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xF1"], # P FB50 63F1
        ["\xFB\x51",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xF8"], # Q FB51 63F8
        ["\xFB\x52",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xFD"], # R FB52 63FD
        ["\xFB\x53",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xB9"], # S FB53 9FB9
        ["\xFB\x54",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xA5"], # T FB54 64A5
        ["\xFB\x55",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xAD"], # U FB55 64AD
        ["\xFB\x56",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xAE"], # V FB56 64AE
        ["\xFB\x57",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xAF"], # W FB57 64AF
        ["\xFB\x58",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xB9"], # X FB58 64B9
        ["\xFB\x59",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xB4"], # Y FB59 64B4
        ["\xFB\x5A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xC2"], # Z FB5A 64C2
        ["\xFB\x5B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xCC"], # [ FB5B 64CC
        ["\xFB\x5C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xBA"], # \ FB5C 9FBA
        ["\xFB\x5D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xD0"], # ] FB5D 64D0
        ["\xFB\x5E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xCE"], # ^ FB5E 64CE
        ["\xFB\x5F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xD2"], # _ FB5F 64D2
        ["\xFB\x60",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xDF"], # ` FB60 64DF
        ["\xFB\x61",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xDB"], # a FB61 64DB
        ["\xFB\x62",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"], # b FB62 64E4
        ["\xFB\x63",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xE5"], # c FB63 64E5
        ["\xFB\x64",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xE8"], # d FB64 64E8
        ["\xFB\x65",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xEB"], # e FB65 64EB
        ["\xFB\x66",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xEC"], # f FB66 64EC
        ["\xFB\x67",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xF5"], # g FB67 64F5
        ["\xFB\x68",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xF6"], # h FB68 64F6
        ["\xFB\x69",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xFC"], # i FB69 64FC
        ["\xFB\x6A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xF8"], # j FB6A 64F8
        ["\xFB\x6B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xA8"], # k FB6B 65A8
        ["\xFB\x6C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xAE"], # l FB6C 65AE
        ["\xFB\x6D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xB2"], # m FB6D 65B2
        ["\xFB\x6E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xB9"], # n FB6E 65B9
        ["\xFB\x6F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xC3"], # o FB6F 65C3
        ["\xFB\x70",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xCA"], # p FB70 65CA
        ["\xFB\x71",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xCE"], # q FB71 65CE
        ["\xFB\x72",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xCF"], # r FB72 65CF
        ["\xFB\x73",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"], # s FB73 65D1
        ["\xFB\x74",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xD2"], # t FB74 65D2
        ["\xFB\x75",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xD8"], # u FB75 65D8
        ["\xFB\x76",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xE6"], # v FB76 65E6
        ["\xFB\x77",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xF6"], # w FB77 65F6
        ["\xFB\x78",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xF7"], # x FB78 65F7
        ["\xFB\x79",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xFA"], # y FB79 65FA
        ["\xFB\x7A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xA1"], # z FB7A 66A1
        ["\xFB\x7B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xA5"], # { FB7B 66A5
        ["\xFB\x7C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xAE"], # | FB7C 66AE
        ["\xFB\x7D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xB0"], # } FB7D 66B0
        ["\xFB\x7E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xBB"], # ~ FB7E 66BB
        ["\xFB\x80",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xC2"], #  FB80 66C2
        ["\xFB\x81",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xD0"], #  FB81 66D0
        ["\xFB\x82",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xD3"], #  FB82 66D3
        ["\xFB\x83",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xD4"], #  FB83 66D4
        ["\xFB\x84",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xFE"], #  FB84 66FE
        ["\xFB\x85",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xA2"], #  FB85 67A2
        ["\xFB\x86",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xA6"], #  FB86 67A6
        ["\xFB\x87",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xA4"], #  FB87 67A4
        ["\xFB\x88",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xB7"], #  FB88 67B7
        ["\xFB\x89",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xCC"], #  FB89 67CC
        ["\xFB\x8A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xDD"], #  FB8A 67DD
        ["\xFB\x8B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xE1"], #  FB8B 67E1
        ["\xFB\x8C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xEC"], #  FB8C 67EC
        ["\xFB\x8D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xEB"], #  FB8D 67EB
        ["\xFB\x8E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xF1"], #  FB8E 67F1
        ["\xFB\x8F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x67\xFB"], #  FB8F 67FB
        ["\xFB\x90",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xA5"], #  FB90 68A5
        ["\xFB\x91",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xAE"], #  FB91 68AE
        ["\xFB\x92",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xB2"], #  FB92 68B2
        ["\xFB\x93",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xDA"], #  FB93 68DA
        ["\xFB\x94",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xDD"], #  FB94 68DD
        ["\xFB\x95",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xF2"], #  FB95 68F2
        ["\xFB\x96",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xFC"], #  FB96 68FC
        ["\xFB\x97",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xF8"], #  FB97 68F8
        ["\xFB\x98",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xA3"], #  FB98 69A3
        ["\xFB\x99",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xAF"], #  FB99 69AF
        ["\xFB\x9A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xBE"], #  FB9A 69BE
        ["\xFB\x9B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xBF"], #  FB9B 69BF
        ["\xFB\x9C",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xBA"], #  FB9C 69BA
        ["\xFB\x9D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xC1"], #  FB9D 69C1
        ["\xFB\x9E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xC9"], #  FB9E 69C9
        ["\xFB\x9F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xD0"], #  FB9F 69D0
        ["\xFB\xA0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xD7"], #  FBA0 69D7
        ["\xFB\xA1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xDA"], #  FBA1 69DA
        ["\xFB\xA2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xE6"], #  FBA2 69E6
        ["\xFB\xA3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xFE"], #  FBA3 69FE
        ["\xFB\xA4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xA5"], #  FBA4 6AA5
        ["\xFB\xA5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xAA"], #  FBA5 6AAA
        ["\xFB\xA6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xAB"], #  FBA6 6AAB
        ["\xFB\xA7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xAD"], #  FBA7 6AAD
        ["\xFB\xA8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xB3"], #  FBA8 6AB3
        ["\xFB\xA9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xB2"], #  FBA9 6AB2
        ["\xFB\xAA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xB4"], #  FBAA 6AB4
        ["\xFB\xAB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xBE"], #  FBAB 6ABE
        ["\xFB\xAC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xC3"], #  FBAC 6AC3
        ["\xFB\xAD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xD0"], #  FBAD 6AD0
        ["\xFB\xAE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xCF"], #  FBAE 6ACF
        ["\xFB\xAF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xD5"], #  FBAF 6AD5
        ["\xFB\xB0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xD8"], #  FBB0 6AD8
        ["\xFB\xB1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xD9"], #  FBB1 6AD9
        ["\xFB\xB2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xE1"], #  FBB2 6AE1
        ["\xFB\xB3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xEB"], #  FBB3 6AEB
        ["\xFB\xB4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xFA"], #  FBB4 6AFA
        ["\xFB\xB5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xA3"], #  FBB5 6BA3
        ["\xFB\xB6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xC7"], #  FBB6 6BC7
        ["\xFB\xB7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xCA"], #  FBB7 6BCA
        ["\xFB\xB8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xCD"], #  FBB8 6BCD
        ["\xFB\xB9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xD1"], #  FBB9 6BD1
        ["\xFB\xBA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xD9"], #  FBBA 6BD9
        ["\xFB\xBB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xD8"], #  FBBB 6BD8
        ["\xFB\xBC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xDA"], #  FBBC 6BDA
        ["\xFB\xBD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xDC"], #  FBBD 6BDC
        ["\xFB\xBE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xE1"], #  FBBE 6BE1
        ["\xFB\xBF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xE0"], #  FBBF 6BE0
        ["\xFB\xC0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xDF"], #  FBC0 6BDF
        ["\xFB\xC1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xE5"], #  FBC1 6BE5
        ["\xFB\xC2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xE9"], #  FBC2 6BE9
        ["\xFB\xC3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xE7"], #  FBC3 6BE7
        ["\xFB\xC4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xF2"], #  FBC4 6BF2
        ["\xFB\xC5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xEE"], #  FBC5 6BEE
        ["\xFB\xC6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xF3"], #  FBC6 6BF3
        ["\xFB\xC7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xEF"], #  FBC7 6BEF
        ["\xFB\xC8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xF1"], #  FBC8 6BF1
        ["\xFB\xC9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xEC"], #  FBC9 6BEC
        ["\xFB\xCA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xED"], #  FBCA 6BED
        ["\xFB\xCB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xF6"], #  FBCB 6BF6
        ["\xFB\xCC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xA6"], #  FBCC 6CA6
        ["\xFB\xCD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xA8"], #  FBCD 6CA8
        ["\xFB\xCE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xA5"], #  FBCE 6CA5
        ["\xFB\xCF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xB1"], #  FBCF 6CB1
        ["\xFB\xD0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xAC"], #  FBD0 6CAC
        ["\xFB\xD1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xB8"], #  FBD1 6CB8
        ["\xFB\xD2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xB3"], #  FBD2 6CB3
        ["\xFB\xD3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xB7"], #  FBD3 6CB7
        ["\xFB\xD4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xB5"], #  FBD4 6CB5
        ["\xFB\xD5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xB0"], #  FBD5 6CB0
        ["\xFB\xD6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xCA"], #  FBD6 9FCA
        ["\xFB\xD7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xC3"], #  FBD7 6CC3
        ["\xFB\xD8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xBE"], #  FBD8 6CBE
        ["\xFB\xD9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xCD"], #  FBD9 6CCD
        ["\xFB\xDA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xC2"], #  FBDA 6CC2
        ["\xFB\xDB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xBF"], #  FBDB 6CBF
        ["\xFB\xDC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xC1"], #  FBDC 6CC1
        ["\xFB\xDD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xC4"], #  FBDD 6CC4
        ["\xFB\xDE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xC5"], #  FBDE 6CC5
        ["\xFB\xDF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xCA"], #  FBDF 6CCA
        ["\xFB\xE0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xCC"], #  FBE0 6CCC
        ["\xFB\xE1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xD8"], #  FBE1 6CD8
        ["\xFB\xE2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xE0"], #  FBE2 6CE0
        ["\xFB\xE3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xDF"], #  FBE3 6CDF
        ["\xFB\xE4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xE6"], #  FBE4 6CE6
        ["\xFB\xE5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xEF"], #  FBE5 6CEF
        ["\xFB\xE6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xF0"], #  FBE6 6CF0
        ["\xFB\xE7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xF1"], #  FBE7 6CF1
        ["\xFB\xE8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xF8"], #  FBE8 6CF8
        ["\xFB\xE9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xA2"], #  FBE9 6DA2
        ["\xFB\xEA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xA4"], #  FBEA 6DA4
        ["\xFB\xEB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xA5"], #  FBEB 6DA5
        ["\xFB\xEC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xA6"], #  FBEC 6DA6
        ["\xFB\xED",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xCD"], #  FBED 9FCD
        ["\xFB\xEE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xCE"], #  FBEE 9FCE
        ["\xFB\xEF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xAE"], #  FBEF 6DAE
        ["\xFB\xF0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xB0"], #  FBF0 6DB0
        ["\xFB\xF1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"], #  FBF1 9FCF
        ["\xFB\xF2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xB1"], #  FBF2 6DB1
        ["\xFB\xF3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xB2"], #  FBF3 6DB2
        ["\xFB\xF4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xC1"], #  FBF4 6DC1
        ["\xFB\xF5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xC2"], #  FBF5 6DC2
        ["\xFB\xF6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xC5"], #  FBF6 6DC5
        ["\xFB\xF7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xC6"], #  FBF7 6DC6
        ["\xFB\xF8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xC8"], #  FBF8 6DC8
        ["\xFB\xF9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xC9"], #  FBF9 6DC9
        ["\xFB\xFA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xCC"], #  FBFA 6DCC
        ["\xFB\xFB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xD9"], #  FBFB 6DD9
        ["\xFB\xFC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xD4"], #  FBFC 6DD4
        ["\xFC\x40",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xDC"], # @ FC40 6DDC
        ["\xFC\x41",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xD2"], # A FC41 9FD2
        ["\xFC\x42",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xE0"], # B FC42 6DE0
        ["\xFC\x43",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xE2"], # C FC43 6DE2
        ["\xFC\x44",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xE5"], # D FC44 6DE5
        ["\xFC\x45",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xE7"], # E FC45 6DE7
        ["\xFC\x46",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xD3"], # F FC46 9FD3
        ["\xFC\x47",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x9F\xD8"], # G FC47 9FD8
        ["\xFC\x48",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xF2"], # H FC48 6DF2
        ["\xFC\x49",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xF4"], # I FC49 6DF4
        ["\xFC\x4A",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6E\xAC"], # J FC4A 6EAC
        ["\xFC\x4B",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6E\xA1"], # K FC4B 6EA1
        ["\x81\xB8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xBA"], #  81B8 A2BA
        ["\x81\xB9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xBB"], #  81B9 A2BB
        ["\x81\xBA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xBC"], #  81BA A2BC
        ["\x81\xBB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"], #  81BB A2BD
        ["\x81\xBC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"], #  81BC A2BE
        ["\x81\xBD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"], #  81BD A2BF
        ["\x81\xC8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xCA"], #  81C8 A2CA
        ["\x81\xC9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xCB"], #  81C9 A2CB
        ["\x81\xCB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xCD"], #  81CB A2CD
        ["\x81\xCC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xCE"], #  81CC A2CE
        ["\x81\xCD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xCF"], #  81CD A2CF
        ["\x81\xCE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xD0"], #  81CE A2D0
        ["\x81\xDC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xDE"], #  81DC A2DE
        ["\x81\xDD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xDF"], #  81DD A2DF
        ["\x81\xDE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xE0"], #  81DE A2E0
        ["\x81\xE1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xE3"], #  81E1 A2E3
        ["\x81\xE2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xE4"], #  81E2 A2E4
        ["\x81\xE4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xE6"], #  81E4 A2E6
        ["\x81\xE5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xE7"], #  81E5 A2E7
        ["\x81\xE7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xE9"], #  81E7 A2E9
        ["\x81\xE8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xEA"], #  81E8 A2EA
        ["\x81\xF0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xF2"], #  81F0 A2F2
        ["\x81\xF1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xF3"], #  81F1 A2F3
        ["\x81\xF2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xF4"], #  81F2 A2F4
        ["\x81\xF3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xF5"], #  81F3 A2F5
        ["\x81\xF4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xF6"], #  81F4 A2F6
        ["\x81\xF5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xF7"], #  81F5 A2F7
        ["\x81\xF6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xF8"], #  81F6 A2F8
        ["\x81\xF7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xF9"], #  81F7 A2F9
        ["\x81\xFC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA2\xFE"], #  81FC A2FE
        ["\x84\x9F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xA1"], #  849F A8A1
        ["\x84\xA0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xA2"], #  84A0 A8A2
        ["\x84\xA1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xA3"], #  84A1 A8A3
        ["\x84\xA2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xA4"], #  84A2 A8A4
        ["\x84\xA3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xA5"], #  84A3 A8A5
        ["\x84\xA4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xA6"], #  84A4 A8A6
        ["\x84\xA5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xA7"], #  84A5 A8A7
        ["\x84\xA6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xA8"], #  84A6 A8A8
        ["\x84\xA7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xA9"], #  84A7 A8A9
        ["\x84\xA8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xAA"], #  84A8 A8AA
        ["\x84\xA9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xAB"], #  84A9 A8AB
        ["\x84\xAA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xAC"], #  84AA A8AC
        ["\x84\xAB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xAD"], #  84AB A8AD
        ["\x84\xAC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xAE"], #  84AC A8AE
        ["\x84\xAD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xAF"], #  84AD A8AF
        ["\x84\xAE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xB0"], #  84AE A8B0
        ["\x84\xAF",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xB1"], #  84AF A8B1
        ["\x84\xB0",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xB2"], #  84B0 A8B2
        ["\x84\xB1",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xB3"], #  84B1 A8B3
        ["\x84\xB2",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xB4"], #  84B2 A8B4
        ["\x84\xB3",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xB5"], #  84B3 A8B5
        ["\x84\xB4",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xB6"], #  84B4 A8B6
        ["\x84\xB5",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xB7"], #  84B5 A8B7
        ["\x84\xB6",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xB8"], #  84B6 A8B8
        ["\x84\xB7",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xB9"], #  84B7 A8B9
        ["\x84\xB8",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xBA"], #  84B8 A8BA
        ["\x84\xB9",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xBB"], #  84B9 A8BB
        ["\x84\xBA",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xBC"], #  84BA A8BC
        ["\x84\xBB",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xBD"], #  84BB A8BD
        ["\x84\xBC",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xBE"], #  84BC A8BE
        ["\x84\xBD",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xBF"], #  84BD A8BF
        ["\x84\xBE",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\xA8\xC0"], #  84BE A8C0
        ["\x87\x85",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x73\xEA"], #  8785 73EA
        ["\x87\x86",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x73\xEB"], #  8786 73EB
        ["\x87\x87",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x73\xEC"], #  8787 73EC
        ["\x87\x88",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x73\xED"], #  8788 73ED
        ["\x87\x89",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x73\xEE"], #  8789 73EE
        ["\x87\x8D",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x72\xF5"], #  878D 72F5
        ["\x87\x8E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x72\xF6"], #  878E 72F6
        ["\x87\x8F",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x72\xF7"], #  878F 72F7
        ["\x87\x7E",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x73\xF8"], # ~ 877E 73F8
        ["\x87\x93",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xB8"], #  8793 6FB8
        ["\x87\x94",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xA2"], #  8794 6FA2
        ["\x87\x98",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xB7"], #  8798 6FB7
        ["\x87\x99",'keis83','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xBA"], #  8799 6FBA
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__DATA__
