# Generated by default/object.tt
package Paws::LexRuntimeV2::ConfidenceScore;
  use Moose;
  has Score => (is => 'ro', isa => 'Num', request_name => 'score', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntimeV2::ConfidenceScore

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntimeV2::ConfidenceScore object:

  $service_obj->Method(Att1 => { Score => $value, ..., Score => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntimeV2::ConfidenceScore object:

  $result = $service_obj->Method(...);
  $result->Att1->Score

=head1 DESCRIPTION

Provides a score that indicates the confidence that Amazon Lex V2 has
that an intent is the one that satisfies the user's intent.

=head1 ATTRIBUTES


=head2 Score => Num

A score that indicates how confident Amazon Lex V2 is that an intent
satisfies the user's intent. Ranges between 0.00 and 1.00. Higher
scores indicate higher confidence.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntimeV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

