# Generated by default/object.tt
package Paws::ApiGateway::MutualTlsAuthenticationInput;
  use Moose;
  has TruststoreUri => (is => 'ro', isa => 'Str', request_name => 'truststoreUri', traits => ['NameInRequest']);
  has TruststoreVersion => (is => 'ro', isa => 'Str', request_name => 'truststoreVersion', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApiGateway::MutualTlsAuthenticationInput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApiGateway::MutualTlsAuthenticationInput object:

  $service_obj->Method(Att1 => { TruststoreUri => $value, ..., TruststoreVersion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApiGateway::MutualTlsAuthenticationInput object:

  $result = $service_obj->Method(...);
  $result->Att1->TruststoreUri

=head1 DESCRIPTION

If specified, API Gateway performs two-way authentication between the
client and the server. Clients must present a trusted certificate to
access your custom domain name.

=head1 ATTRIBUTES


=head2 TruststoreUri => Str

An Amazon S3 resource ARN that specifies the truststore for mutual TLS
authentication, for example, C<s3://bucket-name/key-name>. The
truststore can contain certificates from public or private certificate
authorities. To update the truststore, upload a new version to S3, and
then update your custom domain name to use the new version. To update
the truststore, you must have permissions to access the S3 object.


=head2 TruststoreVersion => Str

The version of the S3 object that contains your truststore. To specify
a version, you must have versioning enabled for the S3 bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApiGateway>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

