# Generated by default/object.tt
package Paws::Synthetics::CanaryTimeline;
  use Moose;
  has Created => (is => 'ro', isa => 'Str');
  has LastModified => (is => 'ro', isa => 'Str');
  has LastStarted => (is => 'ro', isa => 'Str');
  has LastStopped => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Synthetics::CanaryTimeline

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Synthetics::CanaryTimeline object:

  $service_obj->Method(Att1 => { Created => $value, ..., LastStopped => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Synthetics::CanaryTimeline object:

  $result = $service_obj->Method(...);
  $result->Att1->Created

=head1 DESCRIPTION

This structure contains information about when the canary was created
and modified.

=head1 ATTRIBUTES


=head2 Created => Str

The date and time the canary was created.


=head2 LastModified => Str

The date and time the canary was most recently modified.


=head2 LastStarted => Str

The date and time that the canary's most recent run started.


=head2 LastStopped => Str

The date and time that the canary's most recent run ended.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Synthetics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

