# Generated by default/object.tt
package Paws::Kendra::DataSourceSyncJobMetrics;
  use Moose;
  has DocumentsAdded => (is => 'ro', isa => 'Str');
  has DocumentsDeleted => (is => 'ro', isa => 'Str');
  has DocumentsFailed => (is => 'ro', isa => 'Str');
  has DocumentsModified => (is => 'ro', isa => 'Str');
  has DocumentsScanned => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::DataSourceSyncJobMetrics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::DataSourceSyncJobMetrics object:

  $service_obj->Method(Att1 => { DocumentsAdded => $value, ..., DocumentsScanned => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::DataSourceSyncJobMetrics object:

  $result = $service_obj->Method(...);
  $result->Att1->DocumentsAdded

=head1 DESCRIPTION

Maps a batch delete document request to a specific data source sync
job. This is optional and should only be supplied when documents are
deleted by a data source connector.

=head1 ATTRIBUTES


=head2 DocumentsAdded => Str

The number of documents added from the data source up to now in the
data source sync.


=head2 DocumentsDeleted => Str

The number of documents deleted from the data source up to now in the
data source sync run.


=head2 DocumentsFailed => Str

The number of documents that failed to sync from the data source up to
now in the data source sync run.


=head2 DocumentsModified => Str

The number of documents modified in the data source up to now in the
data source sync run.


=head2 DocumentsScanned => Str

The current number of documents crawled by the current sync job in the
data source.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

