## Stability

Our top priority is to provide a reliable development framework that important
work is based upon. As such, we promise to put stability and backward
compatibility first in the development of this project.

Version 1.00 of this distribution is considered stable. Any changes to the API
that result in changes to the test suite will be preceded by a three (3) month
notice period, with the following exceptions:

* Changes necessary to maintain compatibility with:

  - [Do](https://metacpan.org/pod/Do)
  - Other major dependencies
  - Perl +5.14

* Contradictions between the implementation and documentation

* Features explicitly documented as "experimental" or "unstable"

* Changes to the documentation

## Versioning

This distribution uses the standard Perl two component number versioning scheme
but increments it based on [semver](https://semver.org) semantics. For example,
a version number of `1.23` is treated as the semver-based version number
`1.2.3`.

## Releasing

This distribution and its source code is maintained and released on GitHub,
with the CPAN serving as the canonical repository. This means that hotfixes,
changes in documentation, and experimental features will be released on GitHub,
only shipping stable releases to the CPAN.

## Questions, Suggestions, Issues/Bugs

Please post any questions, suggestions, issues or bugs to the [issue
tracker](../../issues) on GitHub.
