# NAME

Pluto - Functional Programming

# ABSTRACT

Functional Scripting for Perl 5

# SYNOPSIS

    package Cosmos;

    use Pluto;

    call(string('hello world'), 'titlecase');

    # Hello World

# DESCRIPTION

This package enables functional programming for Perl 5 via indirect routine
dispatching and dependency injection, operating in a way that plays nicely with
third-party libraries without having to switch over to object-oriented
programming.

# WHY

Perl is a multi-paradigm programming language that supports functional
programming, but, Perl has an intentionally limited standard library with an
emphasis on providing library support via the CPAN which is overwhelmingly
object-oriented. This makes developing in a functional style difficult as
you'll eventually need to rely on a CPAN library that requires you to switch
over to object-oriented programming.

# LIBRARIES

This package uses type constraints from:

[Types::Standard](https://metacpan.org/pod/Types::Standard)

# AUTHOR

Al Newkirk, `awncorp@cpan.org`

# LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the terms
of the The Apache License, Version 2.0, as elucidated in the ["license
file"](https://github.com/iamalnewkirk/pluto/blob/master/LICENSE).

# PROJECT

[Wiki](https://github.com/iamalnewkirk/pluto/wiki)

[Project](https://github.com/iamalnewkirk/pluto)

[Initiatives](https://github.com/iamalnewkirk/pluto/projects)

[Milestones](https://github.com/iamalnewkirk/pluto/milestones)

[Contributing](https://github.com/iamalnewkirk/pluto/blob/master/CONTRIBUTE.md)

[Issues](https://github.com/iamalnewkirk/pluto/issues)
