# ABSTRACT: Data::Object Method/Function Signatures for Perl 5
package Data::Object::Signatures;

use 5.14.0;
use strict;
use warnings;

use parent 'Type::Tiny::Signatures';

our @DEFAULTS = @Type::Tiny::Signatures::DEFAULTS = 'Data::Object::Library';

our $VERSION = '0.01'; # VERSION

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Object::Signatures - Data::Object Method/Function Signatures for Perl 5

=head1 VERSION

version 0.01

=head1 SYNOPSIS

    use Data::Object::Signatures;

=head1 DESCRIPTION

Data::Object::Signatures is a subclass of L<Type::Tiny::Signatures> and derives
its functionality to provide method and function signatures with support for
all the standard L<Type::Tiny> type constraints, as well as a few additional
type constraints provided by L<Data::Object::Library>.

=head1 AUTHOR

Al Newkirk <anewkirk@ana.io>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Al Newkirk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
