# Generated by default/object.tt
package Paws::ECS::FSxWindowsFileServerVolumeConfiguration;
  use Moose;
  has AuthorizationConfig => (is => 'ro', isa => 'Paws::ECS::FSxWindowsFileServerAuthorizationConfig', request_name => 'authorizationConfig', traits => ['NameInRequest'], required => 1);
  has FileSystemId => (is => 'ro', isa => 'Str', request_name => 'fileSystemId', traits => ['NameInRequest'], required => 1);
  has RootDirectory => (is => 'ro', isa => 'Str', request_name => 'rootDirectory', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECS::FSxWindowsFileServerVolumeConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECS::FSxWindowsFileServerVolumeConfiguration object:

  $service_obj->Method(Att1 => { AuthorizationConfig => $value, ..., RootDirectory => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECS::FSxWindowsFileServerVolumeConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthorizationConfig

=head1 DESCRIPTION

This parameter is specified when you are using Amazon FSx for Windows
File Server
(https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html) file
system for task storage.

For more information and the input format, see Amazon FSx for Windows
File Server Volumes
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html)
in the I<Amazon Elastic Container Service Developer Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AuthorizationConfig => L<Paws::ECS::FSxWindowsFileServerAuthorizationConfig>

The authorization configuration details for the Amazon FSx for Windows
File Server file system.


=head2 B<REQUIRED> FileSystemId => Str

The Amazon FSx for Windows File Server file system ID to use.


=head2 B<REQUIRED> RootDirectory => Str

The directory within the Amazon FSx for Windows File Server file system
to mount as the root directory inside the host.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

