use strict;
use warnings;

package Printer::ESCPOS::Manual;

# PODNAME: Printer::ESCPOS::Manual
# ABSTRACT: Manual for Printing POS Receipts using L<Printer::ESCPOS>
#
# This file is part of Printer-ESCPOS
#
# This software is copyright (c) 2015 by Shantanu Bhadoria.
#
# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
#
our $VERSION = '0.013'; # VERSION

1;

__END__

=pod

=head1 NAME

Printer::ESCPOS::Manual - Manual for Printing POS Receipts using L<Printer::ESCPOS>

=head1 VERSION

version 0.013

=head1 SYNOPSIS 

=head2 BASIC USAGE

     use Printer::ESCPOS;
 
     # Create a Printer object, Initialize the printer.
     my $device = Printer::ESCPOS->new(
         driverType     => 'Serial'
         deviceFilePath => '/dev/ttyACM0'
     );
 
     # All Printers have their own initialization 
     # recommendations(Cleaning buffers etc.). Run 
     # this command to let the module do this for you.
     $device->printer->init();
 
 
     # Prepare some data to send to the printer using
     # formatting and text commands
     $device->printer->bold(1);
     $device->printer->text("Heading text\n");
     $device->printer->bold(0);
     $device->printer->text("Content here\n");
     $device->printer->text(". . .\n");
 
 
     # Add a cut paper command at the end to cut the receipt
     # This command will be ignored by your printer if it 
     # doesn't have a paper cutter on it 
     $device->printer->cutPaper(); 
 
 
     # Send the Prepared data to the printer.
     $device->printer->print();

=head1 PRINTING TO YOUR PRINTER IN THREE STEPS

L<Printer::ESCPOS> uses a three step mechanism for sending the data to the Printer i.e initialization, preparation of data to send to the printer, and finally sending the prepared data to the printer. Separation of preparation and printing steps allows L<Printer::ESCPOS> to deal with communication speed and buffer limitations found in most common ESCPOS printers.

=head2 INITIALIZATION

=head3 USB PRINTER

The B<USB> I<driverType> allows you to talk to a printer using its vendorId and productId as params.

     my $device = Printer::ESCPOS->new(
         driverType => 'USB',
         vendorId   => 0x1504,
         productId  => 0x0006,
     );

Optional parameters:

The driver uses a default I<endPoint> value of 0x01. To get valid values for I<endPoint> for your printer use the following command:

     shantanu@shantanu-G41M-ES2L:~$ sudo lsusb -vvv -d 1504:0006 | grep bEndpointAddress | grep OUT
             bEndpointAddress     0x01  EP 1 OUT

Replace 1504:0006 with your own printer's vendor id and product id in the above command

=head1 AUTHOR

Shantanu Bhadoria <shantanu@cpan.org> L<https://www.shantanubhadoria.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Shantanu Bhadoria.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
