#!/usr/bin/perl -w
# based on fl12.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 49) * 9 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer2, "frame is layer II");
	ok($frame->has_crc, "frame has CRC");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 192, "bitrate");
	is($frame->sample, 48000, "sample rate");
	ok((($_-1) % 5 == 0) ? $frame->stereo : $frame->joint_stereo, "stereo xor joint stereo");
	is($frame->modext, (0, 0, 3, 2, 1)[$_ % 5], "modext");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
 D1fUffUD3""$          PÜ9˜Ϭӏ4͸ۍ۝w ߿}}{www[mϚֶ 47l`zkσű|浭~WOyS%2U=s=PZaL.`{H(9k9ݽo[m_>هBL?J]>f?<
x"EliX9DlϡmdF[o݌]7fM&ZL G#;Yq]X9s˙OfSA6h|Y:Ush	1;@NXjwLğ=eRi.dHZ;j7kQK8"Y8(;mq|zե*s/Gx=hF&iC]FEt$G:s̃,dYЂ΄.ЋI%,̆ű.bDkyrwʝT3jLڢEcǱ%\SB'ϝZpD3DDD33323HI    UUUU_Jjqu<<<qs=u=Y+Y+>EX;6i*rY,fJNY19W+'W+'!CtIj޷#)V+vU R'{'m8;"e2jFc2Yx[kd`V`VCnC\n6yVʥJ!əsIəsH9uۺڶ`&S-&ulB,e0C0C𠨑Q6kf:οm+mm5<7<7nvż[+J**N;4眗f
f
3Nffn"ȶ-&j4j|8iwwz$LJ¶(r\ȤMMu[5)QZQZ[NSU6NDn7r 5d`d`MZ۵#He08Zm]mc87@d)H\.6# `~U3TUDC333"I    UUUU@Faq<ϼ=}o323532358N2).,-`u:*d1hą qq쵽-oB).ض(T+9qʥUP @ll]=N
dIl[qKM Æ&u͢mu͢m[LUFc1r2mV2Shu2ShuDQ*+22<Ajیs*N"rfːfːVCD32"ձ6)q7-0U[U[8l-;HTX׹rC޼g^gRTKJ#q6@F_qс1qс137#n\;#L2f2ir7[,Nv.nv.l	-K.2*f	ruԪ\q;88#.Ȱ+,%<zQq8&%s3rs3ECP
 DLlq*Vn PU3fUeTDDF    0{ynvyy8yy8qbqbZ򖵄XHQ**MQ`066vv3|v3|GQ	cdI..Ʊ@,,j]j]+UՆhfݗ
r1pU?/6ڊ`ڊ`Tm"!\v8dKTLhR#̽T'd0}w}wn9ێ~ARb$bj&бB*°6q/؀[/؀bɸmUY8H=qt %ՄVDTBcTTBc]χsY
TDBj$F]͸|@͸|B:j֙m*Jl)
Cd7 d!Z!Z赶efX[ᜠ=KjKA$nrFnrp|3]S2N)'yWY8DSkPLbsQbs]F`iS,	qS:n4 ۺyXլլ_o
ݦMuXWp쵢=

 @zIDDwgfUYcd   yy~8y98yyGR`]GR`])3Txs;.H̩$i"մZU]rU]r׹|gYr'%L\0Ү6ycyc1Fb)B+A"iZ<6BBT^E.X ̵25	.M
δ@zδ@zc2kǢ}))F 1{v֛Qy"9xQy"9V-nn:0KZ'EK̟)nc.HNc.HKǗ&y,)"U@pV6pV68q5[@P&q[49j,SSi8юYSFTщ[zp*]M-51Vبfe!fe!A4|"FF]F8Ԯ%c,*"
FeᗒFe-[S 5IӋ3CG4KX,;tե%E5HE5H)Fr2L&B]Mk+5OPZA  
D"DUDCD333$I        8뮺y:y8yy0("0("s`-qxvѴb+rܔJ$qHֵp̸p̺{TVm.,c1وDYǁǁ6il)1F$r)֩NrTf{Tf{܃ح+EP/'T*a0JsԞqSԞqSةSa4eU]v]]ʑlce1S[k9AI9AIE΋Q@4@qm8iRރz
zyV	r\Jd!,kM&N(d!J>I>ISI2L,i$Imlƴ\\`+_{We4)j[^"PYJ֭o-o-mhQ_F[VֳYۍFֵkkuF2F2ܸ9pYFr'"Xim&m61!cE&}cE&|MJ)i0+
h`x2\HAkka p3"UUD3C333lI    TUUUTau<qu<q;\q^.OJ^.OJDW9l
qrSmJc-e.H|%.H|*y)aRF[hS9f!Hf!HEDQh+2"	tJ%d1ۄ-fifo4ifo5ٝJ+Rgynۼn5#&i9jAPezAPe{LAB"H\De2EU1J?DM]?DM]GxFe&RWu*[n'r8M;{mDI"7mDI"4LI,I"HoBVmmN*Ռ,(,DB%KT|Vm(l6NM&ֵ,,vwf3#21Kضg3NcI$S%~SfCNSfCEY-ݝhYln]F{nUU3>Yjp,HBۍ
NFjFj$VaKiV*'T)T+$  `33UfUDD333I   U@_UUF<q׼u=<qu5	魈LQk l+quI[-ܸlkT 2* qSd6I9St&rZ^WBqї-T|4Hvkp'h%D@t:J$
9x$sە^2 (QXefBZMd[]"'nRU]ɴKkNeFU1ZI$M9w_kgW{I%Qji/ӑ҉NXmշ&֭r!lʳ+2IDJҴ(W)[-ܻ3sfٟÙeRnf.-lZۄ@;f8m9s˟uE[;>X$'QmVT/"o1wxTuEY1%	AmZVBI$XXTp槜5-R	;v:6l,Zi4&qj`ekS[([eJT]_V[qFZM&M8 PiODCUfUUDTF$   ZS瞷~y~9888~8~2LHvbC/IĜJg*DTWUQkl3j!W!e˧֙V-lW|LȍcZ!7,ĸE]^%-lµ*{\0X6Yi;M%LNҍ('T%Bk&ee<K=Qw7Tn6n=N|kƼLA`I`&)1psEÃ"jlJؚdC<g9t *Xm9JobGS{66mhB֭kWDaO$P&tD*ɩ,ᝯu1{Gtmk\&rg,(Z2	beH\BH㥯MՔ+(Se6*"+JAHmc{pAۅGcƩfZ%lS=e&Rn۹3(x4jqTFl"E{5/j_H@jzmUc)ODF%yh\F]l[	!oVR6p@<UDffeU[#D  0κy;yyw~8yy~g,_g,_U~ܖ9,oXJڻمYbیc3bیc3}_sLYh bS$qi!3E{733KRU:s"N'@@.߾k߾k)gOnȵl^tm8-z֑<V*"8j"8kjکaժU'B̍x-VZs㰜=~Ǭk~ǬkhEK1rSeώ GFrFGFrFk:Ur'Luvva'],f֒Q#$Q#$v);VcaÌ}=ҠZx:b~Fb~F4d
2m%ZJk}]oD˴RIg
%g
$B#:)SjݷUgQu7Gazh=󘻀Ð󘻀\:	.=
*	mn*^*Z8R-Z|;`em&_f D33UDC3"""i"I        y뮺~8ߝy瞷~88kPOkPOP6-C!eZ4i4Qj]5iA4A4'B,G!0<jh+Vrct˷t˷YEYA\Zq
ֳZtu/@\:C 8#$N[\p\itltl1DaqgjT8b?~Zo1rr"o1rr"4WhC0L&#qV
'eWZeWZ3fW#avXZq8\jֵЊЊsRӽ;,8ө>qͣB16$_6$_:Zt*4i6sLmz#*7!ב)ב)LDK%R+bػV[-7Ϝm|RkT\T\Sy&xE"b#QToEBm$#dydyhXдM3en7H6KϘ*kZp&33UDUD3""3I"I    UUTTau;\;=u]u=\<q3Ѭ'3Ѭ'GTtpl@+$	+@JjY	~C ~C yV
Qj!2
{P,yժD#ZSdSdʭR*[̯;v|=]j84>G884>G8LJĬBP1$X:tqM:vZorosZhqf_̴R"XZ-n
k2s2s b+PSU4tMbd2*T*e2qsaa7qpWl6+Rrڵ#U]VVx
P4H8OZTalTVlTW4sFmvWd6-*mԩ^gH758M758MJNT`&mOALHЁ||
k&C0;LTȚ'Ŋժa0%-QKQK
 	Qx>s.\k׫RQ(jkZ `B33UUD3D3D3m2   UUUU^_Fq]=[˜ ˜ W5s8t@*#(n7OSŢm<6I;6I5ZeXVfldYIH6s9U
>R
>TJĩ3#2#"1l[;iֳ!iqtI&qtI&l4BlP9rwD-v-vôOW5s/Q5hZfѴl6ZLy$$hVxI0RHbBSS:=ZFi=ZFC1TED3;C;d^/+R9>dv!O\!O\Yb!MGX6Il[-M,:ᦍ:ᦍ-HtLp
)
Dv:޷'q9hUhU\w'rvjYc(ʯW6#XV]
/]
/1CDMYT<CA7xV+*ʑI?OcvQcvQ\UY@bIѴo9JF P?U3fUUUDD6    Z0yyy8y89yiA%eiA%eJ3RtLC8]ef`u*Д6<Fi.N_i.N_^bf&h$F blgVs[h_h_cR#;=r*^gzjQE#Xk?Xk>')R\QEH'=c.)3wwtwwtnJtIsRmJʬey2	9MFaOjҦ*gItX`xUU*rjoQuequeuXaVGypݭ]ٺnj3u;]&5ej5ej:ێ4JĬyHtbe$H;fݎfݎwFtdI|.袈3䲴j%TU%TU"Nxѝ>sk6]pi8Fѩ%T"11A1Bl$rG}d1%bUZUu3
4ѭ?=j?=jUMlI֕yWWEtYe|7˓N- @ifDfffdYD   
yy889y8yD]
D]
ac-[J뭸zlsu&%v,,Ϩ3E
{F0mX:9I8xw(nxw(nc M3|K4Bp Kdʸdʸۀ	zj]A7݉y!̰mm8d)et2<hF.[(X];];Ǚr<ˊ	c|8}h@UDtƫQararK]AOqvJ"{Jn%uꎑ'euꎑ'sY;w!KΧ`q]۾][]۾]TZ%J}%9Klc^c,*XE/c|&E/c|#
(U;0sfRܶ|夓e"
8{o{o*)T[Љ>DlA"INwla= la= VKK=	Sb2/F2 %v  U"3DUDDC33"lI        𯪪88߮;9㎺8}Ds}DsI$FqNnFo5E$ ut'kt'kusG4%$F!߷3v;>qw	_q_qi6!HzWt:湇MZkZ-@-@i,˚F887QĢVlZJKJKm9SaXfa&J\!`޽#k@?@?OdP!I"Hh[m3KEltډltډUeVmI(m[#;2i7ъдШdL;#fZ16Jm:sdpdpE^UZ!\4BN	6Ap?qp?uʒ$+r+cnM&n7-qUe*e*VEdqKt)e]W[cz`H%NiZk[ˏWˏW+C7ĬIp\3Yq8m*[Qp͞U3UUD3333"I"@    UUUUU_F\qq<<=zi4:zi4;Yh2)TK(8ruJIr鐄RRQfЩ*2./U,S)O+VCYߩYߩP6jq.\VqMlj@٥Q٥QչMnSKj6Sd%V)Y,#ϱc
3`g6ۢ3`g6ۣt1/xo,6D"Hd,K5͎)U{kU{kO#,.ʬĴqrL{{{{0L32-u	PIȤPH#-35i$	i$	Ω;NLѬh-FpT)BF:W1:W1
TBQ
а2
hzM"
xb5yt(
>*k%I
Lu A9FĬ9FĬ6,ΎMtJM\,Zm6+)SĜĜM
B%"S0s
Ѵpc
RO,b`_D3UUDDD3C"m"@  UUUUUTaq<q\u\s<q\q\q;<5.\,!*Ķ-c8re2><VldxHHvhyWNSgtWuSWQ&/	;DKLєbڶkZ*O'1+11'Xى=9sa!'RLs5	HnFhZvKG.Z9t\8c1
ygAbصZ&,dZ|Ǳ =ӳgItyXa|(Z[ia#lc-8cm"*DS:DBQ"RJjjP&bs%A鎙l[յ_j6ӥnU22nf)Ss'2D$Bmhl6f2f+c`#< 3,qf{:
tZIugV-bıa~qTE*=K2^h|b̲S%4K<"Y\rhMá2>4M	iNrVUMޢAFG#_|xL<PQU3UUfDDDH    
Z08~߾88㎷~y98:>W>W`mYdDIdKFJ2
dYAs"M7M5IRx!"N$K| +Y@V32=F32=F\*^lZk9!HZfb]-F	+x+xJ:Qf&bȽqrcITU3TyԃB;xԃB;x&`vS7bv(K*8A+TRZ(eRBTeRBWr,܋**$bZ!3g$0#PKZ{N`{N`T*
wwwkHe` C:f-SXFٝ(ݝrNSt#;ꆡ$~o~oQnH]^={
B4j3HB_t_tWi݅NQ3l%aX`FGr7LR7LXr(ˬbv'6hl
b(\Qfyk@ԗ9k@ԗjZ\5]5Zesbŕet]lz0< @DDwveV[#d   S8y8瞺y988랹N3N3VxkgBJ1Lkd57579-$Z.kk9t=E")z(q|q|!nB)EfmH>*.P[+9F[+9Es1g%ogw!r*E݊v'#Rv'#RDΉc{Yqp:E:x.[2929GiA&bI^nu3iW1Ocؙ(abab.<pa.IeݰuZ`PH;4WaI"_!"_!z&8qYz6y
rMj>HvDۊTd}Td}-k٨ZjMg'C)CzV7̜7L8ޥjgmb)&l9)-:2O:2O AUY*iZaZ&q*$(*!Djc,jc.ed?l~z:-OBab@X  1f3DDDDD"C"HI        98y8~~yy8*}J4tŚ&,ҦmDۦ%IQEFFIf5a5lMk#\sz,ϛ歫jʲ;r߾%)5|({_
$ahE{%qr]WYe^%.sZWZ*cS)3*)
%rXT8"EslZx9A09Ht @űv]ű$!mG.[Q˱zCw7rkRTjڶG"sp01WQiY:NiZUgH%}zAb Z8bwZ
F4&+8$#cn,[aB*+YZ)޵Qeu]Uqm_>Vn[Rl[-xEf-K,Άa(4*R^)RZo`V`'8i62̶麃u]YJiS)Zթ	P/ɝLL8;ƭmeY:ĜHc)ZpHf3DUD33"3"I"I    UTUTTa=uq]u=u|y<pGt5f]
sΞs2++Rfu;CuF:lc̭U!+Ua|^뻻e;"hr8I7oqu2B/x"n3e6b1S׭k[
l\a -lTɪ:ef'Uҟ>N#"R>ÙƶqӅ^-;ü*JR)͏ӧ"%xQ-33Vc59j*
ICiCÆݫ[[nkiۤ 9c[+V+Rݻ2eziJ3:Φd7S!,y^@LΓlRwrC@(Lez@޲8TYE13Lt:M>pLTkZٶX6m+JSI~_,!(LC,yU4k,c0R$;ݼ5Z̳;!BGXbg˒rUq_(CƼj꺚)JՖ#!!  ``e3DUUDDC33H   UUUUUUF;|q<q<<\qY*Eߗ+oޥYe%IHGTuYC+KUnُ1 dq$[~uS(Jζk-qeVlU"dL ޲ePtm=єf)b!sQ4Mwv8qVѬl8
e{a.㋸6ҥ*LDDQ@#y0U%ͤcU*jeXlvcHH5T*M(vnWnf3ru1#`$K"l1S&ɨR+U3
8P~<OMhMt8ٙѝv]T[XDM]'bl(:÷Bh-BL4)R6-)Rlr9
4P&"Q1@r躘Hq\SLFF3m;k,~JAgkVvEXꮭ 4ðAZiU4>SjI-^Z]٭rVK
nBӸH/rAyw#R2Ʊd
)
Dy%m| Pf3eUUD3DF    Z0ʹm08y뮺y8㎸8SHظSHظ
hwD$D+¹dVژ.y=o.y=o
l-A$hmkɩ;1ɩ;1a"-]<(s0j-nDnDhCERI㔹IjP`Tٴ5+rg+rg|֫͌6&l!YpG|*G|*Q4\囪C>gfs5ZZ9KJQ.ӇC/cӇC/cK\VIH*D4DJֵ̣m48K8K.Ǳv=92;:3zCEtsI:gβ:gβ|O_U	34J*̳fY#IM)N*)N*ͦp	B-&i`fNNhnnŬ
\CT08<^#ɫRZ}$}$3Ex
ĭJ;gQ/L" @3ffTEI$    S+N|ߟ7yy8~yy4ߎO4ߎOT;Rx'wcIDٔpYwkLF"Le{RLe{W{wy	HRPf1mxkMJ'kZ'kZTsEQ^媋U1oˇ`IP]}Y8SA)SA)Ͳt:ǌxT|fo5*7Bb
A
<
A
<Ȇרc21c2ohe-3]TW\BMZڵ~hFfBgUjR
IaIa!ྤHSA
784F.ls-C-DtQS!rͷdtEIXWڧWڧPECyX
F#>MFKhӟd/3d/;2Zjy!>As!S[zsZ7e-}+ٻ}+ٻ"@xh3%'	5i4Z8L\	VKAG;AG;hRYU3ff͇$ȐWmzDZ7W  33D3"3""!$@        0ȟr'yy88瞺8nBGnBGCd!QHen7#Fu:Ŋg2Muq$6Muq$6Zq-]e[m+_t:Va+XA-rT͹*f`"q:zr9+q8|(!"3"3	%mѪ5uQ(J%&`P~ހ5~ހ5:*I|nvaŋU*֒:]MQ]MQ7oCR鞢EtQ-СpNu)Ec Ec :#VЙIR$&-u:zְc4th4th@dQ$r4&DR)"p׽+?+?ck#1
Э1tN\e2\4i[孭&0֊(&0֊(d=2T	&$DP I$\"$,$,bl1TyT"1p8xXƵ&%ؤ|&%ؤ|[HIסzEiZPp`J%>~0! p#3C333"""$@    UKUUUF<=u\<;%a{a{
ܦܭiQ	kQ(A!p&t!!{o\{o]Qy:&m)ms8xϟ-jSss)"6s)"6tN:JJn(	
Rg	IcrЅrЀ
YcF10R!="H+V=T!Q9Q94%&(BRbePhԚN'|A΄*+oj+oP}.IOn6N4Z8֬	&㱣㱣}eZ~'U%Z.	i:浭wF\g;wF\g;p̂-7"ӉxXi1q

jֵEC;EC4IDJ4I T
Tj=޽.^!І؁qb؁qcfM26m"jemT!*^D%.o.ouwY=DL.i(B!<m津!B-:oZ?R-:oZ?[/0rj7țMqTT=+`X"DU33"""$   U_U_Ta%[o[yq|q\pIvIv'N;mSifU)T3-k*Vߛ4ߛ4ĢA5EkU6ą
V6Y*ܞ*ܞZqP*!L4 Glc.uT<xT<x'%OKMRD#eEN3)nn~TH*Si9U5U:D[.uAsG PAsG Q3DBdfT.dJ=Lv
kvɻ0;ɻ0;iəA21%*fD"QYlՈlՈ2e/WAꎢSqD(G:TQۜt:t:kGl,&֎XHp80O
N&Nwjk܉UK։UKמn=bq8.,]&+[eHCeHCх2%
6"1r8:Ts\'\&]@
lL$z^wjPC"DDDDDC34H    
4yy:瞽yyy8ýýĲ+dV	CT"ƱdX3vD+hD́r[g!r[g2R%D[p. KBnC`I0Vn°'I'JiV$GXututṔś"Ͳ:2T"vT^JAuŬuŬӟ=է>.{o}!ܒg" E| E|U)īZR7`MDrKSebVvqlql[uXLNG0u45WJY`xF)pxF)tpwH,kטԵz AJVL_L✇_L✇2Ɩd=,1b44$MA_XAhAhUB:).:
t,6
±S'P2M-U-Tx2 ew1c[6~_̳T@zkqXkqX`A44hi>)QdDABв[ @:DUeTD6    MDM8yy8뮺8ばnZA!nZA%10o	܅iX
k'2څ7xǪǪJHR@ӳf*Z(*S#`e7#T)4#T)4L^Wi*bMSj&Ը{
ߏLPݮRDwRDtw>E#y)5bjHDCDA8SS"WzմrZer:^N(m%%vo*3{V1c78
?/Х/J/Х/JȈ:VDDq)>Rq(0i'oA ;4A ;4տӶ:WҿQ2]R>Ae:c]\ ]\ M5	iH6XvgÇ2$p(.(iJ(iJ1FjW)27'b8jEfAhfAhI@EN.kWZ϶6,iby!Vq!`Vq!`8^M*aA++= dc3D3D33"!$@        AMy88㎺yyBBxГT-gĨ[\$JE"p\,K%m!p81]-T-V[wgp*Y܇"g3j5뵭(p&0Z7`zn!Vŵmr9ӫTBy`mx#%G2K,qo[,zJmD!Z0!%A$[IbIכ7)X
s5FfJ HF2膕f9!Y@_Ҳw'z
q8hZTnhь_ZM:S|<|*lxT"MVk9ad-ɎwkZэ@+aPJI/@l_ٖhCf
eF1T)WUǸA!Q] ]Uܗ&R.b2W+Tfs1yol z7vԅ!݊E+ׄ
kszgTn)6m#eqbXLzVN(p[ZŻGprn9܂73)ofRCqnIR21* pxDD333""$@    T__UUJڬ6a>s<|w<s=u\Ұ$;aWlÛ>}L7
fR(iQrZsή
\ %K,/T(7A!+tlֽۜ%b űACIP74iǱ%mV!{de=C,4zE;$d
̳,]*U6lck9s[p
9"lcHH,).].MVs9,!,kYET`>U7lِ+e={Z9=ĥ]eJ@x8>~T1bBn6vHrb֐[Zgr41q|D\_+wJjE"i5رbR9ӛ1)bR#z'$"2ݐ Y)0dЃNW򲜩N*gӲe^$q۶{rQ>휕Xg%g)AV+q$$H\Z$#Z	'3<$T.-[4!גXl )Nt `@33DDC33""H    TUUUA5<qq<q<qq ,%½%½ ,+?NezzNrJח%4h`4h`|wmҔ&tj+yvj[;!n&]&]`<޷4q&iܹXA\g-q{{֝iQ%v\8>92Y)9r"RHOh	?Ch	?Cng1`"d\a0Q$r++CAQJAQJ:CmmEiZ9DHtܯrjZGZG9ÚM&p,$r<^/e߿dqƣye8iye8i rG$B!T&]fLn7Jk׵'#-Rԥ-RԤВI#a8u6R
byuWU"Hj54?~",l==W>=W>ԝIƉ"I )j5.ݭY>Sl9MtHoHoj6hZ"IׯRPAU3DUD33&    
۝0 ny8瞺㎺yy8j/&f:/&f7EhL:3s7jڶW6deHRٔaUU}c@U*1JҺR#rMvs}_vΒ94I9Β94I5L(eI(~:'+Z4Mԁy^~\k]nEk]nEFɲJTo"B̞rAPqai <ݎ fvg7Mcp4y9|Ԇ1Ԇ1rnPbHAtH+lפuz׎zb|ThVhvZָT)pK{MknfQfQ+s(DQa"Qh}tHiLkhݼkhݸ1If)#1.DKb0[wZ% lV`bLȢbLȧB_$GugV`[- aէmo]o]BP(JHRxWqqXJ$ZjVaGaGذ{
fıHdaBiKĄ @UDUU4I@   

]DWQ89yyy8㎺㎷wa$<$<0Gzswgx!} Hj~cP!$xcP!$xB.njoǰ|Sq@M분+e9\e9\\-u(RC9':paJV	[:V~
G~
G4puSGQjzVH)ءi&/[6&/[6vڢm,o[HnuhYLR樳FFOנFOjo&5MS+h#-bU!HeWYWY303?Fѻlyaۄx^,),)?U\&k[H˷R(/bO4O4ĝ<I|D54VwE8W+X^IOKMOKMo\:ۆÊ"i`IGk#-\USTƫEƫE5
YozWJkb{JVM_B/%_B/%r+@"[ņʲmɠ9'   """C""""HI        }Vꪹ
@yzx{8y62S062S1aX]veRz`$B5ZhA#7eL#7eLŤKT'n,.ZҖsvX،s1!;6p4Qz<{B!Rt::Ӊt::ӌ\pݻZ@.<ztLkmdZ///_p	Sʺm2e,X6S@1`*Tkי2aHv;v2O64$cKhˈj<tɸ3^9apΛΛM܌ȩJ*XPHp絘zKUFKUG[ڵV:HJ3LJ4l"!J4l"!䍌NHdn<ogtٻmg8.wdůwdů+>6~a¥Ii,ÃfÙ2$GRP^ܢ^ܤ[%`EV>3cX0`&|kZ pP""23"C"I"I    KUUUU),K6aq<=u*U,B~ Z?Qh;ZY.[70X|1{O=tx!쳣Ţ%"YpRsJ^&X[r4իZĢTÝ)M,>pJdZ%J>N>|X@%*nMLTbj`䒣]b˘u,8X+^e:t%,RfѹZi:>Zd5HيSZD<r9NL{YeU*lNt\*VS(ѧ|lRVB`EN*
2 T(N[H"Dn Mż!n-%fVh{kZ!(+uTĈ֩JeCנ'w<~삵5Z8,.\xk[-sꠘT|+Gb!,Xqm6qTn?^kPVb\z&4[ƥCjrB6޽~j֥ŷpf-8[j-].~yl͚Z `"w "33"DCm   A@TU_1vpa[q]uq<sfX/ř`2x4Ϲ3H48jr,2tn6;\r%&ܳDE9\fcn7!
jn
*lyWd;v~4iHsLcow$+!`x6:rI"U+Rm"q'+kod	ֈb\CanAd&٭[Vj8i<*0z<$3#sJŋmɲi"2.54:$!3ϙqimJ@-Qxntc#2Y9m0mF	1jjR*fN)J+fl6r3eqouQIbQ*udF#F篱o|5+M9ryĢP2,}r9.52#,ȏEM
z*n8um,[[-Ĉ%z-"GKI-$:(nESud<+(ShJ$nuP	;2U3DDF    y0=y瞺8㎺yW
ªC,C,LW+^MlEr6«$
N[[E*Z*ֶqf]i1h⊪V"Shy1khy1n=SL?9S,'!0:٣EQr,
V܍V܍
C!֫[)>ϮRjKBxk݇E݇Evds/y	#.	{.i7#MB*ʦ\Z\ZZ-RJ`X"ủHinXV9U**7'1pH=<
8.6URaG0@돏0@돏&u]tR(γlIK'ڼxV	.ڼxV	]3z.
k3SQpCk\S@D4GjGjJh?u4֨lK֧0 ۆ;%Î		7
ӇkBzBKT\M;[N֛GܛGݲcp`?V @3D4U]cd   y9A88y~y8롴M{gP	0uY쌡ld*Yjk&\H;,H;.0W{lґ+^]@6DsxÀsx2/(RpQ7u䰓2(FUŊUřhww=&(auړu-LbZķS/S-$i	ВFjQ7ڪy@#LPǌik6!ik6!7}zwש65	SWfڱ*ambɼXgeXgemw=fhc7fdn?]n?]䦯Sqj7&ǀ£Y[Sm-^e-^eO	0[0k(I
mճ2ճ4_AE#"RҤN:a3(aR9:rtw$ow$oӆ@8o	kMsٻ%7UǱ%[IΦΦy
eGM"cH׶ȫhT  ч"3f  "3CI"I$       

8rcާwy;yyy㈤R!c zB	7wF}N
Fnv7ÀUj$
;E*U#ki9ҥ$5K<x9kYn&6eJ[fT!C%	˒M	i$HU1%:4{CsǴ79/!?~C;~`,5Tzw!R엧z|[%| @ zah>}-ld*/rhv@mQy8ۺ[&P4m6rfÞ1M+|aȿ/C_M$E݇bt1R"DKãl:U\?Pq+X2B9{gYS
%<APc6:Ƿ5kTɤr5<z!
R֧l׫6zj3a6fmJNpT/߄9Du	ڝPדG'(Q*U&6blY:tTBBTJ<ݨ3ٵfyj,9¼Îխ p""U  ""m$   U_UUUA]u\piq\\Ϝ<n+U=-Kǆv*Eǆv*DȯN":iKRp @mP+V+VN;t cLE
q֬B5̲Y`2ރ\8>\82:-Hkd~N%zilm$in3˰n3;` ͔+fIZj/
P
P#Tw$Q܎q2j2cȤNW,Hj=Hj=_Ma~5?~Fmժc
Ǭk;]]ˏ2;Y"JMjEBpOgObxuS^"T8r9(E+vI2:L~ne~ne
7a!ml!
zZg3Cs77XiYX7XiY X2`BG^nÆeS>w7}w7}|A֡&M!+um?/ݵm~Uݵm~S)-g5k׮-`33DD   !CmH   AAUUUq\Sֲ<u\q\m7^.<6<6<7
VV'aN`6b,yi^¯yi^Ƴ+Yh4ɚE*ib/1{&&I!$kڱj2rYpKHAlAlJZ%I-Cn܊Děm,k
GH=H=WEH+ۍpiFI%%9spl7Zm%ZnOEf6/u6/w
`p2)Z
-9ssv_v_i,hݗR԰i&H5R!*{&!RG`QPg`QPf/Dr>-޶1ې/==.vz汶mlڛ
p/2okpv(pv([qN-eh7*yЍHՆ'LL$
sΔL$
sΒn1:!7"XQ#bP{33D  &H   Pyߣ19tNz8888:vgf[Եkk go gow$u؂iݍ
¤*\ʹ.r\G	G	H9H8J+426%d	e](QΊ5s5s##}$M<)AGM-25oVm =%%||p?QºPE*}pVhdJMԛ((y!y!FWF"ԊK+2UZYDlkld55gfBH}]ԓ#WWM&M&wz+m2brvKhB	U6ߪ%RU[L\'rG'rD.<4(.<4+%)Z9dTnüE[*lUA\/A\/.w@m[*ajxzz`D`D 6GqUQщ4er,er,`#ɃFKf@DUU9$  
 z8z]m0άs~y8y:瞺.iۚwJZV2ЖWCր؅-M>jM8-,,'»>D:އ(]-H̷.gJnӱf5[VVdFئO$8'ic	[6mRT9F𜯅
,"8%pѹZPr_a=z>&Xv'*f9S1H?GŔl֤)po%J"+DW<O%dY"8DةΞ}("iъbGQXVd͉cq6U~$q3rǩSE#HGZ:O#:P
 Xt*A3Z$2;mm8͠'Xݼ/Bs$npSD#G0EdZ"
U|)gݪA$ǎ2^½g{㪸rC?&"^R$H:̤sRTT`/
w˫c][Js  ڼ33Dff     Z$      
瞷y1L瞺㎺を)+j={CqlnY8nY:#;gtsX1fLdɷuJ4!#7KE7KEVBJBr\c|gPu L26mvvdvd21F6-s~tJ6mdIQR8\8]K)}u(mIdFGσѡUHIpIrY69
PEXU:jtѩ\bż)ّѼ)ّ^pΉkXXŉfhF)1+II/Hc֔iFxgr,\9p$I9uy9u{)|e/1%kT5]Qu`Y@LK DK F6×ծqbf$M$JHUpuM"~u"~tvEMȩ+ۧyyة{ƑbbbbQJ5bւXJu[׃0܅E5܅E6US#+[9m%!'0pj33Dfwݪ     	$  UTU<q<ta(t\5P.W|Ċ6ͅ1n9ͥ_\-m<S;S\bj(ޖ7,B%+b\?]p1ɵ[+2$HHc@bpX*5FfўmEHq.UdIV)S؋T"<=9Ӛ"ڤX9kk/I[·.˵oD
@nt!?U8xAT9s;
('A<̹t˙cLa鵚Mü;Oj2GΆ]m@YHh)fnYJΕqLMq>A&ܲm)g:,HF[*Ƭ|޹:ktkxYާ;Ԭnf	/v)5vhL0OIjgSSF
jhtK7D/LE7iΎ+3:4&s'*j\Iɉ59)HXtřbg#,L9Єލyۙyu.VM)dxBo ֭d`cc33DffD̈       UTϜs<<p"FĊq"p5CTN	C&F}8@p+wHI{$&4[E2LdR8k0ak:c8KȣoHQlƼk--ZU:
jIAOq'MJhe)SZGҥ[Jo[E:춊t1IXORJ/(K
s0<Zn6xyyT<~tMiF':T=]Eu|'ZѺry`k:9ß],Y6,.
'El"X5z4sUIT=ruۍ7| N8@5ƚM[)2k9J!hXPׅ 
ZH4MO#o^;z&tgHڍQZu6$I>OKQo7S]͛lىNDf
Uګ%8Jir]'w
Nx[Zq˭I(
IZaN9͗/EG" +xD"6'P3DDffwD     8yyRԤ4ޭcX~ygFf=v6)#)#Յ	ôJC4o_4}/Az11	7:y7:~UIrvd}*VOD$lH5c
Y7M8U38U3{S+*aT#Fs^!!u-DhbhcMi@TeO&s|.\#idYX!_G7Q_G7S:_}´+<y5{ڷtW=t1JQGʽQGP?B!1+0YJҕ1q㽛f-QV-QW'p#<<y"V)
x¿@oM@oM *a+U۱;v`>b&^}R<^}R<EcIm[C'U*(A.\C0f-cdTQl]SdTQl]Wclla̛:]X+qwÞÞ_@hy.s$zHwj:WLufAA A  
