# This file was autogenerated.

=head1 NAME

hydrogen-topic-string.t - unit tests for Hydrogen::Topic::String

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

=cut

use 5.008001;
use strict;
use warnings;
use Test2::V0 -target => "Hydrogen::Topic::String";

isa_ok( 'Hydrogen::Topic::String', 'Exporter::Tiny' );

my %EXPORTS = map +( $_ => 1 ), @Hydrogen::Topic::String::EXPORT_OK;

subtest 'append' => sub {
    ok exists(&Hydrogen::Topic::String::append), 'function exists';
    ok $EXPORTS{'append'}, 'function is importable';
    my $exception = dies {
        local $_;
        $_ = 'foo';
        Hydrogen::Topic::String::append( 'bar' );
        is( $_, 'foobar', q{$_ is 'foobar'} );
    };
    is $exception, undef, 'no exception thrown running append example';
};

subtest 'chomp' => sub {
    ok exists(&Hydrogen::Topic::String::chomp), 'function exists';
    ok $EXPORTS{'chomp'}, 'function is importable';
};

subtest 'chop' => sub {
    ok exists(&Hydrogen::Topic::String::chop), 'function exists';
    ok $EXPORTS{'chop'}, 'function is importable';
};

subtest 'clear' => sub {
    ok exists(&Hydrogen::Topic::String::clear), 'function exists';
    ok $EXPORTS{'clear'}, 'function is importable';
    my $exception = dies {
        local $_;
        $_ = 'foo';
        Hydrogen::Topic::String::clear();
        note $_; ## nothing
    };
    is $exception, undef, 'no exception thrown running clear example';
};

subtest 'cmp' => sub {
    ok exists(&Hydrogen::Topic::String::cmp), 'function exists';
    ok $EXPORTS{'cmp'}, 'function is importable';
};

subtest 'cmpi' => sub {
    ok exists(&Hydrogen::Topic::String::cmpi), 'function exists';
    ok $EXPORTS{'cmpi'}, 'function is importable';
};

subtest 'contains' => sub {
    ok exists(&Hydrogen::Topic::String::contains), 'function exists';
    ok $EXPORTS{'contains'}, 'function is importable';
};

subtest 'contains_i' => sub {
    ok exists(&Hydrogen::Topic::String::contains_i), 'function exists';
    ok $EXPORTS{'contains_i'}, 'function is importable';
};

subtest 'ends_with' => sub {
    ok exists(&Hydrogen::Topic::String::ends_with), 'function exists';
    ok $EXPORTS{'ends_with'}, 'function is importable';
};

subtest 'ends_with_i' => sub {
    ok exists(&Hydrogen::Topic::String::ends_with_i), 'function exists';
    ok $EXPORTS{'ends_with_i'}, 'function is importable';
};

subtest 'eq' => sub {
    ok exists(&Hydrogen::Topic::String::eq), 'function exists';
    ok $EXPORTS{'eq'}, 'function is importable';
};

subtest 'eqi' => sub {
    ok exists(&Hydrogen::Topic::String::eqi), 'function exists';
    ok $EXPORTS{'eqi'}, 'function is importable';
};

subtest 'fc' => sub {
    ok exists(&Hydrogen::Topic::String::fc), 'function exists';
    ok $EXPORTS{'fc'}, 'function is importable';
};

subtest 'ge' => sub {
    ok exists(&Hydrogen::Topic::String::ge), 'function exists';
    ok $EXPORTS{'ge'}, 'function is importable';
};

subtest 'gei' => sub {
    ok exists(&Hydrogen::Topic::String::gei), 'function exists';
    ok $EXPORTS{'gei'}, 'function is importable';
};

subtest 'get' => sub {
    ok exists(&Hydrogen::Topic::String::get), 'function exists';
    ok $EXPORTS{'get'}, 'function is importable';
    my $exception = dies {
        local $_;
        $_ = 'foo';
        is( Hydrogen::Topic::String::get(), 'foo', q{Hydrogen::Topic::String::get() is 'foo'} );
    };
    is $exception, undef, 'no exception thrown running get example';
};

subtest 'gt' => sub {
    ok exists(&Hydrogen::Topic::String::gt), 'function exists';
    ok $EXPORTS{'gt'}, 'function is importable';
};

subtest 'gti' => sub {
    ok exists(&Hydrogen::Topic::String::gti), 'function exists';
    ok $EXPORTS{'gti'}, 'function is importable';
};

subtest 'inc' => sub {
    ok exists(&Hydrogen::Topic::String::inc), 'function exists';
    ok $EXPORTS{'inc'}, 'function is importable';
};

subtest 'lc' => sub {
    ok exists(&Hydrogen::Topic::String::lc), 'function exists';
    ok $EXPORTS{'lc'}, 'function is importable';
};

subtest 'le' => sub {
    ok exists(&Hydrogen::Topic::String::le), 'function exists';
    ok $EXPORTS{'le'}, 'function is importable';
};

subtest 'lei' => sub {
    ok exists(&Hydrogen::Topic::String::lei), 'function exists';
    ok $EXPORTS{'lei'}, 'function is importable';
};

subtest 'length' => sub {
    ok exists(&Hydrogen::Topic::String::length), 'function exists';
    ok $EXPORTS{'length'}, 'function is importable';
    my $exception = dies {
        local $_;
        $_ = 'foo';
        is( Hydrogen::Topic::String::length(), 3, q{Hydrogen::Topic::String::length() is 3} );
    };
    is $exception, undef, 'no exception thrown running length example';
};

subtest 'lt' => sub {
    ok exists(&Hydrogen::Topic::String::lt), 'function exists';
    ok $EXPORTS{'lt'}, 'function is importable';
};

subtest 'lti' => sub {
    ok exists(&Hydrogen::Topic::String::lti), 'function exists';
    ok $EXPORTS{'lti'}, 'function is importable';
};

subtest 'match' => sub {
    ok exists(&Hydrogen::Topic::String::match), 'function exists';
    ok $EXPORTS{'match'}, 'function is importable';
    my $exception = dies {
        local $_;
        $_ = 'foo';
        if ( Hydrogen::Topic::String::match( '^f..$' ) ) {
          note 'matched!';
        }
    };
    is $exception, undef, 'no exception thrown running match example';
};

subtest 'match_i' => sub {
    ok exists(&Hydrogen::Topic::String::match_i), 'function exists';
    ok $EXPORTS{'match_i'}, 'function is importable';
    my $exception = dies {
        local $_;
        $_ = 'foo';
        if ( Hydrogen::Topic::String::match_i( '^F..$' ) ) {
          note 'matched!';
        }
    };
    is $exception, undef, 'no exception thrown running match_i example';
};

subtest 'ne' => sub {
    ok exists(&Hydrogen::Topic::String::ne), 'function exists';
    ok $EXPORTS{'ne'}, 'function is importable';
};

subtest 'nei' => sub {
    ok exists(&Hydrogen::Topic::String::nei), 'function exists';
    ok $EXPORTS{'nei'}, 'function is importable';
};

subtest 'prepend' => sub {
    ok exists(&Hydrogen::Topic::String::prepend), 'function exists';
    ok $EXPORTS{'prepend'}, 'function is importable';
    my $exception = dies {
        local $_;
        $_ = 'foo';
        Hydrogen::Topic::String::prepend( 'bar' );
        is( $_, 'barfoo', q{$_ is 'barfoo'} );
    };
    is $exception, undef, 'no exception thrown running prepend example';
};

subtest 'replace' => sub {
    ok exists(&Hydrogen::Topic::String::replace), 'function exists';
    ok $EXPORTS{'replace'}, 'function is importable';
    my $exception = dies {
        local $_;
        $_ = 'foo';
        Hydrogen::Topic::String::replace( 'o' => 'a' );
        is( $_, 'fao', q{$_ is 'fao'} );
      
        $_ = 'foo';
        Hydrogen::Topic::String::replace( qr/O/i => sub { return 'e' } );
        is( $_, 'feo', q{$_ is 'feo'} );
    };
    is $exception, undef, 'no exception thrown running replace example';
};

subtest 'replace_globally' => sub {
    ok exists(&Hydrogen::Topic::String::replace_globally), 'function exists';
    ok $EXPORTS{'replace_globally'}, 'function is importable';
    my $exception = dies {
        local $_;
        $_ = 'foo';
        Hydrogen::Topic::String::replace_globally( 'o' => 'a' );
        is( $_, 'faa', q{$_ is 'faa'} );
      
        $_ = 'foo';
        Hydrogen::Topic::String::replace_globally( qr/O/i => sub { return 'e' } );
        is( $_, 'fee', q{$_ is 'fee'} );
    };
    is $exception, undef, 'no exception thrown running replace_globally example';
};

subtest 'reset' => sub {
    ok exists(&Hydrogen::Topic::String::reset), 'function exists';
    ok $EXPORTS{'reset'}, 'function is importable';
};

subtest 'set' => sub {
    ok exists(&Hydrogen::Topic::String::set), 'function exists';
    ok $EXPORTS{'set'}, 'function is importable';
    my $exception = dies {
        local $_;
        $_ = 'foo';
        Hydrogen::Topic::String::set( 'bar' );
        is( $_, 'bar', q{$_ is 'bar'} );
    };
    is $exception, undef, 'no exception thrown running set example';
};

subtest 'starts_with' => sub {
    ok exists(&Hydrogen::Topic::String::starts_with), 'function exists';
    ok $EXPORTS{'starts_with'}, 'function is importable';
};

subtest 'starts_with_i' => sub {
    ok exists(&Hydrogen::Topic::String::starts_with_i), 'function exists';
    ok $EXPORTS{'starts_with_i'}, 'function is importable';
};

subtest 'substr' => sub {
    ok exists(&Hydrogen::Topic::String::substr), 'function exists';
    ok $EXPORTS{'substr'}, 'function is importable';
};

subtest 'uc' => sub {
    ok exists(&Hydrogen::Topic::String::uc), 'function exists';
    ok $EXPORTS{'uc'}, 'function is importable';
};

done_testing; # :)
