### reader component
### 1. is a subclass of a Component (== OnePassBitmapAlgorithmComponent.pm)

use parent 'OnePassBitmapAlgorithmComponent';

sub new {
    my $class = shift;

    $self = SUPER::OnePassBitmapAlgorithmComponent->new(BagElement1);

    ### 1. matrixbitmap is temporary output of the functor for example
    $self = { matrixbitmap => undef, index => -1, };
    
    bless $self, $class;
}

### returns matrix of the loaded bitmap
sub getBitmap {
  my $self = shift;

  return $self->{matrixbitmap};
}

sub addLoadPNG {
    my ($self) = @_;
    
    my $loader = MatrixBitmapLoader->new;

    ### NOTE : uses WithClassOp, sets index (the base class only contains 1 idx)
    my $self->{index} = $self->addFunctor(OnePassFunctorWithClassOp->new(&$loader->loadPNGFile));
    ### sets class on which this operates
    $self->indexFunctor($i)->setClassOp(\$loader);
}

### This Component only has one function in the functors list
sub executeAllFunctors {
    my ($self, $filename) = @_;

    my $result = $self->indexFunctor($self->{index})->do($filename);
    
    $self->indexFunctor($self->{index})->setResult($result);

}
    
1;
