/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.SequenceInstr;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ItemType;

public class XSLMapEntry
extends StyleElement {
    Expression key = null;
    Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return MapType.ANY_MAP_TYPE;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String keyAtt = null;
        String selectAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("key")) {
                keyAtt = atts.getValue(a);
                this.key = this.makeExpression(keyAtt, a);
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (keyAtt == null) {
            this.reportAbsence("key");
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.key = this.typeCheck("key", this.key);
        this.select = this.typeCheck("select", this.select);
        if (this.select != null) {
            NodeInfo kid;
            boolean foundChild = false;
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((kid = kids.next()) != null) {
                if (kid instanceof XSLFallback) continue;
                foundChild = true;
            }
            if (foundChild) {
                String errorCode = "XTSE3280";
                this.compileError("An xsl:map-entry element with a select attribute must be empty", errorCode);
            }
        }
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.select == null) {
            this.select = this.compileSequenceConstructor(exec, decl, false);
            this.select = this.select.simplify();
        }
        Expression exp = MapFunctionSet.getInstance().makeFunction("entry", 2).makeFunctionCall(this.key, this.select);
        if (this.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/strictStreamability")) {
            exp = new SequenceInstr(exp);
        }
        return exp;
    }
}

