use Unicode::Collate::CJK::Pinyin;
+{
   overrideCJK => \&Unicode::Collate::CJK::Pinyin::weightPinyin,
   entry => <<'ENTRY', # for DUCET v6.0.0
0101      ; [.15A3.001C.0002.0101] # LATIN SMALL LETTER A WITH MACRON
0061 0304 ; [.15A3.001C.0002.0101] # LATIN SMALL LETTER A WITH MACRON
0100      ; [.15A3.001C.0008.0100] # LATIN CAPITAL LETTER A WITH MACRON
0041 0304 ; [.15A3.001C.0008.0100] # LATIN CAPITAL LETTER A WITH MACRON
00E1      ; [.15A3.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
0061 0301 ; [.15A3.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
0061 0341 ; [.15A3.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
00C1      ; [.15A3.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0301 ; [.15A3.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0341 ; [.15A3.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
01CE      ; [.15A3.001E.0002.01CE] # LATIN SMALL LETTER A WITH CARON
0061 030C ; [.15A3.001E.0002.01CE] # LATIN SMALL LETTER A WITH CARON
01CD      ; [.15A3.001E.0008.01CD] # LATIN CAPITAL LETTER A WITH CARON
0041 030C ; [.15A3.001E.0008.01CD] # LATIN CAPITAL LETTER A WITH CARON
00E0      ; [.15A3.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
0061 0300 ; [.15A3.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
0061 0340 ; [.15A3.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
00C0      ; [.15A3.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0300 ; [.15A3.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0340 ; [.15A3.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0113      ; [.15FF.001C.0002.0113] # LATIN SMALL LETTER E WITH MACRON
0065 0304 ; [.15FF.001C.0002.0113] # LATIN SMALL LETTER E WITH MACRON
0112      ; [.15FF.001C.0008.0112] # LATIN CAPITAL LETTER E WITH MACRON
0045 0304 ; [.15FF.001C.0008.0112] # LATIN CAPITAL LETTER E WITH MACRON
00E9      ; [.15FF.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
0065 0301 ; [.15FF.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
0065 0341 ; [.15FF.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
00C9      ; [.15FF.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0301 ; [.15FF.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0341 ; [.15FF.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
011B      ; [.15FF.001E.0002.011B] # LATIN SMALL LETTER E WITH CARON
0065 030C ; [.15FF.001E.0002.011B] # LATIN SMALL LETTER E WITH CARON
011A      ; [.15FF.001E.0008.011A] # LATIN CAPITAL LETTER E WITH CARON
0045 030C ; [.15FF.001E.0008.011A] # LATIN CAPITAL LETTER E WITH CARON
00E8      ; [.15FF.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
0065 0300 ; [.15FF.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
0065 0340 ; [.15FF.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
00C8      ; [.15FF.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0300 ; [.15FF.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0340 ; [.15FF.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
00EA 0304 ; [.15FF.0021.0002.00EA] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
00CA 0304 ; [.15FF.0021.0008.00CA] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
0065 0302 0304 ; [.15FF.0021.0002.00EA] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
0045 0302 0304 ; [.15FF.0021.0008.00CA] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
1EBF      ; [.15FF.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0301 ; [.15FF.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0341 ; [.15FF.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
1EBE      ; [.15FF.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0301 ; [.15FF.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0341 ; [.15FF.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
00EA 0301 ; [.15FF.0022.0002.1EBF] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00EA 0341 ; [.15FF.0022.0002.1EBF] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00CA 0301 ; [.15FF.0022.0008.1EBE] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00CA 0341 ; [.15FF.0022.0008.1EBE] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00EA 030C ; [.15FF.0023.0002.00EA] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
00CA 030C ; [.15FF.0023.0008.00CA] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
0065 0302 030C ; [.15FF.0023.0002.00EA] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
0045 0302 030C ; [.15FF.0023.0008.00CA] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
1EC1      ; [.15FF.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0300 ; [.15FF.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0340 ; [.15FF.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
1EC0      ; [.15FF.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0300 ; [.15FF.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0340 ; [.15FF.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
00EA 0300 ; [.15FF.0024.0002.1EC1] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00EA 0340 ; [.15FF.0024.0002.1EC1] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00CA 0300 ; [.15FF.0024.0008.1EC0] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00CA 0340 ; [.15FF.0024.0008.1EC0] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00EA      ; [.15FF.0025.0002.00EA] # LATIN SMALL LETTER E WITH CIRCUMFLEX
0065 0302 ; [.15FF.0025.0002.00EA] # LATIN SMALL LETTER E WITH CIRCUMFLEX
00CA      ; [.15FF.0025.0008.00CA] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
0045 0302 ; [.15FF.0025.0008.00CA] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
1EC5      ; [.15FF.0025.0002.00EA][.0000.004E.0002.0303] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
1EC4      ; [.15FF.0025.0008.00CA][.0000.004E.0002.0303] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
1EC3      ; [.15FF.0025.0002.00EA][.0000.0064.0002.0309] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC2      ; [.15FF.0025.0008.00CA][.0000.0064.0002.0309] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC7      ; [.15FF.0025.0002.00EA][.0000.0070.0002.0323] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
1EC6      ; [.15FF.0025.0008.00CA][.0000.0070.0002.0323] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
012B      ; [.1680.001C.0002.012B] # LATIN SMALL LETTER I WITH MACRON
0069 0304 ; [.1680.001C.0002.012B] # LATIN SMALL LETTER I WITH MACRON
012A      ; [.1680.001C.0008.012A] # LATIN CAPITAL LETTER I WITH MACRON
0049 0304 ; [.1680.001C.0008.012A] # LATIN CAPITAL LETTER I WITH MACRON
00ED      ; [.1680.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
0069 0301 ; [.1680.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
0069 0341 ; [.1680.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
00CD      ; [.1680.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0301 ; [.1680.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0341 ; [.1680.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
01D0      ; [.1680.001E.0002.01D0] # LATIN SMALL LETTER I WITH CARON
0069 030C ; [.1680.001E.0002.01D0] # LATIN SMALL LETTER I WITH CARON
01CF      ; [.1680.001E.0008.01CF] # LATIN CAPITAL LETTER I WITH CARON
0049 030C ; [.1680.001E.0008.01CF] # LATIN CAPITAL LETTER I WITH CARON
00EC      ; [.1680.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
0069 0300 ; [.1680.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
0069 0340 ; [.1680.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
00CC      ; [.1680.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0300 ; [.1680.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0340 ; [.1680.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
006D 0304 ; [.16F4.001C.0002.006D] # <LATIN SMALL LETTER M, COMBINING MACRON>
004D 0304 ; [.16F4.001C.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING MACRON>
1E3F      ; [.16F4.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
006D 0301 ; [.16F4.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
006D 0341 ; [.16F4.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
1E3E      ; [.16F4.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0301 ; [.16F4.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0341 ; [.16F4.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
006D 030C ; [.16F4.001E.0002.006D] # <LATIN SMALL LETTER M, COMBINING CARON>
004D 030C ; [.16F4.001E.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING CARON>
006D 0300 ; [.16F4.001F.0002.006D] # <LATIN SMALL LETTER M, COMBINING GRAVE ACCENT>
006D 0340 ; [.16F4.001F.0002.006D] # <LATIN SMALL LETTER M, COMBINING GRAVE TONE MARK>
004D 0300 ; [.16F4.001F.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING GRAVE ACCENT>
004D 0340 ; [.16F4.001F.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING GRAVE TONE MARK>
006E 0304 ; [.1702.001C.0002.006E] # <LATIN SMALL LETTER N, COMBINING MACRON>
004E 0304 ; [.1702.001C.0008.004E] # <LATIN CAPITAL LETTER N, COMBINING MACRON>
0144      ; [.1702.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
006E 0301 ; [.1702.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
006E 0341 ; [.1702.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
0143      ; [.1702.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0301 ; [.1702.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0341 ; [.1702.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
0148      ; [.1702.001E.0002.0148] # LATIN SMALL LETTER N WITH CARON
006E 030C ; [.1702.001E.0002.0148] # LATIN SMALL LETTER N WITH CARON
0147      ; [.1702.001E.0008.0147] # LATIN CAPITAL LETTER N WITH CARON
004E 030C ; [.1702.001E.0008.0147] # LATIN CAPITAL LETTER N WITH CARON
01F9      ; [.1702.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
006E 0300 ; [.1702.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
006E 0340 ; [.1702.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
01F8      ; [.1702.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0300 ; [.1702.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0340 ; [.1702.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
014D      ; [.1724.001C.0002.014D] # LATIN SMALL LETTER O WITH MACRON
006F 0304 ; [.1724.001C.0002.014D] # LATIN SMALL LETTER O WITH MACRON
014C      ; [.1724.001C.0008.014C] # LATIN CAPITAL LETTER O WITH MACRON
004F 0304 ; [.1724.001C.0008.014C] # LATIN CAPITAL LETTER O WITH MACRON
00F3      ; [.1724.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
006F 0301 ; [.1724.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
006F 0341 ; [.1724.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
00D3      ; [.1724.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0301 ; [.1724.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0341 ; [.1724.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
01D2      ; [.1724.001E.0002.01D2] # LATIN SMALL LETTER O WITH CARON
006F 030C ; [.1724.001E.0002.01D2] # LATIN SMALL LETTER O WITH CARON
01D1      ; [.1724.001E.0008.01D1] # LATIN CAPITAL LETTER O WITH CARON
004F 030C ; [.1724.001E.0008.01D1] # LATIN CAPITAL LETTER O WITH CARON
00F2      ; [.1724.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
006F 0300 ; [.1724.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
006F 0340 ; [.1724.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
00D2      ; [.1724.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0300 ; [.1724.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0340 ; [.1724.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
016B      ; [.17E9.001C.0002.016B] # LATIN SMALL LETTER U WITH MACRON
0075 0304 ; [.17E9.001C.0002.016B] # LATIN SMALL LETTER U WITH MACRON
016A      ; [.17E9.001C.0008.016A] # LATIN CAPITAL LETTER U WITH MACRON
0055 0304 ; [.17E9.001C.0008.016A] # LATIN CAPITAL LETTER U WITH MACRON
00FA      ; [.17E9.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
0075 0301 ; [.17E9.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
0075 0341 ; [.17E9.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
00DA      ; [.17E9.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0301 ; [.17E9.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0341 ; [.17E9.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
01D4      ; [.17E9.001E.0002.01D4] # LATIN SMALL LETTER U WITH CARON
0075 030C ; [.17E9.001E.0002.01D4] # LATIN SMALL LETTER U WITH CARON
01D3      ; [.17E9.001E.0008.01D3] # LATIN CAPITAL LETTER U WITH CARON
0055 030C ; [.17E9.001E.0008.01D3] # LATIN CAPITAL LETTER U WITH CARON
00F9      ; [.17E9.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
0075 0300 ; [.17E9.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
0075 0340 ; [.17E9.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
00D9      ; [.17E9.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0300 ; [.17E9.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0340 ; [.17E9.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
01D6      ; [.17E9.0021.0002.01D6] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
0075 0308 0304 ; [.17E9.0021.0002.01D6] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
01D5      ; [.17E9.0021.0008.01D5] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
0055 0308 0304 ; [.17E9.0021.0008.01D5] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
00FC 0304 ; [.17E9.0021.0002.01D6] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING MACRON>
00DC 0304 ; [.17E9.0021.0008.01D5] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING MACRON>
01D8      ; [.17E9.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0301 ; [.17E9.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0341 ; [.17E9.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
01D7      ; [.17E9.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0301 ; [.17E9.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0341 ; [.17E9.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
00FC 0301 ; [.17E9.0022.0002.01D8] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00FC 0341 ; [.17E9.0022.0002.01D8] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
00DC 0301 ; [.17E9.0022.0008.01D7] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00DC 0341 ; [.17E9.0022.0008.01D7] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
01DA      ; [.17E9.0023.0002.01DA] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
0075 0308 030C ; [.17E9.0023.0002.01DA] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
01D9      ; [.17E9.0023.0008.01D9] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
0055 0308 030C ; [.17E9.0023.0008.01D9] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
00FC 030C ; [.17E9.0023.0002.01DA] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING CARON>
00DC 030C ; [.17E9.0023.0008.01D9] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING CARON>
01DC      ; [.17E9.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0300 ; [.17E9.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0340 ; [.17E9.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
01DB      ; [.17E9.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0300 ; [.17E9.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0340 ; [.17E9.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
00FC 0300 ; [.17E9.0024.0002.01DC] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00FC 0340 ; [.17E9.0024.0002.01DC] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00DC 0300 ; [.17E9.0024.0008.01DB] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00DC 0340 ; [.17E9.0024.0008.01DB] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00FC      ; [.17E9.0025.0002.00FC] # LATIN SMALL LETTER U WITH DIAERESIS
0075 0308 ; [.17E9.0025.0002.00FC] # LATIN SMALL LETTER U WITH DIAERESIS
00DC      ; [.17E9.0025.0008.00DC] # LATIN CAPITAL LETTER U WITH DIAERESIS
0055 0308 ; [.17E9.0025.0008.00DC] # LATIN CAPITAL LETTER U WITH DIAERESIS
FDD0 0041 ; [.8000.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER A>
FDD0 0042 ; [.80C5.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER B>
FDD0 0043 ; [.8441.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER C>
FDD0 0044 ; [.897D.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER D>
FDD0 0045 ; [.8D61.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER E>
FDD0 0046 ; [.8E1B.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER F>
FDD0 0047 ; [.9089.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER G>
FDD0 0048 ; [.93C4.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER H>
FDD0 004A ; [.97EC.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER J>
FDD0 004B ; [.9E32.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER K>
FDD0 004C ; [.A05D.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER L>
3007      ; [.A401.0020.0002.3007] # IDEOGRAPHIC NUMBER ZERO
FDD0 004D ; [.A680.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER M>
FDD0 004E ; [.A9A9.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER N>
FDD0 004F ; [.AB89.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER O>
FDD0 0050 ; [.ABAC.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER P>
FDD0 0051 ; [.AE02.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER Q>
FDD0 0052 ; [.B1F1.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER R>
FDD0 0053 ; [.B337.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER S>
FDD0 0054 ; [.B858.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER T>
FDD0 0057 ; [.BBD3.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER W>
FDD0 0058 ; [.BE4A.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER X>
FDD0 0059 ; [.C382.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER Y>
FDD0 005A ; [.CB22.0020.0002.FDD0] # <noncharacter-FDD0, LATIN CAPITAL LETTER Z>
3220      ; [*030E.0020.0004.3220][.C5CF.0020.0004.3220][*030F.0020.001F.3220] # PARENTHESIZED IDEOGRAPH ONE
3226      ; [*030E.0020.0004.3226][.AE03.0020.0004.3226][*030F.0020.001F.3226] # PARENTHESIZED IDEOGRAPH SEVEN
3222      ; [*030E.0020.0004.3222][.B35F.0020.0004.3222][*030F.0020.001F.3222] # PARENTHESIZED IDEOGRAPH THREE
3228      ; [*030E.0020.0004.3228][.9C92.0020.0004.3228][*030F.0020.001F.3228] # PARENTHESIZED IDEOGRAPH NINE
3221      ; [*030E.0020.0004.3221][.8E0E.0020.0004.3221][*030F.0020.001F.3221] # PARENTHESIZED IDEOGRAPH TWO
3224      ; [*030E.0020.0004.3224][.BDF1.0020.0004.3224][*030F.0020.001F.3224] # PARENTHESIZED IDEOGRAPH FIVE
3239      ; [*030E.0020.0004.3239][.89B6.0020.0004.3239][*030F.0020.001F.3239] # PARENTHESIZED IDEOGRAPH REPRESENT
323D      ; [*030E.0020.0004.323D][.AE82.0020.0004.323D][*030F.0020.001F.323D] # PARENTHESIZED IDEOGRAPH ENTERPRISE
3241      ; [*030E.0020.0004.3241][.C1F9.0020.0004.3241][*030F.0020.001F.3241] # PARENTHESIZED IDEOGRAPH REST
3227      ; [*030E.0020.0004.3227][.80C6.0020.0004.3227][*030F.0020.001F.3227] # PARENTHESIZED IDEOGRAPH EIGHT
3225      ; [*030E.0020.0004.3225][.A49F.0020.0004.3225][*030F.0020.001F.3225] # PARENTHESIZED IDEOGRAPH SIX
3238      ; [*030E.0020.0004.3238][.A132.0020.0004.3238][*030F.0020.001F.3238] # PARENTHESIZED IDEOGRAPH LABOR
3229      ; [*030E.0020.0004.3229][.B57B.0020.0004.3229][*030F.0020.001F.3229] # PARENTHESIZED IDEOGRAPH TEN
323F      ; [*030E.0020.0004.323F][.C10A.0020.0004.323F][*030F.0020.001F.323F] # PARENTHESIZED IDEOGRAPH ALLIANCE
3234      ; [*030E.0020.0004.3234][.A8EB.0020.0004.3234][*030F.0020.001F.3234] # PARENTHESIZED IDEOGRAPH NAME
323A      ; [*030E.0020.0004.323A][.9589.0020.0004.323A][*030F.0020.001F.323A] # PARENTHESIZED IDEOGRAPH CALL
3223      ; [*030E.0020.0004.3223][.B715.0020.0004.3223][*030F.0020.001F.3223] # PARENTHESIZED IDEOGRAPH FOUR
322F      ; [*030E.0020.0004.322F][.BB2D.0020.0004.322F][*030F.0020.001F.322F] # PARENTHESIZED IDEOGRAPH EARTH
323B      ; [*030E.0020.0004.323B][.C304.0020.0004.323B][*030F.0020.001F.323B] # PARENTHESIZED IDEOGRAPH STUDY
3230      ; [*030E.0020.0004.3230][.B272.0020.0004.3230][*030F.0020.001F.3230] # PARENTHESIZED IDEOGRAPH SUN
322A      ; [*030E.0020.0004.322A][.CA96.0020.0004.322A][*030F.0020.001F.322A] # PARENTHESIZED IDEOGRAPH MOON
3232      ; [*030E.0020.0004.3232][.C8D2.0020.0004.3232][*030F.0020.001F.3232] # PARENTHESIZED IDEOGRAPH HAVE
322D      ; [*030E.0020.0004.322D][.A98A.0020.0004.322D][*030F.0020.001F.322D] # PARENTHESIZED IDEOGRAPH WOOD
3231      ; [*030E.0020.0004.3231][.CF58.0020.0004.3231][*030F.0020.001F.3231] # PARENTHESIZED IDEOGRAPH STOCK
322C      ; [*030E.0020.0004.322C][.B6BA.0020.0004.322C][*030F.0020.001F.322C] # PARENTHESIZED IDEOGRAPH WATER
322B      ; [*030E.0020.0004.322B][.97BC.0020.0004.322B][*030F.0020.001F.322B] # PARENTHESIZED IDEOGRAPH FIRE
3235      ; [*030E.0020.0004.3235][.B980.0020.0004.3235][*030F.0020.001F.3235] # PARENTHESIZED IDEOGRAPH SPECIAL
323C      ; [*030E.0020.0004.323C][.999B.0020.0004.323C][*030F.0020.001F.323C] # PARENTHESIZED IDEOGRAPH SUPERVISE
3233      ; [*030E.0020.0004.3233][.B4AC.0020.0004.3233][*030F.0020.001F.3233] # PARENTHESIZED IDEOGRAPH SOCIETY
3237      ; [*030E.0020.0004.3237][.CFAD.0020.0004.3237][*030F.0020.001F.3237] # PARENTHESIZED IDEOGRAPH CONGRATULATION
3240      ; [*030E.0020.0004.3240][.98D6.0020.0004.3240][*030F.0020.001F.3240] # PARENTHESIZED IDEOGRAPH FESTIVAL
3242      ; [*030E.0020.0004.3242][.D0D4.0020.0004.3242][*030F.0020.001F.3242] # PARENTHESIZED IDEOGRAPH SELF
3243      ; [*030E.0020.0004.3243][.CE51.0020.0004.3243][*030F.0020.001F.3243] # PARENTHESIZED IDEOGRAPH REACH
3236      ; [*030E.0020.0004.3236][.844F.0020.0004.3236][*030F.0020.001F.3236] # PARENTHESIZED IDEOGRAPH FINANCIAL
323E      ; [*030E.0020.0004.323E][.D0A3.0020.0004.323E][*030F.0020.001F.323E] # PARENTHESIZED IDEOGRAPH RESOURCE
322E      ; [*030E.0020.0004.322E][.9B96.0020.0004.322E][*030F.0020.001F.322E] # PARENTHESIZED IDEOGRAPH METAL
3358      ; [.1599.0020.0004.3358][.8B60.0020.0004.3358] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO
33E9      ; [.159A.0020.0004.33E9][.1599.0020.0004.33E9][.B272.0020.001F.33E9] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN
32C9      ; [.159A.0020.0004.32C9][.1599.0020.0004.32C9][.CA96.0020.001F.32C9] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER
3362      ; [.159A.0020.0004.3362][.1599.0020.0004.3362][.8B60.0020.001F.3362] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN
33EA      ; [.159A.0020.0004.33EA][.159A.0020.0004.33EA][.B272.0020.001F.33EA] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN
32CA      ; [.159A.0020.0004.32CA][.159A.0020.0004.32CA][.CA96.0020.001F.32CA] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER
3363      ; [.159A.0020.0004.3363][.159A.0020.0004.3363][.8B60.0020.001F.3363] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN
33EB      ; [.159A.0020.0004.33EB][.159B.0020.0004.33EB][.B272.0020.001F.33EB] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE
32CB      ; [.159A.0020.0004.32CB][.159B.0020.0004.32CB][.CA96.0020.001F.32CB] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER
3364      ; [.159A.0020.0004.3364][.159B.0020.0004.3364][.8B60.0020.001F.3364] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE
33EC      ; [.159A.0020.0004.33EC][.159C.0020.0004.33EC][.B272.0020.001F.33EC] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN
3365      ; [.159A.0020.0004.3365][.159C.0020.0004.3365][.8B60.0020.001F.3365] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN
33ED      ; [.159A.0020.0004.33ED][.159D.0020.0004.33ED][.B272.0020.001F.33ED] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN
3366      ; [.159A.0020.0004.3366][.159D.0020.0004.3366][.8B60.0020.001F.3366] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN
33EE      ; [.159A.0020.0004.33EE][.159E.0020.0004.33EE][.B272.0020.001F.33EE] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN
3367      ; [.159A.0020.0004.3367][.159E.0020.0004.3367][.8B60.0020.001F.3367] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN
33EF      ; [.159A.0020.0004.33EF][.159F.0020.0004.33EF][.B272.0020.001F.33EF] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN
3368      ; [.159A.0020.0004.3368][.159F.0020.0004.3368][.8B60.0020.001F.3368] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN
33F0      ; [.159A.0020.0004.33F0][.15A0.0020.0004.33F0][.B272.0020.001F.33F0] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN
3369      ; [.159A.0020.0004.3369][.15A0.0020.0004.3369][.8B60.0020.001F.3369] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN
33F1      ; [.159A.0020.0004.33F1][.15A1.0020.0004.33F1][.B272.0020.001F.33F1] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN
336A      ; [.159A.0020.0004.336A][.15A1.0020.0004.336A][.8B60.0020.001F.336A] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN
33F2      ; [.159A.0020.0004.33F2][.15A2.0020.0004.33F2][.B272.0020.001F.33F2] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN
336B      ; [.159A.0020.0004.336B][.15A2.0020.0004.336B][.8B60.0020.001F.336B] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN
33E0      ; [.159A.0020.0004.33E0][.B272.0020.0004.33E0] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE
32C0      ; [.159A.0020.0004.32C0][.CA96.0020.0004.32C0] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY
3359      ; [.159A.0020.0004.3359][.8B60.0020.0004.3359] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE
33F3      ; [.159B.0020.0004.33F3][.1599.0020.0004.33F3][.B272.0020.001F.33F3] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY
336C      ; [.159B.0020.0004.336C][.1599.0020.0004.336C][.8B60.0020.001F.336C] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY
33F4      ; [.159B.0020.0004.33F4][.159A.0020.0004.33F4][.B272.0020.001F.33F4] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE
336D      ; [.159B.0020.0004.336D][.159A.0020.0004.336D][.8B60.0020.001F.336D] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE
33F5      ; [.159B.0020.0004.33F5][.159B.0020.0004.33F5][.B272.0020.001F.33F5] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO
336E      ; [.159B.0020.0004.336E][.159B.0020.0004.336E][.8B60.0020.001F.336E] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO
33F6      ; [.159B.0020.0004.33F6][.159C.0020.0004.33F6][.B272.0020.001F.33F6] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE
336F      ; [.159B.0020.0004.336F][.159C.0020.0004.336F][.8B60.0020.001F.336F] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE
33F7      ; [.159B.0020.0004.33F7][.159D.0020.0004.33F7][.B272.0020.001F.33F7] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR
3370      ; [.159B.0020.0004.3370][.159D.0020.0004.3370][.8B60.0020.001F.3370] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR
33F8      ; [.159B.0020.0004.33F8][.159E.0020.0004.33F8][.B272.0020.001F.33F8] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE
33F9      ; [.159B.0020.0004.33F9][.159F.0020.0004.33F9][.B272.0020.001F.33F9] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX
33FA      ; [.159B.0020.0004.33FA][.15A0.0020.0004.33FA][.B272.0020.001F.33FA] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN
33FB      ; [.159B.0020.0004.33FB][.15A1.0020.0004.33FB][.B272.0020.001F.33FB] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT
33FC      ; [.159B.0020.0004.33FC][.15A2.0020.0004.33FC][.B272.0020.001F.33FC] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE
33E1      ; [.159B.0020.0004.33E1][.B272.0020.0004.33E1] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO
32C1      ; [.159B.0020.0004.32C1][.CA96.0020.0004.32C1] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY
335A      ; [.159B.0020.0004.335A][.8B60.0020.0004.335A] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO
33FD      ; [.159C.0020.0004.33FD][.1599.0020.0004.33FD][.B272.0020.001F.33FD] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY
33FE      ; [.159C.0020.0004.33FE][.159A.0020.0004.33FE][.B272.0020.001F.33FE] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE
33E2      ; [.159C.0020.0004.33E2][.B272.0020.0004.33E2] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE
32C2      ; [.159C.0020.0004.32C2][.CA96.0020.0004.32C2] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH
335B      ; [.159C.0020.0004.335B][.8B60.0020.0004.335B] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE
33E3      ; [.159D.0020.0004.33E3][.B272.0020.0004.33E3] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR
32C3      ; [.159D.0020.0004.32C3][.CA96.0020.0004.32C3] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL
335C      ; [.159D.0020.0004.335C][.8B60.0020.0004.335C] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR
33E4      ; [.159E.0020.0004.33E4][.B272.0020.0004.33E4] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE
32C4      ; [.159E.0020.0004.32C4][.CA96.0020.0004.32C4] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY
335D      ; [.159E.0020.0004.335D][.8B60.0020.0004.335D] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE
33E5      ; [.159F.0020.0004.33E5][.B272.0020.0004.33E5] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX
32C5      ; [.159F.0020.0004.32C5][.CA96.0020.0004.32C5] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE
335E      ; [.159F.0020.0004.335E][.8B60.0020.0004.335E] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX
33E6      ; [.15A0.0020.0004.33E6][.B272.0020.0004.33E6] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN
32C6      ; [.15A0.0020.0004.32C6][.CA96.0020.0004.32C6] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY
335F      ; [.15A0.0020.0004.335F][.8B60.0020.0004.335F] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN
33E7      ; [.15A1.0020.0004.33E7][.B272.0020.0004.33E7] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT
32C7      ; [.15A1.0020.0004.32C7][.CA96.0020.0004.32C7] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST
3360      ; [.15A1.0020.0004.3360][.8B60.0020.0004.3360] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT
33E8      ; [.15A2.0020.0004.33E8][.B272.0020.0004.33E8] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE
32C8      ; [.15A2.0020.0004.32C8][.CA96.0020.0004.32C8] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER
3361      ; [.15A2.0020.0004.3361][.8B60.0020.0004.3361] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE
1F241     ; [*0356.0020.0004.1F241][.B35F.0020.0004.1F241][*0357.0020.001F.1F241] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E09
1F242     ; [*0356.0020.0004.1F242][.8E0E.0020.0004.1F242][*0357.0020.001F.1F242] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E8C
1F247     ; [*0356.0020.0004.1F247][.B548.0020.0004.1F247][*0357.0020.001F.1F247] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-52DD
1F243     ; [*0356.0020.0004.1F243][.8049.0020.0004.1F243][*0357.0020.001F.1F243] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-5B89
1F245     ; [*0356.0020.0004.1F245][.89A6.0020.0004.1F245][*0357.0020.001F.1F245] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6253
1F248     ; [*0356.0020.0004.1F248][.811B.0020.0004.1F248][*0357.0020.001F.1F248] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
1F240     ; [*0356.0020.0004.1F240][.81FC.0020.0004.1F240][*0357.0020.001F.1F240] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C
1F244     ; [*0356.0020.0004.1F244][.8B60.0020.0004.1F244][*0357.0020.001F.1F244] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-70B9
1F246     ; [*0356.0020.0004.1F246][.8A91.0020.0004.1F246][*0357.0020.001F.1F246] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-76D7
2F00      ; [.C5CF.0020.0004.2F00] # KANGXI RADICAL ONE
3192      ; [.C5CF.0020.0014.3192] # IDEOGRAPHIC ANNOTATION ONE MARK
3280      ; [.C5CF.0020.0006.3280] # CIRCLED IDEOGRAPH ONE
1F229     ; [.C5CF.0020.001C.1F229] # SQUARED CJK UNIFIED IDEOGRAPH-4E00
319C      ; [.8BE6.0020.0014.319C] # IDEOGRAPHIC ANNOTATION FOURTH MARK
3286      ; [.AE03.0020.0006.3286] # CIRCLED IDEOGRAPH SEVEN
3194      ; [.B35F.0020.0014.3194] # IDEOGRAPHIC ANNOTATION THREE MARK
3282      ; [.B35F.0020.0006.3282] # CIRCLED IDEOGRAPH THREE
1F22A     ; [.B35F.0020.001C.1F22A] # SQUARED CJK UNIFIED IDEOGRAPH-4E09
3196      ; [.B46D.0020.0014.3196] # IDEOGRAPHIC ANNOTATION TOP MARK
32A4      ; [.B46D.0020.0006.32A4] # CIRCLED IDEOGRAPH HIGH
3198      ; [.BF75.0020.0014.3198] # IDEOGRAPHIC ANNOTATION BOTTOM MARK
32A6      ; [.BF75.0020.0006.32A6] # CIRCLED IDEOGRAPH LOW
319B      ; [.8382.0020.0014.319B] # IDEOGRAPHIC ANNOTATION THIRD MARK
2F01      ; [.937A.0020.0004.2F01] # KANGXI RADICAL LINE
3197      ; [.CECC.0020.0014.3197] # IDEOGRAPHIC ANNOTATION MIDDLE MARK
32A5      ; [.CECC.0020.0006.32A5] # CIRCLED IDEOGRAPH CENTRE
1F22D     ; [.CECC.0020.001C.1F22D] # SQUARED CJK UNIFIED IDEOGRAPH-4E2D
2F02      ; [.CF8B.0020.0004.2F02] # KANGXI RADICAL DOT
2F03      ; [.AD44.0020.0004.2F03] # KANGXI RADICAL SLASH
2F04      ; [.C643.0020.0004.2F04] # KANGXI RADICAL SECOND
319A      ; [.C643.0020.0014.319A] # IDEOGRAPHIC ANNOTATION SECOND MARK
3288      ; [.9C92.0020.0006.3288] # CIRCLED IDEOGRAPH NINE
2F05      ; [.9D9D.0020.0004.2F05] # KANGXI RADICAL HOOK
2F06      ; [.8E0E.0020.0004.2F06] # KANGXI RADICAL TWO
3193      ; [.8E0E.0020.0014.3193] # IDEOGRAPHIC ANNOTATION TWO MARK
3281      ; [.8E0E.0020.0006.3281] # CIRCLED IDEOGRAPH TWO
1F214     ; [.8E0E.0020.001C.1F214] # SQUARED CJK UNIFIED IDEOGRAPH-4E8C
3284      ; [.BDF1.0020.0006.3284] # CIRCLED IDEOGRAPH FIVE
2F07      ; [.BAE9.0020.0004.2F07] # KANGXI RADICAL LID
1F218     ; [.9A8F.0020.001C.1F218] # SQUARED CJK UNIFIED IDEOGRAPH-4EA4
2F08      ; [.B22F.0020.0004.2F08] # KANGXI RADICAL MAN
319F      ; [.B22F.0020.0014.319F] # IDEOGRAPHIC ANNOTATION MAN MARK
32AD      ; [.AE82.0020.0006.32AD] # CIRCLED IDEOGRAPH ENTERPRISE
32A1      ; [.C1F9.0020.0006.32A1] # CIRCLED IDEOGRAPH REST
329D      ; [.C8A5.0020.0006.329D] # CIRCLED IDEOGRAPH EXCELLENT
2F09      ; [.8DE5.0020.0004.2F09] # KANGXI RADICAL LEGS
2F0A      ; [.B2E8.0020.0004.2F0A] # KANGXI RADICAL ENTER
2F0B      ; [.80C6.0020.0004.2F0B] # KANGXI RADICAL EIGHT
3287      ; [.80C6.0020.0006.3287] # CIRCLED IDEOGRAPH EIGHT
3285      ; [.A49F.0020.0006.3285] # CIRCLED IDEOGRAPH SIX
2F0C      ; [.9C60.0020.0004.2F0C] # KANGXI RADICAL DOWN BOX
1F21E     ; [.CB49.0020.001C.1F21E] # SQUARED CJK UNIFIED IDEOGRAPH-518D
2F0D      ; [.A832.0020.0004.2F0D] # KANGXI RADICAL COVER
32A2      ; [.C132.0020.0006.32A2] # CIRCLED IDEOGRAPH COPY
2F0E      ; [.837B.0020.0004.2F0E] # KANGXI RADICAL ICE
2F0F      ; [.989A.0020.0004.2F0F] # KANGXI RADICAL TABLE
2F10      ; [.AF3D.0020.0004.2F10] # KANGXI RADICAL OPEN BOX
2F11      ; [.8A71.0020.0004.2F11] # KANGXI RADICAL KNIFE
1F220     ; [.8779.0020.001C.1F220] # SQUARED CJK UNIFIED IDEOGRAPH-521D
1F21C     ; [.AF1F.0020.001C.1F21C] # SQUARED CJK UNIFIED IDEOGRAPH-524D
1F239     ; [.9162.0020.001C.1F239] # SQUARED CJK UNIFIED IDEOGRAPH-5272
2F12      ; [.A237.0020.0004.2F12] # KANGXI RADICAL POWER
3298      ; [.A132.0020.0006.3298] # CIRCLED IDEOGRAPH LABOR
2F13      ; [.8175.0020.0004.2F13] # KANGXI RADICAL WRAP
2F14      ; [.8238.0020.0004.2F14] # KANGXI RADICAL SPOON
2F15      ; [.8E8F.0020.0004.2F15] # KANGXI RADICAL RIGHT OPEN BOX
2F16      ; [.BF01.0020.0004.2F16] # KANGXI RADICAL HIDING ENCLOSURE
32A9      ; [.C5D4.0020.0006.32A9] # CIRCLED IDEOGRAPH MEDICINE
2F17      ; [.B57B.0020.0004.2F17] # KANGXI RADICAL TEN
3038      ; [.B57B.0020.0004.3038] # HANGZHOU NUMERAL TEN
3289      ; [.B57B.0020.0006.3289] # CIRCLED IDEOGRAPH TEN
3039      ; [.AAA8.0020.0004.3039] # HANGZHOU NUMERAL TWENTY
303A      ; [.B342.0020.0004.303A] # HANGZHOU NUMERAL THIRTY
32AF      ; [.C10A.0020.0006.32AF] # CIRCLED IDEOGRAPH ALLIANCE
2F18      ; [.8410.0020.0004.2F18] # KANGXI RADICAL DIVINATION
2F19      ; [.9B2A.0020.0004.2F19] # KANGXI RADICAL SEAL
329E      ; [.C7AF.0020.0006.329E] # CIRCLED IDEOGRAPH PRINT
2F1A      ; [.85AC.0020.0004.2F1A] # KANGXI RADICAL CLIFF
2F1B      ; [.B6E4.0020.0004.2F1B] # KANGXI RADICAL PRIVATE
2F1C      ; [.C8E8.0020.0004.2F1C] # KANGXI RADICAL AGAIN
1F212     ; [.B6A1.0020.001C.1F212] # SQUARED CJK UNIFIED IDEOGRAPH-53CC
2F1D      ; [.9F2E.0020.0004.2F1D] # KANGXI RADICAL MOUTH
1F251     ; [.9ED7.0020.0006.1F251] # CIRCLED IDEOGRAPH ACCEPT
32A8      ; [.C8E9.0020.0006.32A8] # CIRCLED IDEOGRAPH RIGHT
1F22E     ; [.C8E9.0020.001C.1F22E] # SQUARED CJK UNIFIED IDEOGRAPH-53F3
1F234     ; [.9499.0020.001C.1F234] # SQUARED CJK UNIFIED IDEOGRAPH-5408
3294      ; [.A8EB.0020.0006.3294] # CIRCLED IDEOGRAPH NAME
1F225     ; [.8816.0020.001C.1F225] # SQUARED CJK UNIFIED IDEOGRAPH-5439
3244      ; [.BD6F.0020.0006.3244] # CIRCLED IDEOGRAPH QUESTION
1F23A     ; [.C804.0020.001C.1F23A] # SQUARED CJK UNIFIED IDEOGRAPH-55B6
2F1E      ; [.BC8F.0020.0004.2F1E] # KANGXI RADICAL ENCLOSURE
3195      ; [.B715.0020.0014.3195] # IDEOGRAPHIC ANNOTATION FOUR MARK
3283      ; [.B715.0020.0006.3283] # CIRCLED IDEOGRAPH FOUR
2F1F      ; [.BB2D.0020.0004.2F1F] # KANGXI RADICAL EARTH
328F      ; [.BB2D.0020.0006.328F] # CIRCLED IDEOGRAPH EARTH
319E      ; [.8AAF.0020.0014.319E] # IDEOGRAPHIC ANNOTATION EARTH MARK
2F20      ; [.B5A9.0020.0004.2F20] # KANGXI RADICAL SCHOLAR
1F224     ; [.B526.0020.001C.1F224] # SQUARED CJK UNIFIED IDEOGRAPH-58F0
2F21      ; [.CE2D.0020.0004.2F21] # KANGXI RADICAL GO
2F22      ; [.B7D9.0020.0004.2F22] # KANGXI RADICAL GO SLOWLY
2F23      ; [.BE4B.0020.0004.2F23] # KANGXI RADICAL EVENING
1F215     ; [.8D1C.0020.001C.1F215] # SQUARED CJK UNIFIED IDEOGRAPH-591A
32B0      ; [.C59A.0020.0006.32B0] # CIRCLED IDEOGRAPH NIGHT
2F24      ; [.89A7.0020.0004.2F24] # KANGXI RADICAL BIG
337D      ; [.89A7.0020.001C.337D][.CDCB.0020.001F.337D] # SQUARE ERA NAME TAISYOU
319D      ; [.B9F9.0020.0014.319D] # IDEOGRAPHIC ANNOTATION HEAVEN MARK
1F217     ; [.B9F9.0020.001C.1F217] # SQUARED CJK UNIFIED IDEOGRAPH-5929
2F25      ; [.AB5E.0020.0004.2F25] # KANGXI RADICAL WOMAN
329B      ; [.AB5E.0020.0006.329B] # CIRCLED IDEOGRAPH FEMALE
2F26      ; [.D0E1.0020.0004.2F26] # KANGXI RADICAL CHILD
1F211     ; [.D0D3.0020.001C.1F211] # SQUARED CJK UNIFIED IDEOGRAPH-5B57
32AB      ; [.C304.0020.0006.32AB] # CIRCLED IDEOGRAPH STUDY
2F27      ; [.A858.0020.0004.2F27] # KANGXI RADICAL ROOF
32AA      ; [.D0E4.0020.0006.32AA] # CIRCLED IDEOGRAPH RELIGION
2F28      ; [.8955.0020.0004.2F28] # KANGXI RADICAL INCH
2F29      ; [.C0DE.0020.0004.2F29] # KANGXI RADICAL SMALL
2F2A      ; [.C8AC.0020.0004.2F2A] # KANGXI RADICAL LAME
2F2B      ; [.B554.0020.0004.2F2B] # KANGXI RADICAL CORPSE
2F2C      ; [.85F7.0020.0004.2F2C] # KANGXI RADICAL SPROUT
2F2D      ; [.B3FD.0020.0004.2F2D] # KANGXI RADICAL MOUNTAIN
2F2E      ; [.87DC.0020.0004.2F2E] # KANGXI RADICAL RIVER
2F2F      ; [.91CB.0020.0004.2F2F] # KANGXI RADICAL WORK
32A7      ; [.D19D.0020.0006.32A7] # CIRCLED IDEOGRAPH LEFT
1F22C     ; [.D19D.0020.001C.1F22C] # SQUARED CJK UNIFIED IDEOGRAPH-5DE6
2F30      ; [.989B.0020.0004.2F30] # KANGXI RADICAL ONESELF
2F31      ; [.9B91.0020.0004.2F31] # KANGXI RADICAL TURBAN
2F32      ; [.90EE.0020.0004.2F32] # KANGXI RADICAL DRY
337B      ; [.AD6D.0020.001C.337B][.866D.0020.001F.337B] # SQUARE ERA NAME HEISEI
2F33      ; [.C50D.0020.0004.2F33] # KANGXI RADICAL SHORT THREAD
3245      ; [.C8EA.0020.0006.3245] # CIRCLED IDEOGRAPH KINDERGARTEN
2F34      ; [.9307.0020.0004.2F34] # KANGXI RADICAL DOTTED CLIFF
2F35      ; [.C792.0020.0004.2F35] # KANGXI RADICAL LONG STRIDE
2F36      ; [.91E7.0020.0004.2F36] # KANGXI RADICAL TWO HANDS
2F37      ; [.C66C.0020.0004.2F37] # KANGXI RADICAL SHOOT
2F38      ; [.91CC.0020.0004.2F38] # KANGXI RADICAL BOW
2F39      ; [.98AF.0020.0004.2F39] # KANGXI RADICAL SNOUT
2F3A      ; [.B3FE.0020.0004.2F3A] # KANGXI RADICAL BRISTLE
2F3B      ; [.86F1.0020.0004.2F3B] # KANGXI RADICAL STEP
1F21D     ; [.957C.0020.001C.1F21D] # SQUARED CJK UNIFIED IDEOGRAPH-5F8C
1F250     ; [.8AB1.0020.0006.1F250] # CIRCLED IDEOGRAPH ADVANTAGE
2F3C      ; [.C178.0020.0004.2F3C] # KANGXI RADICAL HEART
2F3D      ; [.9153.0020.0004.2F3D] # KANGXI RADICAL HALBERD
2F3E      ; [.95D9.0020.0004.2F3E] # KANGXI RADICAL DOOR
2F3F      ; [.B60C.0020.0004.2F3F] # KANGXI RADICAL HAND
1F210     ; [.B60C.0020.001C.1F210] # SQUARED CJK UNIFIED IDEOGRAPH-624B
1F231     ; [.89A6.0020.001C.1F231] # SQUARED CJK UNIFIED IDEOGRAPH-6253
1F227     ; [.BAEB.0020.001C.1F227] # SQUARED CJK UNIFIED IDEOGRAPH-6295
1F22F     ; [.CE40.0020.001C.1F22F] # SQUARED CJK UNIFIED IDEOGRAPH-6307
1F228     ; [.8420.0020.001C.1F228] # SQUARED CJK UNIFIED IDEOGRAPH-6355
2F40      ; [.CDDA.0020.0004.2F40] # KANGXI RADICAL BRANCH
2F41      ; [.ADCC.0020.0004.2F41] # KANGXI RADICAL RAP
2F42      ; [.BD44.0020.0004.2F42] # KANGXI RADICAL SCRIPT
3246      ; [.BD44.0020.0006.3246] # CIRCLED IDEOGRAPH SCHOOL
2F43      ; [.8C5E.0020.0004.2F43] # KANGXI RADICAL DIPPER
1F21B     ; [.A385.0020.001C.1F21B] # SQUARED CJK UNIFIED IDEOGRAPH-6599
2F44      ; [.9B93.0020.0004.2F44] # KANGXI RADICAL AXE
1F21F     ; [.C188.0020.001C.1F21F] # SQUARED CJK UNIFIED IDEOGRAPH-65B0
2F45      ; [.8E90.0020.0004.2F45] # KANGXI RADICAL SQUARE
2F46      ; [.BDD2.0020.0004.2F46] # KANGXI RADICAL NOT
2F47      ; [.B272.0020.0004.2F47] # KANGXI RADICAL SUN
3290      ; [.B272.0020.0006.3290] # CIRCLED IDEOGRAPH SUN
337E      ; [.A8EC.0020.001C.337E][.CE5C.0020.001F.337E] # SQUARE ERA NAME MEIZI
1F219     ; [.C83C.0020.001C.1F219] # SQUARED CJK UNIFIED IDEOGRAPH-6620
337C      ; [.CCD5.0020.001C.337C][.949E.0020.001F.337C] # SQUARE ERA NAME SYOUWA
2F48      ; [.CA8E.0020.0004.2F48] # KANGXI RADICAL SAY
2F49      ; [.CA96.0020.0004.2F49] # KANGXI RADICAL MOON
328A      ; [.CA96.0020.0006.328A] # CIRCLED IDEOGRAPH MOON
1F237     ; [.CA96.0020.001C.1F237] # SQUARED CJK UNIFIED IDEOGRAPH-6708
3292      ; [.C8D2.0020.0006.3292] # CIRCLED IDEOGRAPH HAVE
1F236     ; [.C8D2.0020.001C.1F236] # SQUARED CJK UNIFIED IDEOGRAPH-6709
2F4A      ; [.A98A.0020.0004.2F4A] # KANGXI RADICAL TREE
328D      ; [.A98A.0020.0006.328D] # CIRCLED IDEOGRAPH WOOD
3291      ; [.CF58.0020.0006.3291] # CIRCLED IDEOGRAPH STOCK
337F      ; [.CF58.0020.001C.337F][.B5B3.0020.001F.337F][.9737.0020.001F.337F][.B4AC.0020.001F.337F] # SQUARE CORPORATION
2F4B      ; [.AF4C.0020.0004.2F4B] # KANGXI RADICAL LACK
2F4C      ; [.CE2E.0020.0004.2F4C] # KANGXI RADICAL STOP
32A3      ; [.CDCB.0020.0006.32A3] # CIRCLED IDEOGRAPH CORRECT
2F4D      ; [.89B3.0020.0004.2F4D] # KANGXI RADICAL DEATH
2F4E      ; [.B623.0020.0004.2F4E] # KANGXI RADICAL WEAPON
2F4F      ; [.BDD3.0020.0004.2F4F] # KANGXI RADICAL DO NOT
2E9F      ; [.A97A.0020.0004.2E9F] # CJK RADICAL MOTHER
2F50      ; [.8239.0020.0004.2F50] # KANGXI RADICAL COMPARE
2F51      ; [.A71D.0020.0004.2F51] # KANGXI RADICAL FUR
2F52      ; [.B5AA.0020.0004.2F52] # KANGXI RADICAL CLAN
2F53      ; [.AE99.0020.0004.2F53] # KANGXI RADICAL STEAM
2F54      ; [.B6BA.0020.0004.2F54] # KANGXI RADICAL WATER
328C      ; [.B6BA.0020.0006.328C] # CIRCLED IDEOGRAPH WATER
329F      ; [.CFA5.0020.0006.329F] # CIRCLED IDEOGRAPH ATTENTION
1F235     ; [.A6DD.0020.001C.1F235] # SQUARED CJK UNIFIED IDEOGRAPH-6E80
1F226     ; [.C445.0020.001C.1F226] # SQUARED CJK UNIFIED IDEOGRAPH-6F14
2F55      ; [.97BC.0020.0004.2F55] # KANGXI RADICAL FIRE
328B      ; [.97BC.0020.0006.328B] # CIRCLED IDEOGRAPH FIRE
1F21A     ; [.BDE3.0020.001C.1F21A] # SQUARED CJK UNIFIED IDEOGRAPH-7121
2F56      ; [.CCDE.0020.0004.2F56] # KANGXI RADICAL CLAW
2F57      ; [.9046.0020.0004.2F57] # KANGXI RADICAL FATHER
2F58      ; [.C51B.0020.0004.2F58] # KANGXI RADICAL DOUBLE X
2F59      ; [.ABD3.0020.0004.2F59] # KANGXI RADICAL HALF TREE TRUNK
2F5A      ; [.AD1C.0020.0004.2F5A] # KANGXI RADICAL SLICE
2F5B      ; [.C397.0020.0004.2F5B] # KANGXI RADICAL FANG
2F5C      ; [.AB21.0020.0004.2F5C] # KANGXI RADICAL COW
3295      ; [.B980.0020.0006.3295] # CIRCLED IDEOGRAPH SPECIAL
2F5D      ; [.B1B4.0020.0004.2F5D] # KANGXI RADICAL DOG
2F5E      ; [.C2C8.0020.0004.2F5E] # KANGXI RADICAL PROFOUND
2F5F      ; [.C99A.0020.0004.2F5F] # KANGXI RADICAL JADE
2F60      ; [.928E.0020.0004.2F60] # KANGXI RADICAL MELON
2F61      ; [.BBE5.0020.0004.2F61] # KANGXI RADICAL TILE
2F62      ; [.90BE.0020.0004.2F62] # KANGXI RADICAL SWEET
2F63      ; [.B523.0020.0004.2F63] # KANGXI RADICAL LIFE
1F222     ; [.B523.0020.001C.1F222] # SQUARED CJK UNIFIED IDEOGRAPH-751F
2F64      ; [.C894.0020.0004.2F64] # KANGXI RADICAL USE
2F65      ; [.BA01.0020.0004.2F65] # KANGXI RADICAL FIELD
3199      ; [.9955.0020.0014.3199] # IDEOGRAPHIC ANNOTATION FIRST MARK
1F238     ; [.B4C6.0020.001C.1F238] # SQUARED CJK UNIFIED IDEOGRAPH-7533
329A      ; [.A9E0.0020.0006.329A] # CIRCLED IDEOGRAPH MALE
2F66      ; [.ACE2.0020.0004.2F66] # KANGXI RADICAL BOLT OF CLOTH
2F67      ; [.AA2F.0020.0004.2F67] # KANGXI RADICAL SICKNESS
2F68      ; [.83AC.0020.0004.2F68] # KANGXI RADICAL DOTTED TENT
2F69      ; [.810B.0020.0004.2F69] # KANGXI RADICAL WHITE
2F6A      ; [.ACBB.0020.0004.2F6A] # KANGXI RADICAL SKIN
2F6B      ; [.A8CF.0020.0004.2F6B] # KANGXI RADICAL DISH
32AC      ; [.999B.0020.0006.32AC] # CIRCLED IDEOGRAPH SUPERVISE
2F6C      ; [.A98D.0020.0004.2F6C] # KANGXI RADICAL EYE
2F6D      ; [.A71E.0020.0004.2F6D] # KANGXI RADICAL SPEAR
2F6E      ; [.B59D.0020.0004.2F6E] # KANGXI RADICAL ARROW
2F6F      ; [.B57D.0020.0004.2F6F] # KANGXI RADICAL STONE
2F70      ; [.B5B0.0020.0004.2F70] # KANGXI RADICAL SPIRIT
3293      ; [.B4AC.0020.0006.3293] # CIRCLED IDEOGRAPH SOCIETY
3297      ; [.CFAD.0020.0006.3297] # CIRCLED IDEOGRAPH CONGRATULATION
1F232     ; [.9BD6.0020.001C.1F232] # SQUARED CJK UNIFIED IDEOGRAPH-7981
2F71      ; [.B2AC.0020.0004.2F71] # KANGXI RADICAL TRACK
2F72      ; [.9498.0020.0004.2F72] # KANGXI RADICAL GRAIN
3299      ; [.A83C.0020.0006.3299] # CIRCLED IDEOGRAPH SECRET
2F73      ; [.C301.0020.0004.2F73] # KANGXI RADICAL CAVE
1F233     ; [.9F18.0020.001C.1F233] # SQUARED CJK UNIFIED IDEOGRAPH-7A7A
2F74      ; [.A23B.0020.0004.2F74] # KANGXI RADICAL STAND
2F75      ; [.CF74.0020.0004.2F75] # KANGXI RADICAL BAMBOO
3247      ; [.CDBB.0020.0006.3247] # CIRCLED IDEOGRAPH KOTO
2F76      ; [.A821.0020.0004.2F76] # KANGXI RADICAL RICE
2F77      ; [.A833.0020.0004.2F77] # KANGXI RADICAL SILK
1F221     ; [.CEDC.0020.001C.1F221] # SQUARED CJK UNIFIED IDEOGRAPH-7D42
2F78      ; [.8F9E.0020.0004.2F78] # KANGXI RADICAL JAR
2F79      ; [.BC56.0020.0004.2F79] # KANGXI RADICAL NET
2F7A      ; [.C4C4.0020.0004.2F7A] # KANGXI RADICAL SHEEP
2F7B      ; [.C975.0020.0004.2F7B] # KANGXI RADICAL FEATHER
2F7C      ; [.A149.0020.0004.2F7C] # KANGXI RADICAL OLD
2F7D      ; [.8DE6.0020.0004.2F7D] # KANGXI RADICAL AND
2F7E      ; [.A19B.0020.0004.2F7E] # KANGXI RADICAL PLOW
2F7F      ; [.8E00.0020.0004.2F7F] # KANGXI RADICAL EAR
2F80      ; [.C99D.0020.0004.2F80] # KANGXI RADICAL BRUSH
2F81      ; [.B2C1.0020.0004.2F81] # KANGXI RADICAL MEAT
2F82      ; [.8612.0020.0004.2F82] # KANGXI RADICAL MINISTER
2F83      ; [.D0D4.0020.0004.2F83] # KANGXI RADICAL SELF
2F84      ; [.CE51.0020.0004.2F84] # KANGXI RADICAL ARRIVE
2F85      ; [.9CA1.0020.0004.2F85] # KANGXI RADICAL MORTAR
2F86      ; [.B4A3.0020.0004.2F86] # KANGXI RADICAL TONGUE
2F87      ; [.87EF.0020.0004.2F87] # KANGXI RADICAL OPPOSE
2F88      ; [.CF09.0020.0004.2F88] # KANGXI RADICAL BOAT
2F89      ; [.91A3.0020.0004.2F89] # KANGXI RADICAL STOPPING
2F8A      ; [.B3A0.0020.0004.2F8A] # KANGXI RADICAL COLOR
2F8B      ; [.84B1.0020.0004.2F8B] # KANGXI RADICAL GRASS
2F8C      ; [.9588.0020.0004.2F8C] # KANGXI RADICAL TIGER
2F8D      ; [.872E.0020.0004.2F8D] # KANGXI RADICAL INSECT
2F8E      ; [.C317.0020.0004.2F8E] # KANGXI RADICAL BLOOD
2F8F      ; [.C1BA.0020.0004.2F8F] # KANGXI RADICAL WALK ENCLOSURE
2F90      ; [.C5D3.0020.0004.2F90] # KANGXI RADICAL CLOTHES
2F91      ; [.C3B8.0020.0004.2F91] # KANGXI RADICAL WEST
2F92      ; [.99FE.0020.0004.2F92] # KANGXI RADICAL SEE
2F93      ; [.9AB8.0020.0004.2F93] # KANGXI RADICAL HORN
1F216     ; [.9B6C.0020.001C.1F216] # SQUARED CJK UNIFIED IDEOGRAPH-89E3
2F94      ; [.C3F5.0020.0004.2F94] # KANGXI RADICAL SPEECH
2F95      ; [.924B.0020.0004.2F95] # KANGXI RADICAL VALLEY
2F96      ; [.8C5F.0020.0004.2F96] # KANGXI RADICAL BEAN
2F97      ; [.B59F.0020.0004.2F97] # KANGXI RADICAL PIG
2F98      ; [.CE56.0020.0004.2F98] # KANGXI RADICAL BADGER
2F99      ; [.81CA.0020.0004.2F99] # KANGXI RADICAL SHELL
3296      ; [.844F.0020.0006.3296] # CIRCLED IDEOGRAPH FINANCIAL
1F223     ; [.8E87.0020.001C.1F223] # SQUARED CJK UNIFIED IDEOGRAPH-8CA9
32AE      ; [.D0A3.0020.0006.32AE] # CIRCLED IDEOGRAPH RESOURCE
2F9A      ; [.86F6.0020.0004.2F9A] # KANGXI RADICAL RED
2F9B      ; [.D138.0020.0004.2F9B] # KANGXI RADICAL RUN
1F230     ; [.D138.0020.001C.1F230] # SQUARED CJK UNIFIED IDEOGRAPH-8D70
2F9C      ; [.D141.0020.0004.2F9C] # KANGXI RADICAL FOOT
2F9D      ; [.B4CA.0020.0004.2F9D] # KANGXI RADICAL BODY
2F9E      ; [.85ED.0020.0004.2F9E] # KANGXI RADICAL CART
2F9F      ; [.C17D.0020.0004.2F9F] # KANGXI RADICAL BITTER
2FA0      ; [.8616.0020.0004.2FA0] # KANGXI RADICAL MORNING
2FA1      ; [.8858.0020.0004.2FA1] # KANGXI RADICAL WALK
1F22B     ; [.C8C4.0020.001C.1F22B] # SQUARED CJK UNIFIED IDEOGRAPH-904A
329C      ; [.B5EC.0020.0006.329C] # CIRCLED IDEOGRAPH SUITABLE
2FA2      ; [.C682.0020.0004.2FA2] # KANGXI RADICAL CITY
2FA3      ; [.C8D6.0020.0004.2FA3] # KANGXI RADICAL WINE
2FA4      ; [.82F0.0020.0004.2FA4] # KANGXI RADICAL DISTINGUISH
2FA5      ; [.A21E.0020.0004.2FA5] # KANGXI RADICAL VILLAGE
2FA6      ; [.9B96.0020.0004.2FA6] # KANGXI RADICAL GOLD
328E      ; [.9B96.0020.0006.328E] # CIRCLED IDEOGRAPH METAL
2FA7      ; [.CCB5.0020.0004.2FA7] # KANGXI RADICAL LONG
2FA8      ; [.A7B4.0020.0004.2FA8] # KANGXI RADICAL GATE
2FA9      ; [.904E.0020.0004.2FA9] # KANGXI RADICAL MOUND
2FAA      ; [.A24C.0020.0004.2FAA] # KANGXI RADICAL SLAVE
2FAB      ; [.D014.0020.0004.2FAB] # KANGXI RADICAL SHORT TAILED BIRD
2FAC      ; [.C976.0020.0004.2FAC] # KANGXI RADICAL RAIN
2FAD      ; [.B063.0020.0004.2FAD] # KANGXI RADICAL BLUE
2FAE      ; [.8EB9.0020.0004.2FAE] # KANGXI RADICAL WRONG
2FAF      ; [.A882.0020.0004.2FAF] # KANGXI RADICAL FACE
2FB0      ; [.9173.0020.0004.2FB0] # KANGXI RADICAL LEATHER
2FB1      ; [.BC9A.0020.0004.2FB1] # KANGXI RADICAL TANNED LEATHER
2FB2      ; [.9C9A.0020.0004.2FB2] # KANGXI RADICAL LEEK
2FB3      ; [.C745.0020.0004.2FB3] # KANGXI RADICAL SOUND
2FB4      ; [.C59E.0020.0004.2FB4] # KANGXI RADICAL LEAF
32A0      ; [.C084.0020.0006.32A0] # CIRCLED IDEOGRAPH ITEM
2FB5      ; [.8F57.0020.0004.2FB5] # KANGXI RADICAL WIND
2FB6      ; [.8EBA.0020.0004.2FB6] # KANGXI RADICAL FLY
2FB7      ; [.B58A.0020.0004.2FB7] # KANGXI RADICAL EAT
2FB8      ; [.B60F.0020.0004.2FB8] # KANGXI RADICAL HEAD
2FB9      ; [.C044.0020.0004.2FB9] # KANGXI RADICAL FRAGRANT
2FBA      ; [.A690.0020.0004.2FBA] # KANGXI RADICAL HORSE
2FBB      ; [.924E.0020.0004.2FBB] # KANGXI RADICAL BONE
2FBC      ; [.9124.0020.0004.2FBC] # KANGXI RADICAL TALL
2FBD      ; [.830C.0020.0004.2FBD] # KANGXI RADICAL HAIR
2FBE      ; [.8C65.0020.0004.2FBE] # KANGXI RADICAL FIGHT
2FBF      ; [.85BA.0020.0004.2FBF] # KANGXI RADICAL SACRIFICIAL WINE
2FC0      ; [.9176.0020.0004.2FC0] # KANGXI RADICAL CAULDRON
2FC1      ; [.934D.0020.0004.2FC1] # KANGXI RADICAL GHOST
2FC2      ; [.C936.0020.0004.2FC2] # KANGXI RADICAL FISH
2FC3      ; [.AABB.0020.0004.2FC3] # KANGXI RADICAL BIRD
2FC4      ; [.A552.0020.0004.2FC4] # KANGXI RADICAL SALT
2FC5      ; [.A57C.0020.0004.2FC5] # KANGXI RADICAL DEER
2FC6      ; [.A6C0.0020.0004.2FC6] # KANGXI RADICAL WHEAT
2FC7      ; [.A687.0020.0004.2FC7] # KANGXI RADICAL HEMP
2FC8      ; [.96C2.0020.0004.2FC8] # KANGXI RADICAL YELLOW
2FC9      ; [.B656.0020.0004.2FC9] # KANGXI RADICAL MILLET
2FCA      ; [.94F2.0020.0004.2FCA] # KANGXI RADICAL BLACK
2FCB      ; [.CE4C.0020.0004.2FCB] # KANGXI RADICAL EMBROIDERY
2FCC      ; [.A87C.0020.0004.2FCC] # KANGXI RADICAL FROG
2FCD      ; [.8BF6.0020.0004.2FCD] # KANGXI RADICAL TRIPOD
2FCE      ; [.9261.0020.0004.2FCE] # KANGXI RADICAL DRUM
2FCF      ; [.B659.0020.0004.2FCF] # KANGXI RADICAL RAT
2FD0      ; [.8237.0020.0004.2FD0] # KANGXI RADICAL NOSE
2FD1      ; [.AE64.0020.0004.2FD1] # KANGXI RADICAL EVEN
2FD2      ; [.86F0.0020.0004.2FD2] # KANGXI RADICAL TOOTH
2FD3      ; [.A4C6.0020.0004.2FD3] # KANGXI RADICAL DRAGON
2FD4      ; [.9336.0020.0004.2FD4] # KANGXI RADICAL TURTLE
2EF3      ; [.9317.0020.0004.2EF3] # CJK RADICAL C-SIMPLIFIED TURTLE
2FD5      ; [.CAB5.0020.0004.2FD5] # KANGXI RADICAL FLUTE
ENTRY
};
