# Generated by default/object.tt
package Paws::EKS::Nodegroup;
  use Moose;
  has AmiType => (is => 'ro', isa => 'Str', request_name => 'amiType', traits => ['NameInRequest']);
  has CapacityType => (is => 'ro', isa => 'Str', request_name => 'capacityType', traits => ['NameInRequest']);
  has ClusterName => (is => 'ro', isa => 'Str', request_name => 'clusterName', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has DiskSize => (is => 'ro', isa => 'Int', request_name => 'diskSize', traits => ['NameInRequest']);
  has Health => (is => 'ro', isa => 'Paws::EKS::NodegroupHealth', request_name => 'health', traits => ['NameInRequest']);
  has InstanceTypes => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'instanceTypes', traits => ['NameInRequest']);
  has Labels => (is => 'ro', isa => 'Paws::EKS::LabelsMap', request_name => 'labels', traits => ['NameInRequest']);
  has LaunchTemplate => (is => 'ro', isa => 'Paws::EKS::LaunchTemplateSpecification', request_name => 'launchTemplate', traits => ['NameInRequest']);
  has ModifiedAt => (is => 'ro', isa => 'Str', request_name => 'modifiedAt', traits => ['NameInRequest']);
  has NodegroupArn => (is => 'ro', isa => 'Str', request_name => 'nodegroupArn', traits => ['NameInRequest']);
  has NodegroupName => (is => 'ro', isa => 'Str', request_name => 'nodegroupName', traits => ['NameInRequest']);
  has NodeRole => (is => 'ro', isa => 'Str', request_name => 'nodeRole', traits => ['NameInRequest']);
  has ReleaseVersion => (is => 'ro', isa => 'Str', request_name => 'releaseVersion', traits => ['NameInRequest']);
  has RemoteAccess => (is => 'ro', isa => 'Paws::EKS::RemoteAccessConfig', request_name => 'remoteAccess', traits => ['NameInRequest']);
  has Resources => (is => 'ro', isa => 'Paws::EKS::NodegroupResources', request_name => 'resources', traits => ['NameInRequest']);
  has ScalingConfig => (is => 'ro', isa => 'Paws::EKS::NodegroupScalingConfig', request_name => 'scalingConfig', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has Subnets => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'subnets', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::EKS::TagMap', request_name => 'tags', traits => ['NameInRequest']);
  has Taints => (is => 'ro', isa => 'ArrayRef[Paws::EKS::Taint]', request_name => 'taints', traits => ['NameInRequest']);
  has UpdateConfig => (is => 'ro', isa => 'Paws::EKS::NodegroupUpdateConfig', request_name => 'updateConfig', traits => ['NameInRequest']);
  has Version => (is => 'ro', isa => 'Str', request_name => 'version', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EKS::Nodegroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EKS::Nodegroup object:

  $service_obj->Method(Att1 => { AmiType => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EKS::Nodegroup object:

  $result = $service_obj->Method(...);
  $result->Att1->AmiType

=head1 DESCRIPTION

An object representing an Amazon EKS managed node group.

=head1 ATTRIBUTES


=head2 AmiType => Str

If the node group was deployed using a launch template with a custom
AMI, then this is C<CUSTOM>. For node groups that weren't deployed
using a launch template, this is the AMI type that was specified in the
node group configuration.


=head2 CapacityType => Str

The capacity type of your managed node group.


=head2 ClusterName => Str

The name of the cluster that the managed node group resides in.


=head2 CreatedAt => Str

The Unix epoch timestamp in seconds for when the managed node group was
created.


=head2 DiskSize => Int

If the node group wasn't deployed with a launch template, then this is
the disk size in the node group configuration. If the node group was
deployed with a launch template, then this is C<null>.


=head2 Health => L<Paws::EKS::NodegroupHealth>

The health status of the node group. If there are issues with your node
group's health, they are listed here.


=head2 InstanceTypes => ArrayRef[Str|Undef]

If the node group wasn't deployed with a launch template, then this is
the instance type that is associated with the node group. If the node
group was deployed with a launch template, then this is C<null>.


=head2 Labels => L<Paws::EKS::LabelsMap>

The Kubernetes labels applied to the nodes in the node group.

Only labels that are applied with the Amazon EKS API are shown here.
There may be other Kubernetes labels applied to the nodes in this
group.


=head2 LaunchTemplate => L<Paws::EKS::LaunchTemplateSpecification>

If a launch template was used to create the node group, then this is
the launch template that was used.


=head2 ModifiedAt => Str

The Unix epoch timestamp in seconds for when the managed node group was
last modified.


=head2 NodegroupArn => Str

The Amazon Resource Name (ARN) associated with the managed node group.


=head2 NodegroupName => Str

The name associated with an Amazon EKS managed node group.


=head2 NodeRole => Str

The IAM role associated with your node group. The Amazon EKS node
C<kubelet> daemon makes calls to AWS APIs on your behalf. Nodes receive
permissions for these API calls through an IAM instance profile and
associated policies.


=head2 ReleaseVersion => Str

If the node group was deployed using a launch template with a custom
AMI, then this is the AMI ID that was specified in the launch template.
For node groups that weren't deployed using a launch template, this is
the version of the Amazon EKS optimized AMI that the node group was
deployed with.


=head2 RemoteAccess => L<Paws::EKS::RemoteAccessConfig>

If the node group wasn't deployed with a launch template, then this is
the remote access configuration that is associated with the node group.
If the node group was deployed with a launch template, then this is
C<null>.


=head2 Resources => L<Paws::EKS::NodegroupResources>

The resources associated with the node group, such as Auto Scaling
groups and security groups for remote access.


=head2 ScalingConfig => L<Paws::EKS::NodegroupScalingConfig>

The scaling configuration details for the Auto Scaling group that is
associated with your node group.


=head2 Status => Str

The current status of the managed node group.


=head2 Subnets => ArrayRef[Str|Undef]

The subnets that were specified for the Auto Scaling group that is
associated with your node group.


=head2 Tags => L<Paws::EKS::TagMap>

The metadata applied to the node group to assist with categorization
and organization. Each tag consists of a key and an optional value,
both of which you define. Node group tags do not propagate to any other
resources associated with the node group, such as the Amazon EC2
instances or subnets.


=head2 Taints => ArrayRef[L<Paws::EKS::Taint>]

The Kubernetes taints to be applied to the nodes in the node group when
they are created. Effect is one of C<NoSchedule>, C<PreferNoSchedule>,
or C<NoExecute>. Kubernetes taints can be used together with
tolerations to control how workloads are scheduled to your nodes.


=head2 UpdateConfig => L<Paws::EKS::NodegroupUpdateConfig>




=head2 Version => Str

The Kubernetes version of the managed node group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EKS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

