package HTML::Lint::Pluggable::HTML5;
use 5.008_001;
use strict;
use warnings;

our $VERSION = '0.10';

use parent qw/ HTML::Lint::Pluggable::WhiteList /;
use List::MoreUtils qw/any/;

# refs. https://www.w3.org/TR/html5/syntax.html
my %html5_tag = map { $_ => 1 } qw/article aside audio bdi canvas command datalist details dialog embed figcaption figure footer header hgroup keygen main mark menu menuitem meter nav output progress section source summary template time track video rb rp rt rtc ruby wbr/;
my %html5_unclosed_tag = map { $_ => 1 } qw/area base basefont bgsound br col embed frame hr img input link meta param source track wbr/;

my %html5_global_attr = map { $_ => 1 } qw/contenteditable contextmenu draggable dropzone hidden role spellcheck tabindex translate/;
my @html5_global_user_attr = (qr/^aria-/, qr/^data-/);
my %html5_attr = (
    a        => +{ map { $_ => 1 } qw/media/ },
    area     => +{ map { $_ => 1 } qw/media hreflang rel/ },
    base     => +{ map { $_ => 1 } qw/target/ },
    meta     => +{ map { $_ => 1 } qw/charset/ },
    input    => +{ map { $_ => 1 } qw/autofocus placeholder form required autocomplete min max multiple pattern step dirname formaction formenctype formmethod formnovalidate formtarget/ },
    select   => +{ map { $_ => 1 } qw/autofocus form required/ },
    textarea => +{ map { $_ => 1 } qw/autofocus placeholder form required dirname maxlength wrap/ },
    button   => +{ map { $_ => 1 } qw/form autofocus formaction formenctype formmethod formnovalidate formtarget/ },
    output   => +{ map { $_ => 1 } qw/form/ },
    label    => +{ map { $_ => 1 } qw/form/ },
    object   => +{ map { $_ => 1 } qw/form/ },
    fieldset => +{ map { $_ => 1 } qw/form disabled/ },
    form     => +{ map { $_ => 1 } qw/novalidate/ },
    menu     => +{ map { $_ => 1 } qw/type label/ },
    style    => +{ map { $_ => 1 } qw/scoped/ },
    script   => +{ map { $_ => 1 } qw/async/ },
    html     => +{ map { $_ => 1 } qw/manifest/ },
    link     => +{ map { $_ => 1 } qw/sizes/ },
    ol       => +{ map { $_ => 1 } qw/reversed/ },
    iframe   => +{ map { $_ => 1 } qw/sandbox seamless srcdoc allowfullscreen/ },
);

# Generated by html5_entities.pl
my %html5_entity = map { "&" . $_ . ";" => 1 } qw/ lhard EmptySmallSquare capcup
    odot dstrok solbar ulcorn Wcirc caret dscy nearrow zcy nrArr OpenCurlyQuote
    twoheadrightarrow eogon imacr subsetneq boxUr angrt quatint xuplus mp Hfr
    DoubleLeftArrow xcup GreaterLess orv Conint Racute isinv nsupE udhar boxvL
    subsim VerticalLine infintie NotLeftTriangleBar NotVerticalBar vsubne ubrcy
    ncup range doteq leftthreetimes lrarr supmult lessgtr profalar xrArr nge
    gnsim gneq dotminus ubreve rmoust ltrPar SuchThat NotPrecedesEqual simlE
    ulcorner sdotb DownArrowUpArrow marker Omacr Emacr NotLess Gbreve nLl les
    tscy Ropf verbar gtquest gsim divonx Cedilla die tstrok DoubleVerticalBar
    olt nleqslant Oopf Eopf LeftDownVector Lleftarrow YAcy Otimes LJcy nges
    rightsquigarrow Superset lcaron rangd angrtvbd numsp questeq HilbertSpace
    DiacriticalTilde Aogon angmsdaa gdot acd isindot cupdot nlE hoarr swarrow
    NewLine dtrif ntrianglerighteq Xscr Rrightarrow LeftTriangleEqual sfr boxV
    opar KJcy approx succapprox iopf Union bigtriangleup LeftDownTeeVector
    lozenge emptyv gjcy harrw xodot LT smt fllig loang nang fcy LeftVector
    bigstar Mscr submult vArr Bcy ltdot timesbar ucy nsube xrarr target
    sqsubseteq supsim Ncy NotSuperset gvnE oscr nrarr frac15 integers gla kappav
    thicksim DownRightTeeVector DoubleRightArrow Uogon Lacute GreaterTilde Tcy
    smte supsetneq sfrown bsolhsub boxh succeq Dstrok xcirc nLt Lmidot realine
    leftharpoonup vangrt cupcup daleth rbbrk NegativeThickSpace cularrp rbarr
    wreath LongRightArrow beth gscr UpArrowDownArrow ngeq bigcap lbrack gne
    gescc ngsim ContourIntegral ncaron niv GreaterGreater boxdL popf nGg Yscr
    capdot Cayleys leftrightarrows iecy mcomma nsucceq Kopf OverBracket
    triangledown elinters triangleq leg frac25 amalg rnmid lparlt langle prE Not
    veeeq notinvc sqsupe cuesc lg rect cularr ohbar Gcy precnapprox trisb hstrok
    gtlPar Lopf softcy flat DScy LessSlantEqual rightleftharpoons
    twoheadleftarrow LowerLeftArrow simeq fscr dbkarow Uparrow ovbar
    blacklozenge neArr boxminus eDDot quaternions hybull pertenk jfr lltri
    backepsilon ii wcirc uscr napos wp CenterDot ShortRightArrow Nscr iff Breve
    NotGreaterTilde checkmark nearhk angzarr rcaron Mcy boxVh hardcy Bscr utilde
    boxUR shchcy Qfr Zcaron zdot mlcp NestedLessLess UnderBrace Tscr langd
    precnsim gsime race ocy ee dharr Hat leqq smeparsl biguplus topf circledcirc
    commat sstarf DoubleLeftRightArrow bigoplus blk12 eDot gtrless Vopf hslash
    precsim Uarr lesseqgtr gcy prcue rhard strns gesles nvltrie eqcolon quest
    COPY tshcy boxDL SquareSuperset osol subseteqq zeetrf orslope mldr rpargt
    nsupseteqq boxuL nsce Ycy nsc swarhk NotHumpEqual measuredangle subedot
    ReverseElement vartriangleright imof Gscr Vert rrarr Ufr RightAngleBracket
    boxHu Implies CircleDot DJcy rationals napid plusacir blacktriangleright
    ominus Product lmoust DoubleUpDownArrow par nless swArr cdot prnsim dopf
    bigwedge hbar circleddash thickapprox eparsl planckh vltri gtcc lbarr Jfr ap
    zscr parsim egs Gt eqcirc longrightarrow rbrack ycirc NotGreaterEqual jmath
    Assign Lstrok hopf UpDownArrow mapsto Precedes rightharpoonup ecolon
    Rightarrow precneqq horbar boxhd gl Ncedil angmsd NotLeftTriangle comp ac
    Copf order mapstodown frac78 nltri UpArrow rangle Afr nearr plustwo bigvee
    Tcedil Sacute grave NotPrecedesSlantEqual lessdot dwangle Poincareplane
    Because tbrk ntriangleleft eplus NotTilde nvdash UpperLeftArrow lessapprox
    Longleftarrow dollar nvrArr simrarr Gdot TSHcy Cacute efr Vbar Dopf khcy
    nldr NegativeThinSpace notindot uring roang ape vellip ngt leq cscr
    GreaterFullEqual dlcrop angrtvb swarr bumpE tridot Udblac supedot ccups
    cuvee succ longmapsto Gcedil lnE gbreve sqsub NotLessSlantEqual trpezium
    SubsetEqual supseteqq Fopf Sopf nsucc bigsqcup varpi sqsupset blacksquare
    lbbrk DiacriticalDot demptyv sscr RightDownTeeVector setmn simplus ffllig
    kopf mopf backsim Ecaron Xfr iocy bernou boxVR rharu twixt sccue gammad
    lsquor SquareSubset ltimes Bumpeq Rcaron vprop prec npart blacktriangleleft
    nshortmid sext VerticalBar GreaterEqual backcong boxplus bbrktbrk Wopf
    EmptyVerySmallSquare lopf Vvdash xoplus LeftDownVectorBar gap nLtv
    nleftarrow angle RightTeeVector olcir nbumpe lnapprox Ubrcy boxHd
    LowerRightArrow uhblk NotGreaterLess csup supset ReverseEquilibrium
    DifferentialD trie QUOT ReverseUpEquilibrium ecy NotRightTriangleBar xnis
    FilledSmallSquare Ubreve scnsim OverParenthesis gimel ldquor LessLess nsmid
    ShortLeftArrow rightleftarrows gesdoto eqslantgtr nparallel Map UnderBracket
    geqslant lacute glj equest half ggg egsdot lmidot xlarr Rang Acy rarrw
    ldrdhar rtrif seswar intcal xhArr block upuparrows nequiv angmsdae bemptyv
    nhArr odblac cuepr circlearrowright leftrightharpoons lvertneqq Hscr GT lesg
    rbrksld NotReverseElement NotTildeFullEqual nlarr varkappa bbrk nedot And
    ddotseq ic YUcy odsold DoubleDot boxvl risingdotseq succneqq lneqq comma Jcy
    squf LongLeftArrow divideontimes rightarrow bsemi vopf boxdl
    DiacriticalAcute bnequiv scedil Succeeds topbot cirscir duarr Iopf subset
    Ucy DoubleLongRightArrow UpperRightArrow cirfnint starf nopf laemptyv oint
    RoundImplies mid reals Laplacetrf xopf Yfr uogon mnplus utri barwed mstpos
    blk34 Cross succsim ccaps loplus nrightarrow roarr rbrke orderof xutri
    curvearrowleft square af kgreen CircleTimes DotEqual NotExists Lcaron
    NotSquareSupersetEqual gfr napE TildeTilde nsupseteq nacute colone
    NotCongruent boxVH LeftCeiling nVdash ord nlArr robrk urcorn nharr ThinSpace
    Popf succnsim notnivc LessTilde xwedge ijlig sigmav ratail sqcaps ufisht ofr
    boxhu andslope rdca spar nvge vert ratio mumap Imacr el llarr Lang luruhar
    SOFTcy looparrowright bopf Mfr HorizontalLine NotSucceedsSlantEqual bkarow
    NotSquareSubsetEqual imagline Vdashl NotSubsetEqual xharr jcy thksim Abreve
    urcorner simgE vsupnE ntgl propto xlArr RightUpTeeVector wopf RightArrowBar
    asympeq cupor uHar uparrow nvHarr complexes subdot lE racute sol percnt
    Colon backprime boxul lsimg boxH Utilde timesb Gfr drcrop uplus suplarr
    boxVr boxDl NotEqualTilde succnapprox ltrif edot Uscr gel frac38
    RightCeiling longleftarrow angmsdah rtriltri minusd supsetneqq Jukcy
    imagpart phiv nsubset sharp lbrksld dotplus dcaron esim div Zacute
    FilledVerySmallSquare Uarrocir RightTriangleEqual uharl topcir TRADE lharu
    sqcups csupe leftharpoondown NotRightTriangleEqual nwnear Tab vrtri rsquor
    rtimes suphsub yacy Tfr nrtri ropf therefore intlarhk Qscr
    leftrightsquigarrow nmid xcap preceq HARDcy vnsub rightrightarrows ncap
    angmsdad Nfr ForAll epar ufr diamond caps Longrightarrow gnap lesssim Zopf
    UnionPlus Bfr compfn lstrok OpenCurlyDoubleQuote realpart DZcy supne
    cupbrcap qopf NotSucceedsEqual awint ffr nvgt jscr rdquor tcaron Dcaron
    iiint scy bowtie lobrk Ccirc bigtriangledown xdtri EqualTilde aopf awconint
    downharpoonleft lesdot latail precapprox subsetneqq yopf ohm nsccue ange
    ldca hcirc SquareSupersetEqual circledS cfr oS ell scE Gammad rlarr
    straightphi ddarr dzcy jukcy cuwed emsp14 primes thetav
    DoubleLongLeftRightArrow RightTee UpTee RightTeeArrow nLeftrightarrow hyphen
    bNot xsqcup supdot UnderParenthesis triangleright escr DoubleContourIntegral
    Uring Exists gtreqqless scpolint erDot NotElement sdote subne ddagger udblac
    Ascr Diamond Ccaron Star hercon RightVector trianglelefteq ncongdot cups
    raemptyv lrtri cire LessEqualGreater Scirc UpTeeArrow maltese ApplyFunction
    amacr dzigrarr lates cir HumpEqual LeftUpDownVector roplus yucy caron odash
    andand lbrke zfr loarr Jscr vzigzag female dtdot upharpoonright NotSubset
    TildeFullEqual tritime gtcir Verbar nleqq tosa Sc Ll nesear Im triplus ltri
    boxvH inodot bigodot frac23 RightUpDownVector lesseqqgtr mho tcedil ruluhar
    IEcy lBarr NJcy ulcrop NotSquareSuperset lnap rtrie nvinfin npreceq cacute
    ImaginaryI hscr male searhk ZHcy ltlarr zopf CapitalDifferentialD erarr
    phmmat digamma Cscr between DoubleLeftTee sime tdot rbrkslu setminus boxdR
    seArr tprime DownRightVector DownLeftVector bsolb rdsh NegativeVeryThinSpace
    yfr nwArr Fscr DownBreve rarrfs Jcirc subsub afr nwarhk frac13
    NotHumpDownHump LongLeftRightArrow ocir NonBreakingSpace Coproduct lrcorner
    Sscr bumpeq ecaron elsdot icy NotLessEqual bumpe Dscr shcy Rcy lmoustache
    frac58 Upsi vdash shortparallel GJcy CupCap ENG nsubseteqq Ecy emsp13 boxbox
    Ocy angmsdac gE zacute InvisibleComma uwangle prnap rarrtl Supset barwedge
    RightArrowLeftArrow SucceedsEqual nrarrw profsurf odiv cwconint copf
    VerticalSeparator lfisht curlyvee nprcue lhblk OverBrace boxHU
    CloseCurlyQuote triangle DiacriticalDoubleAcute ltcir rfr Topf naturals
    Iogon SquareSubsetEqual gsiml Cdot searr Vscr PartialD CircleMinus
    updownarrow tscr cwint vartheta ncong djcy aleph lAarr plusb heartsuit boxur
    barvee notni rdldhar fopf qfr nGt GT ShortDownArrow fltns ExponentialE
    PlusMinus boxDr Bopf ntlg Zfr midast SquareIntersection uopf boxVl
    NotLeftTriangleEqual Nopf sqcup jcirc cirE epsi omid nisd LeftUpVectorBar
    sqsup late umacr ntriangleright Subset leftarrowtail
    ClockwiseContourIntegral Gopf nsup ast natur boxvR bnot dscr
    NotGreaterFullEqual MinusPlus lagran Lcy rightharpoondown duhar smashp
    Scedil efDot nleftrightarrow eqsim rcub nvap sqsubset REG Sum wfr
    triangleleft qint Square gesdot Congruent bcong nsqsube Nacute uharr rHar
    gtrarr siml nwarr eg supsub pcy lat DownLeftTeeVector Sqrt Pr solb Barwed
    larrlp hookrightarrow cemptyv Kcy top expectation lesges napprox frac56
    iukcy gtrdot ldsh sung DoubleUpArrow nprec drbkarow ssetmn scsim nesim
    varnothing oopf bump gneqq vartriangleleft larrfs vsupne tcy subrarr
    UpEquilibrium RuleDelayed filig gvertneqq Pfr succcurlyeq boxhD swnwar
    varsupsetneqq mDDot Vcy prap models homtht plankv Proportion Leftrightarrow
    midcir nsubE SquareUnion rmoustache sqcap iiota dot boxdr doublebarwedge
    straightepsilon notinva andv HumpDownHump cupcap larrtl gEl DD isinE lesdoto
    it subseteq searrow Mopf bfr Bernoullis epsiv wr rfisht gacute leqslant
    varepsilon dsol ntrianglelefteq suphsol disin nwarrow bigcup mapstoup Edot
    nfr emptyset notinE nLeftarrow curlyeqsucc zigrarr Ifr rtri NotSucceeds
    congdot gnapprox jsercy fflig vfr LeftFloor PrecedesTilde dcy LeftUpVector
    LeftRightVector rBarr Lscr gopf shortmid QUOT notnivb InvisibleTimes bottom
    Rcedil Integral ltrie nshortparallel Esim lap fpartint NotTildeTilde
    SucceedsSlantEqual varrho yicy urtri varr capbrcup plussim Kscr leftarrow
    omacr pscr leftleftarrows nspar Yopf map Lsh IJlig lbrkslu xfr Mellintrf in
    malt bepsi DownRightVectorBar DoubleRightTee supseteq IOcy capcap star
    downdownarrows aogon otimesas nvDash srarr CloseCurlyDoubleQuote
    NotSucceedsTilde incare Dot complement lcub numero rightarrowtail nsupe
    NotGreaterGreater boxDR gesdotol sc AMP varphi SHCHcy period lHar frac35
    sqsupseteq supdsub Lt utrif nltrie boxuR dotsquare lrhard scirc smile rarrlp
    TScy sqsube andd dlcorn Wfr lfr Rsh Fcy rightthreetimes Scy Lcedil
    varsubsetneq iscr nRightarrow DoubleDownArrow phone parsl itilde Xopf Jsercy
    lowbar parallel Hcirc mfr kfr boxvr blacktriangledown rlhar topfork Oscr
    rAarr Escr nap intercal DoubleLongLeftArrow Rscr Dcy vee scnE ngeqq nparsl
    boxUL angmsdag sce Longleftrightarrow RightArrow Tstrok VDash conint Kcedil
    hkswarow olarr lesdotor SmallCircle fjlig circeq NotPrecedes nGtv
    MediumSpace gtrapprox Amacr circlearrowleft larrbfs nbump RightUpVectorBar
    npolint olcross RightDoubleBracket nsupset vBarv angmsdaf mapstoleft Dfr
    eopf curarrm COPY LeftArrowBar puncsp dashv mcy gtrsim rpar eng kcy rarrpl
    angst simg LeftTee frac18 smallsetminus Sfr NotNestedGreaterGreater
    LeftArrow Ffr yscr lcy utdot Sup Gg ccaron hamilt isinsv RightUpVector plus
    rarrb lotimes origof ascr larrhk boxtimes nle Darr vDash ffilig ngeqslant
    Cfr npre ogt prsim pm iinfin downarrow RBarr timesd lozf scap bigotimes
    lbrace telrec Eogon hookleftarrow fork Vee hfr nvle Cup LeftAngleBracket
    varsubsetneqq nles SucceedsTilde geqq LT Jopf lsime ThickSpace Zdot iogon
    minusb ngE NotLessLess zcaron udarr emacr rthree iprod LeftVectorBar smid
    lrhar PrecedesSlantEqual equivDD frown ccirc DownLeftVectorBar plusdo
    supplus upsi check subnE cylcty squarf lAtail nvlArr vnsup lharul Or rcedil
    blk14 angsph CirclePlus Aopf TildeEqual qprime csube npr profline dharl
    bullet ZeroWidthSpace nrarrc plusdu Sub upharpoonleft AMP LeftRightArrow
    LessFullEqual wedge hksearow Updownarrow Equilibrium VeryThinSpace
    RightDownVector llcorner prurel planck varsigma DownTeeArrow varsupsetneq
    rarrap gnE nis prnE tint oast NotSupersetEqual geq bsol NotLessGreater vcy
    dblac dfr boxHD SupersetEqual wscr TripleDot bsime larrsim operp Dashv SHcy
    Icy bot wedgeq Hstrok blacktriangle LeftArrowRightArrow Uopf rsqb pre ncy
    boxv Zscr nlsim dHar Tcaron toea Umacr bcy nleq wedbar isins ssmile supnE
    lEg jopf subplus nsime backsimeq urcrop rsh Equal apid Int qscr minusdu
    RightVectorBar NoBreak NotLessTilde CHcy Gcirc Backslash ll Vfr cirmid
    circledast Cap circledR veebar pr colon boxVL nVDash nsimeq Therefore lgE
    tfr NotCupCap nexists Pcy OverBar ctdot LeftTriangle pointint
    NotGreaterSlantEqual ltcc Ncaron Downarrow coprod rscr lopar preccurlyeq
    Qopf nvrtrie subsup Kfr Larr NotDoubleVerticalBar curlyeqprec xscr drcorn
    copysr apacir pfr UpArrowBar Hacek dfisht csub becaus triminus eqvparsl
    DDotrahd RightTriangleBar notniva longleftrightarrow rbrace iiiint xotime
    abreve NotNestedLessLess excl simne VerticalTilde lthree exponentiale Odblac
    oror kcedil Colone imath Lfr RightTriangle rppolint spadesuit
    RightDownVectorBar vscr rharul nscr orarr lsim lcedil pluscir ltquest Itilde
    ges esdot rAtail trianglerighteq fallingdotseq boxhU cudarrr scnap Iscr
    gtreqless pitchfork UnderBar lneq lnsim ldrushar notinvb NotTildeEqual
    intprod ecir breve bne supE DownTee frac16 curlywedge cross Zcy bscr rarrbfs
    DownArrow uuarr natural pluse curarr ccupssm GreaterEqualLess slarr
    NestedGreaterGreater larrpl lpar Pscr dtri bigcirc Rarrtl LeftTriangleBar
    NotRightTriangle Ycirc doteqdot rcy gcirc hairsp capand Element Intersection
    harrcir rarrhk equals llhard DownArrowBar ring PrecedesEqual rotimes nexist
    xvee larrb njcy nrtrie Re eqslantless nvsim apE curvearrowright ngtr
    Fouriertrf els Cconint Efr Ofr varpropto looparrowleft Tilde glE Wedge YIcy
    Leftarrow Idot gg GreaterSlantEqual acE smtes lsh Rfr KHcy LeftUpTeeVector
    rx ifr DiacriticalGrave boxUl dd angmsdab sopf centerdot kscr nsqsupe mscr
    forkv diamondsuit frac45 acy squ Rarr num Del chcy LeftDoubleBracket Barv
    ycy ropar lescc lne DownLeftRightVector ncedil nsim ultri supsup Wscr lscr
    bsim xmap vsubnE nhpar leftrightarrow coloneq ogon LeftTeeVector LessGreater
    Proportional NotEqual NegativeMediumSpace NotSquareSubset
    CounterClockwiseContourIntegral Hopf easter approxeq clubsuit boxvh DotDot
    simdot nlt multimap imped Vdash gesl zhcy dash kjcy because lvnE rarrc blank
    vBar Iukcy diam npar bprime rarrsim rhov gtdot ljcy thkap REG cudarrl sacute
    subE LeftTeeArrow downharpoonright lurdshar nsubseteq NotGreater lsqb semi
    RightFloor ShortUpArrow nvlt ofcir/;

sub init {
    my($class, $lint) = @_;
    $class->SUPER::init($lint => +{
        rule => +{
            'elem-unknown' => sub {
                my $param = shift;
                return 1 if $html5_tag{$param->{tag}};
                return 0;
            },
            'elem-unclosed' => sub {
                my $param = shift;
                return 1 if $html5_unclosed_tag{$param->{tag}};
                return 0;
            },
            'attr-unknown' => sub {
                my $param = shift;
                return 1 if $html5_global_attr{$param->{attr}};
                return 1 if $html5_attr{$param->{tag}}{$param->{attr}};
                return 1 if any { $param->{attr} =~ $_ } @html5_global_user_attr;
                return 0;
            },
            'text-unknown-entity' => sub {
                my $param = shift;
                return 1 if $html5_entity{$param->{entity}};
                return 0;
            },
        }
    });
}

1;
__END__

=head1 NAME

HTML::Lint::Pluggable::HTML5 - [DEPRECATED] allow HTML5 tags and attributes.

=head1 DEPRECATED

This plugin is no longer be maintenance.
Suggest to use L<HTML::Tidy5> instead of this plugin.

=head1 VERSION

This document describes HTML::Lint::Pluggable::HTML5 version 0.10.

=head1 DEPENDENCIES

Perl 5.8.1 or later.

=head1 BUGS

All complex software has bugs lurking in it, and this module is no
exception. If you find a bug please either email me, or add the bug
to cpan-RT.

=head1 SEE ALSO

L<perl>

=head1 AUTHOR

Kenta Sato E<lt>karupa@cpan.orgE<gt>

=head1 LICENSE AND COPYRIGHT

Copyright (c) 2012, Kenta Sato. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
