package Bio::Chado::Schema::CellLine::CellLineCvtermprop;

# Created by DBIx::Class::Schema::Loader
# DO NOT MODIFY THE FIRST PART OF THIS FILE

use strict;
use warnings;

use base 'DBIx::Class::Core';


=head1 NAME

Bio::Chado::Schema::CellLine::CellLineCvtermprop

=cut

__PACKAGE__->table("cell_line_cvtermprop");

=head1 ACCESSORS

=head2 cell_line_cvtermprop_id

  data_type: integer
  default_value: nextval('cell_line_cvtermprop_cell_line_cvtermprop_id_seq'::regclass)
  is_auto_increment: 1
  is_nullable: 0

=head2 cell_line_cvterm_id

  data_type: integer
  default_value: undef
  is_foreign_key: 1
  is_nullable: 0

=head2 type_id

  data_type: integer
  default_value: undef
  is_foreign_key: 1
  is_nullable: 0

=head2 value

  data_type: text
  default_value: undef
  is_nullable: 1

=head2 rank

  data_type: integer
  default_value: 0
  is_nullable: 0

=cut

__PACKAGE__->add_columns(
  "cell_line_cvtermprop_id",
  {
    data_type         => "integer",
    default_value     => \"nextval('cell_line_cvtermprop_cell_line_cvtermprop_id_seq'::regclass)",
    is_auto_increment => 1,
    is_nullable       => 0,
  },
  "cell_line_cvterm_id",
  {
    data_type      => "integer",
    default_value  => undef,
    is_foreign_key => 1,
    is_nullable    => 0,
  },
  "type_id",
  {
    data_type      => "integer",
    default_value  => undef,
    is_foreign_key => 1,
    is_nullable    => 0,
  },
  "value",
  { data_type => "text", default_value => undef, is_nullable => 1 },
  "rank",
  { data_type => "integer", default_value => 0, is_nullable => 0 },
);
__PACKAGE__->set_primary_key("cell_line_cvtermprop_id");
__PACKAGE__->add_unique_constraint(
  "cell_line_cvtermprop_c1",
  ["cell_line_cvterm_id", "type_id", "rank"],
);

=head1 RELATIONS

=head2 cell_line_cvterm

Type: belongs_to

Related object: L<Bio::Chado::Schema::CellLine::CellLineCvterm>

=cut

__PACKAGE__->belongs_to(
  "cell_line_cvterm",
  "Bio::Chado::Schema::CellLine::CellLineCvterm",
  { cell_line_cvterm_id => "cell_line_cvterm_id" },
  { cascade_copy => 0, cascade_delete => 0 },
);

=head2 type

Type: belongs_to

Related object: L<Bio::Chado::Schema::Cv::Cvterm>

=cut

__PACKAGE__->belongs_to(
  "type",
  "Bio::Chado::Schema::Cv::Cvterm",
  { cvterm_id => "type_id" },
  { cascade_copy => 0, cascade_delete => 0 },
);


# Created by DBIx::Class::Schema::Loader v0.05002 @ 2010-02-18 11:30:28
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:eQ0mmlt4mrBuy7tKcaJJxQ


# You can replace this text with custom content, and it will be preserved on regeneration
1;
