# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BG;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240910191013;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            43[1-6]|
            70[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [356]|
            4[124-7]|
            7[1-9]|
            8[1-6]|
            9[1-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              70|
              8
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            43[1-7]|
            7
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [48]|
            9[08]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '9',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'geographic' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'mobile' => '
          (?:
            43[07-9]|
            99[69]\\d
          )\\d{5}|
          (?:
            8[7-9]|
            98
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(700\\d{5})|(90\\d{6})',
                'toll_free' => '
          (?:
            00800\\d\\d|
            800
          )\\d{5}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"3596544", "Novachene\,\ Pleven",
"3597046", "Boboshevo",
"3599541", "Doktor\ Yosifovo",
"3593923", "Radievo",
"359478", "Elhovo\,\ Yambol",
"3595717", "Vedrina",
"3597733", "Filipovtsi",
"3593545", "Draginovo",
"3596737", "Krushevo\,\ Gabr\.",
"3596921", "Ablanitsa\,\ Lovech",
"3596557", "Bregare",
"3595518", "Rudnik\,\ Burgas",
"3596538", "Obnova",
"3595366", "Branichevo",
"3597164", "Rebrovo",
"3595327", "Kaspichan\,\ Shumen",
"3595318", "Srednya",
"3598675", "Aydemir",
"359861", "Silistra",
"3593707", "Nikolovo\,\ Hask\.",
"3596542", "Vabel\,\ Pleven",
"3593159", "Belozem",
"35960382", "Kovachevets",
"3595527", "Sokolovo\,\ Burgas",
"3598159", "Koshov",
"3599341", "Dimovo\,\ Vidin",
"359361", "Kardzhali",
"3593675", "Fotinovo\,\ Kardzh\.",
"3593071", "Zlatograd",
"3597162", "Lakatnik",
"3593345", "Lyaskovo\,\ Plovdiv",
"3593029", "Petkovo\,\ Smol\.",
"3594125", "Mihaylovo\,\ St\.\ Zagora",
"3599569", "Lipen",
"3594743", "Mamarchevo",
"3598113", "Novo\ selo\,\ Ruse",
"3596003", "Preselets",
"35936702", "Gorski\ izvor\,\ Kardzh\.",
"3593632", "Dzhebel",
"3596960", "Belish",
"3593040", "Trigrad",
"35931605", "Bukovo\,\ Plovdiv",
"3595765", "Lovchantsi",
"3593777", "Mezek",
"3593113", "Branipole",
"359554", "Sunny\ Beach",
"3594350", "Gorno\ Izvorovo",
"3598632", "Zafirovo",
"35960384", "Gagovo",
"3595131", "Valchi\ dol",
"35961395", "Paskalevets",
"3596111", "Kapinovo\,\ V\.\ Tarnovo",
"35984761", "Gradina\,\ Razgrad",
"3597729", "Dolna\ Dikanya",
"3593634", "Pripek\,\ Kardzh\.",
"3593746", "Sirakovo\,\ Hask\.",
"35993342", "Kireevo",
"3594730", "Knyazhevo",
"3598648", "Sekulovo",
"3599180", "Golyamo\ Peshtene",
"35947354", "Kamenna\ reka",
"35941145", "Arnautito",
"35931403", "Trivoditsi",
"3593648", "Golyamo\ Kamenyane",
"3594116", "Rakitnitsa\,\ St\.\ Zagora",
"3598634", "Nova\ Cherna",
"35959405", "Zaychar",
"3599112", "Banitsa",
"3596909", "Malka\ Zhelyazna",
"3593764", "Polyanovo\,\ Hask\.",
"35991180", "Lesura",
"35941336", "Yazdach",
"359748", "Simitli",
"3598133", "Ryahovo",
"3594520", "Konyovo",
"3599148", "Barkachevo",
"35930458", "Lyubcha",
"359379", "Svilengrad",
"3593133", "Kalofer",
"35960388", "Goritsa\,\ Targ\.",
"3595396", "Lovets\,\ Shumen",
"35951428", "Gospodinovo\,\ Varna",
"35984467", "Seslav",
"3599134", "Tarnak",
"3593762", "Izvorovo\,\ Hask\.",
"3594710", "Bolyarsko",
"3598140", "Borovo\,\ Ruse",
"3594136", "Cherna\ gora\,\ St\.\ Zagora",
"3593101", "Voyvodinovo",
"3597192", "Gintsi",
"3599132", "Knezha",
"35974407", "Kremen\,\ Blag\.",
"35942", "Stara\ Zagora",
"3593129", "Skutare",
"35971398", "Osikovitsa",
"3596990", "Malak\ izvor\,\ Lovech",
"3595557", "Bistrets\,\ Burgas",
"3599175", "Ostrov",
"3595737", "Lyulyakovo\,\ Dobr\.",
"3597713", "Rudartsi",
"3596173", "Dolna\ Oryahovitsa",
"3597177", "Aldomirovtsi",
"3596717", "Lesicharka",
"3598129", "Lom\ Cherkovna",
"35930256", "Galabovo\,\ Smol\.",
"3595758", "Kladentsi",
"3593581", "Belovo",
"3595342", "Kapitan\ Petko",
"3595538", "Karanovo\,\ Burgas",
"3596518", "Riben",
"3596583", "Belene",
"3594155", "Glavan\,\ St\.\ Zagora",
"3593059", "Kutela",
"3596327", "Ovcha\ mogila",
"3596566", "Dolni\ Vit",
"3595338", "Troitsa",
"35971306", "Rashkovo",
"3597523", "Garmen",
"3596527", "Odarne",
"3597430", "Damyanitsa",
"3596728", "Burya",
"3595344", "Velino",
"3597146", "Chernyovo",
"3594361", "Pavel\ banya",
"35963579", "Ralevo",
"35963573", "Disevitsa",
"35974495", "Yurukovo",
"3597731", "Tran",
"3593544", "Kostandovo",
"3597927", "Treklyano",
"3596923", "Goran",
"35931401", "Kadievo",
"3595129", "Blaskovo",
"3593921", "Merichleri",
"3593557", "Byaga",
"35931997", "Zlatosel",
"3598672", "Bradvari",
"3596545", "Lyubenovo\,\ Pleven",
"3593758", "Yerusalimovo",
"3594122", "Elenino",
"3599167", "Lipnitsa\,\ Vratsa",
"3593538", "Elshitsa",
"359676", "Dryanovo\,\ Gabr\.",
"3593342", "Narechenski\ bani",
"3597165", "Milanovo\,\ Sofia",
"3593672", "Chorbadzhiysko",
"3599330", "Rabrovo",
"3599126", "Kameno\ pole",
"35931700", "Belovitsa",
"3596159", "Zlataritsa",
"359910", "Mezdra",
"3593542", "Rakitovo",
"35974348", "Igralishte",
"35984763", "Beli\ Lom",
"35984769", "Gorotsvet",
"3598674", "Profesor\ Ishirkovo",
"35937706", "Chernodab",
"3593073", "Startsevo",
"3598424", "Tsar\ Kaloyan\,\ Razgrad",
"3596987", "Karlukovo",
"35930476", "Selcha",
"3594124", "Zmeyovo",
"3593344", "Novakovo\,\ Plovdiv",
"3596029", "Nadarevo",
"3599343", "Gomotartsi",
"3594770", "General\ Inzovo",
"3593674", "Samodiva",
"3597918", "Yabalkovo\,\ Kyust\.",
"3596071", "Antonovo",
"3595764", "Vladimirovo\,\ Dobr\.",
"3594593", "Shivachevo",
"35960454", "Zmeyno",
"3598111", "Shtraklevo",
"3594741", "Bolyarovo",
"3596001", "Cherkovna\,\ Targ\.",
"35996", "Montana",
"3596578", "Reselets",
"35941116", "Sladak\ Kladenets",
"35930417", "Grohotno",
"35961605", "Novo\ gradishte",
"3595133", "General\ Kolevo\,\ Varna",
"359579", "Albena",
"3597117", "Gradets\,\ Sofia",
"3596113", "Balvan",
"3596939", "Dragana",
"35967194", "Grablevtsi",
"3595919", "Marinka",
"3599115", "Chiren",
"35967398", "Damyanovo",
"35931395", "Iganovo",
"35961107", "Momin\ sbor",
"3593111", "Parvenets\,\ Plovdiv",
"3595762", "Stefan\ Karadzha\,\ Dobr\.",
"35931388", "Beguntsi",
"3596033", "Medovina",
"3597058", "Stob",
"35967306", "Gradishte\,\ Gabr\.",
"3595140", "Shkorpilovtsi",
"359938", "Kula",
"35961403", "Orlovets",
"35971227", "Beli\ Iskar",
"3595101", "Dabravino",
"3598697", "Sokol\,\ Silistra",
"3598635", "Tsar\ Samuil",
"35963567", "Gradina\,\ Pleven",
"35937604", "Varbovo\,\ Hask\.",
"3597158", "Doganovo",
"35963571", "Brestovets",
"35960458", "Verentsi",
"3595578", "Terziysko\,\ Burgas",
"3598131", "Borisovo\,\ Ruse",
"3593765", "Ivanovo\,\ Hask\.",
"3599135", "Bardarski\ geran",
"35971220", "Gutsal",
"3596919", "Slatina\,\ Lovech",
"35967394", "Bogatovo",
"3597137", "Skravena",
"3596133", "Mihaltsi",
"35963560", "Radishevo",
"35961307", "Stambolovo\,\ V\.\ Tarnovo",
"3594106", "Pastren",
"35971798", "Vasilovtsi\,Sof\.",
"35977226", "Debeli\ lag",
"35944", "Sliven",
"3595746", "Belgun",
"35941355", "Yavorovo",
"35930410", "Breze\,\ Smol\.",
"35957306", "Izvorovo\,\ Dobr\.",
"35974322", "Petrovo\,\ Blag\.",
"3599749", "Cherni\ vrah\,\ Mont\.",
"3593103", "Milevo",
"3596129", "Gabrovtsi",
"3599174", "Gorni\ Vadin",
"3597711", "Kladnitsa",
"35931707", "Chernozemen",
"35974324", "Struma",
"3593173", "Panicheri",
"359860", "Silistra",
"3593717", "Konush\,\ Hask\.",
"3599720", "Kovachitsa",
"3596581", "Byala\ voda\,\ Pleven",
"35984725", "Kichenitsa",
"3594154", "Mednikarovo",
"3593518", "Dragor",
"3593327", "Bachkovo",
"3593583", "Gabrovitsa",
"3594147", "Lyubenovo\,\ St\.\ Zagora",
"35984736", "Podayva",
"3593626", "Perperek",
"3596953", "Borima",
"359728", "Zlatitsa",
"3593566", "Boshulya",
"3599172", "Selanovtsi",
"3597521", "Koprivlen",
"35967392", "Yavorets",
"3593527", "Aleko\ Konstantinovo",
"3593667", "Pokrovan",
"3594152", "Obruchishte",
"35984745", "Vladimirovtsi",
"3593728", "Slavyanovo\,\ Hask\.",
"3598626", "Sredishte\,\ Silistra",
"3594363", "Gabarevo",
"3597189", "Chavdar\,\ Sofia",
"3594799", "Golyam\ manastir",
"3595345", "Razvigorovo",
"3598667", "Belitsa\,\ Silistra",
"35937602", "Cherna\ mogila\,\ Hask\.",
"3597938", "Dolno\ Uyno",
"3594586", "Neykovo\,\ Sliven",
"3595168", "Petrov\ dol\,\ Varna",
"3596520", "Nikolaevo\,\ Pleven",
"3597437", "Melnik",
"3595743", "Shabla",
"3593932", "Bodrovo",
"3598639", "Kolarovo\,\ Silistra",
"35971505", "Churek",
"35951125", "Konstantinovo\,\ Varna",
"3593639", "Nanovitsa\,\ Kardzh\.",
"3593785", "Dryanovo\,\ Hask\.",
"359454", "Tvarditsa\,\ Sliven",
"35941119", "Elhovo\,\ St\.\ Zagora",
"35941113", "Pryaporets\,\ St\.\ Zagora",
"3593106", "Stroevo",
"3598431", "Isperih",
"35967309", "Agatovo",
"35967303", "Batoshevo",
"3593934", "Skobelevo\,\ Hask\.",
"3596710", "Donino",
"35934", "Pazardzhik",
"35961406", "Karantsi",
"35961502", "Gorsko\ Novo\ Selo",
"3599119", "Tishevitsa",
"3596902", "Ribaritsa\,\ Lovech",
"3595915", "Balgarovo",
"3597724", "Izvor\,\ Pernik",
"3596935", "Sopot\,\ Lovech",
"3596997", "Dobrevtsi\,\ Lovech",
"35984", "Razgrad",
"3595116", "Krumovo\,\ Varna",
"3596136", "Suhindol",
"3594103", "Byal\ izvor\,\ St\.\ Zagora",
"3595391", "Varbitsa\,\ Shumen",
"3596068", "Bozhurka",
"3596956", "Lomets\,\ Lovech",
"3593563", "Varvara\,\ Pazardzhik",
"35962", "Veliko\ Tarnovo",
"3593623", "Boyno",
"3596025", "Alvanovo",
"3598147", "Baniska",
"3599564", "Stubel",
"3594717", "Chargan",
"3596561", "Gulyantsi",
"3593024", "Taran",
"3598623", "Golesh\,\ Silistra",
"35935501", "Ravnogor",
"3594518", "Topolchane",
"3593154", "Chalakovi",
"3594583", "Kipilovo",
"3593147", "Novo\ selo\,\ Plovdiv",
"359590", "Tsarevo",
"3596155", "Konstantin",
"3594327", "Sheynovo",
"3598152", "Krasen\,\ Ruse",
"3594566", "Pitovo",
"3595967", "Bata",
"3597169", "Tompsan",
"3593022", "Vievo",
"3593176", "Starosel",
"3594527", "Zagortsi\,\ Sliven",
"359391", "Dimitrovgrad",
"3596549", "Sanadinovo",
"3594728", "Melnitsa",
"3593586", "Borimechkovo",
"359726", "Svoge",
"35984766", "Kamenar\,\ Razgrad",
"3595125", "Gradinarovo",
"35937703", "Dimitrovche",
"3598122", "Tsenovo\,\ Ruse",
"35952", "Varna",
"3595349", "Studenitsa",
"3594795", "Skalitsa",
"3597185", "Chelopech",
"3594737", "Sinapovo",
"359678", "Teteven",
"3599187", "Lyutadzhik",
"35984733", "Ludogortsi",
"3593052", "Laki\,\ Plovdiv",
"3594557", "Bikovo",
"3594342", "Ovoshtnik",
"3593122", "Manole",
"3593076", "Tsatsarovtsi",
"3599346", "Sinagovtsi",
"359751", "Gotse\ Delchev",
"3594338", "Kran",
"3596926", "Gorno\ Pavlikene",
"35941331", "Granit",
"3598124", "Novgrad",
"3593653", "Mlechino",
"3597041", "Shatrovo",
"3599546", "Slavotin",
"3596967", "Kaleytsa",
"3593054", "Podvis\,\ Smol\.",
"3594344", "Shanovo",
"3593124", "Kalekovets",
"35969245", "Devetaki",
"3595361", "Kaolinovo",
"3599123", "Roman",
"3596125", "Pushevo",
"3594357", "Gorno\ Sahrane",
"3595520", "Cherkovo",
"3596168", "Sushitsa\,\ V\.\ Tarnovo",
"3599745", "Zlatia\,\ Mont\.",
"3593700", "Trakiets",
"3596036", "Sadina",
"35977229", "Galabnik",
"3593741", "Mandra",
"3596591", "Gornik",
"3597754", "Kosharevo",
"3597548", "Godeshevo",
"3595784", "Vrachantsi",
"35941274", "Samuilovo\,\ St\.\ Zagora",
"3595710", "Pobeda\,\ Dobr\.",
"3596550", "Stavertsi",
"3597532", "Bukovo\,\ Blag\.",
"359697", "Lukovit",
"3596915", "Smochan",
"3599139", "Tarnava\,\ Vratsa",
"3597752", "Rezhantsi",
"359936", "Belogradchik",
"35984711", "Mortagonovo",
"3595320", "Pet\ mogili\,\ Shumen",
"3593769", "Oreshets\,\ Hask\.",
"3595136", "Brestak",
"3596116", "Golemanite",
"35963203", "Hadzhidimitrovo\,\ V\.\ Tarnovo",
"3597428", "Gabrene",
"359729", "Godech",
"3595782", "Benkovski\,\ Dobr\.",
"3596905", "Divchovoto",
"3593520", "Miryantsi",
"3596932", "Mikre",
"3595912", "Polski\ izvor",
"3599517", "Kobilyak",
"3594764", "Malenovo",
"35935254", "Dobrovnitsa",
"35937701", "Sladun",
"3599328", "Dolni\ Lom",
"3599783", "Brusartsi",
"3598660", "Tutrakan",
"359746", "Sandanski",
"3593784", "Konstantinovo\,\ Hask\.",
"3593710", "Uzundzhovo",
"3596934", "Katunets",
"3595914", "Atia",
"3597725", "Klenovik",
"35964", "Pleven",
"3598136", "Stambolovo\,\ Ruse",
"3594762", "Vodenichane",
"3599727", "Medkovets",
"3593935", "Varbitsa\,\ Hask\.",
"3594101", "Opan",
"3596948", "Karpachevo",
"3595769", "Hitovo",
"3595393", "Ivanovo\,\ Shumen",
"3593320", "Oreshets\,\ Plovdiv",
"3594140", "Polski\ Gradets",
"3599317", "Archar",
"3593136", "Rozino\,\ Plovdiv",
"359605", "Omurtag",
"3599528", "Gaganitsa",
"3593782", "Kalugerovo\,\ Hask\.",
"35931620", "Dobri\ dol\,\ Plovdiv",
"3594129", "Madzherito",
"3593025", "Banite",
"3596563", "Brest\,\ Pleven",
"3593349", "Boyantsi",
"3593198", "Chehlare",
"35932", "Plovdiv",
"3593679", "Kirkovo",
"3593561", "Septemvri",
"3596024", "Ruets",
"35953435", "Izgrev\,\ Shumen",
"3597526", "Ribnovo",
"35993212", "Karbintsi",
"35982", "Ruse",
"3596154", "Buynovtsi",
"35967301", "Idilevo",
"3595122", "Slaveykovo\,\ Varna",
"3593155", "Momino\ selo",
"3598621", "Silistra",
"3596147", "Ivancha\,\ V\.\ Tarnovo",
"3598679", "Kaynardzha",
"3597143", "Vakarel",
"3597446", "Eleshnitsa\,\ Blag\.",
"3596022", "Probuda\,\ Targ\.",
"3596176", "Polikraishte",
"35941111", "Starozagorski\ bani",
"35960370", "Golyamo\ gradishte",
"35943616", "Turia",
"3596152", "Bebrovo",
"35971337", "Kalugerovo\,\ Sofia",
"3595124", "Komarevo\,\ Varna",
"35935252", "Topoli\ dol",
"359750", "Borovets\,\ Sofia",
"3593549", "Grashevo",
"3596586", "Belene",
"3594794", "Ovchi\ kladenets",
"35984719", "Balkanski",
"35984713", "Blagoevo\,\ Razgrad",
"3597184", "Koprivshtitsa",
"3597030", "Resilovo",
"35960377", "Aprilovo\,\ Targ\.",
"3596122", "Belyakovets",
"3596076", "Taymishte",
"3598690", "Silistra",
"3595147", "Pchelnik\,\ Varna",
"359749", "Bansko",
"3593055", "Elhovets",
"3597043", "Golemo\ selo",
"3593926", "Dobrich\,\ Hask\.",
"3596047", "Zelena\ morava",
"3594792", "Botevo\,\ Yambol",
"3597182", "Mirkovo",
"35953222", "Markovo\,\ Shumen",
"3598125", "Koprivets",
"3593651", "Ardino",
"35947192", "Zavoy",
"35963576", "Tuchenitsa",
"3595363", "Gusla",
"3596124", "Ledenik",
"3599121", "Tsarevets\,\ Vratsa",
"3597110", "Opitsvet",
"3596770", "Plachkovtsi",
"3593125", "Razhevo\ Konare",
"35977221", "Kondofrey",
"3594345", "Raduntsi",
"3597755", "Velkovtsi\,\ Pernik",
"3596912", "Bahovitsa",
"35935258", "Tsar\ Asen\,\ Pazardzhik",
"3593743", "Silen",
"3593168", "Ezerovo\,\ Plovdiv",
"3599744", "Valchedram",
"3593036", "Mogilitsa",
"3594113", "Preslaven",
"3594777", "Tenevo",
"35941339", "Dimitrievo",
"35941333", "Sredno\ gradishte",
"3595106", "Avren\,\ Varna",
"3596980", "Belentsi",
"35931627", "Krushevo\,\ Plovdiv",
"35981886", "Chereshovo\,\ Ruse",
"3599558", "Gavril\ Genovo",
"3598116", "Ivanovo\,\ Ruse",
"3594746", "Popovo\,\ Yambol",
"3596006", "Presian",
"3596914", "Slivek",
"35954", "Shumen",
"3599742", "Yakimovo",
"3597920", "Skrinyano",
"35941019", "Venets\,\ St\.\ Zagora",
"3593116", "Krumovo\,\ Plovdiv",
"3599337", "Gramada",
"35959694", "Gaberovo",
"3595948", "Snyagovo\,\ Burgas",
"3599160", "Glozhene\,\ Vratsa",
"359707", "Sapareva\ banya",
"3593020", "Davidkovo",
"3599560", "Bezdenitsa",
"3594723", "Boyanovo\,\ Yambol",
"3593516", "Tsrancha\,\ Pazardzhik",
"3598150", "Semerdzhievo",
"3597104", "Laga",
"35941332", "Naydenovo",
"3597936", "Slokoshtitsa",
"3594588", "Filaretovo",
"3593767", "Branitsa",
"3593726", "Klokotnitsa",
"3594513", "Gavrailovoc",
"3598628", "Tsar\ Asen\,\ Silistra",
"35984727", "Kamenovo\,\ Razgrad",
"3593191", "Brezovo\,\ Plovdiv",
"35971304", "Lipnitsa\,\ Sofia",
"3599137", "Popitsa",
"3593628", "Miladinovo",
"35931705", "Gorna\ mahala",
"3597102", "Lopyan",
"3593568", "Vinogradets",
"3595775", "Polkovnik\ Dyakovo",
"3597135", "Trudovets",
"35931258", "Glavatar",
"3596900", "Vasilyovo",
"3594108", "Vasil\ Levski\,\ St\.\ Zagora",
"3596941", "Letnitsa",
"35931390", "Moskovets",
"3596063", "Bayachevo",
"3593665", "Svirachi",
"3597172", "Dragoman",
"3596524", "Petarnitsa",
"3596712", "Gabene",
"3595732", "Petleshkovo",
"3599521", "Zamfirovo",
"35971302", "Bozhenitsa",
"3595552", "Dyulevo\,\ Burgas",
"3595347", "Zhivkovo\,\ Shumen",
"3597156", "Ravno\ pole",
"3598665", "Iskra\,\ Silistra",
"3595576", "Lozarevo",
"35947193", "Mogila\,\ Yambol",
"3599189", "Pavolche",
"3596322", "Alekovo\,\ V\.\ Tarnovo",
"35941357", "Zetyovo\,\ St\.\ Zagora",
"35953223", "Tsarkvitsa",
"35941334", "Saedinenie\,\ St\.\ Zagora",
"3595354", "Rish",
"3594739", "Radovets",
"3597720", "Priboy",
"35961305", "Lesicheri",
"3597174", "Kalotina",
"3596714", "Popovtsi",
"3594359", "Asen\,\ St\.\ Zagora",
"3596522", "Zgalevo",
"3595734", "Preselentsi",
"3595554", "Momina\ tsarkva",
"35984712", "Kostandenets",
"3593325", "Cherven\,\ Plovdiv",
"3594145", "Znamenosets",
"3593049", "Beden",
"3598445", "Yuper",
"3596324", "Vardim",
"3595163", "Mlada\ gvardia",
"3595748", "Durankulak",
"3596969", "Beklemeto",
"3595352", "Yankovo",
"35963565", "Mechka\,\ Pleven",
"35960386", "Voditsa\,\ Targ\.",
"3595941", "Skalak\,\ Burgas",
"3597423", "Kolarovo\,\ Blag\.",
"3593704", "Bryagovo\,\ Hask\.",
"35974207", "General\ Todorov",
"35971225", "Novo\ selo\,\ Sofia",
"3596552", "Dolna\ Mitropolia",
"3594329", "Dolno\ Sahrane",
"3593149", "Tsalapitsa",
"3596732", "Sennik",
"3595524", "Ekzarh\ Antimovo",
"3595712", "Stozher",
"35941338", "Tselina",
"3596576", "Radomirtsi",
"3599351", "Izvor\,\ Vidin",
"3598149", "Katselovo",
"3596985", "Rumyantsevo",
"35930456", "Chavdar\,\ Smol\.",
"35961105", "Prisovo",
"3593555", "Nova\ mahala\,\ Pazardzhik",
"35931397", "Hristo\ Danovo",
"3593702", "Tsareva\ polyana",
"3598161", "Vetovo",
"3596547", "Dragash\ voyvoda",
"3597056", "Mursalevo",
"3599551", "Georgi\ Damyanovo",
"3596554", "Krushovene",
"3596734", "Petko\ Slaveykov",
"3595714", "Karapelit",
"3597925", "Gyueshevo",
"3595522", "Iskra\,\ Burgas",
"35947356", "Mramor\,\ Yambol",
"3597126", "Gorni\ Okol",
"35930415", "Devin",
"35961607", "Balkantsi\,\ V\.\ Tarnovo",
"35941018", "Knyazhevsko",
"3599165", "Sofronievo",
"3594529", "Sadievo\,\ Sliven",
"3596352", "Dolni\ Lukovit",
"35969615", "Balabansko",
"3595969", "Galabets\,\ Burgas",
"35941350", "Mirovo\,\ St\.\ Zagora",
"3597167", "Tserovo\,\ Sofia",
"3596163", "Kamen\,\ V\.\ Tarnovo",
"3595324", "Harsovo\,\ Shumen",
"35984718", "Dryanovets\,\ Razgrad",
"3597035", "Cherven\ breg",
"3599128", "Eliseyna",
"3593695", "Komuniga",
"3593637", "Gruevo",
"3593756", "Valche\ pole",
"35984720", "Topchii",
"35941175", "Kolena",
"3593536", "Banya\,\ Pazardzhik",
"3593772", "Momkovo",
"3598637", "Malak\ Preslavets",
"3598695", "Nozharevo",
"3597439", "Ploski",
"35935502", "Fotinovo\,\ Pazardzhik",
"3593658", "Padina\,\ Kardzh\.",
"3594333", "Dabovo\,\ St\.\ Zagora",
"3593050", "Bukova\ polyana",
"35976", "Pernik",
"3597916", "Bagrentsi",
"3594753", "Zornitsa\,\ Yambol",
"35984740", "Bisertsi",
"3593774", "Levka",
"35931995", "Streltsi\,\ Plovdiv",
"3593120", "Hrabrino",
"3599117", "Krivodol",
"3594340", "Panicherevo",
"35963202", "Dragomirovo\,\ V\.\ Tarnovo",
"3596020", "Lilyak",
"3594779", "Hanovo",
"35984734", "Todorovo\,\ Razgrad",
"35930528", "Manastir\,\ Plovdiv",
"3595756", "Bozhan",
"3595536", "Maglen",
"3596516", "Iskar\,\ Pleven",
"359335", "Karlovo",
"359670", "Troyan\,\ Lovech",
"3597105", "Malki\ Iskar",
"3597132", "Radotina",
"3595772", "Telerig",
"35955502", "Suhodol\,\ Burgas",
"3596150", "Zlataritsa",
"3597148", "Muhovo",
"3594511", "Slivenski\ mineralni\ bani",
"3599339", "Makresh",
"35953221", "Stoyan\ Mihaylovski",
"3596726", "Skalsko",
"3597134", "Vrachesh",
"3595774", "Koriten",
"35974346", "Tsaparevo",
"35977222", "Gorna\ Dikanya",
"3596568", "Dabovan",
"359373", "Harmanli",
"3593193", "Borets",
"3595120", "Bozveliysko",
"35961203", "Emen",
"35961705", "Gorski\ dolen\ Trambesh",
"3595336", "Imrenchevo",
"35974405", "Kraishte\,\ Blag\.",
"35937420", "Podkrepa",
"3599523", "Barzia",
"3596525", "Barkach",
"3593664", "Plevun",
"3593712", "Malevo\,\ Hask\.",
"3593524", "Apriltsi\,\ Pazardzhik",
"35967396", "Berievo",
"3596943", "Gorsko\ Slivovo",
"3596061", "Golyamo\ Sokolovo",
"3595149", "Golitsa",
"35941279", "Strelets\,\ St\.\ Zagora",
"3599146", "Sokolare",
"3598442", "Zavet\,\ Razgrad",
"3594142", "Troyanovo\,\ St\.\ Zagora",
"3598664", "Polyana\,\ Silistra",
"35937606", "Shishmanovo",
"35941118", "Ostra\ mogila\,\ St\.\ Zagora",
"3593322", "Zlatovrah",
"3595555", "Fakia",
"35959400", "Daskotna",
"35984465", "Savin",
"3595735", "Krasen\,\ Dobr\.",
"35967308", "Lovnidol",
"359677", "Tryavna",
"3597175", "Gaber",
"3593662", "Zhelezino",
"3594138", "Gita",
"35955504", "Bogdanovo\,\ Burgas",
"35957304", "Dabovik",
"3596930", "Slavshtitsa",
"3593522", "Gelemenovo",
"3595910", "Cherni\ vrah\,\ Burgas",
"3596049", "Kamburovo",
"3595161", "Vetrino",
"3599323", "Drenovets",
"3594157", "Razdelna\,\ St\.\ Zagora",
"3596325", "Kozlovets",
"35984732", "Yonkovo",
"3594144", "Kovachevo\,\ St\.\ Zagora",
"3593324", "Izbeglii",
"35963204", "Delyanovtsi",
"3598662", "Dobrotitsa\,\ Silistra",
"3597922", "Dragovishtitsa\,\ Kyust\.",
"3595525", "Devetak",
"3599740", "Septemvriytsi\,\ Mont\.",
"35959407", "Sini\ rid",
"3596149", "Kutsina",
"3598677", "Srebarna",
"35937702", "Mustrak",
"3593705", "Vaglarovo",
"3595943", "Vresovo",
"3593552", "Bratsigovo",
"3599353", "Koshava",
"35941114", "Lozen\,\ St\.\ Zagora",
"3593347", "Lenovo",
"3599162", "Mihaylovo\,\ Vratsa",
"35930472", "Mihalkovo",
"3596984", "Bezhanovo\,\ Lovech",
"35991185", "Pudria",
"359701", "Dupnitsa",
"3593677", "Drangovo\,\ Kardzh\.",
"3599553", "Prevala",
"35941480", "Kolarovo\,\ St\.\ Zagora",
"3595715", "Popgrigorovo",
"3597924", "Shishkovtsi",
"3593547", "Sarnitsa\,\ Pazardzhik",
"35957308", "Chernookovo\,\ Dobr\.",
"3596555", "Baykal",
"35961397", "Musina",
"3596910", "Malinovo",
"3593646", "Tokachka",
"35967304", "Kramolin",
"3594118", "Pamukchii\,\ St\.\ Zagora",
"3593554", "Kozarsko",
"3598163", "Bazan",
"3597541", "Satovcha",
"3595325", "Voyvoda",
"3599164", "Krushovitsa\,\ Vratsa",
"3596161", "Strazhitsa\,\ V\.\ Tarnovo",
"3596982", "aglen",
"3593748", "Lyaskovets\,\ Hask\.",
"3593163", "Iskra\,\ Plovdiv",
"3598646", "Vokil",
"3597034", "Dzherman",
"3595516", "Indzhe\ voyvoda",
"3596536", "Asparuhovo\,\ Pleven",
"35984738", "Kitanchevo",
"3595368", "Takach",
"3594331", "Gurkovo\,\ St\.\ Zagora",
"35951537", "Chernevo",
"35967302", "Kravenik",
"359570", "Kavarna",
"3597048", "Blazhievo",
"35961503", "Chakali",
"3598694", "Zebil",
"3599319", "Gamzovo",
"3594751", "Voynika",
"3595767", "Zhitnitsa\,\ Dobr\.",
"35930517", "Zabardo",
"3595726", "Tsarichino",
"3597032", "Yahinovo",
"35941112", "Starozagorski\ bani",
"3599729", "Rasovo",
"35935251", "Bratanitsa",
"35937704", "Mladinovo",
"3595316", "Salmanovo",
"3593775", "Generalovo",
"3598692", "Stefan\ Karadzha\,\ Silistra",
"3595108", "Sadovo\,\ Varna",
"3598127", "Karamanovo",
"3599556", "Govezhda",
"3593044", "Lyaskovo\,\ Smol\.",
"3592", "Sofia",
"35941276", "Mogila\,\ St\.\ Zagora",
"3596964", "Velchevo\,\ Lovech",
"3593057", "Plovdivtsi",
"3599182", "Devene",
"3598166", "Svalenik",
"3596329", "Tsarevets\,\ V\.\ Tarnovo",
"3594552", "Stara\ reka\,\ Sliven",
"359727", "Slivnitsa\,\ Sofia",
"3593643", "Golyama\ Chinka",
"35937603", "Rogozinovo",
"3594732", "Ustrem",
"3593127", "Tsaratsovo",
"3594347", "Rozovo\,\ St\.\ Zagora",
"3599110", "Virovsko",
"3593038", "Chokmanovo",
"3598643", "Zlatoklas",
"3594354", "Zimnitsa\,\ St\.\ Zagora",
"3597179", "Golemo\ Malovo",
"3595739", "Pchelarovo\,\ Dobr\.",
"35967774", "Belitsa\,\ Gabr\.",
"3595559", "Kubadin",
"35967399", "Malki\ Varshets",
"35967393", "Dushevo",
"3593166", "Byala\ reka\,\ Plovdiv",
"3593042", "Borino",
"3594554", "Trapoklovo",
"3593118", "Sadovo\,\ Plovdiv",
"3596962", "Cherni\ Osam",
"3599184", "Ohoden",
"3594734", "Srem",
"3595946", "Tranak",
"3595145", "Grozdyovo",
"3599356", "Kalenik\,\ Vidin",
"3596529", "Koilovtsi",
"3594352", "Gorno\ Cherkovishte",
"3598630", "Silistra",
"3598118", "Nikolovo\,\ Ruse",
"3594748", "Voden\,\ Yambol",
"3596571", "Lepitsa",
"35974323", "Lozenitsa",
"3597742", "Kalishte",
"3597911", "Granitsa",
"3595723", "Gurkovo\,\ Dobr\.",
"3596540", "Asenovo\,\ Pleven",
"359868", "Silistra",
"3599335", "Tsar\ Petrovo",
"3595313", "Madara",
"359596", "Pomorie",
"3593751", "Lyubimets",
"3597744", "Elovdol\,\ Pernik",
"3595513", "Gabar",
"3596533", "Stezherovo",
"35984768", "Sinya\ voda",
"35960375", "Garchinovo",
"3594775", "Karavelovo\,\ Yambol",
"3593928", "Dolno\ Belevo",
"359720", "Etropole",
"3593779", "Siva\ reka",
"35961402", "Stefan\ Stambolovo",
"3593937", "Yabalkovo\,\ Hask\.",
"3593721", "Stambolovo\,\ Hask\.",
"3596994", "Brestnitsa\,\ Lovech",
"3596723", "Tsareva\ livada",
"3597727", "Kovachevtsi\,\ Pernik",
"3598196", "Nisovo",
"35938", "Haskovo",
"3599725", "Komoshtitsa",
"3597528", "Hadzhidimovo",
"3595333", "Han\ Krum",
"3599315", "Gradets\,\ Vidin",
"3593196", "Drangovo\,\ Plovdiv",
"3597434", "Strumyani",
"35984764", "Seydol",
"3596588", "Dekov",
"3593511", "Ognyanovo\,\ Pazardzhik",
"3596907", "Gradezhnitsa",
"3595533", "Pirne",
"3596992", "Zlatna\ Panega",
"3596513", "Pordim",
"35975214", "Gaytaninovo",
"3599515", "Madan\,\ Mont\.",
"3595753", "Orlyak",
"3597448", "Bachevo",
"3596178", "Strelets\,\ V\.\ Tarnovo",
"3597718", "Dragichevo",
"35953437", "Gabritsa\,\ Shumen",
"3595340", "Visoka\ polyana\,\ Shumen",
"3594524", "Kamenovo\,\ Sliven",
"3598142", "Bazovets\,\ Ruse",
"3594712", "Kabile",
"35960453", "Moravka",
"3595329", "Mirovtsi",
"3599130", "Tlachene",
"3599326", "Gorni\ Lom",
"35967193", "Kmetovtsi",
"3596559", "Gostilya",
"3594322", "Yagoda",
"3593142", "Brestovitsa\,\ Plovdiv",
"3595719", "Donchevo",
"3599526", "Slatina\,\ Mont\.",
"3593027", "Slaveyno",
"3596946", "Chavdartsi",
"3596359", "Glava",
"3599567", "Dolna\ Verenitsa",
"3598144", "Batishnitsa",
"3594522", "Korten",
"3594714", "Drazhevo",
"3593138", "Vedrare",
"3593157", "Bolyarino",
"35981465", "Batin",
"3599143", "Enitsa",
"3593709", "Karamantsi",
"3596145", "Strahilovo",
"3595571", "Sungurlare",
"3594324", "Shipka",
"3598138", "Brashlen",
"3595529", "Krushovo\,\ Burgas",
"3596044", "Dolno\ Kozarevo",
"3597546", "Slashten",
"3593641", "Krumovgrad",
"3596965", "Beli\ Osam",
"3594149", "Trankovo\,\ St\.\ Zagora",
"3593045", "Dospat",
"35963572", "Yasen\,\ Pleven",
"3597053", "Kocherinovo",
"3595760", "Bozhurovo\,\ Dobr\.",
"3598641", "Okorsh",
"35951314", "Voyvodino",
"3597123", "Kovachevtsi\,\ Sofia",
"3594355", "Buzovgrad",
"3596166", "Vinograd",
"3593719", "Knizhovnik",
"3595142", "Dolni\ chiflik",
"3597426", "Marikostinovo",
"3596042", "Iliyno",
"3594797", "Galabintsi",
"3597187", "Bunovo\,\ Sofia",
"3599185", "Beli\ Izvor",
"3595138", "Dobrotich",
"3596118", "Voneshta\ voda",
"3598669", "Garvan\,\ Silistra",
"35974321", "Harsovo\,\ Blag\.",
"3596573", "Koynare",
"3595144", "Kamchia",
"3593529", "Mokrishte",
"3597913", "Rashka\ Grashtitsa",
"3596917", "Balgarene\,\ Lovech",
"3597139", "Dzhurovo",
"3599348", "Negovanovtsi",
"35969247", "Gostinya",
"35958", "Dobrich",
"3594756", "Polyana\,\ Yambol",
"359723", "Botevgrad",
"3595311", "Gradishte\,\ Shumen",
"3594772", "Simeonovo\,\ Yambol",
"3595958", "Gramatikovo",
"3598670", "Silistra",
"3595511", "Lukoil\ Neftochim",
"3596531", "Izgrev\,\ Pleven",
"3597415", "Selishte\,\ Blag\.",
"3593533", "Bata",
"3597745", "Egalnitsa",
"359747", "Razlog",
"35967391", "Stolat",
"3593753", "Oryahovo\,\ Hask\.",
"3599747", "Mokresh\,\ Mont\.",
"3599548", "Krapchene",
"35963574", "Todorovo\,\ Pleven",
"3599332", "Rakovitsa",
"3594774", "Krumovo\,\ Yambol",
"3594336", "Dolno\ Izvorovo",
"3596928", "Kakrina",
"3593340", "Novi\ izvor",
"3599724", "Stanevo",
"3599512", "Beli\ breg",
"3597119", "Dramsha",
"35931402", "Skobelevo\,\ Plovdiv",
"3595917", "Izvor\,\ Burgas",
"3596937", "Sokolovo\,\ Lovech",
"3597933", "Gramazhdano",
"3594368", "Tarnicheni",
"35968", "Lovech",
"3594516", "Kermen",
"359470", "Topolovgrad",
"3599314", "Dunavtsi\,\ Vidin",
"359721", "Kostinbrod",
"3596958", "Apriltsi\,\ Lovech",
"3593588", "Menenkyovo",
"3599514", "Vladimirovo\,\ Mont\.",
"3599722", "Staliyska\ mahala",
"35969240", "Hlevene",
"3596511", "Pobeda\,\ Pleven",
"35995277", "Cherkaski",
"3595751", "Tervel\,\ Dobr\.",
"3594726", "Malomirovo",
"3597435", "Sklave",
"3593513", "Malo\ Konare",
"3598699", "Tarnovtsi\,\ Silistra",
"3599312", "Bregovo\,\ Vidin",
"3593178", "Krasnovo",
"35960451", "Obitel",
"35963578", "Opanets\,\ Pleven",
"3597039", "Samoranovo",
"3593699", "Gabrovo\,\ Kardzh\.",
"3593787", "Tyanevo\,\ Hask\.",
"3593108", "Boykovo",
"3599169", "Rogozen",
"3594525", "Omarchevo\,\ Sliven",
"35930459", "Brashten",
"3597929", "Sovolyano",
"35935256", "Sbor\,\ Pazardzhik",
"3595127", "Manastir\,\ Varna",
"35960383", "Berkovski",
"35960389", "Kardam\,\ Targ\.",
"3596142", "Obedinenie",
"3595166", "Dobroplodno",
"35951429", "Solnik",
"3593559", "Kapitan\ Dimitrievo",
"35947353", "Balgarska\ polyana",
"3596066", "Buynovo\,\ Targ\.",
"3594715", "Kalchevo",
"3598145", "Trastenik\,\ Ruse",
"3596989", "Toros",
"3595118", "Voditsa\,\ Varna",
"3596138", "Nedan",
"3596027", "Dralfa",
"3595573", "Vezenkovo",
"3593145", "Krichim",
"3596157", "Slivovitsa",
"35951127", "Razdelna\,\ Varna",
"359953", "Berkovitsa",
"3594325", "Kanchevo",
"3596144", "Dolna\ Lipnitsa",
"3599141", "Malorad",
"35961602", "Tsarski\ izvor",
"3593693", "Lyaskovo\,\ Kardzh\.",
"3597033", "Kraynitsi",
"3596128", "Hotnitsa",
"359306", "Rudozem",
"3594335", "Razhena",
"35931392", "Dabene",
"35935393", "Smilets\,\ Pazardzhik",
"3598693", "Zvenimir",
"3593519", "Velichkovo\,\ Pazardzhik",
"35984710", "Osenets",
"3594597", "Borov\ dol",
"3594755", "Tamarino",
"35984728", "Rakovski\,\ Razgrad",
"359971", "Lom",
"3597939", "Tsarvaritsa",
"3596117", "Debelets\,\ V\.\ Tarnovo",
"3595137", "Kaloyan",
"3597188", "Petrich\,\ Sofia",
"3594798", "Savino",
"3593729", "Krivo\ pole",
"35974202", "Klyuch",
"35974204", "Gega",
"3599552", "Belimel",
"3595579", "Vedrovo",
"3597159", "Aprilovo\,\ Sofia",
"3595521", "Venets\,\ Burgas",
"3594736", "Svetlina",
"3595944", "Ruen\,\ Burgas",
"3597425", "Kulata",
"3593740", "Pchelari",
"3596590", "Rakita\,\ Pleven",
"3594556", "Sotirya",
"3593701", "Elena\,\ Hask\.",
"35981463", "Mogilino",
"3599186", "Zgorigrad",
"3599354", "Antimovo\,\ Vidin",
"359725", "Elin\ Pelin",
"3596983", "Dermantsi",
"3593077", "Sredets\,\ Smol\.",
"3593162", "Gradina\,\ Plovdiv",
"3596918", "Drenov",
"3599347", "Bela\ Rada",
"35941358", "Opalchenets",
"3599554", "Chiprovtsi",
"3596551", "Trastenik\,\ Pleven",
"3597923", "Vrattsa",
"3593046", "Barutin",
"3596927", "Umarevtsi",
"3595711", "Ovcharovo\,\ Dobr\.",
"3597545", "Kochan",
"3595942", "Lyulyakovo\,\ Burgas",
"35931394", "Vasil\ Levski\,\ Plovdiv",
"3596966", "Shipkovo",
"3593553", "Batak\,\ Pazardzhik",
"3599547", "Vinishte",
"3598164", "Pisanets",
"3596165", "Asenovo\,\ V\.\ Tarnovo",
"35941330", "Tsenovo\,\ St\.\ Zagora",
"3599352", "Druzhba",
"3599748", "Dalgodeltsi",
"3599163", "Harlets",
"3595321", "Praventsi",
"35991186", "Baurene",
"35961604", "Mirovo\,\ V\.\ Tarnovo",
"3593164", "Dalbok\ izvor",
"3594356", "Hadzhidimitrovo\,\ St\.\ Zagora",
"3596521", "Sadovets",
"35991201", "Lyuti\ brod",
"3599524", "Yagodovo\,\ Mont\.",
"3596957", "Golyama\ Zhelyazna",
"3596579", "Ruptsi\,\ Pleven",
"3596065", "Bistra\,\ Targ\.",
"3595590", "Zhitosvyat",
"3593523", "Sinitevo",
"3596944", "Krushuna",
"35984466", "Zvanartsi",
"3594716", "Veselinovo\,\ Yambol",
"359309", "Pamporovo",
"35941354", "Malko\ Tranovo",
"3594367", "Tazha",
"3599322", "Oreshets\,\ Vidin",
"35941337", "Sarnevets",
"3595351", "Smyadovo",
"3594130", "Spasovo\,\ St\.\ Zagora",
"3593146", "Kurtovo\ Konare",
"35984722", "Yasenovets",
"3596938", "Kalenik\,\ Lovech",
"3598663", "Sitovo\,\ Silistra",
"3595918", "Rusokastro",
"3594326", "Enina",
"3596711", "Kozi\ rog",
"3595731", "General\ Toshevo\,\ Dobr\.",
"3599522", "Kotenovtsi",
"35967395", "Gorna\ Rositsa",
"3594567", "Banya\,\ Sliven",
"3595551", "Sredets\,\ Burgas",
"35931398", "Slatina\,\ Plovdiv",
"3597129", "Raduil",
"3594526", "Mlekarevo",
"3593713", "Dinevo",
"3593177", "Novo\ Zhelezare",
"3596942", "Aleksandrovo\,\ Lovech",
"3596321", "Gorna\ Studena",
"3599324", "Ruzhintsi",
"35947202", "Zhrebino",
"359722", "Samokov",
"3595165", "Nevsha",
"35961608", "Gorski\ Senovets",
"3594768", "Zimnitsa\,\ Yambol",
"35984776", "Harsovo\,\ Razgrad",
"3594143", "Sarnevo\,\ St\.\ Zagora",
"3593587", "Sestrimo",
"3593323", "Bolyartsi\,\ Plovdiv",
"35930257", "Vishnevo",
"3597436", "Levunovo",
"35984744", "Belovets",
"35984717", "Pobit\ kamak\,\ Razgrad",
"3594725", "Lesovo",
"35960373", "Posabina",
"3595128", "Zhitnitsa\,\ Varna",
"3596560", "Kreta\,\ Pleven",
"3598192", "Hotantsa",
"35947204", "Pchela",
"35961706", "Pisarevo\,\ V\.\ Tarnovo",
"35974406", "Dobarsko",
"3593192", "Babek",
"3593107", "Graf\ Ignatievo",
"3593759", "Borislavtsi",
"359457", "Nova\ Zagora",
"3594515", "Mokren",
"35941352", "Vinarovo\,\ St\.\ Zagora",
"3598194", "Sandrovo",
"3596158", "Sredni\ kolibi",
"3596137", "Butovo",
"359848", "Kubrat",
"3597133", "Pravets",
"3595117", "Botevo\,\ Varna",
"3595773", "Lozenets\,\ Dobr\.",
"359418", "Galabovo\,\ St\.\ Zagora",
"3596028", "Vardun",
"359973", "Kozloduy",
"35969032", "Balgarski\ izvor",
"3593194", "Zelenikovo\,\ Plovdiv",
"35974325", "Lilyanovo",
"3597031", "Gorna\ Koznitsa",
"35931602", "Tatarevo\,\ Plovdiv",
"3593691", "Chernoochene",
"3593128", "Zlatitrap",
"3594752", "Parvenets\,\ Yambol",
"3593037", "Sivino",
"3594348", "Dunavtsi\,\ St\.\ Zagora",
"35937422", "Dolni\ Glavanak",
"3593058", "Mugla",
"3598691", "Silistra",
"3595539", "Chernograd",
"3596519", "Beglezh",
"35931996", "Svezhen",
"3594334", "Elhovo\,\ St\.\ Zagora\,\ mun\.\ Nikolaevo",
"3595759", "Kochmar",
"3598128", "Polsko\ Kosovo",
"3596007", "Ralitsa",
"3598117", "Marten",
"3594747", "Dennitsa\,\ Yambol",
"3594754", "Kamenets\,\ Yambol",
"35984730", "Golyam\ Porovets",
"3599336", "Staropatitsa",
"3593117", "Katunitsa",
"3593773", "Kapitan\ Andreevo",
"359745", "Petrich\,\ Blag\.",
"35981461", "Karan\ Varbovka",
"35937707", "Shtit",
"3594332", "Vetren\,\ St\.\ Zagora",
"3599149", "Bukovets\,\ Vratsa",
"3597424", "Karnalovo",
"3595945", "Dobromir",
"3593703", "Zhalti\ bryag",
"359431", "Kazanlak",
"35961106", "Novo\ selo\,\ V\.\ Tarnovo",
"35931792", "Chernichevo\,\ Plovdiv",
"35959404", "Yasenovo\,\ Burgas",
"3595523", "Krumovo\ gradishte",
"3596077", "Stevrek",
"35969616", "Staro\ selo\,\ Lovech",
"3595146", "Goren\ chiflik",
"35941117", "Kazanka",
"35941144", "Kaloyanovets",
"35930416", "Gyovren",
"3596981", "Petrevene",
"3599355", "Kosovo\,\ Vidin",
"35967307", "Mlechevo",
"3598165", "Smirnenski\,\ Ruse",
"3593927", "Chernogorovo\,\ Hask\.",
"3597422", "Topolnitsa\,\ Blag\.",
"3596046", "Vrani\ kon",
"3597544", "Osina",
"3596553", "Oryahovitsa\,\ Pleven",
"3597921", "Zhilentsi",
"35937424", "Kozlets",
"3596733", "Kormyansko",
"359619", "Lyaskovets\,\ V\.\ Tarnovo",
"3595713", "Stefanovo\,\ Dobr\.",
"35960385", "Lomtsi",
"35963566", "Brashlyanitsa",
"35961394", "Daskot",
"35935391", "Blatnitsa",
"3599555", "Kopilovtsi\,\ Mont\.",
"3593165", "Karadzhalovo",
"35931604", "Dragoynovo",
"3599161", "Mizia",
"3596164", "Bryagovitsa",
"3595323", "Pliska",
"3593661", "Ivaylovgrad",
"35959408", "Razhitsa",
"3593521", "Zvanichevo",
"3596064", "Golyamo\ Novo",
"3596523", "Krushovitsa\,\ Pleven",
"3597527", "Gorno\ Dryanovo",
"3595740", "Gorichane",
"35961306", "Patresh",
"35951106", "Osenovo\,\ Varna",
"35941484", "Zemlen",
"3599525", "Dolno\ Ozirovo",
"3597728", "Drugan",
"3598661", "Tutrakan",
"3595162", "Belogradets",
"3596146", "Polski\ Senovets",
"3595353", "Veselinovo\,\ Shumen",
"3596062", "Strazha\,\ Targ\.",
"3593711", "Dolno\ Botevo",
"35957307", "Zhiten\,\ Dobr\.",
"3597717", "Divotino",
"3598649", "Yarebitsa",
"359519", "Devnya",
"3596713", "Vranilovtsi",
"3596177", "Yantra\,\ V\.\ Tarnovo",
"3597447", "Dobrinishte",
"3595733", "Kardam\,\ Dobr\.",
"3595553", "Orlintsi",
"3596908", "Glogovo",
"3593321", "Topolovo\,\ Plovdiv",
"3594100", "Stoletovo\,\ St\.\ Zagora",
"3596323", "Balgarsko\ slivovo",
"3595164", "Neofit\ Rilski",
"3599325", "Belo\ pole\,\ Vidin",
"359453", "Kotel",
"35941110", "Starozagorski\ bani",
"3596587", "Petokladentsi",
"3599516", "Lehchevo",
"3594724", "Razdel\,\ Yambol",
"3594512", "Blatets\,\ Sliven",
"35965617", "Iskar\,\ Pleven",
"35984737", "Raynino",
"35951538", "Izgrev\,\ Varna",
"35931706", "Suhozem",
"3594580", "Borintsi",
"3595519", "Zidarovo",
"3598620", "Silistra",
"3597103", "Brusen\,\ Sofia",
"3596539", "Gradishte\,\ Pleven",
"3598137", "Golyamo\ Vranovo",
"3599726", "Zamfir",
"3594722", "Granitovo\,\ Yambol",
"3594514", "Krushare",
"3595319", "Drumevo",
"3599568", "Blagovo\,\ Mont\.",
"3593028", "Arda",
"3593137", "Klisura\,\ Plovdiv",
"3593195", "Rozovets",
"35991203", "Lik",
"3599316", "Novo\ selo\,\ Vidin",
"3595771", "Krushari",
"3598158", "Mechka\,\ Ruse",
"35969613", "Chiflik\,\ Lovech",
"3595556", "Golyamo\ Bukovo",
"35971587", "Golema\ Rakovitsa",
"35930419", "Yagodina",
"3597176", "Hrabarsko",
"3596716", "Zhaltesh",
"35930413", "Devin",
"3595736", "Vasilevo",
"359650", "Levski\,\ Pleven",
"35991888", "Veslets\,\ Vratsa",
"3595572", "Beronovo",
"3599559", "Gorna\ Kovachitsa",
"3597152", "Gorna\ Malina",
"3596326", "Morava",
"35961103", "Rusalya",
"35961109", "Vaglevtsi",
"3596567", "Somovit",
"3594711", "Bezmer\,\ Yambol",
"3598141", "Dve\ mogili",
"3596526", "Varbitsa\,\ Pleven",
"3595574", "Saedinenie\,\ Burgas",
"3594321", "Maglizh",
"3593100", "Belashtitsa",
"3597154", "Stolnik",
"3595949", "Planinitsa\,\ Burgas",
"3597147", "Pchelin\,\ Sofia",
"3596143", "Maslarevo",
"35931324", "Mrachenik",
"3599145", "Brenitsa\,\ Vratsa",
"35963569", "Kamenets\,\ Pleven",
"35963563", "Borislav",
"35935255", "Rosen\,\ Pazardzhik",
"3596991", "Yablanitsa",
"3599723", "Traykovo",
"3596725", "Gostilitsa",
"3597934", "Bunovo\,\ Kyust\.",
"35931993", "Sarnegor",
"35935418", "Krastava",
"3593724", "Susam",
"3593512", "Hadzhievo",
"3599313", "Kapitanovtsi",
"3595335", "Milanovo\,\ Shumen",
"3595397", "Metodievo\,\ Shumen",
"3595755", "Kolartsi",
"3599513", "Boychinovtsi",
"3596515", "Slavyanovo\,\ Pleven",
"3597932", "Shipochano",
"3595535", "Lyaskovo\,\ Burgas",
"3596950", "Gumoshtnik",
"3594158", "Iskritsa",
"3593722", "Mineralni\ bani\,\ Hask\.",
"3593514", "Chernogorovo\,\ Pazardzhik",
"359618", "Gorna\ Oryahovitsa",
"3594137", "Veren",
"35941173", "Bratya\ Kunchevi",
"3599787", "Smirnenski\,\ Mont\.",
"35941179", "Han\ Asparuhovo",
"3597106", "Yamna",
"35953434", "Yasenkovo",
"35930205", "Starnitsa",
"3597914", "Vaksevo",
"3593678", "Chakalarovo",
"3599540", "Belotintsi",
"35931703", "Zhitnitsa\,\ Plovdiv",
"35931709", "Mihiltsi",
"3593348", "Dobralak",
"359608", "Popovo\,\ Targ\.",
"3593532", "Strelcha",
"3596920", "Lesidren",
"3593752", "Malko\ gradishte",
"35984760", "Trapishte",
"359537", "Novi\ pazar\,\ Shumen",
"3598678", "Sratsimir\,\ Silistra",
"3595315", "Tsarev\ brod",
"3599333", "Boynitsa",
"3593776", "Raykova\ mogila",
"35974388", "Gorno\ Spanchevo",
"3596535", "Kozar\ Belene",
"3593747", "Tatarevo\,\ Hask\.",
"3597912", "Gorna\ Grashtitsa",
"3595515", "Kameno",
"3593534", "Popintsi",
"3593754", "Lozen\,\ Hask\.",
"3597741", "Zemen",
"35936402", "Gorna\ kula",
"3599340", "Septemvriytsi\,\ Vidin",
"3594773", "Okop",
"359518", "Provadia",
"3593548", "Pashovo",
"359702", "Bobov\ dol",
"3597047", "Usoyka",
"3593645", "Avren\,\ Kardzh\.",
"3596043", "Dolno\ Novkovo",
"3599329", "Rabisha",
"3596736", "Gradnitsa\,\ Gabr\.",
"3595716", "Paskalevo",
"3597054", "Rila",
"3596556", "Gorna\ Mitropolia",
"359331", "Asenovgrad",
"3594351", "Koprinka",
"3599719", "Asparuhovo\,\ Mont\.",
"3597124", "Belchinski\ bani",
"3595367", "Todor\ Ikonomovo",
"3596572", "Suhache",
"359550", "Sozopol",
"3598645", "Mezhden",
"35951103", "Lyuben\ Karavelovo",
"35961309", "Gorsko\ Kalugerovo",
"35961303", "Gorna\ Lipnitsa",
"3595326", "Varbyane",
"3595130", "General\ Kiselovo",
"3594551", "Byala\,\ Sliven",
"3596030", "Svetlen\,\ Targ\.",
"3593706", "Tankovo\,\ Hask\.",
"3599181", "Kravoder",
"3595526", "Klikach",
"3597052", "Pastra",
"3599529", "Borovtsi",
"3596574", "Chomakovtsi",
"35974401", "Gorno\ Draglishte",
"3598185", "Senovo",
"3595143", "Byala\,\ Varna",
"3595768", "Odrintsi\,\ Dobr\.",
"35941171", "Dalboki",
"3594523", "Stoil\ voyvoda",
"3596169", "Blagoevo\,\ V\.\ Tarnovo",
"3599142", "Lazarovo",
"3597549", "Dolen\,\ Blag\.",
"359350", "Peshtera\,\ Pazardzhik",
"3593326", "Patriarh\ Evtimovo",
"35981466", "Pomen",
"3593130", "Karavelovo\,\ Plovdiv",
"3594146", "Dinya",
"3599138", "Altimir",
"35991189", "Tri\ kladentsi",
"35991183", "Furen",
"3593567", "Kovachevo\,\ Pazardzhik",
"3593526", "Dinkata",
"3598477", "Samuil",
"3594713", "Stara\ reka\,\ Yambol",
"3598143", "Obretenik",
"3593666", "Popsko",
"35971504", "Belopoptsi",
"3596141", "Polski\ Trambesh",
"3599144", "Nivyanin",
"3598627", "Babuk",
"3598666", "Tutrakan",
"3594323", "Tulovo",
"359675", "Sevlievo",
"3597155", "Lesnovo",
"3593768", "Dositeevo",
"3594587", "Yablanovo",
"3593143", "Perushtitsa",
"3595575", "Prilep\,\ Burgas",
"35981268", "Krivina\,\ Ruse",
"3593725", "Stamboliyski\,\ Hask\.",
"35971221", "Yarlovo",
"35969248", "Skobelevo\,\ Lovech",
"3599721", "Dolno\ Tserovene",
"35963561", "Grivitsa",
"3597935", "Dolno\ selo",
"3595532", "Topolitsa",
"3596512", "Gorni\ Dabnik",
"3596724", "Yantra\,\ Gabr\.",
"3595348", "Trem",
"3595752", "Nova\ Kamena",
"35971502", "Eleshnitsa\,\ Sofia",
"359337", "Hisarya",
"3597136", "Novachene\,\ Sofia",
"3595776", "Cherna\,\ Dobr\.",
"3596580", "Tatari",
"35963570", "Staroseltsi",
"3595334", "Osmar",
"3599311", "Kutovo",
"3594107", "Sredets\,\ St\.\ Zagora",
"3593515", "Kalugerovo\,\ Pazardzhik",
"3595747", "Vaklino",
"3597520", "Kornitsa",
"3597433", "Kresna",
"359357", "Panagyurishte",
"3595534", "Karageorgievo",
"35961101", "Velchevo\,\ V\.\ Tarnovo",
"3596722", "Sokolovo\,\ Gabr\.",
"3596514", "Dolni\ Dabnik",
"359416", "Chirpan",
"3594339", "Yulievo",
"3595754", "Zarnevo",
"35965165", "Pisarovo\,\ Pleven",
"359318", "Saedinenie\,\ Plovdiv",
"3595332", "Dragoevo",
"35930411", "Devin",
"35974403", "Dolno\ Draglishte",
"35974409", "Mesta",
"35961703", "Varbitsa\,\ V\.\ Tarnovo",
"359308", "Madan\,\ Smol\.",
"35981264", "Piperkovo",
"3597915", "Nevestino\,\ Kyust\.",
"35969244", "Tepava",
"3595724", "Dropla\,\ Dobr\.",
"35971471", "Ochusha",
"3596532", "Balgarene\,\ Pleven",
"3593920", "Zlatopole",
"35984392", "Belintsi",
"3595580", "Troyanovo\,\ Burgas",
"3597116", "Petarch",
"3594519", "Samuilovo\,\ Sliven",
"35960376", "Lyublen",
"3595314", "Belokopitovo",
"3593755", "Belitsa\,\ Hask\.",
"3597168", "Bov",
"3593535", "Levski\,\ Pazardzhik",
"3597743", "Divlya",
"35961301", "Byala\ reka\,\ V\.\ Tarnovo",
"3597036", "Balanovo",
"3593696", "Pchelarovo\,\ Kardzh\.",
"3596534", "Malchika",
"3598696", "Suhodol\,\ Silistra",
"3594729", "Kirilovo\,\ Yambol",
"35963577", "Pelishat",
"3596548", "Debovo",
"3595312", "Dibich",
"3594771", "Malomir\,\ Yambol",
"3593657", "Zhaltusha",
"3597926", "Konyavo",
"3593043", "Zmeitsa",
"3596963", "Balkanets",
"359631", "Svishtov",
"3598638", "Bogdantsi\,\ Silistra",
"3593556", "Radilovo",
"3595169", "Momchilovo",
"3593644", "Egrek",
"3599166", "Hayredin",
"3598644", "Chernolik",
"3594353", "Srednogorovo",
"3597125", "Govedartsi",
"3593110", "Popovitsa",
"3593638", "Zvezdel",
"3599127", "Lyutidol",
"35931309", "Kliment\,\ Plovdiv",
"35984463", "Prelez",
"35984469", "Bozhurovo\,\ Razgrad",
"3593030", "Shiroka\ laka",
"3594553", "Rakovo\,\ Sliven",
"35941275", "Lyaskovo\,\ St\.\ Zagora",
"35984779", "Zdravets\,\ Razgrad",
"3599183", "Lilyache",
"3594733", "Orlov\ dol",
"35984394", "Duhovets",
"3593642", "Potochnitsa",
"35969242", "Presyaka",
"3595100", "Sindel",
"3596986", "Daben",
"35981262", "Bistrentsi",
"35931701", "Krastevich",
"3598184", "Glodzhevo",
"3596069", "Vasil\ Levski\,\ Targ\.",
"3595141", "Staro\ Oryahovo",
"3596575", "Telish",
"3598642", "Dulovo",
"3597715", "Studena\,\ Pernik",
"3596175", "Parvomaytsi",
"359777", "Radomir",
"3593720", "Madzharovo",
"3597445", "Banya\,\ Blag\.",
"3594564", "Novoselets",
"3599173", "Galovo",
"35969249", "Doyrentsi",
"35969243", "Kazachevo",
"3596952", "Oreshak\,\ Lovech",
"35961704", "Pravda\,\ V\.\ Tarnovo",
"3593174", "Staro\ Zhelezare",
"3597930", "Eremia",
"35974404", "Babyak",
"3594153", "Madrets\,\ St\.\ Zagora",
"35936700", "Shoptsi",
"3599327", "Chuprene",
"3594362", "Manolovo",
"3596585", "Belene",
"3593584", "Vetren\,\ Pazardzhik",
"3599518", "Marchevo",
"3597525", "Banichan",
"3593510", "Ovchepoltsi",
"3596954", "Vrabevo",
"3599527", "Varshets",
"3594562", "Kriva\ krusha",
"3598156", "Cherven\,\ Ruse",
"3593026", "Smilyan",
"35984462", "Ostrovo",
"3599318", "Bukovets\,\ Vidin",
"35984735", "Sveshtari",
"3593156", "Shishmantsi",
"3594364", "Osetenovo",
"35936401", "Strandzhevo",
"3599728", "Slivata",
"35984726", "Ushintsi",
"3593582", "Momina\ klisura",
"3595341", "Hitrino",
"3593936", "Gorski\ izvor\,\ Hask\.",
"3596148", "Pavel",
"3598135", "Babovo",
"35941356", "Rupkite",
"3597726", "Dren",
"35963205", "Chervena",
"35991668", "Manastirishte",
"35984464", "Veselets\,\ Razgrad",
"3599131", "Dobrolevo",
"3595114", "Ezerovo\,\ Varna",
"3596134", "Byala\ cherkva\,\ V\.\ Tarnovo",
"35957305", "Rositsa\,\ Dobr\.",
"3593135", "Karnare",
"3593197", "Tyurkmen",
"35955505", "Drachevo",
"35931108", "Bogdanitsa",
"3593102", "Karadzhovo",
"35984774", "Golyam\ izvor\,\ Razgrad",
"35991188", "Galatin",
"35984393", "Vazovo",
"3596906", "Cherni\ Vit",
"3595112", "Beloslav",
"35960380", "Drinovo",
"3596132", "Karaisen",
"35974402", "Godlevo",
"3593749", "Garvanovo",
"3593104", "Yagodovo\,\ Plovdiv",
"3595570", "Manolich",
"3595148", "Rudnik\,\ Varna",
"3595763", "Plachidol",
"35930457", "Kasak",
"3596032", "Zaraevo",
"359817", "Byala\,\ Ruse",
"3594745", "Sharkovo",
"3598115", "Chervena\ voda",
"3599111", "Chelopek",
"3595134", "Cherventsi",
"3596114", "Kilifarevo",
"35960387", "Gloginka",
"3593115", "Kuklen",
"3597120", "Dolna\ banya",
"35931308", "Bogdan\,\ Plovdiv",
"35967305", "Stokite",
"35961606", "Vladislav",
"3594139", "Svoboda\,\ St\.\ Zagora",
"3593035", "Varbina",
"35941115", "Borilovo",
"3594592", "Byala\ palanka",
"3593631", "Momchilgrad",
"35984778", "Bogdantsi\,\ Razgrad",
"35991184", "Rakevo",
"3596034", "Slavyanovo\,\ Targ\.",
"3595599", "Hadzhiite",
"3595105", "Priseltsi\,\ Varna",
"3595132", "Mihalich\,\ Varna",
"35931396", "Domlyan",
"3596112", "Samovodene",
"3596570", "Deventsi",
"35971503", "Dolno\ Kamartsi",
"3598631", "Silistra",
"3596048", "Izvorovo\,\ Targ\.",
"35937705", "Pastrogor",
"3595952", "Malko\ Tarnovo",
"3593543", "Dorkovo",
"3597735", "Leva\ reka",
"35974408", "Obidim",
"35984266", "Prostorno",
"3599557", "Gorno\ Tserovene",
"35991401", "Vranyak",
"3596541", "Nikopol",
"3598167", "Tserovets",
"3599544", "Studeno\ buche",
"3594778", "Pobeda\,\ Yambol",
"3593056", "Chepintsi\,\ Smol\.",
"3593925", "Krum",
"3597910", "Bersin",
"35991182", "Osen\,\ Vratsa",
"3593126", "Trud",
"3593072", "Nedelino",
"3594346", "Golyamo\ Dryanovo",
"3599342", "Inovo",
"3593167", "Bryagovo\,\ Plovdiv",
"35930475", "Stomanevo",
"3593530", "Poibrene",
"3596922", "Leshnitsa\,\ Lovech",
"3599338", "Shishentsi",
"3599542", "Smolyanovtsi",
"3595947", "Prosenik",
"35974496", "Filipovo\,\ Blag\.",
"3598673", "Alfatar",
"3597149", "Zhivkovo\,\ Sofia",
"3593074", "Erma\ reka",
"3594123", "Bogomilovo",
"3593343", "Kozanovo",
"3596569", "Lenkovo",
"3599344", "Vrav",
"3593673", "Tihomir",
"359601", "Targovishte",
"359724", "Ihtiman",
"35974327", "Novo\ Delchevo",
"3593175", "Dalgo\ pole\,\ Plovdiv",
"3596720", "Kereka",
"3599129", "Sinyo\ bardo",
"3599171", "Oryahovo\,\ Vratsa",
"3597444", "Belitsa\,\ Blag\.",
"35935419", "Sveta\ Petka",
"35931704", "Ivan\ Vazovo",
"3597714", "Meshtitsa",
"3596174", "Draganovo\,\ V\.\ Tarnovo",
"3597522", "Dabnitsa",
"35931998", "Choba",
"3595126", "Cherkovna\,\ Varna",
"3593585", "Akandzhievo",
"3595330", "Zlatar",
"3596584", "Belene",
"3597438", "Katuntsi",
"3595167", "Venchan",
"3596067", "Kralevo\,\ Targ\.",
"3595750", "Kableshkovo\,\ Dobr\.",
"35974347", "Razdol",
"3595530", "Peshtersko",
"3596510", "Totleben",
"3596955", "Dalbok\ dol",
"35961302", "Batak\,\ V\.\ Tarnovo",
"3596026", "Makariopolsko",
"3597442", "Yakoruda",
"3597712", "Batanovtsi",
"3597524", "Ablanitsa\,\ Blag\.",
"35941178", "Oryahovitsa\,\ St\.\ Zagora",
"3596998", "Golyam\ izvor\,\ Lovech",
"3596156", "Rodina",
"3595343", "Venets\,\ Shumen",
"3596582", "Belene",
"3593763", "Balgarin",
"3593148", "Yoakim\ Gruevo",
"35956", "Burgas",
"3595916", "Rosen\,\ Burgas",
"3598134", "Malko\ Vranovo",
"35930418", "Buynovo\,\ Smol\.",
"3594517", "Ichera",
"359558", "Aytos",
"35961304", "Dimcha",
"3593134", "Sopot\,\ Plovdiv",
"35951104", "Dolishte\,\ Varna",
"3598148", "Gorno\ Ablanovo",
"3594718", "Roza",
"3596135", "Varbovka",
"3597193", "Golesh\,\ Sofia",
"359517", "Dalgopol",
"35961108", "Plakovo",
"3595115", "General\ Kantardzhievo",
"35967397", "Ryahovtsite",
"3599133", "Komarevo\,\ Vratsa",
"3598132", "Yudelnik",
"35941335", "Mogilovo",
"35960450", "Dolna\ Hubavka",
"35931387", "Prolom",
"3594727", "Malak\ manastir",
"35969241", "Yoglav",
"3593132", "Banya\,\ Plovdiv",
"35971228", "Maritsa",
"3593105", "Manolsko\ Konare",
"35931702", "Dolna\ mahala\,\ Plovdiv",
"3595968", "Kableshkovo\,\ Burgas",
"3594528", "Lyubenova\ mahala",
"3593786", "Navasen",
"35963568", "Bukovlak",
"3599140", "Gabare",
"359538", "Veliki\ Preslav",
"3594744", "Golyamo\ Krushevo",
"3598114", "Pirgovo",
"3596004", "Makovo",
"3596916", "Brestovo\,\ Lovech",
"35941172", "Gorno\ Botevo",
"35941146", "Hristianovo",
"35966", "Gabrovo",
"35930414", "Devin",
"3593032", "Srednogortsi",
"3594109", "Trakia",
"35969614", "Gorno\ trape",
"3595761", "Batovo",
"3594595", "Sborishte",
"3594757", "Nedyalsko",
"3594738", "Hlyabovo",
"35961104", "Vodoley",
"3593114", "Brestnik",
"3598640", "Pravda\,\ Silistra",
"35959406", "Razboyna\,\ Burgas",
"3599188", "Gorno\ Peshtene",
"3599113", "Mramoren",
"3595102", "Padina\,\ Varna",
"3596115", "Resen",
"35951108", "Izvorsko",
"3595135", "Stefan\ Karadzha\,\ Varna",
"35961308", "Vishovgrad",
"3593633", "Rogozche",
"3596035", "Palamartsa",
"3594742", "Stefan\ Karadzhovo",
"3596002", "Saedinenie\,\ Targ\.",
"3594358", "Skobelevo\,\ St\.\ Zagora",
"35931606", "Voden\,\ Plovdiv",
"3593034", "Levochevo",
"3599746", "Razgrad\,\ Mont\.",
"3595749", "Krapets\,\ Dobr\.",
"3596968", "Dobrodan",
"3598633", "Staro\ selo\,\ Silistra",
"35963564", "Bivolare",
"3593112", "Markovo\,\ Plovdiv",
"35967390", "Shumata",
"3594337", "Yasenovo\,\ St\.\ Zagora",
"35971224", "Shipochane",
"35931992", "Padarsko",
"3596543", "Muselievo",
"3597547", "Valkosel",
"3593924", "Krepost",
"35931708", "Pesnopoy\,\ Plovdiv",
"3599545", "Gabrovnitsa",
"35951536", "Nikolaevka",
"35963562", "Komarevo\,\ Pleven",
"3596925", "Vladinya",
"3597734", "Glavanovtsi\,\ Pernik",
"3595310", "Radko\ Dimitrievo",
"3596126", "Tserova\ koria",
"3596072", "Dobrotitsa\,\ Targ\.",
"3597163", "Iskrets",
"3596167", "Kesarevo",
"3597186", "Anton",
"3594796", "General\ Toshevo\,\ Yambol",
"3598629", "Smilets\,\ Silistra",
"3596530", "Tranchovitsa",
"3597427", "Parvomay\,\ Blag\.",
"3593922", "Brod",
"3598671", "Silistra",
"3597732", "Vukan",
"35961102", "Pchelishte",
"359610", "Pavlikeni\,\ V\.\ Tarnovo",
"3593671", "Podkova",
"3593569", "Karabunar",
"3596074", "Lyubichevo",
"35969612", "Terziysko\,\ Lovech",
"3599345", "Vinarovo\,\ Vidin",
"3593629", "Most",
"3594121", "Lyulyak",
"35930412", "Devin",
"35941174", "Podslon\,\ St\.\ Zagora",
"3593341", "Konush\,\ Plovdiv",
"3593075", "Dolen\,\ Smol\.",
"359301", "Smolyan",
"35991202", "Kunino",
"3597531", "Dolno\ Dryanovo",
"3593636", "Raven",
"3593744", "Sarnitsa\,\ Hask\.",
"35941489", "Bozduganovo",
"3597751", "Breznik",
"3599168", "Butan",
"3593757", "Georgi\ Dobrevo",
"3593537", "Panagyurski\ kolonii",
"3593109", "Lilkovo",
"3593558", "Isperihovo",
"3598636", "Glavinitsa\,\ Silistra",
"3595781", "Svoboda\,\ Dobr\.",
"35941277", "Zagore",
"35984721", "Lipnik",
"35973", "Blagoevgrad",
"3597928", "Garlyano",
"3595119", "Ignatievo",
"3597917", "Tavalichevo",
"3596913", "Slavyani",
"3596988", "Peshterna",
"3599550", "Mitrovtsi",
"3594112", "Badeshte",
"35947201", "Izgrev\,\ Yambol",
"35953234", "Zlatna\ niva",
"3599116", "Kostelevo",
"35963575", "Bohot",
"3594793", "Boyadzhik",
"3597183", "Dushantsi",
"3594369", "Aleksandrovo\,\ St\.\ Zagora",
"3597042", "Korkina",
"3597118", "Dragovishtitsa\,\ Sofia",
"3596577", "Breste",
"3595362", "Kliment\,\ Shumen",
"359559", "Karnobat",
"3595153", "Suvorovo",
"3596959", "Debnevo",
"3598698", "Shumentsi",
"3596546", "Lozitsa\,\ Pleven",
"3597044", "Babino",
"3593051", "Chepelare",
"3597057", "Malo\ selo",
"35941351", "Partizanin",
"3593589", "Tserovo\,\ Pazardzhik",
"3596123", "Bukovets\,\ V\.\ Tarnovo",
"3597127", "Shiroki\ dol",
"3599125", "Gorna\ Beshovitsa",
"3594341", "Cherganovo",
"35969031", "Galata",
"3597166", "Vlado\ Trichkov",
"3593121", "Rogosh",
"3598475", "Loznitsa\,\ Razgrad",
"3593079", "Kozarka",
"3599561", "Sumer",
"3596564", "Zagrazhden\,\ Pleven",
"3596023", "Podgoritsa",
"35992", "Vratsa",
"3598151", "Prosena",
"3593625", "Shiroko\ pole",
"3599349", "Slanotran",
"3597138", "Litakovo",
"35974386", "Pirin",
"3595959", "Zvezdets",
"3597157", "Sarantsi",
"3596153", "Zlataritsa",
"3595346", "Kamenyak\,\ Shumen",
"35951539", "Levski\,\ Varna",
"3594585", "Zheravna",
"359659", "Cherven\ bryag",
"3595577", "Podvis\,\ Burgas",
"3597144", "Kostenets",
"3593151", "Rakovski\,\ Plovdiv",
"3598625", "Oven",
"35953436", "Chernoglavtsi",
"3596562", "Gigen",
"3593190", "Varben\,\ Plovdiv",
"3595123", "Ravna\,\ Varna",
"3596929", "Radyuvene",
"3599549", "Dolna\ Riksa",
"35974201", "Kapatovo",
"3597142", "Kostenets",
"3593328", "Dolnoslav",
"35959409", "Cheresha",
"35959403", "Rechitsa",
"3594763", "Irechekovo",
"3598448", "Terter",
"3596901", "Glozhene\,\ Lovech",
"3593517", "Lesichovo",
"3595745", "Vranino",
"3599520", "Gorno\ Ozirovo",
"3595392", "Mengishevo",
"3599784", "Kiselevo",
"359556", "Obzor",
"35941149", "Lovets\,\ St\.\ Zagora",
"3593718", "Voyvodovo\,\ Hask\.",
"3594134", "Bratya\ Daskalovi",
"3593783", "Svirkovo",
"3596039", "Opaka",
"3596933", "Golets",
"3597937", "Razhdavitsa",
"3595913", "Krushevets",
"3598668", "Popina",
"3595139", "Oborishte\,\ Varna",
"3596119", "Dichin",
"3593766", "Biser",
"35961393", "Gorsko\ Kosovo",
"35937423", "Golemantsi",
"3593727", "Nova\ Nadezhda",
"35978", "Kyustendil",
"3593931", "Kasnakovo",
"3593528", "Govedare",
"3595394", "Byala\ reka\,\ Shumen",
"3599782", "Bukovets\,\ Mont\.",
"35941270", "Malka\ Vereya",
"3594132", "Orizovo",
"35931603", "Vinitsa",
"3594599", "Chervenakovo",
"3594105", "Byalo\ pole",
"3599136", "Galiche",
"3599320", "Stakevtsi",
"3599741", "Dolni\ Tsibar",
"35946", "Yambol",
"3595328", "Nikola\ Kozlevo",
"359915", "Byala\ Slatina",
"3593745", "Malak\ izvor\,\ Hask\.",
"3597533", "Osikovo\,\ Blag\.",
"3596537", "Asenovtsi",
"3595517", "Ravnets\,\ Burgas",
"3597753", "Noevtsi",
"3596738", "Dobromirka",
"3595718", "Smolnitsa",
"3596558", "Slavovitsa\,\ Pleven",
"35941359", "Izvorovo\,\ St\.\ Zagora",
"35941353", "Plodovitovo",
"3595783", "Kotlentsi",
"359417", "Radnevo",
"3593019", "Pisanitsa",
"3594115", "Kirilovo\,\ St\.\ Zagora",
"359336", "Parvomay\,\ Plovdiv",
"3595766", "Metodievo\,\ Dobr\.",
"3595727", "Senokos\,\ Dobr\.",
"3596911", "Lisets\,\ Lovech",
"3595528", "Nevestino\,\ Burgas",
"3593708", "Orlovo\,\ Hask\.",
"3595317", "Ivanski",
"35960372", "Krepcha",
"35960374", "Gorsko\ Ablanovo",
"35947203", "Trankovo\,\ Yambol",
"3593652", "Byal\ izvor\,\ Kardzh\.",
"3598676", "Vetren\,\ Silistra",
"35984749", "Sevar",
"3597181", "Pirdop",
"35984743", "Brestovene",
"3593778", "Studena\,\ Hask\.",
"3593346", "Muldava",
"3594330", "Nikolaevo\,\ St\.\ Zagora",
"3598187", "Tetovo",
"35981266", "Starmen\,\ Ruse",
"3594126", "Hrishteni",
"3599122", "Zverino",
"3597529", "Breznitsa",
"3593676", "Benkovski\,\ Kardzh\.",
"3598123", "Bosilkovtsi",
"35930200", "Zagrazhden\,\ Smol\.",
"3593647", "Chernichevo\,\ Kardzh\.",
"3597045", "Golem\ Varbovnik",
"3596589", "Kulina\ voda",
"35984723", "Dyankovo",
"35984729", "Ezerche",
"3593053", "Hvoyna",
"3594343", "Konare\,\ St\.\ Zagora",
"35971338", "Osikovska\ Lakavitsa",
"3593123", "Kaloyanovo\,\ Plovdiv",
"3596121", "Nikyup",
"3599124", "Tipchenitsa",
"3595365", "Lyatno",
"3597719", "Yardzhilovtsi",
"3598647", "Paisievo",
"3596179", "Krusheto",
"3593564", "Semchinovo",
"3596021", "Buhovtsi",
"3593624", "Chiflik\,\ Kardzh\.",
"3596565", "Milkovitsa",
"35960378", "Tsar\ Asen\,\ Targ\.",
"3593023", "Momchilovtsi",
"35935394", "Oborishte\,\ Pazardzhik",
"3598624", "Kalipetrovo",
"35961391", "Slomer",
"3597145", "Mirovo\,\ Sofia",
"35937421", "Dolno\ pole",
"359359", "Velingrad",
"35984765", "Veselina",
"3599147", "Borovan",
"35984269", "Nedoklan",
"3593153", "Stryama",
"3594584", "Ticha",
"35975215", "Teshovo",
"3596151", "Elena\,\ V\.\ Tarnovo",
"3599176", "Leskovets\,\ Vratsa",
"3593562", "Slavovitsa\,\ Pazardzhik",
"359339", "Stamboliyski\,\ Plovdiv",
"3594510", "Zhelyu\ voyvoda",
"3593622", "Stremtsi",
"3595589", "Vinarsko",
"3598622", "Alekovo\,\ Silistra",
"3593929", "Golyamo\ Asenovo",
"35995276", "Draganitsa",
"3594156", "Aprilovo\,\ St\.\ Zagora",
"35981462", "Volovo",
"3594582", "Gradets\,\ Sliven",
"3595121", "Tutrakantsi",
"35935257", "Saraya",
"3596328", "Oresh",
"35981464", "Ostritsa\,\ Ruse",
"3595757", "Bezmer\,\ Dobr\.",
"35961405", "Petko\ Karavelovo",
"3596060", "Ovcharovo\,\ Targ\.",
"35974203", "Rupite",
"3596517", "Podem",
"3594761", "Straldzha",
"3595537", "Sadievo\,\ Burgas",
"35931791", "Begovo",
"3595558", "Debelt",
"3593781", "Simeonovgrad",
"3596718", "Draganovtsi",
"3597178", "Prolesha",
"3595738", "Spasovo\,\ Dobr\.",
"3593039", "Polkovnik\ Serafimovo",
"3594102", "Yastrebovo\,\ St\.\ Zagora",
"3599785", "Vasilovtsi\,\ Mont\.",
"35931393", "Voynyagovo",
"359865", "Silistra",
"3593933", "Stransko",
"3595742", "Rakovski\,\ Dobr\.",
"3593119", "Galabovo\,\ Plovdiv",
"35994", "Vidin",
"3596931", "Ugarchin",
"35971506", "Gabra",
"3597723", "Dolni\ Rakovets",
"3596727", "Ganchovets",
"35935392", "Dyulevo\,\ Pazardzhik",
"35961603", "Lozen\,\ V\.\ Tarnovo",
"3594749", "Ruzhitsa\,\ Yambol",
"3596528", "Valchitran",
"3594104", "Kravino",
"35953220", "Pamukchii\,\ Shumen",
"3595337", "Kochovo",
"3595395", "Chernookovo\,\ Shumen",};
$areanames{bg} = {"3597434", "Струмяни",
"35984764", "Сейдол",
"3596588", "Деков",
"3593511", "Огняново\,\ Пазарджик",
"3596907", "Градежница",
"3595533", "Пирне",
"3596992", "Златна\ Панега",
"3596513", "Пордим",
"35975214", "Гайтаниново",
"3599515", "Мадан\,\ Монт\.",
"3595753", "Орляк",
"3597448", "Бачево",
"3597718", "Драгичево",
"3596178", "Стрелец\,\ В\.\ Търново",
"35953437", "Габрица\,\ Шумен",
"3595340", "Висока\ поляна\,\ Шумен",
"3593779", "Сива\ река",
"35961402", "Стефан\ Стамболово",
"3593937", "Ябълково\,\ Хаск\.",
"3593721", "Стамболово\,\ Хаск\.",
"3596994", "Брестница\,\ Ловеч",
"3596723", "Царева\ ливада",
"3597727", "Ковачевци\,\ Перник",
"3598196", "Нисово",
"3599725", "Комощица",
"35938", "Хасково",
"3597528", "Хаджидимово",
"3595333", "Хан\ Крум",
"3599315", "Градец\,\ Видин",
"3593196", "Дрангово\,\ Пловдив",
"3599526", "Слатина\,\ Монт\.",
"3596946", "Чавдарци",
"3593027", "Славейно",
"3599567", "Долна\ Вереница",
"3598144", "Батишница",
"3594714", "Дражево",
"3594522", "Кортен",
"3596359", "Глава",
"3593138", "Ведраре",
"3593157", "Болярино",
"35981465", "Батин",
"3599143", "Еница",
"3593709", "Караманци",
"3596145", "Страхилово",
"3595571", "Сунгурларе",
"3594324", "Шипка",
"3598138", "Бръшлен",
"3595529", "Крушово\,\ Бургас",
"3598142", "Бъзовец\,\ Русе",
"3594712", "Кабиле",
"3594524", "Каменово\,\ Сливен",
"3595329", "Мировци",
"35960453", "Моравка",
"3599130", "Тлачене",
"3599326", "Горни\ Лом",
"35967193", "Кметовци",
"3594322", "Ягода",
"3596559", "Гостиля",
"3593142", "Брестовица\,\ Пловдив",
"3595719", "Дончево",
"3593042", "Борино",
"3594554", "Трапоклово",
"3593118", "Садово\,\ Пловдив",
"3596962", "Черни\ Осъм",
"3599184", "Оходен",
"3594734", "Срем",
"3595946", "Трънак",
"3595145", "Гроздьово",
"3599356", "Каленик\,\ Видин",
"3596529", "Коиловци",
"3594352", "Горно\ Черковище",
"3598630", "Силистра",
"3594748", "Воден\,\ Ямбол",
"3598118", "Николово\,\ Русе",
"3596571", "Лепица",
"3595108", "Садово\,\ Варна",
"3598127", "Караманово",
"3599556", "Говежда",
"3593044", "Лясково\,\ Смол\.",
"3592", "София",
"35941276", "Могила\,\ Ст\.\ Загора",
"3593057", "Пловдивци",
"3596964", "Велчево\,\ Ловеч",
"3599182", "Девене",
"3598166", "Сваленик",
"3596329", "Царевец\,\ В\.\ Търново",
"3594552", "Стара\ река\,\ Сливен",
"359727", "Сливница\,\ София",
"3593643", "Голяма\ Чинка",
"35937603", "Рогозиново",
"3594732", "Устрем",
"3593127", "Царацово",
"3594347", "Розово\,\ Ст\.\ Загора",
"3599110", "Вировско",
"3593038", "Чокманово",
"3597179", "Големо\ Малово",
"3598643", "Златоклас",
"3594354", "Зимница\,\ Ст\.\ Загора",
"3595739", "Пчеларово\,\ Добр\.",
"35967774", "Белица\,\ Габр\.",
"3595559", "Кубадин",
"35967399", "Малки\ Вършец",
"35967393", "Душево",
"3593166", "Бяла\ река\,\ Пловдив",
"3593751", "Любимец",
"3597744", "Еловдол\,\ Перник",
"3595513", "Габър",
"3596533", "Стежерово",
"35984768", "Синя\ вода",
"35960375", "Гърчиново",
"3594775", "Каравелово\,\ Ямбол",
"3593928", "Долно\ Белево",
"359720", "Етрополе",
"35974323", "Лозеница",
"3597742", "Калище",
"3597911", "Граница",
"3596540", "Асеново\,\ Плевен",
"3595723", "Гурково\,\ Добр\.",
"359868", "Силистра",
"3599335", "Цар\ Петрово",
"3595313", "Мадара",
"359596", "Поморие",
"3593588", "Мененкьово",
"3599722", "Сталийска\ махала",
"3599514", "Владимирово\,\ Монт\.",
"35969240", "Хлевене",
"3596511", "Победа\,\ Плевен",
"35995277", "Черкаски",
"3595751", "Тервел\,\ Добр\.",
"3594726", "Маломирово",
"3597435", "Склаве",
"3598699", "Търновци\,\ Силистра",
"3593513", "Мало\ Конаре",
"3599312", "Брегово\,\ Видин",
"3593178", "Красново",
"35960451", "Обител",
"35963578", "Опанец\,\ Плевен",
"3597039", "Самораново",
"3593699", "Габрово\,\ Кърдж\.",
"3593787", "Тянево\,\ Хаск\.",
"3599512", "Бели\ брег",
"3599724", "Станево",
"3597119", "Дръмша",
"35931402", "Скобелево\,\ Пловдив",
"3595917", "Извор\,\ Бургас",
"3597933", "Грамаждано",
"3596937", "Соколово\,\ Ловеч",
"3594368", "Търничени",
"35968", "Ловеч",
"3594516", "Кермен",
"359470", "Тополовград",
"3599314", "Дунавци\,\ Видин",
"359721", "Костинброд",
"3596958", "Априлци\,\ Ловеч",
"35947353", "Българска\ поляна",
"3596066", "Буйново\,\ Търг\.",
"3594715", "Калчево",
"3598145", "Тръстеник\,\ Русе",
"3596989", "Торос",
"3595118", "Водица\,\ Варна",
"3596138", "Недан",
"3596027", "Дралфа",
"3595573", "Везенково",
"3593145", "Кричим",
"3596157", "Сливовица",
"359953", "Берковица",
"3594325", "Кънчево",
"35951127", "Разделна\,\ Варна",
"3596144", "Долна\ Липница",
"3599141", "Малорад",
"3593108", "Бойково",
"3599169", "Рогозен",
"3594525", "Омарчево\,\ Сливен",
"35930459", "Бръщен",
"3597929", "Соволяно",
"35935256", "Сбор\,\ Пазарджик",
"3595127", "Манастир\,\ Варна",
"35960389", "Кардам\,\ Търг\.",
"35960383", "Берковски",
"3596142", "Обединение",
"3595166", "Доброплодно",
"3593559", "Капитан\ Димитриево",
"35951429", "Солник",
"3597426", "Марикостиново",
"3596042", "Илийно",
"3597187", "Буново\,\ София",
"3594797", "Гълъбинци",
"3599185", "Бели\ Извор",
"3595138", "Добротич",
"3596118", "Вонеща\ вода",
"3598669", "Гарван\,\ Силистра",
"35974321", "Хърсово\,\ Благ\.",
"3596573", "Койнаре",
"3595144", "Камчия",
"3593529", "Мокрище",
"3596044", "Долно\ Козарево",
"3597546", "Слащен",
"3593641", "Крумовград",
"3596965", "Бели\ Осъм",
"3593045", "Доспат",
"3594149", "Трънково\,\ Ст\.\ Загора",
"35963572", "Ясен\,\ Плевен",
"3597053", "Кочериново",
"3595760", "Божурово\,\ Добр\.",
"3598641", "Окорш",
"35951314", "Войводино",
"3597123", "Ковачевци\,\ София",
"3594355", "Бузовград",
"3596166", "Виноград",
"3593719", "Книжовник",
"3595142", "Долни\ чифлик",
"3598670", "Силистра",
"3595511", "Лукойл\ Нефтохим",
"3596531", "Изгрев\,\ Плевен",
"3597415", "Селище\,\ Благ\.",
"3593533", "Бъта",
"3597745", "Егълница",
"359747", "Разлог",
"35967391", "Столът",
"3593753", "Оряхово\,\ Хаск\.",
"3599747", "Мокреш\,\ Монт\.",
"35963574", "Тодорово\,\ Плевен",
"3599548", "Крапчене",
"3599332", "Раковица",
"3594774", "Крумово\,\ Ямбол",
"3594336", "Долно\ Изворово",
"3596928", "Къкрина",
"3593340", "Нови\ извор",
"3596917", "Българене\,\ Ловеч",
"3597913", "Рашка\ Гращица",
"3597139", "Джурово",
"3599348", "Неговановци",
"35969247", "Гостиня",
"35958", "Добрич",
"3594756", "Поляна\,\ Ямбол",
"359723", "Ботевград",
"3595311", "Градище\,\ Шумен",
"3594772", "Симеоново\,\ Ямбол",
"3595958", "Граматиково",
"3593555", "Нова\ махала\,\ Пазарджик",
"35961105", "Присово",
"35931397", "Христо\ Даново",
"3593702", "Царева\ поляна",
"3598161", "Ветово",
"3596547", "Драгаш\ войвода",
"3597056", "Мурсалево",
"3599551", "Георги\ Дамяново",
"3596554", "Крушовене",
"3596734", "Петко\ Славейков",
"3597925", "Гюешево",
"3595522", "Искра\,\ Бургас",
"3595714", "Карапелит",
"35947356", "Мрамор\,\ Ямбол",
"3597126", "Горни\ Окол",
"35961607", "Балканци\,\ В\.\ Търново",
"35930415", "Девин",
"35941018", "Княжевско",
"3599165", "Софрониево",
"3594529", "Съдиево\,\ Сливен",
"3596352", "Долни\ Луковит",
"35969615", "Балабанско",
"3595969", "Гълъбец\,\ Бургас",
"3597167", "Церово\,\ София",
"3595324", "Хърсово\,\ Шумен",
"3596163", "Камен\,\ В\.\ Търново",
"35941350", "Мирово\,\ Ст\.\ Загора",
"35963565", "Мечка\,\ Плевен",
"35960386", "Водица\,\ Търг\.",
"3595941", "Скалак\,\ Бургас",
"3597423", "Коларово\,\ Благ\.",
"3593704", "Брягово\,\ Хаск\.",
"35974207", "Генерал\ Тодоров",
"35971225", "Ново\ село\,\ София",
"3594329", "Долно\ Сахране",
"3596552", "Долна\ Митрополия",
"3593149", "Цалапица",
"3596732", "Сенник",
"3595524", "Екзарх\ Антимово",
"3595712", "Стожер",
"35941338", "Целина",
"3596576", "Радомирци",
"3599351", "Извор\,\ Видин",
"3598149", "Кацелово",
"3596985", "Румянцево",
"35930456", "Чавдар\,\ Смол\.",
"3593050", "Букова\ поляна",
"35976", "Перник",
"3597916", "Багренци",
"3594753", "Зорница\,\ Ямбол",
"35984740", "Бисерци",
"3593774", "Левка",
"35931995", "Стрелци\,\ Пловдив",
"3593120", "Храбрино",
"3594340", "Паничерево",
"3599117", "Криводол",
"35984718", "Дряновец\,\ Разград",
"3599128", "Елисейна",
"3593695", "Комунига",
"3597035", "Червен\ брег",
"3593637", "Груево",
"3593756", "Вълче\ поле",
"35984720", "Топчии",
"35941175", "Колена",
"3593536", "Баня\,\ Пазарджик",
"3593772", "Момково",
"3598637", "Малък\ Преславец",
"3598695", "Ножарево",
"3597439", "Плоски",
"35935502", "Фотиново\,\ Пазарджик",
"3593658", "Падина\,\ Кърдж\.",
"3594333", "Дъбово\,\ Ст\.\ Загора",
"35941332", "Найденово",
"3597936", "Слокощица",
"3594588", "Филаретово",
"3593767", "Браница",
"3593726", "Клокотница",
"3594513", "Гавраилово",
"3598628", "Цар\ Асен\,\ Силистра",
"35984727", "Каменово\,\ Разград",
"3593191", "Брезово\,\ Пловдив",
"35971304", "Липница\,\ София",
"3593628", "Миладиново",
"3599137", "Попица",
"35931705", "Горна\ махала",
"3597102", "Лопян",
"3593568", "Виноградец",
"3595775", "Полковник\ Дяково",
"3597135", "Трудовец",
"35931258", "Главатар",
"359707", "Сапарева\ баня",
"3593020", "Давидково",
"3599560", "Безденица",
"3594723", "Бояново\,\ Ямбол",
"3593516", "Црънча\,\ Пазарджик",
"3598150", "Семерджиево",
"3597104", "Лъга",
"3597720", "Прибой",
"35961305", "Лесичери",
"3597174", "Калотина",
"3596522", "Згалево",
"3596714", "Поповци",
"3594359", "Асен\,\ Ст\.\ Загора",
"3595734", "Преселенци",
"3595554", "Момина\ църква",
"35984712", "Костанденец",
"3593325", "Червен\,\ Пловдив",
"3594145", "Знаменосец",
"3593049", "Беден",
"3598445", "Юпер",
"3596324", "Вардим",
"3595163", "Млада\ гвардия",
"3596969", "Беклемето",
"3595748", "Дуранкулак",
"3595352", "Янково",
"3596900", "Васильово",
"3594108", "Васил\ Левски\,\ Ст\.\ Загора",
"3596941", "Летница",
"35931390", "Московец",
"3593665", "Свирачи",
"3596063", "Баячево",
"3596712", "Гъбене",
"3597172", "Драгоман",
"3596524", "Петърница",
"3599521", "Замфирово",
"3595732", "Петлешково",
"35971302", "Боженица",
"3595552", "Дюлево\,\ Бургас",
"3597156", "Равно\ поле",
"3595347", "Живково\,\ Шумен",
"3598665", "Искра\,\ Силистра",
"3595576", "Лозарево",
"3599189", "Паволче",
"35947193", "Могила\,\ Ямбол",
"3596322", "Алеково\,\ В\.\ Търново",
"35941357", "Зетьово\,\ Ст\.\ Загора",
"35941334", "Съединение\,\ Ст\.\ Загора",
"35953223", "Църквица",
"3595354", "Риш",
"3594739", "Радовец",
"3599553", "Превала",
"35941480", "Коларово\,\ Ст\.\ Загора",
"3595715", "Попгригорово",
"3597924", "Шишковци",
"3593547", "Сърница\,\ Пазарджик",
"35957308", "Чернооково\,\ Добр\.",
"3596555", "Байкал",
"35961397", "Мусина",
"3596910", "Малиново",
"3593646", "Токачка",
"35967304", "Крамолин",
"3594118", "Памукчии\,\ Ст\.\ Загора",
"3593554", "Козарско",
"3598163", "Бъзън",
"3597541", "Сатовча",
"3595325", "Войвода",
"3599164", "Крушовица\,\ Враца",
"3596982", "Ъглен",
"3596161", "Стражица\,\ В\.\ Търново",
"3593748", "Лясковец\,\ Хаск\.",
"3593163", "Искра\,\ Пловдив",
"3598646", "Вокил",
"3595525", "Деветак",
"3597922", "Драговищица\,\ Кюст\.",
"3599740", "Септемврийци\,\ Монт\.",
"35959407", "Сини\ рид",
"3598677", "Сребърна",
"3596149", "Куцина",
"35937702", "Мустрак",
"3593705", "Въгларово",
"3595943", "Вресово",
"3593552", "Брацигово",
"3599353", "Кошава",
"3593347", "Леново",
"35941114", "Лозен\,\ Ст\.\ Загора",
"3599162", "Михайлово\,\ Враца",
"35930472", "Михалково",
"3596984", "Бежаново\,\ Ловеч",
"35991185", "Пудрия",
"359701", "Дупница",
"3593677", "Дрангово\,\ Кърдж\.",
"3599319", "Гъмзово",
"3594751", "Войника",
"3595767", "Житница\,\ Добр\.",
"35930517", "Забърдо",
"3595726", "Царичино",
"3597032", "Яхиново",
"35941112", "Старозагорски\ бани",
"3599729", "Расово",
"35935251", "Братаница",
"35937704", "Младиново",
"3595316", "Салманово",
"3593775", "Генералово",
"3598692", "Стефан\ Караджа\,\ Силистра",
"3595516", "Индже\ войвода",
"3597034", "Джерман",
"3596536", "Аспарухово\,\ Плевен",
"35984738", "Китанчево",
"3595368", "Тъкач",
"3594331", "Гурково\,\ Ст\.\ Загора",
"35951537", "Чернево",
"35967302", "Кръвеник",
"359570", "Каварна",
"3597048", "Блажиево",
"35961503", "Чакали",
"3598694", "Зебил",
"3597148", "Мухово",
"3594511", "Сливенски\ минерални\ бани",
"3599339", "Макреш",
"35953221", "Стоян\ Михайловски",
"3596726", "Скалско",
"3597134", "Врачеш",
"3595774", "Коритен",
"35974346", "Цапарево",
"35977222", "Горна\ Диканя",
"3596568", "Дъбован",
"359373", "Харманли",
"3595120", "Бозвелийско",
"3593193", "Борец",
"35961203", "Емен",
"35961705", "Горски\ долен\ Тръмбеш",
"3595336", "Имренчево",
"35974405", "Краище\,\ Благ\.",
"35963202", "Драгомирово\,\ В\.\ Търново",
"3596020", "Лиляк",
"3594779", "Ханово",
"35984734", "Тодорово\,\ Разград",
"35930528", "Манастир\,\ Пловдив",
"3595756", "Божан",
"3595536", "Мъглен",
"359335", "Карлово",
"3596516", "Искър\,\ Плевен",
"359670", "Троян\,\ Ловеч",
"3597105", "Малки\ Искър",
"3597132", "Радотина",
"3595772", "Телериг",
"35955502", "Суходол\,\ Бургас",
"3596150", "Златарица",
"3595555", "Факия",
"35959400", "Дъскотна",
"35984465", "Савин",
"3595735", "Красен\,\ Добр\.",
"35967308", "Ловнидол",
"359677", "Трявна",
"3597175", "Габер",
"3593662", "Железино",
"3594138", "Гита",
"35955504", "Богданово\,\ Бургас",
"35957304", "Дъбовик",
"3596930", "Славщица",
"3593522", "Гелеменово",
"3595910", "Черни\ връх\,\ Бургас",
"3596049", "Камбурово",
"3595161", "Ветрино",
"3599323", "Дреновец",
"3594157", "Разделна\,\ Ст\.\ Загора",
"3596325", "Козловец",
"35984732", "Йонково",
"3594144", "Ковачево\,\ Ст\.\ Загора",
"3593324", "Избеглии",
"35963204", "Деляновци",
"3598662", "Добротица\,\ Силистра",
"3599523", "Бързия",
"35937420", "Подкрепа",
"3596525", "Бъркач",
"3593664", "Плевун",
"3593712", "Малево\,\ Хаск\.",
"3593524", "Априлци\,\ Пазарджик",
"35967396", "Бериево",
"3596943", "Горско\ Сливово",
"3596061", "Голямо\ Соколово",
"3595149", "Голица",
"35941279", "Стрелец\,\ Ст\.\ Загора",
"3599146", "Соколаре",
"3598442", "Завет\,\ Разград",
"3594142", "Трояново\,\ Ст\.\ Загора",
"35937606", "Шишманово",
"3598664", "Поляна\,\ Силистра",
"3593322", "Златовръх",
"35941118", "Остра\ могила\,\ Ст\.\ Загора",
"3594338", "Крън",
"3596926", "Горно\ Павликене",
"3598124", "Новград",
"35941331", "Гранит",
"3593653", "Млечино",
"3599546", "Славотин",
"3597041", "Шатрово",
"3593054", "Подвис\,\ Смол\.",
"3596967", "Калейца",
"3594344", "Шаново",
"3593124", "Калековец",
"35969245", "Деветаки",
"3595361", "Каолиново",
"3599123", "Роман",
"3596125", "Пушево",
"3594357", "Горно\ Сахране",
"3598122", "Ценово\,\ Русе",
"35952", "Варна",
"3595349", "Студеница",
"3597185", "Челопеч",
"3594795", "Скалица",
"3594737", "Синапово",
"359678", "Тетевен",
"3599187", "Лютаджик",
"3593052", "Лъки\,\ Пловдив",
"35984733", "Лудогорци",
"3594557", "Биково",
"3594342", "Овощник",
"3593122", "Маноле",
"3593076", "Цацаровци",
"3599346", "Синаговци",
"359751", "Гоце\ Делчев",
"3595710", "Победа\,\ Добр\.",
"3596550", "Ставерци",
"359697", "Луковит",
"3597532", "Буково\,\ Благ\.",
"3596915", "Смочан",
"3599139", "Търнава\,\ Враца",
"3597752", "Режанци",
"359936", "Белоградчик",
"35984711", "Мортагоново",
"3595320", "Пет\ могили\,\ Шумен",
"3593769", "Орешец\,\ Хаск\.",
"3595136", "Брестак",
"3596116", "Големаните",
"35963203", "Хаджидимитрово\,\ В\.\ Търново",
"3597428", "Габрене",
"359729", "Годеч",
"3595782", "Бенковски\,\ Добр\.",
"3595520", "Черково",
"3596168", "Сушица\,\ В\.\ Търново",
"3599745", "Златия\,\ Монт\.",
"3593700", "Тракиец",
"3596036", "Садина",
"35977229", "Гълъбник",
"3593741", "Мандра",
"3596591", "Горник",
"3597754", "Кошарево",
"3597548", "Годешево",
"3595784", "Врачанци",
"35941274", "Самуилово\,\ Ст\.\ Загора",
"35967303", "Батошево",
"35967309", "Агатово",
"3596710", "Донино",
"3593934", "Скобелево\,\ Хаск\.",
"35934", "Пазарджик",
"35961406", "Каранци",
"35961502", "Горско\ Ново\ Село",
"3599119", "Тишевица",
"3596902", "Рибарица\,\ Ловеч",
"3595915", "Българово",
"3597724", "Извор\,\ Перник",
"3596935", "Сопот\,\ Ловеч",
"3596997", "Добревци\,\ Ловеч",
"35984", "Разград",
"3595116", "Крумово\,\ Варна",
"3596136", "Сухиндол",
"3594103", "Бял\ извор\,\ Ст\.\ Загора",
"3595391", "Върбица\,\ Шумен",
"3596068", "Божурка",
"3595168", "Петров\ дол\,\ Варна",
"3593932", "Бодрово",
"3597437", "Мелник",
"3595743", "Шабла",
"3596520", "Николаево\,\ Плевен",
"3598639", "Коларово\,\ Силистра",
"35971505", "Чурек",
"35951125", "Константиново\,\ Варна",
"3593785", "Дряново\,\ Хаск\.",
"3593639", "Нановица\,\ Кърдж\.",
"359454", "Твърдица\,\ Сливен",
"35941119", "Елхово\,\ Ст\.\ Загора",
"35941113", "Пряпорец\,\ Ст\.\ Загора",
"3593106", "Строево",
"3598431", "Исперих",
"3594566", "Питово",
"3598152", "Красен\,\ Русе",
"3595967", "Бата",
"3597169", "Томпсън",
"3593022", "Виево",
"3593176", "Старосел",
"3594527", "Загорци\,\ Сливен",
"359391", "Димитровград",
"3596549", "Санадиново",
"3594728", "Мелница",
"3593586", "Боримечково",
"359726", "Своге",
"3595125", "Градинарово",
"35984766", "Каменар\,\ Разград",
"35937703", "Димитровче",
"3596956", "Ломец\,\ Ловеч",
"3593563", "Варвара\,\ Пазарджик",
"35962", "Велико\ Търново",
"3596025", "Алваново",
"3593623", "Бойно",
"3594717", "Чарган",
"3599564", "Стубел",
"3598147", "Баниска",
"3596561", "Гулянци",
"3593024", "Търън",
"3598623", "Голеш\,\ Силистра",
"3594518", "Тополчане",
"35935501", "Равногор",
"3593154", "Чалъкови",
"3593147", "Ново\ село\,\ Пловдив",
"3594583", "Кипилово",
"359590", "Царево",
"3596155", "Константин",
"3594327", "Шейново",
"3593055", "Елховец",
"3593926", "Добрич\,\ Хаск\.",
"3597043", "Големо\ село",
"3596047", "Зелена\ морава",
"3594792", "Ботево\,\ Ямбол",
"3597182", "Мирково",
"35953222", "Марково\,\ Шумен",
"3593651", "Ардино",
"3598125", "Копривец",
"35947192", "Завой",
"35963576", "Тученица",
"3595363", "Гусла",
"3596124", "Леденик",
"3599121", "Царевец\,\ Враца",
"3597110", "Опицвет",
"3596770", "Плачковци",
"3593125", "Ръжево\ Конаре",
"35977221", "Кондофрей",
"3594345", "Радунци",
"35984713", "Благоево\,\ Разград",
"35984719", "Балкански",
"3594794", "Овчи\ кладенец",
"3597184", "Копривщица",
"3597030", "Ресилово",
"35960377", "Априлово\,\ Търг\.",
"3596122", "Беляковец",
"3596076", "Таймище",
"3598690", "Силистра",
"3595147", "Пчелник\,\ Варна",
"359749", "Банско",
"3594746", "Попово\,\ Ямбол",
"3598116", "Иваново\,\ Русе",
"3596006", "Пресиян",
"3596914", "Сливек",
"35954", "Шумен",
"3599742", "Якимово",
"3597920", "Скриняно",
"35941019", "Венец\,\ Ст\.\ Загора",
"3593116", "Крумово\,\ Пловдив",
"3599337", "Грамада",
"3595948", "Снягово\,\ Бургас",
"35959694", "Габерово",
"3599160", "Гложене\,\ Враца",
"3597755", "Велковци\,\ Перник",
"3596912", "Баховица",
"3593743", "Силен",
"35935258", "Цар\ Асен\,\ Пазарджик",
"3593168", "Езерово\,\ Пловдив",
"3599744", "Вълчедръм",
"3593036", "Могилица",
"3594113", "Преславен",
"3594777", "Тенево",
"35941333", "Средно\ градище",
"35941339", "Димитриево",
"3595106", "Аврен\,\ Варна",
"3596980", "Беленци",
"35931627", "Крушево\,\ Пловдив",
"3599558", "Гаврил\ Геново",
"35981886", "Черешово\,\ Русе",
"3593710", "Узунджово",
"3596934", "Катунец",
"3597725", "Кленовик",
"3595914", "Атия",
"35964", "Плевен",
"3598136", "Стамболово\,\ Русе",
"3594762", "Воденичане",
"3599727", "Медковец",
"3593935", "Върбица\,\ Хаск\.",
"3594101", "Опан",
"3596948", "Кърпачево",
"3595769", "Хитово",
"3595393", "Иваново\,\ Шумен",
"3593320", "Орешец\,\ Пловдив",
"3594140", "Полски\ Градец",
"3599317", "Арчар",
"3593136", "Розино\,\ Пловдив",
"359605", "Омуртаг",
"3599528", "Гаганица",
"3593782", "Калугерово\,\ Хаск\.",
"35931620", "Добри\ дол\,\ Пловдив",
"3596905", "Дивчовото",
"3593520", "Мирянци",
"3596932", "Микре",
"3595912", "Полски\ извор",
"3599517", "Кобиляк",
"3594764", "Маленово",
"35935254", "Добровница",
"35937701", "Сладун",
"3599328", "Долни\ Лом",
"3599783", "Брусарци",
"3598660", "Тутракан",
"359746", "Сандански",
"3593784", "Константиново\,\ Хаск\.",
"3596022", "Пробуда\,\ Търг\.",
"3597446", "Елешница\,\ Благ\.",
"3596176", "Поликраище",
"35941111", "Старозагорски\ бани",
"35960370", "Голямо\ градище",
"35943616", "Турия",
"3596152", "Беброво",
"35971337", "Калугерово\,\ София",
"3595124", "Комарево\,\ Варна",
"35935252", "Тополи\ дол",
"359750", "Боровец\,\ София",
"3593549", "Грашево",
"3596586", "Белене",
"3593025", "Баните",
"3594129", "Маджерито",
"3596563", "Брест\,\ Плевен",
"3593349", "Боянци",
"3593198", "Чехларе",
"35932", "Пловдив",
"3593679", "Кирково",
"3593561", "Септември",
"3596024", "Руец",
"35953435", "Изгрев\,\ Шумен",
"3597526", "Рибново",
"35993212", "Карбинци",
"35982", "Русе",
"3596154", "Буйновци",
"35967301", "Идилево",
"3595122", "Славейково\,\ Варна",
"3593155", "Момино\ село",
"3598621", "Силистра",
"3598679", "Кайнарджа",
"3597143", "Вакарел",
"3596147", "Иванча\,\ В\.\ Търново",
"3593762", "Изворово\,\ Хаск\.",
"3598140", "Борово\,\ Русе",
"3594710", "Болярско",
"3594136", "Черна\ гора\,\ Ст\.\ Загора",
"3593101", "Войводиново",
"3597192", "Гинци",
"3599132", "Кнежа",
"3593764", "Поляново\,\ Хаск\.",
"35991180", "Лесура",
"35941336", "Яздач",
"359748", "Симитли",
"3598133", "Ряхово",
"3594520", "Коньово",
"3599148", "Бъркачево",
"35930458", "Любча",
"359379", "Свиленград",
"3593133", "Калофер",
"35960388", "Горица\,\ Търг\.",
"3595396", "Ловец\,\ Шумен",
"35951428", "Господиново\,\ Варна",
"35984467", "Сеслав",
"3599134", "Търнак",
"3596566", "Долни\ Вит",
"3595338", "Троица",
"35971306", "Рашково",
"3597430", "Дамяница",
"3597523", "Гърмен",
"3596527", "Одърне",
"3596728", "Буря",
"3595344", "Велино",
"3597146", "Черньово",
"3594361", "Павел\ баня",
"35963573", "Дисевица",
"35963579", "Ралево",
"35974407", "Кремен\,\ Благ\.",
"35942", "Стара\ Загора",
"3593129", "Скутаре",
"35971398", "Осиковица",
"3596990", "Малък\ извор\,\ Ловеч",
"3595557", "Бистрец\,\ Бургас",
"3599175", "Остров",
"3595737", "Люляково\,\ Добр\.",
"3597713", "Рударци",
"3597177", "Алдомировци",
"3596173", "Долна\ Оряховица",
"3596717", "Лесичарка",
"3598129", "Лом\ Черковна",
"35930256", "Гълъбово\,\ Смол\.",
"3595758", "Кладенци",
"3593581", "Белово",
"3595342", "Капитан\ Петко",
"3595538", "Караново\,\ Бургас",
"3596518", "Рибен",
"3596583", "Белене",
"3594155", "Главан\,\ Ст\.\ Загора",
"3593059", "Кутела",
"3596327", "Овча\ могила",
"3598675", "Айдемир",
"3595318", "Средня",
"3593707", "Николово\,\ Хаск\.",
"359861", "Силистра",
"3596542", "Въбел\,\ Плевен",
"3593159", "Белозем",
"35960382", "Ковачевец",
"3595527", "Соколово\,\ Бургас",
"3598159", "Кошов",
"3599341", "Димово\,\ Видин",
"359361", "Кърджали",
"3593675", "Фотиново\,\ Кърдж\.",
"3593071", "Златоград",
"3597162", "Лакатник",
"3593345", "Лясково\,\ Пловдив",
"3593029", "Петково\,\ Смол\.",
"3594125", "Михайлово\,\ Ст\.\ Загора",
"3599569", "Липен",
"3596544", "Новачене\,\ Плевен",
"3597046", "Бобошево",
"3599541", "Доктор\ Йосифово",
"3593923", "Радиево",
"359478", "Елхово\,\ Ямбол",
"3595717", "Ведрина",
"3596737", "Крушево\,\ Габр\.",
"3597733", "Филиповци",
"3593545", "Драгиново",
"3596921", "Абланица\,\ Ловеч",
"3596557", "Брегаре",
"3595518", "Рудник\,\ Бургас",
"3596538", "Обнова",
"3595366", "Браничево",
"3597164", "Реброво",
"3595327", "Каспичан\,\ Шумен",
"3593634", "Припек\,\ Кърдж\.",
"35993342", "Киреево",
"3593746", "Сираково\,\ Хаск\.",
"3594730", "Княжево",
"3598648", "Секулово",
"3599180", "Голямо\ Пещене",
"35947354", "Каменна\ река",
"35941145", "Арнаутито",
"35931403", "Триводици",
"3593648", "Голямо\ Каменяне",
"3594116", "Ракитница\,\ Ст\.\ Загора",
"3598634", "Нова\ Черна",
"35959405", "Зайчар",
"3599112", "Баница",
"3596909", "Малка\ Желязна",
"3598113", "Ново\ село\,\ Русе",
"3594743", "Мамарчево",
"3596003", "Преселец",
"35936702", "Горски\ извор\,\ Кърдж\.",
"3593632", "Джебел",
"3596960", "Белиш",
"35931605", "Буково\,\ Пловдив",
"3593040", "Триград",
"3595765", "Ловчанци",
"359554", "Слънчев\ бряг",
"3593113", "Браниполе",
"3593777", "Мезек",
"3594350", "Горно\ Изворово",
"3598632", "Зафирово",
"35960384", "Гагово",
"35961395", "Паскалевец",
"3595131", "Вълчи\ дол",
"3596111", "Къпиново\,\ В\.\ Търново",
"35984761", "Градина\,\ Разград",
"3597729", "Долна\ Диканя",
"35944", "Сливен",
"3595746", "Белгун",
"35941355", "Яворово",
"35930410", "Брезе\,\ Смол\.",
"35957306", "Изворово\,\ Добр\.",
"35974322", "Петрово\,\ Благ\.",
"3599749", "Черни\ връх\,\ Монт\.",
"3593103", "Милево",
"35937604", "Върбово\,\ Хаск\.",
"3597158", "Доганово",
"35960458", "Веренци",
"35963571", "Брестовец",
"3595578", "Терзийско\,\ Бургас",
"3598131", "Борисово\,\ Русе",
"3593765", "Иваново\,\ Хаск\.",
"3599135", "Бърдарски\ геран",
"35971220", "Гуцал",
"3596919", "Слатина\,\ Ловеч",
"35967394", "Богатово",
"3596133", "Михалци",
"3597137", "Скравена",
"35961307", "Стамболово\,\ В\.\ Търново",
"35963560", "Радишево",
"3594106", "Пъстрен",
"35971798", "Василовци\,Соф\.",
"35977226", "Дебели\ лаг",
"3593626", "Перперек",
"359728", "Златица",
"3596953", "Борима",
"3593566", "Бошуля",
"3599172", "Селановци",
"3597521", "Копривлен",
"35967392", "Яворец",
"3593527", "Алеко\ Константиново",
"3593667", "Покрован",
"3594152", "Обручище",
"35984745", "Владимировци",
"3593728", "Славяново\,\ Хаск\.",
"3598626", "Средище\,\ Силистра",
"3594363", "Габарево",
"3597189", "Чавдар\,\ София",
"3594799", "Голям\ манастир",
"3595345", "Развигорово",
"3598667", "Белица\,\ Силистра",
"3597938", "Долно\ Уйно",
"35937602", "Черна\ могила\,\ Хаск\.",
"3594586", "Нейково\,\ Сливен",
"3596129", "Габровци",
"3599174", "Горни\ Вадин",
"35931707", "Черноземен",
"3597711", "Кладница",
"35974324", "Струма",
"359860", "Силистра",
"3593173", "Паничери",
"3593717", "Конуш\,\ Хаск\.",
"3599720", "Ковачица",
"3596581", "Бяла\ вода\,\ Плевен",
"35984725", "Киченица",
"3594154", "Медникарово",
"3593518", "Драгор",
"3593327", "Бачково",
"3593583", "Габровица",
"3594147", "Любеново\,\ Ст\.\ Загора",
"35984736", "Подайва",
"3596159", "Златарица",
"35931700", "Беловица",
"359910", "Мездра",
"3593542", "Ракитово",
"35974348", "Игралище",
"35984769", "Гороцвет",
"35984763", "Бели\ Лом",
"35937706", "Чернодъб",
"3598674", "Професор\ Иширково",
"3593073", "Старцево",
"3596987", "Карлуково",
"3598424", "Цар\ Калоян\,\ Разград",
"35930476", "Селча",
"3594124", "Змейово",
"3593344", "Новаково\,\ Пловдив",
"3596029", "Надарево",
"3599343", "Гомотарци",
"3594770", "Генерал\ Инзово",
"3593674", "Самодива",
"3597918", "Ябълково\,\ Кюст\.",
"3596071", "Антоново",
"3597731", "Трън",
"35974495", "Юруково",
"3593544", "Костандово",
"3597927", "Трекляно",
"3596923", "Горан",
"35931401", "Кадиево",
"3595129", "Блъсково",
"3593921", "Меричлери",
"3593557", "Бяга",
"35931997", "Златосел",
"3598672", "Брадвари",
"3596545", "Любеново\,\ Плевен",
"3593758", "Йерусалимово",
"3599167", "Липница\,\ Враца",
"3594122", "Еленино",
"3593538", "Елшица",
"359676", "Дряново\,\ Габр\.",
"3593342", "Нареченски\ бани",
"3597165", "Миланово\,\ София",
"3593672", "Чорбаджийско",
"3599330", "Раброво",
"3599126", "Камено\ поле",
"3595762", "Стефан\ Караджа\,\ Добр\.",
"35931388", "Бегунци",
"3596033", "Медовина",
"3597058", "Стоб",
"35967306", "Градище\,\ Габр\.",
"3595140", "Шкорпиловци",
"359938", "Кула",
"35961403", "Орловец",
"35971227", "Бели\ Искър",
"3595101", "Дъбравино",
"3598697", "Сокол\,\ Силистра",
"3598635", "Цар\ Самуил",
"35963567", "Градина\,\ Плевен",
"3595764", "Владимирово\,\ Добр\.",
"3594593", "Шивачево",
"35960454", "Змейно",
"3594741", "Болярово",
"3598111", "Щръклево",
"3596001", "Черковна\,\ Търг\.",
"35996", "Монтана",
"35941116", "Сладък\ Кладенец",
"3596578", "Реселец",
"35961605", "Ново\ градище",
"35930417", "Грохотно",
"3595133", "Генерал\ Колево\,\ Варна",
"3596113", "Балван",
"3597117", "Градец\,\ София",
"359579", "Албена",
"3596939", "Драгана",
"35967194", "Гръблевци",
"3595919", "Маринка",
"3599115", "Чирен",
"35967398", "Дамяново",
"35931395", "Иганово",
"35961107", "Момин\ сбор",
"3593111", "Първенец\,\ Пловдив",
"35953436", "Черноглавци",
"3596562", "Гиген",
"3593190", "Върбен\,\ Пловдив",
"3595123", "Равна\,\ Варна",
"3596929", "Радювене",
"3599549", "Долна\ Рикса",
"35974201", "Капатово",
"3597142", "Костенец",
"3598475", "Лозница\,\ Разград",
"3593079", "Козарка",
"3599561", "Сумер",
"3596564", "Загражден\,\ Плевен",
"3593625", "Широко\ поле",
"35992", "Враца",
"3598151", "Просена",
"3596023", "Подгорица",
"3599349", "Сланотрън",
"3597138", "Литаково",
"35974386", "Пирин",
"3595959", "Звездец",
"3597157", "Саранци",
"3595346", "Каменяк\,\ Шумен",
"3596153", "Златарица",
"35951539", "Левски\,\ Варна",
"3594585", "Жеравна",
"3595577", "Подвис\,\ Бургас",
"359659", "Червен\ бряг",
"3597144", "Костенец",
"3593151", "Раковски\,\ Пловдив",
"3598625", "Овен",
"3596933", "Голец",
"3597937", "Ръждавица",
"3595913", "Крушевец",
"3598668", "Попина",
"3595139", "Оборище\,\ Варна",
"3596119", "Дичин",
"3593766", "Бисер",
"35961393", "Горско\ Косово",
"35937423", "Големанци",
"3593727", "Нова\ Надежда",
"3593931", "Каснаково",
"35978", "Кюстендил",
"3593528", "Говедаре",
"3599782", "Буковец\,\ Монт\.",
"35941270", "Малка\ Верея",
"3595394", "Бяла\ река\,\ Шумен",
"3594132", "Оризово",
"35931603", "Виница",
"3594599", "Червенаково",
"3594105", "Бяло\ поле",
"3599136", "Галиче",
"3599320", "Стакевци",
"3593328", "Долнослав",
"35959409", "Череша",
"35959403", "Речица",
"3594763", "Иречеково",
"3596901", "Гложене\,\ Ловеч",
"3598448", "Тертер",
"3593517", "Лесичово",
"3595745", "Вранино",
"3599520", "Горно\ Озирово",
"359556", "Обзор",
"3599784", "Киселево",
"3595392", "Менгишево",
"35941149", "Ловец\,\ Ст\.\ Загора",
"3593718", "Войводово\,\ Хаск\.",
"3594134", "Братя\ Даскалови",
"3593783", "Свирково",
"3596039", "Опака",
"3595119", "Игнатиево",
"3596913", "Славяни",
"3597917", "Таваличево",
"3596988", "Пещерна",
"3599550", "Митровци",
"3594112", "Бъдеще",
"35947201", "Изгрев\,\ Ямбол",
"35953234", "Златна\ нива",
"3599116", "Костелево",
"35991202", "Кунино",
"3597531", "Долно\ Дряново",
"3593636", "Равен",
"3593744", "Сърница\,\ Хаск\.",
"3597751", "Брезник",
"35941489", "Боздуганово",
"3599168", "Бутан",
"3593757", "Георги\ Добрево",
"3593537", "Панагюрски\ колонии",
"3593109", "Лилково",
"3598636", "Главиница\,\ Силистра",
"3593558", "Исперихово",
"3595781", "Свобода\,\ Добр\.",
"35941277", "Загоре",
"35984721", "Липник",
"35973", "Благоевград",
"3597928", "Гърляно",
"3598698", "Шуменци",
"3596546", "Лозица\,\ Плевен",
"3597044", "Бабино",
"3593051", "Чепеларе",
"3597057", "Мало\ село",
"35941351", "Партизанин",
"3593589", "Церово\,\ Пазарджик",
"3596123", "Буковец\,\ В\.\ Търново",
"3597127", "Широки\ дол",
"3599125", "Горна\ Бешовица",
"3594341", "Черганово",
"35969031", "Галата",
"3597166", "Владо\ Тричков",
"3593121", "Рогош",
"35963575", "Бохот",
"3597183", "Душанци",
"3594793", "Бояджик",
"3594369", "Александрово\,\ Ст\.\ Загора",
"3597042", "Коркина",
"3597118", "Драговищица\,\ София",
"359559", "Карнобат",
"3596577", "Бресте",
"3595362", "Климент\,\ Шумен",
"3595153", "Суворово",
"3596959", "Дебнево",
"3599176", "Лесковец\,\ Враца",
"359339", "Стамболийски\,\ Пловдив",
"3593562", "Славовица\,\ Пазарджик",
"3594510", "Желю\ войвода",
"3593622", "Стремци",
"3595589", "Винарско",
"3598622", "Алеково\,\ Силистра",
"3593929", "Голямо\ Асеново",
"35995276", "Драганица",
"3594156", "Априлово\,\ Ст\.\ Загора",
"35981462", "Волово",
"3594582", "Градец\,\ Сливен",
"3595121", "Тутраканци",
"3593564", "Семчиново",
"3596021", "Буховци",
"3593624", "Чифлик\,\ Кърдж\.",
"3596565", "Милковица",
"35960378", "Цар\ Асен\,\ Търг\.",
"3593023", "Момчиловци",
"35935394", "Оборище\,\ Пазарджик",
"3598624", "Калипетрово",
"35961391", "Сломер",
"3597145", "Мирово\,\ София",
"35937421", "Долно\ поле",
"359359", "Велинград",
"35984765", "Веселина",
"3599147", "Борован",
"35984269", "Недоклан",
"3593153", "Стряма",
"3594584", "Тича",
"35975215", "Тешово",
"3596151", "Елена\,\ В\.\ Търново",
"35931393", "Войнягово",
"359865", "Силистра",
"3593933", "Странско",
"3595742", "Раковски\,\ Добр\.",
"3593119", "Гълъбово\,\ Пловдив",
"3596931", "Угърчин",
"35994", "Видин",
"35971506", "Габра",
"3597723", "Долни\ Раковец",
"35935392", "Дюлево\,\ Пазарджик",
"3596727", "Ганчовец",
"35961603", "Лозен\,\ В\.\ Търново",
"3594749", "Ружица\,\ Ямбол",
"3596528", "Вълчитрън",
"3594104", "Кравино",
"35953220", "Памукчии\,\ Шумен",
"3595337", "Кочово",
"3595395", "Чернооково\,\ Шумен",
"35935257", "Сарая",
"35981464", "Острица\,\ Русе",
"3596328", "Ореш",
"3595757", "Безмер\,\ Добр\.",
"35961405", "Петко\ Каравелово",
"3596060", "Овчарово\,\ Търг\.",
"35974203", "Рупите",
"3596517", "Подем",
"3594761", "Стралджа",
"3595537", "Съдиево\,\ Бургас",
"35931791", "Бегово",
"3595558", "Дебелт",
"3593781", "Симеоновград",
"3596718", "Драгановци",
"3597178", "Пролеша",
"3595738", "Спасово\,\ Добр\.",
"3593039", "Полковник\ Серафимово",
"3594102", "Ястребово\,\ Ст\.\ Загора",
"3599785", "Василовци\,\ Монт\.",
"359336", "Първомай\,\ Пловдив",
"3595766", "Методиево\,\ Добр\.",
"3595727", "Сенокос\,\ Добр\.",
"3596911", "Лисец\,\ Ловеч",
"3595528", "Невестино\,\ Бургас",
"3593708", "Орлово\,\ Хаск\.",
"3595317", "Ивански",
"35960372", "Крепча",
"3599741", "Долни\ Цибър",
"35946", "Ямбол",
"3595328", "Никола\ Козлево",
"359915", "Бяла\ Слатина",
"3597533", "Осиково\,\ Благ\.",
"3593745", "Малък\ извор\,\ Хаск\.",
"3596537", "Асеновци",
"3595517", "Равнец\,\ Бургас",
"3597753", "Ноевци",
"3596738", "Добромирка",
"3595718", "Смолница",
"3596558", "Славовица\,\ Плевен",
"35941359", "Изворово\,\ Ст\.\ Загора",
"35941353", "Плодовитово",
"3595783", "Котленци",
"359417", "Раднево",
"3594115", "Кирилово\,\ Ст\.\ Загора",
"3593019", "Писаница",
"3598123", "Босилковци",
"35930200", "Загражден\,\ Смол\.",
"3596589", "Кулина\ вода",
"3597045", "Голем\ Върбовник",
"3593647", "Черничево\,\ Кърдж\.",
"35984729", "Езерче",
"35984723", "Дянково",
"3593053", "Хвойна",
"3594343", "Конаре\,\ Ст\.\ Загора",
"3593123", "Калояново\,\ Пловдив",
"35971338", "Осиковска\ Лакавица",
"3596121", "Никюп",
"3599124", "Типченица",
"3595365", "Лятно",
"3596179", "Крушето",
"3598647", "Паисиево",
"3597719", "Ярджиловци",
"35960374", "Горско\ Абланово",
"35947203", "Трънково\,\ Ямбол",
"3593652", "Бял\ извор\,\ Кърдж\.",
"3598676", "Ветрен\,\ Силистра",
"35984749", "Севар",
"35984743", "Брестовене",
"3597181", "Пирдоп",
"3593778", "Студена\,\ Хаск\.",
"3593346", "Мулдава",
"3594330", "Николаево\,\ Ст\.\ Загора",
"3598187", "Тетово",
"35981266", "Стърмен\,\ Русе",
"3594126", "Хрищени",
"3599122", "Зверино",
"3597529", "Брезница",
"3593676", "Бенковски\,\ Кърдж\.",
"35961606", "Владислав",
"3593035", "Върбина",
"3594139", "Свобода\,\ Ст\.\ Загора",
"35941115", "Борилово",
"3594592", "Бяла\ паланка",
"3593631", "Момчилград",
"35984778", "Богданци\,\ Разград",
"35991184", "Ракево",
"3596034", "Славяново\,\ Търг\.",
"3595599", "Хаджиите",
"3595105", "Приселци\,\ Варна",
"3595132", "Михалич\,\ Варна",
"35931396", "Домлян",
"3596112", "Самоводене",
"3596570", "Девенци",
"35971503", "Долно\ Камарци",
"3598631", "Силистра",
"3596048", "Изворово\,\ Търг\.",
"3595148", "Рудник\,\ Варна",
"3595763", "Плачидол",
"35930457", "Късак",
"3596032", "Зараево",
"359817", "Бяла\,\ Русе",
"3594745", "Шарково",
"3598115", "Червена\ вода",
"3595134", "Червенци",
"3599111", "Челопек",
"35960387", "Глогинка",
"3596114", "Килифарево",
"3593115", "Куклен",
"35931308", "Богдан\,\ Пловдив",
"3597120", "Долна\ баня",
"35967305", "Стоките",
"3596922", "Лешница\,\ Ловеч",
"3593530", "Поибрене",
"3599338", "Шишенци",
"3599542", "Смоляновци",
"3595947", "Просеник",
"35974496", "Филипово\,\ Благ\.",
"3598673", "Алфатар",
"3597149", "Живково\,\ София",
"3593074", "Ерма\ река",
"3594123", "Богомилово",
"3593343", "Козаново",
"3596569", "Ленково",
"3599344", "Връв",
"3593673", "Тихомир",
"359601", "Търговище",
"359724", "Ихтиман",
"3595952", "Малко\ Търново",
"35937705", "Пъстрогор",
"3597735", "Лева\ река",
"3593543", "Дорково",
"35974408", "Обидим",
"35984266", "Просторно",
"3599557", "Горно\ Церовене",
"35991401", "Враняк",
"3596541", "Никопол",
"3598167", "Церовец",
"3599544", "Студено\ буче",
"3593056", "Чепинци\,\ Смол\.",
"3594778", "Победа\,\ Ямбол",
"3593925", "Крум",
"3597910", "Берсин",
"35991182", "Осен\,\ Враца",
"3593126", "Труд",
"3593072", "Неделино",
"3594346", "Голямо\ Дряново",
"3599342", "Иново",
"35930475", "Стоманево",
"3593167", "Брягово\,\ Пловдив",
"3597525", "Баничан",
"3593510", "Овчеполци",
"3596954", "Врабево",
"3599527", "Вършец",
"3598156", "Червен\,\ Русе",
"3594562", "Крива\ круша",
"3593026", "Смилян",
"35984462", "Острово",
"3599318", "Буковец\,\ Видин",
"35984735", "Свещари",
"3593156", "Шишманци",
"3594364", "Осетеново",
"35936401", "Странджево",
"3599728", "Сливата",
"35984726", "Ушинци",
"3593582", "Момина\ клисура",
"3595341", "Хитрино",
"3597715", "Студена\,\ Перник",
"3596175", "Първомайци",
"359777", "Радомир",
"3593720", "Маджарово",
"3597445", "Баня\,\ Благ\.",
"3599173", "Галово",
"3594564", "Новоселец",
"35969249", "Дойренци",
"35969243", "Казачево",
"3596952", "Орешак\,\ Ловеч",
"35961704", "Правда\,\ В\.\ Търново",
"35974404", "Бабяк",
"3597930", "Еремия",
"3593174", "Старо\ Железаре",
"3594153", "Мъдрец\,\ Ст\.\ Загора",
"35936700", "Шопци",
"3594362", "Манолово",
"3599327", "Чупрене",
"3596585", "Белене",
"3593584", "Ветрен\,\ Пазарджик",
"3599518", "Мърчево",
"35984774", "Голям\ извор\,\ Разград",
"35991188", "Галатин",
"35984393", "Вазово",
"3596906", "Черни\ Вит",
"3595112", "Белослав",
"3596132", "Караисен",
"35960380", "Дриново",
"35974402", "Годлево",
"3593749", "Гарваново",
"3593104", "Ягодово\,\ Пловдив",
"3595570", "Манолич",
"3593936", "Горски\ извор\,\ Хаск\.",
"3596148", "Павел",
"3598135", "Бабово",
"3597726", "Дрен",
"35941356", "Рупките",
"35963205", "Червена",
"35991668", "Манастирище",
"35984464", "Веселец\,\ Разград",
"3599131", "Добролево",
"3595114", "Езерово\,\ Варна",
"3596134", "Бяла\ черква\,\ В\.\ Търново",
"35957305", "Росица\,\ Добр\.",
"3593135", "Кърнаре",
"3593197", "Тюркмен",
"35955505", "Драчево",
"35931108", "Богданица",
"3593102", "Караджово",
"3593633", "Рогозче",
"3596035", "Паламарца",
"3594742", "Стефан\ Караджово",
"3596002", "Съединение\,\ Търг\.",
"3594358", "Скобелево\,\ Ст\.\ Загора",
"35931606", "Воден\,\ Пловдив",
"3593034", "Левочево",
"3599746", "Разград\,\ Монт\.",
"3595749", "Крапец\,\ Добр\.",
"3596968", "Добродан",
"3598633", "Старо\ село\,\ Силистра",
"35963564", "Биволаре",
"3593112", "Марково\,\ Пловдив",
"35967390", "Шумата",
"3594337", "Ясеново\,\ Ст\.\ Загора",
"35931992", "Пъдарско",
"35971224", "Шипочане",
"3598114", "Пиргово",
"3594744", "Голямо\ Крушево",
"3596004", "Маково",
"35941172", "Горно\ Ботево",
"3596916", "Брестово\,\ Ловеч",
"35941146", "Християново",
"35966", "Габрово",
"35930414", "Девин",
"3593032", "Средногорци",
"3594109", "Тракия",
"3595761", "Батово",
"35969614", "Горно\ трапе",
"3594595", "Сборище",
"3594757", "Недялско",
"3594738", "Хлябово",
"35961104", "Водолей",
"3593114", "Брестник",
"3598640", "Правда\,\ Силистра",
"3599188", "Горно\ Пещене",
"35959406", "Разбойна\,\ Бургас",
"3599113", "Мраморен",
"3595102", "Падина\,\ Варна",
"3596115", "Ресен",
"35951108", "Изворско",
"3595135", "Стефан\ Караджа\,\ Варна",
"35961308", "Вишовград",
"3597186", "Антон",
"3594796", "Генерал\ Тошево\,\ Ямбол",
"3598629", "Смилец\,\ Силистра",
"3597427", "Първомай\,\ Благ\.",
"3596530", "Трънчовица",
"3593922", "Брод",
"3598671", "Силистра",
"3597732", "Вукан",
"35961102", "Пчелище",
"359610", "Павликени\,\ В\.\ Търново",
"3593671", "Подкова",
"3593569", "Карабунар",
"3596074", "Любичево",
"35969612", "Терзийско\,\ Ловеч",
"3599345", "Винарово\,\ Видин",
"3593629", "Мост",
"3594121", "Люляк",
"35930412", "Девин",
"3593341", "Конуш\,\ Пловдив",
"35941174", "Подслон\,\ Ст\.\ Загора",
"3593075", "Долен\,\ Смол\.",
"359301", "Смолян",
"3597547", "Вълкосел",
"3596543", "Муселиево",
"35931708", "Песнопой\,\ Пловдив",
"3593924", "Крепост",
"3599545", "Габровница",
"35951536", "Николаевка",
"35963562", "Комарево\,\ Плевен",
"3596925", "Владиня",
"3597734", "Главановци\,\ Перник",
"3595310", "Радко\ Димитриево",
"3596126", "Церова\ кория",
"3596072", "Добротица\,\ Търг\.",
"3597163", "Искрец",
"3596167", "Кесарево",
"3596067", "Кралево\,\ Търг\.",
"3595750", "Каблешково\,\ Добр\.",
"35974347", "Раздол",
"3595530", "Пещерско",
"3596510", "Тотлебен",
"3596955", "Дълбок\ дол",
"35961302", "Батак\,\ В\.\ Търново",
"3597442", "Якоруда",
"3596026", "Макариополско",
"3597524", "Абланица\,\ Благ\.",
"3597712", "Батановци",
"35941178", "Оряховица\,\ Ст\.\ Загора",
"3596998", "Голям\ извор\,\ Ловеч",
"3596156", "Родина",
"3595343", "Венец\,\ Шумен",
"3596582", "Белене",
"35974327", "Ново\ Делчево",
"3593175", "Дълго\ поле\,\ Пловдив",
"3596720", "Керека",
"3599129", "Синьо\ бърдо",
"3599171", "Оряхово\,\ Враца",
"35935419", "Света\ Петка",
"3597444", "Белица\,\ Благ\.",
"35931704", "Иван\ Вазово",
"3596174", "Драганово\,\ В\.\ Търново",
"3597714", "Мещица",
"3597522", "Дъбница",
"35931998", "Чоба",
"3595126", "Черковна\,\ Варна",
"3593585", "Аканджиево",
"3595330", "Златар",
"3596584", "Белене",
"3597438", "Катунци",
"3595167", "Венчан",
"3598132", "Юделник",
"35941335", "Могилово",
"35960450", "Долна\ Хубавка",
"35931387", "Пролом",
"3594727", "Малък\ манастир",
"35969241", "Йоглав",
"35971228", "Марица",
"3593132", "Баня\,\ Пловдив",
"35931702", "Долна\ махала\,\ Пловдив",
"3593105", "Манолско\ Конаре",
"3595968", "Каблешково\,\ Бургас",
"3594528", "Любенова\ махала",
"3593786", "Навъсен",
"35963568", "Буковлък",
"3599140", "Габаре",
"359538", "Велики\ Преслав",
"3593763", "Българин",
"3593148", "Йоаким\ Груево",
"35956", "Бургас",
"3595916", "Росен\,\ Бургас",
"3598134", "Малко\ Враново",
"35930418", "Буйново\,\ Смол\.",
"3594517", "Ичера",
"359558", "Айтос",
"35961304", "Димча",
"3593134", "Сопот\,\ Пловдив",
"35951104", "Долище\,\ Варна",
"3598148", "Горно\ Абланово",
"3594718", "Роза",
"3597193", "Голеш\,\ София",
"3596135", "Върбовка",
"359517", "Дългопол",
"35961108", "Плаково",
"3595115", "Генерал\ Кантарджиево",
"35967397", "Ряховците",
"3599133", "Комарево\,\ Враца",
"3593747", "Татарево\,\ Хаск\.",
"3596535", "Козар\ Белене",
"3595515", "Камено",
"3597912", "Горна\ Гращица",
"3593534", "Попинци",
"3593754", "Лозен\,\ Хаск\.",
"3597741", "Земен",
"35936402", "Горна\ кула",
"359518", "Провадия",
"3599340", "Септемврийци\,\ Видин",
"3594773", "Окоп",
"3593548", "Пашово",
"359702", "Бобов\ дол",
"3597914", "Ваксево",
"3593678", "Чакаларово",
"35931709", "Михилци",
"3599540", "Белотинци",
"35931703", "Житница\,\ Пловдив",
"359608", "Попово\,\ Търг\.",
"3593348", "Добралък",
"3593532", "Стрелча",
"3596920", "Лесидрен",
"3593752", "Малко\ градище",
"35984760", "Трапище",
"359537", "Нови\ пазар\,\ Шумен",
"3595315", "Царев\ брод",
"3598678", "Срацимир\,\ Силистра",
"3599333", "Бойница",
"3593776", "Райкова\ могила",
"35974388", "Горно\ Спанчево",
"3594551", "Бяла\,\ Сливен",
"3596030", "Светлен\,\ Търг\.",
"3593706", "Тънково\,\ Хаск\.",
"3599181", "Краводер",
"3595526", "Кликач",
"3597052", "Пастра",
"3599529", "Боровци",
"35974401", "Горно\ Драглище",
"3596574", "Чомаковци",
"3598185", "Сеново",
"3595143", "Бяла\,\ Варна",
"3595768", "Одринци\,\ Добр\.",
"3593645", "Аврен\,\ Кърдж\.",
"3597047", "Усойка",
"3596043", "Долно\ Новково",
"3599329", "Рабиша",
"3596736", "Градница\,\ Габр\.",
"3595716", "Паскалево",
"3597054", "Рила",
"359331", "Асеновград",
"3596556", "Горна\ Митрополия",
"3594351", "Копринка",
"3599719", "Аспарухово\,\ Монт\.",
"3597124", "Белчински\ бани",
"3595367", "Тодор\ Икономово",
"3596572", "Сухаче",
"359550", "Созопол",
"3598645", "Межден",
"35951103", "Любен\ Каравелово",
"35961309", "Горско\ Калугерово",
"35961303", "Горна\ Липница",
"3595326", "Върбяне",
"3595130", "Генерал\ Киселово",
"3596567", "Сомовит",
"3598141", "Две\ могили",
"3594711", "Безмер\,\ Ямбол",
"3596526", "Върбица\,\ Плевен",
"3595574", "Съединение\,\ Бургас",
"3594321", "Мъглиж",
"3593100", "Белащица",
"3597154", "Столник",
"3595949", "Планиница\,\ Бургас",
"3597147", "Пчелин\,\ София",
"3596143", "Масларево",
"35931324", "Мраченик",
"3599145", "Бреница\,\ Враца",
"35963563", "Борислав",
"35963569", "Каменец\,\ Плевен",
"35935255", "Росен\,\ Пазарджик",
"35969613", "Чифлик\,\ Ловеч",
"3595556", "Голямо\ Буково",
"35971587", "Голема\ Раковица",
"35930413", "Девин",
"3597176", "Храбърско",
"3596716", "Жълтеш",
"35930419", "Ягодина",
"3595736", "Василево",
"35991888", "Веслец\,\ Враца",
"359650", "Левски\,\ Плевен",
"3595572", "Бероново",
"3599559", "Горна\ Ковачица",
"3597152", "Горна\ Малина",
"3596326", "Морава",
"35961109", "Въглевци",
"35961103", "Русаля",
"3595755", "Коларци",
"3599513", "Бойчиновци",
"3596515", "Славяново\,\ Плевен",
"3597932", "Шипочано",
"3595535", "Лясково\,\ Бургас",
"3596950", "Гумощник",
"3594158", "Искрица",
"3593514", "Черногорово\,\ Пазарджик",
"3593722", "Минерални\ бани\,\ Хаск\.",
"359618", "Горна\ Оряховица",
"3594137", "Верен",
"35941179", "Хан\ Аспарухово",
"3599787", "Смирненски\,\ Монт\.",
"35941173", "Братя\ Кунчеви",
"3597106", "Ямна",
"35953434", "Ясенково",
"35930205", "Стърница",
"3596991", "Ябланица",
"3599723", "Трайково",
"3596725", "Гостилица",
"3597934", "Буново\,\ Кюст\.",
"35931993", "Сърнегор",
"35935418", "Кръстава",
"3593512", "Хаджиево",
"3593724", "Сусам",
"3599313", "Капитановци",
"3595397", "Методиево\,\ Шумен",
"3595335", "Миланово\,\ Шумен",
"3593755", "Белица\,\ Хаск\.",
"3597168", "Бов",
"3593535", "Левски\,\ Пазарджик",
"3597743", "Дивля",
"3597036", "Баланово",
"3593696", "Пчеларово\,\ Кърдж\.",
"35961301", "Бяла\ река\,\ В\.\ Търново",
"3596534", "Малчика",
"3598696", "Суходол\,\ Силистра",
"3594729", "Кирилово\,\ Ямбол",
"35963577", "Пелишат",
"3596548", "Дебово",
"3595312", "Дибич",
"3594771", "Маломир\,\ Ямбол",
"35974403", "Долно\ Драглище",
"35974409", "Места",
"35961703", "Върбица\,\ В\.\ Търново",
"35981264", "Пиперково",
"359308", "Мадан\,\ Смол\.",
"3597915", "Невестино\,\ Кюст\.",
"3595724", "Дропла\,\ Добр\.",
"35969244", "Тепава",
"35971471", "Очуша",
"3593920", "Златополе",
"3596532", "Българене\,\ Плевен",
"35984392", "Белинци",
"3595580", "Трояново\,\ Бургас",
"3597116", "Петърч",
"3594519", "Самуилово\,\ Сливен",
"35960376", "Люблен",
"3595314", "Белокопитово",
"3593030", "Широка\ лъка",
"3594553", "Раково\,\ Сливен",
"35941275", "Лясково\,\ Ст\.\ Загора",
"35984779", "Здравец\,\ Разград",
"3599183", "Лиляче",
"3594733", "Орлов\ дол",
"35984394", "Духовец",
"3593642", "Поточница",
"3595100", "Синдел",
"35969242", "Пресяка",
"3596986", "Дъбен",
"35981262", "Бистренци",
"35931701", "Кръстевич",
"3598184", "Глоджево",
"3595141", "Старо\ Оряхово",
"3596069", "Васил\ Левски\,\ Търг\.",
"3596575", "Телиш",
"3598642", "Дулово",
"3593657", "Жълтуша",
"3597926", "Коняво",
"3593043", "Змеица",
"3596963", "Балканец",
"3593556", "Радилово",
"3598638", "Богданци\,\ Силистра",
"359631", "Свищов",
"3595169", "Момчилово",
"3593644", "Егрек",
"3599166", "Хайредин",
"3598644", "Чернолик",
"3594353", "Средногорово",
"3597125", "Говедарци",
"3593110", "Поповица",
"3599127", "Лютидол",
"3593638", "Звездел",
"35931309", "Климент\,\ Пловдив",
"35984463", "Прелез",
"35984469", "Божурово\,\ Разград",
"3599138", "Алтимир",
"35991183", "Фурен",
"35991189", "Три\ кладенци",
"3593567", "Ковачево\,\ Пазарджик",
"3593526", "Динката",
"3598477", "Самуил",
"3598143", "Обретеник",
"3594713", "Стара\ река\,\ Ямбол",
"3593666", "Попско",
"35971504", "Белопопци",
"3596141", "Полски\ Тръмбеш",
"3599144", "Нивянин",
"3598627", "Бабук",
"3594323", "Тулово",
"3598666", "Тутракан",
"359675", "Севлиево",
"3597155", "Лесново",
"3593768", "Доситеево",
"3593143", "Перущица",
"3594587", "Ябланово",
"3595575", "Прилеп\,\ Бургас",
"35941171", "Дълбоки",
"3594523", "Стоил\ войвода",
"3596169", "Благоево\,\ В\.\ Търново",
"3599142", "Лазарово",
"3597549", "Долен\,\ Благ\.",
"359350", "Пещера\,\ Пазарджик",
"3593326", "Патриарх\ Евтимово",
"35981466", "Помен",
"3593130", "Каравелово\,\ Пловдив",
"3594146", "Диня",
"3593515", "Калугерово\,\ Пазарджик",
"3597433", "Кресна",
"3597520", "Корница",
"359357", "Панагюрище",
"3595747", "Ваклино",
"3595534", "Карагеоргиево",
"35961101", "Велчево\,\ В\.\ Търново",
"3596722", "Соколово\,\ Габр\.",
"3596514", "Долни\ Дъбник",
"359416", "Чирпан",
"3594339", "Юлиево",
"3595754", "Зърнево",
"35965165", "Писарово\,\ Плевен",
"359318", "Съединение\,\ Пловдив",
"3595332", "Драгоево",
"35930411", "Девин",
"35981268", "Кривина\,\ Русе",
"3593725", "Стамболийски\,\ Хаск\.",
"35971221", "Ярлово",
"35969248", "Скобелево\,\ Ловеч",
"3595532", "Тополица",
"3599721", "Долно\ Церовене",
"3597935", "Долно\ село",
"35963561", "Гривица",
"3596724", "Янтра\,\ Габр\.",
"3596512", "Горни\ Дъбник",
"3595348", "Трем",
"3595752", "Нова\ Камена",
"35971502", "Елешница\,\ София",
"359337", "Хисаря",
"3597136", "Новачене\,\ София",
"3595776", "Черна\,\ Добр\.",
"3596580", "Татари",
"35963570", "Староселци",
"3595334", "Осмар",
"3599311", "Кутово",
"3594107", "Средец\,\ Ст\.\ Загора",
"3596711", "Кози\ рог",
"3599522", "Котеновци",
"3595731", "Генерал\ Тошево\,\ Добр\.",
"35967395", "Горна\ Росица",
"3594567", "Баня\,\ Сливен",
"3595551", "Средец\,\ Бургас",
"35931398", "Слатина\,\ Пловдив",
"3597129", "Радуил",
"3594526", "Млекарево",
"3593713", "Динево",
"3593177", "Ново\ Железаре",
"3596942", "Александрово\,\ Ловеч",
"3596321", "Горна\ Студена",
"3599324", "Ружинци",
"35947202", "Жребино",
"359722", "Самоков",
"35961608", "Горски\ Сеновец",
"3595165", "Невша",
"3594768", "Зимница\,\ Ямбол",
"35984776", "Хърсово\,\ Разград",
"3593587", "Сестримо",
"3594143", "Сърнево\,\ Ст\.\ Загора",
"3593323", "Болярци\,\ Пловдив",
"3596521", "Садовец",
"35991201", "Люти\ брод",
"3599524", "Ягодово\,\ Монт\.",
"3596957", "Голяма\ Желязна",
"3596579", "Рупци\,\ Плевен",
"3596065", "Бистра\,\ Търг\.",
"3593523", "Синитево",
"3595590", "Житосвят",
"35984466", "Звънарци",
"3596944", "Крушуна",
"3594716", "Веселиново\,\ Ямбол",
"359309", "Пампорово",
"35941354", "Малко\ Тръново",
"3594367", "Тъжа",
"3599322", "Орешец\,\ Видин",
"35941337", "Сърневец",
"3595351", "Смядово",
"3594130", "Спасово\,\ Ст\.\ Загора",
"3593146", "Куртово\ Конаре",
"35984722", "Ясеновец",
"3596938", "Каленик\,\ Ловеч",
"3594326", "Енина",
"3598663", "Ситово\,\ Силистра",
"3595918", "Русокастро",
"359457", "Нова\ Загора",
"3594515", "Мокрен",
"35941352", "Винарово\,\ Ст\.\ Загора",
"3598194", "Сандрово",
"3596158", "Средни\ колиби",
"359848", "Кубрат",
"3597133", "Правец",
"3596137", "Бутово",
"3595773", "Лозенец\,\ Добр\.",
"359418", "Гълъбово\,\ Ст\.\ Загора",
"3595117", "Ботево\,\ Варна",
"3596028", "Вардун",
"359973", "Козлодуй",
"3593194", "Зелениково\,\ Пловдив",
"35969032", "Български\ извор",
"35974325", "Лиляново",
"35930257", "Вишнево",
"3597436", "Левуново",
"35984744", "Беловец",
"35984717", "Побит\ камък\,\ Разград",
"3594725", "Лесово",
"35960373", "Посабина",
"3595128", "Житница\,\ Варна",
"3596560", "Крета\,\ Плевен",
"3598192", "Хотанца",
"35947204", "Пчела",
"35961706", "Писарево\,\ В\.\ Търново",
"35974406", "Добърско",
"3593192", "Бабек",
"3593107", "Граф\ Игнатиево",
"3593759", "Бориславци",
"3594597", "Боров\ дол",
"35984710", "Осенец",
"3594755", "Тамарино",
"35984728", "Раковски\,\ Разград",
"359971", "Лом",
"3597939", "Църварица",
"3596117", "Дебелец\,\ В\.\ Търново",
"3595137", "Калоян",
"3597188", "Петрич\,\ София",
"3594798", "Савино",
"35974202", "Ключ",
"3593729", "Криво\ поле",
"35961602", "Царски\ извор",
"3593693", "Лясково\,\ Кърдж\.",
"3597033", "Крайници",
"3596128", "Хотница",
"359306", "Рудозем",
"3594335", "Ръжена",
"35931392", "Дъбене",
"35935393", "Смилец\,\ Пазарджик",
"3598693", "Звенимир",
"3593519", "Величково\,\ Пазарджик",
"3599554", "Чипровци",
"3596551", "Тръстеник\,\ Плевен",
"3596927", "Умаревци",
"3597923", "Вратца",
"3593046", "Барутин",
"3595711", "Овчарово\,\ Добр\.",
"3597545", "Кочан",
"3595942", "Люляково\,\ Бургас",
"35931394", "Васил\ Левски\,\ Пловдив",
"3596966", "Шипково",
"3593553", "Батак\,\ Пазарджик",
"3598164", "Писанец",
"3599547", "Винище",
"3596165", "Асеново\,\ В\.\ Търново",
"35941330", "Ценово\,\ Ст\.\ Загора",
"3599352", "Дружба",
"3599748", "Дългоделци",
"3599163", "Хърлец",
"35991186", "Баурене",
"3595321", "Правенци",
"35961604", "Мирово\,\ В\.\ Търново",
"3593164", "Дълбок\ извор",
"3594356", "Хаджидимитрово\,\ Ст\.\ Загора",
"35974204", "Гега",
"3599552", "Белимел",
"3595579", "Ведрово",
"3597159", "Априлово\,\ София",
"3595521", "Венец\,\ Бургас",
"3594736", "Светлина",
"3595944", "Руен\,\ Бургас",
"3596590", "Ракита\,\ Плевен",
"3597425", "Кулата",
"3593740", "Пчелари",
"3594556", "Сотиря",
"3593701", "Елена\,\ Хаск\.",
"3599186", "Згориград",
"35981463", "Могилино",
"3599354", "Антимово\,\ Видин",
"3596983", "Дерманци",
"359725", "Елин\ Пелин",
"3593077", "Средец\,\ Смол\.",
"3593162", "Градина\,\ Пловдив",
"3596918", "Дренов",
"3599347", "Бела\ Рада",
"35941358", "Опълченец",
"3596062", "Стража\,\ Търг\.",
"3593711", "Долно\ Ботево",
"35957307", "Житен\,\ Добр\.",
"3598649", "Яребица",
"3596713", "Враниловци",
"3597717", "Дивотино",
"359519", "Девня",
"3596177", "Янтра\,\ В\.\ Търново",
"3597447", "Добринище",
"3595733", "Кардам\,\ Добр\.",
"3595553", "Орлинци",
"3596908", "Глогово",
"3593321", "Тополово\,\ Пловдив",
"3594100", "Столетово\,\ Ст\.\ Загора",
"3596323", "Българско\ сливово",
"3595164", "Неофит\ Рилски",
"35941110", "Старозагорски\ бани",
"3599325", "Бело\ поле\,\ Видин",
"359453", "Котел",
"3596587", "Петокладенци",
"3593661", "Ивайловград",
"35959408", "Ръжица",
"3593521", "Звъничево",
"3596064", "Голямо\ Ново",
"3595740", "Горичане",
"3597527", "Горно\ Дряново",
"3596523", "Крушовица\,\ Плевен",
"35961306", "Патреш",
"35951106", "Осеново\,\ Варна",
"35941484", "Землен",
"3599525", "Долно\ Озирово",
"3597728", "Друган",
"3598661", "Тутракан",
"3595162", "Белоградец",
"3595353", "Веселиново\,\ Шумен",
"3596146", "Полски\ Сеновец",
"3598137", "Голямо\ Враново",
"3599726", "Замфир",
"3594514", "Крушаре",
"3594722", "Гранитово\,\ Ямбол",
"3595319", "Друмево",
"3599568", "Благово\,\ Монт\.",
"3593028", "Арда",
"3593137", "Клисура\,\ Пловдив",
"3593195", "Розовец",
"35991203", "Лик",
"3599316", "Ново\ село\,\ Видин",
"3595771", "Крушари",
"3598158", "Мечка\,\ Русе",
"3599516", "Лехчево",
"3594724", "Раздел\,\ Ямбол",
"3594512", "Блатец\,\ Сливен",
"35965617", "Искър\,\ Плевен",
"35984737", "Райнино",
"35951538", "Изгрев\,\ Варна",
"35931706", "Сухозем",
"3594580", "Боринци",
"3598620", "Силистра",
"3595519", "Зидарово",
"3597103", "Брусен\,\ София",
"3596539", "Градище\,\ Плевен",
"3596007", "Ралица",
"3594747", "Денница\,\ Ямбол",
"3598117", "Мартен",
"3594754", "Каменец\,\ Ямбол",
"35984730", "Голям\ Поровец",
"3599336", "Старопатица",
"3593117", "Катуница",
"3593773", "Капитан\ Андреево",
"359745", "Петрич\,\ Благ\.",
"35981461", "Каран\ Върбовка",
"35937707", "Щит",
"3594332", "Ветрен\,\ Ст\.\ Загора",
"3597031", "Горна\ Козница",
"35931602", "Татарево\,\ Пловдив",
"3593691", "Черноочeне",
"3593128", "Златитрап",
"3594752", "Първенец\,\ Ямбол",
"3593037", "Сивино",
"3594348", "Дунавци\,\ Ст\.\ Загора",
"35937422", "Долни\ Главанак",
"3593058", "Мугла",
"3598691", "Силистра",
"3595539", "Черноград",
"3596519", "Беглеж",
"35931996", "Свежен",
"3594334", "Елхово\,\ Ст\.\ Загора\,\ общ\.\ Николаево",
"3595759", "Кочмар",
"3598128", "Полско\ Косово",
"35967307", "Млечево",
"3598165", "Смирненски\,\ Русе",
"3597422", "Тополница\,\ Благ\.",
"3596046", "Врани\ кон",
"3593927", "Черногорово\,\ Хаск\.",
"3597544", "Осина",
"3596553", "Оряховица\,\ Плевен",
"3597921", "Жиленци",
"3596733", "Кормянско",
"35937424", "Козлец",
"359619", "Лясковец\,\ В\.\ Търново",
"3595713", "Стефаново\,\ Добр\.",
"35963566", "Бръшляница",
"35961394", "Дъскот",
"35935391", "Блатница",
"35960385", "Ломци",
"3599555", "Копиловци\,\ Монт\.",
"3593165", "Караджалово",
"3599161", "Мизия",
"35931604", "Драгойново",
"3595323", "Плиска",
"3596164", "Бряговица",
"3599149", "Буковец\,\ Враца",
"3597424", "Кърналово",
"3595945", "Добромир",
"3593703", "Жълти\ бряг",
"359431", "Казанлък",
"35961106", "Ново\ село\,\ В\.\ Търново",
"35931792", "Черничево\,\ Пловдив",
"35959404", "Ясеново\,\ Бургас",
"3595523", "Крумово\ градище",
"3596077", "Стеврек",
"35969616", "Старо\ село\,\ Ловеч",
"3595146", "Горен\ чифлик",
"35941117", "Казанка",
"35941144", "Калояновец",
"3596981", "Петревене",
"35930416", "Гьоврен",
"3599355", "Косово\,\ Видин",};
my $timezones = {
               '' => [
                       'Europe/Sofia'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+359|\D)//g;
      my $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;