package PerlIO::via::YAML;
use 5.006; our $VERSION = 0.01; use strict; use warnings; use YAML::XS;
BEGIN {
	no strict 'refs'; # I'm as evil as stringification
	*{"IO::File::prints"} = sub { PRINT(@_); };
	*{"IO::File::load"} = sub { LOAD(@_); };
}
sub PUSHED { bless [], $_[0]; }
sub FILL { my ($self, $fh) = @_; <$fh> || undef; }
sub WRITE { my ($self, $buf, $fh) = @_; return print $fh $buf ? $buf : -1; }
sub LOAD { my ($fh) = @_; my $t = do { local $/; <$fh> }; return (defined $t) ? Load $t : undef; }
sub PRINT { ${$_[0]}->print(Dump($_[1])); }
'*\o/*';
__END__;

=head1 NAME

PerlIO::via::YAML - PerlIO layer for YAML

=head1 VERSION

Version 0.01

=cut

=head1 SYNOPSIS

	use PerlIO::via::YAML;

	my $file = 'test.yml';
	my $struct = {
		stay => "I'll see them shine",
		wonder => [
			'I'll be satisfied',
			'not to read in between',
			'the lines'
		]
	};

	open my $fh, '>:via(YAML)', $file or die $!;

	prints $fh $struct; 

	close $fh;

	open my $ih, '<:via(YAML)', $file or die $!;

	my $in = load $ih; 

	close $ih;

=head1 DESCRIPTION

This module implements a PerlIO layer that works on files encoded in the
YAML format.  It will decode from YAML format while reading from a handle, 
and it will encode to YAML while writing to a handle.

=head1 AUTHOR

LNATION, C<< <email at lnation.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-perlio-via-yaml at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=PerlIO-via-YAML>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

	perldoc PerlIO::via::YAML

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=PerlIO-via-YAML>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/PerlIO-via-YAML>

=item * CPAN Ratings

L<https://cpanratings.perl.org/d/PerlIO-via-YAML>

=item * Search CPAN

L<https://metacpan.org/release/PerlIO-via-YAML>

=back

=head1 ACKNOWLEDGEMENTS

=head1 LICENSE AND COPYRIGHT

This software is Copyright (c) 2020 by LNATION.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut

1; # End of PerlIO::via::YAML
