#!/usr/bin/env raku

use Protobuf;

my $p = parse-proto($*ARGFILES.slurp);

for $p.services -> $svc {
  say "service name " ~ $svc.name;
  for $svc.endpoints -> $e {
    say " endpoint  " ~ $e.name;
    say '  request params ' ~ $e.request.name;
    for $e.request.fields -> $f {
      say '   name : ' ~ $f.name;
      say '   type : ' ~ $f.type;
      say ' repeated' if $f.repeated;
    }
    say '  response params ' ~ $e.response.name;
    for $e.response.fields -> $f {
      say '   name : ' ~ $f.name;
      say '   type : ' ~ $f.type;
      say ' repeated' if $f.repeated;
    }
  }
}


