use v6;

use Test;

use LibCurl::Test;
use LibCurl::Easy;

plan 6;

my $outjar will leave { unlink $_ } = 'jar73.txt';

my $server = LibCurl::Test.new;

$server.start;

my $curl = LibCurl::Easy.new(URL => "http://$HOSTIP:$HTTPPORT/73",
                             Host => 'host.NOT_DISCLOSED.se',
                             cookiejar => $outjar).perform;

is $curl.response-code, 200, 'response-code';

is $curl.statusline, 'HTTP/1.1 200 OK swsclose', 'statusline';

is $curl.content, "boo\n", 'content';

is $curl.cookielist,
[
    ".NOT_DISCLOSED.se	TRUE	/	FALSE	0	IPCZQX01af0fca5c	000010008168c200d25dfc4b"
], 'cookielist';

$curl.cleanup;

is $outjar.IO.slurp,
"# Netscape HTTP Cookie File
# http://curl.haxx.se/docs/http-cookies.html
# This file was generated by libcurl! Edit at your own risk.

.NOT_DISCLOSED.se	TRUE	/	FALSE	0	IPCZQX01af0fca5c	000010008168c200d25dfc4b
", 'cookiejar';

is $server.input,
"GET /73 HTTP/1.1
Accept: */*
Host: host.NOT_DISCLOSED.se

", 'Correct input';

done-testing;
