/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.plugins.clib.CLibImageReader;
import com.sun.media.imageioimpl.plugins.png.CLibPNGMetadata;
import com.sun.media.imageioimpl.plugins.png.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.png.Decoder;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

final class CLibPNGImageReader
extends CLibImageReader {
    private Decoder decoder;
    private HashMap imageTypes = new HashMap();

    CLibPNGImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    protected final synchronized mediaLibImage decode(InputStream stream) throws IOException {
        try {
            this.decoder = new Decoder(stream);
            this.decoder.decode();
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        mediaLibImage mlImage = null;
        try {
            mlImage = this.decoder.getImage();
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        if (mlImage == null) {
            throw new IIOException(I18N.getString("CLibPNGImageReader0"));
        }
        return mlImage;
    }

    public synchronized Iterator getImageTypes(int imageIndex) throws IOException {
        this.seekToImage(imageIndex);
        ArrayList types = null;
        Integer key = new Integer(imageIndex);
        if (this.imageTypes.containsKey(key)) {
            types = (ArrayList)this.imageTypes.get(key);
        } else {
            types = new ArrayList();
            mediaLibImage image = this.getImage(imageIndex);
            byte[] rgbPalette = null;
            try {
                rgbPalette = this.decoder.getPalette();
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
            if (rgbPalette != null) {
                int paletteLength = rgbPalette.length / 3;
                byte[] r = new byte[paletteLength];
                byte[] g = new byte[paletteLength];
                byte[] b = new byte[paletteLength];
                int j = 0;
                for (int i = 0; i < paletteLength; ++i) {
                    r[i] = rgbPalette[j++];
                    g[i] = rgbPalette[j++];
                    b[i] = rgbPalette[j++];
                }
                int[] alphaPalette = null;
                try {
                    alphaPalette = this.decoder.getTransparency();
                }
                catch (Throwable t) {
                    throw new IIOException("codecLib error", t);
                }
                byte[] a = null;
                if (alphaPalette != null) {
                    int i;
                    a = new byte[paletteLength];
                    for (i = 0; i < alphaPalette.length; ++i) {
                        a[i] = (byte)(alphaPalette[i] & 0xFF);
                    }
                    for (i = alphaPalette.length; i < paletteLength; ++i) {
                        a[i] = -1;
                    }
                }
                types.add(CLibPNGImageReader.createImageType(image, null, this.decoder.getBitDepth(), r, g, b, a));
            } else {
                byte[] iccProfileData;
                ICC_ColorSpace cs = null;
                if (this.decoder.getStandardRGB() == -1 && (iccProfileData = this.decoder.getEmbeddedICCProfile()) != null) {
                    ICC_Profile iccProfile = ICC_Profile.getInstance(iccProfileData);
                    ICC_ColorSpace icccs = new ICC_ColorSpace(iccProfile);
                    int numBands = image.getChannels();
                    if (icccs.getType() == 5 && (numBands >= 3 || rgbPalette != null) || icccs.getType() == 6 && numBands < 3 && rgbPalette == null) {
                        cs = icccs;
                    }
                }
                int bitDepth = this.decoder.getBitDepth();
                ImageTypeSpecifier type = CLibPNGImageReader.createImageType(image, cs, bitDepth, null, null, null, null);
                types.add(type);
                if (type.getColorModel().getColorSpace().equals(cs)) {
                    types.add(CLibPNGImageReader.createImageType(image, null, bitDepth, null, null, null, null));
                }
            }
            this.imageTypes.put(key, types);
        }
        return types.iterator();
    }

    protected void resetLocal() {
        this.decoder = null;
        this.imageTypes.clear();
        super.resetLocal();
    }

    public synchronized IIOMetadata getImageMetadata(int imageIndex) throws IIOException {
        if (this.input == null) {
            throw new IllegalStateException("input == null");
        }
        this.seekToImage(imageIndex);
        CLibPNGMetadata im = new CLibPNGMetadata();
        try {
            this.getImage(imageIndex);
        }
        catch (IOException e) {
            throw new IIOException("codecLib error", e);
        }
        im.readMetadata(this, this.decoder);
        return im;
    }

    void forwardWarningMessage(String warning) {
        this.processWarningOccurred(warning);
    }
}

